import _extends from "@babel/runtime/helpers/esm/extends";
import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _objectSpread from "@babel/runtime/helpers/esm/objectSpread2";
import _typeof from "@babel/runtime/helpers/esm/typeof";
import _slicedToArray from "@babel/runtime/helpers/esm/slicedToArray";
import _objectWithoutProperties from "@babel/runtime/helpers/esm/objectWithoutProperties";
var _excluded = ["prefixCls", "onPressEnter", "defaultValue", "value", "autoSize", "onResize", "className", "style", "disabled", "onChange", "onInternalAutoSize"];
import classNames from 'classnames';
import ResizeObserver from 'rc-resize-observer';
import useLayoutEffect from "rc-util/es/hooks/useLayoutEffect";
import useMergedState from "rc-util/es/hooks/useMergedState";
import raf from "rc-util/es/raf";
import * as React from 'react';
import calculateAutoSizeStyle from "./calculateNodeHeight";
var RESIZE_START = 0;
var RESIZE_MEASURING = 1;
var RESIZE_STABLE = 2;
var ResizableTextArea = /*#__PURE__*/React.forwardRef(function (props, ref) {
  var _ref = props,
      prefixCls = _ref.prefixCls,
      onPressEnter = _ref.onPressEnter,
      defaultValue = _ref.defaultValue,
      value = _ref.value,
      autoSize = _ref.autoSize,
      onResize = _ref.onResize,
      className = _ref.className,
      style = _ref.style,
      disabled = _ref.disabled,
      onChange = _ref.onChange,
      onInternalAutoSize = _ref.onInternalAutoSize,
      restProps = _objectWithoutProperties(_ref, _excluded); // =============================== Value ================================


  var _useMergedState = useMergedState(defaultValue, {
    value: value,
    postState: function postState(val) {
      return val !== null && val !== void 0 ? val : '';
    }
  }),
      _useMergedState2 = _slicedToArray(_useMergedState, 2),
      mergedValue = _useMergedState2[0],
      setMergedValue = _useMergedState2[1];

  var onInternalChange = function onInternalChange(event) {
    setMergedValue(event.target.value);
    onChange === null || onChange === void 0 ? void 0 : onChange(event);
  }; // ================================ Ref =================================


  var textareaRef = React.useRef();
  React.useImperativeHandle(ref, function () {
    return {
      textArea: textareaRef.current
    };
  }); // ============================== AutoSize ==============================

  var _React$useMemo = React.useMemo(function () {
    if (autoSize && _typeof(autoSize) === 'object') {
      return [autoSize.minRows, autoSize.maxRows];
    }

    return [];
  }, [autoSize]),
      _React$useMemo2 = _slicedToArray(_React$useMemo, 2),
      minRows = _React$useMemo2[0],
      maxRows = _React$useMemo2[1];

  var needAutoSize = !!autoSize; // =============================== Scroll ===============================
  // https://github.com/ant-design/ant-design/issues/21870

  var fixFirefoxAutoScroll = function fixFirefoxAutoScroll() {
    try {
      // FF has bug with jump of scroll to top. We force back here.
      if (document.activeElement === textareaRef.current) {
        var _textareaRef$current = textareaRef.current,
            selectionStart = _textareaRef$current.selectionStart,
            selectionEnd = _textareaRef$current.selectionEnd,
            scrollTop = _textareaRef$current.scrollTop; // Fix Safari bug which not rollback when break line
        // This makes Chinese IME can't input. Do not fix this
        // const { value: tmpValue } = textareaRef.current;
        // textareaRef.current.value = '';
        // textareaRef.current.value = tmpValue;

        textareaRef.current.setSelectionRange(selectionStart, selectionEnd);
        textareaRef.current.scrollTop = scrollTop;
      }
    } catch (e) {// Fix error in Chrome:
      // Failed to read the 'selectionStart' property from 'HTMLInputElement'
      // http://stackoverflow.com/q/21177489/3040605
    }
  }; // =============================== Resize ===============================


  var _React$useState = React.useState(RESIZE_STABLE),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      resizeState = _React$useState2[0],
      setResizeState = _React$useState2[1];

  var _React$useState3 = React.useState(),
      _React$useState4 = _slicedToArray(_React$useState3, 2),
      autoSizeStyle = _React$useState4[0],
      setAutoSizeStyle = _React$useState4[1];

  var startResize = function startResize() {
    setResizeState(RESIZE_START);

    if (process.env.NODE_ENV === 'test') {
      onInternalAutoSize === null || onInternalAutoSize === void 0 ? void 0 : onInternalAutoSize();
    }
  }; // Change to trigger resize measure


  useLayoutEffect(function () {
    if (needAutoSize) {
      startResize();
    }
  }, [value, minRows, maxRows, needAutoSize]);
  useLayoutEffect(function () {
    if (resizeState === RESIZE_START) {
      setResizeState(RESIZE_MEASURING);
    } else if (resizeState === RESIZE_MEASURING) {
      var textareaStyles = calculateAutoSizeStyle(textareaRef.current, false, minRows, maxRows); // Safari has bug that text will keep break line on text cut when it's prev is break line.
      // ZombieJ: This not often happen. So we just skip it.
      // const { selectionStart, selectionEnd, scrollTop } = textareaRef.current;
      // const { value: tmpValue } = textareaRef.current;
      // textareaRef.current.value = '';
      // textareaRef.current.value = tmpValue;
      // if (document.activeElement === textareaRef.current) {
      //   textareaRef.current.scrollTop = scrollTop;
      //   textareaRef.current.setSelectionRange(selectionStart, selectionEnd);
      // }

      setResizeState(RESIZE_STABLE);
      setAutoSizeStyle(textareaStyles);
    } else {
      fixFirefoxAutoScroll();
    }
  }, [resizeState]); // We lock resize trigger by raf to avoid Safari warning

  var resizeRafRef = React.useRef();

  var cleanRaf = function cleanRaf() {
    raf.cancel(resizeRafRef.current);
  };

  var onInternalResize = function onInternalResize(size) {
    if (resizeState === RESIZE_STABLE) {
      onResize === null || onResize === void 0 ? void 0 : onResize(size);

      if (autoSize) {
        cleanRaf();
        resizeRafRef.current = raf(function () {
          startResize();
        });
      }
    }
  };

  React.useEffect(function () {
    return cleanRaf;
  }, []); // =============================== Render ===============================

  var mergedAutoSizeStyle = needAutoSize ? autoSizeStyle : null;

  var mergedStyle = _objectSpread(_objectSpread({}, style), mergedAutoSizeStyle);

  if (resizeState === RESIZE_START || resizeState === RESIZE_MEASURING) {
    mergedStyle.overflowY = 'hidden';
    mergedStyle.overflowX = 'hidden';
  }

  return /*#__PURE__*/React.createElement(ResizeObserver, {
    onResize: onInternalResize,
    disabled: !(autoSize || onResize)
  }, /*#__PURE__*/React.createElement("textarea", _extends({}, restProps, {
    ref: textareaRef,
    style: mergedStyle,
    className: classNames(prefixCls, className, _defineProperty({}, "".concat(prefixCls, "-disabled"), disabled)),
    disabled: disabled,
    value: mergedValue,
    onChange: onInternalChange
  })));
});
export default ResizableTextArea;