import type { BaseInputProps, ShowCountProps } from 'rc-input/lib/interface';
import type React from 'react';
export interface AutoSizeType {
    minRows?: number;
    maxRows?: number;
}
export interface ResizableTextAreaRef {
    textArea: HTMLTextAreaElement;
}
export declare type HTMLTextareaProps = React.TextareaHTMLAttributes<HTMLTextAreaElement>;
export declare type TextAreaProps = Omit<HTMLTextareaProps, 'onResize'> & {
    prefixCls?: string;
    className?: string;
    style?: React.CSSProperties;
    autoSize?: boolean | AutoSizeType;
    onPressEnter?: React.KeyboardEventHandler<HTMLTextAreaElement>;
    onResize?: (size: {
        width: number;
        height: number;
    }) => void;
    showCount?: boolean | ShowCountProps;
    classes?: {
        textarea?: string;
        countWrapper?: string;
        affixWrapper?: string;
    };
} & Pick<BaseInputProps, 'allowClear' | 'suffix'>;
export declare type TextAreaRef = {
    resizableTextArea: ResizableTextAreaRef;
    focus: () => void;
    blur: () => void;
};
