"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof3 = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectSpread2 = _interopRequireDefault(require("@babel/runtime/helpers/objectSpread2"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _typeof2 = _interopRequireDefault(require("@babel/runtime/helpers/typeof"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));
var _classnames = _interopRequireDefault(require("classnames"));
var _rcInput = require("rc-input");
var _commonUtils = require("rc-input/lib/utils/commonUtils");
var _useMergedState3 = _interopRequireDefault(require("rc-util/lib/hooks/useMergedState"));
var _react = _interopRequireWildcard(require("react"));
var _ResizableTextArea = _interopRequireDefault(require("./ResizableTextArea"));
var _excluded = ["defaultValue", "value", "onFocus", "onBlur", "onChange", "allowClear", "maxLength", "onCompositionStart", "onCompositionEnd", "suffix", "prefixCls", "classes", "showCount", "className", "style", "disabled", "hidden", "classNames", "styles", "onResize"];
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof3(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function fixEmojiLength(value, maxLength) {
  return (0, _toConsumableArray2.default)(value || '').slice(0, maxLength).join('');
}
function setTriggerValue(isCursorInEnd, preValue, triggerValue, maxLength) {
  var newTriggerValue = triggerValue;
  if (isCursorInEnd) {
    // 光标在尾部，直接截断
    newTriggerValue = fixEmojiLength(triggerValue, maxLength);
  } else if ((0, _toConsumableArray2.default)(preValue || '').length < triggerValue.length && (0, _toConsumableArray2.default)(triggerValue || '').length > maxLength) {
    // 光标在中间，如果最后的值超过最大值，则采用原先的值
    newTriggerValue = preValue;
  }
  return newTriggerValue;
}
var TextArea = /*#__PURE__*/_react.default.forwardRef(function (_ref, ref) {
  var _clsx;
  var defaultValue = _ref.defaultValue,
    customValue = _ref.value,
    onFocus = _ref.onFocus,
    onBlur = _ref.onBlur,
    onChange = _ref.onChange,
    allowClear = _ref.allowClear,
    maxLength = _ref.maxLength,
    onCompositionStart = _ref.onCompositionStart,
    onCompositionEnd = _ref.onCompositionEnd,
    suffix = _ref.suffix,
    _ref$prefixCls = _ref.prefixCls,
    prefixCls = _ref$prefixCls === void 0 ? 'rc-textarea' : _ref$prefixCls,
    classes = _ref.classes,
    showCount = _ref.showCount,
    className = _ref.className,
    style = _ref.style,
    disabled = _ref.disabled,
    hidden = _ref.hidden,
    classNames = _ref.classNames,
    styles = _ref.styles,
    onResize = _ref.onResize,
    rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var _useMergedState = (0, _useMergedState3.default)(defaultValue, {
      value: customValue,
      defaultValue: defaultValue
    }),
    _useMergedState2 = (0, _slicedToArray2.default)(_useMergedState, 2),
    value = _useMergedState2[0],
    setValue = _useMergedState2[1];
  var resizableTextAreaRef = (0, _react.useRef)(null);
  var _React$useState = _react.default.useState(false),
    _React$useState2 = (0, _slicedToArray2.default)(_React$useState, 2),
    focused = _React$useState2[0],
    setFocused = _React$useState2[1];
  var _React$useState3 = _react.default.useState(false),
    _React$useState4 = (0, _slicedToArray2.default)(_React$useState3, 2),
    compositing = _React$useState4[0],
    setCompositing = _React$useState4[1];
  var oldCompositionValueRef = _react.default.useRef();
  var oldSelectionStartRef = _react.default.useRef(0);
  // Since ResizeObserver would resize once on mounted, manual resizing should be happened after that
  var _React$useState5 = _react.default.useState(null),
    _React$useState6 = (0, _slicedToArray2.default)(_React$useState5, 2),
    resizeStatus = _React$useState6[0],
    setResizeStatus = _React$useState6[1];
  var focus = function focus() {
    resizableTextAreaRef.current.textArea.focus();
  };
  (0, _react.useImperativeHandle)(ref, function () {
    return {
      resizableTextArea: resizableTextAreaRef.current,
      focus: focus,
      blur: function blur() {
        resizableTextAreaRef.current.textArea.blur();
      }
    };
  });
  (0, _react.useEffect)(function () {
    setFocused(function (prev) {
      return !disabled && prev;
    });
  }, [disabled]);

  // =========================== Value Update ===========================
  // Max length value
  var hasMaxLength = Number(maxLength) > 0;
  var onInternalCompositionStart = function onInternalCompositionStart(e) {
    setCompositing(true);
    // 拼音输入前保存一份旧值
    oldCompositionValueRef.current = value;
    // 保存旧的光标位置
    oldSelectionStartRef.current = e.currentTarget.selectionStart;
    onCompositionStart === null || onCompositionStart === void 0 ? void 0 : onCompositionStart(e);
  };
  var onInternalCompositionEnd = function onInternalCompositionEnd(e) {
    setCompositing(false);
    var triggerValue = e.currentTarget.value;
    if (hasMaxLength) {
      var _oldCompositionValueR;
      var isCursorInEnd = oldSelectionStartRef.current >= maxLength + 1 || oldSelectionStartRef.current === ((_oldCompositionValueR = oldCompositionValueRef.current) === null || _oldCompositionValueR === void 0 ? void 0 : _oldCompositionValueR.length);
      triggerValue = setTriggerValue(isCursorInEnd, oldCompositionValueRef.current, triggerValue, maxLength);
    }
    // Patch composition onChange when value changed
    if (triggerValue !== value) {
      setValue(triggerValue);
      (0, _commonUtils.resolveOnChange)(e.currentTarget, e, onChange, triggerValue);
    }
    onCompositionEnd === null || onCompositionEnd === void 0 ? void 0 : onCompositionEnd(e);
  };
  var handleChange = function handleChange(e) {
    var triggerValue = e.target.value;
    if (!compositing && hasMaxLength) {
      // 1. 复制粘贴超过maxlength的情况 2.未超过maxlength的情况
      var isCursorInEnd = e.target.selectionStart >= maxLength + 1 || e.target.selectionStart === triggerValue.length || !e.target.selectionStart;
      triggerValue = setTriggerValue(isCursorInEnd, value, triggerValue, maxLength);
    }
    setValue(triggerValue);
    (0, _commonUtils.resolveOnChange)(e.currentTarget, e, onChange, triggerValue);
  };
  var handleKeyDown = function handleKeyDown(e) {
    var onPressEnter = rest.onPressEnter,
      onKeyDown = rest.onKeyDown;
    if (e.key === 'Enter' && onPressEnter) {
      onPressEnter(e);
    }
    onKeyDown === null || onKeyDown === void 0 ? void 0 : onKeyDown(e);
  };
  var handleFocus = function handleFocus(e) {
    setFocused(true);
    onFocus === null || onFocus === void 0 ? void 0 : onFocus(e);
  };
  var handleBlur = function handleBlur(e) {
    setFocused(false);
    onBlur === null || onBlur === void 0 ? void 0 : onBlur(e);
  };

  // ============================== Reset ===============================
  var handleReset = function handleReset(e) {
    setValue('');
    focus();
    (0, _commonUtils.resolveOnChange)(resizableTextAreaRef.current.textArea, e, onChange);
  };
  var val = (0, _commonUtils.fixControlledValue)(value);
  if (!compositing && hasMaxLength && (customValue === null || customValue === undefined)) {
    // fix #27612 将value转为数组进行截取，解决 '😂'.length === 2 等emoji表情导致的截取乱码的问题
    val = fixEmojiLength(val, maxLength);
  }
  var suffixNode = suffix;
  var dataCount;
  if (showCount) {
    var valueLength = (0, _toConsumableArray2.default)(val).length;
    if ((0, _typeof2.default)(showCount) === 'object') {
      dataCount = showCount.formatter({
        value: val,
        count: valueLength,
        maxLength: maxLength
      });
    } else {
      dataCount = "".concat(valueLength).concat(hasMaxLength ? " / ".concat(maxLength) : '');
    }
    suffixNode = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, suffixNode, /*#__PURE__*/_react.default.createElement("span", {
      className: (0, _classnames.default)("".concat(prefixCls, "-data-count"), classNames === null || classNames === void 0 ? void 0 : classNames.count),
      style: styles === null || styles === void 0 ? void 0 : styles.count
    }, dataCount));
  }
  var handleResize = function handleResize(size) {
    onResize === null || onResize === void 0 ? void 0 : onResize(size);
    if (resizeStatus === null) {
      setResizeStatus('mounted');
    } else if (resizeStatus === 'mounted') {
      setResizeStatus('resized');
    }
  };
  var textarea = /*#__PURE__*/_react.default.createElement(_rcInput.BaseInput, {
    value: val,
    allowClear: allowClear,
    handleReset: handleReset,
    suffix: suffixNode,
    prefixCls: prefixCls,
    classes: {
      affixWrapper: (0, _classnames.default)(classes === null || classes === void 0 ? void 0 : classes.affixWrapper, (_clsx = {}, (0, _defineProperty2.default)(_clsx, "".concat(prefixCls, "-show-count"), showCount), (0, _defineProperty2.default)(_clsx, "".concat(prefixCls, "-textarea-allow-clear"), allowClear), _clsx))
    },
    disabled: disabled,
    focused: focused,
    className: className,
    style: (0, _objectSpread2.default)((0, _objectSpread2.default)({}, style), resizeStatus === 'resized' ? {
      height: 'auto'
    } : {}),
    dataAttrs: {
      affixWrapper: {
        'data-count': typeof dataCount === 'string' ? dataCount : undefined
      }
    },
    hidden: hidden,
    inputElement: /*#__PURE__*/_react.default.createElement(_ResizableTextArea.default, (0, _extends2.default)({}, rest, {
      onKeyDown: handleKeyDown,
      onChange: handleChange,
      onFocus: handleFocus,
      onBlur: handleBlur,
      onCompositionStart: onInternalCompositionStart,
      onCompositionEnd: onInternalCompositionEnd,
      className: classNames === null || classNames === void 0 ? void 0 : classNames.textarea,
      style: (0, _objectSpread2.default)((0, _objectSpread2.default)({}, styles === null || styles === void 0 ? void 0 : styles.textarea), {}, {
        resize: style === null || style === void 0 ? void 0 : style.resize
      }),
      disabled: disabled,
      prefixCls: prefixCls,
      onResize: handleResize,
      ref: resizableTextAreaRef
    }))
  });
  return textarea;
});
var _default = TextArea;
exports.default = _default;