'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _Select = require('./Select');

var _Select2 = _interopRequireDefault(_Select);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var formatOption = function formatOption(option, disabledOptions) {
  var value = '' + option;
  if (option < 10) {
    value = '0' + option;
  }

  var disabled = false;
  if (disabledOptions && disabledOptions.indexOf(option) >= 0) {
    disabled = true;
  }

  return {
    value: value,
    disabled: disabled
  };
};

var Combobox = _react2["default"].createClass({
  displayName: 'Combobox',

  propTypes: {
    format: _react.PropTypes.string,
    defaultOpenValue: _react.PropTypes.object,
    prefixCls: _react.PropTypes.string,
    value: _react.PropTypes.object,
    onChange: _react.PropTypes.func,
    showHour: _react.PropTypes.bool,
    showMinute: _react.PropTypes.bool,
    showSecond: _react.PropTypes.bool,
    hourOptions: _react.PropTypes.array,
    minuteOptions: _react.PropTypes.array,
    secondOptions: _react.PropTypes.array,
    disabledHours: _react.PropTypes.func,
    disabledMinutes: _react.PropTypes.func,
    disabledSeconds: _react.PropTypes.func,
    onCurrentSelectPanelChange: _react.PropTypes.func,
    use12Hours: _react.PropTypes.bool
  },

  onItemChange: function onItemChange(type, itemValue) {
    var _props = this.props,
        onChange = _props.onChange,
        defaultOpenValue = _props.defaultOpenValue,
        use12Hours = _props.use12Hours;

    var value = (this.props.value || defaultOpenValue).clone();

    if (type === 'hour') {
      if (use12Hours) {
        if (this.isAM()) {
          value.hour(+itemValue % 12);
        } else {
          value.hour(+itemValue % 12 + 12);
        }
      } else {
        value.hour(+itemValue);
      }
    } else if (type === 'minute') {
      value.minute(+itemValue);
    } else if (type === 'ampm') {
      var ampm = itemValue.toUpperCase();
      if (use12Hours) {
        if (ampm === 'PM' && value.hour() < 12) {
          value.hour(value.hour() % 12 + 12);
        }

        if (ampm === 'AM') {
          if (value.hour() >= 12) {
            value.hour(value.hour() - 12);
          }
        }
      }
    } else {
      value.second(+itemValue);
    }
    onChange(value);
  },
  onEnterSelectPanel: function onEnterSelectPanel(range) {
    this.props.onCurrentSelectPanelChange(range);
  },
  getHourSelect: function getHourSelect(hour) {
    var _props2 = this.props,
        prefixCls = _props2.prefixCls,
        hourOptions = _props2.hourOptions,
        disabledHours = _props2.disabledHours,
        showHour = _props2.showHour,
        use12Hours = _props2.use12Hours;

    if (!showHour) {
      return null;
    }
    var disabledOptions = disabledHours();
    var hourOptionsAdj = void 0;
    var hourAdj = void 0;
    if (use12Hours) {
      hourOptionsAdj = [12].concat(hourOptions.filter(function (h) {
        return h < 12 && h > 0;
      }));
      hourAdj = hour % 12 || 12;
    } else {
      hourOptionsAdj = hourOptions;
      hourAdj = hour;
    }

    return _react2["default"].createElement(_Select2["default"], {
      prefixCls: prefixCls,
      options: hourOptionsAdj.map(function (option) {
        return formatOption(option, disabledOptions);
      }),
      selectedIndex: hourOptionsAdj.indexOf(hourAdj),
      type: 'hour',
      onSelect: this.onItemChange,
      onMouseEnter: this.onEnterSelectPanel.bind(this, 'hour')
    });
  },
  getMinuteSelect: function getMinuteSelect(minute) {
    var _props3 = this.props,
        prefixCls = _props3.prefixCls,
        minuteOptions = _props3.minuteOptions,
        disabledMinutes = _props3.disabledMinutes,
        defaultOpenValue = _props3.defaultOpenValue,
        showMinute = _props3.showMinute;

    if (!showMinute) {
      return null;
    }
    var value = this.props.value || defaultOpenValue;
    var disabledOptions = disabledMinutes(value.hour());

    return _react2["default"].createElement(_Select2["default"], {
      prefixCls: prefixCls,
      options: minuteOptions.map(function (option) {
        return formatOption(option, disabledOptions);
      }),
      selectedIndex: minuteOptions.indexOf(minute),
      type: 'minute',
      onSelect: this.onItemChange,
      onMouseEnter: this.onEnterSelectPanel.bind(this, 'minute')
    });
  },
  getSecondSelect: function getSecondSelect(second) {
    var _props4 = this.props,
        prefixCls = _props4.prefixCls,
        secondOptions = _props4.secondOptions,
        disabledSeconds = _props4.disabledSeconds,
        showSecond = _props4.showSecond,
        defaultOpenValue = _props4.defaultOpenValue;

    if (!showSecond) {
      return null;
    }
    var value = this.props.value || defaultOpenValue;
    var disabledOptions = disabledSeconds(value.hour(), value.minute());

    return _react2["default"].createElement(_Select2["default"], {
      prefixCls: prefixCls,
      options: secondOptions.map(function (option) {
        return formatOption(option, disabledOptions);
      }),
      selectedIndex: secondOptions.indexOf(second),
      type: 'second',
      onSelect: this.onItemChange,
      onMouseEnter: this.onEnterSelectPanel.bind(this, 'second')
    });
  },
  getAMPMSelect: function getAMPMSelect() {
    var _props5 = this.props,
        prefixCls = _props5.prefixCls,
        use12Hours = _props5.use12Hours,
        format = _props5.format;

    if (!use12Hours) {
      return null;
    }

    var AMPMOptions = ['am', 'pm'] // If format has A char, then we should uppercase AM/PM
    .map(function (c) {
      return format.match(/\sA/) ? c.toUpperCase() : c;
    }).map(function (c) {
      return { value: c };
    });

    var selected = this.isAM() ? 0 : 1;

    return _react2["default"].createElement(_Select2["default"], {
      prefixCls: prefixCls,
      options: AMPMOptions,
      selectedIndex: selected,
      type: 'ampm',
      onSelect: this.onItemChange,
      onMouseEnter: this.onEnterSelectPanel.bind(this, 'ampm')
    });
  },
  isAM: function isAM() {
    var value = this.props.value || this.props.defaultOpenValue;
    return value.hour() >= 0 && value.hour() < 12;
  },
  render: function render() {
    var _props6 = this.props,
        prefixCls = _props6.prefixCls,
        defaultOpenValue = _props6.defaultOpenValue;

    var value = this.props.value || defaultOpenValue;
    return _react2["default"].createElement(
      'div',
      { className: prefixCls + '-combobox' },
      this.getHourSelect(value.hour()),
      this.getMinuteSelect(value.minute()),
      this.getSecondSelect(value.second()),
      this.getAMPMSelect(value.hour())
    );
  }
});

exports["default"] = Combobox;
module.exports = exports['default'];