'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _defineProperty2 = require('babel-runtime/helpers/defineProperty');

var _defineProperty3 = _interopRequireDefault(_defineProperty2);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactDom = require('react-dom');

var _reactDom2 = _interopRequireDefault(_reactDom);

var _classnames3 = require('classnames');

var _classnames4 = _interopRequireDefault(_classnames3);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var scrollTo = function scrollTo(element, to, duration) {
  var requestAnimationFrame = window.requestAnimationFrame || function requestAnimationFrameTimeout() {
    return setTimeout(arguments[0], 10);
  };
  // jump to target if duration zero
  if (duration <= 0) {
    element.scrollTop = to;
    return;
  }
  var difference = to - element.scrollTop;
  var perTick = difference / duration * 10;

  requestAnimationFrame(function () {
    element.scrollTop = element.scrollTop + perTick;
    if (element.scrollTop === to) return;
    scrollTo(element, to, duration - 10);
  });
};

var Select = _react2["default"].createClass({
  displayName: 'Select',

  propTypes: {
    prefixCls: _react.PropTypes.string,
    options: _react.PropTypes.array,
    selectedIndex: _react.PropTypes.number,
    type: _react.PropTypes.string,
    onSelect: _react.PropTypes.func,
    onMouseEnter: _react.PropTypes.func
  },

  getInitialState: function getInitialState() {
    return {
      active: false
    };
  },
  componentDidMount: function componentDidMount() {
    // jump to selected option
    this.scrollToSelected(0);
  },
  componentDidUpdate: function componentDidUpdate(prevProps) {
    // smooth scroll to selected option
    if (prevProps.selectedIndex !== this.props.selectedIndex) {
      this.scrollToSelected(120);
    }
  },
  onSelect: function onSelect(value) {
    var _props = this.props,
        onSelect = _props.onSelect,
        type = _props.type;

    onSelect(type, value);
  },
  getOptions: function getOptions() {
    var _this = this;

    var _props2 = this.props,
        options = _props2.options,
        selectedIndex = _props2.selectedIndex,
        prefixCls = _props2.prefixCls;

    return options.map(function (item, index) {
      var _classnames;

      var cls = (0, _classnames4["default"])((_classnames = {}, (0, _defineProperty3["default"])(_classnames, prefixCls + '-select-option-selected', selectedIndex === index), (0, _defineProperty3["default"])(_classnames, prefixCls + '-select-option-disabled', item.disabled), _classnames));
      var onclick = null;
      if (!item.disabled) {
        onclick = _this.onSelect.bind(_this, item.value);
      }
      return _react2["default"].createElement(
        'li',
        {
          className: cls,
          key: index,
          onClick: onclick,
          disabled: item.disabled
        },
        item.value
      );
    });
  },
  scrollToSelected: function scrollToSelected(duration) {
    // move to selected item
    var select = _reactDom2["default"].findDOMNode(this);
    var list = _reactDom2["default"].findDOMNode(this.refs.list);
    if (!list) {
      return;
    }
    var index = this.props.selectedIndex;
    if (index < 0) {
      index = 0;
    }
    var topOption = list.children[index];
    var to = topOption.offsetTop;
    scrollTo(select, to, duration);
  },
  handleMouseEnter: function handleMouseEnter(e) {
    this.setState({ active: true });
    this.props.onMouseEnter(e);
  },
  handleMouseLeave: function handleMouseLeave() {
    this.setState({ active: false });
  },
  render: function render() {
    var _classnames2;

    if (this.props.options.length === 0) {
      return null;
    }

    var prefixCls = this.props.prefixCls;

    var cls = (0, _classnames4["default"])((_classnames2 = {}, (0, _defineProperty3["default"])(_classnames2, prefixCls + '-select', 1), (0, _defineProperty3["default"])(_classnames2, prefixCls + '-select-active', this.state.active), _classnames2));

    return _react2["default"].createElement(
      'div',
      {
        className: cls,
        onMouseEnter: this.handleMouseEnter,
        onMouseLeave: this.handleMouseLeave
      },
      _react2["default"].createElement(
        'ul',
        { ref: 'list' },
        this.getOptions()
      )
    );
  }
});

exports["default"] = Select;
module.exports = exports['default'];