import * as React from 'react';
import type { TriggerProps } from 'rc-trigger';
import type { AlignType, AnimationType, ActionType } from 'rc-trigger/lib/interface';
export interface TooltipProps extends Pick<TriggerProps, 'onPopupAlign' | 'builtinPlacements'> {
    trigger?: ActionType | ActionType[];
    defaultVisible?: boolean;
    visible?: boolean;
    placement?: string;
    /** @deprecated Use `motion` instead */
    transitionName?: string;
    /** @deprecated Use `motion` instead */
    animation?: AnimationType;
    /** Config popup motion */
    motion?: TriggerProps['popupMotion'];
    onVisibleChange?: (visible: boolean) => void;
    afterVisibleChange?: (visible: boolean) => void;
    overlay: (() => React.ReactNode) | React.ReactNode;
    overlayStyle?: React.CSSProperties;
    overlayClassName?: string;
    prefixCls?: string;
    mouseEnterDelay?: number;
    mouseLeaveDelay?: number;
    getTooltipContainer?: (node: HTMLElement) => HTMLElement;
    destroyTooltipOnHide?: boolean | {
        keepParent?: boolean;
    };
    align?: AlignType;
    showArrow?: boolean;
    arrowContent?: React.ReactNode;
    id?: string;
    children?: React.ReactElement;
    popupVisible?: boolean;
    overlayInnerStyle?: React.CSSProperties;
    zIndex?: number;
}
declare const _default: React.ForwardRefExoticComponent<TooltipProps & React.RefAttributes<unknown>>;
export default _default;
