import * as React from 'react';
import { TreeNodeProps } from './TreeNode';
import { FlattenNode } from './interface';
import { TreeNodeRequiredProps } from './utils/treeUtil';
interface MotionTreeNodeProps extends Omit<TreeNodeProps, 'domRef'> {
    motion?: any;
    motionNodes?: FlattenNode[];
    onMotionEnd: () => void;
    motionType?: 'show' | 'hide';
    treeNodeRequiredProps: TreeNodeRequiredProps;
}
declare const RefMotionTreeNode: React.ForwardRefExoticComponent<MotionTreeNodeProps & React.RefAttributes<unknown>>;
export default RefMotionTreeNode;
