/**
 * Legacy code. Should avoid to use if you are new to import these code.
 */
import React from 'react';
import { TreeNodeProps } from './TreeNode';
import { NodeElement, Key, DataNode, DataEntity } from './interface';
import { TreeProps } from './Tree';
export declare function arrDel(list: Key[], value: Key): (string | number)[];
export declare function arrAdd(list: Key[], value: Key): (string | number)[];
export declare function posToArr(pos: string): string[];
export declare function getPosition(level: string | number, index: number): string;
export declare function isTreeNode(node: NodeElement): boolean;
export declare function isCheckDisabled(node: DataNode): boolean;
export declare function getDragNodesKeys(dragNodeKey: Key, keyEntities: Record<Key, DataEntity>): Key[];
export declare function calcDropPosition(event: React.MouseEvent, treeNode: NodeElement): 1 | 0 | -1;
/**
 * Return selectedKeys according with multiple prop
 * @param selectedKeys
 * @param props
 * @returns [string]
 */
export declare function calcSelectedKeys(selectedKeys: Key[], props: TreeProps): (string | number)[];
export declare function convertDataToTree(treeData: DataNode[], processor?: {
    processProps: (prop: DataNode) => any;
}): NodeElement[];
/**
 * Parse `checkedKeys` to { checkedKeys, halfCheckedKeys } style
 */
export declare function parseCheckedKeys(keys: Key[] | {
    checked: Key[];
    halfChecked: Key[];
}): any;
/**
 * Conduct check state by the keyList. It will conduct up & from the provided key.
 * If the conduct path reach the disabled or already checked / unchecked node will stop conduct.
 */
export declare function conductCheck(
/** list of keys */
keyList: Key[], 
/** is check the node or not */
isCheck: boolean, 
/** parsed by `convertTreeToEntities` function in Tree */
keyEntities: Record<Key, DataEntity>, 
/** Can pass current checked status for process (usually for uncheck operation) */
checkStatus?: {
    checkedKeys?: Key[];
    halfCheckedKeys?: Key[];
}): {
    checkedKeys: any[];
    halfCheckedKeys: any[];
};
/**
 * If user use `autoExpandParent` we should get the list of parent node
 * @param keyList
 * @param keyEntities
 */
export declare function conductExpandParent(keyList: Key[], keyEntities: Record<Key, DataEntity>): string[];
/**
 * Returns only the data- and aria- key/value pairs
 */
export declare function getDataAndAria(props: Partial<TreeProps | TreeNodeProps>): Record<string, string>;
