/**
 * Handle virtual list of the TreeNodes.
 */
import * as React from 'react';
import { FlattenNode, Key, DataEntity } from './interface';
export declare const MOTION_KEY: string;
export declare const MotionEntity: DataEntity;
interface NodeListProps {
    prefixCls: string;
    className: string;
    style: React.CSSProperties;
    data: FlattenNode[];
    motion: any;
    expandedKeys: Key[];
    selectedKeys: Key[];
    checkedKeys: Key[];
    loadedKeys: Key[];
    loadingKeys: Key[];
    halfCheckedKeys: Key[];
    keyEntities: Record<Key, DataEntity>;
    dragging: boolean;
    dragOverNodeKey: Key;
    dropPosition: number;
    height: number;
    itemHeight: number;
}
/**
 * We only need get visible content items to play the animation.
 */
export declare function getMinimumRangeTransitionRange(list: FlattenNode[], height: number, itemHeight: number): FlattenNode[];
declare const NodeList: React.FC<NodeListProps>;
export default NodeList;
