"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMinimumRangeTransitionRange = getMinimumRangeTransitionRange;
exports.default = exports.MotionEntity = exports.MOTION_KEY = void 0;

var React = _interopRequireWildcard(require("react"));

var _rcVirtualList = _interopRequireDefault(require("rc-virtual-list"));

var _MotionTreeNode = _interopRequireDefault(require("./MotionTreeNode"));

var _diffUtil = require("./utils/diffUtil");

var _treeUtil = require("./utils/treeUtil");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance"); }

function _iterableToArrayLimit(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var MOTION_KEY = "RC_TREE_MOTION_".concat(Math.random());
exports.MOTION_KEY = MOTION_KEY;
var MotionNode = {
  key: MOTION_KEY
};
var MotionEntity = {
  key: MOTION_KEY,
  level: 0,
  index: 0,
  pos: '0',
  node: MotionNode
};
exports.MotionEntity = MotionEntity;
var MotionFlattenData = {
  parent: null,
  children: [],
  pos: MotionEntity.pos,
  data: MotionNode,

  /** Hold empty list here since we do not use it */
  isStart: [],
  isEnd: []
};
/**
 * We only need get visible content items to play the animation.
 */

function getMinimumRangeTransitionRange(list, height, itemHeight) {
  if (!height) {
    return list;
  }

  return list.slice(0, Math.ceil(height / itemHeight) + 1);
}

function itemKey(item) {
  var key = item.data.key,
      pos = item.pos;
  return (0, _treeUtil.getKey)(key, pos);
}

var NodeList = function NodeList(_ref) {
  var prefixCls = _ref.prefixCls,
      data = _ref.data,
      expandedKeys = _ref.expandedKeys,
      selectedKeys = _ref.selectedKeys,
      checkedKeys = _ref.checkedKeys,
      loadedKeys = _ref.loadedKeys,
      loadingKeys = _ref.loadingKeys,
      halfCheckedKeys = _ref.halfCheckedKeys,
      keyEntities = _ref.keyEntities,
      dragging = _ref.dragging,
      dragOverNodeKey = _ref.dragOverNodeKey,
      dropPosition = _ref.dropPosition,
      motion = _ref.motion,
      height = _ref.height,
      itemHeight = _ref.itemHeight,
      domProps = _objectWithoutProperties(_ref, ["prefixCls", "data", "expandedKeys", "selectedKeys", "checkedKeys", "loadedKeys", "loadingKeys", "halfCheckedKeys", "keyEntities", "dragging", "dragOverNodeKey", "dropPosition", "motion", "height", "itemHeight"]);

  var _React$useState = React.useState(false),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      disableVirtual = _React$useState2[0],
      setDisableVirtual = _React$useState2[1];

  var _React$useState3 = React.useState(expandedKeys),
      _React$useState4 = _slicedToArray(_React$useState3, 2),
      prevExpandedKeys = _React$useState4[0],
      setPrevExpandedKeys = _React$useState4[1];

  var _React$useState5 = React.useState(data),
      _React$useState6 = _slicedToArray(_React$useState5, 2),
      prevData = _React$useState6[0],
      setPrevData = _React$useState6[1];

  var _React$useState7 = React.useState(data),
      _React$useState8 = _slicedToArray(_React$useState7, 2),
      transitionData = _React$useState8[0],
      setTransitionData = _React$useState8[1];

  var _React$useState9 = React.useState([]),
      _React$useState10 = _slicedToArray(_React$useState9, 2),
      transitionRange = _React$useState10[0],
      setTransitionRange = _React$useState10[1];

  var _React$useState11 = React.useState(null),
      _React$useState12 = _slicedToArray(_React$useState11, 2),
      motionType = _React$useState12[0],
      setMotionType = _React$useState12[1];

  function onMotionEnd() {
    setPrevData(data);
    setTransitionData(data);
    setTransitionRange([]);
    setMotionType(null);
    setDisableVirtual(false);
  } // Do animation if expanded keys changed


  React.useEffect(function () {
    setPrevExpandedKeys(expandedKeys);
    var diffExpanded = (0, _diffUtil.findExpandedKeys)(prevExpandedKeys, expandedKeys);

    if (diffExpanded.key !== null) {
      if (diffExpanded.add) {
        var keyIndex = prevData.findIndex(function (_ref2) {
          var key = _ref2.data.key;
          return key === diffExpanded.key;
        });
        if (motion) setDisableVirtual(true);
        var rangeNodes = getMinimumRangeTransitionRange((0, _diffUtil.getExpandRange)(prevData, data, diffExpanded.key), height, itemHeight);
        var newTransitionData = prevData.slice();
        newTransitionData.splice(keyIndex + 1, 0, MotionFlattenData);
        setTransitionData(newTransitionData);
        setTransitionRange(rangeNodes);
        setMotionType('show');
      } else {
        var _keyIndex = data.findIndex(function (_ref3) {
          var key = _ref3.data.key;
          return key === diffExpanded.key;
        });

        if (motion) setDisableVirtual(true);

        var _rangeNodes = getMinimumRangeTransitionRange((0, _diffUtil.getExpandRange)(data, prevData, diffExpanded.key), height, itemHeight);

        var _newTransitionData = data.slice();

        _newTransitionData.splice(_keyIndex + 1, 0, MotionFlattenData);

        setTransitionData(_newTransitionData);
        setTransitionRange(_rangeNodes);
        setMotionType('hide');
      }
    } else if (prevData !== data) {
      // If whole data changed, we just refresh the list
      setPrevData(data);
      setTransitionData(data);
    }
  }, [expandedKeys, data]); // We should clean up motion if is changed by dragging

  React.useEffect(function () {
    if (!dragging) {
      onMotionEnd();
    }
  }, [dragging]);
  var mergedData = motion ? transitionData : data;
  var treeNodeRequiredProps = {
    expandedKeys: expandedKeys,
    selectedKeys: selectedKeys,
    loadedKeys: loadedKeys,
    loadingKeys: loadingKeys,
    checkedKeys: checkedKeys,
    halfCheckedKeys: halfCheckedKeys,
    dragOverNodeKey: dragOverNodeKey,
    dropPosition: dropPosition,
    keyEntities: keyEntities
  };
  return React.createElement(_rcVirtualList.default, Object.assign({}, domProps, {
    disabled: disableVirtual,
    role: "tree",
    data: mergedData,
    itemKey: itemKey,
    height: height,
    itemHeight: itemHeight,
    onSkipRender: onMotionEnd,
    prefixCls: "".concat(prefixCls, "-list")
  }), function (treeNode) {
    var pos = treeNode.pos,
        _treeNode$data = treeNode.data,
        key = _treeNode$data.key,
        restProps = _objectWithoutProperties(_treeNode$data, ["key"]),
        isStart = treeNode.isStart,
        isEnd = treeNode.isEnd;

    var mergedKey = (0, _treeUtil.getKey)(key, pos);
    delete restProps.children;
    var treeNodeProps = (0, _treeUtil.getTreeNodeProps)(mergedKey, treeNodeRequiredProps);
    return React.createElement(_MotionTreeNode.default, Object.assign({}, restProps, treeNodeProps, {
      pos: pos,
      data: treeNode.data,
      isStart: isStart,
      isEnd: isEnd,
      motion: motion,
      motionNodes: key === MOTION_KEY ? transitionRange : null,
      motionType: motionType,
      onMotionEnd: onMotionEnd,
      treeNodeRequiredProps: treeNodeRequiredProps
    }));
  });
};

var _default = NodeList;
exports.default = _default;