import * as React from 'react';
import PropTypes from 'prop-types';
import { DataNode, IconType, Key, FlattenNode, DataEntity, NodeInstance } from './interface';
interface CheckInfo {
    event: 'check';
    node: NodeInstance;
    checked: boolean;
    nativeEvent: MouseEvent;
    checkedNodes: DataNode[];
    checkedNodesPositions?: {
        node: DataNode;
        pos: string;
    }[];
    halfCheckedKeys?: Key[];
}
export interface TreeProps {
    prefixCls: string;
    className?: string;
    style?: React.CSSProperties;
    tabIndex?: number;
    children?: React.ReactNode;
    treeData?: DataNode[];
    showLine?: boolean;
    showIcon?: boolean;
    icon?: IconType;
    focusable?: boolean;
    selectable?: boolean;
    disabled?: boolean;
    multiple?: boolean;
    checkable?: boolean | React.ReactNode;
    checkStrictly?: boolean;
    draggable?: boolean;
    defaultExpandParent?: boolean;
    autoExpandParent?: boolean;
    defaultExpandAll?: boolean;
    defaultExpandedKeys?: Key[];
    expandedKeys?: Key[];
    defaultCheckedKeys?: Key[];
    checkedKeys: (Key)[] | {
        checked: (Key)[];
        halfChecked: Key[];
    };
    defaultSelectedKeys: Key[];
    selectedKeys: Key[];
    onClick: (e: React.MouseEvent, treeNode: DataNode) => void;
    onDoubleClick: (e: React.MouseEvent, treeNode: DataNode) => void;
    onExpand: (expandedKeys: Key[], info: {
        node: NodeInstance;
        expanded: boolean;
        nativeEvent: MouseEvent;
    }) => void;
    onCheck: (checked: {
        checked: Key[];
        halfChecked: Key[];
    } | Key[], info: CheckInfo) => void;
    onSelect: (selectedKeys: Key[], info: {
        event: 'select';
        selected: boolean;
        node: NodeInstance;
        selectedNodes: DataNode[];
        nativeEvent: MouseEvent;
    }) => void;
    onLoad: (loadedKeys: Key[], info: {
        event: 'load';
        node: NodeInstance;
    }) => void;
    loadData: (treeNode: NodeInstance) => Promise<void>;
    loadedKeys: Key[];
    onMouseEnter: (info: {
        event: React.MouseEvent;
        node: NodeInstance;
    }) => void;
    onMouseLeave: (info: {
        event: React.MouseEvent;
        node: NodeInstance;
    }) => void;
    onRightClick: (info: {
        event: React.MouseEvent;
        node: NodeInstance;
    }) => void;
    onDragStart: (info: {
        event: React.MouseEvent;
        node: NodeInstance;
    }) => void;
    onDragEnter: (info: {
        event: React.MouseEvent;
        node: NodeInstance;
        expandedKeys: Key[];
    }) => void;
    onDragOver: (info: {
        event: React.MouseEvent;
        node: NodeInstance;
    }) => void;
    onDragLeave: (info: {
        event: React.MouseEvent;
        node: NodeInstance;
    }) => void;
    onDragEnd: (info: {
        event: React.MouseEvent;
        node: NodeInstance;
    }) => void;
    onDrop: (info: {
        event: React.MouseEvent;
        node: NodeInstance;
        dragNode: NodeInstance;
        dragNodesKeys: Key[];
        dropPosition: number;
        dropToGap: boolean;
    }) => void;
    filterTreeNode: (treeNode: NodeInstance) => boolean;
    motion: any;
    switcherIcon: IconType;
    height: number;
    itemHeight: number;
}
interface TreeState {
    keyEntities: Record<Key, DataEntity>;
    selectedKeys: Key[];
    checkedKeys: Key[];
    halfCheckedKeys: Key[];
    loadedKeys: Key[];
    loadingKeys: Key[];
    expandedKeys: Key[];
    dragging: boolean;
    dragNodesKeys: Key[];
    dragOverNodeKey: Key;
    dropPosition: number;
    treeData: DataNode[];
    flattenNodes: FlattenNode[];
    prevProps: TreeProps;
}
declare class Tree extends React.Component<TreeProps, TreeState> {
    static propTypes: {
        prefixCls: PropTypes.Requireable<string>;
        className: PropTypes.Requireable<string>;
        style: PropTypes.Requireable<object>;
        tabIndex: PropTypes.Requireable<string | number>;
        children: PropTypes.Requireable<any>;
        treeData: PropTypes.Requireable<any[]>;
        showLine: PropTypes.Requireable<boolean>;
        showIcon: PropTypes.Requireable<boolean>;
        icon: PropTypes.Requireable<PropTypes.ReactNodeLike>;
        focusable: PropTypes.Requireable<boolean>;
        selectable: PropTypes.Requireable<boolean>;
        disabled: PropTypes.Requireable<boolean>;
        multiple: PropTypes.Requireable<boolean>;
        checkable: PropTypes.Requireable<PropTypes.ReactNodeLike>;
        checkStrictly: PropTypes.Requireable<boolean>;
        draggable: PropTypes.Requireable<boolean>;
        defaultExpandParent: PropTypes.Requireable<boolean>;
        autoExpandParent: PropTypes.Requireable<boolean>;
        defaultExpandAll: PropTypes.Requireable<boolean>;
        defaultExpandedKeys: PropTypes.Requireable<string[]>;
        expandedKeys: PropTypes.Requireable<string[]>;
        defaultCheckedKeys: PropTypes.Requireable<string[]>;
        checkedKeys: PropTypes.Requireable<object>;
        defaultSelectedKeys: PropTypes.Requireable<string[]>;
        selectedKeys: PropTypes.Requireable<string[]>;
        onClick: PropTypes.Requireable<(...args: any[]) => any>;
        onDoubleClick: PropTypes.Requireable<(...args: any[]) => any>;
        onExpand: PropTypes.Requireable<(...args: any[]) => any>;
        onCheck: PropTypes.Requireable<(...args: any[]) => any>;
        onSelect: PropTypes.Requireable<(...args: any[]) => any>;
        onLoad: PropTypes.Requireable<(...args: any[]) => any>;
        loadData: PropTypes.Requireable<(...args: any[]) => any>;
        loadedKeys: PropTypes.Requireable<string[]>;
        onMouseEnter: PropTypes.Requireable<(...args: any[]) => any>;
        onMouseLeave: PropTypes.Requireable<(...args: any[]) => any>;
        onRightClick: PropTypes.Requireable<(...args: any[]) => any>;
        onDragStart: PropTypes.Requireable<(...args: any[]) => any>;
        onDragEnter: PropTypes.Requireable<(...args: any[]) => any>;
        onDragOver: PropTypes.Requireable<(...args: any[]) => any>;
        onDragLeave: PropTypes.Requireable<(...args: any[]) => any>;
        onDragEnd: PropTypes.Requireable<(...args: any[]) => any>;
        onDrop: PropTypes.Requireable<(...args: any[]) => any>;
        filterTreeNode: PropTypes.Requireable<(...args: any[]) => any>;
        motion: PropTypes.Requireable<object>;
        switcherIcon: PropTypes.Requireable<PropTypes.ReactNodeLike>;
    };
    static defaultProps: {
        prefixCls: string;
        showLine: boolean;
        showIcon: boolean;
        selectable: boolean;
        multiple: boolean;
        checkable: boolean;
        disabled: boolean;
        checkStrictly: boolean;
        draggable: boolean;
        defaultExpandParent: boolean;
        autoExpandParent: boolean;
        defaultExpandAll: boolean;
        defaultExpandedKeys: any[];
        defaultCheckedKeys: any[];
        defaultSelectedKeys: any[];
    };
    delayedDragEnterLogic: Record<Key, number>;
    state: TreeState;
    dragNode: NodeInstance;
    static getDerivedStateFromProps(props: TreeProps, prevState: TreeState): Partial<TreeState>;
    onNodeDragStart: (event: any, node: React.Component<import("./TreeNode").TreeNodeProps, {}, any>) => void;
    /**
     * [Legacy] Select handler is less small than node,
     * so that this will trigger when drag enter node or select handler.
     * This is a little tricky if customize css without padding.
     * Better for use mouse move event to refresh drag state.
     * But let's just keep it to avoid event trigger logic change.
     */
    onNodeDragEnter: (event: any, node: any) => void;
    onNodeDragOver: (event: any, node: any) => void;
    onNodeDragLeave: (event: any, node: any) => void;
    onNodeDragEnd: (event: any, node: any) => void;
    onNodeDrop: (event: any, node: any) => void;
    cleanDragState: () => void;
    onNodeClick: (e: any, treeNode: any) => void;
    onNodeDoubleClick: (e: any, treeNode: any) => void;
    onNodeSelect: (e: any, treeNode: any) => void;
    onNodeCheck: (e: any, treeNode: any, checked: any) => void;
    onNodeLoad: (treeNode: any) => Promise<unknown>;
    onNodeExpand: (e: any, treeNode: any) => Promise<void>;
    onNodeMouseEnter: (event: any, node: any) => void;
    onNodeMouseLeave: (event: any, node: any) => void;
    onNodeContextMenu: (event: any, node: any) => void;
    /**
     * Only update the value which is not in props
     */
    setUncontrolledState: (state: any) => void;
    render(): JSX.Element;
}
export default Tree;
