import _objectSpread from "@babel/runtime/helpers/esm/objectSpread2";
import _slicedToArray from "@babel/runtime/helpers/esm/slicedToArray";
import _objectWithoutProperties from "@babel/runtime/helpers/esm/objectWithoutProperties";
import * as React from 'react';
import { useState, useEffect } from 'react';
import isMobile from "rc-util/es/isMobile";
import Mask from './Mask';
import PopupInner from './PopupInner';
import MobilePopupInner from './MobilePopupInner';
var Popup = React.forwardRef(function (_ref, ref) {
  var visible = _ref.visible,
      mobile = _ref.mobile,
      props = _objectWithoutProperties(_ref, ["visible", "mobile"]);

  var _useState = useState(visible),
      _useState2 = _slicedToArray(_useState, 2),
      innerVisible = _useState2[0],
      serInnerVisible = _useState2[1];

  var _useState3 = useState(false),
      _useState4 = _slicedToArray(_useState3, 2),
      inMobile = _useState4[0],
      setInMobile = _useState4[1];

  var cloneProps = _objectSpread(_objectSpread({}, props), {}, {
    visible: innerVisible
  }); // We check mobile in visible changed here.
  // And this also delay set `innerVisible` to avoid popup component render flash


  useEffect(function () {
    serInnerVisible(visible);

    if (visible && mobile) {
      setInMobile(isMobile());
    }
  }, [visible, !!mobile]);
  var popupNode = inMobile ? React.createElement(MobilePopupInner, Object.assign({}, cloneProps, {
    mobile: mobile,
    ref: ref
  })) : React.createElement(PopupInner, Object.assign({}, cloneProps, {
    ref: ref
  })); // We can use fragment directly but this may failed some selector usage. Keep as origin logic

  return React.createElement("div", null, React.createElement(Mask, Object.assign({}, cloneProps)), popupNode);
});
Popup.displayName = 'Popup';
export default Popup;