import ReactDOM from 'react-dom';

function defaultGetContainer() {
  var container = document.createElement('div');
  document.body.appendChild(container);
  return container;
}

export default function getContainerRenderMixin(config) {
  var isVisible = config.isVisible,
      getComponent = config.getComponent,
      _config$getContainer = config.getContainer,
      getContainer = _config$getContainer === undefined ? defaultGetContainer : _config$getContainer;


  function _renderComponent(instance, componentArg, ready) {
    if (!isVisible || instance._component || isVisible(instance)) {
      if (!instance._container) {
        instance._container = getContainer(instance);
      }
      var component = getComponent(instance, componentArg);
      ReactDOM.unstable_renderSubtreeIntoContainer(instance, component, instance._container, function callback() {
        instance._component = this;
        if (ready) {
          ready.call(this);
        }
      });
    }
  }

  function _removeContainer(instance) {
    if (instance._container) {
      var container = instance._container;
      ReactDOM.unmountComponentAtNode(container);
      container.parentNode.removeChild(container);
      instance._container = null;
    }
  }

  var mixin = {
    renderComponent: function renderComponent(componentArg, ready) {
      _renderComponent(this, componentArg, ready);
    },
    removeContainer: function removeContainer() {
      _removeContainer(this);
    }
  };

  return mixin;
}