import * as React from 'react';
import { PortalRef } from './Portal';
/** @private Test usage only */
export declare function getOpenCount(): number;
export declare type GetContainer = string | HTMLElement | (() => HTMLElement);
export interface PortalWrapperProps {
    visible?: boolean;
    getContainer?: GetContainer;
    wrapperClassName?: string;
    forceRender?: boolean;
    children: (info: {
        getOpenCount: () => number;
        getContainer: () => HTMLElement;
        switchScrollingEffect: () => void;
        ref?: (c: any) => void;
    }) => React.ReactNode;
}
export interface PortalWrapperState {
    _self: PortalWrapper;
}
declare class PortalWrapper extends React.Component<PortalWrapperProps, PortalWrapperState> {
    container?: HTMLElement;
    componentRef: React.RefObject<PortalRef>;
    rafId?: number;
    renderComponent?: (info: {
        afterClose: Function;
        onClose: Function;
        visible: boolean;
    }) => void;
    constructor(props: PortalWrapperProps);
    componentDidMount(): void;
    componentDidUpdate(): void;
    componentWillUnmount(): void;
    static getDerivedStateFromProps(props: any, { prevProps, _self }: {
        prevProps: any;
        _self: any;
    }): {
        prevProps: any;
    };
    attachToParent: (force?: boolean) => boolean;
    getContainer: () => HTMLElement;
    setWrapperClassName: () => void;
    removeCurrentContainer: () => void;
    /**
     * Enhance ./switchScrollingEffect
     * 1. Simulate document body scroll bar with
     * 2. Record body has overflow style and recover when all of PortalWrapper invisible
     * 3. Disable body scroll when PortalWrapper has open
     *
     * @memberof PortalWrapper
     */
    switchScrollingEffect: () => void;
    render(): any;
}
export default PortalWrapper;
