"use strict";
function __export(m) {
    for (var p in m) if (!exports.hasOwnProperty(p)) exports[p] = m[p];
}
Object.defineProperty(exports, "__esModule", { value: true });
const DataFactory = require("@rdfjs/data-model");
const handler_1 = require("./lib/handler");
const Translator_1 = require("./lib/Translator");
__export(require("./lib/handler"));
__export(require("./lib/Translator"));
// Construct translator with built-in handlers
const translator = new Translator_1.Translator();
translator.registerHandler(new handler_1.TypeHandlerString(), handler_1.TypeHandlerString.TYPES.map(DataFactory.namedNode), ['string']);
translator.registerHandler(new handler_1.TypeHandlerBoolean(), [handler_1.TypeHandlerBoolean.TYPE].map(DataFactory.namedNode), ['boolean']);
translator.registerHandler(new handler_1.TypeHandlerNumberDouble(), handler_1.TypeHandlerNumberDouble.TYPES.map(DataFactory.namedNode), ['number']);
translator.registerHandler(new handler_1.TypeHandlerNumberInteger(), handler_1.TypeHandlerNumberInteger.TYPES.map(DataFactory.namedNode), ['number']);
/**
 * Convert the given RDF literal to an JavaScript primitive.
 * @param {Literal} literal An RDF literal value.
 * @param {boolean} validate If the literal value should be validated against the datatype.
 * @return {any} A JavaScript primitive value.
 */
function fromRdf(literal, validate) {
    return translator.fromRdf(literal, validate);
}
exports.fromRdf = fromRdf;
/**
 * Convert the given JavaScript primitive to an RDF literal.
 * @param value A JavaScript primitive value.
 * @param dataFactory An optional data factory to create terms with.
 * @return {Literal} An RDF literal value.
 */
function toRdf(value, dataFactory) {
    return translator.toRdf(value, dataFactory || DataFactory);
}
exports.toRdf = toRdf;
/**
 * Get the raw value of the given term.
 * If it is a literal, {@link fromRdf} will be called.
 * Otherwise {@link .value} will be returned.
 * @param {Term} term Any RDF term.
 * @param {boolean} validate If the literal value should be validated against the datatype.
 * @return {any} A JavaScript primitive value.
 */
function getTermRaw(term, validate) {
    if (term.termType === 'Literal') {
        return fromRdf(term, validate);
    }
    return term.value;
}
exports.getTermRaw = getTermRaw;
/**
 * @return {NamedNode[]} An array of all supported RDF datatypes.
 */
function getSupportedRdfDatatypes() {
    return translator.getSupportedRdfDatatypes();
}
exports.getSupportedRdfDatatypes = getSupportedRdfDatatypes;
/**
 * @return {string[]} An array of all supported JavaScript types.
 */
function getSupportedJavaScriptPrimitives() {
    return translator.getSupportedJavaScriptPrimitives();
}
exports.getSupportedJavaScriptPrimitives = getSupportedJavaScriptPrimitives;
//# sourceMappingURL=index.js.map