import * as RDF from "rdf-js";
import { ITypeHandler } from "./ITypeHandler";
/**
 * Translates between an RDF literal and a JavaScript primitive.
 */
export declare class Translator implements ITypeHandler {
    private readonly supportedRdfDatatypes;
    private readonly fromRdfHandlers;
    private readonly toRdfHandlers;
    constructor();
    static incorrectRdfDataType(literal: RDF.Literal): void;
    registerHandler(handler: ITypeHandler, rdfDatatypes: RDF.NamedNode[], javaScriptDataTypes: string[]): void;
    fromRdf(literal: RDF.Literal, validate?: boolean): any;
    toRdf(value: any, dataFactory: RDF.DataFactory): RDF.Literal;
    /**
     * @return {NamedNode[]} An array of all supported RDF datatypes.
     */
    getSupportedRdfDatatypes(): RDF.NamedNode[];
    /**
     * @return {string[]} An array of all supported JavaScript types.
     */
    getSupportedJavaScriptPrimitives(): string[];
}
