"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const Translator_1 = require("../Translator");
/**
 * Translates double numbers.
 */
class TypeHandlerNumberDouble {
    fromRdf(literal, validate) {
        const parsed = parseFloat(literal.value);
        if (validate) {
            if (isNaN(parsed)) {
                Translator_1.Translator.incorrectRdfDataType(literal);
            }
            // TODO: validate more
        }
        return parsed;
    }
    toRdf(value, dataFactory) {
        if (isNaN(value)) {
            return dataFactory.literal('NaN', dataFactory.namedNode(TypeHandlerNumberDouble.TYPES[0]));
        }
        if (!isFinite(value)) {
            return dataFactory.literal(value > 0 ? 'INF' : '-INF', dataFactory.namedNode(TypeHandlerNumberDouble.TYPES[0]));
        }
        if (value % 1 === 0) {
            return null;
        }
        return dataFactory.literal(value.toExponential(15).replace(/(\d)0*e\+?/, '$1E'), dataFactory.namedNode(TypeHandlerNumberDouble.TYPES[0]));
    }
}
TypeHandlerNumberDouble.TYPES = [
    'http://www.w3.org/2001/XMLSchema#double',
    'http://www.w3.org/2001/XMLSchema#decimal',
    'http://www.w3.org/2001/XMLSchema#float',
];
exports.TypeHandlerNumberDouble = TypeHandlerNumberDouble;
//# sourceMappingURL=TypeHandlerNumberDouble.js.map