"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const Translator_1 = require("../Translator");
/**
 * Translates integer numbers.
 */
class TypeHandlerNumberInteger {
    fromRdf(literal, validate) {
        const parsed = parseInt(literal.value, 10);
        if (validate) {
            if (isNaN(parsed) || literal.value.indexOf('.') >= 0) {
                Translator_1.Translator.incorrectRdfDataType(literal);
            }
            // TODO: validate more
        }
        return parsed;
    }
    toRdf(value, dataFactory) {
        return dataFactory.literal(String(value), value <= TypeHandlerNumberInteger.MAX_INT && value >= TypeHandlerNumberInteger.MIN_INT
            ? dataFactory.namedNode(TypeHandlerNumberInteger.TYPES[0])
            : dataFactory.namedNode(TypeHandlerNumberInteger.TYPES[1]));
    }
}
TypeHandlerNumberInteger.TYPES = [
    'http://www.w3.org/2001/XMLSchema#integer',
    'http://www.w3.org/2001/XMLSchema#long',
    'http://www.w3.org/2001/XMLSchema#int',
    'http://www.w3.org/2001/XMLSchema#byte',
    'http://www.w3.org/2001/XMLSchema#short',
    'http://www.w3.org/2001/XMLSchema#negativeInteger',
    'http://www.w3.org/2001/XMLSchema#nonNegativeInteger',
    'http://www.w3.org/2001/XMLSchema#nonPositiveInteger',
    'http://www.w3.org/2001/XMLSchema#positiveInteger',
    'http://www.w3.org/2001/XMLSchema#unsignedByte',
    'http://www.w3.org/2001/XMLSchema#unsignedInt',
    'http://www.w3.org/2001/XMLSchema#unsignedLong',
    'http://www.w3.org/2001/XMLSchema#unsignedShort',
];
TypeHandlerNumberInteger.MAX_INT = 2147483647;
TypeHandlerNumberInteger.MIN_INT = -2147483648;
exports.TypeHandlerNumberInteger = TypeHandlerNumberInteger;
//# sourceMappingURL=TypeHandlerNumberInteger.js.map