import * as RDF from "@rdfjs/types";
import { IToRdfOptions } from "./lib/ITypeHandler";
export * from "./lib/handler";
export * from "./lib/ITypeHandler";
export * from "./lib/Translator";
/**
 * Convert the given RDF literal to an JavaScript primitive.
 * @param {Literal} literal An RDF literal value.
 * @param {boolean} validate If the literal value should be validated against the datatype.
 * @return {any} A JavaScript primitive value.
 */
export declare function fromRdf(literal: RDF.Literal, validate?: boolean): any;
/**
 * Convert the given JavaScript primitive to an RDF literal.
 * @param value A JavaScript primitive value.
 * @param options Options for RDF conversion. May also be a data factory.
 * @return {Literal} An RDF literal value.
 */
export declare function toRdf(value: any, options?: IToRdfOptions | RDF.DataFactory): RDF.Literal;
/**
 * Get the raw value of the given term.
 * If it is a literal, {@link fromRdf} will be called.
 * Otherwise {@link .value} will be returned.
 * @param {Term} term Any RDF term.
 * @param {boolean} validate If the literal value should be validated against the datatype.
 * @return {any} A JavaScript primitive value.
 */
export declare function getTermRaw(term: RDF.Term, validate?: boolean): any;
/**
 * @return {NamedNode[]} An array of all supported RDF datatypes.
 */
export declare function getSupportedRdfDatatypes(): RDF.NamedNode[];
/**
 * @return {string[]} An array of all supported JavaScript types.
 */
export declare function getSupportedJavaScriptPrimitives(): string[];
