"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getSupportedJavaScriptPrimitives = exports.getSupportedRdfDatatypes = exports.getTermRaw = exports.toRdf = exports.fromRdf = void 0;
const rdf_data_factory_1 = require("rdf-data-factory");
const handler_1 = require("./lib/handler");
const Translator_1 = require("./lib/Translator");
__exportStar(require("./lib/handler"), exports);
__exportStar(require("./lib/ITypeHandler"), exports);
__exportStar(require("./lib/Translator"), exports);
const DF = new rdf_data_factory_1.DataFactory();
// Construct translator with built-in handlers
const translator = new Translator_1.Translator();
translator.registerHandler(new handler_1.TypeHandlerString(), handler_1.TypeHandlerString.TYPES.map(t => DF.namedNode(t)), ['string']);
translator.registerHandler(new handler_1.TypeHandlerBoolean(), [handler_1.TypeHandlerBoolean.TYPE].map(t => DF.namedNode(t)), ['boolean']);
translator.registerHandler(new handler_1.TypeHandlerNumberDouble(), handler_1.TypeHandlerNumberDouble.TYPES.map(t => DF.namedNode(t)), ['number']);
translator.registerHandler(new handler_1.TypeHandlerNumberInteger(), handler_1.TypeHandlerNumberInteger.TYPES.map(t => DF.namedNode(t)), ['number']);
translator.registerHandler(new handler_1.TypeHandlerDate(), handler_1.TypeHandlerDate.TYPES.map(t => DF.namedNode(t)), ['object']);
/**
 * Convert the given RDF literal to an JavaScript primitive.
 * @param {Literal} literal An RDF literal value.
 * @param {boolean} validate If the literal value should be validated against the datatype.
 * @return {any} A JavaScript primitive value.
 */
function fromRdf(literal, validate) {
    return translator.fromRdf(literal, validate);
}
exports.fromRdf = fromRdf;
/**
 * Convert the given JavaScript primitive to an RDF literal.
 * @param value A JavaScript primitive value.
 * @param options Options for RDF conversion. May also be a data factory.
 * @return {Literal} An RDF literal value.
 */
function toRdf(value, options) {
    // Backwards-compatibility to accept data factory as option arg.
    if (options && 'namedNode' in options) {
        options = { dataFactory: options };
    }
    // Set default data factory
    options = options || {};
    if (options && !options.dataFactory) {
        options.dataFactory = DF;
    }
    return translator.toRdf(value, options);
}
exports.toRdf = toRdf;
/**
 * Get the raw value of the given term.
 * If it is a literal, {@link fromRdf} will be called.
 * Otherwise {@link .value} will be returned.
 * @param {Term} term Any RDF term.
 * @param {boolean} validate If the literal value should be validated against the datatype.
 * @return {any} A JavaScript primitive value.
 */
function getTermRaw(term, validate) {
    if (term.termType === 'Literal') {
        return fromRdf(term, validate);
    }
    return term.value;
}
exports.getTermRaw = getTermRaw;
/**
 * @return {NamedNode[]} An array of all supported RDF datatypes.
 */
function getSupportedRdfDatatypes() {
    return translator.getSupportedRdfDatatypes();
}
exports.getSupportedRdfDatatypes = getSupportedRdfDatatypes;
/**
 * @return {string[]} An array of all supported JavaScript types.
 */
function getSupportedJavaScriptPrimitives() {
    return translator.getSupportedJavaScriptPrimitives();
}
exports.getSupportedJavaScriptPrimitives = getSupportedJavaScriptPrimitives;
//# sourceMappingURL=index.js.map