"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TypeHandlerBoolean = void 0;
const Translator_1 = require("../Translator");
/**
 * Translates booleans.
 */
class TypeHandlerBoolean {
    fromRdf(literal, validate) {
        switch (literal.value) {
            case 'true':
                return true;
            case 'false':
                return false;
            case '1':
                return true;
            case '0':
                return false;
        }
        if (validate) {
            Translator_1.Translator.incorrectRdfDataType(literal);
        }
        return false;
    }
    toRdf(value, { datatype, dataFactory }) {
        return dataFactory.literal(value ? 'true' : 'false', datatype || dataFactory.namedNode(TypeHandlerBoolean.TYPE));
    }
}
TypeHandlerBoolean.TYPE = 'http://www.w3.org/2001/XMLSchema#boolean';
exports.TypeHandlerBoolean = TypeHandlerBoolean;
//# sourceMappingURL=TypeHandlerBoolean.js.map