"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TypeHandlerNumberDouble = void 0;
const Translator_1 = require("../Translator");
/**
 * Translates double numbers.
 */
class TypeHandlerNumberDouble {
    fromRdf(literal, validate) {
        const parsed = parseFloat(literal.value);
        if (validate) {
            if (isNaN(parsed)) {
                Translator_1.Translator.incorrectRdfDataType(literal);
            }
            // TODO: validate more
        }
        return parsed;
    }
    toRdf(value, { datatype, dataFactory }) {
        datatype = datatype || dataFactory.namedNode(TypeHandlerNumberDouble.TYPES[0]);
        if (isNaN(value)) {
            return dataFactory.literal('NaN', datatype);
        }
        if (!isFinite(value)) {
            return dataFactory.literal(value > 0 ? 'INF' : '-INF', datatype);
        }
        if (value % 1 === 0) {
            return null;
        }
        return dataFactory.literal(value.toExponential(15).replace(/(\d)0*e\+?/, '$1E'), datatype);
    }
}
TypeHandlerNumberDouble.TYPES = [
    'http://www.w3.org/2001/XMLSchema#double',
    'http://www.w3.org/2001/XMLSchema#decimal',
    'http://www.w3.org/2001/XMLSchema#float',
];
exports.TypeHandlerNumberDouble = TypeHandlerNumberDouble;
//# sourceMappingURL=TypeHandlerNumberDouble.js.map