import * as RDF from "rdf-js";
/**
 * All known term types.
 * @see RDF.Term
 * @type {[string , string , string , string , string]}
 */
export declare const TERM_TYPES: string[];
/**
 * Create an array of unique terms from the given array.
 * @param {T[]} terms An array of RDFJS terms.
 * @return {T[]} A new array of unique RDFJS terms.
 */
export declare function uniqTerms<T extends RDF.Term>(terms: T[]): T[];
/**
 * Find all terms of the given type in the given array.
 * @param {Term[]} terms An array of RDFJS terms.
 * @param {"NamedNode" | "BlankNode" | "Literal" | "Variable" | "DefaultGraph"} termType A term type.
 * @return {Term[]} A new array with elements from the given array only containing elements of the given type.
 */
export declare function getTermsOfType(terms: RDF.Term[], termType: "NamedNode" | "BlankNode" | "Literal" | "Variable" | "DefaultGraph"): RDF.Term[];
/**
 * Find all named nodes in the given array.
 * @param {Term[]} terms An array of RDFJS terms.
 * @return {NamedNode[]} A new array with elements from the given array only containing named nodes.
 */
export declare function getNamedNodes(terms: RDF.Term[]): RDF.NamedNode[];
/**
 * Find all blank nodes in the given array.
 * @param {Term[]} terms An array of RDFJS terms.
 * @return {BlankNode[]} A new array with elements from the given array only containing blank nodes.
 */
export declare function getBlankNodes(terms: RDF.Term[]): RDF.BlankNode[];
/**
 * Find all literals in the given array.
 * @param {Term[]} terms An array of RDFJS terms.
 * @return {Literal[]} A new array with elements from the given array only containing literals.
 */
export declare function getLiterals(terms: RDF.Term[]): RDF.Literal[];
/**
 * Find all variables in the given array.
 * @param {Term[]} terms An array of RDFJS terms.
 * @return {Variable[]} A new array with elements from the given array only containing variables.
 */
export declare function getVariables(terms: RDF.Term[]): RDF.Variable[];
/**
 * Find all default graphs in the given array.
 * @param {Term[]} terms An array of RDFJS terms.
 * @return {DefaultGraph[]} A new array with elements from the given array only containing default graphs.
 */
export declare function getDefaultGraphs(terms: RDF.Term[]): RDF.DefaultGraph[];
