(function() {

var Utils = {};



Utils['extends'] = function(supertype, descendant) {
    descendant.prototype = new supertype();
};


Utils.stackCounterLimit = 1000;
Utils.stackCounter = 0;

Utils.recur = function(c){
    if(Utils.stackCounter === Utils.stackCounterLimit) {
        Utils.stackCounter = 0;
        setTimeout(c, 0);
    } else {
        Utils.stackCounter++;
        c();
    } 
};

Utils.shuffle = function(o){ //v1.0
    for(var j, x, i = o.length; i; j = parseInt(Math.random() * i), x = o[--i], o[i] = o[j], o[j] = x);
	return o;
};

Utils.include = function(a,v) {
    var cmp = arguments[2];

    for(var i=(a.length-1); i>=0; i--) {
        var res = false;
        if(cmp == null) {
            res = (a[i] === v);
        } else {
            res = (cmp(a[i],v) === 0);
        }

        if(res === true) {
            return true;
        }
    }

    return false;
};

Utils.repeat = function(c,max,floop,fend,env) {
    if(arguments.length===4) { env = {}; }
    if(c<max) {
        env._i = c;
        floop(function(floop,env){
            // avoid stack overflow
            // deadly hack
            Utils.recur(function(){ Utils.repeat(c+1, max, floop, fend, env) });
        },env);
    } else {
        fend(env);
    }
};


Utilsmeanwhile = function(c,floop,fend,env) {
    if(arguments.length===3) { env = {}; }

    if(env['_stack_counter'] == null) {
        env['_stack_counter'] = 0;
    }

    if(c===true) {
        floop(function(c,floop,env){
            if(env['_stack_counter'] % 40 == 39) {
                env['_stack_counter'] = env['_stack_counter'] + 1;
                setTimeout(function(){ Utilsmeanwhile(c, floop, fend, env); }, 0);
            } else {
                env['_stack_counter'] = env['_stack_counter'] + 1;
                Utilsmeanwhile(c, floop, fend, env);
            }
        },env);
    } else {
        fend(env);
    }
};

Utils.seq = function() {
    var fs = arguments;
    return function(callback) {
        Utils.repeat(0, fs.length, function(k,env){
            var floop = arguments.callee;
            fs[env._i](function(){
                k(floop, env);
            });
        }, function(){
            callback();
        });
    }
};


Utils.partition = function(c, n) {
    var rem = c.length % n;
    var currentGroup = [];
    for(var i=0; i<rem; i++) {
        currentGroup.push(null);
    }
    
    var groups = [];
    var groupCounter = rem;
    for(var i=0; i<c.length; i++) {
        currentGroup.push(c[i]);
        if(currentGroup.length % n == 0) {
            groups.push(currentGroup);
            currentGroup = [];
        }
    }
    return groups;
};

Utils.keys = function(obj) {
    var variables = [];
    for(var variable in obj) {
        variables.push(variable);
    }

    return variables;
};

Utils.iso8601 = function(date) {
    function pad(n){
        return n<10 ? '0'+n : n;
    }    
    return date.getUTCFullYear()+'-'
        + pad(date.getUTCMonth()+1)+'-'
        + pad(date.getUTCDate())+'T'
        + pad(date.getUTCHours())+':'
        + pad(date.getUTCMinutes())+':'
        + pad(date.getUTCSeconds())+'Z';
};


Utils.parseStrictISO8601 = function (str) {
    var regexp = "([0-9]{4})(-([0-9]{2})(-([0-9]{2})" +
        "(T([0-9]{2}):([0-9]{2})(:([0-9]{2})(\.([0-9]+))?)?" +
        "(Z|(([-+])([0-9]{2}):([0-9]{2})))?)?)?)?";
    var d = str.match(new RegExp(regexp));

    var offset = 0;
    var date = new Date(d[1], 0, 1);

    if (d[3]) { date.setMonth(d[3] - 1); } else { throw "missing ISO8061 component" }
    if (d[5]) { date.setDate(d[5]);  } else { throw "missing ISO8061 component" }
    if (d[7]) { date.setHours(d[7]);  } else { throw "missing ISO8061 component" }
    if (d[8]) { date.setMinutes(d[8]);  } else { throw "missing ISO8061 component" }
    if (d[10]) { date.setSeconds(d[10]);  } else { throw "missing ISO8061 component" }
    if (d[12]) { date.setMilliseconds(Number("0." + d[12]) * 1000); }
    if (d[14]) {
        offset = (Number(d[16]) * 60) + Number(d[17]);
        offset *= ((d[15] == '-') ? 1 : -1);
    }

    offset -= date.getTimezoneOffset();
    time = (Number(date) + (offset * 60 * 1000));
    var toReturn = new Date();
    toReturn.setTime(Number(time));
    return toReturn;
}


Utils.parseISO8601 = function (str) {
    var regexp = "([0-9]{4})(-([0-9]{2})(-([0-9]{2})" +
        "(T([0-9]{2}):([0-9]{2})(:([0-9]{2})(\.([0-9]+))?)?" +
        "(Z|(([-+])([0-9]{2}):([0-9]{2})))?)?)?)?";
    var d = str.match(new RegExp(regexp));

    var offset = 0;
    var date = new Date(d[1], 0, 1);

    if (d[3]) { date.setMonth(d[3] - 1); }
    if (d[5]) { date.setDate(d[5]);  }
    if (d[7]) { date.setHours(d[7]);  }
    if (d[8]) { date.setMinutes(d[8]);  }
    if (d[10]) { date.setSeconds(d[10]);  }
    if (d[12]) { date.setMilliseconds(Number("0." + d[12]) * 1000); }
    if (d[14]) {
        offset = (Number(d[16]) * 60) + Number(d[17]);
        offset *= ((d[15] == '-') ? 1 : -1);
    }

    offset -= date.getTimezoneOffset();
    time = (Number(date) + (offset * 60 * 1000));
    var toReturn = new Date();
    toReturn.setTime(Number(time));
    return toReturn;
};

Utils.parseISO8601Components = function (str) {
    var regexp = "([0-9]{4})(-([0-9]{2}))(-([0-9]{2}))(T([0-9]{2}):([0-9]{2})(:([0-9]{2}))?(\.([0-9]+))?)?(Z|([-+])([0-9]{2})(:([0-9]{2}))?)?";
    var d = str.match(new RegExp(regexp));
    var year, month, date, hours, minutes, seconds, millisecs, timezone;
    year = Number(d[1]);
    month = d[3] - 1;
    date  = Number(d[5]);
    hours = Number(d[7]);
    minutes = Number(d[8]);
    seconds = Number(d[10]);

    if(d[12]) { millisecs = Number("0." + d[12]) * 1000 }

    if(d[13]==="Z") {
        timezone = 0;
    } else if (d[14]) {
        var timezone = 0;
        if(d[17]) {
            timezone = Number(d[17]);
        }
        timezone = timezone+(Number(d[15]) * 60);
        timezone *= ((d[14] == '-') ? -1 : +1);
    } else if(d[14]==null && d[11]) {
        timezone = Number(d[12])*60;
    }    

    return {'year': isNaN(year) ? null : year,
            'month': isNaN(month) ? null : month,
            'date': isNaN(date) ? null : date,
            'hours': isNaN(hours) ? null : hours,
            'minutes': isNaN(minutes) ? null : minutes,
            'seconds': isNaN(seconds) ? null : seconds,
            'millisecs':isNaN(millisecs) ? null : millisecs,
            'timezone': isNaN(timezone) ? null : timezone};
};

Utils.compareDateComponents = function(stra,strb) {
    var a = Utils.parseISO8601Components(stra);
    var b = Utils.parseISO8601Components(strb);

    if((a.timezone == null && b.timezone == null) ||
       (a.timezone != null && b.timezone != null)) {        
        da = Utils.parseISO8601(stra);
        db = Utils.parseISO8601(strb);
        
        if(da.getTime() == db.getTime()) {
            return 0;
        } else if(da.getTime() < db.getTime()){
            return -1;
        } else {
            return 1;
        }
    } else if (a.timezone != null && b.timezone == null){
        da = Utils.parseISO8601(stra);
        db = Utils.parseISO8601(strb);
        ta = da.getTime();
        tb = db.getTime();

        var offset = 14*60*60;

        if(ta < tb && ta < (tb + offset)) {
            return -1;
        } else if(ta > tb && ta > (tb - offset)) {
            return 1;
        } else {
        return null;
        }
    } else {
        da = Utils.parseISO8601(stra);
        db = Utils.parseISO8601(strb);
        ta = da.getTime();
        tb = db.getTime();

        var offset = 14*60*60;
        if(ta < tb && (ta + offset)  < tb) {
            return -1;
        } else if(ta > tb && (ta + offset) > tb) {
            return 1;
        } else {
        return null;
        }
    }
};

// RDF utils

Utils.lexicalFormLiteral = function(term, env) {
    var value = term.value;
    var lang = term.lang;
    var type = term.type;

    var indexedValue = null;
    if(value != null && type != null && typeof(type) != 'string') {
        var typeValue = type.value;

        if(typeValue != null) {
            indexedValue = '"' + term.value + '"^^<' + typeValue + '>';
        } else {
            var typePrefix = type.prefix;
            var typeSuffix = type.suffix;

            var resolvedPrefix = env.namespaces[typePrefix];
            term.type = resolvedPrefix+typeSuffix;
            indexedValue = '"' + term.value + '"^^<' + resolvedPrefix + typeSuffix + '>';
        }
    } else {
        if(lang == null && type == null) {
            indexedValue = '"' + value + '"';
        } else if(type == null) {
            indexedValue = '"' + value + '"' + "@" + lang;        
        } else {
            indexedValue = '"' + term.value + '"^^<'+type+'>';
        }
    }
    return indexedValue;
};

Utils.lexicalFormBaseUri = function(term, env) {
    var uri = null;
    //console.log("*** normalizing URI token:");
    //console.log(term);
    if(term.value == null) {
        //console.log(" - URI has prefix and suffix");
        //console.log(" - prefix:"+term.prefix);
        //console.log(" - suffixx:"+term.suffix);
        var prefix = term.prefix;
        var suffix = term.suffix;
        var resolvedPrefix = env.namespaces[prefix];
        if(resolvedPrefix != null) {            
            uri = resolvedPrefix+suffix;
        }
    } else {
        //console.log(" - URI is not prefixed");
        uri = term.value
    }

    if(uri===null) {
        return null;
    } else {
        //console.log(" - resolved URI is "+uri);
        if(uri.indexOf(":") == -1) {
            //console.log(" - URI is partial");
            uri = (env.base||"") + uri; // applyBaseUri
        } else {
            //console.log(" - URI is complete");
        }
        //console.log(" -> FINAL URI: "+uri);
    }

    return uri;
};


Utils.lexicalFormTerm = function(term, ns) {
    if(term.token === 'uri') {
        return {'uri': Utils.lexicalFormBaseUri(term, ns)}
    } else if(term.token === 'literal') {
        return {'literal': Utils.lexicalFormLiteral(term, ns)};
    } else if(term.token === 'blank') {
        var label = '_:'+ns.blank;
        ns.blank = ns.blank+1;
        return {'blank': label};
    } else {
        callback(false, 'Token of kind '+term.token+' cannot transformed into its lexical form');
    }
};

Utils.normalizeUnicodeLiterals = function(string) {
    var escapedUnicode = string.match(/\\u[0-9abcdefABCDEF]{4,4}/g) || [];
    var dups = {};
    for(var i=0; i<escapedUnicode.length; i++) {
        if(dups[escapedUnicode[i]] == null) {
            dups[escapedUnicode[i]] = true;
            string = string.replace(new RegExp("\\"+escapedUnicode[i],"g"), eval("'"+escapedUnicode[i]+"'"));
        }
    }

    return string;
}

Utils.hashTerm = function(term) {
    try {
      if(term == null) {
          return "";
      } if(term.token==='uri') {
          return "u"+term.value;
      } else if(term.token === 'blank') {
          return "b"+term.value;
      } else if(term.token === 'literal') {
          l = "l"+term.value;
          l = l + (term.type || "");
          l = l + (term.lang || "");        
   
          return l;
      }
    } catch(e) {
        if(typeof(term) === 'object') {
            var key = "";
            for(p in term) {
                key = key + p + term[p];
            }

            return key;
        }
        return term;
    }
}

// end of ./src/js-trees/src/utils.js 
// exports
var InMemoryAsyncBTree = {};

var left = -1;
var right = 1;



InMemoryAsyncBTree._repeat = function(c,max,floop,fend,env) {
    if(c<max) {
        env._i = c;
        floop(function(floop,env){
            InMemoryAsyncBTree._repeat(c+1, max, floop,fend,env);
        },env);
    } else {
        fend(env);
    }
}

/*
 * @doc
 * Implementation based on <http://www.gossamer-threads.com/lists/linux/kernel/667935>
 *
 */

/**
 * Tree
 *
 * Implements the interface of BinarySearchTree.Tree
 *
 * An implementation of an in memory B-Tree.
 */
InMemoryAsyncBTree.Tree = function(order,f) {
    if(arguments.length != 0) {
        this.order = order;
        this.root = this._allocateNode();
        this.root.isLeaf = true;
        this.root.level = 0;
        var that = this;
        this._diskWrite(this.root, function(root){
            that.root = root;
            that._updateRootNode(that.root, function(n){
                that.comparator = function(a,b) {
                    if(a < b) {
                        return -1;
                    } else if(a > b){
                        return 1;
                    } else {
                        return 0;
                    }
                };
                that.merger = null;
                // we notify we are ready
                if(f!=null) {
                    f(that);
                }
            })});
    }
};

/**
 * Creates the new node.
 *
 * This class can be overwritten by different versions of
 * the tree t select the right kind of node to be used
 *
 * @returns the new alloacted node
 */
InMemoryAsyncBTree.Tree.prototype._allocateNode = function() {
    return new InMemoryAsyncBTree.Node();
};

/**
 * _diskWrite
 *
 * Persists the node to secondary memory.
 */
InMemoryAsyncBTree.Tree.prototype._diskWrite= function(node, f) {
    // dummy implementation;
    // no-op
    f(node);
};


/**
 * _diskRead
 *
 * Retrieves a node from secondary memory using the provided
 * pointer
 */
InMemoryAsyncBTree.Tree.prototype._diskRead = function(pointer, f) {
    // dummy implementation;
    // no-op
    f(pointer);
};

InMemoryAsyncBTree.Tree.prototype._diskDelete= function(node,f) {
    // dummy implmentation
    // no-op
    f();
};


/**
 * _updateRootNode
 *
 * Updates the pointer to the root node stored in disk.
 */
InMemoryAsyncBTree.Tree.prototype._updateRootNode = function(node,f) {
    // dummy implementation;
    // no-op
    f(node)
};


/**
 * search
 *
 * Retrieves the node matching the given value.
 * If no node is found, null is returned.
 */
InMemoryAsyncBTree.Tree.prototype.search = function(key,f, checkExists) {
    var node = this.root;
    var tree = this;
    tree.__search(tree,key,node,f, checkExists);
};
InMemoryAsyncBTree.Tree.prototype.__search = function(tree,key,node, f, checkExists) {
    var idx = 0;
    while(idx < node.numberActives && tree.comparator(key, node.keys[idx].key) === 1) {
        idx++;
    }

    if(idx < node.numberActives && tree.comparator(node.keys[idx].key,key) === 0) {
        if(checkExists!=null && checkExists == true) {
            f(true);        
        } else {
            f(node.keys[idx].data);
        }
    } else {
        if(node.isLeaf === true) {
            f(null)
        } else {
            tree._diskRead(node.children[idx],function(node){
                tree.__search(tree,key,node,f, checkExists)
            });
        }
    }
}


/**
 * walk
 * Applies a function to all the nodes key and data in the the
 * tree in key order.
 */
InMemoryAsyncBTree.Tree.prototype.walk = function(f) {
    this.__walk(this,this.root,f,function(){});
};
InMemoryAsyncBTree.Tree.prototype.__walk = function(tree,node,f,callback) {
    if(node.isLeaf) {
        for(var i=0; i<node.numberActives; i++) {
            f(node.keys[i]);
        }
        return callback();
    } else {

        var max = node.numberActives;
        var loopf1 = function(c,env){
            tree._diskRead(node.children[env._i], function(n){
                tree.__walk(tree,n,f,function(){
                    tree._diskRead(node.keys[env._i], function(n){
                        f(n);
                        c(loopf1,env);
                    })
                });
            });
        };
        InMemoryAsyncBTree._repeat(0,max,loopf1,function(env){
            tree._diskRead(node.children[max],function(node){
                tree.__walk(tree,node,f,function(){callback();});
            });
        },{});
    }
};


/**
 * walkNodes
 * Applies a function to all the nodes in the the
 * tree in key order.
 */
InMemoryAsyncBTree.Tree.prototype.walkNodes = function(f) {
    this.__walkNodes(this,root,f,function(){});
};
InMemoryAsyncBTree.Tree.prototype.__walkNodes = function(tree,node,f,callback) {
    if(node.isLeaf) {
        f(node);
        return callback();
    } else {
        f(node);
        var max = node.numberActives;
        var loopf1 = function(c,env){
            tree._diskRead(node.children[env._i], function(n){
                tree.__walkNodes(tree,n,f,function(){
                    c(loopf1,env);
                });
            });
        };
        InMemoryAsyncBTree._repeat(0,max,loopf1,function(env){
            tree._diskRead(node.children[max],function(n){
                tree.__walkNodes(tree,n,f,function(){});
            });
        },{});
    }
};

/**
 * _splitChild
 *
 * Split the child node and adjusts the parent.
 */
InMemoryAsyncBTree.Tree.prototype._splitChild = function(parent, index, child, callback) {
    var newChild = this._allocateNode();
    newChild.isLeaf = child.isLeaf;
    newChild.level = child.level;
    newChild.numberActives = this.order - 1;

    // Copy the higher order keys to the new child
    var newParentChild = child.keys[this.order-1];
    child.keys[this.order-1] = null;

    for(var i=0; i< this.order-1; i++) {
	newChild.keys[i]=child.keys[i+this.order];
	child.keys[i+this.order] = null;
	if(!child.isLeaf) {
	    newChild.children[i] = child.children[i+this.order];
            child.children[i+this.order] = null;
	}
    }

    // Copy the last child pointer
    if(!child.isLeaf) {
	newChild.children[i] = child.children[i+this.order];
        child.children[i+this.order] = null;
    }

    child.numberActives = this.order - 1;


    for(i = parent.numberActives + 1; i>index+1; i--) {
	parent.children[i] = parent.children[i-1];
    }

    parent.children[index+1] = newChild;

    for(i = parent.numberActives; i>index; i--) {
	parent.keys[i] = parent.keys[i-1];
    }

    parent.keys[index] = newParentChild;
    parent.numberActives++;

    var that = this;
    this._diskWrite(newChild,function(newChild){
        that._diskWrite(parent,function(parent){
            parent.children[index+1] = newChild;
            that._diskWrite(child,function(child){
                return callback(parent);
            });
        });
    });
};

/**
 * insert
 *
 * Creates a new node with value key and data and inserts it
 * into the tree.
 */
InMemoryAsyncBTree.Tree.prototype.insert = function(key,data,callback) {

    if(this.root.numberActives === (2 * this.order - 1)) {
        var newRoot = this._allocateNode();
        newRoot.isLeaf = false;
        newRoot.level = this.root.level + 1;
        newRoot.numberActives = 0;
        newRoot.children[0] = this.root;

        var that = this;
        this._splitChild(newRoot, 0, this.root, function(updatedParent){
            newRoot = updatedParent; // @warning tricky!
            that.root = newRoot;
            that._updateRootNode(newRoot, function(newRoot){
                that._insertNonFull(newRoot, key, data, callback);
            });
        });
    } else {
        this._insertNonFull(this.root, key, data,callback);
    }
};

/**
 * _insertNonFull
 *
 * Recursive function that tries to insert the new key in
 * in the prvided node, or splits it and go deeper
 * in the BTree hierarchy.
 */
InMemoryAsyncBTree.Tree.prototype._insertNonFull = function(node,key,data,callback) {
    var idx = node.numberActives -1;
    this.__insertNonFull(this,node,idx,key,data,callback);
}
InMemoryAsyncBTree.Tree.prototype.__insertNonFull = function(tree,node,idx,key,data,callback) {
    if(!node.isLeaf) {
        while(idx>=0 && tree.comparator(key,node.keys[idx].key) === -1) {
            idx--;
        }
        idx++;
        var that = tree;
        tree._diskRead(node.children[idx],function(child) {
            if(child.numberActives === 2*that.order -1) {
                that._splitChild(node,idx,child,function(){
                    if(that.comparator(key, node.keys[idx].key)===1) {
                        idx++;
                    }
                    that._diskRead(node.children[idx], function(node){
                        idx = node.numberActives -1;
                        that.__insertNonFull(tree,node,idx,key,data,callback);
                    });
                });
            } else {
                that._diskRead(node.children[idx], function(node){
                    idx = node.numberActives -1;
                    that.__insertNonFull(tree,node,idx,key,data,callback);
                });
            }
        });

    } else {
        while(idx>=0 && tree.comparator(key,node.keys[idx].key) === -1) {
            node.keys[idx+1] = node.keys[idx];
            idx--;
        }

        node.keys[idx+1] = {key: key, data:data}
        node.numberActives++;
        tree._diskWrite(node, function(node){
            return callback(node);
        });
    }
};

/**
 * delete
 *
 * Deletes the key from the BTree.
 * If the key is not found, an exception is thrown.
 *
 * @param key the key to be deleted
 * @returns true if the key is deleted false otherwise
 */
InMemoryAsyncBTree.Tree.prototype['delete'] = function(key,callback) {
    var node = this.root;
    InMemoryAsyncBTree.Tree.prototype.__deleteSearchNode(this,key,node,callback);
};
InMemoryAsyncBTree.Tree.prototype.__deleteSearchNode = function(tree,key,node,callback) {
    i = 0;

    if(node.numberActives === 0) {
        return callback(false);
    }

    while(i<node.numberActives && tree.comparator(key, node.keys[i].key) === 1) {
        i++;
    }

    idx = i;

    if(i<node.numberActives && tree.comparator(key, node.keys[i].key) === 0) {
        return tree.__deleteNodeFound(tree,key,node,callback);
    }

    if(node.isLeaf === true) {
        return callback(false);
    }

    parent = node;
    tree._diskRead(node.children[i], function(node){
        if(node===null) {
            return callback(false);
        }

        var isLsiblingNull = false;
        var isRsiblingNull = false;
        var rsiblingIndex = null;
        var lsiblingIndex = null;

        if(idx === parent.numberActives) {
            isRsiblingNull = true;
            lsiblingIndex = parent.children[idx-1]
            rsiblingIndex = parent.children[idx-1]
        } else if(idx === 0) {
            isLsiblingNull = true
            rsiblingIndex = parent.children[1];
            lsiblingIndex = parent.children[1];
        } else {
            lsiblingIndex = parent.children[idx-1];
            rsiblingIndex = parent.children[idx+1];
        }

        tree._diskRead(lsiblingIndex, function(lsibling){
            tree._diskRead(rsiblingIndex, function(rsibling){
                if(isRsiblingNull===true) {
                    rsibling = null;
                }
                if(isLsiblingNull===true) {
                    lsibling = null;
                }

                if(node.numberActives === (tree.order-1) && parent != null) {
                    if(rsibling != null && rsibling.numberActives > (tree.order-1)) {
                        // The current node has (t - 1) keys but the right sibling has > (t - 1) keys
                        tree._moveKey(parent,i,left, function(parent){
                            tree.__deleteSearchNode(tree,key,node,callback);
                        });
                    } else if(lsibling != null && lsibling.numberActives > (tree.order-1)) {
                        // The current node has (t - 1) keys but the left sibling has > (t - 1) keys
                        tree._moveKey(parent,i,right, function(parent){
                            tree.__deleteSearchNode(tree,key,node,callback);
                        });
                    } else if(lsibling != null && lsibling.numberActives === (tree.order-1)) {
                        // The current node has (t - 1) keys but the left sibling has (t - 1) keys
                        tree._mergeSiblings(parent,i,left,function(node) {
                            tree.__deleteSearchNode(tree,key,node,callback);
                        });
                    } else if(rsibling != null && rsibling.numberActives === (tree.order-1)){
                        // The current node has (t - 1) keys but the left sibling has (t - 1) keys
                        tree._mergeSiblings(parent,i,right,function(node) {
                            tree.__deleteSearchNode(tree,key,node,callback);
                        });
                    }
                } else {
                    tree.__deleteSearchNode(tree,key,node,callback);
                }
            });
        })
    });
};
InMemoryAsyncBTree.Tree.prototype.__deleteNodeFound = function(tree,key,node,callback) {
    //Case 1 : The node containing the key is found and is the leaf node.
    //Also the leaf node has keys greater than the minimum required.
    //Simply remove the key
    if(node.isLeaf && (node.numberActives > (tree.order-1))) {
        tree._deleteKeyFromNode(node,idx,function(){
            callback(true);
        });
        return true;
    }


    //If the leaf node is the root permit deletion even if the number of keys is
    //less than (t - 1)
    if(node.isLeaf && (node === tree.root)) {
        tree._deleteKeyFromNode(node,idx, function(){
            callback(true);
        });
        return true;
    }


    //Case 2: The node containing the key is found and is an internal node
    if(node.isLeaf === false) {
        tree._diskRead(node.children[idx], function(tmpNode) {
            if(tmpNode.numberActives > (tree.order-1)) {
                tree._getMaxKeyPos(tree,tmpNode,function(subNodeIdx){
                    key = subNodeIdx.node.keys[subNodeIdx.index];

                    node.keys[idx] = key;

                    tree._diskWrite(node,function(node){
                        node = tmpNode;
                        key = key.key;
                        tree.__deleteSearchNode(tree,key,node,callback);
                    });
                });
            } else {
                tree._diskRead(node.children[idx+1],function(tmpNode2){
                    if (tmpNode2.numberActives >(tree.order-1)) {
                        tree._getMinKeyPos(tree,tmpNode2, function(subNodeIdx){
                            key = subNodeIdx.node.keys[subNodeIdx.index];

                            node.keys[idx] = key;

                            tree._diskWrite(node,function(node){
                                node = tmpNode2;
                                key = key.key;
                                tree.__deleteSearchNode(tree,key,node,callback);
                            });
                        });
                    } else if(tmpNode.numberActives === (tree.order-1) && tmpNode2.numberActives === (tree.order-1)) {

                        tree._mergeNodes(tmpNode, node.keys[idx], tmpNode2,function(combNode){

                            node.children[idx] = combNode;

                            idx++;
                            for(var i=idx; i<node.numberActives; i++) {
          	                node.children[i] = node.children[i+1];
          	                node.keys[i-1] = node.keys[i];
                            }
                            // freeing unused references
                            node.children[i] = null;
                            node.keys[i-1] = null;

                            node.numberActives--;
                            if (node.numberActives === 0 && tree.root === node) {
                                tree.root = combNode;
                            }

                            tree._diskWrite(node, function(node){
                                tree.__deleteSearchNode(tree,key,combNode,callback);
                            });
                        });
                    }
                });
            }
        });
    } // end case 2

    // Case 3:
    // In this case start from the top of the tree and continue
    // moving to the leaf node making sure that each node that
    // we encounter on the way has atleast 't' (order of the tree)
    // keys
    if(node.isLeaf && (node.numberActives > tree.order - 1)) {
        tree._deleteKeyFromNode(node,idx, function(node){
            tree.__deleteSearchNode(tree,key,node,callback);
        });
    }
}

/**
 * _moveKey
 *
 * Move key situated at position i of the parent node
 * to the left or right child at positions i-1 and i+1
 * according to the provided position
 *
 * @param parent the node whose is going to be moved to a child
 * @param i Index of the key in the parent
 * @param position left, or right
 */
InMemoryAsyncBTree.Tree.prototype._moveKey = function(parent,i,position, callback) {

    if(position===right) {
        i--;
    }

    var that = this
    //var lchild = parent.children[i-1];
    that._diskRead(parent.children[i], function(lchild) {
        that._diskRead(parent.children[i+1],function(rchild){

            if(position == left) {
                lchild.keys[lchild.numberActives] = parent.keys[i];
                lchild.children[lchild.numberActives+1] = rchild.children[0];
                rchild.children[0] = null;
                lchild.numberActives++;

                parent.keys[i] = rchild.keys[0];

                for(var _i=1; _i<rchild.numberActives; _i++) {
                    rchild.keys[_i-1] = rchild.keys[_i];
                    rchild.children[_i-1] = rchild.children[_i];
                }
                rchild.children[rchild.numberActives-1] = rchild.children[rchild.numberActives];
                rchild.numberActives--;
            } else {
                rchild.children[rchild.numberActives+1] = rchild.children[rchild.numberActives];
                for(var _i=rchild.numberActives; _i>0; _i--) {
                    rchild.children[_i] = rchild.children[_i-1];
                    rchild.keys[_i] = rchild.keys[_i-1];
                }
                rchild.keys[0] = null;
                rchild.children[0] = null;

                rchild.children[0] = lchild.children[lchild.numberActives];
                rchild.keys[0] = parent.keys[i];
                rchild.numberActives++;

                lchild.children[lchild.numberActives] = null;
                parent.keys[i] = lchild.keys[lchild.numberActives-1];
                lchild.keys[lchild.numberActives-1] = null;
                lchild.numberActives--;
            }

            that._diskWrite(lchild, function(lchild){
                that._diskWrite(rchild, function(rchild){
                    that._diskWrite(parent, function(parent){
                        return callback(parent);
                    });
                });
            });
        });
    });
}

/**
 * _mergeSiblings
 *
 * Merges two nodes at the left and right of the provided
 * index in the parent node.
 *
 * @param parent the node whose children will be merged
 * @param i Index of the key in the parent pointing to the nodes to merge
 */
InMemoryAsyncBTree.Tree.prototype._mergeSiblings = function(parent,index,pos,callback) {
    var i,j;
    var n1, n2;
    var tolookn1, tolookn2;

    if (index === (parent.numberActives)) {
        index--;
        tolookn1 = parent.children[parent.numberActives - 1];
        tolookn2 = parent.children[parent.numberActives]
    } else {
        tolookn1 = parent.children[index];
        tolookn2 = parent.children[index + 1];
    }

    var that = this;
    that._diskRead(tolookn1, function(n1){
        that._diskRead(tolookn2, function(n2){

            //Merge the current node with the left node
            var newNode = that._allocateNode();
            newNode.isLeaf = n1.isLeaf;
            newNode.level = n1.level;

            for(j=0; j<that.order-1; j++) {
	        newNode.keys[j] = n1.keys[j];
	        newNode.children[j] = n1.children[j];
            }

            newNode.keys[that.order-1] = parent.keys[index];
            newNode.children[that.order-1] = n1.children[that.order-1];

            for(j=0; j<that.order-1; j++) {
	        newNode.keys[j+that.order] = n2.keys[j];
	        newNode.children[j+that.order] = n2.children[j];
            }
            newNode.children[2*that.order-1] = n2.children[that.order-1];

            parent.children[index] = newNode;

            for(j=index; j<parent.numberActives;j++) {
	        parent.keys[j] = parent.keys[j+1];
	        parent.children[j+1] = parent.children[j+2];
            }

            newNode.numberActives = n1.numberActives + n2.numberActives+1;
            parent.numberActives--;

            for(i=parent.numberActives; i<2*that.order-1; i++) {
	        parent.keys[i] = null;
            }

            if (parent.numberActives === 0 && that.root === parent) {
	        that.root = newNode;
	        if(newNode.level) {
	            newNode.isLeaf = false;
	        } else {
	            newNode.isLeaf = true;
                }
            }

            that._diskWrite(newNode, function(newNode){
                that._diskWrite(parent,function(parent){
                    that._diskDelete(n1,function(){
                        that._diskDelete(n2,function(){
                            if(that.root === newNode) {
                                that._updateRootNode(that.root,function(){
                                    return callback(newNode);
                                });
                            } else {
                                return callback(newNode);
                            }
                        });
                    });
                });
            });
        });
    });
};

/**
 * _deleteKeyFromNode
 *
 * Deletes the key at position index from the provided node.
 *
 * @param node The node where the key will be deleted.
 * @param index The index of the key that will be deletd.
 * @return true if the key can be deleted, false otherwise
 */
InMemoryAsyncBTree.Tree.prototype._deleteKeyFromNode = function(node,index,callback) {
    var keysMax = (2*this.order)-1;
    if(node.numberActives < keysMax) {
        keysMax = node.numberActives;
    };

    var i;

    if(node.isLeaf === false) {
	return false;
    }

    var key = node.keys[index];

    for(i=index; i<keysMax-1; i++) {
	node.keys[i] = node.keys[i+1];
    }

    // cleaning invalid reference
    node.keys.pop();

    node.numberActives--;

    this._diskWrite(node,function(node){
        return callback(node);
    });
}

InMemoryAsyncBTree.Tree.prototype._mergeNodes = function(n1, key, n2, callback) {
    var newNode;
    var i;

    newNode = this._allocateNode();
    newNode.isLeaf = true;

    for(i=0; i<n1.numberActives; i++) {
	newNode.keys[i]   = n1.keys[i];
        newNode.children[i]   = n1.children[i];
    }
    newNode.children[n1.numberActives] = n1.children[n1.numberActives];
    newNode.keys[n1.numberActives] = key;

    for(i=0; i<n2.numberActives; i++) {
	newNode.keys[i+n1.numberActives+1] = n2.keys[i];
        newNode.children[i+n1.numberActives+1] = n2.children[i];
    }
    newNode.children[(2*this.order)-1] = n2.children[n2.numberActives];

    newNode.numberActives = n1.numberActives + n2.numberActives + 1;
    newNode.isLeaf = n1.isLeaf;
    newNode.level = n1.level;


    var that = this;
    this._diskWrite(newNode, function(newNode){
        that._diskDelete(n1, function(){
            that._diskDelete(n2, function(){
                return callback(newNode);
            });
        })
    });
};

/**
 * audit
 *
 * Checks that the tree data structure is
 * valid.
 */
InMemoryAsyncBTree.Tree.prototype.audit = function(showOutput) {
    var errors = [];
    var alreadySeen = [];
    var that = this;

    var foundInArray = function(data) {
        for(var i=0; i<alreadySeen.length; i++) {
            if(that.comparator(alreadySeen[i],data)===0) {
                var error = " !!! duplicated key " + data;
                if(showOutput===true) {
                    console.log(error);
                }
                errors.push(error);
            }
        }
    };

    var length = null;
    var that = this;
    this.walkNodes(function(n) {
        if(showOutput === true) {
          console.log("--- Node at "+ n.level + " level");
          console.log(" - leaf? " + n.isLeaf);
          console.log(" - num actives? " + n.numberActives);
          console.log(" - keys: ");
        }
        for(var i = n.numberActives ; i<n.keys.length; i++) {
            if(n.keys[i] != null) {
                if(showOutput===true) {
                    console.log(" * warning : redundant key data");
                    errors.push(" * warning : redundant key data");
                }
            }
        }

        for(var i = n.numberActives+1 ; i<n.children.length; i++) {
            if(n.children[i] != null) {
                if(showOutput===true) {
                    console.log(" * warning : redundant children data");
                    errors.push(" * warning : redundant key data");
                }
            }
        }


        if(n.isLeaf === false) {
          for(var i=0; i<n.numberActives; i++) {
              var maxLeft = this._diskRead(n.children[i]).keys[this._diskRead(n.children[i]).numberActives -1 ].key
              var minRight = this._diskRead(n.children[i+1]).keys[0].key
              if(showOutput===true) {
                  console.log("   "+n.keys[i].key + "(" + maxLeft + "," + minRight+ ")");
              }
              if(that.comparator(n.keys[i].key,maxLeft)===-1) {
                  var error = " !!! value max left " + maxLeft + " > key " + n.keys[i].key;
                  if(showOutput===true) {
                      console.log(error);
                  }
                  errors.push(error);
              }
              if(that.comparator(n.keys[i].key,minRight)===1) {
                  var error = " !!! value min right " + minRight + " < key " + n.keys[i].key;
                  if(showOutput===true) {
                      console.log(error);
                  }
                  errors.push(error);
              }

              foundInArray(n.keys[i].key);
              alreadySeen.push(n.keys[i].key);
          }
        } else {
            if(length === null) {
                length = n.level;
            } else {
                if(length != n.level) {
                    var error = " !!! Leaf node with wrong level value";
                    if(showOutput===true) {
                        console.log(error);
                    }
                    errors.push(error);
                }
            }
            for(var i=0 ; i<n.numberActives; i++) {
                if(showOutput===true) {
                    console.log(" "+n.keys[i].key);
                }
                foundInArray(n.keys[i].key);
                alreadySeen.push(n.keys[i].key);

            }
        }

        if(n != that.root) {
            if(n.numberActives > ((2*that.order) -1)) {
                if(showOutput===true) {
                    var error = " !!!! MAX num keys restriction violated ";
                }
                console.log(error);
                errors.push(error);
            }
            if(n.numberActives < (that.order -1)) {
                if(showOutput===true) {
                    var error = " !!!! MIN num keys restriction violated ";
                }
                console.log(error);
                errors.push(error);
            }

        }
    });

    return errors;
}

/**
 *  _getMaxKeyPos
 *
 *  Used to get the position of the MAX key within the subtree
 *  @return An object containing the key and position of the key
 */
InMemoryAsyncBTree.Tree.prototype._getMaxKeyPos = function(tree,node,callback) {
    var node_pos = {};

    if(node === null) {
	return callback(null);
    }

    if(node.isLeaf === true) {
	node_pos.node  = node;
	node_pos.index = node.numberActives - 1;
	return callback(node_pos);
    } else {
	node_pos.node  = node;
	node_pos.index = node.numberActives - 1;
	tree._diskRead(node.children[node.numberActives],function(node){
            return tree._getMaxKeyPos(tree,node,callback);
        });
    }
}

/**
 *  _getMinKeyPos
 *
 *  Used to get the position of the MAX key within the subtree
 *  @return An object containing the key and position of the key
 */
InMemoryAsyncBTree.Tree.prototype._getMinKeyPos = function(tree,node,callback) {
    var node_pos = {};

    if(node === null) {
        callback(null);
    }

    if(node.isLeaf === true) {
	node_pos.node  = node;
	node_pos.index = 0;
        return callback(node_pos);
    } else {
	node_pos.node  = node;
	node_pos.index = 0;
	tree._diskRead(node.children[0], function(node){
            return tree._getMinKeyPos(tree,node, callback);
        });
    }
}


/**
 * Node
 *
 * Implements the interface of BinarySearchTree.Node
 *
 * A Tree node augmented with BTree
 * node structures
 */
InMemoryAsyncBTree.Node = function() {
    this.numberActives = 0;
    this.isLeaf = null;
    this.keys = [];
    this.children = [];
    this.level = 0;
};

// end of ./src/js-trees/src/in_memory_async_b_tree.js 
// exports
var QuadIndexCommon = {};

/**
 * NodeKey
 *
 * Implements the interface of BinarySearchTree.Node
 *
 * A Tree node augmented with BPlusTree
 * node structures
 */
QuadIndexCommon.NodeKey = function(components, order) {
    this.subject = components.subject;
    this.predicate = components.predicate;
    this.object = components.object;
    this.graph = components.graph;
    this.order = order;
};

QuadIndexCommon.NodeKey.prototype.comparator = function(keyPattern) {
    for(var i=0; i<this.order.length; i++) {
        var component = this.order[i];
        if(keyPattern[component] == null) {
            return 0;
        } else {
            if(this[component] < keyPattern[component] ) {
                return -1
            } else if(this[component] > keyPattern[component]) {
                return 1
            }
        }
    }

    return 0;
};

/**
 * Pattern
 *
 * A pattern with some variable components
 */
QuadIndexCommon.Pattern = function(components) {
    this.subject = components.subject;
    this.predicate = components.predicate;
    this.object = components.object;
    this.graph = components.graph;
    this.indexKey = [];

    this.keyComponents = {}

    var ks,ko,kp;
    var order = [];
    var indif = [];
    var components = ['subject', 'predicate', 'object', 'graph'];

    // components must have been already normalized and
    // inserted in the lexicon.
    // OIDs retrieved from the lexicon *are* numbers so
    // they can be told apart from variables (strings)
    for(var i=0; i<components.length; i++) {
        if(typeof(this[components[i]]) === 'string') {
            indif.push(components[i]);
            this.keyComponents[components[i]] = null;
        } else {
            order.push(components[i]);
            this.keyComponents[components[i]] = this[components[i]];
            this.indexKey.push(components[i]);
        }
    }

    this.order = order.concat(indif);
    this.key = new QuadIndexCommon.NodeKey(this.keyComponents, this.order);
}

// end of ./src/js-rdf-persistence/src/quad_index_common.js 
// exports
var QuadIndex = {};

// imports
var BaseTree = InMemoryAsyncBTree;

QuadIndex.Tree = function(params,callback) {
    if(arguments != 0) {
        this.componentOrder = params.componentOrder;

        // @todo change this if using the file backed implementation
        BaseTree.Tree.call(this, params.order, function(tree){
            tree.comparator = function(a,b) {
                for(var i=0; i< tree.componentOrder.length; i++) {
                    var component = tree.componentOrder[i];

                    var vala = a[component];
                    var valb = b[component];

                    if(vala < valb) {
                        return -1;
                    } else if(vala > valb) {
                        return 1;
                    }
                }

                return 0;
            }

            tree.rangeComparator = function(a,b) {
                for(var i=0; i<tree.componentOrder.length; i++) {
                    var component = tree.componentOrder[i];
                    if(b[component] == null || a[component]==null) {
                        return 0;
                    } else {
                        if(a[component] < b[component] ) {
                            return -1
                        } else if(a[component] > b[component]) {
                            return 1
                        }
                    }
                }

                return 0;
            }
            callback(tree);
        });
    }
}

Utils['extends'](BaseTree.Tree, QuadIndex.Tree);

QuadIndex.Tree.prototype.insert = function(quad, callback) {
    BaseTree.Tree.prototype.insert.call(this, quad, null, function(result){
        callback(result);
    });
};

QuadIndex.Tree.prototype.search = function(quad, callback) {
    BaseTree.Tree.prototype.search.call(this, quad, function(result){
        callback(result);
    }, true); // true -> check exists : hack only present in the inMemoryAsyncBTree implementation
};

QuadIndex.Tree.prototype.range = function(pattern, callback) {
    this._rangeTraverse(this,this.root, pattern, callback);
}

QuadIndex.Tree.prototype._rangeTraverse = function(tree,node, pattern, callback) {
    var patternKey  = pattern.key;
    var acum = [];
    var pendingNodes = [node];

    Utilsmeanwhile(pendingNodes.length > 0, function(k,em){
        var mainLoopf = arguments.callee;
        var node = pendingNodes.shift();
        var idxMin = 0;

        while(idxMin < node.numberActives && tree.rangeComparator(node.keys[idxMin].key,patternKey) === -1) {
            idxMin++;
        }
        if(node.isLeaf === true) {
            var idxMax = idxMin;

            while(idxMax < node.numberActives && tree.rangeComparator(node.keys[idxMax].key,patternKey) === 0) {
                acum.push(node.keys[idxMax].key);
                idxMax++;
            }

            if(pendingNodes.length === 0) {
                k(false,mainLoopf,em);
            } else {
                k(true,mainLoopf,em);
            }
        } else {
            tree._diskRead(node.children[idxMin], function(childNode){
                pendingNodes.push(childNode);

                Utilsmeanwhile(true,
                            function(kk,e){
                                var loopf = arguments.callee;
                                if(e.idxMax < node.numberActives && tree.rangeComparator(node.keys[e.idxMax].key,patternKey) === 0) {
                                    acum.push(node.keys[e.idxMax].key);
                                    e.idxMax++;
                                    tree._diskRead(node.children[e.idxMax], function(childNode){
                                        pendingNodes.push(childNode);
                                        kk(true,loopf,e);
                                    })
                                } else {
                                    kk(false,loopf,e);
                                }
                            },
                            function(e){
                                if(pendingNodes.length===0) {
                                    k(false,mainLoopf,em);
                                } else {
                                    k(true,mainLoopf,em);
                                }
                            },
                            {idxMax: idxMin});
            })
        }
    }, function(e) {
        callback(acum);
    })
};

// end of ./src/js-rdf-persistence/src/quad_index.js 
// exports
var QuadBackend = {};


// imports


/*
 * "perfect" indices for RDF indexing
 *
 * SPOG (?, ?, ?, ?), (s, ?, ?, ?), (s, p, ?, ?), (s, p, o, ?), (s, p, o, g)
 * GP   (?, ?, ?, g), (?, p, ?, g)
 * OGS  (?, ?, o, ?), (?, ?, o, g), (s, ?, o, g)
 * POG  (?, p, ?, ?), (?, p, o, ?), (?, p, o, g)
 * GSP  (s, ?, ?, g), (s, p, ?, g)
 * OS   (s, ?, o, ?)
 */
QuadBackend.QuadBackend = function(configuration, callback) {
    if(arguments!=0) {
        this.indexMap = {};
        this.treeOrder = configuration['treeOrder']
        this.indices = ['SPOG', 'GP', 'OGS', 'POG', 'GSP', 'OS'];
        this.componentOrders = {
            SPOG: ['subject', 'predicate', 'object', 'graph'],
            GP: ['graph', 'predicate', 'subject', 'object'],
            OGS: ['object', 'graph', 'subject', 'predicate'],
            POG: ['predicate', 'object', 'graph', 'subject'],
            GSP: ['graph', 'subject', 'predicate', 'object'],
            OS: ['object', 'subject', 'predicate', 'graph']
        }
        var that = this;
        Utils.repeat(0, this.indices.length,function(k,e) {
            var indexKey = that.indices[e._i];
            var floop = arguments.callee;
            new QuadIndex.Tree({order: that.treeOrder,
                                componentOrder: that.componentOrders[indexKey]},
                               function(tree){
                                   that.indexMap[indexKey] = tree;
                                   k(floop,e);
                               });
        }, function(e) {
            callback(that);
        });
    }
}

QuadBackend.QuadBackend.prototype._indexForPattern = function(pattern) {
    var indexKey = pattern.indexKey;
    var matchingIndices = this.indices;

    for(var i=0; i<matchingIndices.length; i++) {
        var index = matchingIndices[i];
        var indexComponents = this.componentOrders[index]
        for(var j=0; j<indexComponents.length; j++) {
            if(Utils.include(indexKey, indexComponents[j])===false) {
                break;
            }
            if(j==indexKey.length-1) {
                return index;
            }
        }
    }
    
    return 'SPOG' // If no other match, we erturn the more generic index
}


QuadBackend.QuadBackend.prototype.index = function(quad, callback) {
    var that = this;

    Utils.repeat(0, this.indices.length,function(k,e) {
        var indexKey = that.indices[e._i];
        var index= that.indexMap[indexKey];
        var floop = arguments.callee;

        index.insert(quad, function(result){
            k(floop, e);
        });
    }, function(e) {
        callback(true);
    });
}

QuadBackend.QuadBackend.prototype.range = function(pattern, callback)  {
    var indexKey = this._indexForPattern(pattern);
    var index = this.indexMap[indexKey];
    index.range(pattern, function(quads){
        callback(quads);
    });
}

QuadBackend.QuadBackend.prototype.search = function(quad, callback)  {
    var indexKey = this.indices[0];
    var index= this.indexMap[indexKey];

    index.search(quad, function(result){
        callback(result!=null);
    });
}


QuadBackend.QuadBackend.prototype['delete'] = function(quad, callback) {
    var that = this;

    Utils.repeat(0, this.indices.length,function(k,e) {
        var indexKey = that.indices[e._i];
        var index= that.indexMap[indexKey];
        var floop = arguments.callee;

        index['delete'](quad, function(result){
            k(floop, e);
        });
    }, function(e) {
        callback(that);
    });
}

// end of ./src/js-rdf-persistence/src/quad_backend.js 
// exports
var Lexicon = {};

// imports

/**
 * Temporal implementation of the lexicon
 */


Lexicon.Lexicon = function(callback){
    this.uriToOID = {};
    this.OIDToUri = {};

    this.literalToOID = {};
    this.OIDToLiteral = {};

    this.blankToOID = {};
    this.OIDToBlank = {};

    this.defaultGraphOid = 0;

    this.defaultGraphUri = "https://github.com/antoniogarrote/rdfstore-js#default_graph";
    this.defaultGraphUriTerm = {"token": "uri", "prefix": null, "suffix": null, "value": this.defaultGraphUri, "oid": this.defaultGraphOid};
    this.oidCounter = 1;

    this.knownGraphs = {};
    
    if(callback != null) {
        callback(this);
    }
};

Lexicon.Lexicon.prototype.registerGraph = function(oid, callback){
    if(oid != this.defaultGraphOid) {
        this.knownGraphs[oid] = true;
    }
    callback(true);
};

Lexicon.Lexicon.prototype.registeredGraphs = function(shouldReturnUris,callback) {
    var acum = [];

    for(var g in this.knownGraphs) {
        if(shouldReturnUris === true) {
            acum.push(this.OIDToUri['u'+g]);
        } else {
            acum.push(g);
        }
    }
    callback(true, acum);
};

Lexicon.Lexicon.prototype.registerUri = function(uri, callback) {
    if(uri === this.defaultGraphUri) {
        callback(this.defaultGraphOid);
    } else if(this.uriToOID[uri] == null){
        var oid = this.oidCounter
        var oidStr = 'u'+oid;
        this.oidCounter++;

        this.uriToOID[uri] =[oid, 0];
        this.OIDToUri[oidStr] = uri;

        callback(oid);
    } else {
        var oidCounter = this.uriToOID[uri];
        var oid = oidCounter[0];
        var counter = oidCounter[1] + 1;
        this.uriToOID[uri] = [oid, counter];
        callback(oid);
    }
};

Lexicon.Lexicon.prototype.resolveUri = function(uri, callback) {
    if(uri === this.defaultGraphUri) {
        callback(this.defaultGraphOid);
    } else {
        var oidCounter = this.uriToOID[uri];
        if(oidCounter != null) {
            callback(oidCounter[0]);
        } else {
            callback(-1);
        }
    }
};

Lexicon.Lexicon.prototype.registerBlank = function(label, callback) {
    var oid = this.oidCounter;
    this.oidCounter++;
    var oidStr = ""+oid;
    this.OIDToBlank[oidStr] = true;
    callback(oidStr);
};

Lexicon.Lexicon.prototype.resolveBlank = function(label, callback) {
//    @todo
//    this is failing with unicode tests... e.g. kanji2

//    var id = label.split(":")[1];
//    callback(id);

    var oid = this.oidCounter;
    this.oidCounter++
    callback(""+oid);
};

Lexicon.Lexicon.prototype.registerLiteral = function(literal, callback) {
    if(this.literalToOID[literal] == null){
        var oid = this.oidCounter;
        var oidStr =  'l'+ oid;
        this.oidCounter++;

        this.literalToOID[literal] = [oid, 0];
        this.OIDToLiteral[oidStr] = literal;

        callback(oid);
    } else {
        var oidCounter = this.literalToOID[literal];
        var oid = oidCounter[0];
        var counter = oidCounter[1] + 1;
        this.literalToOID[literal] = [oid, counter];
        callback(oid);
    }
};

Lexicon.Lexicon.prototype.resolveLiteral = function(literal, callback) {
    var oidCounter = this.literalToOID[literal];
    if(oidCounter != null ) {
        callback(oidCounter[0]); 
    } else {
        callback(-1); 
    }
}

Lexicon.Lexicon.prototype.parseLiteral = function(literalString) {
    var parts = literalString.lastIndexOf("@");
    if(parts!=-1 && literalString[parts-1]==='"') {
        var value = literalString.substring(1,parts-1);
        var lang = literalString.substring(parts+1, literalString.length);
        return {token: "literal", value:value, lang:lang};
    }

    var parts = literalString.lastIndexOf("^^");
    if(parts!=-1 && literalString[parts-1]==='"' && literalString[parts+2] === '<' && literalString[literalString.length-1] === '>') {
        var value = literalString.substring(1,parts-1);
        var type = literalString.substring(parts+3, literalString.length-1);

        return {token: "literal", value:value, type:type};
    }

    var value = literalString.substring(1,literalString.length-1);
    return {token:"literal", value:value};
};

Lexicon.Lexicon.prototype.parseUri = function(uriString) {
    return {token: "uri", value:uriString};
};

Lexicon.Lexicon.prototype.retrieve = function(oid,callback) {
    try {
        if(oid === this.defaultGraphOid) {
            callback({ token: "uri", 
                       value:this.defaultGraphUri,
                       prefix: null,
                       suffix: null,
                       defaultGraph: true });
        } else {
          var maybeUri = this.OIDToUri['u'+oid];
          if(maybeUri) {
              callback(this.parseUri(maybeUri));
          } else {
              var maybeLiteral = this.OIDToLiteral['l'+oid];
              if(maybeLiteral) {
                  callback(this.parseLiteral(maybeLiteral));
              } else {
                  var maybeBlank = this.OIDToBlank[""+oid];
                  if(maybeBlank) {
                      callback({token:"blank", value:"_:"+oid});
                  } else {
                      throw("Null value for OID");
                  }
              }
          }
        }
    } catch(e) {
        console.log("error in lexicon retrieving OID:");
        console.log(oid);
        if(e.message) {
            console.log(e.message); 
        }
        if(e.stack) {
            console.log(e.stack);
        }
        throw new Error("Unknown retrieving OID in lexicon:"+oid);

    }
};


Lexicon.Lexicon.prototype.unregister = function(quad, key,callback) {
    try {
        this.unregisterTerm(quad.subject.token, key.subject);
        this.unregisterTerm(quad.predicate.token, key.predicate);
        this.unregisterTerm(quad.object.token, key.object);
        if(quad.graph!=null) {
            this.unregisterTerm(quad.graph.token, key.graph); 
        }
        callback(true);
    } catch(e) {
        console.log("Error unregistering quad");
        console.log(e.message);
        callback(false);
    }
}

Lexicon.Lexicon.prototype.unregisterTerm = function(kind, oid) {
    if(kind === 'uri') {
        if(oid != this.defaultGraphOid) {
            var oidStr = 'u'+oid;
            var uri = this.OIDToUri[oidStr];     // = uri;
            var oidCounter = this.uriToOID[uri]; // =[oid, 0];
            
            var counter = oidCounter[1];
            if(""+oidCounter[0] === ""+oid) {
                if(counter === 0) {
                    delete this.OIDToUri[oidStr];
                    delete this.uriToOID[uri];
                    // delete the graph oid from known graphs
                    // in case this URI is a graph identifier
                    delete this.knownGraphs[oid];
                } else {
                    this.uriToOID[uri] = [oid, counter-1];
                }
            } else {
                throw("Not matching OID : "+oid+" vs "+ oidCounter[0]);
            }
        }
    } else if(kind === 'literal') {
        this.oidCounter++;
        var oidStr     =  'l'+ oid;
        var literal    = this.OIDToLiteral[oidStr];  // = literal;
        var oidCounter = this.literalToOID[literal]; // = [oid, 0];
        
        var counter = oidCounter[1];
        if(""+oidCounter[0] === ""+oid) {
            if(counter === 0) {
                delete this.OIDToLiteral[oidStr];
                delete this.literalToOID[literal];
            } else {
                this.literalToOID[literal] = [oid, counter-1];
            }
        } else {
            throw("Not matching OID : "+oid+" vs "+ oidCounter[0]);
        }

    } else if(kind === 'blank') {
        delete this.OIDToBlank[""+oid];
    }
}

// end of ./src/js-rdf-persistence/src/lexicon.js 
// exports
var NetworkTransport = {};

NetworkTransport.load = function(uri, accept, callback, redirect) {
    var transport = jQuery;

    transport.ajax({
        url: uri,
        headers: {"Accepts": accept},

        success: function(data, status, xhr){
            if((""+xhr.status)[0] == '2') {
                var headers = xhr.getAllResponseHeaders().split("\n");
                var acum = {};
                for(var i=0; i<headers.length; i++) {
                    var header = headers[i].split(":");
                    acum[header[0]] = header[1];
                }

                callback(true, {headers: acum, 
                                data: data});
            }
        },

        error: function(xhr, textStatus, ex){
            if((""+xhr.status)[0] == '3'){                            
                if(redirection == 0) {
                    callback(false, 500);
                } else {
                    var location = (xhr.getAllResponseHeaders()["Location"] || xhr.getAllResponseHeaders()["location"])
                    if(location != null) {
                        NetworkTransport.load(location, accept, callback, (redirection -1));
                    } else {
                        callback(false, 500);
                    }
                } 
            } else {
                callback(false, xhr.statusCode());
            }
        }
    });
}

// end of ./src/js-communication/src/ajax_transport.js 
// exports
var TurtleParser = {};

var statementCounter = 0;
var timer = new Date().getTime();
var printTime = function() {
    var newTimer = new Date().getTime();
    console.log("ellapsed: "+((newTimer-timer)/1000)+" secs");
    timer = newTimer;
};

// imports

TurtleParser.parser = (function(){
  /* Generated by PEG.js 0.6.1 (http://pegjs.majda.cz/). */
  
  var result = {
    /*
     * Parses the input with a generated parser. If the parsing is successfull,
     * returns a value explicitly or implicitly specified by the grammar from
     * which the parser was generated (see |PEG.buildParser|). If the parsing is
     * unsuccessful, throws |PEG.parser.SyntaxError| describing the error.
     */
    innerParse: function(input, startRule) {
      var parseFunctions = {
        "ANON": parse_ANON,
        "BLANK_NODE_LABEL": parse_BLANK_NODE_LABEL,
        "BlankNode": parse_BlankNode,
        "BlankNodePropertyList": parse_BlankNodePropertyList,
        "BooleanLiteral": parse_BooleanLiteral,
        "COMMENT": parse_COMMENT,
        "Collection": parse_Collection,
        "DECIMAL": parse_DECIMAL,
        "DECIMAL_NEGATIVE": parse_DECIMAL_NEGATIVE,
        "DECIMAL_POSITIVE": parse_DECIMAL_POSITIVE,
        "DOUBLE": parse_DOUBLE,
        "DOUBLE_NEGATIVE": parse_DOUBLE_NEGATIVE,
        "DOUBLE_POSITIVE": parse_DOUBLE_POSITIVE,
        "ECHAR": parse_ECHAR,
        "EXPONENT": parse_EXPONENT,
        "GraphNode": parse_GraphNode,
        "GraphTerm": parse_GraphTerm,
        "INTEGER": parse_INTEGER,
        "INTEGER_NEGATIVE": parse_INTEGER_NEGATIVE,
        "INTEGER_POSITIVE": parse_INTEGER_POSITIVE,
        "IRI_REF": parse_IRI_REF,
        "IRIref": parse_IRIref,
        "LANGTAG": parse_LANGTAG,
        "NIL": parse_NIL,
        "NumericLiteral": parse_NumericLiteral,
        "NumericLiteralNegative": parse_NumericLiteralNegative,
        "NumericLiteralPositive": parse_NumericLiteralPositive,
        "NumericLiteralUnsigned": parse_NumericLiteralUnsigned,
        "ObjectList": parse_ObjectList,
        "PNAME_LN": parse_PNAME_LN,
        "PNAME_NS": parse_PNAME_NS,
        "PN_CHARS": parse_PN_CHARS,
        "PN_CHARS_BASE": parse_PN_CHARS_BASE,
        "PN_CHARS_U": parse_PN_CHARS_U,
        "PN_LOCAL": parse_PN_LOCAL,
        "PN_PREFIX": parse_PN_PREFIX,
        "PathAlternative": parse_PathAlternative,
        "PathElt": parse_PathElt,
        "PathEltOrInverse": parse_PathEltOrInverse,
        "PathMod": parse_PathMod,
        "PathNegatedPropertySet": parse_PathNegatedPropertySet,
        "PathOneInPropertySet": parse_PathOneInPropertySet,
        "PathPrimary": parse_PathPrimary,
        "PathSequence": parse_PathSequence,
        "PrefixedName": parse_PrefixedName,
        "PropertyList": parse_PropertyList,
        "PropertyListNotEmpty": parse_PropertyListNotEmpty,
        "PropertyListNotEmptyPath": parse_PropertyListNotEmptyPath,
        "PropertyListPath": parse_PropertyListPath,
        "RDFLiteral": parse_RDFLiteral,
        "STRING_LITERAL1": parse_STRING_LITERAL1,
        "STRING_LITERAL2": parse_STRING_LITERAL2,
        "STRING_LITERAL_LONG1": parse_STRING_LITERAL_LONG1,
        "STRING_LITERAL_LONG2": parse_STRING_LITERAL_LONG2,
        "String": parse_String,
        "TriplesBlock": parse_TriplesBlock,
        "TriplesNode": parse_TriplesNode,
        "TriplesSameSubject": parse_TriplesSameSubject,
        "VAR1": parse_VAR1,
        "VAR2": parse_VAR2,
        "VARNAME": parse_VARNAME,
        "Var": parse_Var,
        "VarOrIRIref": parse_VarOrIRIref,
        "VarOrTerm": parse_VarOrTerm,
        "Verb": parse_Verb,
        "VerbPath": parse_VerbPath,
        "WS": parse_WS,
        "base": parse_base,
        "directive": parse_directive,
        "prefixID": parse_prefixID,
        "statement": parse_statement,
        "turtleDoc": parse_turtleDoc
      };
      
      if (startRule !== undefined) {
        if (parseFunctions[startRule] === undefined) {
          throw new Error("Invalid rule name: " + quote(startRule) + ".");
        }
      } else {
        startRule = "turtleDoc";
      }
      
      var pos = 0;
      var reportMatchFailures = true;
      var rightmostMatchFailuresPos = 0;
      var rightmostMatchFailuresExpected = [];
      var cache = {};
      
      function padLeft(input, padding, length) {
        var result = input;
        
        var padLength = length - input.length;
        for (var i = 0; i < padLength; i++) {
          result = padding + result;
        }
        
        return result;
      }
      
      function escape(ch) {
        var charCode = ch.charCodeAt(0);
        
        if (charCode <= 0xFF) {
          var escapeChar = 'x';
          var length = 2;
        } else {
          var escapeChar = 'u';
          var length = 4;
        }
        
        return '\\' + escapeChar + padLeft(charCode.toString(16).toUpperCase(), '0', length);
      }
      
      function quote(s) {
        /*
         * ECMA-262, 5th ed., 7.8.4: All characters may appear literally in a
         * string literal except for the closing quote character, backslash,
         * carriage return, line separator, paragraph separator, and line feed.
         * Any character may appear in the form of an escape sequence.
         */
        return '"' + s
          .replace(/\\/g, '\\\\')            // backslash
          .replace(/"/g, '\\"')              // closing quote character
          .replace(/\r/g, '\\r')             // carriage return
          .replace(/\n/g, '\\n')             // line feed
          .replace(/[\x80-\uFFFF]/g, escape) // non-ASCII characters
          + '"';
      }
      
      function matchFailed(failure) {
        if (pos < rightmostMatchFailuresPos) {
          return;
        }
        
        if (pos > rightmostMatchFailuresPos) {
          rightmostMatchFailuresPos = pos;
          rightmostMatchFailuresExpected = [];
        }
        
        rightmostMatchFailuresExpected.push(failure);
      }
      
      function parse_turtleDoc() {
        var cacheKey = 'turtleDoc@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        
        var result1 = [];
        var result2 = parse_statement();
        while (result2 !== null) {
          result1.push(result2);
          var result2 = parse_statement();
        }
        var result0 = result1 !== null
          ? (function(sts) {
                  return sts;
              })(result1)
          : null;
        
        
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_statement() {
          statementCounter++;
          if(statementCounter % 1000 == 0) {
              console.log(""+statementCounter);
              printTime();
          }
        var cacheKey = 'statement@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        
        var savedPos1 = pos;
        var result12 = [];
        var result19 = parse_WS();
        while (result19 !== null) {
          result12.push(result19);
          var result19 = parse_WS();
        }
        if (result12 !== null) {
          var result13 = parse_directive();
          if (result13 !== null) {
            var result14 = [];
            var result18 = parse_WS();
            while (result18 !== null) {
              result14.push(result18);
              var result18 = parse_WS();
            }
            if (result14 !== null) {
              if (input.substr(pos, 1) === ".") {
                var result15 = ".";
                pos += 1;
              } else {
                var result15 = null;
                if (reportMatchFailures) {
                  matchFailed("\".\"");
                }
              }
              if (result15 !== null) {
                var result16 = [];
                var result17 = parse_WS();
                while (result17 !== null) {
                  result16.push(result17);
                  var result17 = parse_WS();
                }
                if (result16 !== null) {
                  var result11 = [result12, result13, result14, result15, result16];
                } else {
                  var result11 = null;
                  pos = savedPos1;
                }
              } else {
                var result11 = null;
                pos = savedPos1;
              }
            } else {
              var result11 = null;
              pos = savedPos1;
            }
          } else {
            var result11 = null;
            pos = savedPos1;
          }
        } else {
          var result11 = null;
          pos = savedPos1;
        }
        var result10 = result11 !== null
          ? (function(d) {
                  return d;
              })(result11[1])
          : null;
        if (result10 !== null) {
          var result0 = result10;
        } else {
          var savedPos0 = pos;
          var result5 = [];
          var result9 = parse_WS();
          while (result9 !== null) {
            result5.push(result9);
            var result9 = parse_WS();
          }
          if (result5 !== null) {
            var result6 = parse_TriplesBlock();
            if (result6 !== null) {
              var result7 = [];
              var result8 = parse_WS();
              while (result8 !== null) {
                result7.push(result8);
                var result8 = parse_WS();
              }
              if (result7 !== null) {
                var result4 = [result5, result6, result7];
              } else {
                var result4 = null;
                pos = savedPos0;
              }
            } else {
              var result4 = null;
              pos = savedPos0;
            }
          } else {
            var result4 = null;
            pos = savedPos0;
          }
          var result3 = result4 !== null
            ? (function(ts) {
                    return ts;
                })(result4[1])
            : null;
          if (result3 !== null) {
            var result0 = result3;
          } else {
            var result2 = parse_WS();
            if (result2 !== null) {
              var result1 = [];
              while (result2 !== null) {
                result1.push(result2);
                var result2 = parse_WS();
              }
            } else {
              var result1 = null;
            }
            if (result1 !== null) {
              var result0 = result1;
            } else {
              var result0 = null;;
            };
          };
        }
        
        
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_directive() {
        var cacheKey = 'directive@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        
        var result2 = parse_prefixID();
        if (result2 !== null) {
          var result0 = result2;
        } else {
          var result1 = parse_base();
          if (result1 !== null) {
            var result0 = result1;
          } else {
            var result0 = null;;
          };
        }
        
        
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_base() {
        var cacheKey = 'base@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        
        var savedPos0 = pos;
        var result2 = [];
        var result7 = parse_WS();
        while (result7 !== null) {
          result2.push(result7);
          var result7 = parse_WS();
        }
        if (result2 !== null) {
          if (input.substr(pos, 5) === "@base") {
            var result3 = "@base";
            pos += 5;
          } else {
            var result3 = null;
            if (reportMatchFailures) {
              matchFailed("\"@base\"");
            }
          }
          if (result3 !== null) {
            var result6 = parse_WS();
            if (result6 !== null) {
              var result4 = [];
              while (result6 !== null) {
                result4.push(result6);
                var result6 = parse_WS();
              }
            } else {
              var result4 = null;
            }
            if (result4 !== null) {
              var result5 = parse_IRI_REF();
              if (result5 !== null) {
                var result1 = [result2, result3, result4, result5];
              } else {
                var result1 = null;
                pos = savedPos0;
              }
            } else {
              var result1 = null;
              pos = savedPos0;
            }
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        var result0 = result1 !== null
          ? (function(i) {
                registerDefaultPrefix(i);
          
                base = {};
                base.token = 'base';
                base.value = i;
          
                return base;
          })(result1[3])
          : null;
        
        
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_prefixID() {
        var cacheKey = 'prefixID@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        
        var savedPos0 = pos;
        var result2 = [];
        var result12 = parse_WS();
        while (result12 !== null) {
          result2.push(result12);
          var result12 = parse_WS();
        }
        if (result2 !== null) {
          if (input.substr(pos, 7) === "@prefix") {
            var result3 = "@prefix";
            pos += 7;
          } else {
            var result3 = null;
            if (reportMatchFailures) {
              matchFailed("\"@prefix\"");
            }
          }
          if (result3 !== null) {
            var result11 = parse_WS();
            if (result11 !== null) {
              var result4 = [];
              while (result11 !== null) {
                result4.push(result11);
                var result11 = parse_WS();
              }
            } else {
              var result4 = null;
            }
            if (result4 !== null) {
              var result10 = parse_PN_PREFIX();
              var result5 = result10 !== null ? result10 : '';
              if (result5 !== null) {
                if (input.substr(pos, 1) === ":") {
                  var result6 = ":";
                  pos += 1;
                } else {
                  var result6 = null;
                  if (reportMatchFailures) {
                    matchFailed("\":\"");
                  }
                }
                if (result6 !== null) {
                  var result7 = [];
                  var result9 = parse_WS();
                  while (result9 !== null) {
                    result7.push(result9);
                    var result9 = parse_WS();
                  }
                  if (result7 !== null) {
                    var result8 = parse_IRI_REF();
                    if (result8 !== null) {
                      var result1 = [result2, result3, result4, result5, result6, result7, result8];
                    } else {
                      var result1 = null;
                      pos = savedPos0;
                    }
                  } else {
                    var result1 = null;
                    pos = savedPos0;
                  }
                } else {
                  var result1 = null;
                  pos = savedPos0;
                }
              } else {
                var result1 = null;
                pos = savedPos0;
              }
            } else {
              var result1 = null;
              pos = savedPos0;
            }
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        var result0 = result1 !== null
          ? (function(p, l) {
          
                registerPrefix(p,l);
          
                prefix = {};
                prefix.token = 'prefix';
                prefix.prefix = p;
                prefix.local = l;
          
                return prefix;
          })(result1[3], result1[6])
          : null;
        
        
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_TriplesBlock() {
        var cacheKey = 'TriplesBlock@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        var result2 = parse_TriplesSameSubject();
        if (result2 !== null) {
          var savedPos1 = pos;
          var result5 = [];
          var result9 = parse_WS();
          while (result9 !== null) {
            result5.push(result9);
            var result9 = parse_WS();
          }
          if (result5 !== null) {
            if (input.substr(pos, 1) === ".") {
              var result6 = ".";
              pos += 1;
            } else {
              var result6 = null;
              if (reportMatchFailures) {
                matchFailed("\".\"");
              }
            }
            if (result6 !== null) {
              var result8 = parse_TriplesBlock();
              var result7 = result8 !== null ? result8 : '';
              if (result7 !== null) {
                var result4 = [result5, result6, result7];
              } else {
                var result4 = null;
                pos = savedPos1;
              }
            } else {
              var result4 = null;
              pos = savedPos1;
            }
          } else {
            var result4 = null;
            pos = savedPos1;
          }
          var result3 = result4 !== null ? result4 : '';
          if (result3 !== null) {
            var result1 = [result2, result3];
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        var result0 = result1 !== null
          ? (function(b, bs) {
               var triples = b.triplesContext;
               var toTest = null;
                if(typeof(bs) === 'object') {
                      if(bs.length != null) {
                            if(bs[2].triplesContext!=null) {
                               triples = triples.concat(bs[2].triplesContext);
                        }
                     }
                }
          
               return {token:'triples',
                       triplesContext: triples}
          })(result1[0], result1[1])
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[54] TriplesBlock");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_TriplesSameSubject() {
        var cacheKey = 'TriplesSameSubject@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos1 = pos;
        var result11 = [];
        var result16 = parse_WS();
        while (result16 !== null) {
          result11.push(result16);
          var result16 = parse_WS();
        }
        if (result11 !== null) {
          var result12 = parse_VarOrTerm();
          if (result12 !== null) {
            var result13 = [];
            var result15 = parse_WS();
            while (result15 !== null) {
              result13.push(result15);
              var result15 = parse_WS();
            }
            if (result13 !== null) {
              var result14 = parse_PropertyListNotEmpty();
              if (result14 !== null) {
                var result10 = [result11, result12, result13, result14];
              } else {
                var result10 = null;
                pos = savedPos1;
              }
            } else {
              var result10 = null;
              pos = savedPos1;
            }
          } else {
            var result10 = null;
            pos = savedPos1;
          }
        } else {
          var result10 = null;
          pos = savedPos1;
        }
        var result9 = result10 !== null
          ? (function(s, pairs) {
                var triplesContext = pairs.triplesContext;
                var subject = s;
                if(pairs.pairs) {
                  for(var i=0; i< pairs.pairs.length; i++) {
                      var pair = pairs.pairs[i];
                      var triple = null;
                      if(subject.token && subject.token==='triplesnodecollection') {
                          triple = {subject: subject.chainSubject[0], predicate: pair[0], object: pair[1]}
                          triplesContext.push(triple);
                          triplesContext = triplesContext.concat(subject.triplesContext);
                      } else {
                          triple = {subject: subject, predicate: pair[0], object: pair[1]}
                          triplesContext.push(triple);
                      }
                  }
                }
          
                var token = {};
                token.token = "triplessamesubject";
                token.triplesContext = triplesContext;
                token.chainSubject = subject;
          
                return token;
            })(result10[1], result10[3])
          : null;
        if (result9 !== null) {
          var result0 = result9;
        } else {
          var savedPos0 = pos;
          var result3 = [];
          var result8 = parse_WS();
          while (result8 !== null) {
            result3.push(result8);
            var result8 = parse_WS();
          }
          if (result3 !== null) {
            var result4 = parse_TriplesNode();
            if (result4 !== null) {
              var result5 = [];
              var result7 = parse_WS();
              while (result7 !== null) {
                result5.push(result7);
                var result7 = parse_WS();
              }
              if (result5 !== null) {
                var result6 = parse_PropertyList();
                if (result6 !== null) {
                  var result2 = [result3, result4, result5, result6];
                } else {
                  var result2 = null;
                  pos = savedPos0;
                }
              } else {
                var result2 = null;
                pos = savedPos0;
              }
            } else {
              var result2 = null;
              pos = savedPos0;
            }
          } else {
            var result2 = null;
            pos = savedPos0;
          }
          var result1 = result2 !== null
            ? (function(tn, pairs) {
                  var triplesContext = tn.triplesContext;
                  var subject = tn.chainSubject;
            
                  if(pairs.pairs) {
                    for(var i=0; i< pairs.pairs.length; i++) {
                        var pair = pairs.pairs[i];
                        if(tn.token === "triplesnodecollection") {
                            for(var j=0; j<subject.length; j++) {
                                var subj = subject[j];
                                if(subj.triplesContext != null) {
                                    var triple = {subject: subj.chainSubject, predicate: pair[0], object: pair[1]}
                                    triplesContext.concat(subj.triplesContext);
                                } else {
                                    var triple = {subject: subject[j], predicate: pair[0], object: pair[1]}
                                    triplesContext.push(triple);
                                }
                            }
                        } else {
                            var triple = {subject: subject, predicate: pair[0], object: pair[1]}
                            triplesContext.push(triple);
                        }
                    }
                  }
            
                  var token = {};
                  token.token = "triplessamesubject";
                  token.triplesContext = triplesContext;
                  token.chainSubject = subject;
            
                  return token;
              })(result2[1], result2[3])
            : null;
          if (result1 !== null) {
            var result0 = result1;
          } else {
            var result0 = null;;
          };
        }
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[66] TriplesSameSubject");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_PropertyListNotEmpty() {
        var cacheKey = 'PropertyListNotEmpty@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        var result2 = parse_Verb();
        if (result2 !== null) {
          var result3 = [];
          var result18 = parse_WS();
          while (result18 !== null) {
            result3.push(result18);
            var result18 = parse_WS();
          }
          if (result3 !== null) {
            var result4 = parse_ObjectList();
            if (result4 !== null) {
              var result5 = [];
              var savedPos1 = pos;
              var result7 = [];
              var result17 = parse_WS();
              while (result17 !== null) {
                result7.push(result17);
                var result17 = parse_WS();
              }
              if (result7 !== null) {
                if (input.substr(pos, 1) === ";") {
                  var result8 = ";";
                  pos += 1;
                } else {
                  var result8 = null;
                  if (reportMatchFailures) {
                    matchFailed("\";\"");
                  }
                }
                if (result8 !== null) {
                  var result9 = [];
                  var result16 = parse_WS();
                  while (result16 !== null) {
                    result9.push(result16);
                    var result16 = parse_WS();
                  }
                  if (result9 !== null) {
                    var savedPos2 = pos;
                    var result12 = parse_Verb();
                    if (result12 !== null) {
                      var result13 = [];
                      var result15 = parse_WS();
                      while (result15 !== null) {
                        result13.push(result15);
                        var result15 = parse_WS();
                      }
                      if (result13 !== null) {
                        var result14 = parse_ObjectList();
                        if (result14 !== null) {
                          var result11 = [result12, result13, result14];
                        } else {
                          var result11 = null;
                          pos = savedPos2;
                        }
                      } else {
                        var result11 = null;
                        pos = savedPos2;
                      }
                    } else {
                      var result11 = null;
                      pos = savedPos2;
                    }
                    var result10 = result11 !== null ? result11 : '';
                    if (result10 !== null) {
                      var result6 = [result7, result8, result9, result10];
                    } else {
                      var result6 = null;
                      pos = savedPos1;
                    }
                  } else {
                    var result6 = null;
                    pos = savedPos1;
                  }
                } else {
                  var result6 = null;
                  pos = savedPos1;
                }
              } else {
                var result6 = null;
                pos = savedPos1;
              }
              while (result6 !== null) {
                result5.push(result6);
                var savedPos1 = pos;
                var result7 = [];
                var result17 = parse_WS();
                while (result17 !== null) {
                  result7.push(result17);
                  var result17 = parse_WS();
                }
                if (result7 !== null) {
                  if (input.substr(pos, 1) === ";") {
                    var result8 = ";";
                    pos += 1;
                  } else {
                    var result8 = null;
                    if (reportMatchFailures) {
                      matchFailed("\";\"");
                    }
                  }
                  if (result8 !== null) {
                    var result9 = [];
                    var result16 = parse_WS();
                    while (result16 !== null) {
                      result9.push(result16);
                      var result16 = parse_WS();
                    }
                    if (result9 !== null) {
                      var savedPos2 = pos;
                      var result12 = parse_Verb();
                      if (result12 !== null) {
                        var result13 = [];
                        var result15 = parse_WS();
                        while (result15 !== null) {
                          result13.push(result15);
                          var result15 = parse_WS();
                        }
                        if (result13 !== null) {
                          var result14 = parse_ObjectList();
                          if (result14 !== null) {
                            var result11 = [result12, result13, result14];
                          } else {
                            var result11 = null;
                            pos = savedPos2;
                          }
                        } else {
                          var result11 = null;
                          pos = savedPos2;
                        }
                      } else {
                        var result11 = null;
                        pos = savedPos2;
                      }
                      var result10 = result11 !== null ? result11 : '';
                      if (result10 !== null) {
                        var result6 = [result7, result8, result9, result10];
                      } else {
                        var result6 = null;
                        pos = savedPos1;
                      }
                    } else {
                      var result6 = null;
                      pos = savedPos1;
                    }
                  } else {
                    var result6 = null;
                    pos = savedPos1;
                  }
                } else {
                  var result6 = null;
                  pos = savedPos1;
                }
              }
              if (result5 !== null) {
                var result1 = [result2, result3, result4, result5];
              } else {
                var result1 = null;
                pos = savedPos0;
              }
            } else {
              var result1 = null;
              pos = savedPos0;
            }
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        var result0 = result1 !== null
          ? (function(v, ol, rest) {
                token = {}
                token.token = 'propertylist';
                var triplesContext = [];
                var pairs = [];
                var test = [];
          
                for( var i=0; i<ol.length; i++) {
          
                   if(ol[i].triplesContext != null) {
                       triplesContext = triplesContext.concat(ol[i].triplesContext);
                       if(ol[i].token==='triplesnodecollection' && ol[i].chainSubject.length != null) {
                           pairs.push([v, ol[i].chainSubject[0]]);
                       } else {
                           pairs.push([v, ol[i].chainSubject]);
                       }
          
                    } else {
                        pairs.push([v, ol[i]])
                    }
          
                }
          
          
                for(var i=0; i<rest.length; i++) {
                    var tok = rest[i][3];
                    var newVerb  = tok[0];
                    var newObjsList = tok[2] || [];
          
                    for(var j=0; j<newObjsList.length; j++) {
                     if(newObjsList[j].triplesContext != null) {
                        triplesContext = triplesContext.concat(newObjsList[j].triplesContext);
                       pairs.push([newVerb, newObjsList[j].chainSubject]);
                      } else {
                        pairs.push([newVerb, newObjsList[j]])
                      }
                    }
                }
          
                token.pairs = pairs;
                token.triplesContext = triplesContext;
          
                return token;
          
          })(result1[0], result1[2], result1[3])
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[67] PropertyListNotEmpty");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_PropertyList() {
        var cacheKey = 'PropertyList@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var result1 = parse_PropertyListNotEmpty();
        var result0 = result1 !== null ? result1 : '';
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[68] PropertyList");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_ObjectList() {
        var cacheKey = 'ObjectList@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        var result2 = parse_GraphNode();
        if (result2 !== null) {
          var result3 = [];
          var result10 = parse_WS();
          while (result10 !== null) {
            result3.push(result10);
            var result10 = parse_WS();
          }
          if (result3 !== null) {
            var result4 = [];
            var savedPos1 = pos;
            if (input.substr(pos, 1) === ",") {
              var result6 = ",";
              pos += 1;
            } else {
              var result6 = null;
              if (reportMatchFailures) {
                matchFailed("\",\"");
              }
            }
            if (result6 !== null) {
              var result7 = [];
              var result9 = parse_WS();
              while (result9 !== null) {
                result7.push(result9);
                var result9 = parse_WS();
              }
              if (result7 !== null) {
                var result8 = parse_GraphNode();
                if (result8 !== null) {
                  var result5 = [result6, result7, result8];
                } else {
                  var result5 = null;
                  pos = savedPos1;
                }
              } else {
                var result5 = null;
                pos = savedPos1;
              }
            } else {
              var result5 = null;
              pos = savedPos1;
            }
            while (result5 !== null) {
              result4.push(result5);
              var savedPos1 = pos;
              if (input.substr(pos, 1) === ",") {
                var result6 = ",";
                pos += 1;
              } else {
                var result6 = null;
                if (reportMatchFailures) {
                  matchFailed("\",\"");
                }
              }
              if (result6 !== null) {
                var result7 = [];
                var result9 = parse_WS();
                while (result9 !== null) {
                  result7.push(result9);
                  var result9 = parse_WS();
                }
                if (result7 !== null) {
                  var result8 = parse_GraphNode();
                  if (result8 !== null) {
                    var result5 = [result6, result7, result8];
                  } else {
                    var result5 = null;
                    pos = savedPos1;
                  }
                } else {
                  var result5 = null;
                  pos = savedPos1;
                }
              } else {
                var result5 = null;
                pos = savedPos1;
              }
            }
            if (result4 !== null) {
              var result1 = [result2, result3, result4];
            } else {
              var result1 = null;
              pos = savedPos0;
            }
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        var result0 = result1 !== null
          ? (function(obj, objs) {
          
                  var toReturn = [];
          
                  toReturn.push(obj);
          
                  for(var i=0; i<objs.length; i++) {
                      for(var j=0; j<objs[i].length; j++) {
                          if(typeof(objs[i][j])=="object" && objs[i][j].token != null) {
                              toReturn.push(objs[i][j]);
                          }
                      }
                  }
          
                  return toReturn;
              })(result1[0], result1[2])
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[69] ObjectList");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_Verb() {
        var cacheKey = 'Verb@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var result3 = parse_VarOrIRIref();
        if (result3 !== null) {
          var result0 = result3;
        } else {
          if (input.substr(pos, 1) === "a") {
            var result2 = "a";
            pos += 1;
          } else {
            var result2 = null;
            if (reportMatchFailures) {
              matchFailed("\"a\"");
            }
          }
          var result1 = result2 !== null
            ? (function() {
                  return{token: 'uri', prefix:null, suffix:null, value:"http://www.w3.org/1999/02/22-rdf-syntax-ns#type"}
              })()
            : null;
          if (result1 !== null) {
            var result0 = result1;
          } else {
            var result0 = null;;
          };
        }
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[71] Verb");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_PropertyListNotEmptyPath() {
        var cacheKey = 'PropertyListNotEmptyPath@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        var result13 = parse_VerbPath();
        if (result13 !== null) {
          var result1 = result13;
        } else {
          var result12 = parse_Var();
          if (result12 !== null) {
            var result1 = result12;
          } else {
            var result1 = null;;
          };
        }
        if (result1 !== null) {
          var result2 = parse_ObjectList();
          if (result2 !== null) {
            var result3 = [];
            var savedPos1 = pos;
            if (input.substr(pos, 1) === ";") {
              var result5 = ";";
              pos += 1;
            } else {
              var result5 = null;
              if (reportMatchFailures) {
                matchFailed("\";\"");
              }
            }
            if (result5 !== null) {
              var savedPos2 = pos;
              var result11 = parse_VerbPath();
              if (result11 !== null) {
                var result8 = result11;
              } else {
                var result10 = parse_Var();
                if (result10 !== null) {
                  var result8 = result10;
                } else {
                  var result8 = null;;
                };
              }
              if (result8 !== null) {
                var result9 = parse_ObjectList();
                if (result9 !== null) {
                  var result7 = [result8, result9];
                } else {
                  var result7 = null;
                  pos = savedPos2;
                }
              } else {
                var result7 = null;
                pos = savedPos2;
              }
              var result6 = result7 !== null ? result7 : '';
              if (result6 !== null) {
                var result4 = [result5, result6];
              } else {
                var result4 = null;
                pos = savedPos1;
              }
            } else {
              var result4 = null;
              pos = savedPos1;
            }
            while (result4 !== null) {
              result3.push(result4);
              var savedPos1 = pos;
              if (input.substr(pos, 1) === ";") {
                var result5 = ";";
                pos += 1;
              } else {
                var result5 = null;
                if (reportMatchFailures) {
                  matchFailed("\";\"");
                }
              }
              if (result5 !== null) {
                var savedPos2 = pos;
                var result11 = parse_VerbPath();
                if (result11 !== null) {
                  var result8 = result11;
                } else {
                  var result10 = parse_Var();
                  if (result10 !== null) {
                    var result8 = result10;
                  } else {
                    var result8 = null;;
                  };
                }
                if (result8 !== null) {
                  var result9 = parse_ObjectList();
                  if (result9 !== null) {
                    var result7 = [result8, result9];
                  } else {
                    var result7 = null;
                    pos = savedPos2;
                  }
                } else {
                  var result7 = null;
                  pos = savedPos2;
                }
                var result6 = result7 !== null ? result7 : '';
                if (result6 !== null) {
                  var result4 = [result5, result6];
                } else {
                  var result4 = null;
                  pos = savedPos1;
                }
              } else {
                var result4 = null;
                pos = savedPos1;
              }
            }
            if (result3 !== null) {
              var result0 = [result1, result2, result3];
            } else {
              var result0 = null;
              pos = savedPos0;
            }
          } else {
            var result0 = null;
            pos = savedPos0;
          }
        } else {
          var result0 = null;
          pos = savedPos0;
        }
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[73] PropertyListNotEmptyPath");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_PropertyListPath() {
        var cacheKey = 'PropertyListPath@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var result1 = parse_PropertyListNotEmpty();
        var result0 = result1 !== null ? result1 : '';
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[74] PropertyListPath");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_VerbPath() {
        var cacheKey = 'VerbPath@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var result1 = parse_PathAlternative();
        var result0 = result1 !== null
          ? (function(p) {
                var path = {};
                path.token = 'path';
                path.value = p;
          
                return p;
          })(result1)
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[75]");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_PathAlternative() {
        var cacheKey = 'PathAlternative@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        var result1 = parse_PathSequence();
        if (result1 !== null) {
          var result2 = [];
          var savedPos1 = pos;
          if (input.substr(pos, 1) === "|") {
            var result4 = "|";
            pos += 1;
          } else {
            var result4 = null;
            if (reportMatchFailures) {
              matchFailed("\"|\"");
            }
          }
          if (result4 !== null) {
            var result5 = parse_PathSequence();
            if (result5 !== null) {
              var result3 = [result4, result5];
            } else {
              var result3 = null;
              pos = savedPos1;
            }
          } else {
            var result3 = null;
            pos = savedPos1;
          }
          while (result3 !== null) {
            result2.push(result3);
            var savedPos1 = pos;
            if (input.substr(pos, 1) === "|") {
              var result4 = "|";
              pos += 1;
            } else {
              var result4 = null;
              if (reportMatchFailures) {
                matchFailed("\"|\"");
              }
            }
            if (result4 !== null) {
              var result5 = parse_PathSequence();
              if (result5 !== null) {
                var result3 = [result4, result5];
              } else {
                var result3 = null;
                pos = savedPos1;
              }
            } else {
              var result3 = null;
              pos = savedPos1;
            }
          }
          if (result2 !== null) {
            var result0 = [result1, result2];
          } else {
            var result0 = null;
            pos = savedPos0;
          }
        } else {
          var result0 = null;
          pos = savedPos0;
        }
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[78] PathAlternative");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_PathSequence() {
        var cacheKey = 'PathSequence@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        var result1 = parse_PathEltOrInverse();
        if (result1 !== null) {
          var result2 = [];
          var savedPos1 = pos;
          if (input.substr(pos, 1) === "/") {
            var result4 = "/";
            pos += 1;
          } else {
            var result4 = null;
            if (reportMatchFailures) {
              matchFailed("\"/\"");
            }
          }
          if (result4 !== null) {
            var result5 = parse_PathEltOrInverse();
            if (result5 !== null) {
              var result3 = [result4, result5];
            } else {
              var result3 = null;
              pos = savedPos1;
            }
          } else {
            var result3 = null;
            pos = savedPos1;
          }
          while (result3 !== null) {
            result2.push(result3);
            var savedPos1 = pos;
            if (input.substr(pos, 1) === "/") {
              var result4 = "/";
              pos += 1;
            } else {
              var result4 = null;
              if (reportMatchFailures) {
                matchFailed("\"/\"");
              }
            }
            if (result4 !== null) {
              var result5 = parse_PathEltOrInverse();
              if (result5 !== null) {
                var result3 = [result4, result5];
              } else {
                var result3 = null;
                pos = savedPos1;
              }
            } else {
              var result3 = null;
              pos = savedPos1;
            }
          }
          if (result2 !== null) {
            var result0 = [result1, result2];
          } else {
            var result0 = null;
            pos = savedPos0;
          }
        } else {
          var result0 = null;
          pos = savedPos0;
        }
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[79] PathSequence");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_PathElt() {
        var cacheKey = 'PathElt@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        var result1 = parse_PathPrimary();
        if (result1 !== null) {
          var result3 = parse_PathMod();
          var result2 = result3 !== null ? result3 : '';
          if (result2 !== null) {
            var result0 = [result1, result2];
          } else {
            var result0 = null;
            pos = savedPos0;
          }
        } else {
          var result0 = null;
          pos = savedPos0;
        }
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[88] PathElt");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_PathEltOrInverse() {
        var cacheKey = 'PathEltOrInverse@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var result4 = parse_PathElt();
        if (result4 !== null) {
          var result0 = result4;
        } else {
          var savedPos0 = pos;
          if (input.substr(pos, 1) === "^") {
            var result2 = "^";
            pos += 1;
          } else {
            var result2 = null;
            if (reportMatchFailures) {
              matchFailed("\"^\"");
            }
          }
          if (result2 !== null) {
            var result3 = parse_PathElt();
            if (result3 !== null) {
              var result1 = [result2, result3];
            } else {
              var result1 = null;
              pos = savedPos0;
            }
          } else {
            var result1 = null;
            pos = savedPos0;
          }
          if (result1 !== null) {
            var result0 = result1;
          } else {
            var result0 = null;;
          };
        }
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[81] PathEltOrInverse");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_PathMod() {
        var cacheKey = 'PathMod@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        if (input.substr(pos, 1) === "*") {
          var result21 = "*";
          pos += 1;
        } else {
          var result21 = null;
          if (reportMatchFailures) {
            matchFailed("\"*\"");
          }
        }
        if (result21 !== null) {
          var result0 = result21;
        } else {
          if (input.substr(pos, 1) === "?") {
            var result20 = "?";
            pos += 1;
          } else {
            var result20 = null;
            if (reportMatchFailures) {
              matchFailed("\"?\"");
            }
          }
          if (result20 !== null) {
            var result0 = result20;
          } else {
            if (input.substr(pos, 1) === "+") {
              var result19 = "+";
              pos += 1;
            } else {
              var result19 = null;
              if (reportMatchFailures) {
                matchFailed("\"+\"");
              }
            }
            if (result19 !== null) {
              var result0 = result19;
            } else {
              var savedPos0 = pos;
              if (input.substr(pos, 1) === "{") {
                var result2 = "{";
                pos += 1;
              } else {
                var result2 = null;
                if (reportMatchFailures) {
                  matchFailed("\"{\"");
                }
              }
              if (result2 !== null) {
                var savedPos2 = pos;
                var result9 = parse_INTEGER();
                if (result9 !== null) {
                  var savedPos3 = pos;
                  if (input.substr(pos, 1) === ",") {
                    var result13 = ",";
                    pos += 1;
                  } else {
                    var result13 = null;
                    if (reportMatchFailures) {
                      matchFailed("\",\"");
                    }
                  }
                  if (result13 !== null) {
                    if (input.substr(pos, 1) === "}") {
                      var result18 = "}";
                      pos += 1;
                    } else {
                      var result18 = null;
                      if (reportMatchFailures) {
                        matchFailed("\"}\"");
                      }
                    }
                    if (result18 !== null) {
                      var result14 = result18;
                    } else {
                      var savedPos4 = pos;
                      var result16 = parse_INTEGER();
                      if (result16 !== null) {
                        if (input.substr(pos, 1) === "}") {
                          var result17 = "}";
                          pos += 1;
                        } else {
                          var result17 = null;
                          if (reportMatchFailures) {
                            matchFailed("\"}\"");
                          }
                        }
                        if (result17 !== null) {
                          var result15 = [result16, result17];
                        } else {
                          var result15 = null;
                          pos = savedPos4;
                        }
                      } else {
                        var result15 = null;
                        pos = savedPos4;
                      }
                      if (result15 !== null) {
                        var result14 = result15;
                      } else {
                        var result14 = null;;
                      };
                    }
                    if (result14 !== null) {
                      var result12 = [result13, result14];
                    } else {
                      var result12 = null;
                      pos = savedPos3;
                    }
                  } else {
                    var result12 = null;
                    pos = savedPos3;
                  }
                  if (result12 !== null) {
                    var result10 = result12;
                  } else {
                    if (input.substr(pos, 1) === "}") {
                      var result11 = "}";
                      pos += 1;
                    } else {
                      var result11 = null;
                      if (reportMatchFailures) {
                        matchFailed("\"}\"");
                      }
                    }
                    if (result11 !== null) {
                      var result10 = result11;
                    } else {
                      var result10 = null;;
                    };
                  }
                  if (result10 !== null) {
                    var result8 = [result9, result10];
                  } else {
                    var result8 = null;
                    pos = savedPos2;
                  }
                } else {
                  var result8 = null;
                  pos = savedPos2;
                }
                if (result8 !== null) {
                  var result3 = result8;
                } else {
                  var savedPos1 = pos;
                  if (input.substr(pos, 1) === ",") {
                    var result5 = ",";
                    pos += 1;
                  } else {
                    var result5 = null;
                    if (reportMatchFailures) {
                      matchFailed("\",\"");
                    }
                  }
                  if (result5 !== null) {
                    var result6 = parse_INTEGER();
                    if (result6 !== null) {
                      if (input.substr(pos, 1) === "}") {
                        var result7 = "}";
                        pos += 1;
                      } else {
                        var result7 = null;
                        if (reportMatchFailures) {
                          matchFailed("\"}\"");
                        }
                      }
                      if (result7 !== null) {
                        var result4 = [result5, result6, result7];
                      } else {
                        var result4 = null;
                        pos = savedPos1;
                      }
                    } else {
                      var result4 = null;
                      pos = savedPos1;
                    }
                  } else {
                    var result4 = null;
                    pos = savedPos1;
                  }
                  if (result4 !== null) {
                    var result3 = result4;
                  } else {
                    var result3 = null;;
                  };
                }
                if (result3 !== null) {
                  var result1 = [result2, result3];
                } else {
                  var result1 = null;
                  pos = savedPos0;
                }
              } else {
                var result1 = null;
                pos = savedPos0;
              }
              if (result1 !== null) {
                var result0 = result1;
              } else {
                var result0 = null;;
              };
            };
          };
        }
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[82] PathMod");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_PathPrimary() {
        var cacheKey = 'PathPrimary@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var result9 = parse_IRIref();
        if (result9 !== null) {
          var result0 = result9;
        } else {
          if (input.substr(pos, 1) === "a") {
            var result8 = "a";
            pos += 1;
          } else {
            var result8 = null;
            if (reportMatchFailures) {
              matchFailed("\"a\"");
            }
          }
          if (result8 !== null) {
            var result0 = result8;
          } else {
            var savedPos1 = pos;
            if (input.substr(pos, 1) === "!") {
              var result6 = "!";
              pos += 1;
            } else {
              var result6 = null;
              if (reportMatchFailures) {
                matchFailed("\"!\"");
              }
            }
            if (result6 !== null) {
              var result7 = parse_PathNegatedPropertySet();
              if (result7 !== null) {
                var result5 = [result6, result7];
              } else {
                var result5 = null;
                pos = savedPos1;
              }
            } else {
              var result5 = null;
              pos = savedPos1;
            }
            if (result5 !== null) {
              var result0 = result5;
            } else {
              var savedPos0 = pos;
              if (input.substr(pos, 1) === "(") {
                var result2 = "(";
                pos += 1;
              } else {
                var result2 = null;
                if (reportMatchFailures) {
                  matchFailed("\"(\"");
                }
              }
              if (result2 !== null) {
                var result3 = parse_PathAlternative();
                if (result3 !== null) {
                  if (input.substr(pos, 1) === ")") {
                    var result4 = ")";
                    pos += 1;
                  } else {
                    var result4 = null;
                    if (reportMatchFailures) {
                      matchFailed("\")\"");
                    }
                  }
                  if (result4 !== null) {
                    var result1 = [result2, result3, result4];
                  } else {
                    var result1 = null;
                    pos = savedPos0;
                  }
                } else {
                  var result1 = null;
                  pos = savedPos0;
                }
              } else {
                var result1 = null;
                pos = savedPos0;
              }
              if (result1 !== null) {
                var result0 = result1;
              } else {
                var result0 = null;;
              };
            };
          };
        }
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[83] PathPrimary");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_PathNegatedPropertySet() {
        var cacheKey = 'PathNegatedPropertySet@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        
        var result11 = parse_PathOneInPropertySet();
        if (result11 !== null) {
          var result0 = result11;
        } else {
          var savedPos0 = pos;
          if (input.substr(pos, 1) === "(") {
            var result2 = "(";
            pos += 1;
          } else {
            var result2 = null;
            if (reportMatchFailures) {
              matchFailed("\"(\"");
            }
          }
          if (result2 !== null) {
            var savedPos1 = pos;
            var result6 = parse_PathOneInPropertySet();
            if (result6 !== null) {
              var result7 = [];
              var savedPos2 = pos;
              if (input.substr(pos, 1) === "|") {
                var result9 = "|";
                pos += 1;
              } else {
                var result9 = null;
                if (reportMatchFailures) {
                  matchFailed("\"|\"");
                }
              }
              if (result9 !== null) {
                var result10 = parse_PathOneInPropertySet();
                if (result10 !== null) {
                  var result8 = [result9, result10];
                } else {
                  var result8 = null;
                  pos = savedPos2;
                }
              } else {
                var result8 = null;
                pos = savedPos2;
              }
              while (result8 !== null) {
                result7.push(result8);
                var savedPos2 = pos;
                if (input.substr(pos, 1) === "|") {
                  var result9 = "|";
                  pos += 1;
                } else {
                  var result9 = null;
                  if (reportMatchFailures) {
                    matchFailed("\"|\"");
                  }
                }
                if (result9 !== null) {
                  var result10 = parse_PathOneInPropertySet();
                  if (result10 !== null) {
                    var result8 = [result9, result10];
                  } else {
                    var result8 = null;
                    pos = savedPos2;
                  }
                } else {
                  var result8 = null;
                  pos = savedPos2;
                }
              }
              if (result7 !== null) {
                var result5 = [result6, result7];
              } else {
                var result5 = null;
                pos = savedPos1;
              }
            } else {
              var result5 = null;
              pos = savedPos1;
            }
            var result3 = result5 !== null ? result5 : '';
            if (result3 !== null) {
              if (input.substr(pos, 1) === ")") {
                var result4 = ")";
                pos += 1;
              } else {
                var result4 = null;
                if (reportMatchFailures) {
                  matchFailed("\")\"");
                }
              }
              if (result4 !== null) {
                var result1 = [result2, result3, result4];
              } else {
                var result1 = null;
                pos = savedPos0;
              }
            } else {
              var result1 = null;
              pos = savedPos0;
            }
          } else {
            var result1 = null;
            pos = savedPos0;
          }
          if (result1 !== null) {
            var result0 = result1;
          } else {
            var result0 = null;;
          };
        }
        
        
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_PathOneInPropertySet() {
        var cacheKey = 'PathOneInPropertySet@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var result7 = parse_IRIref();
        if (result7 !== null) {
          var result0 = result7;
        } else {
          if (input.substr(pos, 1) === "a") {
            var result6 = "a";
            pos += 1;
          } else {
            var result6 = null;
            if (reportMatchFailures) {
              matchFailed("\"a\"");
            }
          }
          if (result6 !== null) {
            var result0 = result6;
          } else {
            var savedPos0 = pos;
            if (input.substr(pos, 1) === "^") {
              var result2 = "^";
              pos += 1;
            } else {
              var result2 = null;
              if (reportMatchFailures) {
                matchFailed("\"^\"");
              }
            }
            if (result2 !== null) {
              var result5 = parse_IRIref();
              if (result5 !== null) {
                var result3 = result5;
              } else {
                if (input.substr(pos, 1) === "a") {
                  var result4 = "a";
                  pos += 1;
                } else {
                  var result4 = null;
                  if (reportMatchFailures) {
                    matchFailed("\"a\"");
                  }
                }
                if (result4 !== null) {
                  var result3 = result4;
                } else {
                  var result3 = null;;
                };
              }
              if (result3 !== null) {
                var result1 = [result2, result3];
              } else {
                var result1 = null;
                pos = savedPos0;
              }
            } else {
              var result1 = null;
              pos = savedPos0;
            }
            if (result1 !== null) {
              var result0 = result1;
            } else {
              var result0 = null;;
            };
          };
        }
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[85] PathOneInPropertySet");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_TriplesNode() {
        var cacheKey = 'TriplesNode@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var result3 = parse_Collection();
        var result2 = result3 !== null
          ? (function(c) {
                triplesContext = [];
                chainSubject = [];
          
                var triple = null;
          
                // catch NIL
                /*
                if(c.length == 1 && c[0].token && c[0].token === 'nil') {
                    GlobalBlankNodeCounter++;
                    return  {token: "triplesnodecollection", 
                             triplesContext:[{subject: {token:'blank', label:("_:"+GlobalBlankNodeCounter)},
                                              predicate:{token:'uri', prefix:null, suffix:null, value:'http://www.w3.org/1999/02/22-rdf-syntax-ns#rest'},
                                              object:  {token:'blank', label:("_:"+(GlobalBlankNodeCounter+1))}}], 
                             chainSubject:{token:'blank', label:("_:"+GlobalBlankNodeCounter)}};
          
                }
                */
          
                // other cases
                for(var i=0; i<c.length; i++) {
                    GlobalBlankNodeCounter++;
                    //_:b0  rdf:first  1 ;
                    //rdf:rest   _:b1 .
                    var nextObject = null;
                    if(c[i].chainSubject == null && c[i].triplesContext == null) {
                        nextObject = c[i];
                    } else {
                        nextObject = c[i].chainSubject;
                        triplesContext = triplesContext.concat(nextSubject.triplesContext);
                    }
                    var currentSubject = null;
                    triple = {subject: {token:'blank', label:("_:"+GlobalBlankNodeCounter)},
                              predicate:{token:'uri', prefix:null, suffix:null, value:'http://www.w3.org/1999/02/22-rdf-syntax-ns#first'},
                              object:nextObject };
          
                    if(i==0) {
                        chainSubject.push(triple.subject);
                    }
          
                    triplesContext.push(triple);
          
                    if(i===(c.length-1)) {
                        triple = {subject: {token:'blank', label:("_:"+GlobalBlankNodeCounter)},
                                  predicate:{token:'uri', prefix:null, suffix:null, value:'http://www.w3.org/1999/02/22-rdf-syntax-ns#rest'},
                                  object:   {token:'uri', prefix:null, suffix:null, value:'http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'}};
                    } else {
                        triple = {subject: {token:'blank', label:("_:"+GlobalBlankNodeCounter)},
                                  predicate:{token:'uri', prefix:null, suffix:null, value:'http://www.w3.org/1999/02/22-rdf-syntax-ns#rest'},
                                  object:  {token:'blank', label:("_:"+(GlobalBlankNodeCounter+1))} };
                    }
          
                    triplesContext.push(triple);
                }
          
                return {token:"triplesnodecollection", triplesContext:triplesContext, chainSubject:chainSubject};
          })(result3)
          : null;
        if (result2 !== null) {
          var result0 = result2;
        } else {
          var result1 = parse_BlankNodePropertyList();
          if (result1 !== null) {
            var result0 = result1;
          } else {
            var result0 = null;;
          };
        }
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[87] TriplesNode");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_BlankNodePropertyList() {
        var cacheKey = 'BlankNodePropertyList@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        var result2 = [];
        var result12 = parse_WS();
        while (result12 !== null) {
          result2.push(result12);
          var result12 = parse_WS();
        }
        if (result2 !== null) {
          if (input.substr(pos, 1) === "[") {
            var result3 = "[";
            pos += 1;
          } else {
            var result3 = null;
            if (reportMatchFailures) {
              matchFailed("\"[\"");
            }
          }
          if (result3 !== null) {
            var result4 = [];
            var result11 = parse_WS();
            while (result11 !== null) {
              result4.push(result11);
              var result11 = parse_WS();
            }
            if (result4 !== null) {
              var result5 = parse_PropertyListNotEmpty();
              if (result5 !== null) {
                var result6 = [];
                var result10 = parse_WS();
                while (result10 !== null) {
                  result6.push(result10);
                  var result10 = parse_WS();
                }
                if (result6 !== null) {
                  if (input.substr(pos, 1) === "]") {
                    var result7 = "]";
                    pos += 1;
                  } else {
                    var result7 = null;
                    if (reportMatchFailures) {
                      matchFailed("\"]\"");
                    }
                  }
                  if (result7 !== null) {
                    var result8 = [];
                    var result9 = parse_WS();
                    while (result9 !== null) {
                      result8.push(result9);
                      var result9 = parse_WS();
                    }
                    if (result8 !== null) {
                      var result1 = [result2, result3, result4, result5, result6, result7, result8];
                    } else {
                      var result1 = null;
                      pos = savedPos0;
                    }
                  } else {
                    var result1 = null;
                    pos = savedPos0;
                  }
                } else {
                  var result1 = null;
                  pos = savedPos0;
                }
              } else {
                var result1 = null;
                pos = savedPos0;
              }
            } else {
              var result1 = null;
              pos = savedPos0;
            }
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        var result0 = result1 !== null
          ? (function(pl) {
          
                GlobalBlankNodeCounter++;
                var subject = {token:'blank', label:''+GlobalBlankNodeCounter};
                var newTriples =  [];
          
                for(var i=0; i< pl.pairs.length; i++) {
                    var pair = pl.pairs[i];
                    var triple = {}
                    triple.subject = subject;
                    triple.predicate = pair[0];
                    triple.object = pair[1];
                    newTriples.push(triple);
                }
          
                return {token: 'triplesnode',
                        kind: 'blanknodepropertylist',
                        triplesContext: pl.triplesContext.concat(newTriples),
                        chainSubject: subject};
          })(result1[3])
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[88] BlankNodePropertyList");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_Collection() {
        var cacheKey = 'Collection@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        var result2 = [];
        var result13 = parse_WS();
        while (result13 !== null) {
          result2.push(result13);
          var result13 = parse_WS();
        }
        if (result2 !== null) {
          if (input.substr(pos, 1) === "(") {
            var result3 = "(";
            pos += 1;
          } else {
            var result3 = null;
            if (reportMatchFailures) {
              matchFailed("\"(\"");
            }
          }
          if (result3 !== null) {
            var result4 = [];
            var result12 = parse_WS();
            while (result12 !== null) {
              result4.push(result12);
              var result12 = parse_WS();
            }
            if (result4 !== null) {
              var result11 = parse_GraphNode();
              if (result11 !== null) {
                var result5 = [];
                while (result11 !== null) {
                  result5.push(result11);
                  var result11 = parse_GraphNode();
                }
              } else {
                var result5 = null;
              }
              if (result5 !== null) {
                var result6 = [];
                var result10 = parse_WS();
                while (result10 !== null) {
                  result6.push(result10);
                  var result10 = parse_WS();
                }
                if (result6 !== null) {
                  if (input.substr(pos, 1) === ")") {
                    var result7 = ")";
                    pos += 1;
                  } else {
                    var result7 = null;
                    if (reportMatchFailures) {
                      matchFailed("\")\"");
                    }
                  }
                  if (result7 !== null) {
                    var result8 = [];
                    var result9 = parse_WS();
                    while (result9 !== null) {
                      result8.push(result9);
                      var result9 = parse_WS();
                    }
                    if (result8 !== null) {
                      var result1 = [result2, result3, result4, result5, result6, result7, result8];
                    } else {
                      var result1 = null;
                      pos = savedPos0;
                    }
                  } else {
                    var result1 = null;
                    pos = savedPos0;
                  }
                } else {
                  var result1 = null;
                  pos = savedPos0;
                }
              } else {
                var result1 = null;
                pos = savedPos0;
              }
            } else {
              var result1 = null;
              pos = savedPos0;
            }
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        var result0 = result1 !== null
          ? (function(gn) {
                return gn;
          })(result1[3])
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[89] Collection");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_GraphNode() {
        var cacheKey = 'GraphNode@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos1 = pos;
        var result9 = [];
        var result13 = parse_WS();
        while (result13 !== null) {
          result9.push(result13);
          var result13 = parse_WS();
        }
        if (result9 !== null) {
          var result10 = parse_VarOrTerm();
          if (result10 !== null) {
            var result11 = [];
            var result12 = parse_WS();
            while (result12 !== null) {
              result11.push(result12);
              var result12 = parse_WS();
            }
            if (result11 !== null) {
              var result8 = [result9, result10, result11];
            } else {
              var result8 = null;
              pos = savedPos1;
            }
          } else {
            var result8 = null;
            pos = savedPos1;
          }
        } else {
          var result8 = null;
          pos = savedPos1;
        }
        if (result8 !== null) {
          var result1 = result8;
        } else {
          var savedPos0 = pos;
          var result3 = [];
          var result7 = parse_WS();
          while (result7 !== null) {
            result3.push(result7);
            var result7 = parse_WS();
          }
          if (result3 !== null) {
            var result4 = parse_TriplesNode();
            if (result4 !== null) {
              var result5 = [];
              var result6 = parse_WS();
              while (result6 !== null) {
                result5.push(result6);
                var result6 = parse_WS();
              }
              if (result5 !== null) {
                var result2 = [result3, result4, result5];
              } else {
                var result2 = null;
                pos = savedPos0;
              }
            } else {
              var result2 = null;
              pos = savedPos0;
            }
          } else {
            var result2 = null;
            pos = savedPos0;
          }
          if (result2 !== null) {
            var result1 = result2;
          } else {
            var result1 = null;;
          };
        }
        var result0 = result1 !== null
          ? (function(gn) {
            return gn[1];
          })(result1)
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[90] GraphNode");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_VarOrTerm() {
        var cacheKey = 'VarOrTerm@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var result2 = parse_Var();
        if (result2 !== null) {
          var result0 = result2;
        } else {
          var result1 = parse_GraphTerm();
          if (result1 !== null) {
            var result0 = result1;
          } else {
            var result0 = null;;
          };
        }
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[91] VarOrTerm");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_VarOrIRIref() {
        var cacheKey = 'VarOrIRIref@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var result2 = parse_Var();
        if (result2 !== null) {
          var result0 = result2;
        } else {
          var result1 = parse_IRIref();
          if (result1 !== null) {
            var result0 = result1;
          } else {
            var result0 = null;;
          };
        }
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[92] VarOrIRIref");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_Var() {
        var cacheKey = 'Var@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var result3 = parse_VAR1();
        if (result3 !== null) {
          var result1 = result3;
        } else {
          var result2 = parse_VAR2();
          if (result2 !== null) {
            var result1 = result2;
          } else {
            var result1 = null;;
          };
        }
        var result0 = result1 !== null
          ? (function(v) {
                var term = {};
                term.token = 'var';
                term.value = v;
                return term;
            })(result1)
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[93] Var");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_GraphTerm() {
        var cacheKey = 'GraphTerm@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var result6 = parse_IRIref();
        if (result6 !== null) {
          var result0 = result6;
        } else {
          var result5 = parse_RDFLiteral();
          if (result5 !== null) {
            var result0 = result5;
          } else {
            var result4 = parse_NumericLiteral();
            if (result4 !== null) {
              var result0 = result4;
            } else {
              var result3 = parse_BooleanLiteral();
              if (result3 !== null) {
                var result0 = result3;
              } else {
                var result2 = parse_BlankNode();
                if (result2 !== null) {
                  var result0 = result2;
                } else {
                  var result1 = parse_NIL();
                  if (result1 !== null) {
                    var result0 = result1;
                  } else {
                    var result0 = null;;
                  };
                };
              };
            };
          };
        }
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[94] GraphTerm");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_RDFLiteral() {
        var cacheKey = 'RDFLiteral@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        var result2 = parse_String();
        if (result2 !== null) {
          var result8 = parse_LANGTAG();
          if (result8 !== null) {
            var result4 = result8;
          } else {
            var savedPos1 = pos;
            if (input.substr(pos, 2) === "^^") {
              var result6 = "^^";
              pos += 2;
            } else {
              var result6 = null;
              if (reportMatchFailures) {
                matchFailed("\"^^\"");
              }
            }
            if (result6 !== null) {
              var result7 = parse_IRIref();
              if (result7 !== null) {
                var result5 = [result6, result7];
              } else {
                var result5 = null;
                pos = savedPos1;
              }
            } else {
              var result5 = null;
              pos = savedPos1;
            }
            if (result5 !== null) {
              var result4 = result5;
            } else {
              var result4 = null;;
            };
          }
          var result3 = result4 !== null ? result4 : '';
          if (result3 !== null) {
            var result1 = [result2, result3];
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        var result0 = result1 !== null
          ? (function(s, e) {
                if(typeof(e) === "string" && e.length > 0) {
                    return {token:'literal', value:s.value, lang:e.slice(1), type:null}
                } else {
                    if(typeof(e) === "object") {
                        e.shift(); // remove the '^^' char
                        return {token:'literal', value:s.value, lang:null, type:e[0] }
                    } else {
                        return { token:'literal', value:s.value, lang:null, type:null }
                    }
                }
          })(result1[0], result1[1])
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[112] RDFLiteral");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_NumericLiteral() {
        var cacheKey = 'NumericLiteral@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var result3 = parse_NumericLiteralUnsigned();
        if (result3 !== null) {
          var result0 = result3;
        } else {
          var result2 = parse_NumericLiteralPositive();
          if (result2 !== null) {
            var result0 = result2;
          } else {
            var result1 = parse_NumericLiteralNegative();
            if (result1 !== null) {
              var result0 = result1;
            } else {
              var result0 = null;;
            };
          };
        }
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[113] NumericLiteral");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_NumericLiteralUnsigned() {
        var cacheKey = 'NumericLiteralUnsigned@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var result3 = parse_DOUBLE();
        if (result3 !== null) {
          var result0 = result3;
        } else {
          var result2 = parse_DECIMAL();
          if (result2 !== null) {
            var result0 = result2;
          } else {
            var result1 = parse_INTEGER();
            if (result1 !== null) {
              var result0 = result1;
            } else {
              var result0 = null;;
            };
          };
        }
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[114] NumericLiteralUnsigned");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_NumericLiteralPositive() {
        var cacheKey = 'NumericLiteralPositive@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var result3 = parse_DOUBLE_POSITIVE();
        if (result3 !== null) {
          var result0 = result3;
        } else {
          var result2 = parse_DECIMAL_POSITIVE();
          if (result2 !== null) {
            var result0 = result2;
          } else {
            var result1 = parse_INTEGER_POSITIVE();
            if (result1 !== null) {
              var result0 = result1;
            } else {
              var result0 = null;;
            };
          };
        }
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[115] NumericLiteralPositive");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_NumericLiteralNegative() {
        var cacheKey = 'NumericLiteralNegative@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var result3 = parse_DOUBLE_NEGATIVE();
        if (result3 !== null) {
          var result0 = result3;
        } else {
          var result2 = parse_DECIMAL_NEGATIVE();
          if (result2 !== null) {
            var result0 = result2;
          } else {
            var result1 = parse_INTEGER_NEGATIVE();
            if (result1 !== null) {
              var result0 = result1;
            } else {
              var result0 = null;;
            };
          };
        }
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[116] NumericLiteralNegative");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_BooleanLiteral() {
        var cacheKey = 'BooleanLiteral@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        if (input.substr(pos, 4) === "true") {
          var result4 = "true";
          pos += 4;
        } else {
          var result4 = null;
          if (reportMatchFailures) {
            matchFailed("\"true\"");
          }
        }
        var result3 = result4 !== null
          ? (function() {
                lit = {};
                lit.token = "literal";
                lit.lang = null;
                lit.type = "http://www.w3.org/2001/XMLSchema#boolean";
                lit.value = true;
                return lit;
           })()
          : null;
        if (result3 !== null) {
          var result0 = result3;
        } else {
          if (input.substr(pos, 5) === "false") {
            var result2 = "false";
            pos += 5;
          } else {
            var result2 = null;
            if (reportMatchFailures) {
              matchFailed("\"false\"");
            }
          }
          var result1 = result2 !== null
            ? (function() {
                  lit = {};
                  lit.token = "literal";
                  lit.lang = null;
                  lit.type = "http://www.w3.org/2001/XMLSchema#boolean";
                  lit.value = false;
                  return lit;
            })()
            : null;
          if (result1 !== null) {
            var result0 = result1;
          } else {
            var result0 = null;;
          };
        }
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[117] BooleanLiteral");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_String() {
        var cacheKey = 'String@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var result8 = parse_STRING_LITERAL_LONG1();
        var result7 = result8 !== null
          ? (function(s) { return {token:'string', value:s} })(result8)
          : null;
        if (result7 !== null) {
          var result0 = result7;
        } else {
          var result6 = parse_STRING_LITERAL_LONG2();
          var result5 = result6 !== null
            ? (function(s) { return {token:'string', value:s} })(result6)
            : null;
          if (result5 !== null) {
            var result0 = result5;
          } else {
            var result4 = parse_STRING_LITERAL1();
            var result3 = result4 !== null
              ? (function(s) { return {token:'string', value:s} })(result4)
              : null;
            if (result3 !== null) {
              var result0 = result3;
            } else {
              var result2 = parse_STRING_LITERAL2();
              var result1 = result2 !== null
                ? (function(s) { return {token:'string', value:s} })(result2)
                : null;
              if (result1 !== null) {
                var result0 = result1;
              } else {
                var result0 = null;;
              };
            };
          };
        }
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[118] String");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_IRIref() {
        var cacheKey = 'IRIref@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var result4 = parse_IRI_REF();
        var result3 = result4 !== null
          ? (function(iri) { return {token: 'uri', prefix:null, suffix:null, value:iri} })(result4)
          : null;
        if (result3 !== null) {
          var result0 = result3;
        } else {
          var result2 = parse_PrefixedName();
          var result1 = result2 !== null
            ? (function(p) { return p })(result2)
            : null;
          if (result1 !== null) {
            var result0 = result1;
          } else {
            var result0 = null;;
          };
        }
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[119] IRIref");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_PrefixedName() {
        var cacheKey = 'PrefixedName@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var result4 = parse_PNAME_LN();
        var result3 = result4 !== null
          ? (function(p) { return {token: 'uri', prefix:p[0], suffix:p[1], value:null } })(result4)
          : null;
        if (result3 !== null) {
          var result0 = result3;
        } else {
          var result2 = parse_PNAME_NS();
          var result1 = result2 !== null
            ? (function(p) { return {token: 'uri', prefix:p, suffix:'', value:null } })(result2)
            : null;
          if (result1 !== null) {
            var result0 = result1;
          } else {
            var result0 = null;;
          };
        }
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[120] PrefixedName");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_BlankNode() {
        var cacheKey = 'BlankNode@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var result4 = parse_BLANK_NODE_LABEL();
        var result3 = result4 !== null
          ? (function(l) { return {token:'blank', label:l}})(result4)
          : null;
        if (result3 !== null) {
          var result0 = result3;
        } else {
          var result2 = parse_ANON();
          var result1 = result2 !== null
            ? (function() { GlobalBlankNodeCounter++; return {token:'blank', label:''+GlobalBlankNodeCounter} })()
            : null;
          if (result1 !== null) {
            var result0 = result1;
          } else {
            var result0 = null;;
          };
        }
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[121] BlankNode");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_IRI_REF() {
        var cacheKey = 'IRI_REF@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        if (input.substr(pos, 1) === "<") {
          var result2 = "<";
          pos += 1;
        } else {
          var result2 = null;
          if (reportMatchFailures) {
            matchFailed("\"<\"");
          }
        }
        if (result2 !== null) {
          var result3 = [];
          if (input.substr(pos).match(/^[^<>"{} | ^\\]/) !== null) {
            var result5 = input.charAt(pos);
            pos++;
          } else {
            var result5 = null;
            if (reportMatchFailures) {
              matchFailed("[^<>\"{} | ^\\\\]");
            }
          }
          while (result5 !== null) {
            result3.push(result5);
            if (input.substr(pos).match(/^[^<>"{} | ^\\]/) !== null) {
              var result5 = input.charAt(pos);
              pos++;
            } else {
              var result5 = null;
              if (reportMatchFailures) {
                matchFailed("[^<>\"{} | ^\\\\]");
              }
            }
          }
          if (result3 !== null) {
            if (input.substr(pos, 1) === ">") {
              var result4 = ">";
              pos += 1;
            } else {
              var result4 = null;
              if (reportMatchFailures) {
                matchFailed("\">\"");
              }
            }
            if (result4 !== null) {
              var result1 = [result2, result3, result4];
            } else {
              var result1 = null;
              pos = savedPos0;
            }
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        var result0 = result1 !== null
          ? (function(iri_ref) { return iri_ref.join('') })(result1[1])
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[122] IRI_REF");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_PNAME_NS() {
        var cacheKey = 'PNAME_NS@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        var result4 = parse_PN_PREFIX();
        var result2 = result4 !== null ? result4 : '';
        if (result2 !== null) {
          if (input.substr(pos, 1) === ":") {
            var result3 = ":";
            pos += 1;
          } else {
            var result3 = null;
            if (reportMatchFailures) {
              matchFailed("\":\"");
            }
          }
          if (result3 !== null) {
            var result1 = [result2, result3];
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        var result0 = result1 !== null
          ? (function(p) { return p })(result1[0])
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[123] PNAME_NS");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_PNAME_LN() {
        var cacheKey = 'PNAME_LN@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        var result2 = parse_PNAME_NS();
        if (result2 !== null) {
          var result3 = parse_PN_LOCAL();
          if (result3 !== null) {
            var result1 = [result2, result3];
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        var result0 = result1 !== null
          ? (function(p, s) { return [p, s] })(result1[0], result1[1])
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[124] PNAME_LN");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_BLANK_NODE_LABEL() {
        var cacheKey = 'BLANK_NODE_LABEL@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        if (input.substr(pos, 2) === "_:") {
          var result2 = "_:";
          pos += 2;
        } else {
          var result2 = null;
          if (reportMatchFailures) {
            matchFailed("\"_:\"");
          }
        }
        if (result2 !== null) {
          var result3 = parse_PN_LOCAL();
          if (result3 !== null) {
            var result1 = [result2, result3];
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        var result0 = result1 !== null
          ? (function(l) { return l })(result1[1])
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[125] BLANK_NODE_LABEL");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_VAR1() {
        var cacheKey = 'VAR1@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        if (input.substr(pos, 1) === "?") {
          var result2 = "?";
          pos += 1;
        } else {
          var result2 = null;
          if (reportMatchFailures) {
            matchFailed("\"?\"");
          }
        }
        if (result2 !== null) {
          var result3 = parse_VARNAME();
          if (result3 !== null) {
            var result1 = [result2, result3];
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        var result0 = result1 !== null
          ? (function(v) { return v })(result1[1])
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[126] VAR1");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_VAR2() {
        var cacheKey = 'VAR2@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        if (input.substr(pos, 1) === "$") {
          var result2 = "$";
          pos += 1;
        } else {
          var result2 = null;
          if (reportMatchFailures) {
            matchFailed("\"$\"");
          }
        }
        if (result2 !== null) {
          var result3 = parse_VARNAME();
          if (result3 !== null) {
            var result1 = [result2, result3];
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        var result0 = result1 !== null
          ? (function(v) { return v })(result1[1])
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[127] VAR2");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_LANGTAG() {
        var cacheKey = 'LANGTAG@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        if (input.substr(pos, 1) === "@") {
          var result2 = "@";
          pos += 1;
        } else {
          var result2 = null;
          if (reportMatchFailures) {
            matchFailed("\"@\"");
          }
        }
        if (result2 !== null) {
          if (input.substr(pos).match(/^[a-zA-Z]/) !== null) {
            var result9 = input.charAt(pos);
            pos++;
          } else {
            var result9 = null;
            if (reportMatchFailures) {
              matchFailed("[a-zA-Z]");
            }
          }
          if (result9 !== null) {
            var result3 = [];
            while (result9 !== null) {
              result3.push(result9);
              if (input.substr(pos).match(/^[a-zA-Z]/) !== null) {
                var result9 = input.charAt(pos);
                pos++;
              } else {
                var result9 = null;
                if (reportMatchFailures) {
                  matchFailed("[a-zA-Z]");
                }
              }
            }
          } else {
            var result3 = null;
          }
          if (result3 !== null) {
            var result4 = [];
            var savedPos1 = pos;
            if (input.substr(pos, 1) === "-") {
              var result6 = "-";
              pos += 1;
            } else {
              var result6 = null;
              if (reportMatchFailures) {
                matchFailed("\"-\"");
              }
            }
            if (result6 !== null) {
              if (input.substr(pos).match(/^[a-zA-Z0-9]/) !== null) {
                var result8 = input.charAt(pos);
                pos++;
              } else {
                var result8 = null;
                if (reportMatchFailures) {
                  matchFailed("[a-zA-Z0-9]");
                }
              }
              if (result8 !== null) {
                var result7 = [];
                while (result8 !== null) {
                  result7.push(result8);
                  if (input.substr(pos).match(/^[a-zA-Z0-9]/) !== null) {
                    var result8 = input.charAt(pos);
                    pos++;
                  } else {
                    var result8 = null;
                    if (reportMatchFailures) {
                      matchFailed("[a-zA-Z0-9]");
                    }
                  }
                }
              } else {
                var result7 = null;
              }
              if (result7 !== null) {
                var result5 = [result6, result7];
              } else {
                var result5 = null;
                pos = savedPos1;
              }
            } else {
              var result5 = null;
              pos = savedPos1;
            }
            while (result5 !== null) {
              result4.push(result5);
              var savedPos1 = pos;
              if (input.substr(pos, 1) === "-") {
                var result6 = "-";
                pos += 1;
              } else {
                var result6 = null;
                if (reportMatchFailures) {
                  matchFailed("\"-\"");
                }
              }
              if (result6 !== null) {
                if (input.substr(pos).match(/^[a-zA-Z0-9]/) !== null) {
                  var result8 = input.charAt(pos);
                  pos++;
                } else {
                  var result8 = null;
                  if (reportMatchFailures) {
                    matchFailed("[a-zA-Z0-9]");
                  }
                }
                if (result8 !== null) {
                  var result7 = [];
                  while (result8 !== null) {
                    result7.push(result8);
                    if (input.substr(pos).match(/^[a-zA-Z0-9]/) !== null) {
                      var result8 = input.charAt(pos);
                      pos++;
                    } else {
                      var result8 = null;
                      if (reportMatchFailures) {
                        matchFailed("[a-zA-Z0-9]");
                      }
                    }
                  }
                } else {
                  var result7 = null;
                }
                if (result7 !== null) {
                  var result5 = [result6, result7];
                } else {
                  var result5 = null;
                  pos = savedPos1;
                }
              } else {
                var result5 = null;
                pos = savedPos1;
              }
            }
            if (result4 !== null) {
              var result1 = [result2, result3, result4];
            } else {
              var result1 = null;
              pos = savedPos0;
            }
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        var result0 = result1 !== null
          ? (function(a, b) {
          
                if(b.length===0) {
                    return ("@"+a.join('')).toLowerCase();
                } else {
                    return ("@"+a.join('')+"-"+b[0][1].join('')).toLowerCase();
                }
          })(result1[1], result1[2])
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[128] LANGTAG");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_INTEGER() {
        var cacheKey = 'INTEGER@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        if (input.substr(pos).match(/^[0-9]/) !== null) {
          var result2 = input.charAt(pos);
          pos++;
        } else {
          var result2 = null;
          if (reportMatchFailures) {
            matchFailed("[0-9]");
          }
        }
        if (result2 !== null) {
          var result1 = [];
          while (result2 !== null) {
            result1.push(result2);
            if (input.substr(pos).match(/^[0-9]/) !== null) {
              var result2 = input.charAt(pos);
              pos++;
            } else {
              var result2 = null;
              if (reportMatchFailures) {
                matchFailed("[0-9]");
              }
            }
          }
        } else {
          var result1 = null;
        }
        var result0 = result1 !== null
          ? (function(d) {
                lit = {};
                lit.token = "literal";
                lit.lang = null;
                lit.type = "http://www.w3.org/2001/XMLSchema#integer";
                lit.value = flattenString(d);
                return lit;
          })(result1)
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[129] INTEGER");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_DECIMAL() {
        var cacheKey = 'DECIMAL@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos1 = pos;
        if (input.substr(pos).match(/^[0-9]/) !== null) {
          var result12 = input.charAt(pos);
          pos++;
        } else {
          var result12 = null;
          if (reportMatchFailures) {
            matchFailed("[0-9]");
          }
        }
        if (result12 !== null) {
          var result8 = [];
          while (result12 !== null) {
            result8.push(result12);
            if (input.substr(pos).match(/^[0-9]/) !== null) {
              var result12 = input.charAt(pos);
              pos++;
            } else {
              var result12 = null;
              if (reportMatchFailures) {
                matchFailed("[0-9]");
              }
            }
          }
        } else {
          var result8 = null;
        }
        if (result8 !== null) {
          if (input.substr(pos, 1) === ".") {
            var result9 = ".";
            pos += 1;
          } else {
            var result9 = null;
            if (reportMatchFailures) {
              matchFailed("\".\"");
            }
          }
          if (result9 !== null) {
            var result10 = [];
            if (input.substr(pos).match(/^[0-9]/) !== null) {
              var result11 = input.charAt(pos);
              pos++;
            } else {
              var result11 = null;
              if (reportMatchFailures) {
                matchFailed("[0-9]");
              }
            }
            while (result11 !== null) {
              result10.push(result11);
              if (input.substr(pos).match(/^[0-9]/) !== null) {
                var result11 = input.charAt(pos);
                pos++;
              } else {
                var result11 = null;
                if (reportMatchFailures) {
                  matchFailed("[0-9]");
                }
              }
            }
            if (result10 !== null) {
              var result7 = [result8, result9, result10];
            } else {
              var result7 = null;
              pos = savedPos1;
            }
          } else {
            var result7 = null;
            pos = savedPos1;
          }
        } else {
          var result7 = null;
          pos = savedPos1;
        }
        var result6 = result7 !== null
          ? (function(a, b, c) {
          
                lit = {};
                lit.token = "literal";
                lit.lang = null;
                lit.type = "http://www.w3.org/2001/XMLSchema#decimal";
                lit.value = flattenString([a,b,c]);
                return lit;
          })(result7[0], result7[1], result7[2])
          : null;
        if (result6 !== null) {
          var result0 = result6;
        } else {
          var savedPos0 = pos;
          if (input.substr(pos, 1) === ".") {
            var result3 = ".";
            pos += 1;
          } else {
            var result3 = null;
            if (reportMatchFailures) {
              matchFailed("\".\"");
            }
          }
          if (result3 !== null) {
            if (input.substr(pos).match(/^[0-9]/) !== null) {
              var result5 = input.charAt(pos);
              pos++;
            } else {
              var result5 = null;
              if (reportMatchFailures) {
                matchFailed("[0-9]");
              }
            }
            if (result5 !== null) {
              var result4 = [];
              while (result5 !== null) {
                result4.push(result5);
                if (input.substr(pos).match(/^[0-9]/) !== null) {
                  var result5 = input.charAt(pos);
                  pos++;
                } else {
                  var result5 = null;
                  if (reportMatchFailures) {
                    matchFailed("[0-9]");
                  }
                }
              }
            } else {
              var result4 = null;
            }
            if (result4 !== null) {
              var result2 = [result3, result4];
            } else {
              var result2 = null;
              pos = savedPos0;
            }
          } else {
            var result2 = null;
            pos = savedPos0;
          }
          var result1 = result2 !== null
            ? (function(a, b) {
                  lit = {};
                  lit.token = "literal";
                  lit.lang = null;
                  lit.type = "http://www.w3.org/2001/XMLSchema#decimal";
                  lit.value = flattenString([a,b]);
                  return lit;
             })(result2[0], result2[1])
            : null;
          if (result1 !== null) {
            var result0 = result1;
          } else {
            var result0 = null;;
          };
        }
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[130] DECIMAL");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_DOUBLE() {
        var cacheKey = 'DOUBLE@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos2 = pos;
        if (input.substr(pos).match(/^[0-9]/) !== null) {
          var result19 = input.charAt(pos);
          pos++;
        } else {
          var result19 = null;
          if (reportMatchFailures) {
            matchFailed("[0-9]");
          }
        }
        if (result19 !== null) {
          var result14 = [];
          while (result19 !== null) {
            result14.push(result19);
            if (input.substr(pos).match(/^[0-9]/) !== null) {
              var result19 = input.charAt(pos);
              pos++;
            } else {
              var result19 = null;
              if (reportMatchFailures) {
                matchFailed("[0-9]");
              }
            }
          }
        } else {
          var result14 = null;
        }
        if (result14 !== null) {
          if (input.substr(pos, 1) === ".") {
            var result15 = ".";
            pos += 1;
          } else {
            var result15 = null;
            if (reportMatchFailures) {
              matchFailed("\".\"");
            }
          }
          if (result15 !== null) {
            var result16 = [];
            if (input.substr(pos).match(/^[0-9]/) !== null) {
              var result18 = input.charAt(pos);
              pos++;
            } else {
              var result18 = null;
              if (reportMatchFailures) {
                matchFailed("[0-9]");
              }
            }
            while (result18 !== null) {
              result16.push(result18);
              if (input.substr(pos).match(/^[0-9]/) !== null) {
                var result18 = input.charAt(pos);
                pos++;
              } else {
                var result18 = null;
                if (reportMatchFailures) {
                  matchFailed("[0-9]");
                }
              }
            }
            if (result16 !== null) {
              var result17 = parse_EXPONENT();
              if (result17 !== null) {
                var result13 = [result14, result15, result16, result17];
              } else {
                var result13 = null;
                pos = savedPos2;
              }
            } else {
              var result13 = null;
              pos = savedPos2;
            }
          } else {
            var result13 = null;
            pos = savedPos2;
          }
        } else {
          var result13 = null;
          pos = savedPos2;
        }
        var result12 = result13 !== null
          ? (function(a, b, c, e) {
                lit = {};
                lit.token = "literal";
                lit.lang = null;
                lit.type = "http://www.w3.org/2001/XMLSchema#double";
                lit.value = flattenString([a,b,c,e]);
                return lit;
          })(result13[0], result13[1], result13[2], result13[3])
          : null;
        if (result12 !== null) {
          var result0 = result12;
        } else {
          var savedPos1 = pos;
          if (input.substr(pos, 1) === ".") {
            var result8 = ".";
            pos += 1;
          } else {
            var result8 = null;
            if (reportMatchFailures) {
              matchFailed("\".\"");
            }
          }
          if (result8 !== null) {
            if (input.substr(pos).match(/^[0-9]/) !== null) {
              var result11 = input.charAt(pos);
              pos++;
            } else {
              var result11 = null;
              if (reportMatchFailures) {
                matchFailed("[0-9]");
              }
            }
            if (result11 !== null) {
              var result9 = [];
              while (result11 !== null) {
                result9.push(result11);
                if (input.substr(pos).match(/^[0-9]/) !== null) {
                  var result11 = input.charAt(pos);
                  pos++;
                } else {
                  var result11 = null;
                  if (reportMatchFailures) {
                    matchFailed("[0-9]");
                  }
                }
              }
            } else {
              var result9 = null;
            }
            if (result9 !== null) {
              var result10 = parse_EXPONENT();
              if (result10 !== null) {
                var result7 = [result8, result9, result10];
              } else {
                var result7 = null;
                pos = savedPos1;
              }
            } else {
              var result7 = null;
              pos = savedPos1;
            }
          } else {
            var result7 = null;
            pos = savedPos1;
          }
          var result6 = result7 !== null
            ? (function(a, b, c) {
                  lit = {};
                  lit.token = "literal";
                  lit.lang = null;
                  lit.type = "http://www.w3.org/2001/XMLSchema#double";
                  lit.value = flattenString([a,b,c]);
                  return lit;
            })(result7[0], result7[1], result7[2])
            : null;
          if (result6 !== null) {
            var result0 = result6;
          } else {
            var savedPos0 = pos;
            if (input.substr(pos).match(/^[0-9]/) !== null) {
              var result5 = input.charAt(pos);
              pos++;
            } else {
              var result5 = null;
              if (reportMatchFailures) {
                matchFailed("[0-9]");
              }
            }
            if (result5 !== null) {
              var result3 = [];
              while (result5 !== null) {
                result3.push(result5);
                if (input.substr(pos).match(/^[0-9]/) !== null) {
                  var result5 = input.charAt(pos);
                  pos++;
                } else {
                  var result5 = null;
                  if (reportMatchFailures) {
                    matchFailed("[0-9]");
                  }
                }
              }
            } else {
              var result3 = null;
            }
            if (result3 !== null) {
              var result4 = parse_EXPONENT();
              if (result4 !== null) {
                var result2 = [result3, result4];
              } else {
                var result2 = null;
                pos = savedPos0;
              }
            } else {
              var result2 = null;
              pos = savedPos0;
            }
            var result1 = result2 !== null
              ? (function(a, b) {
                    lit = {};
                    lit.token = "literal";
                    lit.lang = null;
                    lit.type = "http://www.w3.org/2001/XMLSchema#double";
                    lit.value = flattenString([a,b]);
                    return lit;
              })(result2[0], result2[1])
              : null;
            if (result1 !== null) {
              var result0 = result1;
            } else {
              var result0 = null;;
            };
          };
        }
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[131] DOUBLE");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_INTEGER_POSITIVE() {
        var cacheKey = 'INTEGER_POSITIVE@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        if (input.substr(pos, 1) === "+") {
          var result2 = "+";
          pos += 1;
        } else {
          var result2 = null;
          if (reportMatchFailures) {
            matchFailed("\"+\"");
          }
        }
        if (result2 !== null) {
          var result3 = parse_INTEGER();
          if (result3 !== null) {
            var result1 = [result2, result3];
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        var result0 = result1 !== null
          ? (function(d) { d.value = "+"+d.value; return d; })(result1[1])
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[132] INTEGER_POSITIVE");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_DECIMAL_POSITIVE() {
        var cacheKey = 'DECIMAL_POSITIVE@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        if (input.substr(pos, 1) === "+") {
          var result2 = "+";
          pos += 1;
        } else {
          var result2 = null;
          if (reportMatchFailures) {
            matchFailed("\"+\"");
          }
        }
        if (result2 !== null) {
          var result3 = parse_DECIMAL();
          if (result3 !== null) {
            var result1 = [result2, result3];
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        var result0 = result1 !== null
          ? (function(d) { d.value = "+"+d.value; return d })(result1[1])
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[133] DECIMAL_POSITIVE");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_DOUBLE_POSITIVE() {
        var cacheKey = 'DOUBLE_POSITIVE@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        if (input.substr(pos, 1) === "+") {
          var result2 = "+";
          pos += 1;
        } else {
          var result2 = null;
          if (reportMatchFailures) {
            matchFailed("\"+\"");
          }
        }
        if (result2 !== null) {
          var result3 = parse_DOUBLE();
          if (result3 !== null) {
            var result1 = [result2, result3];
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        var result0 = result1 !== null
          ? (function(d) { d.value = "+"+d.value; return d })(result1[1])
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[134] DOUBLE_POSITIVE");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_INTEGER_NEGATIVE() {
        var cacheKey = 'INTEGER_NEGATIVE@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        if (input.substr(pos, 1) === "-") {
          var result2 = "-";
          pos += 1;
        } else {
          var result2 = null;
          if (reportMatchFailures) {
            matchFailed("\"-\"");
          }
        }
        if (result2 !== null) {
          var result3 = parse_INTEGER();
          if (result3 !== null) {
            var result1 = [result2, result3];
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        var result0 = result1 !== null
          ? (function(d) { d.value = "-"+d.value; return d; })(result1[1])
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[135] INTEGER_NEGATIVE");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_DECIMAL_NEGATIVE() {
        var cacheKey = 'DECIMAL_NEGATIVE@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        if (input.substr(pos, 1) === "-") {
          var result2 = "-";
          pos += 1;
        } else {
          var result2 = null;
          if (reportMatchFailures) {
            matchFailed("\"-\"");
          }
        }
        if (result2 !== null) {
          var result3 = parse_DECIMAL();
          if (result3 !== null) {
            var result1 = [result2, result3];
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        var result0 = result1 !== null
          ? (function(d) { d.value = "-"+d.value; return d; })(result1[1])
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[136] DECIMAL_NEGATIVE");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_DOUBLE_NEGATIVE() {
        var cacheKey = 'DOUBLE_NEGATIVE@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        if (input.substr(pos, 1) === "-") {
          var result2 = "-";
          pos += 1;
        } else {
          var result2 = null;
          if (reportMatchFailures) {
            matchFailed("\"-\"");
          }
        }
        if (result2 !== null) {
          var result3 = parse_DOUBLE();
          if (result3 !== null) {
            var result1 = [result2, result3];
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        var result0 = result1 !== null
          ? (function(d) { d.value = "-"+d.value; return d; })(result1[1])
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[137] DOUBLE_NEGATIVE");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_EXPONENT() {
        var cacheKey = 'EXPONENT@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        if (input.substr(pos).match(/^[eE]/) !== null) {
          var result2 = input.charAt(pos);
          pos++;
        } else {
          var result2 = null;
          if (reportMatchFailures) {
            matchFailed("[eE]");
          }
        }
        if (result2 !== null) {
          if (input.substr(pos).match(/^[+\-]/) !== null) {
            var result6 = input.charAt(pos);
            pos++;
          } else {
            var result6 = null;
            if (reportMatchFailures) {
              matchFailed("[+\\-]");
            }
          }
          var result3 = result6 !== null ? result6 : '';
          if (result3 !== null) {
            if (input.substr(pos).match(/^[0-9]/) !== null) {
              var result5 = input.charAt(pos);
              pos++;
            } else {
              var result5 = null;
              if (reportMatchFailures) {
                matchFailed("[0-9]");
              }
            }
            if (result5 !== null) {
              var result4 = [];
              while (result5 !== null) {
                result4.push(result5);
                if (input.substr(pos).match(/^[0-9]/) !== null) {
                  var result5 = input.charAt(pos);
                  pos++;
                } else {
                  var result5 = null;
                  if (reportMatchFailures) {
                    matchFailed("[0-9]");
                  }
                }
              }
            } else {
              var result4 = null;
            }
            if (result4 !== null) {
              var result1 = [result2, result3, result4];
            } else {
              var result1 = null;
              pos = savedPos0;
            }
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        var result0 = result1 !== null
          ? (function(a, b, c) { return flattenString([a,b,c]) })(result1[0], result1[1], result1[2])
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[138] EXPONENT");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_STRING_LITERAL1() {
        var cacheKey = 'STRING_LITERAL1@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        if (input.substr(pos, 1) === "'") {
          var result2 = "'";
          pos += 1;
        } else {
          var result2 = null;
          if (reportMatchFailures) {
            matchFailed("\"'\"");
          }
        }
        if (result2 !== null) {
          var result3 = [];
          if (input.substr(pos).match(/^[^'\\\n\r]/) !== null) {
            var result7 = input.charAt(pos);
            pos++;
          } else {
            var result7 = null;
            if (reportMatchFailures) {
              matchFailed("[^'\\\\\\n\\r]");
            }
          }
          if (result7 !== null) {
            var result5 = result7;
          } else {
            var result6 = parse_ECHAR();
            if (result6 !== null) {
              var result5 = result6;
            } else {
              var result5 = null;;
            };
          }
          while (result5 !== null) {
            result3.push(result5);
            if (input.substr(pos).match(/^[^'\\\n\r]/) !== null) {
              var result7 = input.charAt(pos);
              pos++;
            } else {
              var result7 = null;
              if (reportMatchFailures) {
                matchFailed("[^'\\\\\\n\\r]");
              }
            }
            if (result7 !== null) {
              var result5 = result7;
            } else {
              var result6 = parse_ECHAR();
              if (result6 !== null) {
                var result5 = result6;
              } else {
                var result5 = null;;
              };
            }
          }
          if (result3 !== null) {
            if (input.substr(pos, 1) === "'") {
              var result4 = "'";
              pos += 1;
            } else {
              var result4 = null;
              if (reportMatchFailures) {
                matchFailed("\"'\"");
              }
            }
            if (result4 !== null) {
              var result1 = [result2, result3, result4];
            } else {
              var result1 = null;
              pos = savedPos0;
            }
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        var result0 = result1 !== null
          ? (function(content) { return flattenString(content) })(result1[1])
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[139] STRING_LITERAL1");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_STRING_LITERAL2() {
        var cacheKey = 'STRING_LITERAL2@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        if (input.substr(pos, 1) === "\"") {
          var result2 = "\"";
          pos += 1;
        } else {
          var result2 = null;
          if (reportMatchFailures) {
            matchFailed("\"\\\"\"");
          }
        }
        if (result2 !== null) {
          var result3 = [];
          if (input.substr(pos).match(/^[^"\\\n\r]/) !== null) {
            var result7 = input.charAt(pos);
            pos++;
          } else {
            var result7 = null;
            if (reportMatchFailures) {
              matchFailed("[^\"\\\\\\n\\r]");
            }
          }
          if (result7 !== null) {
            var result5 = result7;
          } else {
            var result6 = parse_ECHAR();
            if (result6 !== null) {
              var result5 = result6;
            } else {
              var result5 = null;;
            };
          }
          while (result5 !== null) {
            result3.push(result5);
            if (input.substr(pos).match(/^[^"\\\n\r]/) !== null) {
              var result7 = input.charAt(pos);
              pos++;
            } else {
              var result7 = null;
              if (reportMatchFailures) {
                matchFailed("[^\"\\\\\\n\\r]");
              }
            }
            if (result7 !== null) {
              var result5 = result7;
            } else {
              var result6 = parse_ECHAR();
              if (result6 !== null) {
                var result5 = result6;
              } else {
                var result5 = null;;
              };
            }
          }
          if (result3 !== null) {
            if (input.substr(pos, 1) === "\"") {
              var result4 = "\"";
              pos += 1;
            } else {
              var result4 = null;
              if (reportMatchFailures) {
                matchFailed("\"\\\"\"");
              }
            }
            if (result4 !== null) {
              var result1 = [result2, result3, result4];
            } else {
              var result1 = null;
              pos = savedPos0;
            }
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        var result0 = result1 !== null
          ? (function(content) { return flattenString(content) })(result1[1])
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[140] STRING_LITERAL2");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_STRING_LITERAL_LONG1() {
        var cacheKey = 'STRING_LITERAL_LONG1@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        if (input.substr(pos, 3) === "'''") {
          var result2 = "'''";
          pos += 3;
        } else {
          var result2 = null;
          if (reportMatchFailures) {
            matchFailed("\"'''\"");
          }
        }
        if (result2 !== null) {
          var result3 = [];
          if (input.substr(pos).match(/^[^'\\]/) !== null) {
            var result7 = input.charAt(pos);
            pos++;
          } else {
            var result7 = null;
            if (reportMatchFailures) {
              matchFailed("[^'\\\\]");
            }
          }
          if (result7 !== null) {
            var result5 = result7;
          } else {
            var result6 = parse_ECHAR();
            if (result6 !== null) {
              var result5 = result6;
            } else {
              var result5 = null;;
            };
          }
          while (result5 !== null) {
            result3.push(result5);
            if (input.substr(pos).match(/^[^'\\]/) !== null) {
              var result7 = input.charAt(pos);
              pos++;
            } else {
              var result7 = null;
              if (reportMatchFailures) {
                matchFailed("[^'\\\\]");
              }
            }
            if (result7 !== null) {
              var result5 = result7;
            } else {
              var result6 = parse_ECHAR();
              if (result6 !== null) {
                var result5 = result6;
              } else {
                var result5 = null;;
              };
            }
          }
          if (result3 !== null) {
            if (input.substr(pos, 3) === "'''") {
              var result4 = "'''";
              pos += 3;
            } else {
              var result4 = null;
              if (reportMatchFailures) {
                matchFailed("\"'''\"");
              }
            }
            if (result4 !== null) {
              var result1 = [result2, result3, result4];
            } else {
              var result1 = null;
              pos = savedPos0;
            }
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        var result0 = result1 !== null
          ? (function(content) { return flattenString(content) })(result1[1])
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[141] STRING_LITERAL_LONG1");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_STRING_LITERAL_LONG2() {
        var cacheKey = 'STRING_LITERAL_LONG2@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        if (input.substr(pos, 3) === "\"\"\"") {
          var result2 = "\"\"\"";
          pos += 3;
        } else {
          var result2 = null;
          if (reportMatchFailures) {
            matchFailed("\"\\\"\\\"\\\"\"");
          }
        }
        if (result2 !== null) {
          var result3 = [];
          if (input.substr(pos).match(/^[^"\\]/) !== null) {
            var result7 = input.charAt(pos);
            pos++;
          } else {
            var result7 = null;
            if (reportMatchFailures) {
              matchFailed("[^\"\\\\]");
            }
          }
          if (result7 !== null) {
            var result5 = result7;
          } else {
            var result6 = parse_ECHAR();
            if (result6 !== null) {
              var result5 = result6;
            } else {
              var result5 = null;;
            };
          }
          while (result5 !== null) {
            result3.push(result5);
            if (input.substr(pos).match(/^[^"\\]/) !== null) {
              var result7 = input.charAt(pos);
              pos++;
            } else {
              var result7 = null;
              if (reportMatchFailures) {
                matchFailed("[^\"\\\\]");
              }
            }
            if (result7 !== null) {
              var result5 = result7;
            } else {
              var result6 = parse_ECHAR();
              if (result6 !== null) {
                var result5 = result6;
              } else {
                var result5 = null;;
              };
            }
          }
          if (result3 !== null) {
            if (input.substr(pos, 3) === "\"\"\"") {
              var result4 = "\"\"\"";
              pos += 3;
            } else {
              var result4 = null;
              if (reportMatchFailures) {
                matchFailed("\"\\\"\\\"\\\"\"");
              }
            }
            if (result4 !== null) {
              var result1 = [result2, result3, result4];
            } else {
              var result1 = null;
              pos = savedPos0;
            }
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        var result0 = result1 !== null
          ? (function(content) { return flattenString(content) })(result1[1])
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[142] STRING_LITERAL_LONG2");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_ECHAR() {
        var cacheKey = 'ECHAR@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        if (input.substr(pos, 1) === "\\") {
          var result1 = "\\";
          pos += 1;
        } else {
          var result1 = null;
          if (reportMatchFailures) {
            matchFailed("\"\\\\\"");
          }
        }
        if (result1 !== null) {
          if (input.substr(pos).match(/^[tbnrf"']/) !== null) {
            var result2 = input.charAt(pos);
            pos++;
          } else {
            var result2 = null;
            if (reportMatchFailures) {
              matchFailed("[tbnrf\"']");
            }
          }
          if (result2 !== null) {
            var result0 = [result1, result2];
          } else {
            var result0 = null;
            pos = savedPos0;
          }
        } else {
          var result0 = null;
          pos = savedPos0;
        }
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[143] ECHAR");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_NIL() {
        var cacheKey = 'NIL@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        if (input.substr(pos, 1) === "(") {
          var result2 = "(";
          pos += 1;
        } else {
          var result2 = null;
          if (reportMatchFailures) {
            matchFailed("\"(\"");
          }
        }
        if (result2 !== null) {
          var result3 = [];
          var result5 = parse_WS();
          while (result5 !== null) {
            result3.push(result5);
            var result5 = parse_WS();
          }
          if (result3 !== null) {
            if (input.substr(pos, 1) === ")") {
              var result4 = ")";
              pos += 1;
            } else {
              var result4 = null;
              if (reportMatchFailures) {
                matchFailed("\")\"");
              }
            }
            if (result4 !== null) {
              var result1 = [result2, result3, result4];
            } else {
              var result1 = null;
              pos = savedPos0;
            }
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        var result0 = result1 !== null
          ? (function() {
          
                return  {token: "triplesnodecollection", 
                         triplesContext:[], 
                         chainSubject:[{token:'uri', value:"http://www.w3.org/1999/02/22-rdf-syntax-ns#nil"}]};
          })()
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[144] NIL");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_WS() {
        var cacheKey = 'WS@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
          reportMatchFailures = false
        if (input.substr(pos).match(/^[ ]/) !== null) {
          var result5 = input.charAt(pos);
          pos++;
        } else {
          var result5 = null;
          if (reportMatchFailures) {
            matchFailed("[ ]");
          }
        }
        if (result5 !== null) {
          var result0 = result5;
        } else {
          if (input.substr(pos).match(/^[	]/) !== null) {
            var result4 = input.charAt(pos);
            pos++;
          } else {
            var result4 = null;
            if (reportMatchFailures) {
              matchFailed("[	]");
            }
          }
          if (result4 !== null) {
            var result0 = result4;
          } else {
            if (input.substr(pos).match(/^[\r]/) !== null) {
              var result3 = input.charAt(pos);
              pos++;
            } else {
              var result3 = null;
              if (reportMatchFailures) {
                matchFailed("[\\r]");
              }
            }
            if (result3 !== null) {
              var result0 = result3;
            } else {
              if (input.substr(pos).match(/^[\n]/) !== null) {
                var result2 = input.charAt(pos);
                pos++;
              } else {
                var result2 = null;
                if (reportMatchFailures) {
                  matchFailed("[\\n]");
                }
              }
              if (result2 !== null) {
                var result0 = result2;
              } else {
                var result1 = parse_COMMENT();
                if (result1 !== null) {
                  var result0 = result1;
                } else {
                  var result0 = null;;
                };
              };
            };
          };
        }
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[145] WS");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_COMMENT() {
        var cacheKey = 'COMMENT@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        if (input.substr(pos, 1) === "#") {
          var result1 = "#";
          pos += 1;
        } else {
          var result1 = null;
          if (reportMatchFailures) {
            matchFailed("\"#\"");
          }
        }
        if (result1 !== null) {
          var result2 = [];
          if (input.substr(pos).match(/^[^#xA#xD]/) !== null) {
            var result3 = input.charAt(pos);
            pos++;
          } else {
            var result3 = null;
            if (reportMatchFailures) {
              matchFailed("[^#xA#xD]");
            }
          }
          while (result3 !== null) {
            result2.push(result3);
            if (input.substr(pos).match(/^[^#xA#xD]/) !== null) {
              var result3 = input.charAt(pos);
              pos++;
            } else {
              var result3 = null;
              if (reportMatchFailures) {
                matchFailed("[^#xA#xD]");
              }
            }
          }
          if (result2 !== null) {
            var result0 = [result1, result2];
          } else {
            var result0 = null;
            pos = savedPos0;
          }
        } else {
          var result0 = null;
          pos = savedPos0;
        }
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed(" COMMENT");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_ANON() {
        var cacheKey = 'ANON@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        if (input.substr(pos, 1) === "[") {
          var result1 = "[";
          pos += 1;
        } else {
          var result1 = null;
          if (reportMatchFailures) {
            matchFailed("\"[\"");
          }
        }
        if (result1 !== null) {
          var result2 = [];
          var result4 = parse_WS();
          while (result4 !== null) {
            result2.push(result4);
            var result4 = parse_WS();
          }
          if (result2 !== null) {
            if (input.substr(pos, 1) === "]") {
              var result3 = "]";
              pos += 1;
            } else {
              var result3 = null;
              if (reportMatchFailures) {
                matchFailed("\"]\"");
              }
            }
            if (result3 !== null) {
              var result0 = [result1, result2, result3];
            } else {
              var result0 = null;
              pos = savedPos0;
            }
          } else {
            var result0 = null;
            pos = savedPos0;
          }
        } else {
          var result0 = null;
          pos = savedPos0;
        }
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[146] ANON");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_PN_CHARS_BASE() {
        var cacheKey = 'PN_CHARS_BASE@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        if (input.substr(pos).match(/^[A-Z]/) !== null) {
          var result14 = input.charAt(pos);
          pos++;
        } else {
          var result14 = null;
          if (reportMatchFailures) {
            matchFailed("[A-Z]");
          }
        }
        if (result14 !== null) {
          var result0 = result14;
        } else {
          if (input.substr(pos).match(/^[a-z]/) !== null) {
            var result13 = input.charAt(pos);
            pos++;
          } else {
            var result13 = null;
            if (reportMatchFailures) {
              matchFailed("[a-z]");
            }
          }
          if (result13 !== null) {
            var result0 = result13;
          } else {
            if (input.substr(pos).match(/^[\xC0-\xD6]/) !== null) {
              var result12 = input.charAt(pos);
              pos++;
            } else {
              var result12 = null;
              if (reportMatchFailures) {
                matchFailed("[\\xC0-\\xD6]");
              }
            }
            if (result12 !== null) {
              var result0 = result12;
            } else {
              if (input.substr(pos).match(/^[\xD8-\xF6]/) !== null) {
                var result11 = input.charAt(pos);
                pos++;
              } else {
                var result11 = null;
                if (reportMatchFailures) {
                  matchFailed("[\\xD8-\\xF6]");
                }
              }
              if (result11 !== null) {
                var result0 = result11;
              } else {
                if (input.substr(pos).match(/^[\xF8-\u02FF]/) !== null) {
                  var result10 = input.charAt(pos);
                  pos++;
                } else {
                  var result10 = null;
                  if (reportMatchFailures) {
                    matchFailed("[\\xF8-\\u02FF]");
                  }
                }
                if (result10 !== null) {
                  var result0 = result10;
                } else {
                  if (input.substr(pos).match(/^[\u0370-\u037D]/) !== null) {
                    var result9 = input.charAt(pos);
                    pos++;
                  } else {
                    var result9 = null;
                    if (reportMatchFailures) {
                      matchFailed("[\\u0370-\\u037D]");
                    }
                  }
                  if (result9 !== null) {
                    var result0 = result9;
                  } else {
                    if (input.substr(pos).match(/^[\u037F-\u1FFF]/) !== null) {
                      var result8 = input.charAt(pos);
                      pos++;
                    } else {
                      var result8 = null;
                      if (reportMatchFailures) {
                        matchFailed("[\\u037F-\\u1FFF]");
                      }
                    }
                    if (result8 !== null) {
                      var result0 = result8;
                    } else {
                      if (input.substr(pos).match(/^[\u200C-\u200D]/) !== null) {
                        var result7 = input.charAt(pos);
                        pos++;
                      } else {
                        var result7 = null;
                        if (reportMatchFailures) {
                          matchFailed("[\\u200C-\\u200D]");
                        }
                      }
                      if (result7 !== null) {
                        var result0 = result7;
                      } else {
                        if (input.substr(pos).match(/^[\u2070-\u218F]/) !== null) {
                          var result6 = input.charAt(pos);
                          pos++;
                        } else {
                          var result6 = null;
                          if (reportMatchFailures) {
                            matchFailed("[\\u2070-\\u218F]");
                          }
                        }
                        if (result6 !== null) {
                          var result0 = result6;
                        } else {
                          if (input.substr(pos).match(/^[\u2C00-\u2FEF]/) !== null) {
                            var result5 = input.charAt(pos);
                            pos++;
                          } else {
                            var result5 = null;
                            if (reportMatchFailures) {
                              matchFailed("[\\u2C00-\\u2FEF]");
                            }
                          }
                          if (result5 !== null) {
                            var result0 = result5;
                          } else {
                            if (input.substr(pos).match(/^[\u3001-\uD7FF]/) !== null) {
                              var result4 = input.charAt(pos);
                              pos++;
                            } else {
                              var result4 = null;
                              if (reportMatchFailures) {
                                matchFailed("[\\u3001-\\uD7FF]");
                              }
                            }
                            if (result4 !== null) {
                              var result0 = result4;
                            } else {
                              if (input.substr(pos).match(/^[\uF900-\uFDCF]/) !== null) {
                                var result3 = input.charAt(pos);
                                pos++;
                              } else {
                                var result3 = null;
                                if (reportMatchFailures) {
                                  matchFailed("[\\uF900-\\uFDCF]");
                                }
                              }
                              if (result3 !== null) {
                                var result0 = result3;
                              } else {
                                if (input.substr(pos).match(/^[\uFDF0-\uFFFD]/) !== null) {
                                  var result2 = input.charAt(pos);
                                  pos++;
                                } else {
                                  var result2 = null;
                                  if (reportMatchFailures) {
                                    matchFailed("[\\uFDF0-\\uFFFD]");
                                  }
                                }
                                if (result2 !== null) {
                                  var result0 = result2;
                                } else {
                                  if (input.substr(pos).match(/^[\u1000-\uEFFF]/) !== null) {
                                    var result1 = input.charAt(pos);
                                    pos++;
                                  } else {
                                    var result1 = null;
                                    if (reportMatchFailures) {
                                      matchFailed("[\\u1000-\\uEFFF]");
                                    }
                                  }
                                  if (result1 !== null) {
                                    var result0 = result1;
                                  } else {
                                    var result0 = null;;
                                  };
                                };
                              };
                            };
                          };
                        };
                      };
                    };
                  };
                };
              };
            };
          };
        }
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[147] PN_CHARS_BASE");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_PN_CHARS_U() {
        var cacheKey = 'PN_CHARS_U@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var result2 = parse_PN_CHARS_BASE();
        if (result2 !== null) {
          var result0 = result2;
        } else {
          if (input.substr(pos, 1) === "_") {
            var result1 = "_";
            pos += 1;
          } else {
            var result1 = null;
            if (reportMatchFailures) {
              matchFailed("\"_\"");
            }
          }
          if (result1 !== null) {
            var result0 = result1;
          } else {
            var result0 = null;;
          };
        }
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[148] PN_CHARS_U");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_VARNAME() {
        var cacheKey = 'VARNAME@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        var result11 = parse_PN_CHARS_U();
        if (result11 !== null) {
          var result2 = result11;
        } else {
          if (input.substr(pos).match(/^[0-9]/) !== null) {
            var result10 = input.charAt(pos);
            pos++;
          } else {
            var result10 = null;
            if (reportMatchFailures) {
              matchFailed("[0-9]");
            }
          }
          if (result10 !== null) {
            var result2 = result10;
          } else {
            var result2 = null;;
          };
        }
        if (result2 !== null) {
          var result3 = [];
          var result9 = parse_PN_CHARS_U();
          if (result9 !== null) {
            var result4 = result9;
          } else {
            if (input.substr(pos).match(/^[0-9]/) !== null) {
              var result8 = input.charAt(pos);
              pos++;
            } else {
              var result8 = null;
              if (reportMatchFailures) {
                matchFailed("[0-9]");
              }
            }
            if (result8 !== null) {
              var result4 = result8;
            } else {
              if (input.substr(pos).match(/^[\xB7]/) !== null) {
                var result7 = input.charAt(pos);
                pos++;
              } else {
                var result7 = null;
                if (reportMatchFailures) {
                  matchFailed("[\\xB7]");
                }
              }
              if (result7 !== null) {
                var result4 = result7;
              } else {
                if (input.substr(pos).match(/^[\u0300-\u036F]/) !== null) {
                  var result6 = input.charAt(pos);
                  pos++;
                } else {
                  var result6 = null;
                  if (reportMatchFailures) {
                    matchFailed("[\\u0300-\\u036F]");
                  }
                }
                if (result6 !== null) {
                  var result4 = result6;
                } else {
                  if (input.substr(pos).match(/^[\u203F-\u2040]/) !== null) {
                    var result5 = input.charAt(pos);
                    pos++;
                  } else {
                    var result5 = null;
                    if (reportMatchFailures) {
                      matchFailed("[\\u203F-\\u2040]");
                    }
                  }
                  if (result5 !== null) {
                    var result4 = result5;
                  } else {
                    var result4 = null;;
                  };
                };
              };
            };
          }
          while (result4 !== null) {
            result3.push(result4);
            var result9 = parse_PN_CHARS_U();
            if (result9 !== null) {
              var result4 = result9;
            } else {
              if (input.substr(pos).match(/^[0-9]/) !== null) {
                var result8 = input.charAt(pos);
                pos++;
              } else {
                var result8 = null;
                if (reportMatchFailures) {
                  matchFailed("[0-9]");
                }
              }
              if (result8 !== null) {
                var result4 = result8;
              } else {
                if (input.substr(pos).match(/^[\xB7]/) !== null) {
                  var result7 = input.charAt(pos);
                  pos++;
                } else {
                  var result7 = null;
                  if (reportMatchFailures) {
                    matchFailed("[\\xB7]");
                  }
                }
                if (result7 !== null) {
                  var result4 = result7;
                } else {
                  if (input.substr(pos).match(/^[\u0300-\u036F]/) !== null) {
                    var result6 = input.charAt(pos);
                    pos++;
                  } else {
                    var result6 = null;
                    if (reportMatchFailures) {
                      matchFailed("[\\u0300-\\u036F]");
                    }
                  }
                  if (result6 !== null) {
                    var result4 = result6;
                  } else {
                    if (input.substr(pos).match(/^[\u203F-\u2040]/) !== null) {
                      var result5 = input.charAt(pos);
                      pos++;
                    } else {
                      var result5 = null;
                      if (reportMatchFailures) {
                        matchFailed("[\\u203F-\\u2040]");
                      }
                    }
                    if (result5 !== null) {
                      var result4 = result5;
                    } else {
                      var result4 = null;;
                    };
                  };
                };
              };
            }
          }
          if (result3 !== null) {
            var result1 = [result2, result3];
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        var result0 = result1 !== null
          ? (function(init, rpart) { return init+rpart.join('') })(result1[0], result1[1])
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[149] VARNAME");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_PN_CHARS() {
        var cacheKey = 'PN_CHARS@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var result6 = parse_PN_CHARS_U();
        if (result6 !== null) {
          var result0 = result6;
        } else {
          if (input.substr(pos, 1) === "-") {
            var result5 = "-";
            pos += 1;
          } else {
            var result5 = null;
            if (reportMatchFailures) {
              matchFailed("\"-\"");
            }
          }
          if (result5 !== null) {
            var result0 = result5;
          } else {
            if (input.substr(pos).match(/^[0-9]/) !== null) {
              var result4 = input.charAt(pos);
              pos++;
            } else {
              var result4 = null;
              if (reportMatchFailures) {
                matchFailed("[0-9]");
              }
            }
            if (result4 !== null) {
              var result0 = result4;
            } else {
              if (input.substr(pos).match(/^[\xB7]/) !== null) {
                var result3 = input.charAt(pos);
                pos++;
              } else {
                var result3 = null;
                if (reportMatchFailures) {
                  matchFailed("[\\xB7]");
                }
              }
              if (result3 !== null) {
                var result0 = result3;
              } else {
                if (input.substr(pos).match(/^[\u0300-\u036F]/) !== null) {
                  var result2 = input.charAt(pos);
                  pos++;
                } else {
                  var result2 = null;
                  if (reportMatchFailures) {
                    matchFailed("[\\u0300-\\u036F]");
                  }
                }
                if (result2 !== null) {
                  var result0 = result2;
                } else {
                  if (input.substr(pos).match(/^[\u203F-\u2040]/) !== null) {
                    var result1 = input.charAt(pos);
                    pos++;
                  } else {
                    var result1 = null;
                    if (reportMatchFailures) {
                      matchFailed("[\\u203F-\\u2040]");
                    }
                  }
                  if (result1 !== null) {
                    var result0 = result1;
                  } else {
                    var result0 = null;;
                  };
                };
              };
            };
          };
        }
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[150] PN_CHARS");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_PN_PREFIX() {
        var cacheKey = 'PN_PREFIX@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        var result2 = parse_PN_CHARS_BASE();
        if (result2 !== null) {
          var result3 = [];
          var result6 = parse_PN_CHARS();
          if (result6 !== null) {
            var result4 = result6;
          } else {
            if (input.substr(pos, 1) === ".") {
              var result5 = ".";
              pos += 1;
            } else {
              var result5 = null;
              if (reportMatchFailures) {
                matchFailed("\".\"");
              }
            }
            if (result5 !== null) {
              var result4 = result5;
            } else {
              var result4 = null;;
            };
          }
          while (result4 !== null) {
            result3.push(result4);
            var result6 = parse_PN_CHARS();
            if (result6 !== null) {
              var result4 = result6;
            } else {
              if (input.substr(pos, 1) === ".") {
                var result5 = ".";
                pos += 1;
              } else {
                var result5 = null;
                if (reportMatchFailures) {
                  matchFailed("\".\"");
                }
              }
              if (result5 !== null) {
                var result4 = result5;
              } else {
                var result4 = null;;
              };
            }
          }
          if (result3 !== null) {
            var result1 = [result2, result3];
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        var result0 = result1 !== null
          ? (function(base, rest) { if(rest[rest.length-1] == '.'){
                                                        	throw new Error("Wrong PN_PREFIX, cannot finish with '.'")
          					      } else {
          						  return base + rest.join('');
          					      }})(result1[0], result1[1])
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[151] PN_PREFIX");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_PN_LOCAL() {
        var cacheKey = 'PN_LOCAL@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        var result8 = parse_PN_CHARS_U();
        if (result8 !== null) {
          var result2 = result8;
        } else {
          if (input.substr(pos).match(/^[0-9]/) !== null) {
            var result7 = input.charAt(pos);
            pos++;
          } else {
            var result7 = null;
            if (reportMatchFailures) {
              matchFailed("[0-9]");
            }
          }
          if (result7 !== null) {
            var result2 = result7;
          } else {
            var result2 = null;;
          };
        }
        if (result2 !== null) {
          var result3 = [];
          var result6 = parse_PN_CHARS();
          if (result6 !== null) {
            var result4 = result6;
          } else {
            if (input.substr(pos, 1) === ".") {
              var result5 = ".";
              pos += 1;
            } else {
              var result5 = null;
              if (reportMatchFailures) {
                matchFailed("\".\"");
              }
            }
            if (result5 !== null) {
              var result4 = result5;
            } else {
              var result4 = null;;
            };
          }
          while (result4 !== null) {
            result3.push(result4);
            var result6 = parse_PN_CHARS();
            if (result6 !== null) {
              var result4 = result6;
            } else {
              if (input.substr(pos, 1) === ".") {
                var result5 = ".";
                pos += 1;
              } else {
                var result5 = null;
                if (reportMatchFailures) {
                  matchFailed("\".\"");
                }
              }
              if (result5 !== null) {
                var result4 = result5;
              } else {
                var result4 = null;;
              };
            }
          }
          if (result3 !== null) {
            var result1 = [result2, result3];
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        var result0 = result1 !== null
          ? (function(base, rest) { 
                                                                 return base + rest.join('');
                                                               })(result1[0], result1[1])
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[152] PN_LOCAL");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function buildErrorMessage() {
        function buildExpected(failuresExpected) {
          failuresExpected.sort();
          
          var lastFailure = null;
          var failuresExpectedUnique = [];
          for (var i = 0; i < failuresExpected.length; i++) {
            if (failuresExpected[i] !== lastFailure) {
              failuresExpectedUnique.push(failuresExpected[i]);
              lastFailure = failuresExpected[i];
            }
          }
          
          switch (failuresExpectedUnique.length) {
            case 0:
              return 'end of input';
            case 1:
              return failuresExpectedUnique[0];
            default:
              return failuresExpectedUnique.slice(0, failuresExpectedUnique.length - 1).join(', ')
                + ' or '
                + failuresExpectedUnique[failuresExpectedUnique.length - 1];
          }
        }
        
        var expected = buildExpected(rightmostMatchFailuresExpected);
        var actualPos = Math.max(pos, rightmostMatchFailuresPos);
        var actual = actualPos < input.length
          ? quote(input.charAt(actualPos))
          : 'end of input';
        
        return 'Expected ' + expected + ' but ' + actual + ' found.';
      }
      
      function computeErrorPosition() {
        /*
         * The first idea was to use |String.split| to break the input up to the
         * error position along newlines and derive the line and column from
         * there. However IE's |split| implementation is so broken that it was
         * enough to prevent it.
         */
        
        var line = 1;
        var column = 1;
        var seenCR = false;
        
        for (var i = 0; i <  rightmostMatchFailuresPos; i++) {
          var ch = input.charAt(i);
          if (ch === '\n') {
            if (!seenCR) { line++; }
            column = 1;
            seenCR = false;
          } else if (ch === '\r' | ch === '\u2028' || ch === '\u2029') {
            line++;
            column = 1;
            seenCR = true;
          } else {
            column++;
            seenCR = false;
          }
        }
        
        return { line: line, column: column };
      }
      
      
      
        var flattenString = function(arrs) {
      
            var acum ="";
      
            for(var i=0; i< arrs.length; i++) {
      
              if(typeof(arrs[i])==='string') {
      
                acum = acum + arrs[i];
      
              } else {
      
                acum = acum + arrs[i].join('');
      
              }
      
            }
      
    
      
            return acum;
      
        }
      
    
      
    
      
        var GlobalBlankNodeCounter = 0;
      
    
      
        var prefixes = {};
      
    
      
        var registerPrefix = function(prefix, uri) {
      
            prefixes[prefix] = uri;
      
        }
      
    
      
        var registerDefaultPrefix = function(uri) {
      
            prefixes[null] = uri;
      
        }
      
    
      
      var result = parseFunctions[startRule]();
      
      /*
       * The parser is now in one of the following three states:
       *
       * 1. The parser successfully parsed the whole input.
       *
       *    - |result !== null|
       *    - |pos === input.length|
       *    - |rightmostMatchFailuresExpected| may or may not contain something
       *
       * 2. The parser successfully parsed only a part of the input.
       *
       *    - |result !== null|
       *    - |pos < input.length|
       *    - |rightmostMatchFailuresExpected| may or may not contain something
       *
       * 3. The parser did not successfully parse any part of the input.
       *
       *   - |result === null|
       *   - |pos === 0|
       *   - |rightmostMatchFailuresExpected| contains at least one failure
       *
       * All code following this comment (including called functions) must
       * handle these states.
       */
      if (result === null || pos !== input.length) {
        var errorPosition = computeErrorPosition();
        throw new this.SyntaxError(
          buildErrorMessage(),
          errorPosition.line,
          errorPosition.column
        );
      }
      
      return result;
    },
    
    /* Returns the parser source code. */
    toSource: function() { return this._source; }
  };
  
  /* Thrown when a parser encounters a syntax error. */
  
  result.SyntaxError = function(message, line, column) {
    this.name = 'SyntaxError';
    this.message = message;
    this.line = line;
    this.column = column;
  };
  
  result.SyntaxError.prototype = Error.prototype;
  
  return result;
})();

TurtleParser.parser.parse = function(data, graph) {
    var quads = [];

    var result = TurtleParser.parser.innerParse(data);
    var namespaces = {};
    var env = {namespaces: namespaces, base:'', blankCounter: 0};

    statementCounter = 0;

    for(var i=0; i<result.length; i++) {
        var unit = result[i];
        if(unit.token === 'base') {
            env.base = unit.value;
        } else if(unit.token === 'prefix') {
            namespaces[unit.prefix] = unit.local;
        } else if(unit.token === 'triples') {
            for(var j=0; j<unit.triplesContext.length; j++) {
                var triple = unit.triplesContext[j];
                var quad = { subject: Utils.lexicalFormTerm(triple.subject, env),
                             predicate: Utils.lexicalFormTerm(triple.predicate, env),
                             object: Utils.lexicalFormTerm(triple.object, env),
                             graph: graph };
     
                quads.push(quad);
            }
        }
    }

    return quads;
};


// end of ./src/js-communication/src/turtle_parser.js 
// exports
var JSONLDParser = {};

// imports

JSONLDParser.parser = {};
JSONLDParser.parser.parse = function(data, graph) {
    var state = {
        defaultContext: { "rdf": "http://www.w3.org/1999/02/22-rdf-syntax-ns#",
                          "rdfs": "http://www.w3.org/2000/01/rdf-schema#",
                          "owl": "http://www.w3.org/2002/07/owl#",
                          "xsd": "http://www.w3.org/2001/XMLSchema#",
                          "dcterms": "http://purl.org/dc/terms/",
                          "foaf": "http://xmlns.com/foaf/0.1/",
                          "cal": "http://www.w3.org/2002/12/cal/ical#",
                          "vcard": "http://www.w3.org/2006/vcard/ns# ",
                          "geo": "http://www.w3.org/2003/01/geo/wgs84_pos#",
                          "cc": "http://creativecommons.org/ns#",
                          "sioc": "http://rdfs.org/sioc/ns#",
                          "doap": "http://usefulinc.com/ns/doap#",
                          "com": "http://purl.org/commerce#",
                          "ps": "http://purl.org/payswarm#",
                          "gr": "http://purl.org/goodrelations/v1#",
                          "sig": "http://purl.org/signature#",
                          "ccard": "http://purl.org/commerce/creditcard#",
                          "@coerce": 
                          {
                              "http://www.w3.org/2001/XMLSchema#anyURI": ["http://xmlns.com/foaf/0.1/homepage", "http://xmlns.com/foaf/0.1/member"],
                              "http://www.w3.org/2001/XMLSchema#integer": "http://xmlns.com/foaf/0.1/age"
                          }
                        },
        defaultGraph: null,
        activeSubject: null,
        inheritedSubject: null,
        activePredicate: null,
        inheritedPredicate: null,
        activeObject: null,
        activeContext: [],
        localContext: {},
        listOfIncompleteTriples: [],
        listOfUnprocessedItems: []
    }

    var triples = [];
    var nodeId = 0;

    // 1) Push the default context onto the active context stack.
    state.activeContext = state.defaultContext;
    if(JSONLDParser.parser.isArray(data)) {
        JSONLDParser.parser.parseListOfNodes(data, state, null, null, triples, nodeId);
    } else {
        JSONLDParser.parser.parseListOfNodes([data], state, null, null, triples, nodeId);
    }

    var quads = [];
    for(var i=0; i<triples.length; i++) {
        var quad = triples[i];
        quad.graph = graph;
        quads.push(quad);
    }
    return quads;
};

JSONLDParser.parser.parseListOfNodes = function(data, state, inheritedSubject, inheritedPredicate, triples, nodeId) {

    for(var i=0; i<data.length; i++) {
        var token = data[i];

        //create a new processor state. 
        processorState = { activeSubject: null,
                           inheritedSubject: inheritedSubject,
                           activePredicate: null,
                           inheritedPredicate: inheritedPredicate,
                           activeObject: null,
                           localContext: {},
                           listOfIncompleteTriples: [],
                           listOfUnprocessedItems: []
                         };

        //Copy the current context stack to the newly created processor state. 
        //Push the active context onto the newly created processor state's active context stack. 
        processorState['activeContext'] = JSONLDParser.parser.copyContext(state.activeContext);


        //If an associative array is detected, 
        if(JSONLDParser.parser.isAssociatveArray(token)) {

            /*
              If a @context keyword is found, the processor merges each key-value pair in the local context into the active context, 
              overwriting any duplicate values in the active context. 
              If the @coerce key is found, the processor merges each key-value pair in the local context's @coerce mapping into the active context's @coerce mapping, 
              overwriting any duplicate values in the active context's @coerce mapping. 
              Process each object in the list of unprocessed items, starting at Step 2.2.
            */
            if(token['@context'] != null) {
                processorState['activeContext'] = JSONLDParser.parser.mergeContexts(processorState['activeContext'], token['@context']);
            }


            if(token['@'] != null) {
                value = token['@'];
                // If a @ key is found, the processor sets the active subject to the value after Object Processing has been performed. 

                processorState.activeSubject = JSONLDParser.parser.parseIri(value,processorState['activeContext']);
            } else {
                processorState.activeSubject = {'token':'uri', 'value':"_:"+nodeId};
                nodeId++;
            }

            // if the inherited subject and inherited predicate values are specified, 
            // generate a triple using the inherited subject for the subject, the inherited 
            // predicate for the predicate, and the active subject for the object.
            if(processorState.inheritedPredicate != null && processorState.inheritedSubject != null) {
                triples.push({subject: processorState.inheritedSubject, predicate: processorState.inheritedPredicate, object: processorState.activeSubject});
            }


            //For each key-value pair in the associative array, using the newly created processor state do the following: 
            for(var key in token) {

                var value = token[key];

                if(key !== '@context' && key !== '@') {
                    if( key === 'a') {
                        // If an 'a' key is found, set the active predicate to http://www.w3.org/1999/02/22-rdf-syntax-ns#type. 
                        processorState.activePredicate = {token: 'uri', value:'http://www.w3.org/1999/02/22-rdf-syntax-ns#type'};

                    } else {
                        //  If a key that is not @context, @, or a, set the active predicate by performing Predicate Processing on the key. 
                        processorState.activePredicate = JSONLDParser.parser.parseIri(key, processorState['activeContext']);
                    }

                    if(typeof(value) != 'object') {
                        processorState.activeObject = JSONLDParser.parser.coerceLiteral(value, processorState.activePredicate, processorState.activeContext);
                        triples.push({subject: processorState.activeSubject, predicate:processorState.activePredicate, object:processorState.activeObject});
                    } else if(value.length != null) {
                        // process new triple per object
                        JSONLDParser.parser.parseListOfNodes(value, processorState, processorState.activeSubject, processorState.activePredicate, triples, nodeId);
                    } else {
                        if(value['@iri'] != null) {
                            triples.push({subject: processorState.activeSubject, predicate: processorState.activePredicate, object: JSONLDParser.parser.parseIri(value)});
                        } else if(value['@literal'] != null) {
                            var object = null
                            if(value['@language']) {
                                obj = {'token': 'literal', 'value': value['@literal'], 'lang': value['@language']};
                            } else {
                                obj = JSONLDParser.parser.coerceLiteral(value['@literal']);
                                obj['type'] = object['type'] || value['@datatype'];
                            }

                            triples.push({subject: processorState.activeSubject, predicate: processorState.activePredicate, object: obj});                   
                        } else {
                            JSONLDParser.parser.parseListOfNodes([value], processorState, null, null, triples);
                        }
                    }
                }
            }
        } else if(typeof(token) === 'string') {
            if(processorState.inheritedPredicate != null && processorState.inheritedSubject != null) {
                triples.push({subject: processorState.inheritedSubject, 
                              predicate: processorState.inheritedPredicate, 
                              object: JSONLDParser.parser.coerceLiteral(token, 
                                                                        processorState.inheritedPredicate, 
                                                                        processorState['activeContext'])});
            }
        }
    }
};

JSONLDParser.parser.coerceLiteral = function(value, activePredicate, activeContext) {
    var coercion = null;

    for(var ns in (activeContext || {})) {
        var uri = activeContext[ns];
        if(value.indexOf(ns) === 0) {
            return {'token': 'uri',
                    'value': uri+(value.split(ns+":")[1]||"")}
        } else {
            if(uri === value) {
                return {'token': 'uri', 'value': uri};
            }
        }
    }

    for(var type in (activeContext['@coerce']||{})) {
        var propertiesToCoerce = activeContext['@coerce'][type];

        if(typeof(propertiesToCoerce) === 'string') {
            propertiesToCoerce = [ propertiesToCoerce ];
        }

        for(var ns in activeContext) {
            for(var i=0; i<propertiesToCoerce.length; i++) {                
                var expandedCoerce = propertiesToCoerce[i];
                if(expandedCoerce.indexOf(ns) === 0) {
                    expandedCoerce = expandedCoerce.split(ns+":")[1]||"";
                    expandedCoerce = activeContext[ns] + expandedCoerce;
                } 
                if(expandedCoerce === activePredicate.value) {
                    if(type === 'http://www.w3.org/2001/XMLSchema#anyURI' || type === 'xsd:anyURI') {
                        return {'token': 'uri', 'value': value}; 
                    } else {
                        return {'token': 'literal', 'value': value, 'type': type}; 
                    }
                }
            }
        }
    }

    return {'token': 'literal', 'value': value};
};

JSONLDParser.parser.isAssociatveArray = function(token) {
    return typeof(token) === 'object' && token.length == null;
};

JSONLDParser.parser.isArray = function(token) {
    return typeof(token) === 'object' && token.length != null;
};

JSONLDParser.parser.copyContext = function(currentContext) {
    var currentContextCopy = {};
    for(var p in currentContext) {
        if(p === "@coerce") {
            var coercion = currentContext[p];
            var coercionCopy = {};
            for(var c in coercion) {
                coercionCopy[c] = coercion[c];
            }
            currentContextCopy[p] = coercionCopy;
        } else {
            currentContextCopy[p] = currentContext[p];
        }
    }
    return currentContextCopy;
};

JSONLDParser.parser.mergeContexts = function(src, dst) {
    for(var p in dst) {
        if(p !== '@coerce') {
            src[p] = dst[p];
        }
    }

    if(dst["@coerce"] != null) {
        var coercion = dst["@coerce"];
        var srcCoercion = src['@coerce'] || {};
        for(var c in coercion) {
            if(typeof(coercion[c]) === 'string') {
                srcCoercion[JSONLDParser.parser.parseIri(c,src).value] = JSONLDParser.parser.parseIri(coercion[c], src).value;
            } else {
                var tmp = [];
                for(var j=0; j<coercion[c].length; j++) {
                    tmp.push(JSONLDParser.parser.parseIri(coercion[c][j], src).value);
                }
            }
        }
        src['@coerce'] = srcCoercion;
    }
    return src;
};

JSONLDParser.parser.copyContextStack = function(contextStack) {
    var newContext = [];

    for(var i=0; i<contextStack.length; i++) {
        var currentContext = contextStack[i];
        var currentContextCopy = {};
        for(var p in currentContext) {
            if(p === "@coerce") {
                var coercion = currentContext[p];
                var coercionCopy = {};
                for(var c in coercion) {
                    if(typeof(coercion[c]) === 'object') {
                        var coercionCopyArray = [];
                        for(var j=0; j<coercion[c].length; j++) {
                            coercionCopyArray.push(coercion[c][j]);
                        }
                        coercionCopy[c] = coercionCopyArray;
                    } else {
                        coercionCopy[c] = coercion[c];
                    }
                }
                currentContextCopy[p] = coercionCopy;
            } else {
                currentContextCopy[p] = currentContext[p];
            }
        }

        newContext.push(currentContextCopy);
    }

    return newContext;
}

JSONLDParser.parser.parseIri = function(object,context) {
    if(typeof(object) === 'object') {
        if(object['@iri'] != null) {
            object = object['@iri'];
        } else {
            throw("Error processing iri");
        }
    } 

    for(var c in context) {
        if(c == '@base' && object.indexOf(":") === 0) {
            return {'token': 'uri', 'value': context[c] + (object.split(":")[1]||"")};
        } else  if(object.indexOf(c) === 0) {
            return {'token': 'uri', 'value': context[c] + (object.split(c+":")[1]||"")};
        }
    }

    if(object.indexOf(":") === -1 && context['@vocab'] != null) {
        return {'token': 'uri', 'value': context['@vocab']+object};
    } else {
        if(object.indexOf(":") != -1) {
            return {'token': 'uri', 'value': object};
        } else {
            throw("Cannot resolve URI: "+object);
        }
    }
}

JSONLDParser.parser.parseObject = function(object,context) {
    if(typeof(object) === 'object') {
        if(object['@iri'] != null) {
            return {'token': 'uri','value': object['@iri']};
        } else {
            throw("Error processing iri");
        }
    } else {
        for(var c in context) {
            if(object.indexOf(c) === 0) {
                return {'token': 'uri', 'value':context[c] + (object.split(c+":")[1]||"")};
            }
        }

        return {'token': 'uri', 'value': object};
    }
}

// end of ./src/js-communication/src/jsonld_parser.js 
// exports
var RDFLoader = {};

// imports

RDFLoader.RDFLoader = function(params) {
    this.precedences = ["text/turtle", "text/n3", "application/json"];
    this.parsers = {"text/turtle": TurtleParser.parser, "text/n3":TurtleParser.parser, "application/json":JSONLDParser.parser};
    if(params != null) {
      for(var mime in params["parsers"]) {
          this.parsers[mime] = params["parsers"][mime];
      }
    }

    if(params && params["precedences"] != null) {
        this.precedences = params["precedences"];
        for(var mime in params["parsers"]) {
            if(!Utils.include(this.precedences, mime)) {
                this.precedences.push(mime);
            }
        }
    }

    this.acceptHeaderValue = "";
    for(var i=0; i<this.precedences.length; i++) {
        if(i!=0) {
            this.acceptHeaderValue = this.acceptHeaderValue + "," + this.precedences[i];
        } else {
            this.acceptHeaderValue = this.acceptHeaderValue + this.precedences[i];
        }
    }
}

RDFLoader.RDFLoader.prototype.registerParser = function(mediaType, parser) {
    this.parsers[mediaType] = parser;
    this.precedences.push(mediaType);
};

RDFLoader.RDFLoader.prototype.unregisterParser = function(mediaType) {
    delete this.parsers[mediaType];
    var mediaTypes = [];
    for(var i=0; i<this.precedences.length; i++) {
        if(this.precedences[i] != mediaType) {
            mediaTypes.push(this.precedences[i]);
        }
    }

    this.precedences = mediaTypes;
};

RDFLoader.RDFLoader.prototype.setAcceptHeaderPrecedence = function(mediaTypes) {
    this.precedences = mediaTypes;
};

RDFLoader.RDFLoader.prototype.load = function(uri, graph, callback) {
    var that = this;
    NetworkTransport.load(uri, this.acceptHeaderValue, function(success, results){
        if(success == true) {
            var mime = results["headers"]["Content-Type"] || results["headers"]["content-type"];
            var data = results['data'];
            if(mime != null) {
                mime = mime.split(";")[0]
                for(var m in that.parsers) {
                    if(m.indexOf("/")!=-1) {
                        var mimeParts = m.split("/");
                        if(mimeParts[1] === '*') {
                            if(mime.indexOf(mimeParts[0])!=-1) {
                                return that.tryToParse(that.parsers[m], graph, data, callback);
                            }
                        } else {
                            if(mime.indexOf(m)!=-1) {
                                return that.tryToParse(that.parsers[m], graph, data, callback);
                            } else if(mime.indexOf(mimeParts[1])!=-1) {
                                return that.tryToParse(that.parsers[m], graph, data, callback);
                            }
                        }
                    } else {
                        if(mime.indexOf(m)!=-1) {
                            return that.tryToParse(that.parsers[m], uri, graph, callback);
                        }
                    }
                }
                callback(false, "Unknown media type : "+mime);
            } else {
                console.log("Unknown media type");
                console.log(results["headers"]);
                callback(false, "Uknown media type");
            }
        } else {
            callback(false, "Network error: "+results);
        }});
};

RDFLoader.RDFLoader.prototype.loadFromFile = function(parser, graph, uri, callback) {
    try {
        var that = this;
        fs = require('fs');
        fs.readFile(uri.split("file:/")[1], function(err, data) {
            if(err) throw err;
            var data = data.toString('utf8');
            that.tryToParse(parser, graph, data, callback);
        });
    } catch(e) {
        callback(false, e);
    }
};

RDFLoader.RDFLoader.prototype.tryToParse = function(parser, graph, input, callback) {
    try {
        if(typeof(input) === 'string') {
            input = Utils.normalizeUnicodeLiterals(input);
        }
        var parsed = parser.parse(input, graph);

        if(parsed != null) {
            callback(true, parsed);
        } else {
            callback(false, "parsing error");
        }
    } catch(e) {
        callback(false, "parsing error with mime type : " + e);
    }
};



// var loader = require("./js-communication/src/rdf_loader").RDFLoader; loader = new loader.RDFLoader(); loader.load('http://dbpedialite.org/titles/Lisp_%28programming_language%29', function(success, results){console.log("hey"); console.log(success); console.log(results)})

// end of ./src/js-communication/src/rdf_loader.js 
// exports
var AbstractQueryTree = {};

// imports

/**
 * @doc
 *
 * Based on <http://www.w3.org/2001/sw/DataAccess/rq23/rq24-algebra.html>
 * W3C's note
 */
AbstractQueryTree.AbstractQueryTree = function(params) {
};

AbstractQueryTree.AbstractQueryTree.prototype.parseQueryString = function(query_string) {
    var syntaxTree  = SparqlParser.parser.parse(query_string);
    return syntaxTree;
};

AbstractQueryTree.AbstractQueryTree.prototype.parseExecutableUnit = function(executableUnit) {
    if(executableUnit.kind === 'select') {
        return this.parseSelect(executableUnit);
    } else if(executableUnit.kind === 'ask') {
        return this.parseSelect(executableUnit);        
    } else if(executableUnit.kind === 'modify') {
        return this.parseSelect(executableUnit);
    } else if(executableUnit.kind === 'construct') {
        return this.parseSelect(executableUnit);        
    } else if(executableUnit.kind === 'insertdata') {
        return this.parseInsertData(executableUnit);        
    } else if(executableUnit.kind === 'deletedata') {
        return this.parseInsertData(executableUnit);        
    } else if(executableUnit.kind === 'load') {
        return executableUnit;
    } else if(executableUnit.kind === 'clear') {
        return executableUnit;
    } else if(executableUnit.kind === 'drop') {
        return executableUnit;
    } else if(executableUnit.kind === 'create') {
        return executableUnit;
    } else {
        throw new Error('unknown executable unit: ' + executableUnit.kind);
    }
};

AbstractQueryTree.AbstractQueryTree.prototype.parseSelect = function(syntaxTree){

    if(syntaxTree == null) {
        console.log("error parsing query");
        return null;
    } else {
        var env = {};
        syntaxTree.pattern = this.build(syntaxTree.pattern, env);
        return syntaxTree;
    }
};

AbstractQueryTree.AbstractQueryTree.prototype.parseInsertData = function(syntaxTree){
    if(syntaxTree == null) {
        console.log("error parsing query");
        return null;
    } else {
        return syntaxTree;
    }
};

AbstractQueryTree.AbstractQueryTree.prototype.build = function(node, env) {
    if(node.token === 'groupgraphpattern') {
        return this._buildGroupGraphPattern(node, env);
    } else if (node.token === 'basicgraphpattern') {
        return { kind: 'BGP',
                 value: node.triplesContext };
    } else if (node.token === 'graphunionpattern') {
        var a = this.build(node.value[0],env);
        var b = this.build(node.value[1],env);

        return { kind: 'UNION',
                 value: [a,b] };
    } else if(node.token === 'graphgraphpattern') {
        var c = this.build(node.value, env);
        return { kind: 'GRAPH',
                 value: c,
                 graph: node.graph };
    } else {
        throw new Error("not supported token in query:"+node.token);
    }
};

AbstractQueryTree.AbstractQueryTree.prototype._buildGroupGraphPattern = function(node, env) {
    var f = (node.filters || []);
    var g = {kind: "EMPTY_PATTERN"};

    for(var i=0; i<node.patterns.length; i++) {
        var pattern = node.patterns[i];
        if(pattern.token === 'optionalgraphpattern') {
            var parsedPattern = this.build(pattern.value,env);
            if(parsedPattern.kind === 'FILTER') {
                g =  { kind:'LEFT_JOIN',
                       lvalue: g,
                       rvalue: parsedPattern.value,
                       filter: parsedPattern.filter }
            } else {
                g = { kind:'LEFT_JOIN',
                      lvalue: g,
                      rvalue: parsedPattern,
                      filter: true };
            }
        } else {
            var parsedPattern = this.build(pattern,env);
            if(g.kind == "EMPTY_PATTERN") {
                g = parsedPattern;
            } else {
                g = { kind: 'JOIN',
                      lvalue: g,
                      rvalue: parsedPattern };
            }
        }
    }

    if(f.length != 0) {
        if(g.kind === 'EMPTY_PATTERN') {
            return { kind: 'FILTER',
                     filter: f,
                     value: g};
        } else if(g.kind === 'LEFT_JOIN' && g.filter === true) {
            return { kind: 'FILTER',
                     filter: f,
                     value: g};

//            g.filter = f;
//            return g;
        } else if(g.kind === 'LEFT_JOIN') {
            return { kind: 'FILTER',
                     filter: f,
                     value: g};
        } else if(g.kind === 'JOIN') {
            return { kind: 'FILTER',
                     filter: f,
                     value: g};
        } else if(g.kind === 'UNION') {
            return { kind: 'FILTER',
                     filter: f,
                     value: g};
        } else if(g.kind === 'GRAPH') {
            return { kind: 'FILTER',
                     filter: f,
                     value: g};
        } else if(g.kind === 'BGP') {
            return { kind: 'FILTER',
                     filter: f,
                     value: g};
        } else {
            throw new Error("Unknow kind of algebra expression: "+ g.kind);
        }
    } else {
        return g;
    }
};

// end of ./src/js-sparql-parser/src/abstract_query_tree.js 
// exports
var SparqlParser = {};

SparqlParser.parser = (function(){
  /* Generated by PEG.js 0.6.1 (http://pegjs.majda.cz/). */
  
  var result = {
    /*
     * Parses the input with a generated parser. If the parsing is successfull,
     * returns a value explicitly or implicitly specified by the grammar from
     * which the parser was generated (see |PEG.buildParser|). If the parsing is
     * unsuccessful, throws |PEG.parser.SyntaxError| describing the error.
     */
    parse: function(input, startRule) {
      var parseFunctions = {
        "ANON": parse_ANON,
        "AdditiveExpression": parse_AdditiveExpression,
        "Aggregate": parse_Aggregate,
        "ArgList": parse_ArgList,
        "AskQuery": parse_AskQuery,
        "BLANK_NODE_LABEL": parse_BLANK_NODE_LABEL,
        "BaseDecl": parse_BaseDecl,
        "BindingValue": parse_BindingValue,
        "BindingsClause": parse_BindingsClause,
        "BlankNode": parse_BlankNode,
        "BlankNodePropertyList": parse_BlankNodePropertyList,
        "BooleanLiteral": parse_BooleanLiteral,
        "BrackettedExpression": parse_BrackettedExpression,
        "BuiltInCall": parse_BuiltInCall,
        "COMMENT": parse_COMMENT,
        "Clear": parse_Clear,
        "Collection": parse_Collection,
        "ConditionalAndExpression": parse_ConditionalAndExpression,
        "ConditionalOrExpression": parse_ConditionalOrExpression,
        "Constraint": parse_Constraint,
        "ConstructQuery": parse_ConstructQuery,
        "ConstructTemplate": parse_ConstructTemplate,
        "ConstructTriples": parse_ConstructTriples,
        "Create": parse_Create,
        "DECIMAL": parse_DECIMAL,
        "DECIMAL_NEGATIVE": parse_DECIMAL_NEGATIVE,
        "DECIMAL_POSITIVE": parse_DECIMAL_POSITIVE,
        "DOUBLE": parse_DOUBLE,
        "DOUBLE_NEGATIVE": parse_DOUBLE_NEGATIVE,
        "DOUBLE_POSITIVE": parse_DOUBLE_POSITIVE,
        "DatasetClause": parse_DatasetClause,
        "DefaultGraphClause": parse_DefaultGraphClause,
        "DeleteClause": parse_DeleteClause,
        "DeleteData": parse_DeleteData,
        "DeleteWhere": parse_DeleteWhere,
        "DescribeQuery": parse_DescribeQuery,
        "Drop": parse_Drop,
        "ECHAR": parse_ECHAR,
        "EXPONENT": parse_EXPONENT,
        "ExistsFunc": parse_ExistsFunc,
        "ExpressionList": parse_ExpressionList,
        "Filter": parse_Filter,
        "FunctionCall": parse_FunctionCall,
        "GraphGraphPattern": parse_GraphGraphPattern,
        "GraphNode": parse_GraphNode,
        "GraphPatternNotTriples": parse_GraphPatternNotTriples,
        "GraphRef": parse_GraphRef,
        "GraphRefAll": parse_GraphRefAll,
        "GraphTerm": parse_GraphTerm,
        "GroupClause": parse_GroupClause,
        "GroupCondition": parse_GroupCondition,
        "GroupGraphPattern": parse_GroupGraphPattern,
        "GroupGraphPatternSub": parse_GroupGraphPatternSub,
        "GroupOrUnionGraphPattern": parse_GroupOrUnionGraphPattern,
        "HavingClause": parse_HavingClause,
        "INTEGER": parse_INTEGER,
        "INTEGER_NEGATIVE": parse_INTEGER_NEGATIVE,
        "INTEGER_POSITIVE": parse_INTEGER_POSITIVE,
        "IRI_REF": parse_IRI_REF,
        "IRIref": parse_IRIref,
        "IRIrefOrFunction": parse_IRIrefOrFunction,
        "InsertClause": parse_InsertClause,
        "InsertData": parse_InsertData,
        "LANGTAG": parse_LANGTAG,
        "LimitClause": parse_LimitClause,
        "LimitOffsetClauses": parse_LimitOffsetClauses,
        "Load": parse_Load,
        "MinusGraphPattern": parse_MinusGraphPattern,
        "Modify": parse_Modify,
        "MultiplicativeExpression": parse_MultiplicativeExpression,
        "NIL": parse_NIL,
        "NamedGraphClause": parse_NamedGraphClause,
        "NotExistsFunc": parse_NotExistsFunc,
        "NumericLiteral": parse_NumericLiteral,
        "NumericLiteralNegative": parse_NumericLiteralNegative,
        "NumericLiteralPositive": parse_NumericLiteralPositive,
        "NumericLiteralUnsigned": parse_NumericLiteralUnsigned,
        "ObjectList": parse_ObjectList,
        "OffsetClause": parse_OffsetClause,
        "OptionalGraphPattern": parse_OptionalGraphPattern,
        "OrderClause": parse_OrderClause,
        "OrderCondition": parse_OrderCondition,
        "PNAME_LN": parse_PNAME_LN,
        "PNAME_NS": parse_PNAME_NS,
        "PN_CHARS": parse_PN_CHARS,
        "PN_CHARS_BASE": parse_PN_CHARS_BASE,
        "PN_CHARS_U": parse_PN_CHARS_U,
        "PN_LOCAL": parse_PN_LOCAL,
        "PN_PREFIX": parse_PN_PREFIX,
        "PathAlternative": parse_PathAlternative,
        "PathElt": parse_PathElt,
        "PathEltOrInverse": parse_PathEltOrInverse,
        "PathMod": parse_PathMod,
        "PathNegatedPropertySet": parse_PathNegatedPropertySet,
        "PathOneInPropertySet": parse_PathOneInPropertySet,
        "PathPrimary": parse_PathPrimary,
        "PathSequence": parse_PathSequence,
        "PrefixDecl": parse_PrefixDecl,
        "PrefixedName": parse_PrefixedName,
        "PrimaryExpression": parse_PrimaryExpression,
        "Prologue": parse_Prologue,
        "PropertyList": parse_PropertyList,
        "PropertyListNotEmpty": parse_PropertyListNotEmpty,
        "PropertyListNotEmptyPath": parse_PropertyListNotEmptyPath,
        "PropertyListPath": parse_PropertyListPath,
        "QuadData": parse_QuadData,
        "QuadPattern": parse_QuadPattern,
        "Quads": parse_Quads,
        "QuadsNotTriples": parse_QuadsNotTriples,
        "Query": parse_Query,
        "RDFLiteral": parse_RDFLiteral,
        "RegexExpression": parse_RegexExpression,
        "RelationalExpression": parse_RelationalExpression,
        "SPARQL": parse_SPARQL,
        "STRING_LITERAL1": parse_STRING_LITERAL1,
        "STRING_LITERAL2": parse_STRING_LITERAL2,
        "STRING_LITERAL_LONG1": parse_STRING_LITERAL_LONG1,
        "STRING_LITERAL_LONG2": parse_STRING_LITERAL_LONG2,
        "SelectClause": parse_SelectClause,
        "SelectQuery": parse_SelectQuery,
        "ServiceGraphPattern": parse_ServiceGraphPattern,
        "SolutionModifier": parse_SolutionModifier,
        "String": parse_String,
        "SubSelect": parse_SubSelect,
        "TriplesBlock": parse_TriplesBlock,
        "TriplesNode": parse_TriplesNode,
        "TriplesSameSubject": parse_TriplesSameSubject,
        "TriplesTemplate": parse_TriplesTemplate,
        "UnaryExpression": parse_UnaryExpression,
        "Update": parse_Update,
        "Update1": parse_Update1,
        "UsingClause": parse_UsingClause,
        "VAR1": parse_VAR1,
        "VAR2": parse_VAR2,
        "VARNAME": parse_VARNAME,
        "Var": parse_Var,
        "VarOrIRIref": parse_VarOrIRIref,
        "VarOrTerm": parse_VarOrTerm,
        "Verb": parse_Verb,
        "VerbPath": parse_VerbPath,
        "WS": parse_WS,
        "WhereClause": parse_WhereClause
      };
      
      if (startRule !== undefined) {
        if (parseFunctions[startRule] === undefined) {
          throw new Error("Invalid rule name: " + quote(startRule) + ".");
        }
      } else {
        startRule = "SPARQL";
      }
      
      var pos = 0;
      var reportMatchFailures = true;
      var rightmostMatchFailuresPos = 0;
      var rightmostMatchFailuresExpected = [];
      var cache = {};
      
      function padLeft(input, padding, length) {
        var result = input;
        
        var padLength = length - input.length;
        for (var i = 0; i < padLength; i++) {
          result = padding + result;
        }
        
        return result;
      }
      
      function escape(ch) {
        var charCode = ch.charCodeAt(0);
        
        if (charCode <= 0xFF) {
          var escapeChar = 'x';
          var length = 2;
        } else {
          var escapeChar = 'u';
          var length = 4;
        }
        
        return '\\' + escapeChar + padLeft(charCode.toString(16).toUpperCase(), '0', length);
      }
      
      function quote(s) {
        /*
         * ECMA-262, 5th ed., 7.8.4: All characters may appear literally in a
         * string literal except for the closing quote character, backslash,
         * carriage return, line separator, paragraph separator, and line feed.
         * Any character may appear in the form of an escape sequence.
         */
        return '"' + s
          .replace(/\\/g, '\\\\')            // backslash
          .replace(/"/g, '\\"')              // closing quote character
          .replace(/\r/g, '\\r')             // carriage return
          .replace(/\n/g, '\\n')             // line feed
          .replace(/[\x80-\uFFFF]/g, escape) // non-ASCII characters
          + '"';
      }
      
      function matchFailed(failure) {
        if (pos < rightmostMatchFailuresPos) {
          return;
        }
        
        if (pos > rightmostMatchFailuresPos) {
          rightmostMatchFailuresPos = pos;
          rightmostMatchFailuresExpected = [];
        }
        
        rightmostMatchFailuresExpected.push(failure);
      }
      
      function parse_SPARQL() {
        var cacheKey = 'SPARQL@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        
        var result2 = parse_Query();
        if (result2 !== null) {
          var result0 = result2;
        } else {
          var result1 = parse_Update();
          if (result1 !== null) {
            var result0 = result1;
          } else {
            var result0 = null;;
          };
        }
        
        
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_Query() {
        var cacheKey = 'Query@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        var result2 = parse_Prologue();
        if (result2 !== null) {
          var result7 = parse_SelectQuery();
          if (result7 !== null) {
            var result3 = result7;
          } else {
            var result6 = parse_ConstructQuery();
            if (result6 !== null) {
              var result3 = result6;
            } else {
              var result5 = parse_DescribeQuery();
              if (result5 !== null) {
                var result3 = result5;
              } else {
                var result4 = parse_AskQuery();
                if (result4 !== null) {
                  var result3 = result4;
                } else {
                  var result3 = null;;
                };
              };
            };
          }
          if (result3 !== null) {
            var result1 = [result2, result3];
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        var result0 = result1 !== null
          ? (function(p, q) {
                return {token: 'query',
                        kind: 'query',
                        prologue: p,
                        units: [q]};
          })(result1[0], result1[1])
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[2] Query");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_Prologue() {
        var cacheKey = 'Prologue@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        var result7 = parse_BaseDecl();
        var result2 = result7 !== null ? result7 : '';
        if (result2 !== null) {
          var result3 = [];
          var result6 = parse_WS();
          while (result6 !== null) {
            result3.push(result6);
            var result6 = parse_WS();
          }
          if (result3 !== null) {
            var result4 = [];
            var result5 = parse_PrefixDecl();
            while (result5 !== null) {
              result4.push(result5);
              var result5 = parse_PrefixDecl();
            }
            if (result4 !== null) {
              var result1 = [result2, result3, result4];
            } else {
              var result1 = null;
              pos = savedPos0;
            }
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        var result0 = result1 !== null
          ? (function(b, pfx) {
                return { token: 'prologue',
                         base: b,
                         prefixes: pfx }
          })(result1[0], result1[2])
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[3] Prologue");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_BaseDecl() {
        var cacheKey = 'BaseDecl@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        var result2 = [];
        var result18 = parse_WS();
        while (result18 !== null) {
          result2.push(result18);
          var result18 = parse_WS();
        }
        if (result2 !== null) {
          if (input.substr(pos, 1) === "B") {
            var result17 = "B";
            pos += 1;
          } else {
            var result17 = null;
            if (reportMatchFailures) {
              matchFailed("\"B\"");
            }
          }
          if (result17 !== null) {
            var result3 = result17;
          } else {
            if (input.substr(pos, 1) === "b") {
              var result16 = "b";
              pos += 1;
            } else {
              var result16 = null;
              if (reportMatchFailures) {
                matchFailed("\"b\"");
              }
            }
            if (result16 !== null) {
              var result3 = result16;
            } else {
              var result3 = null;;
            };
          }
          if (result3 !== null) {
            if (input.substr(pos, 1) === "A") {
              var result15 = "A";
              pos += 1;
            } else {
              var result15 = null;
              if (reportMatchFailures) {
                matchFailed("\"A\"");
              }
            }
            if (result15 !== null) {
              var result4 = result15;
            } else {
              if (input.substr(pos, 1) === "a") {
                var result14 = "a";
                pos += 1;
              } else {
                var result14 = null;
                if (reportMatchFailures) {
                  matchFailed("\"a\"");
                }
              }
              if (result14 !== null) {
                var result4 = result14;
              } else {
                var result4 = null;;
              };
            }
            if (result4 !== null) {
              if (input.substr(pos, 1) === "S") {
                var result13 = "S";
                pos += 1;
              } else {
                var result13 = null;
                if (reportMatchFailures) {
                  matchFailed("\"S\"");
                }
              }
              if (result13 !== null) {
                var result5 = result13;
              } else {
                if (input.substr(pos, 1) === "s") {
                  var result12 = "s";
                  pos += 1;
                } else {
                  var result12 = null;
                  if (reportMatchFailures) {
                    matchFailed("\"s\"");
                  }
                }
                if (result12 !== null) {
                  var result5 = result12;
                } else {
                  var result5 = null;;
                };
              }
              if (result5 !== null) {
                if (input.substr(pos, 1) === "E") {
                  var result11 = "E";
                  pos += 1;
                } else {
                  var result11 = null;
                  if (reportMatchFailures) {
                    matchFailed("\"E\"");
                  }
                }
                if (result11 !== null) {
                  var result6 = result11;
                } else {
                  if (input.substr(pos, 1) === "e") {
                    var result10 = "e";
                    pos += 1;
                  } else {
                    var result10 = null;
                    if (reportMatchFailures) {
                      matchFailed("\"e\"");
                    }
                  }
                  if (result10 !== null) {
                    var result6 = result10;
                  } else {
                    var result6 = null;;
                  };
                }
                if (result6 !== null) {
                  var result7 = [];
                  var result9 = parse_WS();
                  while (result9 !== null) {
                    result7.push(result9);
                    var result9 = parse_WS();
                  }
                  if (result7 !== null) {
                    var result8 = parse_IRI_REF();
                    if (result8 !== null) {
                      var result1 = [result2, result3, result4, result5, result6, result7, result8];
                    } else {
                      var result1 = null;
                      pos = savedPos0;
                    }
                  } else {
                    var result1 = null;
                    pos = savedPos0;
                  }
                } else {
                  var result1 = null;
                  pos = savedPos0;
                }
              } else {
                var result1 = null;
                pos = savedPos0;
              }
            } else {
              var result1 = null;
              pos = savedPos0;
            }
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        var result0 = result1 !== null
          ? (function(i) {
                registerDefaultPrefix(i);
          
                base = {};
                base.token = 'base';
                base.value = i;
          
                return base;
          })(result1[6])
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[4] BaseDecl");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_PrefixDecl() {
        var cacheKey = 'PrefixDecl@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        var result2 = [];
        var result27 = parse_WS();
        while (result27 !== null) {
          result2.push(result27);
          var result27 = parse_WS();
        }
        if (result2 !== null) {
          if (input.substr(pos, 1) === "P") {
            var result26 = "P";
            pos += 1;
          } else {
            var result26 = null;
            if (reportMatchFailures) {
              matchFailed("\"P\"");
            }
          }
          if (result26 !== null) {
            var result3 = result26;
          } else {
            if (input.substr(pos, 1) === "p") {
              var result25 = "p";
              pos += 1;
            } else {
              var result25 = null;
              if (reportMatchFailures) {
                matchFailed("\"p\"");
              }
            }
            if (result25 !== null) {
              var result3 = result25;
            } else {
              var result3 = null;;
            };
          }
          if (result3 !== null) {
            if (input.substr(pos, 1) === "R") {
              var result24 = "R";
              pos += 1;
            } else {
              var result24 = null;
              if (reportMatchFailures) {
                matchFailed("\"R\"");
              }
            }
            if (result24 !== null) {
              var result4 = result24;
            } else {
              if (input.substr(pos, 1) === "r") {
                var result23 = "r";
                pos += 1;
              } else {
                var result23 = null;
                if (reportMatchFailures) {
                  matchFailed("\"r\"");
                }
              }
              if (result23 !== null) {
                var result4 = result23;
              } else {
                var result4 = null;;
              };
            }
            if (result4 !== null) {
              if (input.substr(pos, 1) === "E") {
                var result22 = "E";
                pos += 1;
              } else {
                var result22 = null;
                if (reportMatchFailures) {
                  matchFailed("\"E\"");
                }
              }
              if (result22 !== null) {
                var result5 = result22;
              } else {
                if (input.substr(pos, 1) === "e") {
                  var result21 = "e";
                  pos += 1;
                } else {
                  var result21 = null;
                  if (reportMatchFailures) {
                    matchFailed("\"e\"");
                  }
                }
                if (result21 !== null) {
                  var result5 = result21;
                } else {
                  var result5 = null;;
                };
              }
              if (result5 !== null) {
                if (input.substr(pos, 1) === "F") {
                  var result20 = "F";
                  pos += 1;
                } else {
                  var result20 = null;
                  if (reportMatchFailures) {
                    matchFailed("\"F\"");
                  }
                }
                if (result20 !== null) {
                  var result6 = result20;
                } else {
                  if (input.substr(pos, 1) === "f") {
                    var result19 = "f";
                    pos += 1;
                  } else {
                    var result19 = null;
                    if (reportMatchFailures) {
                      matchFailed("\"f\"");
                    }
                  }
                  if (result19 !== null) {
                    var result6 = result19;
                  } else {
                    var result6 = null;;
                  };
                }
                if (result6 !== null) {
                  if (input.substr(pos, 1) === "I") {
                    var result18 = "I";
                    pos += 1;
                  } else {
                    var result18 = null;
                    if (reportMatchFailures) {
                      matchFailed("\"I\"");
                    }
                  }
                  if (result18 !== null) {
                    var result7 = result18;
                  } else {
                    if (input.substr(pos, 1) === "i") {
                      var result17 = "i";
                      pos += 1;
                    } else {
                      var result17 = null;
                      if (reportMatchFailures) {
                        matchFailed("\"i\"");
                      }
                    }
                    if (result17 !== null) {
                      var result7 = result17;
                    } else {
                      var result7 = null;;
                    };
                  }
                  if (result7 !== null) {
                    if (input.substr(pos, 1) === "X") {
                      var result16 = "X";
                      pos += 1;
                    } else {
                      var result16 = null;
                      if (reportMatchFailures) {
                        matchFailed("\"X\"");
                      }
                    }
                    if (result16 !== null) {
                      var result8 = result16;
                    } else {
                      if (input.substr(pos, 1) === "x") {
                        var result15 = "x";
                        pos += 1;
                      } else {
                        var result15 = null;
                        if (reportMatchFailures) {
                          matchFailed("\"x\"");
                        }
                      }
                      if (result15 !== null) {
                        var result8 = result15;
                      } else {
                        var result8 = null;;
                      };
                    }
                    if (result8 !== null) {
                      var result9 = [];
                      var result14 = parse_WS();
                      while (result14 !== null) {
                        result9.push(result14);
                        var result14 = parse_WS();
                      }
                      if (result9 !== null) {
                        var result10 = parse_PNAME_NS();
                        if (result10 !== null) {
                          var result11 = [];
                          var result13 = parse_WS();
                          while (result13 !== null) {
                            result11.push(result13);
                            var result13 = parse_WS();
                          }
                          if (result11 !== null) {
                            var result12 = parse_IRI_REF();
                            if (result12 !== null) {
                              var result1 = [result2, result3, result4, result5, result6, result7, result8, result9, result10, result11, result12];
                            } else {
                              var result1 = null;
                              pos = savedPos0;
                            }
                          } else {
                            var result1 = null;
                            pos = savedPos0;
                          }
                        } else {
                          var result1 = null;
                          pos = savedPos0;
                        }
                      } else {
                        var result1 = null;
                        pos = savedPos0;
                      }
                    } else {
                      var result1 = null;
                      pos = savedPos0;
                    }
                  } else {
                    var result1 = null;
                    pos = savedPos0;
                  }
                } else {
                  var result1 = null;
                  pos = savedPos0;
                }
              } else {
                var result1 = null;
                pos = savedPos0;
              }
            } else {
              var result1 = null;
              pos = savedPos0;
            }
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        var result0 = result1 !== null
          ? (function(p, l) {
          
                registerPrefix(p,l);
          
                prefix = {};
                prefix.token = 'prefix';
                prefix.prefix = p;
                prefix.local = l;
          
                return prefix;
          })(result1[8], result1[10])
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[5] PrefixDecl");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_SelectQuery() {
        var cacheKey = 'SelectQuery@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        var result2 = parse_SelectClause();
        if (result2 !== null) {
          var result3 = [];
          var result15 = parse_WS();
          while (result15 !== null) {
            result3.push(result15);
            var result15 = parse_WS();
          }
          if (result3 !== null) {
            var result4 = [];
            var result14 = parse_DatasetClause();
            while (result14 !== null) {
              result4.push(result14);
              var result14 = parse_DatasetClause();
            }
            if (result4 !== null) {
              var result5 = [];
              var result13 = parse_WS();
              while (result13 !== null) {
                result5.push(result13);
                var result13 = parse_WS();
              }
              if (result5 !== null) {
                var result6 = parse_WhereClause();
                if (result6 !== null) {
                  var result7 = [];
                  var result12 = parse_WS();
                  while (result12 !== null) {
                    result7.push(result12);
                    var result12 = parse_WS();
                  }
                  if (result7 !== null) {
                    var result8 = parse_SolutionModifier();
                    if (result8 !== null) {
                      var result9 = [];
                      var result11 = parse_WS();
                      while (result11 !== null) {
                        result9.push(result11);
                        var result11 = parse_WS();
                      }
                      if (result9 !== null) {
                        var result10 = parse_BindingsClause();
                        if (result10 !== null) {
                          var result1 = [result2, result3, result4, result5, result6, result7, result8, result9, result10];
                        } else {
                          var result1 = null;
                          pos = savedPos0;
                        }
                      } else {
                        var result1 = null;
                        pos = savedPos0;
                      }
                    } else {
                      var result1 = null;
                      pos = savedPos0;
                    }
                  } else {
                    var result1 = null;
                    pos = savedPos0;
                  }
                } else {
                  var result1 = null;
                  pos = savedPos0;
                }
              } else {
                var result1 = null;
                pos = savedPos0;
              }
            } else {
              var result1 = null;
              pos = savedPos0;
            }
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        var result0 = result1 !== null
          ? (function(s, gs, w, sm) {
          
                var dataset = {'named':[], 'default':[]};
                for(var i=0; i<gs.length; i++) {
                    var g = gs[i];
                    if(g.kind === 'default') {
                        dataset['default'].push(g.graph);
                    } else {
                        dataset['named'].push(g.graph)
                    }
                }
          
          
                if(dataset['named'].length === 0 && dataset['default'].length === 0) {
                    dataset['default'].push({token:'uri', 
                                             prefix:null, 
                                             suffix:null, 
                                             value:'https://github.com/antoniogarrote/rdfstore-js#default_graph'});
                }
          
                var query = {};
                query.kind = 'select';
                query.token = 'executableunit'
                query.dataset = dataset;
                query.projection = s.vars;
                query.modifier = s.modifier;
                query.pattern = w
                
                if(sm!=null && sm.limit!=null) {
                    query.limit = sm.limit;
                }
                if(sm!=null && sm.offset!=null) {
                    query.offset = sm.offset;
                }
                if(sm!=null && (sm.order!=null && sm.order!="")) {
                    query.order = sm.order;
                }
                if(sm!=null && sm.group!=null) {
                    query.group = sm.group;
                }
          
                return query
          })(result1[0], result1[2], result1[4], result1[6])
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[6] SelectQuery");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_SubSelect() {
        var cacheKey = 'SubSelect@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        var result1 = parse_SelectClause();
        if (result1 !== null) {
          var result2 = parse_WhereClause();
          if (result2 !== null) {
            var result3 = parse_SolutionModifier();
            if (result3 !== null) {
              var result0 = [result1, result2, result3];
            } else {
              var result0 = null;
              pos = savedPos0;
            }
          } else {
            var result0 = null;
            pos = savedPos0;
          }
        } else {
          var result0 = null;
          pos = savedPos0;
        }
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[7] SubSelect");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_SelectClause() {
        var cacheKey = 'SelectClause@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        var result2 = [];
        var result112 = parse_WS();
        while (result112 !== null) {
          result2.push(result112);
          var result112 = parse_WS();
        }
        if (result2 !== null) {
          if (input.substr(pos, 1) === "S") {
            var result111 = "S";
            pos += 1;
          } else {
            var result111 = null;
            if (reportMatchFailures) {
              matchFailed("\"S\"");
            }
          }
          if (result111 !== null) {
            var result3 = result111;
          } else {
            if (input.substr(pos, 1) === "s") {
              var result110 = "s";
              pos += 1;
            } else {
              var result110 = null;
              if (reportMatchFailures) {
                matchFailed("\"s\"");
              }
            }
            if (result110 !== null) {
              var result3 = result110;
            } else {
              var result3 = null;;
            };
          }
          if (result3 !== null) {
            if (input.substr(pos, 1) === "E") {
              var result109 = "E";
              pos += 1;
            } else {
              var result109 = null;
              if (reportMatchFailures) {
                matchFailed("\"E\"");
              }
            }
            if (result109 !== null) {
              var result4 = result109;
            } else {
              if (input.substr(pos, 1) === "e") {
                var result108 = "e";
                pos += 1;
              } else {
                var result108 = null;
                if (reportMatchFailures) {
                  matchFailed("\"e\"");
                }
              }
              if (result108 !== null) {
                var result4 = result108;
              } else {
                var result4 = null;;
              };
            }
            if (result4 !== null) {
              if (input.substr(pos, 1) === "L") {
                var result107 = "L";
                pos += 1;
              } else {
                var result107 = null;
                if (reportMatchFailures) {
                  matchFailed("\"L\"");
                }
              }
              if (result107 !== null) {
                var result5 = result107;
              } else {
                if (input.substr(pos, 1) === "l") {
                  var result106 = "l";
                  pos += 1;
                } else {
                  var result106 = null;
                  if (reportMatchFailures) {
                    matchFailed("\"l\"");
                  }
                }
                if (result106 !== null) {
                  var result5 = result106;
                } else {
                  var result5 = null;;
                };
              }
              if (result5 !== null) {
                if (input.substr(pos, 1) === "E") {
                  var result105 = "E";
                  pos += 1;
                } else {
                  var result105 = null;
                  if (reportMatchFailures) {
                    matchFailed("\"E\"");
                  }
                }
                if (result105 !== null) {
                  var result6 = result105;
                } else {
                  if (input.substr(pos, 1) === "e") {
                    var result104 = "e";
                    pos += 1;
                  } else {
                    var result104 = null;
                    if (reportMatchFailures) {
                      matchFailed("\"e\"");
                    }
                  }
                  if (result104 !== null) {
                    var result6 = result104;
                  } else {
                    var result6 = null;;
                  };
                }
                if (result6 !== null) {
                  if (input.substr(pos, 1) === "C") {
                    var result103 = "C";
                    pos += 1;
                  } else {
                    var result103 = null;
                    if (reportMatchFailures) {
                      matchFailed("\"C\"");
                    }
                  }
                  if (result103 !== null) {
                    var result7 = result103;
                  } else {
                    if (input.substr(pos, 1) === "c") {
                      var result102 = "c";
                      pos += 1;
                    } else {
                      var result102 = null;
                      if (reportMatchFailures) {
                        matchFailed("\"c\"");
                      }
                    }
                    if (result102 !== null) {
                      var result7 = result102;
                    } else {
                      var result7 = null;;
                    };
                  }
                  if (result7 !== null) {
                    if (input.substr(pos, 1) === "T") {
                      var result101 = "T";
                      pos += 1;
                    } else {
                      var result101 = null;
                      if (reportMatchFailures) {
                        matchFailed("\"T\"");
                      }
                    }
                    if (result101 !== null) {
                      var result8 = result101;
                    } else {
                      if (input.substr(pos, 1) === "t") {
                        var result100 = "t";
                        pos += 1;
                      } else {
                        var result100 = null;
                        if (reportMatchFailures) {
                          matchFailed("\"t\"");
                        }
                      }
                      if (result100 !== null) {
                        var result8 = result100;
                      } else {
                        var result8 = null;;
                      };
                    }
                    if (result8 !== null) {
                      var result9 = [];
                      var result99 = parse_WS();
                      while (result99 !== null) {
                        result9.push(result99);
                        var result99 = parse_WS();
                      }
                      if (result9 !== null) {
                        var savedPos5 = pos;
                        if (input.substr(pos, 1) === "D") {
                          var result98 = "D";
                          pos += 1;
                        } else {
                          var result98 = null;
                          if (reportMatchFailures) {
                            matchFailed("\"D\"");
                          }
                        }
                        if (result98 !== null) {
                          var result75 = result98;
                        } else {
                          if (input.substr(pos, 1) === "d") {
                            var result97 = "d";
                            pos += 1;
                          } else {
                            var result97 = null;
                            if (reportMatchFailures) {
                              matchFailed("\"d\"");
                            }
                          }
                          if (result97 !== null) {
                            var result75 = result97;
                          } else {
                            var result75 = null;;
                          };
                        }
                        if (result75 !== null) {
                          if (input.substr(pos, 1) === "I") {
                            var result96 = "I";
                            pos += 1;
                          } else {
                            var result96 = null;
                            if (reportMatchFailures) {
                              matchFailed("\"I\"");
                            }
                          }
                          if (result96 !== null) {
                            var result76 = result96;
                          } else {
                            if (input.substr(pos, 1) === "i") {
                              var result95 = "i";
                              pos += 1;
                            } else {
                              var result95 = null;
                              if (reportMatchFailures) {
                                matchFailed("\"i\"");
                              }
                            }
                            if (result95 !== null) {
                              var result76 = result95;
                            } else {
                              var result76 = null;;
                            };
                          }
                          if (result76 !== null) {
                            if (input.substr(pos, 1) === "S") {
                              var result94 = "S";
                              pos += 1;
                            } else {
                              var result94 = null;
                              if (reportMatchFailures) {
                                matchFailed("\"S\"");
                              }
                            }
                            if (result94 !== null) {
                              var result77 = result94;
                            } else {
                              if (input.substr(pos, 1) === "s") {
                                var result93 = "s";
                                pos += 1;
                              } else {
                                var result93 = null;
                                if (reportMatchFailures) {
                                  matchFailed("\"s\"");
                                }
                              }
                              if (result93 !== null) {
                                var result77 = result93;
                              } else {
                                var result77 = null;;
                              };
                            }
                            if (result77 !== null) {
                              if (input.substr(pos, 1) === "T") {
                                var result92 = "T";
                                pos += 1;
                              } else {
                                var result92 = null;
                                if (reportMatchFailures) {
                                  matchFailed("\"T\"");
                                }
                              }
                              if (result92 !== null) {
                                var result78 = result92;
                              } else {
                                if (input.substr(pos, 1) === "t") {
                                  var result91 = "t";
                                  pos += 1;
                                } else {
                                  var result91 = null;
                                  if (reportMatchFailures) {
                                    matchFailed("\"t\"");
                                  }
                                }
                                if (result91 !== null) {
                                  var result78 = result91;
                                } else {
                                  var result78 = null;;
                                };
                              }
                              if (result78 !== null) {
                                if (input.substr(pos, 1) === "I") {
                                  var result90 = "I";
                                  pos += 1;
                                } else {
                                  var result90 = null;
                                  if (reportMatchFailures) {
                                    matchFailed("\"I\"");
                                  }
                                }
                                if (result90 !== null) {
                                  var result79 = result90;
                                } else {
                                  if (input.substr(pos, 1) === "i") {
                                    var result89 = "i";
                                    pos += 1;
                                  } else {
                                    var result89 = null;
                                    if (reportMatchFailures) {
                                      matchFailed("\"i\"");
                                    }
                                  }
                                  if (result89 !== null) {
                                    var result79 = result89;
                                  } else {
                                    var result79 = null;;
                                  };
                                }
                                if (result79 !== null) {
                                  if (input.substr(pos, 1) === "N") {
                                    var result88 = "N";
                                    pos += 1;
                                  } else {
                                    var result88 = null;
                                    if (reportMatchFailures) {
                                      matchFailed("\"N\"");
                                    }
                                  }
                                  if (result88 !== null) {
                                    var result80 = result88;
                                  } else {
                                    if (input.substr(pos, 1) === "n") {
                                      var result87 = "n";
                                      pos += 1;
                                    } else {
                                      var result87 = null;
                                      if (reportMatchFailures) {
                                        matchFailed("\"n\"");
                                      }
                                    }
                                    if (result87 !== null) {
                                      var result80 = result87;
                                    } else {
                                      var result80 = null;;
                                    };
                                  }
                                  if (result80 !== null) {
                                    if (input.substr(pos, 1) === "C") {
                                      var result86 = "C";
                                      pos += 1;
                                    } else {
                                      var result86 = null;
                                      if (reportMatchFailures) {
                                        matchFailed("\"C\"");
                                      }
                                    }
                                    if (result86 !== null) {
                                      var result81 = result86;
                                    } else {
                                      if (input.substr(pos, 1) === "c") {
                                        var result85 = "c";
                                        pos += 1;
                                      } else {
                                        var result85 = null;
                                        if (reportMatchFailures) {
                                          matchFailed("\"c\"");
                                        }
                                      }
                                      if (result85 !== null) {
                                        var result81 = result85;
                                      } else {
                                        var result81 = null;;
                                      };
                                    }
                                    if (result81 !== null) {
                                      if (input.substr(pos, 1) === "T") {
                                        var result84 = "T";
                                        pos += 1;
                                      } else {
                                        var result84 = null;
                                        if (reportMatchFailures) {
                                          matchFailed("\"T\"");
                                        }
                                      }
                                      if (result84 !== null) {
                                        var result82 = result84;
                                      } else {
                                        if (input.substr(pos, 1) === "t") {
                                          var result83 = "t";
                                          pos += 1;
                                        } else {
                                          var result83 = null;
                                          if (reportMatchFailures) {
                                            matchFailed("\"t\"");
                                          }
                                        }
                                        if (result83 !== null) {
                                          var result82 = result83;
                                        } else {
                                          var result82 = null;;
                                        };
                                      }
                                      if (result82 !== null) {
                                        var result74 = [result75, result76, result77, result78, result79, result80, result81, result82];
                                      } else {
                                        var result74 = null;
                                        pos = savedPos5;
                                      }
                                    } else {
                                      var result74 = null;
                                      pos = savedPos5;
                                    }
                                  } else {
                                    var result74 = null;
                                    pos = savedPos5;
                                  }
                                } else {
                                  var result74 = null;
                                  pos = savedPos5;
                                }
                              } else {
                                var result74 = null;
                                pos = savedPos5;
                              }
                            } else {
                              var result74 = null;
                              pos = savedPos5;
                            }
                          } else {
                            var result74 = null;
                            pos = savedPos5;
                          }
                        } else {
                          var result74 = null;
                          pos = savedPos5;
                        }
                        if (result74 !== null) {
                          var result51 = result74;
                        } else {
                          var savedPos4 = pos;
                          if (input.substr(pos, 1) === "R") {
                            var result73 = "R";
                            pos += 1;
                          } else {
                            var result73 = null;
                            if (reportMatchFailures) {
                              matchFailed("\"R\"");
                            }
                          }
                          if (result73 !== null) {
                            var result53 = result73;
                          } else {
                            if (input.substr(pos, 1) === "r") {
                              var result72 = "r";
                              pos += 1;
                            } else {
                              var result72 = null;
                              if (reportMatchFailures) {
                                matchFailed("\"r\"");
                              }
                            }
                            if (result72 !== null) {
                              var result53 = result72;
                            } else {
                              var result53 = null;;
                            };
                          }
                          if (result53 !== null) {
                            if (input.substr(pos, 1) === "E") {
                              var result71 = "E";
                              pos += 1;
                            } else {
                              var result71 = null;
                              if (reportMatchFailures) {
                                matchFailed("\"E\"");
                              }
                            }
                            if (result71 !== null) {
                              var result54 = result71;
                            } else {
                              if (input.substr(pos, 1) === "e") {
                                var result70 = "e";
                                pos += 1;
                              } else {
                                var result70 = null;
                                if (reportMatchFailures) {
                                  matchFailed("\"e\"");
                                }
                              }
                              if (result70 !== null) {
                                var result54 = result70;
                              } else {
                                var result54 = null;;
                              };
                            }
                            if (result54 !== null) {
                              if (input.substr(pos, 1) === "D") {
                                var result69 = "D";
                                pos += 1;
                              } else {
                                var result69 = null;
                                if (reportMatchFailures) {
                                  matchFailed("\"D\"");
                                }
                              }
                              if (result69 !== null) {
                                var result55 = result69;
                              } else {
                                if (input.substr(pos, 1) === "d") {
                                  var result68 = "d";
                                  pos += 1;
                                } else {
                                  var result68 = null;
                                  if (reportMatchFailures) {
                                    matchFailed("\"d\"");
                                  }
                                }
                                if (result68 !== null) {
                                  var result55 = result68;
                                } else {
                                  var result55 = null;;
                                };
                              }
                              if (result55 !== null) {
                                if (input.substr(pos, 1) === "U") {
                                  var result67 = "U";
                                  pos += 1;
                                } else {
                                  var result67 = null;
                                  if (reportMatchFailures) {
                                    matchFailed("\"U\"");
                                  }
                                }
                                if (result67 !== null) {
                                  var result56 = result67;
                                } else {
                                  if (input.substr(pos, 1) === "u") {
                                    var result66 = "u";
                                    pos += 1;
                                  } else {
                                    var result66 = null;
                                    if (reportMatchFailures) {
                                      matchFailed("\"u\"");
                                    }
                                  }
                                  if (result66 !== null) {
                                    var result56 = result66;
                                  } else {
                                    var result56 = null;;
                                  };
                                }
                                if (result56 !== null) {
                                  if (input.substr(pos, 1) === "C") {
                                    var result65 = "C";
                                    pos += 1;
                                  } else {
                                    var result65 = null;
                                    if (reportMatchFailures) {
                                      matchFailed("\"C\"");
                                    }
                                  }
                                  if (result65 !== null) {
                                    var result57 = result65;
                                  } else {
                                    if (input.substr(pos, 1) === "c") {
                                      var result64 = "c";
                                      pos += 1;
                                    } else {
                                      var result64 = null;
                                      if (reportMatchFailures) {
                                        matchFailed("\"c\"");
                                      }
                                    }
                                    if (result64 !== null) {
                                      var result57 = result64;
                                    } else {
                                      var result57 = null;;
                                    };
                                  }
                                  if (result57 !== null) {
                                    if (input.substr(pos, 1) === "E") {
                                      var result63 = "E";
                                      pos += 1;
                                    } else {
                                      var result63 = null;
                                      if (reportMatchFailures) {
                                        matchFailed("\"E\"");
                                      }
                                    }
                                    if (result63 !== null) {
                                      var result58 = result63;
                                    } else {
                                      if (input.substr(pos, 1) === "e") {
                                        var result62 = "e";
                                        pos += 1;
                                      } else {
                                        var result62 = null;
                                        if (reportMatchFailures) {
                                          matchFailed("\"e\"");
                                        }
                                      }
                                      if (result62 !== null) {
                                        var result58 = result62;
                                      } else {
                                        var result58 = null;;
                                      };
                                    }
                                    if (result58 !== null) {
                                      if (input.substr(pos, 1) === "D") {
                                        var result61 = "D";
                                        pos += 1;
                                      } else {
                                        var result61 = null;
                                        if (reportMatchFailures) {
                                          matchFailed("\"D\"");
                                        }
                                      }
                                      if (result61 !== null) {
                                        var result59 = result61;
                                      } else {
                                        if (input.substr(pos, 1) === "d") {
                                          var result60 = "d";
                                          pos += 1;
                                        } else {
                                          var result60 = null;
                                          if (reportMatchFailures) {
                                            matchFailed("\"d\"");
                                          }
                                        }
                                        if (result60 !== null) {
                                          var result59 = result60;
                                        } else {
                                          var result59 = null;;
                                        };
                                      }
                                      if (result59 !== null) {
                                        var result52 = [result53, result54, result55, result56, result57, result58, result59];
                                      } else {
                                        var result52 = null;
                                        pos = savedPos4;
                                      }
                                    } else {
                                      var result52 = null;
                                      pos = savedPos4;
                                    }
                                  } else {
                                    var result52 = null;
                                    pos = savedPos4;
                                  }
                                } else {
                                  var result52 = null;
                                  pos = savedPos4;
                                }
                              } else {
                                var result52 = null;
                                pos = savedPos4;
                              }
                            } else {
                              var result52 = null;
                              pos = savedPos4;
                            }
                          } else {
                            var result52 = null;
                            pos = savedPos4;
                          }
                          if (result52 !== null) {
                            var result51 = result52;
                          } else {
                            var result51 = null;;
                          };
                        }
                        var result10 = result51 !== null ? result51 : '';
                        if (result10 !== null) {
                          var result11 = [];
                          var result50 = parse_WS();
                          while (result50 !== null) {
                            result11.push(result50);
                            var result50 = parse_WS();
                          }
                          if (result11 !== null) {
                            var savedPos3 = pos;
                            var result45 = [];
                            var result49 = parse_WS();
                            while (result49 !== null) {
                              result45.push(result49);
                              var result49 = parse_WS();
                            }
                            if (result45 !== null) {
                              var result46 = parse_Var();
                              if (result46 !== null) {
                                var result47 = [];
                                var result48 = parse_WS();
                                while (result48 !== null) {
                                  result47.push(result48);
                                  var result48 = parse_WS();
                                }
                                if (result47 !== null) {
                                  var result44 = [result45, result46, result47];
                                } else {
                                  var result44 = null;
                                  pos = savedPos3;
                                }
                              } else {
                                var result44 = null;
                                pos = savedPos3;
                              }
                            } else {
                              var result44 = null;
                              pos = savedPos3;
                            }
                            if (result44 !== null) {
                              var result20 = result44;
                            } else {
                              var savedPos2 = pos;
                              var result22 = [];
                              var result43 = parse_WS();
                              while (result43 !== null) {
                                result22.push(result43);
                                var result43 = parse_WS();
                              }
                              if (result22 !== null) {
                                if (input.substr(pos, 1) === "(") {
                                  var result23 = "(";
                                  pos += 1;
                                } else {
                                  var result23 = null;
                                  if (reportMatchFailures) {
                                    matchFailed("\"(\"");
                                  }
                                }
                                if (result23 !== null) {
                                  var result24 = [];
                                  var result42 = parse_WS();
                                  while (result42 !== null) {
                                    result24.push(result42);
                                    var result42 = parse_WS();
                                  }
                                  if (result24 !== null) {
                                    var result25 = parse_ConditionalOrExpression();
                                    if (result25 !== null) {
                                      var result26 = [];
                                      var result41 = parse_WS();
                                      while (result41 !== null) {
                                        result26.push(result41);
                                        var result41 = parse_WS();
                                      }
                                      if (result26 !== null) {
                                        if (input.substr(pos, 1) === "A") {
                                          var result40 = "A";
                                          pos += 1;
                                        } else {
                                          var result40 = null;
                                          if (reportMatchFailures) {
                                            matchFailed("\"A\"");
                                          }
                                        }
                                        if (result40 !== null) {
                                          var result27 = result40;
                                        } else {
                                          if (input.substr(pos, 1) === "a") {
                                            var result39 = "a";
                                            pos += 1;
                                          } else {
                                            var result39 = null;
                                            if (reportMatchFailures) {
                                              matchFailed("\"a\"");
                                            }
                                          }
                                          if (result39 !== null) {
                                            var result27 = result39;
                                          } else {
                                            var result27 = null;;
                                          };
                                        }
                                        if (result27 !== null) {
                                          if (input.substr(pos, 1) === "S") {
                                            var result38 = "S";
                                            pos += 1;
                                          } else {
                                            var result38 = null;
                                            if (reportMatchFailures) {
                                              matchFailed("\"S\"");
                                            }
                                          }
                                          if (result38 !== null) {
                                            var result28 = result38;
                                          } else {
                                            if (input.substr(pos, 1) === "s") {
                                              var result37 = "s";
                                              pos += 1;
                                            } else {
                                              var result37 = null;
                                              if (reportMatchFailures) {
                                                matchFailed("\"s\"");
                                              }
                                            }
                                            if (result37 !== null) {
                                              var result28 = result37;
                                            } else {
                                              var result28 = null;;
                                            };
                                          }
                                          if (result28 !== null) {
                                            var result29 = [];
                                            var result36 = parse_WS();
                                            while (result36 !== null) {
                                              result29.push(result36);
                                              var result36 = parse_WS();
                                            }
                                            if (result29 !== null) {
                                              var result30 = parse_Var();
                                              if (result30 !== null) {
                                                var result31 = [];
                                                var result35 = parse_WS();
                                                while (result35 !== null) {
                                                  result31.push(result35);
                                                  var result35 = parse_WS();
                                                }
                                                if (result31 !== null) {
                                                  if (input.substr(pos, 1) === ")") {
                                                    var result32 = ")";
                                                    pos += 1;
                                                  } else {
                                                    var result32 = null;
                                                    if (reportMatchFailures) {
                                                      matchFailed("\")\"");
                                                    }
                                                  }
                                                  if (result32 !== null) {
                                                    var result33 = [];
                                                    var result34 = parse_WS();
                                                    while (result34 !== null) {
                                                      result33.push(result34);
                                                      var result34 = parse_WS();
                                                    }
                                                    if (result33 !== null) {
                                                      var result21 = [result22, result23, result24, result25, result26, result27, result28, result29, result30, result31, result32, result33];
                                                    } else {
                                                      var result21 = null;
                                                      pos = savedPos2;
                                                    }
                                                  } else {
                                                    var result21 = null;
                                                    pos = savedPos2;
                                                  }
                                                } else {
                                                  var result21 = null;
                                                  pos = savedPos2;
                                                }
                                              } else {
                                                var result21 = null;
                                                pos = savedPos2;
                                              }
                                            } else {
                                              var result21 = null;
                                              pos = savedPos2;
                                            }
                                          } else {
                                            var result21 = null;
                                            pos = savedPos2;
                                          }
                                        } else {
                                          var result21 = null;
                                          pos = savedPos2;
                                        }
                                      } else {
                                        var result21 = null;
                                        pos = savedPos2;
                                      }
                                    } else {
                                      var result21 = null;
                                      pos = savedPos2;
                                    }
                                  } else {
                                    var result21 = null;
                                    pos = savedPos2;
                                  }
                                } else {
                                  var result21 = null;
                                  pos = savedPos2;
                                }
                              } else {
                                var result21 = null;
                                pos = savedPos2;
                              }
                              if (result21 !== null) {
                                var result20 = result21;
                              } else {
                                var result20 = null;;
                              };
                            }
                            if (result20 !== null) {
                              var result19 = [];
                              while (result20 !== null) {
                                result19.push(result20);
                                var savedPos3 = pos;
                                var result45 = [];
                                var result49 = parse_WS();
                                while (result49 !== null) {
                                  result45.push(result49);
                                  var result49 = parse_WS();
                                }
                                if (result45 !== null) {
                                  var result46 = parse_Var();
                                  if (result46 !== null) {
                                    var result47 = [];
                                    var result48 = parse_WS();
                                    while (result48 !== null) {
                                      result47.push(result48);
                                      var result48 = parse_WS();
                                    }
                                    if (result47 !== null) {
                                      var result44 = [result45, result46, result47];
                                    } else {
                                      var result44 = null;
                                      pos = savedPos3;
                                    }
                                  } else {
                                    var result44 = null;
                                    pos = savedPos3;
                                  }
                                } else {
                                  var result44 = null;
                                  pos = savedPos3;
                                }
                                if (result44 !== null) {
                                  var result20 = result44;
                                } else {
                                  var savedPos2 = pos;
                                  var result22 = [];
                                  var result43 = parse_WS();
                                  while (result43 !== null) {
                                    result22.push(result43);
                                    var result43 = parse_WS();
                                  }
                                  if (result22 !== null) {
                                    if (input.substr(pos, 1) === "(") {
                                      var result23 = "(";
                                      pos += 1;
                                    } else {
                                      var result23 = null;
                                      if (reportMatchFailures) {
                                        matchFailed("\"(\"");
                                      }
                                    }
                                    if (result23 !== null) {
                                      var result24 = [];
                                      var result42 = parse_WS();
                                      while (result42 !== null) {
                                        result24.push(result42);
                                        var result42 = parse_WS();
                                      }
                                      if (result24 !== null) {
                                        var result25 = parse_ConditionalOrExpression();
                                        if (result25 !== null) {
                                          var result26 = [];
                                          var result41 = parse_WS();
                                          while (result41 !== null) {
                                            result26.push(result41);
                                            var result41 = parse_WS();
                                          }
                                          if (result26 !== null) {
                                            if (input.substr(pos, 1) === "A") {
                                              var result40 = "A";
                                              pos += 1;
                                            } else {
                                              var result40 = null;
                                              if (reportMatchFailures) {
                                                matchFailed("\"A\"");
                                              }
                                            }
                                            if (result40 !== null) {
                                              var result27 = result40;
                                            } else {
                                              if (input.substr(pos, 1) === "a") {
                                                var result39 = "a";
                                                pos += 1;
                                              } else {
                                                var result39 = null;
                                                if (reportMatchFailures) {
                                                  matchFailed("\"a\"");
                                                }
                                              }
                                              if (result39 !== null) {
                                                var result27 = result39;
                                              } else {
                                                var result27 = null;;
                                              };
                                            }
                                            if (result27 !== null) {
                                              if (input.substr(pos, 1) === "S") {
                                                var result38 = "S";
                                                pos += 1;
                                              } else {
                                                var result38 = null;
                                                if (reportMatchFailures) {
                                                  matchFailed("\"S\"");
                                                }
                                              }
                                              if (result38 !== null) {
                                                var result28 = result38;
                                              } else {
                                                if (input.substr(pos, 1) === "s") {
                                                  var result37 = "s";
                                                  pos += 1;
                                                } else {
                                                  var result37 = null;
                                                  if (reportMatchFailures) {
                                                    matchFailed("\"s\"");
                                                  }
                                                }
                                                if (result37 !== null) {
                                                  var result28 = result37;
                                                } else {
                                                  var result28 = null;;
                                                };
                                              }
                                              if (result28 !== null) {
                                                var result29 = [];
                                                var result36 = parse_WS();
                                                while (result36 !== null) {
                                                  result29.push(result36);
                                                  var result36 = parse_WS();
                                                }
                                                if (result29 !== null) {
                                                  var result30 = parse_Var();
                                                  if (result30 !== null) {
                                                    var result31 = [];
                                                    var result35 = parse_WS();
                                                    while (result35 !== null) {
                                                      result31.push(result35);
                                                      var result35 = parse_WS();
                                                    }
                                                    if (result31 !== null) {
                                                      if (input.substr(pos, 1) === ")") {
                                                        var result32 = ")";
                                                        pos += 1;
                                                      } else {
                                                        var result32 = null;
                                                        if (reportMatchFailures) {
                                                          matchFailed("\")\"");
                                                        }
                                                      }
                                                      if (result32 !== null) {
                                                        var result33 = [];
                                                        var result34 = parse_WS();
                                                        while (result34 !== null) {
                                                          result33.push(result34);
                                                          var result34 = parse_WS();
                                                        }
                                                        if (result33 !== null) {
                                                          var result21 = [result22, result23, result24, result25, result26, result27, result28, result29, result30, result31, result32, result33];
                                                        } else {
                                                          var result21 = null;
                                                          pos = savedPos2;
                                                        }
                                                      } else {
                                                        var result21 = null;
                                                        pos = savedPos2;
                                                      }
                                                    } else {
                                                      var result21 = null;
                                                      pos = savedPos2;
                                                    }
                                                  } else {
                                                    var result21 = null;
                                                    pos = savedPos2;
                                                  }
                                                } else {
                                                  var result21 = null;
                                                  pos = savedPos2;
                                                }
                                              } else {
                                                var result21 = null;
                                                pos = savedPos2;
                                              }
                                            } else {
                                              var result21 = null;
                                              pos = savedPos2;
                                            }
                                          } else {
                                            var result21 = null;
                                            pos = savedPos2;
                                          }
                                        } else {
                                          var result21 = null;
                                          pos = savedPos2;
                                        }
                                      } else {
                                        var result21 = null;
                                        pos = savedPos2;
                                      }
                                    } else {
                                      var result21 = null;
                                      pos = savedPos2;
                                    }
                                  } else {
                                    var result21 = null;
                                    pos = savedPos2;
                                  }
                                  if (result21 !== null) {
                                    var result20 = result21;
                                  } else {
                                    var result20 = null;;
                                  };
                                }
                              }
                            } else {
                              var result19 = null;
                            }
                            if (result19 !== null) {
                              var result12 = result19;
                            } else {
                              var savedPos1 = pos;
                              var result14 = [];
                              var result18 = parse_WS();
                              while (result18 !== null) {
                                result14.push(result18);
                                var result18 = parse_WS();
                              }
                              if (result14 !== null) {
                                if (input.substr(pos, 1) === "*") {
                                  var result15 = "*";
                                  pos += 1;
                                } else {
                                  var result15 = null;
                                  if (reportMatchFailures) {
                                    matchFailed("\"*\"");
                                  }
                                }
                                if (result15 !== null) {
                                  var result16 = [];
                                  var result17 = parse_WS();
                                  while (result17 !== null) {
                                    result16.push(result17);
                                    var result17 = parse_WS();
                                  }
                                  if (result16 !== null) {
                                    var result13 = [result14, result15, result16];
                                  } else {
                                    var result13 = null;
                                    pos = savedPos1;
                                  }
                                } else {
                                  var result13 = null;
                                  pos = savedPos1;
                                }
                              } else {
                                var result13 = null;
                                pos = savedPos1;
                              }
                              if (result13 !== null) {
                                var result12 = result13;
                              } else {
                                var result12 = null;;
                              };
                            }
                            if (result12 !== null) {
                              var result1 = [result2, result3, result4, result5, result6, result7, result8, result9, result10, result11, result12];
                            } else {
                              var result1 = null;
                              pos = savedPos0;
                            }
                          } else {
                            var result1 = null;
                            pos = savedPos0;
                          }
                        } else {
                          var result1 = null;
                          pos = savedPos0;
                        }
                      } else {
                        var result1 = null;
                        pos = savedPos0;
                      }
                    } else {
                      var result1 = null;
                      pos = savedPos0;
                    }
                  } else {
                    var result1 = null;
                    pos = savedPos0;
                  }
                } else {
                  var result1 = null;
                  pos = savedPos0;
                }
              } else {
                var result1 = null;
                pos = savedPos0;
              }
            } else {
              var result1 = null;
              pos = savedPos0;
            }
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        var result0 = result1 !== null
          ? (function(mod, proj) {
               var vars = [];
                if(proj.length === 3 && proj[1]==="*") {
                    return {vars: [{token: 'variable', kind:'*'}], modifier:arrayToString(mod)};
                }
          
                for(var i=0; i< proj.length; i++) {
                    var aVar = proj[i];
          
                    if(aVar.length === 3) {
                        vars.push({token: 'variable', kind:'var', value:aVar[1]});
                    } else {
                        vars.push({token: 'variable', kind:'aliased', expression: aVar[3], alias:aVar[8]})
                    }
                }
          
                return {vars: vars, modifier:arrayToString(mod)};
          })(result1[8], result1[10])
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[8] SelectClause");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_ConstructQuery() {
        var cacheKey = 'ConstructQuery@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        var result2 = [];
        var result43 = parse_WS();
        while (result43 !== null) {
          result2.push(result43);
          var result43 = parse_WS();
        }
        if (result2 !== null) {
          if (input.substr(pos, 1) === "C") {
            var result42 = "C";
            pos += 1;
          } else {
            var result42 = null;
            if (reportMatchFailures) {
              matchFailed("\"C\"");
            }
          }
          if (result42 !== null) {
            var result3 = result42;
          } else {
            if (input.substr(pos, 1) === "c") {
              var result41 = "c";
              pos += 1;
            } else {
              var result41 = null;
              if (reportMatchFailures) {
                matchFailed("\"c\"");
              }
            }
            if (result41 !== null) {
              var result3 = result41;
            } else {
              var result3 = null;;
            };
          }
          if (result3 !== null) {
            if (input.substr(pos, 1) === "O") {
              var result40 = "O";
              pos += 1;
            } else {
              var result40 = null;
              if (reportMatchFailures) {
                matchFailed("\"O\"");
              }
            }
            if (result40 !== null) {
              var result4 = result40;
            } else {
              if (input.substr(pos, 1) === "o") {
                var result39 = "o";
                pos += 1;
              } else {
                var result39 = null;
                if (reportMatchFailures) {
                  matchFailed("\"o\"");
                }
              }
              if (result39 !== null) {
                var result4 = result39;
              } else {
                var result4 = null;;
              };
            }
            if (result4 !== null) {
              if (input.substr(pos, 1) === "N") {
                var result38 = "N";
                pos += 1;
              } else {
                var result38 = null;
                if (reportMatchFailures) {
                  matchFailed("\"N\"");
                }
              }
              if (result38 !== null) {
                var result5 = result38;
              } else {
                if (input.substr(pos, 1) === "n") {
                  var result37 = "n";
                  pos += 1;
                } else {
                  var result37 = null;
                  if (reportMatchFailures) {
                    matchFailed("\"n\"");
                  }
                }
                if (result37 !== null) {
                  var result5 = result37;
                } else {
                  var result5 = null;;
                };
              }
              if (result5 !== null) {
                if (input.substr(pos, 1) === "S") {
                  var result36 = "S";
                  pos += 1;
                } else {
                  var result36 = null;
                  if (reportMatchFailures) {
                    matchFailed("\"S\"");
                  }
                }
                if (result36 !== null) {
                  var result6 = result36;
                } else {
                  if (input.substr(pos, 1) === "s") {
                    var result35 = "s";
                    pos += 1;
                  } else {
                    var result35 = null;
                    if (reportMatchFailures) {
                      matchFailed("\"s\"");
                    }
                  }
                  if (result35 !== null) {
                    var result6 = result35;
                  } else {
                    var result6 = null;;
                  };
                }
                if (result6 !== null) {
                  if (input.substr(pos, 1) === "T") {
                    var result34 = "T";
                    pos += 1;
                  } else {
                    var result34 = null;
                    if (reportMatchFailures) {
                      matchFailed("\"T\"");
                    }
                  }
                  if (result34 !== null) {
                    var result7 = result34;
                  } else {
                    if (input.substr(pos, 1) === "t") {
                      var result33 = "t";
                      pos += 1;
                    } else {
                      var result33 = null;
                      if (reportMatchFailures) {
                        matchFailed("\"t\"");
                      }
                    }
                    if (result33 !== null) {
                      var result7 = result33;
                    } else {
                      var result7 = null;;
                    };
                  }
                  if (result7 !== null) {
                    if (input.substr(pos, 1) === "R") {
                      var result32 = "R";
                      pos += 1;
                    } else {
                      var result32 = null;
                      if (reportMatchFailures) {
                        matchFailed("\"R\"");
                      }
                    }
                    if (result32 !== null) {
                      var result8 = result32;
                    } else {
                      if (input.substr(pos, 1) === "r") {
                        var result31 = "r";
                        pos += 1;
                      } else {
                        var result31 = null;
                        if (reportMatchFailures) {
                          matchFailed("\"r\"");
                        }
                      }
                      if (result31 !== null) {
                        var result8 = result31;
                      } else {
                        var result8 = null;;
                      };
                    }
                    if (result8 !== null) {
                      if (input.substr(pos, 1) === "U") {
                        var result30 = "U";
                        pos += 1;
                      } else {
                        var result30 = null;
                        if (reportMatchFailures) {
                          matchFailed("\"U\"");
                        }
                      }
                      if (result30 !== null) {
                        var result9 = result30;
                      } else {
                        if (input.substr(pos, 1) === "u") {
                          var result29 = "u";
                          pos += 1;
                        } else {
                          var result29 = null;
                          if (reportMatchFailures) {
                            matchFailed("\"u\"");
                          }
                        }
                        if (result29 !== null) {
                          var result9 = result29;
                        } else {
                          var result9 = null;;
                        };
                      }
                      if (result9 !== null) {
                        if (input.substr(pos, 1) === "C") {
                          var result28 = "C";
                          pos += 1;
                        } else {
                          var result28 = null;
                          if (reportMatchFailures) {
                            matchFailed("\"C\"");
                          }
                        }
                        if (result28 !== null) {
                          var result10 = result28;
                        } else {
                          if (input.substr(pos, 1) === "c") {
                            var result27 = "c";
                            pos += 1;
                          } else {
                            var result27 = null;
                            if (reportMatchFailures) {
                              matchFailed("\"c\"");
                            }
                          }
                          if (result27 !== null) {
                            var result10 = result27;
                          } else {
                            var result10 = null;;
                          };
                        }
                        if (result10 !== null) {
                          if (input.substr(pos, 1) === "T") {
                            var result26 = "T";
                            pos += 1;
                          } else {
                            var result26 = null;
                            if (reportMatchFailures) {
                              matchFailed("\"T\"");
                            }
                          }
                          if (result26 !== null) {
                            var result11 = result26;
                          } else {
                            if (input.substr(pos, 1) === "t") {
                              var result25 = "t";
                              pos += 1;
                            } else {
                              var result25 = null;
                              if (reportMatchFailures) {
                                matchFailed("\"t\"");
                              }
                            }
                            if (result25 !== null) {
                              var result11 = result25;
                            } else {
                              var result11 = null;;
                            };
                          }
                          if (result11 !== null) {
                            var result12 = [];
                            var result24 = parse_WS();
                            while (result24 !== null) {
                              result12.push(result24);
                              var result24 = parse_WS();
                            }
                            if (result12 !== null) {
                              var result13 = parse_ConstructTemplate();
                              if (result13 !== null) {
                                var result14 = [];
                                var result23 = parse_WS();
                                while (result23 !== null) {
                                  result14.push(result23);
                                  var result23 = parse_WS();
                                }
                                if (result14 !== null) {
                                  var result15 = [];
                                  var result22 = parse_DatasetClause();
                                  while (result22 !== null) {
                                    result15.push(result22);
                                    var result22 = parse_DatasetClause();
                                  }
                                  if (result15 !== null) {
                                    var result16 = [];
                                    var result21 = parse_WS();
                                    while (result21 !== null) {
                                      result16.push(result21);
                                      var result21 = parse_WS();
                                    }
                                    if (result16 !== null) {
                                      var result17 = parse_WhereClause();
                                      if (result17 !== null) {
                                        var result18 = [];
                                        var result20 = parse_WS();
                                        while (result20 !== null) {
                                          result18.push(result20);
                                          var result20 = parse_WS();
                                        }
                                        if (result18 !== null) {
                                          var result19 = parse_SolutionModifier();
                                          if (result19 !== null) {
                                            var result1 = [result2, result3, result4, result5, result6, result7, result8, result9, result10, result11, result12, result13, result14, result15, result16, result17, result18, result19];
                                          } else {
                                            var result1 = null;
                                            pos = savedPos0;
                                          }
                                        } else {
                                          var result1 = null;
                                          pos = savedPos0;
                                        }
                                      } else {
                                        var result1 = null;
                                        pos = savedPos0;
                                      }
                                    } else {
                                      var result1 = null;
                                      pos = savedPos0;
                                    }
                                  } else {
                                    var result1 = null;
                                    pos = savedPos0;
                                  }
                                } else {
                                  var result1 = null;
                                  pos = savedPos0;
                                }
                              } else {
                                var result1 = null;
                                pos = savedPos0;
                              }
                            } else {
                              var result1 = null;
                              pos = savedPos0;
                            }
                          } else {
                            var result1 = null;
                            pos = savedPos0;
                          }
                        } else {
                          var result1 = null;
                          pos = savedPos0;
                        }
                      } else {
                        var result1 = null;
                        pos = savedPos0;
                      }
                    } else {
                      var result1 = null;
                      pos = savedPos0;
                    }
                  } else {
                    var result1 = null;
                    pos = savedPos0;
                  }
                } else {
                  var result1 = null;
                  pos = savedPos0;
                }
              } else {
                var result1 = null;
                pos = savedPos0;
              }
            } else {
              var result1 = null;
              pos = savedPos0;
            }
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        var result0 = result1 !== null
          ? (function(t, gs, w, sm) {
                var dataset = {named:[], 'default':[]};
                for(var i=0; i<gs.length; i++) {
                    var g = gs[i];
                    if(g.kind === 'default') {
                        dataset['default'].push(g.graph);
                    } else {
                        dataset['named'].push(g.graph)
                    }
                }
          
          
                if(dataset['named'].length === 0 && dataset['default'].length === 0) {
                    dataset['default'].push({token:'uri', 
                                             prefix:null, 
                                             suffix:null, 
                                             value:'https://github.com/antoniogarrote/rdfstore-js#default_graph'});
                }
          
                var query = {};
                query.kind = 'construct';
                query.token = 'executableunit'
                query.dataset = dataset;
                query.template = t;
                query.pattern = w
                
                if(sm!=null && sm.limit!=null) {
                    query.limit = sm.limit;
                }
                if(sm!=null && sm.offset!=null) {
                    query.offset = sm.offset;
                }
                if(sm!=null && (sm.order!=null && sm.order!="")) {
                    query.order = sm.order;
                }
                return query
          
          })(result1[11], result1[13], result1[15], result1[17])
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[9] ConstructQuery");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_DescribeQuery() {
        var cacheKey = 'DescribeQuery@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        if (input.substr(pos, 8) === "DESCRIBE") {
          var result1 = "DESCRIBE";
          pos += 8;
        } else {
          var result1 = null;
          if (reportMatchFailures) {
            matchFailed("\"DESCRIBE\"");
          }
        }
        if (result1 !== null) {
          var result10 = parse_VarOrIRIref();
          if (result10 !== null) {
            var result9 = [];
            while (result10 !== null) {
              result9.push(result10);
              var result10 = parse_VarOrIRIref();
            }
          } else {
            var result9 = null;
          }
          if (result9 !== null) {
            var result2 = result9;
          } else {
            if (input.substr(pos, 1) === "*") {
              var result8 = "*";
              pos += 1;
            } else {
              var result8 = null;
              if (reportMatchFailures) {
                matchFailed("\"*\"");
              }
            }
            if (result8 !== null) {
              var result2 = result8;
            } else {
              var result2 = null;;
            };
          }
          if (result2 !== null) {
            var result3 = [];
            var result7 = parse_DatasetClause();
            while (result7 !== null) {
              result3.push(result7);
              var result7 = parse_DatasetClause();
            }
            if (result3 !== null) {
              var result6 = parse_WhereClause();
              var result4 = result6 !== null ? result6 : '';
              if (result4 !== null) {
                var result5 = parse_SolutionModifier();
                if (result5 !== null) {
                  var result0 = [result1, result2, result3, result4, result5];
                } else {
                  var result0 = null;
                  pos = savedPos0;
                }
              } else {
                var result0 = null;
                pos = savedPos0;
              }
            } else {
              var result0 = null;
              pos = savedPos0;
            }
          } else {
            var result0 = null;
            pos = savedPos0;
          }
        } else {
          var result0 = null;
          pos = savedPos0;
        }
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[10] DescribeQuery");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_AskQuery() {
        var cacheKey = 'AskQuery@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        var result2 = [];
        var result19 = parse_WS();
        while (result19 !== null) {
          result2.push(result19);
          var result19 = parse_WS();
        }
        if (result2 !== null) {
          if (input.substr(pos, 1) === "A") {
            var result18 = "A";
            pos += 1;
          } else {
            var result18 = null;
            if (reportMatchFailures) {
              matchFailed("\"A\"");
            }
          }
          if (result18 !== null) {
            var result3 = result18;
          } else {
            if (input.substr(pos, 1) === "a") {
              var result17 = "a";
              pos += 1;
            } else {
              var result17 = null;
              if (reportMatchFailures) {
                matchFailed("\"a\"");
              }
            }
            if (result17 !== null) {
              var result3 = result17;
            } else {
              var result3 = null;;
            };
          }
          if (result3 !== null) {
            if (input.substr(pos, 1) === "S") {
              var result16 = "S";
              pos += 1;
            } else {
              var result16 = null;
              if (reportMatchFailures) {
                matchFailed("\"S\"");
              }
            }
            if (result16 !== null) {
              var result4 = result16;
            } else {
              if (input.substr(pos, 1) === "s") {
                var result15 = "s";
                pos += 1;
              } else {
                var result15 = null;
                if (reportMatchFailures) {
                  matchFailed("\"s\"");
                }
              }
              if (result15 !== null) {
                var result4 = result15;
              } else {
                var result4 = null;;
              };
            }
            if (result4 !== null) {
              if (input.substr(pos, 1) === "K") {
                var result14 = "K";
                pos += 1;
              } else {
                var result14 = null;
                if (reportMatchFailures) {
                  matchFailed("\"K\"");
                }
              }
              if (result14 !== null) {
                var result5 = result14;
              } else {
                if (input.substr(pos, 1) === "k") {
                  var result13 = "k";
                  pos += 1;
                } else {
                  var result13 = null;
                  if (reportMatchFailures) {
                    matchFailed("\"k\"");
                  }
                }
                if (result13 !== null) {
                  var result5 = result13;
                } else {
                  var result5 = null;;
                };
              }
              if (result5 !== null) {
                var result6 = [];
                var result12 = parse_WS();
                while (result12 !== null) {
                  result6.push(result12);
                  var result12 = parse_WS();
                }
                if (result6 !== null) {
                  var result7 = [];
                  var result11 = parse_DatasetClause();
                  while (result11 !== null) {
                    result7.push(result11);
                    var result11 = parse_DatasetClause();
                  }
                  if (result7 !== null) {
                    var result8 = [];
                    var result10 = parse_WS();
                    while (result10 !== null) {
                      result8.push(result10);
                      var result10 = parse_WS();
                    }
                    if (result8 !== null) {
                      var result9 = parse_WhereClause();
                      if (result9 !== null) {
                        var result1 = [result2, result3, result4, result5, result6, result7, result8, result9];
                      } else {
                        var result1 = null;
                        pos = savedPos0;
                      }
                    } else {
                      var result1 = null;
                      pos = savedPos0;
                    }
                  } else {
                    var result1 = null;
                    pos = savedPos0;
                  }
                } else {
                  var result1 = null;
                  pos = savedPos0;
                }
              } else {
                var result1 = null;
                pos = savedPos0;
              }
            } else {
              var result1 = null;
              pos = savedPos0;
            }
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        var result0 = result1 !== null
          ? (function(gs, w) {
                var dataset = {'named':[], 'default':[]};
                for(var i=0; i<gs.length; i++) {
                    var g = gs[i];
                    if(g.kind === 'default') {
                        dataset['default'].push(g.graph);
                    } else {
                        dataset['named'].push(g.graph)
                    }
                }
          
          
                if(dataset['named'].length === 0 && dataset['default'].length === 0) {
                    dataset['default'].push({token:'uri', 
                                             prefix:null, 
                                             suffix:null, 
                                             value:'https://github.com/antoniogarrote/rdfstore-js#default_graph'});
                }
          
                var query = {};
                query.kind = 'ask';
                query.token = 'executableunit'
                query.dataset = dataset;
                query.pattern = w
          
                return query
          })(result1[5], result1[7])
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[11] AskQuery");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_DatasetClause() {
        var cacheKey = 'DatasetClause@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        if (input.substr(pos, 1) === "F") {
          var result20 = "F";
          pos += 1;
        } else {
          var result20 = null;
          if (reportMatchFailures) {
            matchFailed("\"F\"");
          }
        }
        if (result20 !== null) {
          var result2 = result20;
        } else {
          if (input.substr(pos, 1) === "f") {
            var result19 = "f";
            pos += 1;
          } else {
            var result19 = null;
            if (reportMatchFailures) {
              matchFailed("\"f\"");
            }
          }
          if (result19 !== null) {
            var result2 = result19;
          } else {
            var result2 = null;;
          };
        }
        if (result2 !== null) {
          if (input.substr(pos, 1) === "R") {
            var result18 = "R";
            pos += 1;
          } else {
            var result18 = null;
            if (reportMatchFailures) {
              matchFailed("\"R\"");
            }
          }
          if (result18 !== null) {
            var result3 = result18;
          } else {
            if (input.substr(pos, 1) === "r") {
              var result17 = "r";
              pos += 1;
            } else {
              var result17 = null;
              if (reportMatchFailures) {
                matchFailed("\"r\"");
              }
            }
            if (result17 !== null) {
              var result3 = result17;
            } else {
              var result3 = null;;
            };
          }
          if (result3 !== null) {
            if (input.substr(pos, 1) === "O") {
              var result16 = "O";
              pos += 1;
            } else {
              var result16 = null;
              if (reportMatchFailures) {
                matchFailed("\"O\"");
              }
            }
            if (result16 !== null) {
              var result4 = result16;
            } else {
              if (input.substr(pos, 1) === "o") {
                var result15 = "o";
                pos += 1;
              } else {
                var result15 = null;
                if (reportMatchFailures) {
                  matchFailed("\"o\"");
                }
              }
              if (result15 !== null) {
                var result4 = result15;
              } else {
                var result4 = null;;
              };
            }
            if (result4 !== null) {
              if (input.substr(pos, 1) === "M") {
                var result14 = "M";
                pos += 1;
              } else {
                var result14 = null;
                if (reportMatchFailures) {
                  matchFailed("\"M\"");
                }
              }
              if (result14 !== null) {
                var result5 = result14;
              } else {
                if (input.substr(pos, 1) === "m") {
                  var result13 = "m";
                  pos += 1;
                } else {
                  var result13 = null;
                  if (reportMatchFailures) {
                    matchFailed("\"m\"");
                  }
                }
                if (result13 !== null) {
                  var result5 = result13;
                } else {
                  var result5 = null;;
                };
              }
              if (result5 !== null) {
                var result6 = [];
                var result12 = parse_WS();
                while (result12 !== null) {
                  result6.push(result12);
                  var result12 = parse_WS();
                }
                if (result6 !== null) {
                  var result11 = parse_DefaultGraphClause();
                  if (result11 !== null) {
                    var result7 = result11;
                  } else {
                    var result10 = parse_NamedGraphClause();
                    if (result10 !== null) {
                      var result7 = result10;
                    } else {
                      var result7 = null;;
                    };
                  }
                  if (result7 !== null) {
                    var result8 = [];
                    var result9 = parse_WS();
                    while (result9 !== null) {
                      result8.push(result9);
                      var result9 = parse_WS();
                    }
                    if (result8 !== null) {
                      var result1 = [result2, result3, result4, result5, result6, result7, result8];
                    } else {
                      var result1 = null;
                      pos = savedPos0;
                    }
                  } else {
                    var result1 = null;
                    pos = savedPos0;
                  }
                } else {
                  var result1 = null;
                  pos = savedPos0;
                }
              } else {
                var result1 = null;
                pos = savedPos0;
              }
            } else {
              var result1 = null;
              pos = savedPos0;
            }
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        var result0 = result1 !== null
          ? (function(gs) {
                return gs;
          })(result1[5])
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[12] DatasetClause");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_DefaultGraphClause() {
        var cacheKey = 'DefaultGraphClause@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        var result2 = [];
        var result4 = parse_WS();
        while (result4 !== null) {
          result2.push(result4);
          var result4 = parse_WS();
        }
        if (result2 !== null) {
          var result3 = parse_IRIref();
          if (result3 !== null) {
            var result1 = [result2, result3];
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        var result0 = result1 !== null
          ? (function(s) {
              return {graph:s , kind:'default', token:'graphClause'}
          })(result1[1])
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[13] DefaultGraphClause");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_NamedGraphClause() {
        var cacheKey = 'NamedGraphClause@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        if (input.substr(pos, 1) === "N") {
          var result19 = "N";
          pos += 1;
        } else {
          var result19 = null;
          if (reportMatchFailures) {
            matchFailed("\"N\"");
          }
        }
        if (result19 !== null) {
          var result2 = result19;
        } else {
          if (input.substr(pos, 1) === "n") {
            var result18 = "n";
            pos += 1;
          } else {
            var result18 = null;
            if (reportMatchFailures) {
              matchFailed("\"n\"");
            }
          }
          if (result18 !== null) {
            var result2 = result18;
          } else {
            var result2 = null;;
          };
        }
        if (result2 !== null) {
          if (input.substr(pos, 1) === "A") {
            var result17 = "A";
            pos += 1;
          } else {
            var result17 = null;
            if (reportMatchFailures) {
              matchFailed("\"A\"");
            }
          }
          if (result17 !== null) {
            var result3 = result17;
          } else {
            if (input.substr(pos, 1) === "a") {
              var result16 = "a";
              pos += 1;
            } else {
              var result16 = null;
              if (reportMatchFailures) {
                matchFailed("\"a\"");
              }
            }
            if (result16 !== null) {
              var result3 = result16;
            } else {
              var result3 = null;;
            };
          }
          if (result3 !== null) {
            if (input.substr(pos, 1) === "M") {
              var result15 = "M";
              pos += 1;
            } else {
              var result15 = null;
              if (reportMatchFailures) {
                matchFailed("\"M\"");
              }
            }
            if (result15 !== null) {
              var result4 = result15;
            } else {
              if (input.substr(pos, 1) === "m") {
                var result14 = "m";
                pos += 1;
              } else {
                var result14 = null;
                if (reportMatchFailures) {
                  matchFailed("\"m\"");
                }
              }
              if (result14 !== null) {
                var result4 = result14;
              } else {
                var result4 = null;;
              };
            }
            if (result4 !== null) {
              if (input.substr(pos, 1) === "E") {
                var result13 = "E";
                pos += 1;
              } else {
                var result13 = null;
                if (reportMatchFailures) {
                  matchFailed("\"E\"");
                }
              }
              if (result13 !== null) {
                var result5 = result13;
              } else {
                if (input.substr(pos, 1) === "e") {
                  var result12 = "e";
                  pos += 1;
                } else {
                  var result12 = null;
                  if (reportMatchFailures) {
                    matchFailed("\"e\"");
                  }
                }
                if (result12 !== null) {
                  var result5 = result12;
                } else {
                  var result5 = null;;
                };
              }
              if (result5 !== null) {
                if (input.substr(pos, 1) === "D") {
                  var result11 = "D";
                  pos += 1;
                } else {
                  var result11 = null;
                  if (reportMatchFailures) {
                    matchFailed("\"D\"");
                  }
                }
                if (result11 !== null) {
                  var result6 = result11;
                } else {
                  if (input.substr(pos, 1) === "d") {
                    var result10 = "d";
                    pos += 1;
                  } else {
                    var result10 = null;
                    if (reportMatchFailures) {
                      matchFailed("\"d\"");
                    }
                  }
                  if (result10 !== null) {
                    var result6 = result10;
                  } else {
                    var result6 = null;;
                  };
                }
                if (result6 !== null) {
                  var result7 = [];
                  var result9 = parse_WS();
                  while (result9 !== null) {
                    result7.push(result9);
                    var result9 = parse_WS();
                  }
                  if (result7 !== null) {
                    var result8 = parse_IRIref();
                    if (result8 !== null) {
                      var result1 = [result2, result3, result4, result5, result6, result7, result8];
                    } else {
                      var result1 = null;
                      pos = savedPos0;
                    }
                  } else {
                    var result1 = null;
                    pos = savedPos0;
                  }
                } else {
                  var result1 = null;
                  pos = savedPos0;
                }
              } else {
                var result1 = null;
                pos = savedPos0;
              }
            } else {
              var result1 = null;
              pos = savedPos0;
            }
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        var result0 = result1 !== null
          ? (function(s) {      
                return {graph:s, kind:'named', token:'graphCluase'};
          })(result1[6])
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[14] NamedGraphClause");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_WhereClause() {
        var cacheKey = 'WhereClause@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        var savedPos1 = pos;
        if (input.substr(pos, 1) === "W") {
          var result23 = "W";
          pos += 1;
        } else {
          var result23 = null;
          if (reportMatchFailures) {
            matchFailed("\"W\"");
          }
        }
        if (result23 !== null) {
          var result9 = result23;
        } else {
          if (input.substr(pos, 1) === "w") {
            var result22 = "w";
            pos += 1;
          } else {
            var result22 = null;
            if (reportMatchFailures) {
              matchFailed("\"w\"");
            }
          }
          if (result22 !== null) {
            var result9 = result22;
          } else {
            var result9 = null;;
          };
        }
        if (result9 !== null) {
          if (input.substr(pos, 1) === "H") {
            var result21 = "H";
            pos += 1;
          } else {
            var result21 = null;
            if (reportMatchFailures) {
              matchFailed("\"H\"");
            }
          }
          if (result21 !== null) {
            var result10 = result21;
          } else {
            if (input.substr(pos, 1) === "h") {
              var result20 = "h";
              pos += 1;
            } else {
              var result20 = null;
              if (reportMatchFailures) {
                matchFailed("\"h\"");
              }
            }
            if (result20 !== null) {
              var result10 = result20;
            } else {
              var result10 = null;;
            };
          }
          if (result10 !== null) {
            if (input.substr(pos, 1) === "E") {
              var result19 = "E";
              pos += 1;
            } else {
              var result19 = null;
              if (reportMatchFailures) {
                matchFailed("\"E\"");
              }
            }
            if (result19 !== null) {
              var result11 = result19;
            } else {
              if (input.substr(pos, 1) === "e") {
                var result18 = "e";
                pos += 1;
              } else {
                var result18 = null;
                if (reportMatchFailures) {
                  matchFailed("\"e\"");
                }
              }
              if (result18 !== null) {
                var result11 = result18;
              } else {
                var result11 = null;;
              };
            }
            if (result11 !== null) {
              if (input.substr(pos, 1) === "R") {
                var result17 = "R";
                pos += 1;
              } else {
                var result17 = null;
                if (reportMatchFailures) {
                  matchFailed("\"R\"");
                }
              }
              if (result17 !== null) {
                var result12 = result17;
              } else {
                if (input.substr(pos, 1) === "r") {
                  var result16 = "r";
                  pos += 1;
                } else {
                  var result16 = null;
                  if (reportMatchFailures) {
                    matchFailed("\"r\"");
                  }
                }
                if (result16 !== null) {
                  var result12 = result16;
                } else {
                  var result12 = null;;
                };
              }
              if (result12 !== null) {
                if (input.substr(pos, 1) === "E") {
                  var result15 = "E";
                  pos += 1;
                } else {
                  var result15 = null;
                  if (reportMatchFailures) {
                    matchFailed("\"E\"");
                  }
                }
                if (result15 !== null) {
                  var result13 = result15;
                } else {
                  if (input.substr(pos, 1) === "e") {
                    var result14 = "e";
                    pos += 1;
                  } else {
                    var result14 = null;
                    if (reportMatchFailures) {
                      matchFailed("\"e\"");
                    }
                  }
                  if (result14 !== null) {
                    var result13 = result14;
                  } else {
                    var result13 = null;;
                  };
                }
                if (result13 !== null) {
                  var result8 = [result9, result10, result11, result12, result13];
                } else {
                  var result8 = null;
                  pos = savedPos1;
                }
              } else {
                var result8 = null;
                pos = savedPos1;
              }
            } else {
              var result8 = null;
              pos = savedPos1;
            }
          } else {
            var result8 = null;
            pos = savedPos1;
          }
        } else {
          var result8 = null;
          pos = savedPos1;
        }
        var result2 = result8 !== null ? result8 : '';
        if (result2 !== null) {
          var result3 = [];
          var result7 = parse_WS();
          while (result7 !== null) {
            result3.push(result7);
            var result7 = parse_WS();
          }
          if (result3 !== null) {
            var result4 = parse_GroupGraphPattern();
            if (result4 !== null) {
              var result5 = [];
              var result6 = parse_WS();
              while (result6 !== null) {
                result5.push(result6);
                var result6 = parse_WS();
              }
              if (result5 !== null) {
                var result1 = [result2, result3, result4, result5];
              } else {
                var result1 = null;
                pos = savedPos0;
              }
            } else {
              var result1 = null;
              pos = savedPos0;
            }
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        var result0 = result1 !== null
          ? (function(g) {
                return g;
          })(result1[2])
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[16] WhereClause");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_SolutionModifier() {
        var cacheKey = 'SolutionModifier@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        var result9 = parse_GroupClause();
        var result2 = result9 !== null ? result9 : '';
        if (result2 !== null) {
          var result8 = parse_HavingClause();
          var result3 = result8 !== null ? result8 : '';
          if (result3 !== null) {
            var result7 = parse_OrderClause();
            var result4 = result7 !== null ? result7 : '';
            if (result4 !== null) {
              var result6 = parse_LimitOffsetClauses();
              var result5 = result6 !== null ? result6 : '';
              if (result5 !== null) {
                var result1 = [result2, result3, result4, result5];
              } else {
                var result1 = null;
                pos = savedPos0;
              }
            } else {
              var result1 = null;
              pos = savedPos0;
            }
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        var result0 = result1 !== null
          ? (function(gc, oc, lo) {
                var acum = {};
                if(lo != null) {
                    if(lo.limit != null) {
                        acum.limit = lo.limit;
                    } 
                    if(lo.offset != null) {
                        acum.offset = lo.offset;
                    }
                }
          
                if(gc != null) {
                    acum.group = gc;
                }
          
                acum.order = oc;
          
                return acum
          })(result1[0], result1[2], result1[3])
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[17] SolutionModifier");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_GroupClause() {
        var cacheKey = 'GroupClause@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        if (input.substr(pos, 1) === "G") {
          var result28 = "G";
          pos += 1;
        } else {
          var result28 = null;
          if (reportMatchFailures) {
            matchFailed("\"G\"");
          }
        }
        if (result28 !== null) {
          var result2 = result28;
        } else {
          if (input.substr(pos, 1) === "g") {
            var result27 = "g";
            pos += 1;
          } else {
            var result27 = null;
            if (reportMatchFailures) {
              matchFailed("\"g\"");
            }
          }
          if (result27 !== null) {
            var result2 = result27;
          } else {
            var result2 = null;;
          };
        }
        if (result2 !== null) {
          if (input.substr(pos, 1) === "R") {
            var result26 = "R";
            pos += 1;
          } else {
            var result26 = null;
            if (reportMatchFailures) {
              matchFailed("\"R\"");
            }
          }
          if (result26 !== null) {
            var result3 = result26;
          } else {
            if (input.substr(pos, 1) === "r") {
              var result25 = "r";
              pos += 1;
            } else {
              var result25 = null;
              if (reportMatchFailures) {
                matchFailed("\"r\"");
              }
            }
            if (result25 !== null) {
              var result3 = result25;
            } else {
              var result3 = null;;
            };
          }
          if (result3 !== null) {
            if (input.substr(pos, 1) === "O") {
              var result24 = "O";
              pos += 1;
            } else {
              var result24 = null;
              if (reportMatchFailures) {
                matchFailed("\"O\"");
              }
            }
            if (result24 !== null) {
              var result4 = result24;
            } else {
              if (input.substr(pos, 1) === "o") {
                var result23 = "o";
                pos += 1;
              } else {
                var result23 = null;
                if (reportMatchFailures) {
                  matchFailed("\"o\"");
                }
              }
              if (result23 !== null) {
                var result4 = result23;
              } else {
                var result4 = null;;
              };
            }
            if (result4 !== null) {
              if (input.substr(pos, 1) === "U") {
                var result22 = "U";
                pos += 1;
              } else {
                var result22 = null;
                if (reportMatchFailures) {
                  matchFailed("\"U\"");
                }
              }
              if (result22 !== null) {
                var result5 = result22;
              } else {
                if (input.substr(pos, 1) === "u") {
                  var result21 = "u";
                  pos += 1;
                } else {
                  var result21 = null;
                  if (reportMatchFailures) {
                    matchFailed("\"u\"");
                  }
                }
                if (result21 !== null) {
                  var result5 = result21;
                } else {
                  var result5 = null;;
                };
              }
              if (result5 !== null) {
                if (input.substr(pos, 1) === "P") {
                  var result20 = "P";
                  pos += 1;
                } else {
                  var result20 = null;
                  if (reportMatchFailures) {
                    matchFailed("\"P\"");
                  }
                }
                if (result20 !== null) {
                  var result6 = result20;
                } else {
                  if (input.substr(pos, 1) === "p") {
                    var result19 = "p";
                    pos += 1;
                  } else {
                    var result19 = null;
                    if (reportMatchFailures) {
                      matchFailed("\"p\"");
                    }
                  }
                  if (result19 !== null) {
                    var result6 = result19;
                  } else {
                    var result6 = null;;
                  };
                }
                if (result6 !== null) {
                  var result7 = [];
                  var result18 = parse_WS();
                  while (result18 !== null) {
                    result7.push(result18);
                    var result18 = parse_WS();
                  }
                  if (result7 !== null) {
                    if (input.substr(pos, 1) === "B") {
                      var result17 = "B";
                      pos += 1;
                    } else {
                      var result17 = null;
                      if (reportMatchFailures) {
                        matchFailed("\"B\"");
                      }
                    }
                    if (result17 !== null) {
                      var result8 = result17;
                    } else {
                      if (input.substr(pos, 1) === "b") {
                        var result16 = "b";
                        pos += 1;
                      } else {
                        var result16 = null;
                        if (reportMatchFailures) {
                          matchFailed("\"b\"");
                        }
                      }
                      if (result16 !== null) {
                        var result8 = result16;
                      } else {
                        var result8 = null;;
                      };
                    }
                    if (result8 !== null) {
                      if (input.substr(pos, 1) === "Y") {
                        var result15 = "Y";
                        pos += 1;
                      } else {
                        var result15 = null;
                        if (reportMatchFailures) {
                          matchFailed("\"Y\"");
                        }
                      }
                      if (result15 !== null) {
                        var result9 = result15;
                      } else {
                        if (input.substr(pos, 1) === "y") {
                          var result14 = "y";
                          pos += 1;
                        } else {
                          var result14 = null;
                          if (reportMatchFailures) {
                            matchFailed("\"y\"");
                          }
                        }
                        if (result14 !== null) {
                          var result9 = result14;
                        } else {
                          var result9 = null;;
                        };
                      }
                      if (result9 !== null) {
                        var result10 = [];
                        var result13 = parse_WS();
                        while (result13 !== null) {
                          result10.push(result13);
                          var result13 = parse_WS();
                        }
                        if (result10 !== null) {
                          var result12 = parse_GroupCondition();
                          if (result12 !== null) {
                            var result11 = [];
                            while (result12 !== null) {
                              result11.push(result12);
                              var result12 = parse_GroupCondition();
                            }
                          } else {
                            var result11 = null;
                          }
                          if (result11 !== null) {
                            var result1 = [result2, result3, result4, result5, result6, result7, result8, result9, result10, result11];
                          } else {
                            var result1 = null;
                            pos = savedPos0;
                          }
                        } else {
                          var result1 = null;
                          pos = savedPos0;
                        }
                      } else {
                        var result1 = null;
                        pos = savedPos0;
                      }
                    } else {
                      var result1 = null;
                      pos = savedPos0;
                    }
                  } else {
                    var result1 = null;
                    pos = savedPos0;
                  }
                } else {
                  var result1 = null;
                  pos = savedPos0;
                }
              } else {
                var result1 = null;
                pos = savedPos0;
              }
            } else {
              var result1 = null;
              pos = savedPos0;
            }
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        var result0 = result1 !== null
          ? (function(conds) {
                return conds;
          })(result1[9])
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[18] GroupClause");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_GroupCondition() {
        var cacheKey = 'GroupCondition@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos4 = pos;
        var result43 = [];
        var result47 = parse_WS();
        while (result47 !== null) {
          result43.push(result47);
          var result47 = parse_WS();
        }
        if (result43 !== null) {
          var result44 = parse_BuiltInCall();
          if (result44 !== null) {
            var result45 = [];
            var result46 = parse_WS();
            while (result46 !== null) {
              result45.push(result46);
              var result46 = parse_WS();
            }
            if (result45 !== null) {
              var result42 = [result43, result44, result45];
            } else {
              var result42 = null;
              pos = savedPos4;
            }
          } else {
            var result42 = null;
            pos = savedPos4;
          }
        } else {
          var result42 = null;
          pos = savedPos4;
        }
        var result41 = result42 !== null
          ? (function(b) {
                return b;
          })(result42[1])
          : null;
        if (result41 !== null) {
          var result0 = result41;
        } else {
          var savedPos3 = pos;
          var result36 = [];
          var result40 = parse_WS();
          while (result40 !== null) {
            result36.push(result40);
            var result40 = parse_WS();
          }
          if (result36 !== null) {
            var result37 = parse_FunctionCall();
            if (result37 !== null) {
              var result38 = [];
              var result39 = parse_WS();
              while (result39 !== null) {
                result38.push(result39);
                var result39 = parse_WS();
              }
              if (result38 !== null) {
                var result35 = [result36, result37, result38];
              } else {
                var result35 = null;
                pos = savedPos3;
              }
            } else {
              var result35 = null;
              pos = savedPos3;
            }
          } else {
            var result35 = null;
            pos = savedPos3;
          }
          var result34 = result35 !== null
            ? (function(f) {
                  return f;
            })(result35[1])
            : null;
          if (result34 !== null) {
            var result0 = result34;
          } else {
            var savedPos1 = pos;
            var result10 = [];
            var result33 = parse_WS();
            while (result33 !== null) {
              result10.push(result33);
              var result33 = parse_WS();
            }
            if (result10 !== null) {
              if (input.substr(pos, 1) === "(") {
                var result11 = "(";
                pos += 1;
              } else {
                var result11 = null;
                if (reportMatchFailures) {
                  matchFailed("\"(\"");
                }
              }
              if (result11 !== null) {
                var result12 = [];
                var result32 = parse_WS();
                while (result32 !== null) {
                  result12.push(result32);
                  var result32 = parse_WS();
                }
                if (result12 !== null) {
                  var result13 = parse_ConditionalOrExpression();
                  if (result13 !== null) {
                    var result14 = [];
                    var result31 = parse_WS();
                    while (result31 !== null) {
                      result14.push(result31);
                      var result31 = parse_WS();
                    }
                    if (result14 !== null) {
                      var savedPos2 = pos;
                      if (input.substr(pos, 1) === "A") {
                        var result30 = "A";
                        pos += 1;
                      } else {
                        var result30 = null;
                        if (reportMatchFailures) {
                          matchFailed("\"A\"");
                        }
                      }
                      if (result30 !== null) {
                        var result22 = result30;
                      } else {
                        if (input.substr(pos, 1) === "a") {
                          var result29 = "a";
                          pos += 1;
                        } else {
                          var result29 = null;
                          if (reportMatchFailures) {
                            matchFailed("\"a\"");
                          }
                        }
                        if (result29 !== null) {
                          var result22 = result29;
                        } else {
                          var result22 = null;;
                        };
                      }
                      if (result22 !== null) {
                        if (input.substr(pos, 1) === "S") {
                          var result28 = "S";
                          pos += 1;
                        } else {
                          var result28 = null;
                          if (reportMatchFailures) {
                            matchFailed("\"S\"");
                          }
                        }
                        if (result28 !== null) {
                          var result23 = result28;
                        } else {
                          if (input.substr(pos, 1) === "s") {
                            var result27 = "s";
                            pos += 1;
                          } else {
                            var result27 = null;
                            if (reportMatchFailures) {
                              matchFailed("\"s\"");
                            }
                          }
                          if (result27 !== null) {
                            var result23 = result27;
                          } else {
                            var result23 = null;;
                          };
                        }
                        if (result23 !== null) {
                          var result24 = [];
                          var result26 = parse_WS();
                          while (result26 !== null) {
                            result24.push(result26);
                            var result26 = parse_WS();
                          }
                          if (result24 !== null) {
                            var result25 = parse_Var();
                            if (result25 !== null) {
                              var result21 = [result22, result23, result24, result25];
                            } else {
                              var result21 = null;
                              pos = savedPos2;
                            }
                          } else {
                            var result21 = null;
                            pos = savedPos2;
                          }
                        } else {
                          var result21 = null;
                          pos = savedPos2;
                        }
                      } else {
                        var result21 = null;
                        pos = savedPos2;
                      }
                      var result15 = result21 !== null ? result21 : '';
                      if (result15 !== null) {
                        var result16 = [];
                        var result20 = parse_WS();
                        while (result20 !== null) {
                          result16.push(result20);
                          var result20 = parse_WS();
                        }
                        if (result16 !== null) {
                          if (input.substr(pos, 1) === ")") {
                            var result17 = ")";
                            pos += 1;
                          } else {
                            var result17 = null;
                            if (reportMatchFailures) {
                              matchFailed("\")\"");
                            }
                          }
                          if (result17 !== null) {
                            var result18 = [];
                            var result19 = parse_WS();
                            while (result19 !== null) {
                              result18.push(result19);
                              var result19 = parse_WS();
                            }
                            if (result18 !== null) {
                              var result9 = [result10, result11, result12, result13, result14, result15, result16, result17, result18];
                            } else {
                              var result9 = null;
                              pos = savedPos1;
                            }
                          } else {
                            var result9 = null;
                            pos = savedPos1;
                          }
                        } else {
                          var result9 = null;
                          pos = savedPos1;
                        }
                      } else {
                        var result9 = null;
                        pos = savedPos1;
                      }
                    } else {
                      var result9 = null;
                      pos = savedPos1;
                    }
                  } else {
                    var result9 = null;
                    pos = savedPos1;
                  }
                } else {
                  var result9 = null;
                  pos = savedPos1;
                }
              } else {
                var result9 = null;
                pos = savedPos1;
              }
            } else {
              var result9 = null;
              pos = savedPos1;
            }
            var result8 = result9 !== null
              ? (function(e, alias) {
                    if(alias.length != 0) {
                        return {token: 'aliased_expression',
                                expression: e,
                                alias: alias[3] };
                    } else {
                        return e;
                    }
              })(result9[3], result9[5])
              : null;
            if (result8 !== null) {
              var result0 = result8;
            } else {
              var savedPos0 = pos;
              var result3 = [];
              var result7 = parse_WS();
              while (result7 !== null) {
                result3.push(result7);
                var result7 = parse_WS();
              }
              if (result3 !== null) {
                var result4 = parse_Var();
                if (result4 !== null) {
                  var result5 = [];
                  var result6 = parse_WS();
                  while (result6 !== null) {
                    result5.push(result6);
                    var result6 = parse_WS();
                  }
                  if (result5 !== null) {
                    var result2 = [result3, result4, result5];
                  } else {
                    var result2 = null;
                    pos = savedPos0;
                  }
                } else {
                  var result2 = null;
                  pos = savedPos0;
                }
              } else {
                var result2 = null;
                pos = savedPos0;
              }
              var result1 = result2 !== null
                ? (function(v) {
                      return v;
                })(result2[1])
                : null;
              if (result1 !== null) {
                var result0 = result1;
              } else {
                var result0 = null;;
              };
            };
          };
        }
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[19] GroupCondition");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_HavingClause() {
        var cacheKey = 'HavingClause@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        if (input.substr(pos, 6) === "HAVING") {
          var result1 = "HAVING";
          pos += 6;
        } else {
          var result1 = null;
          if (reportMatchFailures) {
            matchFailed("\"HAVING\"");
          }
        }
        if (result1 !== null) {
          var result3 = parse_Constraint();
          if (result3 !== null) {
            var result2 = [];
            while (result3 !== null) {
              result2.push(result3);
              var result3 = parse_Constraint();
            }
          } else {
            var result2 = null;
          }
          if (result2 !== null) {
            var result0 = [result1, result2];
          } else {
            var result0 = null;
            pos = savedPos0;
          }
        } else {
          var result0 = null;
          pos = savedPos0;
        }
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[20] HavingClause");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_OrderClause() {
        var cacheKey = 'OrderClause@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        if (input.substr(pos, 1) === "O") {
          var result30 = "O";
          pos += 1;
        } else {
          var result30 = null;
          if (reportMatchFailures) {
            matchFailed("\"O\"");
          }
        }
        if (result30 !== null) {
          var result2 = result30;
        } else {
          if (input.substr(pos, 1) === "o") {
            var result29 = "o";
            pos += 1;
          } else {
            var result29 = null;
            if (reportMatchFailures) {
              matchFailed("\"o\"");
            }
          }
          if (result29 !== null) {
            var result2 = result29;
          } else {
            var result2 = null;;
          };
        }
        if (result2 !== null) {
          if (input.substr(pos, 1) === "R") {
            var result28 = "R";
            pos += 1;
          } else {
            var result28 = null;
            if (reportMatchFailures) {
              matchFailed("\"R\"");
            }
          }
          if (result28 !== null) {
            var result3 = result28;
          } else {
            if (input.substr(pos, 1) === "r") {
              var result27 = "r";
              pos += 1;
            } else {
              var result27 = null;
              if (reportMatchFailures) {
                matchFailed("\"r\"");
              }
            }
            if (result27 !== null) {
              var result3 = result27;
            } else {
              var result3 = null;;
            };
          }
          if (result3 !== null) {
            if (input.substr(pos, 1) === "D") {
              var result26 = "D";
              pos += 1;
            } else {
              var result26 = null;
              if (reportMatchFailures) {
                matchFailed("\"D\"");
              }
            }
            if (result26 !== null) {
              var result4 = result26;
            } else {
              if (input.substr(pos, 1) === "d") {
                var result25 = "d";
                pos += 1;
              } else {
                var result25 = null;
                if (reportMatchFailures) {
                  matchFailed("\"d\"");
                }
              }
              if (result25 !== null) {
                var result4 = result25;
              } else {
                var result4 = null;;
              };
            }
            if (result4 !== null) {
              if (input.substr(pos, 1) === "E") {
                var result24 = "E";
                pos += 1;
              } else {
                var result24 = null;
                if (reportMatchFailures) {
                  matchFailed("\"E\"");
                }
              }
              if (result24 !== null) {
                var result5 = result24;
              } else {
                if (input.substr(pos, 1) === "e") {
                  var result23 = "e";
                  pos += 1;
                } else {
                  var result23 = null;
                  if (reportMatchFailures) {
                    matchFailed("\"e\"");
                  }
                }
                if (result23 !== null) {
                  var result5 = result23;
                } else {
                  var result5 = null;;
                };
              }
              if (result5 !== null) {
                if (input.substr(pos, 1) === "R") {
                  var result22 = "R";
                  pos += 1;
                } else {
                  var result22 = null;
                  if (reportMatchFailures) {
                    matchFailed("\"R\"");
                  }
                }
                if (result22 !== null) {
                  var result6 = result22;
                } else {
                  if (input.substr(pos, 1) === "r") {
                    var result21 = "r";
                    pos += 1;
                  } else {
                    var result21 = null;
                    if (reportMatchFailures) {
                      matchFailed("\"r\"");
                    }
                  }
                  if (result21 !== null) {
                    var result6 = result21;
                  } else {
                    var result6 = null;;
                  };
                }
                if (result6 !== null) {
                  var result7 = [];
                  var result20 = parse_WS();
                  while (result20 !== null) {
                    result7.push(result20);
                    var result20 = parse_WS();
                  }
                  if (result7 !== null) {
                    if (input.substr(pos, 1) === "B") {
                      var result19 = "B";
                      pos += 1;
                    } else {
                      var result19 = null;
                      if (reportMatchFailures) {
                        matchFailed("\"B\"");
                      }
                    }
                    if (result19 !== null) {
                      var result8 = result19;
                    } else {
                      if (input.substr(pos, 1) === "b") {
                        var result18 = "b";
                        pos += 1;
                      } else {
                        var result18 = null;
                        if (reportMatchFailures) {
                          matchFailed("\"b\"");
                        }
                      }
                      if (result18 !== null) {
                        var result8 = result18;
                      } else {
                        var result8 = null;;
                      };
                    }
                    if (result8 !== null) {
                      if (input.substr(pos, 1) === "Y") {
                        var result17 = "Y";
                        pos += 1;
                      } else {
                        var result17 = null;
                        if (reportMatchFailures) {
                          matchFailed("\"Y\"");
                        }
                      }
                      if (result17 !== null) {
                        var result9 = result17;
                      } else {
                        if (input.substr(pos, 1) === "y") {
                          var result16 = "y";
                          pos += 1;
                        } else {
                          var result16 = null;
                          if (reportMatchFailures) {
                            matchFailed("\"y\"");
                          }
                        }
                        if (result16 !== null) {
                          var result9 = result16;
                        } else {
                          var result9 = null;;
                        };
                      }
                      if (result9 !== null) {
                        var result10 = [];
                        var result15 = parse_WS();
                        while (result15 !== null) {
                          result10.push(result15);
                          var result15 = parse_WS();
                        }
                        if (result10 !== null) {
                          var result14 = parse_OrderCondition();
                          if (result14 !== null) {
                            var result11 = [];
                            while (result14 !== null) {
                              result11.push(result14);
                              var result14 = parse_OrderCondition();
                            }
                          } else {
                            var result11 = null;
                          }
                          if (result11 !== null) {
                            var result12 = [];
                            var result13 = parse_WS();
                            while (result13 !== null) {
                              result12.push(result13);
                              var result13 = parse_WS();
                            }
                            if (result12 !== null) {
                              var result1 = [result2, result3, result4, result5, result6, result7, result8, result9, result10, result11, result12];
                            } else {
                              var result1 = null;
                              pos = savedPos0;
                            }
                          } else {
                            var result1 = null;
                            pos = savedPos0;
                          }
                        } else {
                          var result1 = null;
                          pos = savedPos0;
                        }
                      } else {
                        var result1 = null;
                        pos = savedPos0;
                      }
                    } else {
                      var result1 = null;
                      pos = savedPos0;
                    }
                  } else {
                    var result1 = null;
                    pos = savedPos0;
                  }
                } else {
                  var result1 = null;
                  pos = savedPos0;
                }
              } else {
                var result1 = null;
                pos = savedPos0;
              }
            } else {
              var result1 = null;
              pos = savedPos0;
            }
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        var result0 = result1 !== null
          ? (function(os) {
                return os;
          })(result1[9])
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[22] OrderClause");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_OrderCondition() {
        var cacheKey = 'OrderCondition@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos1 = pos;
        if (input.substr(pos, 3) === "ASC") {
          var result17 = "ASC";
          pos += 3;
        } else {
          var result17 = null;
          if (reportMatchFailures) {
            matchFailed("\"ASC\"");
          }
        }
        if (result17 !== null) {
          var result10 = result17;
        } else {
          if (input.substr(pos, 4) === "DESC") {
            var result16 = "DESC";
            pos += 4;
          } else {
            var result16 = null;
            if (reportMatchFailures) {
              matchFailed("\"DESC\"");
            }
          }
          if (result16 !== null) {
            var result10 = result16;
          } else {
            var result10 = null;;
          };
        }
        if (result10 !== null) {
          var result11 = [];
          var result15 = parse_WS();
          while (result15 !== null) {
            result11.push(result15);
            var result15 = parse_WS();
          }
          if (result11 !== null) {
            var result12 = parse_BrackettedExpression();
            if (result12 !== null) {
              var result13 = [];
              var result14 = parse_WS();
              while (result14 !== null) {
                result13.push(result14);
                var result14 = parse_WS();
              }
              if (result13 !== null) {
                var result9 = [result10, result11, result12, result13];
              } else {
                var result9 = null;
                pos = savedPos1;
              }
            } else {
              var result9 = null;
              pos = savedPos1;
            }
          } else {
            var result9 = null;
            pos = savedPos1;
          }
        } else {
          var result9 = null;
          pos = savedPos1;
        }
        var result8 = result9 !== null
          ? (function(direction, e) {
                return { direction: direction, expression:e };
          })(result9[0], result9[2])
          : null;
        if (result8 !== null) {
          var result0 = result8;
        } else {
          var savedPos0 = pos;
          var result7 = parse_Constraint();
          if (result7 !== null) {
            var result3 = result7;
          } else {
            var result6 = parse_Var();
            if (result6 !== null) {
              var result3 = result6;
            } else {
              var result3 = null;;
            };
          }
          if (result3 !== null) {
            var result4 = [];
            var result5 = parse_WS();
            while (result5 !== null) {
              result4.push(result5);
              var result5 = parse_WS();
            }
            if (result4 !== null) {
              var result2 = [result3, result4];
            } else {
              var result2 = null;
              pos = savedPos0;
            }
          } else {
            var result2 = null;
            pos = savedPos0;
          }
          var result1 = result2 !== null
            ? (function(e) {
                if(e.token === 'var') {
                    e = { token:'expression', 
                          expressionType:'atomic',
                          primaryexpression: 'var',
                          value: e };
                }
                return { direction: 'ASC', expression:e };
            })(result2[0])
            : null;
          if (result1 !== null) {
            var result0 = result1;
          } else {
            var result0 = null;;
          };
        }
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[23] OrderCondition");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_LimitOffsetClauses() {
        var cacheKey = 'LimitOffsetClauses@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos1 = pos;
        var result7 = parse_LimitClause();
        if (result7 !== null) {
          var result9 = parse_OffsetClause();
          var result8 = result9 !== null ? result9 : '';
          if (result8 !== null) {
            var result6 = [result7, result8];
          } else {
            var result6 = null;
            pos = savedPos1;
          }
        } else {
          var result6 = null;
          pos = savedPos1;
        }
        if (result6 !== null) {
          var result1 = result6;
        } else {
          var savedPos0 = pos;
          var result3 = parse_OffsetClause();
          if (result3 !== null) {
            var result5 = parse_LimitClause();
            var result4 = result5 !== null ? result5 : '';
            if (result4 !== null) {
              var result2 = [result3, result4];
            } else {
              var result2 = null;
              pos = savedPos0;
            }
          } else {
            var result2 = null;
            pos = savedPos0;
          }
          if (result2 !== null) {
            var result1 = result2;
          } else {
            var result1 = null;;
          };
        }
        var result0 = result1 !== null
          ? (function(cls) {
                var acum = {};
                for(var i=0; i<cls.length; i++) {
                    var cl = cls[i];
                    if(cl.limit != null) {
                        acum['limit'] = cl.limit;
                    } else if(cl.offset != null){
                        acum['offset'] = cl.offset;
                    }
                }
          
                return acum;
          })(result1)
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[24] LimitOffsetClauses");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_LimitClause() {
        var cacheKey = 'LimitClause@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        if (input.substr(pos, 1) === "L") {
          var result21 = "L";
          pos += 1;
        } else {
          var result21 = null;
          if (reportMatchFailures) {
            matchFailed("\"L\"");
          }
        }
        if (result21 !== null) {
          var result2 = result21;
        } else {
          if (input.substr(pos, 1) === "l") {
            var result20 = "l";
            pos += 1;
          } else {
            var result20 = null;
            if (reportMatchFailures) {
              matchFailed("\"l\"");
            }
          }
          if (result20 !== null) {
            var result2 = result20;
          } else {
            var result2 = null;;
          };
        }
        if (result2 !== null) {
          if (input.substr(pos, 1) === "I") {
            var result19 = "I";
            pos += 1;
          } else {
            var result19 = null;
            if (reportMatchFailures) {
              matchFailed("\"I\"");
            }
          }
          if (result19 !== null) {
            var result3 = result19;
          } else {
            if (input.substr(pos, 1) === "i") {
              var result18 = "i";
              pos += 1;
            } else {
              var result18 = null;
              if (reportMatchFailures) {
                matchFailed("\"i\"");
              }
            }
            if (result18 !== null) {
              var result3 = result18;
            } else {
              var result3 = null;;
            };
          }
          if (result3 !== null) {
            if (input.substr(pos, 1) === "M") {
              var result17 = "M";
              pos += 1;
            } else {
              var result17 = null;
              if (reportMatchFailures) {
                matchFailed("\"M\"");
              }
            }
            if (result17 !== null) {
              var result4 = result17;
            } else {
              if (input.substr(pos, 1) === "m") {
                var result16 = "m";
                pos += 1;
              } else {
                var result16 = null;
                if (reportMatchFailures) {
                  matchFailed("\"m\"");
                }
              }
              if (result16 !== null) {
                var result4 = result16;
              } else {
                var result4 = null;;
              };
            }
            if (result4 !== null) {
              if (input.substr(pos, 1) === "I") {
                var result15 = "I";
                pos += 1;
              } else {
                var result15 = null;
                if (reportMatchFailures) {
                  matchFailed("\"I\"");
                }
              }
              if (result15 !== null) {
                var result5 = result15;
              } else {
                if (input.substr(pos, 1) === "i") {
                  var result14 = "i";
                  pos += 1;
                } else {
                  var result14 = null;
                  if (reportMatchFailures) {
                    matchFailed("\"i\"");
                  }
                }
                if (result14 !== null) {
                  var result5 = result14;
                } else {
                  var result5 = null;;
                };
              }
              if (result5 !== null) {
                if (input.substr(pos, 1) === "T") {
                  var result13 = "T";
                  pos += 1;
                } else {
                  var result13 = null;
                  if (reportMatchFailures) {
                    matchFailed("\"T\"");
                  }
                }
                if (result13 !== null) {
                  var result6 = result13;
                } else {
                  if (input.substr(pos, 1) === "t") {
                    var result12 = "t";
                    pos += 1;
                  } else {
                    var result12 = null;
                    if (reportMatchFailures) {
                      matchFailed("\"t\"");
                    }
                  }
                  if (result12 !== null) {
                    var result6 = result12;
                  } else {
                    var result6 = null;;
                  };
                }
                if (result6 !== null) {
                  var result7 = [];
                  var result11 = parse_WS();
                  while (result11 !== null) {
                    result7.push(result11);
                    var result11 = parse_WS();
                  }
                  if (result7 !== null) {
                    var result8 = parse_INTEGER();
                    if (result8 !== null) {
                      var result9 = [];
                      var result10 = parse_WS();
                      while (result10 !== null) {
                        result9.push(result10);
                        var result10 = parse_WS();
                      }
                      if (result9 !== null) {
                        var result1 = [result2, result3, result4, result5, result6, result7, result8, result9];
                      } else {
                        var result1 = null;
                        pos = savedPos0;
                      }
                    } else {
                      var result1 = null;
                      pos = savedPos0;
                    }
                  } else {
                    var result1 = null;
                    pos = savedPos0;
                  }
                } else {
                  var result1 = null;
                  pos = savedPos0;
                }
              } else {
                var result1 = null;
                pos = savedPos0;
              }
            } else {
              var result1 = null;
              pos = savedPos0;
            }
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        var result0 = result1 !== null
          ? (function(i) {
            return { limit:parseInt(i.value) };
          })(result1[6])
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[25] LimitClause");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_OffsetClause() {
        var cacheKey = 'OffsetClause@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        if (input.substr(pos, 1) === "O") {
          var result24 = "O";
          pos += 1;
        } else {
          var result24 = null;
          if (reportMatchFailures) {
            matchFailed("\"O\"");
          }
        }
        if (result24 !== null) {
          var result2 = result24;
        } else {
          if (input.substr(pos, 1) === "o") {
            var result23 = "o";
            pos += 1;
          } else {
            var result23 = null;
            if (reportMatchFailures) {
              matchFailed("\"o\"");
            }
          }
          if (result23 !== null) {
            var result2 = result23;
          } else {
            var result2 = null;;
          };
        }
        if (result2 !== null) {
          if (input.substr(pos, 1) === "F") {
            var result22 = "F";
            pos += 1;
          } else {
            var result22 = null;
            if (reportMatchFailures) {
              matchFailed("\"F\"");
            }
          }
          if (result22 !== null) {
            var result3 = result22;
          } else {
            if (input.substr(pos, 1) === "f") {
              var result21 = "f";
              pos += 1;
            } else {
              var result21 = null;
              if (reportMatchFailures) {
                matchFailed("\"f\"");
              }
            }
            if (result21 !== null) {
              var result3 = result21;
            } else {
              var result3 = null;;
            };
          }
          if (result3 !== null) {
            if (input.substr(pos, 1) === "F") {
              var result20 = "F";
              pos += 1;
            } else {
              var result20 = null;
              if (reportMatchFailures) {
                matchFailed("\"F\"");
              }
            }
            if (result20 !== null) {
              var result4 = result20;
            } else {
              if (input.substr(pos, 1) === "f") {
                var result19 = "f";
                pos += 1;
              } else {
                var result19 = null;
                if (reportMatchFailures) {
                  matchFailed("\"f\"");
                }
              }
              if (result19 !== null) {
                var result4 = result19;
              } else {
                var result4 = null;;
              };
            }
            if (result4 !== null) {
              if (input.substr(pos, 1) === "S") {
                var result18 = "S";
                pos += 1;
              } else {
                var result18 = null;
                if (reportMatchFailures) {
                  matchFailed("\"S\"");
                }
              }
              if (result18 !== null) {
                var result5 = result18;
              } else {
                if (input.substr(pos, 1) === "s") {
                  var result17 = "s";
                  pos += 1;
                } else {
                  var result17 = null;
                  if (reportMatchFailures) {
                    matchFailed("\"s\"");
                  }
                }
                if (result17 !== null) {
                  var result5 = result17;
                } else {
                  var result5 = null;;
                };
              }
              if (result5 !== null) {
                if (input.substr(pos, 1) === "E") {
                  var result16 = "E";
                  pos += 1;
                } else {
                  var result16 = null;
                  if (reportMatchFailures) {
                    matchFailed("\"E\"");
                  }
                }
                if (result16 !== null) {
                  var result6 = result16;
                } else {
                  if (input.substr(pos, 1) === "e") {
                    var result15 = "e";
                    pos += 1;
                  } else {
                    var result15 = null;
                    if (reportMatchFailures) {
                      matchFailed("\"e\"");
                    }
                  }
                  if (result15 !== null) {
                    var result6 = result15;
                  } else {
                    var result6 = null;;
                  };
                }
                if (result6 !== null) {
                  if (input.substr(pos, 1) === "T") {
                    var result14 = "T";
                    pos += 1;
                  } else {
                    var result14 = null;
                    if (reportMatchFailures) {
                      matchFailed("\"T\"");
                    }
                  }
                  if (result14 !== null) {
                    var result7 = result14;
                  } else {
                    if (input.substr(pos, 1) === "t") {
                      var result13 = "t";
                      pos += 1;
                    } else {
                      var result13 = null;
                      if (reportMatchFailures) {
                        matchFailed("\"t\"");
                      }
                    }
                    if (result13 !== null) {
                      var result7 = result13;
                    } else {
                      var result7 = null;;
                    };
                  }
                  if (result7 !== null) {
                    var result8 = [];
                    var result12 = parse_WS();
                    while (result12 !== null) {
                      result8.push(result12);
                      var result12 = parse_WS();
                    }
                    if (result8 !== null) {
                      var result9 = parse_INTEGER();
                      if (result9 !== null) {
                        var result10 = [];
                        var result11 = parse_WS();
                        while (result11 !== null) {
                          result10.push(result11);
                          var result11 = parse_WS();
                        }
                        if (result10 !== null) {
                          var result1 = [result2, result3, result4, result5, result6, result7, result8, result9, result10];
                        } else {
                          var result1 = null;
                          pos = savedPos0;
                        }
                      } else {
                        var result1 = null;
                        pos = savedPos0;
                      }
                    } else {
                      var result1 = null;
                      pos = savedPos0;
                    }
                  } else {
                    var result1 = null;
                    pos = savedPos0;
                  }
                } else {
                  var result1 = null;
                  pos = savedPos0;
                }
              } else {
                var result1 = null;
                pos = savedPos0;
              }
            } else {
              var result1 = null;
              pos = savedPos0;
            }
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        var result0 = result1 !== null
          ? (function(i) {
            return { offset:parseInt(i.value) };
          })(result1[7])
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[26] OffsetClause");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_BindingsClause() {
        var cacheKey = 'BindingsClause@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        if (input.substr(pos, 8) === "BINDINGS") {
          var result2 = "BINDINGS";
          pos += 8;
        } else {
          var result2 = null;
          if (reportMatchFailures) {
            matchFailed("\"BINDINGS\"");
          }
        }
        if (result2 !== null) {
          var result3 = [];
          var result14 = parse_Var();
          while (result14 !== null) {
            result3.push(result14);
            var result14 = parse_Var();
          }
          if (result3 !== null) {
            if (input.substr(pos, 1) === "{") {
              var result4 = "{";
              pos += 1;
            } else {
              var result4 = null;
              if (reportMatchFailures) {
                matchFailed("\"{\"");
              }
            }
            if (result4 !== null) {
              var result5 = [];
              var savedPos1 = pos;
              if (input.substr(pos, 1) === "(") {
                var result10 = "(";
                pos += 1;
              } else {
                var result10 = null;
                if (reportMatchFailures) {
                  matchFailed("\"(\"");
                }
              }
              if (result10 !== null) {
                var result13 = parse_BindingValue();
                if (result13 !== null) {
                  var result11 = [];
                  while (result13 !== null) {
                    result11.push(result13);
                    var result13 = parse_BindingValue();
                  }
                } else {
                  var result11 = null;
                }
                if (result11 !== null) {
                  if (input.substr(pos, 1) === ")") {
                    var result12 = ")";
                    pos += 1;
                  } else {
                    var result12 = null;
                    if (reportMatchFailures) {
                      matchFailed("\")\"");
                    }
                  }
                  if (result12 !== null) {
                    var result9 = [result10, result11, result12];
                  } else {
                    var result9 = null;
                    pos = savedPos1;
                  }
                } else {
                  var result9 = null;
                  pos = savedPos1;
                }
              } else {
                var result9 = null;
                pos = savedPos1;
              }
              if (result9 !== null) {
                var result7 = result9;
              } else {
                var result8 = parse_NIL();
                if (result8 !== null) {
                  var result7 = result8;
                } else {
                  var result7 = null;;
                };
              }
              while (result7 !== null) {
                result5.push(result7);
                var savedPos1 = pos;
                if (input.substr(pos, 1) === "(") {
                  var result10 = "(";
                  pos += 1;
                } else {
                  var result10 = null;
                  if (reportMatchFailures) {
                    matchFailed("\"(\"");
                  }
                }
                if (result10 !== null) {
                  var result13 = parse_BindingValue();
                  if (result13 !== null) {
                    var result11 = [];
                    while (result13 !== null) {
                      result11.push(result13);
                      var result13 = parse_BindingValue();
                    }
                  } else {
                    var result11 = null;
                  }
                  if (result11 !== null) {
                    if (input.substr(pos, 1) === ")") {
                      var result12 = ")";
                      pos += 1;
                    } else {
                      var result12 = null;
                      if (reportMatchFailures) {
                        matchFailed("\")\"");
                      }
                    }
                    if (result12 !== null) {
                      var result9 = [result10, result11, result12];
                    } else {
                      var result9 = null;
                      pos = savedPos1;
                    }
                  } else {
                    var result9 = null;
                    pos = savedPos1;
                  }
                } else {
                  var result9 = null;
                  pos = savedPos1;
                }
                if (result9 !== null) {
                  var result7 = result9;
                } else {
                  var result8 = parse_NIL();
                  if (result8 !== null) {
                    var result7 = result8;
                  } else {
                    var result7 = null;;
                  };
                }
              }
              if (result5 !== null) {
                if (input.substr(pos, 1) === "}") {
                  var result6 = "}";
                  pos += 1;
                } else {
                  var result6 = null;
                  if (reportMatchFailures) {
                    matchFailed("\"}\"");
                  }
                }
                if (result6 !== null) {
                  var result1 = [result2, result3, result4, result5, result6];
                } else {
                  var result1 = null;
                  pos = savedPos0;
                }
              } else {
                var result1 = null;
                pos = savedPos0;
              }
            } else {
              var result1 = null;
              pos = savedPos0;
            }
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        var result0 = result1 !== null ? result1 : '';
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[27] BindingsClause");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_BindingValue() {
        var cacheKey = 'BindingValue@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var result5 = parse_IRIref();
        if (result5 !== null) {
          var result0 = result5;
        } else {
          var result4 = parse_RDFLiteral();
          if (result4 !== null) {
            var result0 = result4;
          } else {
            var result3 = parse_NumericLiteral();
            if (result3 !== null) {
              var result0 = result3;
            } else {
              var result2 = parse_BooleanLiteral();
              if (result2 !== null) {
                var result0 = result2;
              } else {
                if (input.substr(pos, 5) === "UNDEF") {
                  var result1 = "UNDEF";
                  pos += 5;
                } else {
                  var result1 = null;
                  if (reportMatchFailures) {
                    matchFailed("\"UNDEF\"");
                  }
                }
                if (result1 !== null) {
                  var result0 = result1;
                } else {
                  var result0 = null;;
                };
              };
            };
          };
        }
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[28] BindingValue");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_Update() {
        var cacheKey = 'Update@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        var result2 = parse_Prologue();
        if (result2 !== null) {
          var result3 = [];
          var result14 = parse_WS();
          while (result14 !== null) {
            result3.push(result14);
            var result14 = parse_WS();
          }
          if (result3 !== null) {
            var result4 = parse_Update1();
            if (result4 !== null) {
              var savedPos1 = pos;
              var result7 = [];
              var result13 = parse_WS();
              while (result13 !== null) {
                result7.push(result13);
                var result13 = parse_WS();
              }
              if (result7 !== null) {
                if (input.substr(pos, 1) === ";") {
                  var result8 = ";";
                  pos += 1;
                } else {
                  var result8 = null;
                  if (reportMatchFailures) {
                    matchFailed("\";\"");
                  }
                }
                if (result8 !== null) {
                  var result9 = [];
                  var result12 = parse_WS();
                  while (result12 !== null) {
                    result9.push(result12);
                    var result12 = parse_WS();
                  }
                  if (result9 !== null) {
                    var result11 = parse_Update();
                    var result10 = result11 !== null ? result11 : '';
                    if (result10 !== null) {
                      var result6 = [result7, result8, result9, result10];
                    } else {
                      var result6 = null;
                      pos = savedPos1;
                    }
                  } else {
                    var result6 = null;
                    pos = savedPos1;
                  }
                } else {
                  var result6 = null;
                  pos = savedPos1;
                }
              } else {
                var result6 = null;
                pos = savedPos1;
              }
              var result5 = result6 !== null ? result6 : '';
              if (result5 !== null) {
                var result1 = [result2, result3, result4, result5];
              } else {
                var result1 = null;
                pos = savedPos0;
              }
            } else {
              var result1 = null;
              pos = savedPos0;
            }
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        var result0 = result1 !== null
          ? (function(p, u, us) {
          
                var query = {};
                query.token = 'query';
                query.kind = 'update'
                query.prologue = p;
          
               var units = [u];
          
               if(us.length != null && us[3] != null && us[3].units != null) {
                   units = units.concat(us[3].units);
               }
          
               query.units = units;
               return query;
          })(result1[0], result1[2], result1[3])
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[30] Update");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_Update1() {
        var cacheKey = 'Update1@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var result8 = parse_Load();
        if (result8 !== null) {
          var result0 = result8;
        } else {
          var result7 = parse_Clear();
          if (result7 !== null) {
            var result0 = result7;
          } else {
            var result6 = parse_Drop();
            if (result6 !== null) {
              var result0 = result6;
            } else {
              var result5 = parse_Create();
              if (result5 !== null) {
                var result0 = result5;
              } else {
                var result4 = parse_InsertData();
                if (result4 !== null) {
                  var result0 = result4;
                } else {
                  var result3 = parse_DeleteData();
                  if (result3 !== null) {
                    var result0 = result3;
                  } else {
                    var result2 = parse_DeleteWhere();
                    if (result2 !== null) {
                      var result0 = result2;
                    } else {
                      var result1 = parse_Modify();
                      if (result1 !== null) {
                        var result0 = result1;
                      } else {
                        var result0 = null;;
                      };
                    };
                  };
                };
              };
            };
          };
        }
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[31] Update1");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_Load() {
        var cacheKey = 'Load@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        if (input.substr(pos, 1) === "L") {
          var result35 = "L";
          pos += 1;
        } else {
          var result35 = null;
          if (reportMatchFailures) {
            matchFailed("\"L\"");
          }
        }
        if (result35 !== null) {
          var result2 = result35;
        } else {
          if (input.substr(pos, 1) === "l") {
            var result34 = "l";
            pos += 1;
          } else {
            var result34 = null;
            if (reportMatchFailures) {
              matchFailed("\"l\"");
            }
          }
          if (result34 !== null) {
            var result2 = result34;
          } else {
            var result2 = null;;
          };
        }
        if (result2 !== null) {
          if (input.substr(pos, 1) === "O") {
            var result33 = "O";
            pos += 1;
          } else {
            var result33 = null;
            if (reportMatchFailures) {
              matchFailed("\"O\"");
            }
          }
          if (result33 !== null) {
            var result3 = result33;
          } else {
            if (input.substr(pos, 1) === "o") {
              var result32 = "o";
              pos += 1;
            } else {
              var result32 = null;
              if (reportMatchFailures) {
                matchFailed("\"o\"");
              }
            }
            if (result32 !== null) {
              var result3 = result32;
            } else {
              var result3 = null;;
            };
          }
          if (result3 !== null) {
            if (input.substr(pos, 1) === "A") {
              var result31 = "A";
              pos += 1;
            } else {
              var result31 = null;
              if (reportMatchFailures) {
                matchFailed("\"A\"");
              }
            }
            if (result31 !== null) {
              var result4 = result31;
            } else {
              if (input.substr(pos, 1) === "a") {
                var result30 = "a";
                pos += 1;
              } else {
                var result30 = null;
                if (reportMatchFailures) {
                  matchFailed("\"a\"");
                }
              }
              if (result30 !== null) {
                var result4 = result30;
              } else {
                var result4 = null;;
              };
            }
            if (result4 !== null) {
              if (input.substr(pos, 1) === "D") {
                var result29 = "D";
                pos += 1;
              } else {
                var result29 = null;
                if (reportMatchFailures) {
                  matchFailed("\"D\"");
                }
              }
              if (result29 !== null) {
                var result5 = result29;
              } else {
                if (input.substr(pos, 1) === "d") {
                  var result28 = "d";
                  pos += 1;
                } else {
                  var result28 = null;
                  if (reportMatchFailures) {
                    matchFailed("\"d\"");
                  }
                }
                if (result28 !== null) {
                  var result5 = result28;
                } else {
                  var result5 = null;;
                };
              }
              if (result5 !== null) {
                var result6 = [];
                var result27 = parse_WS();
                while (result27 !== null) {
                  result6.push(result27);
                  var result27 = parse_WS();
                }
                if (result6 !== null) {
                  var result7 = parse_IRIref();
                  if (result7 !== null) {
                    var result8 = [];
                    var result26 = parse_WS();
                    while (result26 !== null) {
                      result8.push(result26);
                      var result26 = parse_WS();
                    }
                    if (result8 !== null) {
                      var savedPos1 = pos;
                      if (input.substr(pos, 1) === "I") {
                        var result25 = "I";
                        pos += 1;
                      } else {
                        var result25 = null;
                        if (reportMatchFailures) {
                          matchFailed("\"I\"");
                        }
                      }
                      if (result25 !== null) {
                        var result11 = result25;
                      } else {
                        if (input.substr(pos, 1) === "i") {
                          var result24 = "i";
                          pos += 1;
                        } else {
                          var result24 = null;
                          if (reportMatchFailures) {
                            matchFailed("\"i\"");
                          }
                        }
                        if (result24 !== null) {
                          var result11 = result24;
                        } else {
                          var result11 = null;;
                        };
                      }
                      if (result11 !== null) {
                        if (input.substr(pos, 1) === "N") {
                          var result23 = "N";
                          pos += 1;
                        } else {
                          var result23 = null;
                          if (reportMatchFailures) {
                            matchFailed("\"N\"");
                          }
                        }
                        if (result23 !== null) {
                          var result12 = result23;
                        } else {
                          if (input.substr(pos, 1) === "n") {
                            var result22 = "n";
                            pos += 1;
                          } else {
                            var result22 = null;
                            if (reportMatchFailures) {
                              matchFailed("\"n\"");
                            }
                          }
                          if (result22 !== null) {
                            var result12 = result22;
                          } else {
                            var result12 = null;;
                          };
                        }
                        if (result12 !== null) {
                          if (input.substr(pos, 1) === "T") {
                            var result21 = "T";
                            pos += 1;
                          } else {
                            var result21 = null;
                            if (reportMatchFailures) {
                              matchFailed("\"T\"");
                            }
                          }
                          if (result21 !== null) {
                            var result13 = result21;
                          } else {
                            if (input.substr(pos, 1) === "t") {
                              var result20 = "t";
                              pos += 1;
                            } else {
                              var result20 = null;
                              if (reportMatchFailures) {
                                matchFailed("\"t\"");
                              }
                            }
                            if (result20 !== null) {
                              var result13 = result20;
                            } else {
                              var result13 = null;;
                            };
                          }
                          if (result13 !== null) {
                            if (input.substr(pos, 1) === "O") {
                              var result19 = "O";
                              pos += 1;
                            } else {
                              var result19 = null;
                              if (reportMatchFailures) {
                                matchFailed("\"O\"");
                              }
                            }
                            if (result19 !== null) {
                              var result14 = result19;
                            } else {
                              if (input.substr(pos, 1) === "o") {
                                var result18 = "o";
                                pos += 1;
                              } else {
                                var result18 = null;
                                if (reportMatchFailures) {
                                  matchFailed("\"o\"");
                                }
                              }
                              if (result18 !== null) {
                                var result14 = result18;
                              } else {
                                var result14 = null;;
                              };
                            }
                            if (result14 !== null) {
                              var result15 = [];
                              var result17 = parse_WS();
                              while (result17 !== null) {
                                result15.push(result17);
                                var result17 = parse_WS();
                              }
                              if (result15 !== null) {
                                var result16 = parse_GraphRef();
                                if (result16 !== null) {
                                  var result10 = [result11, result12, result13, result14, result15, result16];
                                } else {
                                  var result10 = null;
                                  pos = savedPos1;
                                }
                              } else {
                                var result10 = null;
                                pos = savedPos1;
                              }
                            } else {
                              var result10 = null;
                              pos = savedPos1;
                            }
                          } else {
                            var result10 = null;
                            pos = savedPos1;
                          }
                        } else {
                          var result10 = null;
                          pos = savedPos1;
                        }
                      } else {
                        var result10 = null;
                        pos = savedPos1;
                      }
                      var result9 = result10 !== null ? result10 : '';
                      if (result9 !== null) {
                        var result1 = [result2, result3, result4, result5, result6, result7, result8, result9];
                      } else {
                        var result1 = null;
                        pos = savedPos0;
                      }
                    } else {
                      var result1 = null;
                      pos = savedPos0;
                    }
                  } else {
                    var result1 = null;
                    pos = savedPos0;
                  }
                } else {
                  var result1 = null;
                  pos = savedPos0;
                }
              } else {
                var result1 = null;
                pos = savedPos0;
              }
            } else {
              var result1 = null;
              pos = savedPos0;
            }
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        var result0 = result1 !== null
          ? (function(sg, dg) {
                var query = {};
                query.kind = 'load';
                query.token = 'executableunit'
                query.sourceGraph = sg;
                query.destinyGraph = dg[5];
                
                return query;
          })(result1[5], result1[7])
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[32] Load");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_Clear() {
        var cacheKey = 'Clear@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        if (input.substr(pos, 1) === "C") {
          var result41 = "C";
          pos += 1;
        } else {
          var result41 = null;
          if (reportMatchFailures) {
            matchFailed("\"C\"");
          }
        }
        if (result41 !== null) {
          var result2 = result41;
        } else {
          if (input.substr(pos, 1) === "c") {
            var result40 = "c";
            pos += 1;
          } else {
            var result40 = null;
            if (reportMatchFailures) {
              matchFailed("\"c\"");
            }
          }
          if (result40 !== null) {
            var result2 = result40;
          } else {
            var result2 = null;;
          };
        }
        if (result2 !== null) {
          if (input.substr(pos, 1) === "L") {
            var result39 = "L";
            pos += 1;
          } else {
            var result39 = null;
            if (reportMatchFailures) {
              matchFailed("\"L\"");
            }
          }
          if (result39 !== null) {
            var result3 = result39;
          } else {
            if (input.substr(pos, 1) === "l") {
              var result38 = "l";
              pos += 1;
            } else {
              var result38 = null;
              if (reportMatchFailures) {
                matchFailed("\"l\"");
              }
            }
            if (result38 !== null) {
              var result3 = result38;
            } else {
              var result3 = null;;
            };
          }
          if (result3 !== null) {
            if (input.substr(pos, 1) === "E") {
              var result37 = "E";
              pos += 1;
            } else {
              var result37 = null;
              if (reportMatchFailures) {
                matchFailed("\"E\"");
              }
            }
            if (result37 !== null) {
              var result4 = result37;
            } else {
              if (input.substr(pos, 1) === "e") {
                var result36 = "e";
                pos += 1;
              } else {
                var result36 = null;
                if (reportMatchFailures) {
                  matchFailed("\"e\"");
                }
              }
              if (result36 !== null) {
                var result4 = result36;
              } else {
                var result4 = null;;
              };
            }
            if (result4 !== null) {
              if (input.substr(pos, 1) === "A") {
                var result35 = "A";
                pos += 1;
              } else {
                var result35 = null;
                if (reportMatchFailures) {
                  matchFailed("\"A\"");
                }
              }
              if (result35 !== null) {
                var result5 = result35;
              } else {
                if (input.substr(pos, 1) === "a") {
                  var result34 = "a";
                  pos += 1;
                } else {
                  var result34 = null;
                  if (reportMatchFailures) {
                    matchFailed("\"a\"");
                  }
                }
                if (result34 !== null) {
                  var result5 = result34;
                } else {
                  var result5 = null;;
                };
              }
              if (result5 !== null) {
                if (input.substr(pos, 1) === "R") {
                  var result33 = "R";
                  pos += 1;
                } else {
                  var result33 = null;
                  if (reportMatchFailures) {
                    matchFailed("\"R\"");
                  }
                }
                if (result33 !== null) {
                  var result6 = result33;
                } else {
                  if (input.substr(pos, 1) === "r") {
                    var result32 = "r";
                    pos += 1;
                  } else {
                    var result32 = null;
                    if (reportMatchFailures) {
                      matchFailed("\"r\"");
                    }
                  }
                  if (result32 !== null) {
                    var result6 = result32;
                  } else {
                    var result6 = null;;
                  };
                }
                if (result6 !== null) {
                  var result7 = [];
                  var result31 = parse_WS();
                  while (result31 !== null) {
                    result7.push(result31);
                    var result31 = parse_WS();
                  }
                  if (result7 !== null) {
                    var savedPos1 = pos;
                    if (input.substr(pos, 1) === "S") {
                      var result30 = "S";
                      pos += 1;
                    } else {
                      var result30 = null;
                      if (reportMatchFailures) {
                        matchFailed("\"S\"");
                      }
                    }
                    if (result30 !== null) {
                      var result13 = result30;
                    } else {
                      if (input.substr(pos, 1) === "s") {
                        var result29 = "s";
                        pos += 1;
                      } else {
                        var result29 = null;
                        if (reportMatchFailures) {
                          matchFailed("\"s\"");
                        }
                      }
                      if (result29 !== null) {
                        var result13 = result29;
                      } else {
                        var result13 = null;;
                      };
                    }
                    if (result13 !== null) {
                      if (input.substr(pos, 1) === "I") {
                        var result28 = "I";
                        pos += 1;
                      } else {
                        var result28 = null;
                        if (reportMatchFailures) {
                          matchFailed("\"I\"");
                        }
                      }
                      if (result28 !== null) {
                        var result14 = result28;
                      } else {
                        if (input.substr(pos, 1) === "i") {
                          var result27 = "i";
                          pos += 1;
                        } else {
                          var result27 = null;
                          if (reportMatchFailures) {
                            matchFailed("\"i\"");
                          }
                        }
                        if (result27 !== null) {
                          var result14 = result27;
                        } else {
                          var result14 = null;;
                        };
                      }
                      if (result14 !== null) {
                        if (input.substr(pos, 1) === "L") {
                          var result26 = "L";
                          pos += 1;
                        } else {
                          var result26 = null;
                          if (reportMatchFailures) {
                            matchFailed("\"L\"");
                          }
                        }
                        if (result26 !== null) {
                          var result15 = result26;
                        } else {
                          if (input.substr(pos, 1) === "l") {
                            var result25 = "l";
                            pos += 1;
                          } else {
                            var result25 = null;
                            if (reportMatchFailures) {
                              matchFailed("\"l\"");
                            }
                          }
                          if (result25 !== null) {
                            var result15 = result25;
                          } else {
                            var result15 = null;;
                          };
                        }
                        if (result15 !== null) {
                          if (input.substr(pos, 1) === "E") {
                            var result24 = "E";
                            pos += 1;
                          } else {
                            var result24 = null;
                            if (reportMatchFailures) {
                              matchFailed("\"E\"");
                            }
                          }
                          if (result24 !== null) {
                            var result16 = result24;
                          } else {
                            if (input.substr(pos, 1) === "e") {
                              var result23 = "e";
                              pos += 1;
                            } else {
                              var result23 = null;
                              if (reportMatchFailures) {
                                matchFailed("\"e\"");
                              }
                            }
                            if (result23 !== null) {
                              var result16 = result23;
                            } else {
                              var result16 = null;;
                            };
                          }
                          if (result16 !== null) {
                            if (input.substr(pos, 1) === "N") {
                              var result22 = "N";
                              pos += 1;
                            } else {
                              var result22 = null;
                              if (reportMatchFailures) {
                                matchFailed("\"N\"");
                              }
                            }
                            if (result22 !== null) {
                              var result17 = result22;
                            } else {
                              if (input.substr(pos, 1) === "n") {
                                var result21 = "n";
                                pos += 1;
                              } else {
                                var result21 = null;
                                if (reportMatchFailures) {
                                  matchFailed("\"n\"");
                                }
                              }
                              if (result21 !== null) {
                                var result17 = result21;
                              } else {
                                var result17 = null;;
                              };
                            }
                            if (result17 !== null) {
                              if (input.substr(pos, 1) === "T") {
                                var result20 = "T";
                                pos += 1;
                              } else {
                                var result20 = null;
                                if (reportMatchFailures) {
                                  matchFailed("\"T\"");
                                }
                              }
                              if (result20 !== null) {
                                var result18 = result20;
                              } else {
                                if (input.substr(pos, 1) === "t") {
                                  var result19 = "t";
                                  pos += 1;
                                } else {
                                  var result19 = null;
                                  if (reportMatchFailures) {
                                    matchFailed("\"t\"");
                                  }
                                }
                                if (result19 !== null) {
                                  var result18 = result19;
                                } else {
                                  var result18 = null;;
                                };
                              }
                              if (result18 !== null) {
                                var result12 = [result13, result14, result15, result16, result17, result18];
                              } else {
                                var result12 = null;
                                pos = savedPos1;
                              }
                            } else {
                              var result12 = null;
                              pos = savedPos1;
                            }
                          } else {
                            var result12 = null;
                            pos = savedPos1;
                          }
                        } else {
                          var result12 = null;
                          pos = savedPos1;
                        }
                      } else {
                        var result12 = null;
                        pos = savedPos1;
                      }
                    } else {
                      var result12 = null;
                      pos = savedPos1;
                    }
                    var result8 = result12 !== null ? result12 : '';
                    if (result8 !== null) {
                      var result9 = [];
                      var result11 = parse_WS();
                      while (result11 !== null) {
                        result9.push(result11);
                        var result11 = parse_WS();
                      }
                      if (result9 !== null) {
                        var result10 = parse_GraphRefAll();
                        if (result10 !== null) {
                          var result1 = [result2, result3, result4, result5, result6, result7, result8, result9, result10];
                        } else {
                          var result1 = null;
                          pos = savedPos0;
                        }
                      } else {
                        var result1 = null;
                        pos = savedPos0;
                      }
                    } else {
                      var result1 = null;
                      pos = savedPos0;
                    }
                  } else {
                    var result1 = null;
                    pos = savedPos0;
                  }
                } else {
                  var result1 = null;
                  pos = savedPos0;
                }
              } else {
                var result1 = null;
                pos = savedPos0;
              }
            } else {
              var result1 = null;
              pos = savedPos0;
            }
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        var result0 = result1 !== null
          ? (function(ref) {
                var query = {};
                query.kind = 'clear';
                query.token = 'executableunit'
                query.destinyGraph = ref;
                
                return query;
          })(result1[8])
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[33] Clear");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_Drop() {
        var cacheKey = 'Drop@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        if (input.substr(pos, 1) === "D") {
          var result38 = "D";
          pos += 1;
        } else {
          var result38 = null;
          if (reportMatchFailures) {
            matchFailed("\"D\"");
          }
        }
        if (result38 !== null) {
          var result2 = result38;
        } else {
          if (input.substr(pos, 1) === "d") {
            var result37 = "d";
            pos += 1;
          } else {
            var result37 = null;
            if (reportMatchFailures) {
              matchFailed("\"d\"");
            }
          }
          if (result37 !== null) {
            var result2 = result37;
          } else {
            var result2 = null;;
          };
        }
        if (result2 !== null) {
          if (input.substr(pos, 1) === "R") {
            var result36 = "R";
            pos += 1;
          } else {
            var result36 = null;
            if (reportMatchFailures) {
              matchFailed("\"R\"");
            }
          }
          if (result36 !== null) {
            var result3 = result36;
          } else {
            if (input.substr(pos, 1) === "r") {
              var result35 = "r";
              pos += 1;
            } else {
              var result35 = null;
              if (reportMatchFailures) {
                matchFailed("\"r\"");
              }
            }
            if (result35 !== null) {
              var result3 = result35;
            } else {
              var result3 = null;;
            };
          }
          if (result3 !== null) {
            if (input.substr(pos, 1) === "O") {
              var result34 = "O";
              pos += 1;
            } else {
              var result34 = null;
              if (reportMatchFailures) {
                matchFailed("\"O\"");
              }
            }
            if (result34 !== null) {
              var result4 = result34;
            } else {
              if (input.substr(pos, 1) === "o") {
                var result33 = "o";
                pos += 1;
              } else {
                var result33 = null;
                if (reportMatchFailures) {
                  matchFailed("\"o\"");
                }
              }
              if (result33 !== null) {
                var result4 = result33;
              } else {
                var result4 = null;;
              };
            }
            if (result4 !== null) {
              if (input.substr(pos, 1) === "P") {
                var result32 = "P";
                pos += 1;
              } else {
                var result32 = null;
                if (reportMatchFailures) {
                  matchFailed("\"P\"");
                }
              }
              if (result32 !== null) {
                var result5 = result32;
              } else {
                if (input.substr(pos, 1) === "p") {
                  var result31 = "p";
                  pos += 1;
                } else {
                  var result31 = null;
                  if (reportMatchFailures) {
                    matchFailed("\"p\"");
                  }
                }
                if (result31 !== null) {
                  var result5 = result31;
                } else {
                  var result5 = null;;
                };
              }
              if (result5 !== null) {
                var result6 = [];
                var result30 = parse_WS();
                while (result30 !== null) {
                  result6.push(result30);
                  var result30 = parse_WS();
                }
                if (result6 !== null) {
                  var savedPos1 = pos;
                  if (input.substr(pos, 1) === "S") {
                    var result29 = "S";
                    pos += 1;
                  } else {
                    var result29 = null;
                    if (reportMatchFailures) {
                      matchFailed("\"S\"");
                    }
                  }
                  if (result29 !== null) {
                    var result12 = result29;
                  } else {
                    if (input.substr(pos, 1) === "s") {
                      var result28 = "s";
                      pos += 1;
                    } else {
                      var result28 = null;
                      if (reportMatchFailures) {
                        matchFailed("\"s\"");
                      }
                    }
                    if (result28 !== null) {
                      var result12 = result28;
                    } else {
                      var result12 = null;;
                    };
                  }
                  if (result12 !== null) {
                    if (input.substr(pos, 1) === "I") {
                      var result27 = "I";
                      pos += 1;
                    } else {
                      var result27 = null;
                      if (reportMatchFailures) {
                        matchFailed("\"I\"");
                      }
                    }
                    if (result27 !== null) {
                      var result13 = result27;
                    } else {
                      if (input.substr(pos, 1) === "i") {
                        var result26 = "i";
                        pos += 1;
                      } else {
                        var result26 = null;
                        if (reportMatchFailures) {
                          matchFailed("\"i\"");
                        }
                      }
                      if (result26 !== null) {
                        var result13 = result26;
                      } else {
                        var result13 = null;;
                      };
                    }
                    if (result13 !== null) {
                      if (input.substr(pos, 1) === "L") {
                        var result25 = "L";
                        pos += 1;
                      } else {
                        var result25 = null;
                        if (reportMatchFailures) {
                          matchFailed("\"L\"");
                        }
                      }
                      if (result25 !== null) {
                        var result14 = result25;
                      } else {
                        if (input.substr(pos, 1) === "l") {
                          var result24 = "l";
                          pos += 1;
                        } else {
                          var result24 = null;
                          if (reportMatchFailures) {
                            matchFailed("\"l\"");
                          }
                        }
                        if (result24 !== null) {
                          var result14 = result24;
                        } else {
                          var result14 = null;;
                        };
                      }
                      if (result14 !== null) {
                        if (input.substr(pos, 1) === "E") {
                          var result23 = "E";
                          pos += 1;
                        } else {
                          var result23 = null;
                          if (reportMatchFailures) {
                            matchFailed("\"E\"");
                          }
                        }
                        if (result23 !== null) {
                          var result15 = result23;
                        } else {
                          if (input.substr(pos, 1) === "e") {
                            var result22 = "e";
                            pos += 1;
                          } else {
                            var result22 = null;
                            if (reportMatchFailures) {
                              matchFailed("\"e\"");
                            }
                          }
                          if (result22 !== null) {
                            var result15 = result22;
                          } else {
                            var result15 = null;;
                          };
                        }
                        if (result15 !== null) {
                          if (input.substr(pos, 1) === "N") {
                            var result21 = "N";
                            pos += 1;
                          } else {
                            var result21 = null;
                            if (reportMatchFailures) {
                              matchFailed("\"N\"");
                            }
                          }
                          if (result21 !== null) {
                            var result16 = result21;
                          } else {
                            if (input.substr(pos, 1) === "n") {
                              var result20 = "n";
                              pos += 1;
                            } else {
                              var result20 = null;
                              if (reportMatchFailures) {
                                matchFailed("\"n\"");
                              }
                            }
                            if (result20 !== null) {
                              var result16 = result20;
                            } else {
                              var result16 = null;;
                            };
                          }
                          if (result16 !== null) {
                            if (input.substr(pos, 1) === "T") {
                              var result19 = "T";
                              pos += 1;
                            } else {
                              var result19 = null;
                              if (reportMatchFailures) {
                                matchFailed("\"T\"");
                              }
                            }
                            if (result19 !== null) {
                              var result17 = result19;
                            } else {
                              if (input.substr(pos, 1) === "t") {
                                var result18 = "t";
                                pos += 1;
                              } else {
                                var result18 = null;
                                if (reportMatchFailures) {
                                  matchFailed("\"t\"");
                                }
                              }
                              if (result18 !== null) {
                                var result17 = result18;
                              } else {
                                var result17 = null;;
                              };
                            }
                            if (result17 !== null) {
                              var result11 = [result12, result13, result14, result15, result16, result17];
                            } else {
                              var result11 = null;
                              pos = savedPos1;
                            }
                          } else {
                            var result11 = null;
                            pos = savedPos1;
                          }
                        } else {
                          var result11 = null;
                          pos = savedPos1;
                        }
                      } else {
                        var result11 = null;
                        pos = savedPos1;
                      }
                    } else {
                      var result11 = null;
                      pos = savedPos1;
                    }
                  } else {
                    var result11 = null;
                    pos = savedPos1;
                  }
                  var result7 = result11 !== null ? result11 : '';
                  if (result7 !== null) {
                    var result8 = [];
                    var result10 = parse_WS();
                    while (result10 !== null) {
                      result8.push(result10);
                      var result10 = parse_WS();
                    }
                    if (result8 !== null) {
                      var result9 = parse_GraphRefAll();
                      if (result9 !== null) {
                        var result1 = [result2, result3, result4, result5, result6, result7, result8, result9];
                      } else {
                        var result1 = null;
                        pos = savedPos0;
                      }
                    } else {
                      var result1 = null;
                      pos = savedPos0;
                    }
                  } else {
                    var result1 = null;
                    pos = savedPos0;
                  }
                } else {
                  var result1 = null;
                  pos = savedPos0;
                }
              } else {
                var result1 = null;
                pos = savedPos0;
              }
            } else {
              var result1 = null;
              pos = savedPos0;
            }
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        var result0 = result1 !== null
          ? (function(ref) {
                var query = {};
                query.kind = 'drop';
                query.token = 'executableunit'
                query.destinyGraph = ref;
                
                return query;
          })(result1[7])
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[34] Drop");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_Create() {
        var cacheKey = 'Create@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        if (input.substr(pos, 1) === "C") {
          var result44 = "C";
          pos += 1;
        } else {
          var result44 = null;
          if (reportMatchFailures) {
            matchFailed("\"C\"");
          }
        }
        if (result44 !== null) {
          var result2 = result44;
        } else {
          if (input.substr(pos, 1) === "c") {
            var result43 = "c";
            pos += 1;
          } else {
            var result43 = null;
            if (reportMatchFailures) {
              matchFailed("\"c\"");
            }
          }
          if (result43 !== null) {
            var result2 = result43;
          } else {
            var result2 = null;;
          };
        }
        if (result2 !== null) {
          if (input.substr(pos, 1) === "R") {
            var result42 = "R";
            pos += 1;
          } else {
            var result42 = null;
            if (reportMatchFailures) {
              matchFailed("\"R\"");
            }
          }
          if (result42 !== null) {
            var result3 = result42;
          } else {
            if (input.substr(pos, 1) === "r") {
              var result41 = "r";
              pos += 1;
            } else {
              var result41 = null;
              if (reportMatchFailures) {
                matchFailed("\"r\"");
              }
            }
            if (result41 !== null) {
              var result3 = result41;
            } else {
              var result3 = null;;
            };
          }
          if (result3 !== null) {
            if (input.substr(pos, 1) === "E") {
              var result40 = "E";
              pos += 1;
            } else {
              var result40 = null;
              if (reportMatchFailures) {
                matchFailed("\"E\"");
              }
            }
            if (result40 !== null) {
              var result4 = result40;
            } else {
              if (input.substr(pos, 1) === "e") {
                var result39 = "e";
                pos += 1;
              } else {
                var result39 = null;
                if (reportMatchFailures) {
                  matchFailed("\"e\"");
                }
              }
              if (result39 !== null) {
                var result4 = result39;
              } else {
                var result4 = null;;
              };
            }
            if (result4 !== null) {
              if (input.substr(pos, 1) === "A") {
                var result38 = "A";
                pos += 1;
              } else {
                var result38 = null;
                if (reportMatchFailures) {
                  matchFailed("\"A\"");
                }
              }
              if (result38 !== null) {
                var result5 = result38;
              } else {
                if (input.substr(pos, 1) === "a") {
                  var result37 = "a";
                  pos += 1;
                } else {
                  var result37 = null;
                  if (reportMatchFailures) {
                    matchFailed("\"a\"");
                  }
                }
                if (result37 !== null) {
                  var result5 = result37;
                } else {
                  var result5 = null;;
                };
              }
              if (result5 !== null) {
                if (input.substr(pos, 1) === "T") {
                  var result36 = "T";
                  pos += 1;
                } else {
                  var result36 = null;
                  if (reportMatchFailures) {
                    matchFailed("\"T\"");
                  }
                }
                if (result36 !== null) {
                  var result6 = result36;
                } else {
                  if (input.substr(pos, 1) === "t") {
                    var result35 = "t";
                    pos += 1;
                  } else {
                    var result35 = null;
                    if (reportMatchFailures) {
                      matchFailed("\"t\"");
                    }
                  }
                  if (result35 !== null) {
                    var result6 = result35;
                  } else {
                    var result6 = null;;
                  };
                }
                if (result6 !== null) {
                  if (input.substr(pos, 1) === "E") {
                    var result34 = "E";
                    pos += 1;
                  } else {
                    var result34 = null;
                    if (reportMatchFailures) {
                      matchFailed("\"E\"");
                    }
                  }
                  if (result34 !== null) {
                    var result7 = result34;
                  } else {
                    if (input.substr(pos, 1) === "e") {
                      var result33 = "e";
                      pos += 1;
                    } else {
                      var result33 = null;
                      if (reportMatchFailures) {
                        matchFailed("\"e\"");
                      }
                    }
                    if (result33 !== null) {
                      var result7 = result33;
                    } else {
                      var result7 = null;;
                    };
                  }
                  if (result7 !== null) {
                    var result8 = [];
                    var result32 = parse_WS();
                    while (result32 !== null) {
                      result8.push(result32);
                      var result32 = parse_WS();
                    }
                    if (result8 !== null) {
                      var savedPos1 = pos;
                      if (input.substr(pos, 1) === "S") {
                        var result31 = "S";
                        pos += 1;
                      } else {
                        var result31 = null;
                        if (reportMatchFailures) {
                          matchFailed("\"S\"");
                        }
                      }
                      if (result31 !== null) {
                        var result14 = result31;
                      } else {
                        if (input.substr(pos, 1) === "s") {
                          var result30 = "s";
                          pos += 1;
                        } else {
                          var result30 = null;
                          if (reportMatchFailures) {
                            matchFailed("\"s\"");
                          }
                        }
                        if (result30 !== null) {
                          var result14 = result30;
                        } else {
                          var result14 = null;;
                        };
                      }
                      if (result14 !== null) {
                        if (input.substr(pos, 1) === "I") {
                          var result29 = "I";
                          pos += 1;
                        } else {
                          var result29 = null;
                          if (reportMatchFailures) {
                            matchFailed("\"I\"");
                          }
                        }
                        if (result29 !== null) {
                          var result15 = result29;
                        } else {
                          if (input.substr(pos, 1) === "i") {
                            var result28 = "i";
                            pos += 1;
                          } else {
                            var result28 = null;
                            if (reportMatchFailures) {
                              matchFailed("\"i\"");
                            }
                          }
                          if (result28 !== null) {
                            var result15 = result28;
                          } else {
                            var result15 = null;;
                          };
                        }
                        if (result15 !== null) {
                          if (input.substr(pos, 1) === "L") {
                            var result27 = "L";
                            pos += 1;
                          } else {
                            var result27 = null;
                            if (reportMatchFailures) {
                              matchFailed("\"L\"");
                            }
                          }
                          if (result27 !== null) {
                            var result16 = result27;
                          } else {
                            if (input.substr(pos, 1) === "l") {
                              var result26 = "l";
                              pos += 1;
                            } else {
                              var result26 = null;
                              if (reportMatchFailures) {
                                matchFailed("\"l\"");
                              }
                            }
                            if (result26 !== null) {
                              var result16 = result26;
                            } else {
                              var result16 = null;;
                            };
                          }
                          if (result16 !== null) {
                            if (input.substr(pos, 1) === "E") {
                              var result25 = "E";
                              pos += 1;
                            } else {
                              var result25 = null;
                              if (reportMatchFailures) {
                                matchFailed("\"E\"");
                              }
                            }
                            if (result25 !== null) {
                              var result17 = result25;
                            } else {
                              if (input.substr(pos, 1) === "e") {
                                var result24 = "e";
                                pos += 1;
                              } else {
                                var result24 = null;
                                if (reportMatchFailures) {
                                  matchFailed("\"e\"");
                                }
                              }
                              if (result24 !== null) {
                                var result17 = result24;
                              } else {
                                var result17 = null;;
                              };
                            }
                            if (result17 !== null) {
                              if (input.substr(pos, 1) === "N") {
                                var result23 = "N";
                                pos += 1;
                              } else {
                                var result23 = null;
                                if (reportMatchFailures) {
                                  matchFailed("\"N\"");
                                }
                              }
                              if (result23 !== null) {
                                var result18 = result23;
                              } else {
                                if (input.substr(pos, 1) === "n") {
                                  var result22 = "n";
                                  pos += 1;
                                } else {
                                  var result22 = null;
                                  if (reportMatchFailures) {
                                    matchFailed("\"n\"");
                                  }
                                }
                                if (result22 !== null) {
                                  var result18 = result22;
                                } else {
                                  var result18 = null;;
                                };
                              }
                              if (result18 !== null) {
                                if (input.substr(pos, 1) === "T") {
                                  var result21 = "T";
                                  pos += 1;
                                } else {
                                  var result21 = null;
                                  if (reportMatchFailures) {
                                    matchFailed("\"T\"");
                                  }
                                }
                                if (result21 !== null) {
                                  var result19 = result21;
                                } else {
                                  if (input.substr(pos, 1) === "t") {
                                    var result20 = "t";
                                    pos += 1;
                                  } else {
                                    var result20 = null;
                                    if (reportMatchFailures) {
                                      matchFailed("\"t\"");
                                    }
                                  }
                                  if (result20 !== null) {
                                    var result19 = result20;
                                  } else {
                                    var result19 = null;;
                                  };
                                }
                                if (result19 !== null) {
                                  var result13 = [result14, result15, result16, result17, result18, result19];
                                } else {
                                  var result13 = null;
                                  pos = savedPos1;
                                }
                              } else {
                                var result13 = null;
                                pos = savedPos1;
                              }
                            } else {
                              var result13 = null;
                              pos = savedPos1;
                            }
                          } else {
                            var result13 = null;
                            pos = savedPos1;
                          }
                        } else {
                          var result13 = null;
                          pos = savedPos1;
                        }
                      } else {
                        var result13 = null;
                        pos = savedPos1;
                      }
                      var result9 = result13 !== null ? result13 : '';
                      if (result9 !== null) {
                        var result10 = [];
                        var result12 = parse_WS();
                        while (result12 !== null) {
                          result10.push(result12);
                          var result12 = parse_WS();
                        }
                        if (result10 !== null) {
                          var result11 = parse_GraphRef();
                          if (result11 !== null) {
                            var result1 = [result2, result3, result4, result5, result6, result7, result8, result9, result10, result11];
                          } else {
                            var result1 = null;
                            pos = savedPos0;
                          }
                        } else {
                          var result1 = null;
                          pos = savedPos0;
                        }
                      } else {
                        var result1 = null;
                        pos = savedPos0;
                      }
                    } else {
                      var result1 = null;
                      pos = savedPos0;
                    }
                  } else {
                    var result1 = null;
                    pos = savedPos0;
                  }
                } else {
                  var result1 = null;
                  pos = savedPos0;
                }
              } else {
                var result1 = null;
                pos = savedPos0;
              }
            } else {
              var result1 = null;
              pos = savedPos0;
            }
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        var result0 = result1 !== null
          ? (function(ref) {
                var query = {};
                query.kind = 'create';
                query.token = 'executableunit'
                query.destinyGraph = ref;
                
                return query;
          })(result1[9])
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[35] Create");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_InsertData() {
        var cacheKey = 'InsertData@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        if (input.substr(pos, 1) === "I") {
          var result36 = "I";
          pos += 1;
        } else {
          var result36 = null;
          if (reportMatchFailures) {
            matchFailed("\"I\"");
          }
        }
        if (result36 !== null) {
          var result2 = result36;
        } else {
          if (input.substr(pos, 1) === "i") {
            var result35 = "i";
            pos += 1;
          } else {
            var result35 = null;
            if (reportMatchFailures) {
              matchFailed("\"i\"");
            }
          }
          if (result35 !== null) {
            var result2 = result35;
          } else {
            var result2 = null;;
          };
        }
        if (result2 !== null) {
          if (input.substr(pos, 1) === "N") {
            var result34 = "N";
            pos += 1;
          } else {
            var result34 = null;
            if (reportMatchFailures) {
              matchFailed("\"N\"");
            }
          }
          if (result34 !== null) {
            var result3 = result34;
          } else {
            if (input.substr(pos, 1) === "n") {
              var result33 = "n";
              pos += 1;
            } else {
              var result33 = null;
              if (reportMatchFailures) {
                matchFailed("\"n\"");
              }
            }
            if (result33 !== null) {
              var result3 = result33;
            } else {
              var result3 = null;;
            };
          }
          if (result3 !== null) {
            if (input.substr(pos, 1) === "S") {
              var result32 = "S";
              pos += 1;
            } else {
              var result32 = null;
              if (reportMatchFailures) {
                matchFailed("\"S\"");
              }
            }
            if (result32 !== null) {
              var result4 = result32;
            } else {
              if (input.substr(pos, 1) === "s") {
                var result31 = "s";
                pos += 1;
              } else {
                var result31 = null;
                if (reportMatchFailures) {
                  matchFailed("\"s\"");
                }
              }
              if (result31 !== null) {
                var result4 = result31;
              } else {
                var result4 = null;;
              };
            }
            if (result4 !== null) {
              if (input.substr(pos, 1) === "E") {
                var result30 = "E";
                pos += 1;
              } else {
                var result30 = null;
                if (reportMatchFailures) {
                  matchFailed("\"E\"");
                }
              }
              if (result30 !== null) {
                var result5 = result30;
              } else {
                if (input.substr(pos, 1) === "e") {
                  var result29 = "e";
                  pos += 1;
                } else {
                  var result29 = null;
                  if (reportMatchFailures) {
                    matchFailed("\"e\"");
                  }
                }
                if (result29 !== null) {
                  var result5 = result29;
                } else {
                  var result5 = null;;
                };
              }
              if (result5 !== null) {
                if (input.substr(pos, 1) === "R") {
                  var result28 = "R";
                  pos += 1;
                } else {
                  var result28 = null;
                  if (reportMatchFailures) {
                    matchFailed("\"R\"");
                  }
                }
                if (result28 !== null) {
                  var result6 = result28;
                } else {
                  if (input.substr(pos, 1) === "r") {
                    var result27 = "r";
                    pos += 1;
                  } else {
                    var result27 = null;
                    if (reportMatchFailures) {
                      matchFailed("\"r\"");
                    }
                  }
                  if (result27 !== null) {
                    var result6 = result27;
                  } else {
                    var result6 = null;;
                  };
                }
                if (result6 !== null) {
                  if (input.substr(pos, 1) === "T") {
                    var result26 = "T";
                    pos += 1;
                  } else {
                    var result26 = null;
                    if (reportMatchFailures) {
                      matchFailed("\"T\"");
                    }
                  }
                  if (result26 !== null) {
                    var result7 = result26;
                  } else {
                    if (input.substr(pos, 1) === "t") {
                      var result25 = "t";
                      pos += 1;
                    } else {
                      var result25 = null;
                      if (reportMatchFailures) {
                        matchFailed("\"t\"");
                      }
                    }
                    if (result25 !== null) {
                      var result7 = result25;
                    } else {
                      var result7 = null;;
                    };
                  }
                  if (result7 !== null) {
                    var result8 = [];
                    var result24 = parse_WS();
                    while (result24 !== null) {
                      result8.push(result24);
                      var result24 = parse_WS();
                    }
                    if (result8 !== null) {
                      if (input.substr(pos, 1) === "D") {
                        var result23 = "D";
                        pos += 1;
                      } else {
                        var result23 = null;
                        if (reportMatchFailures) {
                          matchFailed("\"D\"");
                        }
                      }
                      if (result23 !== null) {
                        var result9 = result23;
                      } else {
                        if (input.substr(pos, 1) === "d") {
                          var result22 = "d";
                          pos += 1;
                        } else {
                          var result22 = null;
                          if (reportMatchFailures) {
                            matchFailed("\"d\"");
                          }
                        }
                        if (result22 !== null) {
                          var result9 = result22;
                        } else {
                          var result9 = null;;
                        };
                      }
                      if (result9 !== null) {
                        if (input.substr(pos, 1) === "A") {
                          var result21 = "A";
                          pos += 1;
                        } else {
                          var result21 = null;
                          if (reportMatchFailures) {
                            matchFailed("\"A\"");
                          }
                        }
                        if (result21 !== null) {
                          var result10 = result21;
                        } else {
                          if (input.substr(pos, 1) === "a") {
                            var result20 = "a";
                            pos += 1;
                          } else {
                            var result20 = null;
                            if (reportMatchFailures) {
                              matchFailed("\"a\"");
                            }
                          }
                          if (result20 !== null) {
                            var result10 = result20;
                          } else {
                            var result10 = null;;
                          };
                        }
                        if (result10 !== null) {
                          if (input.substr(pos, 1) === "T") {
                            var result19 = "T";
                            pos += 1;
                          } else {
                            var result19 = null;
                            if (reportMatchFailures) {
                              matchFailed("\"T\"");
                            }
                          }
                          if (result19 !== null) {
                            var result11 = result19;
                          } else {
                            if (input.substr(pos, 1) === "t") {
                              var result18 = "t";
                              pos += 1;
                            } else {
                              var result18 = null;
                              if (reportMatchFailures) {
                                matchFailed("\"t\"");
                              }
                            }
                            if (result18 !== null) {
                              var result11 = result18;
                            } else {
                              var result11 = null;;
                            };
                          }
                          if (result11 !== null) {
                            if (input.substr(pos, 1) === "A") {
                              var result17 = "A";
                              pos += 1;
                            } else {
                              var result17 = null;
                              if (reportMatchFailures) {
                                matchFailed("\"A\"");
                              }
                            }
                            if (result17 !== null) {
                              var result12 = result17;
                            } else {
                              if (input.substr(pos, 1) === "a") {
                                var result16 = "a";
                                pos += 1;
                              } else {
                                var result16 = null;
                                if (reportMatchFailures) {
                                  matchFailed("\"a\"");
                                }
                              }
                              if (result16 !== null) {
                                var result12 = result16;
                              } else {
                                var result12 = null;;
                              };
                            }
                            if (result12 !== null) {
                              var result13 = [];
                              var result15 = parse_WS();
                              while (result15 !== null) {
                                result13.push(result15);
                                var result15 = parse_WS();
                              }
                              if (result13 !== null) {
                                var result14 = parse_QuadData();
                                if (result14 !== null) {
                                  var result1 = [result2, result3, result4, result5, result6, result7, result8, result9, result10, result11, result12, result13, result14];
                                } else {
                                  var result1 = null;
                                  pos = savedPos0;
                                }
                              } else {
                                var result1 = null;
                                pos = savedPos0;
                              }
                            } else {
                              var result1 = null;
                              pos = savedPos0;
                            }
                          } else {
                            var result1 = null;
                            pos = savedPos0;
                          }
                        } else {
                          var result1 = null;
                          pos = savedPos0;
                        }
                      } else {
                        var result1 = null;
                        pos = savedPos0;
                      }
                    } else {
                      var result1 = null;
                      pos = savedPos0;
                    }
                  } else {
                    var result1 = null;
                    pos = savedPos0;
                  }
                } else {
                  var result1 = null;
                  pos = savedPos0;
                }
              } else {
                var result1 = null;
                pos = savedPos0;
              }
            } else {
              var result1 = null;
              pos = savedPos0;
            }
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        var result0 = result1 !== null
          ? (function(qs) {
                var query = {};
                query.kind = 'insertdata';
                query.token = 'executableunit'
                query.quads = qs;
          
                return query;
          })(result1[12])
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[36] InsertData");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_DeleteData() {
        var cacheKey = 'DeleteData@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        if (input.substr(pos, 1) === "D") {
          var result34 = "D";
          pos += 1;
        } else {
          var result34 = null;
          if (reportMatchFailures) {
            matchFailed("\"D\"");
          }
        }
        if (result34 !== null) {
          var result2 = result34;
        } else {
          if (input.substr(pos, 1) === "d") {
            var result33 = "d";
            pos += 1;
          } else {
            var result33 = null;
            if (reportMatchFailures) {
              matchFailed("\"d\"");
            }
          }
          if (result33 !== null) {
            var result2 = result33;
          } else {
            var result2 = null;;
          };
        }
        if (result2 !== null) {
          if (input.substr(pos, 1) === "E") {
            var result32 = "E";
            pos += 1;
          } else {
            var result32 = null;
            if (reportMatchFailures) {
              matchFailed("\"E\"");
            }
          }
          if (result32 !== null) {
            var result3 = result32;
          } else {
            if (input.substr(pos, 1) === "e") {
              var result31 = "e";
              pos += 1;
            } else {
              var result31 = null;
              if (reportMatchFailures) {
                matchFailed("\"e\"");
              }
            }
            if (result31 !== null) {
              var result3 = result31;
            } else {
              var result3 = null;;
            };
          }
          if (result3 !== null) {
            if (input.substr(pos, 1) === "L") {
              var result30 = "L";
              pos += 1;
            } else {
              var result30 = null;
              if (reportMatchFailures) {
                matchFailed("\"L\"");
              }
            }
            if (result30 !== null) {
              var result4 = result30;
            } else {
              if (input.substr(pos, 1) === "l") {
                var result29 = "l";
                pos += 1;
              } else {
                var result29 = null;
                if (reportMatchFailures) {
                  matchFailed("\"l\"");
                }
              }
              if (result29 !== null) {
                var result4 = result29;
              } else {
                var result4 = null;;
              };
            }
            if (result4 !== null) {
              if (input.substr(pos, 1) === "E") {
                var result28 = "E";
                pos += 1;
              } else {
                var result28 = null;
                if (reportMatchFailures) {
                  matchFailed("\"E\"");
                }
              }
              if (result28 !== null) {
                var result5 = result28;
              } else {
                if (input.substr(pos, 1) === "e") {
                  var result27 = "e";
                  pos += 1;
                } else {
                  var result27 = null;
                  if (reportMatchFailures) {
                    matchFailed("\"e\"");
                  }
                }
                if (result27 !== null) {
                  var result5 = result27;
                } else {
                  var result5 = null;;
                };
              }
              if (result5 !== null) {
                if (input.substr(pos, 1) === "T") {
                  var result26 = "T";
                  pos += 1;
                } else {
                  var result26 = null;
                  if (reportMatchFailures) {
                    matchFailed("\"T\"");
                  }
                }
                if (result26 !== null) {
                  var result6 = result26;
                } else {
                  if (input.substr(pos, 1) === "t") {
                    var result25 = "t";
                    pos += 1;
                  } else {
                    var result25 = null;
                    if (reportMatchFailures) {
                      matchFailed("\"t\"");
                    }
                  }
                  if (result25 !== null) {
                    var result6 = result25;
                  } else {
                    var result6 = null;;
                  };
                }
                if (result6 !== null) {
                  if (input.substr(pos, 1) === "E") {
                    var result24 = "E";
                    pos += 1;
                  } else {
                    var result24 = null;
                    if (reportMatchFailures) {
                      matchFailed("\"E\"");
                    }
                  }
                  if (result24 !== null) {
                    var result7 = result24;
                  } else {
                    if (input.substr(pos, 1) === "e") {
                      var result23 = "e";
                      pos += 1;
                    } else {
                      var result23 = null;
                      if (reportMatchFailures) {
                        matchFailed("\"e\"");
                      }
                    }
                    if (result23 !== null) {
                      var result7 = result23;
                    } else {
                      var result7 = null;;
                    };
                  }
                  if (result7 !== null) {
                    var result8 = [];
                    var result22 = parse_WS();
                    while (result22 !== null) {
                      result8.push(result22);
                      var result22 = parse_WS();
                    }
                    if (result8 !== null) {
                      if (input.substr(pos, 1) === "D") {
                        var result21 = "D";
                        pos += 1;
                      } else {
                        var result21 = null;
                        if (reportMatchFailures) {
                          matchFailed("\"D\"");
                        }
                      }
                      if (result21 !== null) {
                        var result9 = result21;
                      } else {
                        if (input.substr(pos, 1) === "d") {
                          var result20 = "d";
                          pos += 1;
                        } else {
                          var result20 = null;
                          if (reportMatchFailures) {
                            matchFailed("\"d\"");
                          }
                        }
                        if (result20 !== null) {
                          var result9 = result20;
                        } else {
                          var result9 = null;;
                        };
                      }
                      if (result9 !== null) {
                        if (input.substr(pos, 1) === "A") {
                          var result19 = "A";
                          pos += 1;
                        } else {
                          var result19 = null;
                          if (reportMatchFailures) {
                            matchFailed("\"A\"");
                          }
                        }
                        if (result19 !== null) {
                          var result10 = result19;
                        } else {
                          if (input.substr(pos, 1) === "a") {
                            var result18 = "a";
                            pos += 1;
                          } else {
                            var result18 = null;
                            if (reportMatchFailures) {
                              matchFailed("\"a\"");
                            }
                          }
                          if (result18 !== null) {
                            var result10 = result18;
                          } else {
                            var result10 = null;;
                          };
                        }
                        if (result10 !== null) {
                          if (input.substr(pos, 1) === "T") {
                            var result17 = "T";
                            pos += 1;
                          } else {
                            var result17 = null;
                            if (reportMatchFailures) {
                              matchFailed("\"T\"");
                            }
                          }
                          if (result17 !== null) {
                            var result11 = result17;
                          } else {
                            if (input.substr(pos, 1) === "t") {
                              var result16 = "t";
                              pos += 1;
                            } else {
                              var result16 = null;
                              if (reportMatchFailures) {
                                matchFailed("\"t\"");
                              }
                            }
                            if (result16 !== null) {
                              var result11 = result16;
                            } else {
                              var result11 = null;;
                            };
                          }
                          if (result11 !== null) {
                            if (input.substr(pos, 1) === "A") {
                              var result15 = "A";
                              pos += 1;
                            } else {
                              var result15 = null;
                              if (reportMatchFailures) {
                                matchFailed("\"A\"");
                              }
                            }
                            if (result15 !== null) {
                              var result12 = result15;
                            } else {
                              if (input.substr(pos, 1) === "a") {
                                var result14 = "a";
                                pos += 1;
                              } else {
                                var result14 = null;
                                if (reportMatchFailures) {
                                  matchFailed("\"a\"");
                                }
                              }
                              if (result14 !== null) {
                                var result12 = result14;
                              } else {
                                var result12 = null;;
                              };
                            }
                            if (result12 !== null) {
                              var result13 = parse_QuadData();
                              if (result13 !== null) {
                                var result1 = [result2, result3, result4, result5, result6, result7, result8, result9, result10, result11, result12, result13];
                              } else {
                                var result1 = null;
                                pos = savedPos0;
                              }
                            } else {
                              var result1 = null;
                              pos = savedPos0;
                            }
                          } else {
                            var result1 = null;
                            pos = savedPos0;
                          }
                        } else {
                          var result1 = null;
                          pos = savedPos0;
                        }
                      } else {
                        var result1 = null;
                        pos = savedPos0;
                      }
                    } else {
                      var result1 = null;
                      pos = savedPos0;
                    }
                  } else {
                    var result1 = null;
                    pos = savedPos0;
                  }
                } else {
                  var result1 = null;
                  pos = savedPos0;
                }
              } else {
                var result1 = null;
                pos = savedPos0;
              }
            } else {
              var result1 = null;
              pos = savedPos0;
            }
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        var result0 = result1 !== null
          ? (function(qs) {
                var query = {};
                query.kind = 'deletedata';
                query.token = 'executableunit'
                query.quads = qs;
          
                return query;
          })(result1[11])
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[37] DeleteData");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_DeleteWhere() {
        var cacheKey = 'DeleteWhere@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        if (input.substr(pos, 1) === "D") {
          var result39 = "D";
          pos += 1;
        } else {
          var result39 = null;
          if (reportMatchFailures) {
            matchFailed("\"D\"");
          }
        }
        if (result39 !== null) {
          var result2 = result39;
        } else {
          if (input.substr(pos, 1) === "d") {
            var result38 = "d";
            pos += 1;
          } else {
            var result38 = null;
            if (reportMatchFailures) {
              matchFailed("\"d\"");
            }
          }
          if (result38 !== null) {
            var result2 = result38;
          } else {
            var result2 = null;;
          };
        }
        if (result2 !== null) {
          if (input.substr(pos, 1) === "E") {
            var result37 = "E";
            pos += 1;
          } else {
            var result37 = null;
            if (reportMatchFailures) {
              matchFailed("\"E\"");
            }
          }
          if (result37 !== null) {
            var result3 = result37;
          } else {
            if (input.substr(pos, 1) === "e") {
              var result36 = "e";
              pos += 1;
            } else {
              var result36 = null;
              if (reportMatchFailures) {
                matchFailed("\"e\"");
              }
            }
            if (result36 !== null) {
              var result3 = result36;
            } else {
              var result3 = null;;
            };
          }
          if (result3 !== null) {
            if (input.substr(pos, 1) === "L") {
              var result35 = "L";
              pos += 1;
            } else {
              var result35 = null;
              if (reportMatchFailures) {
                matchFailed("\"L\"");
              }
            }
            if (result35 !== null) {
              var result4 = result35;
            } else {
              if (input.substr(pos, 1) === "l") {
                var result34 = "l";
                pos += 1;
              } else {
                var result34 = null;
                if (reportMatchFailures) {
                  matchFailed("\"l\"");
                }
              }
              if (result34 !== null) {
                var result4 = result34;
              } else {
                var result4 = null;;
              };
            }
            if (result4 !== null) {
              if (input.substr(pos, 1) === "E") {
                var result33 = "E";
                pos += 1;
              } else {
                var result33 = null;
                if (reportMatchFailures) {
                  matchFailed("\"E\"");
                }
              }
              if (result33 !== null) {
                var result5 = result33;
              } else {
                if (input.substr(pos, 1) === "e") {
                  var result32 = "e";
                  pos += 1;
                } else {
                  var result32 = null;
                  if (reportMatchFailures) {
                    matchFailed("\"e\"");
                  }
                }
                if (result32 !== null) {
                  var result5 = result32;
                } else {
                  var result5 = null;;
                };
              }
              if (result5 !== null) {
                if (input.substr(pos, 1) === "T") {
                  var result31 = "T";
                  pos += 1;
                } else {
                  var result31 = null;
                  if (reportMatchFailures) {
                    matchFailed("\"T\"");
                  }
                }
                if (result31 !== null) {
                  var result6 = result31;
                } else {
                  if (input.substr(pos, 1) === "t") {
                    var result30 = "t";
                    pos += 1;
                  } else {
                    var result30 = null;
                    if (reportMatchFailures) {
                      matchFailed("\"t\"");
                    }
                  }
                  if (result30 !== null) {
                    var result6 = result30;
                  } else {
                    var result6 = null;;
                  };
                }
                if (result6 !== null) {
                  if (input.substr(pos, 1) === "E") {
                    var result29 = "E";
                    pos += 1;
                  } else {
                    var result29 = null;
                    if (reportMatchFailures) {
                      matchFailed("\"E\"");
                    }
                  }
                  if (result29 !== null) {
                    var result7 = result29;
                  } else {
                    if (input.substr(pos, 1) === "e") {
                      var result28 = "e";
                      pos += 1;
                    } else {
                      var result28 = null;
                      if (reportMatchFailures) {
                        matchFailed("\"e\"");
                      }
                    }
                    if (result28 !== null) {
                      var result7 = result28;
                    } else {
                      var result7 = null;;
                    };
                  }
                  if (result7 !== null) {
                    var result8 = [];
                    var result27 = parse_WS();
                    while (result27 !== null) {
                      result8.push(result27);
                      var result27 = parse_WS();
                    }
                    if (result8 !== null) {
                      if (input.substr(pos, 1) === "W") {
                        var result26 = "W";
                        pos += 1;
                      } else {
                        var result26 = null;
                        if (reportMatchFailures) {
                          matchFailed("\"W\"");
                        }
                      }
                      if (result26 !== null) {
                        var result9 = result26;
                      } else {
                        if (input.substr(pos, 1) === "w") {
                          var result25 = "w";
                          pos += 1;
                        } else {
                          var result25 = null;
                          if (reportMatchFailures) {
                            matchFailed("\"w\"");
                          }
                        }
                        if (result25 !== null) {
                          var result9 = result25;
                        } else {
                          var result9 = null;;
                        };
                      }
                      if (result9 !== null) {
                        if (input.substr(pos, 1) === "H") {
                          var result24 = "H";
                          pos += 1;
                        } else {
                          var result24 = null;
                          if (reportMatchFailures) {
                            matchFailed("\"H\"");
                          }
                        }
                        if (result24 !== null) {
                          var result10 = result24;
                        } else {
                          if (input.substr(pos, 1) === "h") {
                            var result23 = "h";
                            pos += 1;
                          } else {
                            var result23 = null;
                            if (reportMatchFailures) {
                              matchFailed("\"h\"");
                            }
                          }
                          if (result23 !== null) {
                            var result10 = result23;
                          } else {
                            var result10 = null;;
                          };
                        }
                        if (result10 !== null) {
                          if (input.substr(pos, 1) === "E") {
                            var result22 = "E";
                            pos += 1;
                          } else {
                            var result22 = null;
                            if (reportMatchFailures) {
                              matchFailed("\"E\"");
                            }
                          }
                          if (result22 !== null) {
                            var result11 = result22;
                          } else {
                            if (input.substr(pos, 1) === "e") {
                              var result21 = "e";
                              pos += 1;
                            } else {
                              var result21 = null;
                              if (reportMatchFailures) {
                                matchFailed("\"e\"");
                              }
                            }
                            if (result21 !== null) {
                              var result11 = result21;
                            } else {
                              var result11 = null;;
                            };
                          }
                          if (result11 !== null) {
                            if (input.substr(pos, 1) === "R") {
                              var result20 = "R";
                              pos += 1;
                            } else {
                              var result20 = null;
                              if (reportMatchFailures) {
                                matchFailed("\"R\"");
                              }
                            }
                            if (result20 !== null) {
                              var result12 = result20;
                            } else {
                              if (input.substr(pos, 1) === "r") {
                                var result19 = "r";
                                pos += 1;
                              } else {
                                var result19 = null;
                                if (reportMatchFailures) {
                                  matchFailed("\"r\"");
                                }
                              }
                              if (result19 !== null) {
                                var result12 = result19;
                              } else {
                                var result12 = null;;
                              };
                            }
                            if (result12 !== null) {
                              if (input.substr(pos, 1) === "E") {
                                var result18 = "E";
                                pos += 1;
                              } else {
                                var result18 = null;
                                if (reportMatchFailures) {
                                  matchFailed("\"E\"");
                                }
                              }
                              if (result18 !== null) {
                                var result13 = result18;
                              } else {
                                if (input.substr(pos, 1) === "e") {
                                  var result17 = "e";
                                  pos += 1;
                                } else {
                                  var result17 = null;
                                  if (reportMatchFailures) {
                                    matchFailed("\"e\"");
                                  }
                                }
                                if (result17 !== null) {
                                  var result13 = result17;
                                } else {
                                  var result13 = null;;
                                };
                              }
                              if (result13 !== null) {
                                var result14 = [];
                                var result16 = parse_WS();
                                while (result16 !== null) {
                                  result14.push(result16);
                                  var result16 = parse_WS();
                                }
                                if (result14 !== null) {
                                  var result15 = parse_GroupGraphPattern();
                                  if (result15 !== null) {
                                    var result1 = [result2, result3, result4, result5, result6, result7, result8, result9, result10, result11, result12, result13, result14, result15];
                                  } else {
                                    var result1 = null;
                                    pos = savedPos0;
                                  }
                                } else {
                                  var result1 = null;
                                  pos = savedPos0;
                                }
                              } else {
                                var result1 = null;
                                pos = savedPos0;
                              }
                            } else {
                              var result1 = null;
                              pos = savedPos0;
                            }
                          } else {
                            var result1 = null;
                            pos = savedPos0;
                          }
                        } else {
                          var result1 = null;
                          pos = savedPos0;
                        }
                      } else {
                        var result1 = null;
                        pos = savedPos0;
                      }
                    } else {
                      var result1 = null;
                      pos = savedPos0;
                    }
                  } else {
                    var result1 = null;
                    pos = savedPos0;
                  }
                } else {
                  var result1 = null;
                  pos = savedPos0;
                }
              } else {
                var result1 = null;
                pos = savedPos0;
              }
            } else {
              var result1 = null;
              pos = savedPos0;
            }
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        var result0 = result1 !== null
          ? (function(p) {
                var query = {};
                query.kind = 'modify';
                query.pattern = p;
                query['with'] = null;
                query['using'] = null;
          
                var quads = [];
          
          
                var patternsCollection = p.patterns[0];
                if(patternsCollection.triplesContext == null && patternsCollection.patterns!=null) {
                    patternsCollection = patternsCollection.patterns[0].triplesContext;
                } else {
                    patternsCollection = patternsCollection.triplesContext;
                }
          
                for(var i=0; i<patternsCollection.length; i++) {
                    var quad = {};
                    var contextQuad = patternsCollection[i];
          
                    quad['subject'] = contextQuad['subject'];
                    quad['predicate'] = contextQuad['predicate'];
                    quad['object'] = contextQuad['object'];
                    quad['graph'] = contextQuad['graph'];
          
                    quads.push(quad);
                }
          
                query['delete'] = quads;
          
                return query;
          })(result1[13])
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[38] DeleteWhere");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_Modify() {
        var cacheKey = 'Modify@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        var savedPos2 = pos;
        if (input.substr(pos, 1) === "W") {
          var result54 = "W";
          pos += 1;
        } else {
          var result54 = null;
          if (reportMatchFailures) {
            matchFailed("\"W\"");
          }
        }
        if (result54 !== null) {
          var result40 = result54;
        } else {
          if (input.substr(pos, 1) === "w") {
            var result53 = "w";
            pos += 1;
          } else {
            var result53 = null;
            if (reportMatchFailures) {
              matchFailed("\"w\"");
            }
          }
          if (result53 !== null) {
            var result40 = result53;
          } else {
            var result40 = null;;
          };
        }
        if (result40 !== null) {
          if (input.substr(pos, 1) === "I") {
            var result52 = "I";
            pos += 1;
          } else {
            var result52 = null;
            if (reportMatchFailures) {
              matchFailed("\"I\"");
            }
          }
          if (result52 !== null) {
            var result41 = result52;
          } else {
            if (input.substr(pos, 1) === "i") {
              var result51 = "i";
              pos += 1;
            } else {
              var result51 = null;
              if (reportMatchFailures) {
                matchFailed("\"i\"");
              }
            }
            if (result51 !== null) {
              var result41 = result51;
            } else {
              var result41 = null;;
            };
          }
          if (result41 !== null) {
            if (input.substr(pos, 1) === "T") {
              var result50 = "T";
              pos += 1;
            } else {
              var result50 = null;
              if (reportMatchFailures) {
                matchFailed("\"T\"");
              }
            }
            if (result50 !== null) {
              var result42 = result50;
            } else {
              if (input.substr(pos, 1) === "t") {
                var result49 = "t";
                pos += 1;
              } else {
                var result49 = null;
                if (reportMatchFailures) {
                  matchFailed("\"t\"");
                }
              }
              if (result49 !== null) {
                var result42 = result49;
              } else {
                var result42 = null;;
              };
            }
            if (result42 !== null) {
              if (input.substr(pos, 1) === "H") {
                var result48 = "H";
                pos += 1;
              } else {
                var result48 = null;
                if (reportMatchFailures) {
                  matchFailed("\"H\"");
                }
              }
              if (result48 !== null) {
                var result43 = result48;
              } else {
                if (input.substr(pos, 1) === "h") {
                  var result47 = "h";
                  pos += 1;
                } else {
                  var result47 = null;
                  if (reportMatchFailures) {
                    matchFailed("\"h\"");
                  }
                }
                if (result47 !== null) {
                  var result43 = result47;
                } else {
                  var result43 = null;;
                };
              }
              if (result43 !== null) {
                var result44 = [];
                var result46 = parse_WS();
                while (result46 !== null) {
                  result44.push(result46);
                  var result46 = parse_WS();
                }
                if (result44 !== null) {
                  var result45 = parse_IRIref();
                  if (result45 !== null) {
                    var result39 = [result40, result41, result42, result43, result44, result45];
                  } else {
                    var result39 = null;
                    pos = savedPos2;
                  }
                } else {
                  var result39 = null;
                  pos = savedPos2;
                }
              } else {
                var result39 = null;
                pos = savedPos2;
              }
            } else {
              var result39 = null;
              pos = savedPos2;
            }
          } else {
            var result39 = null;
            pos = savedPos2;
          }
        } else {
          var result39 = null;
          pos = savedPos2;
        }
        var result2 = result39 !== null ? result39 : '';
        if (result2 !== null) {
          var result3 = [];
          var result38 = parse_WS();
          while (result38 !== null) {
            result3.push(result38);
            var result38 = parse_WS();
          }
          if (result3 !== null) {
            var savedPos1 = pos;
            var result33 = parse_DeleteClause();
            if (result33 !== null) {
              var result34 = [];
              var result37 = parse_WS();
              while (result37 !== null) {
                result34.push(result37);
                var result37 = parse_WS();
              }
              if (result34 !== null) {
                var result36 = parse_InsertClause();
                var result35 = result36 !== null ? result36 : '';
                if (result35 !== null) {
                  var result32 = [result33, result34, result35];
                } else {
                  var result32 = null;
                  pos = savedPos1;
                }
              } else {
                var result32 = null;
                pos = savedPos1;
              }
            } else {
              var result32 = null;
              pos = savedPos1;
            }
            if (result32 !== null) {
              var result4 = result32;
            } else {
              var result31 = parse_InsertClause();
              if (result31 !== null) {
                var result4 = result31;
              } else {
                var result4 = null;;
              };
            }
            if (result4 !== null) {
              var result5 = [];
              var result30 = parse_WS();
              while (result30 !== null) {
                result5.push(result30);
                var result30 = parse_WS();
              }
              if (result5 !== null) {
                var result6 = [];
                var result29 = parse_UsingClause();
                while (result29 !== null) {
                  result6.push(result29);
                  var result29 = parse_UsingClause();
                }
                if (result6 !== null) {
                  var result7 = [];
                  var result28 = parse_WS();
                  while (result28 !== null) {
                    result7.push(result28);
                    var result28 = parse_WS();
                  }
                  if (result7 !== null) {
                    if (input.substr(pos, 1) === "W") {
                      var result27 = "W";
                      pos += 1;
                    } else {
                      var result27 = null;
                      if (reportMatchFailures) {
                        matchFailed("\"W\"");
                      }
                    }
                    if (result27 !== null) {
                      var result8 = result27;
                    } else {
                      if (input.substr(pos, 1) === "w") {
                        var result26 = "w";
                        pos += 1;
                      } else {
                        var result26 = null;
                        if (reportMatchFailures) {
                          matchFailed("\"w\"");
                        }
                      }
                      if (result26 !== null) {
                        var result8 = result26;
                      } else {
                        var result8 = null;;
                      };
                    }
                    if (result8 !== null) {
                      if (input.substr(pos, 1) === "H") {
                        var result25 = "H";
                        pos += 1;
                      } else {
                        var result25 = null;
                        if (reportMatchFailures) {
                          matchFailed("\"H\"");
                        }
                      }
                      if (result25 !== null) {
                        var result9 = result25;
                      } else {
                        if (input.substr(pos, 1) === "h") {
                          var result24 = "h";
                          pos += 1;
                        } else {
                          var result24 = null;
                          if (reportMatchFailures) {
                            matchFailed("\"h\"");
                          }
                        }
                        if (result24 !== null) {
                          var result9 = result24;
                        } else {
                          var result9 = null;;
                        };
                      }
                      if (result9 !== null) {
                        if (input.substr(pos, 1) === "E") {
                          var result23 = "E";
                          pos += 1;
                        } else {
                          var result23 = null;
                          if (reportMatchFailures) {
                            matchFailed("\"E\"");
                          }
                        }
                        if (result23 !== null) {
                          var result10 = result23;
                        } else {
                          if (input.substr(pos, 1) === "e") {
                            var result22 = "e";
                            pos += 1;
                          } else {
                            var result22 = null;
                            if (reportMatchFailures) {
                              matchFailed("\"e\"");
                            }
                          }
                          if (result22 !== null) {
                            var result10 = result22;
                          } else {
                            var result10 = null;;
                          };
                        }
                        if (result10 !== null) {
                          if (input.substr(pos, 1) === "R") {
                            var result21 = "R";
                            pos += 1;
                          } else {
                            var result21 = null;
                            if (reportMatchFailures) {
                              matchFailed("\"R\"");
                            }
                          }
                          if (result21 !== null) {
                            var result11 = result21;
                          } else {
                            if (input.substr(pos, 1) === "r") {
                              var result20 = "r";
                              pos += 1;
                            } else {
                              var result20 = null;
                              if (reportMatchFailures) {
                                matchFailed("\"r\"");
                              }
                            }
                            if (result20 !== null) {
                              var result11 = result20;
                            } else {
                              var result11 = null;;
                            };
                          }
                          if (result11 !== null) {
                            if (input.substr(pos, 1) === "E") {
                              var result19 = "E";
                              pos += 1;
                            } else {
                              var result19 = null;
                              if (reportMatchFailures) {
                                matchFailed("\"E\"");
                              }
                            }
                            if (result19 !== null) {
                              var result12 = result19;
                            } else {
                              if (input.substr(pos, 1) === "e") {
                                var result18 = "e";
                                pos += 1;
                              } else {
                                var result18 = null;
                                if (reportMatchFailures) {
                                  matchFailed("\"e\"");
                                }
                              }
                              if (result18 !== null) {
                                var result12 = result18;
                              } else {
                                var result12 = null;;
                              };
                            }
                            if (result12 !== null) {
                              var result13 = [];
                              var result17 = parse_WS();
                              while (result17 !== null) {
                                result13.push(result17);
                                var result17 = parse_WS();
                              }
                              if (result13 !== null) {
                                var result14 = parse_GroupGraphPattern();
                                if (result14 !== null) {
                                  var result15 = [];
                                  var result16 = parse_WS();
                                  while (result16 !== null) {
                                    result15.push(result16);
                                    var result16 = parse_WS();
                                  }
                                  if (result15 !== null) {
                                    var result1 = [result2, result3, result4, result5, result6, result7, result8, result9, result10, result11, result12, result13, result14, result15];
                                  } else {
                                    var result1 = null;
                                    pos = savedPos0;
                                  }
                                } else {
                                  var result1 = null;
                                  pos = savedPos0;
                                }
                              } else {
                                var result1 = null;
                                pos = savedPos0;
                              }
                            } else {
                              var result1 = null;
                              pos = savedPos0;
                            }
                          } else {
                            var result1 = null;
                            pos = savedPos0;
                          }
                        } else {
                          var result1 = null;
                          pos = savedPos0;
                        }
                      } else {
                        var result1 = null;
                        pos = savedPos0;
                      }
                    } else {
                      var result1 = null;
                      pos = savedPos0;
                    }
                  } else {
                    var result1 = null;
                    pos = savedPos0;
                  }
                } else {
                  var result1 = null;
                  pos = savedPos0;
                }
              } else {
                var result1 = null;
                pos = savedPos0;
              }
            } else {
              var result1 = null;
              pos = savedPos0;
            }
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        var result0 = result1 !== null
          ? (function(wg, dic, uc, p) {
                var query = {};
                query.kind = 'modify';
          
                if(wg != "") {
                    query['with'] = wg[5];
                } else {
                    query['with'] = null;
                }
          
          
                if(dic.length === 3 && dic[2] === '') {
                    query['delete'] = dic[0];
                    query.insert = null;
                } else if(dic.length === 3 && dic[0].length != null && dic[1].length != null && dic[2].length != null) {
                    query['delete'] = dic[0];
                    query.insert = dic[2];
                } else  {
                    query.insert = dic;
                    query['delete'] = null;
                }
          
                if(uc != '') {
                    query['using'] = uc;
                }
          
                query.pattern = p;
          
                return query;
          })(result1[0], result1[2], result1[4], result1[12])
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[39] Modify");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_DeleteClause() {
        var cacheKey = 'DeleteClause@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        if (input.substr(pos, 1) === "D") {
          var result20 = "D";
          pos += 1;
        } else {
          var result20 = null;
          if (reportMatchFailures) {
            matchFailed("\"D\"");
          }
        }
        if (result20 !== null) {
          var result2 = result20;
        } else {
          if (input.substr(pos, 1) === "d") {
            var result19 = "d";
            pos += 1;
          } else {
            var result19 = null;
            if (reportMatchFailures) {
              matchFailed("\"d\"");
            }
          }
          if (result19 !== null) {
            var result2 = result19;
          } else {
            var result2 = null;;
          };
        }
        if (result2 !== null) {
          if (input.substr(pos, 1) === "E") {
            var result18 = "E";
            pos += 1;
          } else {
            var result18 = null;
            if (reportMatchFailures) {
              matchFailed("\"E\"");
            }
          }
          if (result18 !== null) {
            var result3 = result18;
          } else {
            if (input.substr(pos, 1) === "e") {
              var result17 = "e";
              pos += 1;
            } else {
              var result17 = null;
              if (reportMatchFailures) {
                matchFailed("\"e\"");
              }
            }
            if (result17 !== null) {
              var result3 = result17;
            } else {
              var result3 = null;;
            };
          }
          if (result3 !== null) {
            if (input.substr(pos, 1) === "L") {
              var result16 = "L";
              pos += 1;
            } else {
              var result16 = null;
              if (reportMatchFailures) {
                matchFailed("\"L\"");
              }
            }
            if (result16 !== null) {
              var result4 = result16;
            } else {
              if (input.substr(pos, 1) === "l") {
                var result15 = "l";
                pos += 1;
              } else {
                var result15 = null;
                if (reportMatchFailures) {
                  matchFailed("\"l\"");
                }
              }
              if (result15 !== null) {
                var result4 = result15;
              } else {
                var result4 = null;;
              };
            }
            if (result4 !== null) {
              if (input.substr(pos, 1) === "E") {
                var result14 = "E";
                pos += 1;
              } else {
                var result14 = null;
                if (reportMatchFailures) {
                  matchFailed("\"E\"");
                }
              }
              if (result14 !== null) {
                var result5 = result14;
              } else {
                if (input.substr(pos, 1) === "e") {
                  var result13 = "e";
                  pos += 1;
                } else {
                  var result13 = null;
                  if (reportMatchFailures) {
                    matchFailed("\"e\"");
                  }
                }
                if (result13 !== null) {
                  var result5 = result13;
                } else {
                  var result5 = null;;
                };
              }
              if (result5 !== null) {
                if (input.substr(pos, 1) === "T") {
                  var result12 = "T";
                  pos += 1;
                } else {
                  var result12 = null;
                  if (reportMatchFailures) {
                    matchFailed("\"T\"");
                  }
                }
                if (result12 !== null) {
                  var result6 = result12;
                } else {
                  if (input.substr(pos, 1) === "t") {
                    var result11 = "t";
                    pos += 1;
                  } else {
                    var result11 = null;
                    if (reportMatchFailures) {
                      matchFailed("\"t\"");
                    }
                  }
                  if (result11 !== null) {
                    var result6 = result11;
                  } else {
                    var result6 = null;;
                  };
                }
                if (result6 !== null) {
                  if (input.substr(pos, 1) === "E") {
                    var result10 = "E";
                    pos += 1;
                  } else {
                    var result10 = null;
                    if (reportMatchFailures) {
                      matchFailed("\"E\"");
                    }
                  }
                  if (result10 !== null) {
                    var result7 = result10;
                  } else {
                    if (input.substr(pos, 1) === "e") {
                      var result9 = "e";
                      pos += 1;
                    } else {
                      var result9 = null;
                      if (reportMatchFailures) {
                        matchFailed("\"e\"");
                      }
                    }
                    if (result9 !== null) {
                      var result7 = result9;
                    } else {
                      var result7 = null;;
                    };
                  }
                  if (result7 !== null) {
                    var result8 = parse_QuadPattern();
                    if (result8 !== null) {
                      var result1 = [result2, result3, result4, result5, result6, result7, result8];
                    } else {
                      var result1 = null;
                      pos = savedPos0;
                    }
                  } else {
                    var result1 = null;
                    pos = savedPos0;
                  }
                } else {
                  var result1 = null;
                  pos = savedPos0;
                }
              } else {
                var result1 = null;
                pos = savedPos0;
              }
            } else {
              var result1 = null;
              pos = savedPos0;
            }
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        var result0 = result1 !== null
          ? (function(q) {
                return q;
          })(result1[6])
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[40] DeleteClause");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_InsertClause() {
        var cacheKey = 'InsertClause@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        if (input.substr(pos, 1) === "I") {
          var result20 = "I";
          pos += 1;
        } else {
          var result20 = null;
          if (reportMatchFailures) {
            matchFailed("\"I\"");
          }
        }
        if (result20 !== null) {
          var result2 = result20;
        } else {
          if (input.substr(pos, 1) === "i") {
            var result19 = "i";
            pos += 1;
          } else {
            var result19 = null;
            if (reportMatchFailures) {
              matchFailed("\"i\"");
            }
          }
          if (result19 !== null) {
            var result2 = result19;
          } else {
            var result2 = null;;
          };
        }
        if (result2 !== null) {
          if (input.substr(pos, 1) === "N") {
            var result18 = "N";
            pos += 1;
          } else {
            var result18 = null;
            if (reportMatchFailures) {
              matchFailed("\"N\"");
            }
          }
          if (result18 !== null) {
            var result3 = result18;
          } else {
            if (input.substr(pos, 1) === "n") {
              var result17 = "n";
              pos += 1;
            } else {
              var result17 = null;
              if (reportMatchFailures) {
                matchFailed("\"n\"");
              }
            }
            if (result17 !== null) {
              var result3 = result17;
            } else {
              var result3 = null;;
            };
          }
          if (result3 !== null) {
            if (input.substr(pos, 1) === "S") {
              var result16 = "S";
              pos += 1;
            } else {
              var result16 = null;
              if (reportMatchFailures) {
                matchFailed("\"S\"");
              }
            }
            if (result16 !== null) {
              var result4 = result16;
            } else {
              if (input.substr(pos, 1) === "s") {
                var result15 = "s";
                pos += 1;
              } else {
                var result15 = null;
                if (reportMatchFailures) {
                  matchFailed("\"s\"");
                }
              }
              if (result15 !== null) {
                var result4 = result15;
              } else {
                var result4 = null;;
              };
            }
            if (result4 !== null) {
              if (input.substr(pos, 1) === "E") {
                var result14 = "E";
                pos += 1;
              } else {
                var result14 = null;
                if (reportMatchFailures) {
                  matchFailed("\"E\"");
                }
              }
              if (result14 !== null) {
                var result5 = result14;
              } else {
                if (input.substr(pos, 1) === "e") {
                  var result13 = "e";
                  pos += 1;
                } else {
                  var result13 = null;
                  if (reportMatchFailures) {
                    matchFailed("\"e\"");
                  }
                }
                if (result13 !== null) {
                  var result5 = result13;
                } else {
                  var result5 = null;;
                };
              }
              if (result5 !== null) {
                if (input.substr(pos, 1) === "R") {
                  var result12 = "R";
                  pos += 1;
                } else {
                  var result12 = null;
                  if (reportMatchFailures) {
                    matchFailed("\"R\"");
                  }
                }
                if (result12 !== null) {
                  var result6 = result12;
                } else {
                  if (input.substr(pos, 1) === "r") {
                    var result11 = "r";
                    pos += 1;
                  } else {
                    var result11 = null;
                    if (reportMatchFailures) {
                      matchFailed("\"r\"");
                    }
                  }
                  if (result11 !== null) {
                    var result6 = result11;
                  } else {
                    var result6 = null;;
                  };
                }
                if (result6 !== null) {
                  if (input.substr(pos, 1) === "T") {
                    var result10 = "T";
                    pos += 1;
                  } else {
                    var result10 = null;
                    if (reportMatchFailures) {
                      matchFailed("\"T\"");
                    }
                  }
                  if (result10 !== null) {
                    var result7 = result10;
                  } else {
                    if (input.substr(pos, 1) === "t") {
                      var result9 = "t";
                      pos += 1;
                    } else {
                      var result9 = null;
                      if (reportMatchFailures) {
                        matchFailed("\"t\"");
                      }
                    }
                    if (result9 !== null) {
                      var result7 = result9;
                    } else {
                      var result7 = null;;
                    };
                  }
                  if (result7 !== null) {
                    var result8 = parse_QuadPattern();
                    if (result8 !== null) {
                      var result1 = [result2, result3, result4, result5, result6, result7, result8];
                    } else {
                      var result1 = null;
                      pos = savedPos0;
                    }
                  } else {
                    var result1 = null;
                    pos = savedPos0;
                  }
                } else {
                  var result1 = null;
                  pos = savedPos0;
                }
              } else {
                var result1 = null;
                pos = savedPos0;
              }
            } else {
              var result1 = null;
              pos = savedPos0;
            }
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        var result0 = result1 !== null
          ? (function(q) {
            return q;
          })(result1[6])
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[41] InsertClause");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_UsingClause() {
        var cacheKey = 'UsingClause@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        var result2 = [];
        var result41 = parse_WS();
        while (result41 !== null) {
          result2.push(result41);
          var result41 = parse_WS();
        }
        if (result2 !== null) {
          if (input.substr(pos, 1) === "U") {
            var result40 = "U";
            pos += 1;
          } else {
            var result40 = null;
            if (reportMatchFailures) {
              matchFailed("\"U\"");
            }
          }
          if (result40 !== null) {
            var result3 = result40;
          } else {
            if (input.substr(pos, 1) === "u") {
              var result39 = "u";
              pos += 1;
            } else {
              var result39 = null;
              if (reportMatchFailures) {
                matchFailed("\"u\"");
              }
            }
            if (result39 !== null) {
              var result3 = result39;
            } else {
              var result3 = null;;
            };
          }
          if (result3 !== null) {
            if (input.substr(pos, 1) === "S") {
              var result38 = "S";
              pos += 1;
            } else {
              var result38 = null;
              if (reportMatchFailures) {
                matchFailed("\"S\"");
              }
            }
            if (result38 !== null) {
              var result4 = result38;
            } else {
              if (input.substr(pos, 1) === "s") {
                var result37 = "s";
                pos += 1;
              } else {
                var result37 = null;
                if (reportMatchFailures) {
                  matchFailed("\"s\"");
                }
              }
              if (result37 !== null) {
                var result4 = result37;
              } else {
                var result4 = null;;
              };
            }
            if (result4 !== null) {
              if (input.substr(pos, 1) === "I") {
                var result36 = "I";
                pos += 1;
              } else {
                var result36 = null;
                if (reportMatchFailures) {
                  matchFailed("\"I\"");
                }
              }
              if (result36 !== null) {
                var result5 = result36;
              } else {
                if (input.substr(pos, 1) === "i") {
                  var result35 = "i";
                  pos += 1;
                } else {
                  var result35 = null;
                  if (reportMatchFailures) {
                    matchFailed("\"i\"");
                  }
                }
                if (result35 !== null) {
                  var result5 = result35;
                } else {
                  var result5 = null;;
                };
              }
              if (result5 !== null) {
                if (input.substr(pos, 1) === "N") {
                  var result34 = "N";
                  pos += 1;
                } else {
                  var result34 = null;
                  if (reportMatchFailures) {
                    matchFailed("\"N\"");
                  }
                }
                if (result34 !== null) {
                  var result6 = result34;
                } else {
                  if (input.substr(pos, 1) === "n") {
                    var result33 = "n";
                    pos += 1;
                  } else {
                    var result33 = null;
                    if (reportMatchFailures) {
                      matchFailed("\"n\"");
                    }
                  }
                  if (result33 !== null) {
                    var result6 = result33;
                  } else {
                    var result6 = null;;
                  };
                }
                if (result6 !== null) {
                  if (input.substr(pos, 1) === "G") {
                    var result32 = "G";
                    pos += 1;
                  } else {
                    var result32 = null;
                    if (reportMatchFailures) {
                      matchFailed("\"G\"");
                    }
                  }
                  if (result32 !== null) {
                    var result7 = result32;
                  } else {
                    if (input.substr(pos, 1) === "g") {
                      var result31 = "g";
                      pos += 1;
                    } else {
                      var result31 = null;
                      if (reportMatchFailures) {
                        matchFailed("\"g\"");
                      }
                    }
                    if (result31 !== null) {
                      var result7 = result31;
                    } else {
                      var result7 = null;;
                    };
                  }
                  if (result7 !== null) {
                    var result8 = [];
                    var result30 = parse_WS();
                    while (result30 !== null) {
                      result8.push(result30);
                      var result30 = parse_WS();
                    }
                    if (result8 !== null) {
                      var result29 = parse_IRIref();
                      if (result29 !== null) {
                        var result9 = result29;
                      } else {
                        var savedPos1 = pos;
                        if (input.substr(pos, 1) === "N") {
                          var result28 = "N";
                          pos += 1;
                        } else {
                          var result28 = null;
                          if (reportMatchFailures) {
                            matchFailed("\"N\"");
                          }
                        }
                        if (result28 !== null) {
                          var result11 = result28;
                        } else {
                          if (input.substr(pos, 1) === "n") {
                            var result27 = "n";
                            pos += 1;
                          } else {
                            var result27 = null;
                            if (reportMatchFailures) {
                              matchFailed("\"n\"");
                            }
                          }
                          if (result27 !== null) {
                            var result11 = result27;
                          } else {
                            var result11 = null;;
                          };
                        }
                        if (result11 !== null) {
                          if (input.substr(pos, 1) === "A") {
                            var result26 = "A";
                            pos += 1;
                          } else {
                            var result26 = null;
                            if (reportMatchFailures) {
                              matchFailed("\"A\"");
                            }
                          }
                          if (result26 !== null) {
                            var result12 = result26;
                          } else {
                            if (input.substr(pos, 1) === "a") {
                              var result25 = "a";
                              pos += 1;
                            } else {
                              var result25 = null;
                              if (reportMatchFailures) {
                                matchFailed("\"a\"");
                              }
                            }
                            if (result25 !== null) {
                              var result12 = result25;
                            } else {
                              var result12 = null;;
                            };
                          }
                          if (result12 !== null) {
                            if (input.substr(pos, 1) === "M") {
                              var result24 = "M";
                              pos += 1;
                            } else {
                              var result24 = null;
                              if (reportMatchFailures) {
                                matchFailed("\"M\"");
                              }
                            }
                            if (result24 !== null) {
                              var result13 = result24;
                            } else {
                              if (input.substr(pos, 1) === "m") {
                                var result23 = "m";
                                pos += 1;
                              } else {
                                var result23 = null;
                                if (reportMatchFailures) {
                                  matchFailed("\"m\"");
                                }
                              }
                              if (result23 !== null) {
                                var result13 = result23;
                              } else {
                                var result13 = null;;
                              };
                            }
                            if (result13 !== null) {
                              if (input.substr(pos, 1) === "E") {
                                var result22 = "E";
                                pos += 1;
                              } else {
                                var result22 = null;
                                if (reportMatchFailures) {
                                  matchFailed("\"E\"");
                                }
                              }
                              if (result22 !== null) {
                                var result14 = result22;
                              } else {
                                if (input.substr(pos, 1) === "e") {
                                  var result21 = "e";
                                  pos += 1;
                                } else {
                                  var result21 = null;
                                  if (reportMatchFailures) {
                                    matchFailed("\"e\"");
                                  }
                                }
                                if (result21 !== null) {
                                  var result14 = result21;
                                } else {
                                  var result14 = null;;
                                };
                              }
                              if (result14 !== null) {
                                if (input.substr(pos, 1) === "D") {
                                  var result20 = "D";
                                  pos += 1;
                                } else {
                                  var result20 = null;
                                  if (reportMatchFailures) {
                                    matchFailed("\"D\"");
                                  }
                                }
                                if (result20 !== null) {
                                  var result15 = result20;
                                } else {
                                  if (input.substr(pos, 1) === "d") {
                                    var result19 = "d";
                                    pos += 1;
                                  } else {
                                    var result19 = null;
                                    if (reportMatchFailures) {
                                      matchFailed("\"d\"");
                                    }
                                  }
                                  if (result19 !== null) {
                                    var result15 = result19;
                                  } else {
                                    var result15 = null;;
                                  };
                                }
                                if (result15 !== null) {
                                  var result16 = [];
                                  var result18 = parse_WS();
                                  while (result18 !== null) {
                                    result16.push(result18);
                                    var result18 = parse_WS();
                                  }
                                  if (result16 !== null) {
                                    var result17 = parse_IRIref();
                                    if (result17 !== null) {
                                      var result10 = [result11, result12, result13, result14, result15, result16, result17];
                                    } else {
                                      var result10 = null;
                                      pos = savedPos1;
                                    }
                                  } else {
                                    var result10 = null;
                                    pos = savedPos1;
                                  }
                                } else {
                                  var result10 = null;
                                  pos = savedPos1;
                                }
                              } else {
                                var result10 = null;
                                pos = savedPos1;
                              }
                            } else {
                              var result10 = null;
                              pos = savedPos1;
                            }
                          } else {
                            var result10 = null;
                            pos = savedPos1;
                          }
                        } else {
                          var result10 = null;
                          pos = savedPos1;
                        }
                        if (result10 !== null) {
                          var result9 = result10;
                        } else {
                          var result9 = null;;
                        };
                      }
                      if (result9 !== null) {
                        var result1 = [result2, result3, result4, result5, result6, result7, result8, result9];
                      } else {
                        var result1 = null;
                        pos = savedPos0;
                      }
                    } else {
                      var result1 = null;
                      pos = savedPos0;
                    }
                  } else {
                    var result1 = null;
                    pos = savedPos0;
                  }
                } else {
                  var result1 = null;
                  pos = savedPos0;
                }
              } else {
                var result1 = null;
                pos = savedPos0;
              }
            } else {
              var result1 = null;
              pos = savedPos0;
            }
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        var result0 = result1 !== null
          ? (function(g) {
                if(g.length!=null) {
                    return {kind: 'named', uri: g[6]};
                } else {
                    return {kind: 'default', uri: g};
                }
          })(result1[7])
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[42] UsingClause");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_GraphRef() {
        var cacheKey = 'GraphRef@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        if (input.substr(pos, 1) === "G") {
          var result19 = "G";
          pos += 1;
        } else {
          var result19 = null;
          if (reportMatchFailures) {
            matchFailed("\"G\"");
          }
        }
        if (result19 !== null) {
          var result2 = result19;
        } else {
          if (input.substr(pos, 1) === "g") {
            var result18 = "g";
            pos += 1;
          } else {
            var result18 = null;
            if (reportMatchFailures) {
              matchFailed("\"g\"");
            }
          }
          if (result18 !== null) {
            var result2 = result18;
          } else {
            var result2 = null;;
          };
        }
        if (result2 !== null) {
          if (input.substr(pos, 1) === "R") {
            var result17 = "R";
            pos += 1;
          } else {
            var result17 = null;
            if (reportMatchFailures) {
              matchFailed("\"R\"");
            }
          }
          if (result17 !== null) {
            var result3 = result17;
          } else {
            if (input.substr(pos, 1) === "r") {
              var result16 = "r";
              pos += 1;
            } else {
              var result16 = null;
              if (reportMatchFailures) {
                matchFailed("\"r\"");
              }
            }
            if (result16 !== null) {
              var result3 = result16;
            } else {
              var result3 = null;;
            };
          }
          if (result3 !== null) {
            if (input.substr(pos, 1) === "A") {
              var result15 = "A";
              pos += 1;
            } else {
              var result15 = null;
              if (reportMatchFailures) {
                matchFailed("\"A\"");
              }
            }
            if (result15 !== null) {
              var result4 = result15;
            } else {
              if (input.substr(pos, 1) === "a") {
                var result14 = "a";
                pos += 1;
              } else {
                var result14 = null;
                if (reportMatchFailures) {
                  matchFailed("\"a\"");
                }
              }
              if (result14 !== null) {
                var result4 = result14;
              } else {
                var result4 = null;;
              };
            }
            if (result4 !== null) {
              if (input.substr(pos, 1) === "P") {
                var result13 = "P";
                pos += 1;
              } else {
                var result13 = null;
                if (reportMatchFailures) {
                  matchFailed("\"P\"");
                }
              }
              if (result13 !== null) {
                var result5 = result13;
              } else {
                if (input.substr(pos, 1) === "p") {
                  var result12 = "p";
                  pos += 1;
                } else {
                  var result12 = null;
                  if (reportMatchFailures) {
                    matchFailed("\"p\"");
                  }
                }
                if (result12 !== null) {
                  var result5 = result12;
                } else {
                  var result5 = null;;
                };
              }
              if (result5 !== null) {
                if (input.substr(pos, 1) === "H") {
                  var result11 = "H";
                  pos += 1;
                } else {
                  var result11 = null;
                  if (reportMatchFailures) {
                    matchFailed("\"H\"");
                  }
                }
                if (result11 !== null) {
                  var result6 = result11;
                } else {
                  if (input.substr(pos, 1) === "h") {
                    var result10 = "h";
                    pos += 1;
                  } else {
                    var result10 = null;
                    if (reportMatchFailures) {
                      matchFailed("\"h\"");
                    }
                  }
                  if (result10 !== null) {
                    var result6 = result10;
                  } else {
                    var result6 = null;;
                  };
                }
                if (result6 !== null) {
                  var result7 = [];
                  var result9 = parse_WS();
                  while (result9 !== null) {
                    result7.push(result9);
                    var result9 = parse_WS();
                  }
                  if (result7 !== null) {
                    var result8 = parse_IRIref();
                    if (result8 !== null) {
                      var result1 = [result2, result3, result4, result5, result6, result7, result8];
                    } else {
                      var result1 = null;
                      pos = savedPos0;
                    }
                  } else {
                    var result1 = null;
                    pos = savedPos0;
                  }
                } else {
                  var result1 = null;
                  pos = savedPos0;
                }
              } else {
                var result1 = null;
                pos = savedPos0;
              }
            } else {
              var result1 = null;
              pos = savedPos0;
            }
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        var result0 = result1 !== null
          ? (function(i) {
                return i;
          })(result1[6])
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[43] GraphRef");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_GraphRefAll() {
        var cacheKey = 'GraphRefAll@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var result53 = parse_GraphRef();
        var result52 = result53 !== null
          ? (function(g) {
                return g;
          })(result53)
          : null;
        if (result52 !== null) {
          var result0 = result52;
        } else {
          var savedPos2 = pos;
          if (input.substr(pos, 1) === "D") {
            var result51 = "D";
            pos += 1;
          } else {
            var result51 = null;
            if (reportMatchFailures) {
              matchFailed("\"D\"");
            }
          }
          if (result51 !== null) {
            var result31 = result51;
          } else {
            if (input.substr(pos, 1) === "d") {
              var result50 = "d";
              pos += 1;
            } else {
              var result50 = null;
              if (reportMatchFailures) {
                matchFailed("\"d\"");
              }
            }
            if (result50 !== null) {
              var result31 = result50;
            } else {
              var result31 = null;;
            };
          }
          if (result31 !== null) {
            if (input.substr(pos, 1) === "E") {
              var result49 = "E";
              pos += 1;
            } else {
              var result49 = null;
              if (reportMatchFailures) {
                matchFailed("\"E\"");
              }
            }
            if (result49 !== null) {
              var result32 = result49;
            } else {
              if (input.substr(pos, 1) === "e") {
                var result48 = "e";
                pos += 1;
              } else {
                var result48 = null;
                if (reportMatchFailures) {
                  matchFailed("\"e\"");
                }
              }
              if (result48 !== null) {
                var result32 = result48;
              } else {
                var result32 = null;;
              };
            }
            if (result32 !== null) {
              if (input.substr(pos, 1) === "F") {
                var result47 = "F";
                pos += 1;
              } else {
                var result47 = null;
                if (reportMatchFailures) {
                  matchFailed("\"F\"");
                }
              }
              if (result47 !== null) {
                var result33 = result47;
              } else {
                if (input.substr(pos, 1) === "f") {
                  var result46 = "f";
                  pos += 1;
                } else {
                  var result46 = null;
                  if (reportMatchFailures) {
                    matchFailed("\"f\"");
                  }
                }
                if (result46 !== null) {
                  var result33 = result46;
                } else {
                  var result33 = null;;
                };
              }
              if (result33 !== null) {
                if (input.substr(pos, 1) === "A") {
                  var result45 = "A";
                  pos += 1;
                } else {
                  var result45 = null;
                  if (reportMatchFailures) {
                    matchFailed("\"A\"");
                  }
                }
                if (result45 !== null) {
                  var result34 = result45;
                } else {
                  if (input.substr(pos, 1) === "a") {
                    var result44 = "a";
                    pos += 1;
                  } else {
                    var result44 = null;
                    if (reportMatchFailures) {
                      matchFailed("\"a\"");
                    }
                  }
                  if (result44 !== null) {
                    var result34 = result44;
                  } else {
                    var result34 = null;;
                  };
                }
                if (result34 !== null) {
                  if (input.substr(pos, 1) === "U") {
                    var result43 = "U";
                    pos += 1;
                  } else {
                    var result43 = null;
                    if (reportMatchFailures) {
                      matchFailed("\"U\"");
                    }
                  }
                  if (result43 !== null) {
                    var result35 = result43;
                  } else {
                    if (input.substr(pos, 1) === "u") {
                      var result42 = "u";
                      pos += 1;
                    } else {
                      var result42 = null;
                      if (reportMatchFailures) {
                        matchFailed("\"u\"");
                      }
                    }
                    if (result42 !== null) {
                      var result35 = result42;
                    } else {
                      var result35 = null;;
                    };
                  }
                  if (result35 !== null) {
                    if (input.substr(pos, 1) === "L") {
                      var result41 = "L";
                      pos += 1;
                    } else {
                      var result41 = null;
                      if (reportMatchFailures) {
                        matchFailed("\"L\"");
                      }
                    }
                    if (result41 !== null) {
                      var result36 = result41;
                    } else {
                      if (input.substr(pos, 1) === "l") {
                        var result40 = "l";
                        pos += 1;
                      } else {
                        var result40 = null;
                        if (reportMatchFailures) {
                          matchFailed("\"l\"");
                        }
                      }
                      if (result40 !== null) {
                        var result36 = result40;
                      } else {
                        var result36 = null;;
                      };
                    }
                    if (result36 !== null) {
                      if (input.substr(pos, 1) === "T") {
                        var result39 = "T";
                        pos += 1;
                      } else {
                        var result39 = null;
                        if (reportMatchFailures) {
                          matchFailed("\"T\"");
                        }
                      }
                      if (result39 !== null) {
                        var result37 = result39;
                      } else {
                        if (input.substr(pos, 1) === "t") {
                          var result38 = "t";
                          pos += 1;
                        } else {
                          var result38 = null;
                          if (reportMatchFailures) {
                            matchFailed("\"t\"");
                          }
                        }
                        if (result38 !== null) {
                          var result37 = result38;
                        } else {
                          var result37 = null;;
                        };
                      }
                      if (result37 !== null) {
                        var result30 = [result31, result32, result33, result34, result35, result36, result37];
                      } else {
                        var result30 = null;
                        pos = savedPos2;
                      }
                    } else {
                      var result30 = null;
                      pos = savedPos2;
                    }
                  } else {
                    var result30 = null;
                    pos = savedPos2;
                  }
                } else {
                  var result30 = null;
                  pos = savedPos2;
                }
              } else {
                var result30 = null;
                pos = savedPos2;
              }
            } else {
              var result30 = null;
              pos = savedPos2;
            }
          } else {
            var result30 = null;
            pos = savedPos2;
          }
          var result29 = result30 !== null
            ? (function() {
                  return 'default';
            })()
            : null;
          if (result29 !== null) {
            var result0 = result29;
          } else {
            var savedPos1 = pos;
            if (input.substr(pos, 1) === "N") {
              var result28 = "N";
              pos += 1;
            } else {
              var result28 = null;
              if (reportMatchFailures) {
                matchFailed("\"N\"");
              }
            }
            if (result28 !== null) {
              var result14 = result28;
            } else {
              if (input.substr(pos, 1) === "n") {
                var result27 = "n";
                pos += 1;
              } else {
                var result27 = null;
                if (reportMatchFailures) {
                  matchFailed("\"n\"");
                }
              }
              if (result27 !== null) {
                var result14 = result27;
              } else {
                var result14 = null;;
              };
            }
            if (result14 !== null) {
              if (input.substr(pos, 1) === "A") {
                var result26 = "A";
                pos += 1;
              } else {
                var result26 = null;
                if (reportMatchFailures) {
                  matchFailed("\"A\"");
                }
              }
              if (result26 !== null) {
                var result15 = result26;
              } else {
                if (input.substr(pos, 1) === "a") {
                  var result25 = "a";
                  pos += 1;
                } else {
                  var result25 = null;
                  if (reportMatchFailures) {
                    matchFailed("\"a\"");
                  }
                }
                if (result25 !== null) {
                  var result15 = result25;
                } else {
                  var result15 = null;;
                };
              }
              if (result15 !== null) {
                if (input.substr(pos, 1) === "M") {
                  var result24 = "M";
                  pos += 1;
                } else {
                  var result24 = null;
                  if (reportMatchFailures) {
                    matchFailed("\"M\"");
                  }
                }
                if (result24 !== null) {
                  var result16 = result24;
                } else {
                  if (input.substr(pos, 1) === "m") {
                    var result23 = "m";
                    pos += 1;
                  } else {
                    var result23 = null;
                    if (reportMatchFailures) {
                      matchFailed("\"m\"");
                    }
                  }
                  if (result23 !== null) {
                    var result16 = result23;
                  } else {
                    var result16 = null;;
                  };
                }
                if (result16 !== null) {
                  if (input.substr(pos, 1) === "E") {
                    var result22 = "E";
                    pos += 1;
                  } else {
                    var result22 = null;
                    if (reportMatchFailures) {
                      matchFailed("\"E\"");
                    }
                  }
                  if (result22 !== null) {
                    var result17 = result22;
                  } else {
                    if (input.substr(pos, 1) === "e") {
                      var result21 = "e";
                      pos += 1;
                    } else {
                      var result21 = null;
                      if (reportMatchFailures) {
                        matchFailed("\"e\"");
                      }
                    }
                    if (result21 !== null) {
                      var result17 = result21;
                    } else {
                      var result17 = null;;
                    };
                  }
                  if (result17 !== null) {
                    if (input.substr(pos, 1) === "D") {
                      var result20 = "D";
                      pos += 1;
                    } else {
                      var result20 = null;
                      if (reportMatchFailures) {
                        matchFailed("\"D\"");
                      }
                    }
                    if (result20 !== null) {
                      var result18 = result20;
                    } else {
                      if (input.substr(pos, 1) === "d") {
                        var result19 = "d";
                        pos += 1;
                      } else {
                        var result19 = null;
                        if (reportMatchFailures) {
                          matchFailed("\"d\"");
                        }
                      }
                      if (result19 !== null) {
                        var result18 = result19;
                      } else {
                        var result18 = null;;
                      };
                    }
                    if (result18 !== null) {
                      var result13 = [result14, result15, result16, result17, result18];
                    } else {
                      var result13 = null;
                      pos = savedPos1;
                    }
                  } else {
                    var result13 = null;
                    pos = savedPos1;
                  }
                } else {
                  var result13 = null;
                  pos = savedPos1;
                }
              } else {
                var result13 = null;
                pos = savedPos1;
              }
            } else {
              var result13 = null;
              pos = savedPos1;
            }
            var result12 = result13 !== null
              ? (function() {
                    return 'named';
              })()
              : null;
            if (result12 !== null) {
              var result0 = result12;
            } else {
              var savedPos0 = pos;
              if (input.substr(pos, 1) === "A") {
                var result11 = "A";
                pos += 1;
              } else {
                var result11 = null;
                if (reportMatchFailures) {
                  matchFailed("\"A\"");
                }
              }
              if (result11 !== null) {
                var result3 = result11;
              } else {
                if (input.substr(pos, 1) === "a") {
                  var result10 = "a";
                  pos += 1;
                } else {
                  var result10 = null;
                  if (reportMatchFailures) {
                    matchFailed("\"a\"");
                  }
                }
                if (result10 !== null) {
                  var result3 = result10;
                } else {
                  var result3 = null;;
                };
              }
              if (result3 !== null) {
                if (input.substr(pos, 1) === "L") {
                  var result9 = "L";
                  pos += 1;
                } else {
                  var result9 = null;
                  if (reportMatchFailures) {
                    matchFailed("\"L\"");
                  }
                }
                if (result9 !== null) {
                  var result4 = result9;
                } else {
                  if (input.substr(pos, 1) === "l") {
                    var result8 = "l";
                    pos += 1;
                  } else {
                    var result8 = null;
                    if (reportMatchFailures) {
                      matchFailed("\"l\"");
                    }
                  }
                  if (result8 !== null) {
                    var result4 = result8;
                  } else {
                    var result4 = null;;
                  };
                }
                if (result4 !== null) {
                  if (input.substr(pos, 1) === "L") {
                    var result7 = "L";
                    pos += 1;
                  } else {
                    var result7 = null;
                    if (reportMatchFailures) {
                      matchFailed("\"L\"");
                    }
                  }
                  if (result7 !== null) {
                    var result5 = result7;
                  } else {
                    if (input.substr(pos, 1) === "l") {
                      var result6 = "l";
                      pos += 1;
                    } else {
                      var result6 = null;
                      if (reportMatchFailures) {
                        matchFailed("\"l\"");
                      }
                    }
                    if (result6 !== null) {
                      var result5 = result6;
                    } else {
                      var result5 = null;;
                    };
                  }
                  if (result5 !== null) {
                    var result2 = [result3, result4, result5];
                  } else {
                    var result2 = null;
                    pos = savedPos0;
                  }
                } else {
                  var result2 = null;
                  pos = savedPos0;
                }
              } else {
                var result2 = null;
                pos = savedPos0;
              }
              var result1 = result2 !== null
                ? (function() {
                      return 'all';
                })()
                : null;
              if (result1 !== null) {
                var result0 = result1;
              } else {
                var result0 = null;;
              };
            };
          };
        }
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[44] GraphRefAll");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_QuadPattern() {
        var cacheKey = 'QuadPattern@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        var result2 = [];
        var result12 = parse_WS();
        while (result12 !== null) {
          result2.push(result12);
          var result12 = parse_WS();
        }
        if (result2 !== null) {
          if (input.substr(pos, 1) === "{") {
            var result3 = "{";
            pos += 1;
          } else {
            var result3 = null;
            if (reportMatchFailures) {
              matchFailed("\"{\"");
            }
          }
          if (result3 !== null) {
            var result4 = [];
            var result11 = parse_WS();
            while (result11 !== null) {
              result4.push(result11);
              var result11 = parse_WS();
            }
            if (result4 !== null) {
              var result5 = parse_Quads();
              if (result5 !== null) {
                var result6 = [];
                var result10 = parse_WS();
                while (result10 !== null) {
                  result6.push(result10);
                  var result10 = parse_WS();
                }
                if (result6 !== null) {
                  if (input.substr(pos, 1) === "}") {
                    var result7 = "}";
                    pos += 1;
                  } else {
                    var result7 = null;
                    if (reportMatchFailures) {
                      matchFailed("\"}\"");
                    }
                  }
                  if (result7 !== null) {
                    var result8 = [];
                    var result9 = parse_WS();
                    while (result9 !== null) {
                      result8.push(result9);
                      var result9 = parse_WS();
                    }
                    if (result8 !== null) {
                      var result1 = [result2, result3, result4, result5, result6, result7, result8];
                    } else {
                      var result1 = null;
                      pos = savedPos0;
                    }
                  } else {
                    var result1 = null;
                    pos = savedPos0;
                  }
                } else {
                  var result1 = null;
                  pos = savedPos0;
                }
              } else {
                var result1 = null;
                pos = savedPos0;
              }
            } else {
              var result1 = null;
              pos = savedPos0;
            }
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        var result0 = result1 !== null
          ? (function(qs) {
                return qs.quadsContext;
          })(result1[3])
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[45] QuadPattern");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_QuadData() {
        var cacheKey = 'QuadData@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        var result2 = [];
        var result12 = parse_WS();
        while (result12 !== null) {
          result2.push(result12);
          var result12 = parse_WS();
        }
        if (result2 !== null) {
          if (input.substr(pos, 1) === "{") {
            var result3 = "{";
            pos += 1;
          } else {
            var result3 = null;
            if (reportMatchFailures) {
              matchFailed("\"{\"");
            }
          }
          if (result3 !== null) {
            var result4 = [];
            var result11 = parse_WS();
            while (result11 !== null) {
              result4.push(result11);
              var result11 = parse_WS();
            }
            if (result4 !== null) {
              var result5 = parse_Quads();
              if (result5 !== null) {
                var result6 = [];
                var result10 = parse_WS();
                while (result10 !== null) {
                  result6.push(result10);
                  var result10 = parse_WS();
                }
                if (result6 !== null) {
                  if (input.substr(pos, 1) === "}") {
                    var result7 = "}";
                    pos += 1;
                  } else {
                    var result7 = null;
                    if (reportMatchFailures) {
                      matchFailed("\"}\"");
                    }
                  }
                  if (result7 !== null) {
                    var result8 = [];
                    var result9 = parse_WS();
                    while (result9 !== null) {
                      result8.push(result9);
                      var result9 = parse_WS();
                    }
                    if (result8 !== null) {
                      var result1 = [result2, result3, result4, result5, result6, result7, result8];
                    } else {
                      var result1 = null;
                      pos = savedPos0;
                    }
                  } else {
                    var result1 = null;
                    pos = savedPos0;
                  }
                } else {
                  var result1 = null;
                  pos = savedPos0;
                }
              } else {
                var result1 = null;
                pos = savedPos0;
              }
            } else {
              var result1 = null;
              pos = savedPos0;
            }
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        var result0 = result1 !== null
          ? (function(qs) {
                return qs.quadsContext;
          })(result1[3])
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[46] QuadData");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_Quads() {
        var cacheKey = 'Quads@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        var result10 = parse_TriplesTemplate();
        var result2 = result10 !== null ? result10 : '';
        if (result2 !== null) {
          var result3 = [];
          var savedPos1 = pos;
          var result5 = parse_QuadsNotTriples();
          if (result5 !== null) {
            if (input.substr(pos, 1) === ".") {
              var result9 = ".";
              pos += 1;
            } else {
              var result9 = null;
              if (reportMatchFailures) {
                matchFailed("\".\"");
              }
            }
            var result6 = result9 !== null ? result9 : '';
            if (result6 !== null) {
              var result8 = parse_TriplesTemplate();
              var result7 = result8 !== null ? result8 : '';
              if (result7 !== null) {
                var result4 = [result5, result6, result7];
              } else {
                var result4 = null;
                pos = savedPos1;
              }
            } else {
              var result4 = null;
              pos = savedPos1;
            }
          } else {
            var result4 = null;
            pos = savedPos1;
          }
          while (result4 !== null) {
            result3.push(result4);
            var savedPos1 = pos;
            var result5 = parse_QuadsNotTriples();
            if (result5 !== null) {
              if (input.substr(pos, 1) === ".") {
                var result9 = ".";
                pos += 1;
              } else {
                var result9 = null;
                if (reportMatchFailures) {
                  matchFailed("\".\"");
                }
              }
              var result6 = result9 !== null ? result9 : '';
              if (result6 !== null) {
                var result8 = parse_TriplesTemplate();
                var result7 = result8 !== null ? result8 : '';
                if (result7 !== null) {
                  var result4 = [result5, result6, result7];
                } else {
                  var result4 = null;
                  pos = savedPos1;
                }
              } else {
                var result4 = null;
                pos = savedPos1;
              }
            } else {
              var result4 = null;
              pos = savedPos1;
            }
          }
          if (result3 !== null) {
            var result1 = [result2, result3];
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        var result0 = result1 !== null
          ? (function(ts, qs) {
                var quads = []
                if(ts.triplesContext != null && ts.triplesContext != null) {
                  for(var i=0; i<ts.triplesContext.length; i++) {
                      var triple = ts.triplesContext[i]
                      triple.graph = null;
                      quads.push(triple)
                  }
                }
          
                if(qs && qs.length>0 && qs[0].length > 0) {
                    quads = quads.concat(qs[0][0].quadsContext);
          
                    if( qs[0][2] != null && qs[0][2].triplesContext != null) {
                      for(var i=0; i<qs[0][2].triplesContext.length; i++) {
                          var triple = qs[0][2].triplesContext[i]
                          triple.graph = null;
                          quads.push(triple)
                      }
                    }
                }
          
                return {token:'quads',
                        quadsContext: quads}
          })(result1[0], result1[1])
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[47] Quads");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_QuadsNotTriples() {
        var cacheKey = 'QuadsNotTriples@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        var result2 = [];
        var result33 = parse_WS();
        while (result33 !== null) {
          result2.push(result33);
          var result33 = parse_WS();
        }
        if (result2 !== null) {
          if (input.substr(pos, 1) === "G") {
            var result32 = "G";
            pos += 1;
          } else {
            var result32 = null;
            if (reportMatchFailures) {
              matchFailed("\"G\"");
            }
          }
          if (result32 !== null) {
            var result3 = result32;
          } else {
            if (input.substr(pos, 1) === "g") {
              var result31 = "g";
              pos += 1;
            } else {
              var result31 = null;
              if (reportMatchFailures) {
                matchFailed("\"g\"");
              }
            }
            if (result31 !== null) {
              var result3 = result31;
            } else {
              var result3 = null;;
            };
          }
          if (result3 !== null) {
            if (input.substr(pos, 1) === "R") {
              var result30 = "R";
              pos += 1;
            } else {
              var result30 = null;
              if (reportMatchFailures) {
                matchFailed("\"R\"");
              }
            }
            if (result30 !== null) {
              var result4 = result30;
            } else {
              if (input.substr(pos, 1) === "r") {
                var result29 = "r";
                pos += 1;
              } else {
                var result29 = null;
                if (reportMatchFailures) {
                  matchFailed("\"r\"");
                }
              }
              if (result29 !== null) {
                var result4 = result29;
              } else {
                var result4 = null;;
              };
            }
            if (result4 !== null) {
              if (input.substr(pos, 1) === "A") {
                var result28 = "A";
                pos += 1;
              } else {
                var result28 = null;
                if (reportMatchFailures) {
                  matchFailed("\"A\"");
                }
              }
              if (result28 !== null) {
                var result5 = result28;
              } else {
                if (input.substr(pos, 1) === "a") {
                  var result27 = "a";
                  pos += 1;
                } else {
                  var result27 = null;
                  if (reportMatchFailures) {
                    matchFailed("\"a\"");
                  }
                }
                if (result27 !== null) {
                  var result5 = result27;
                } else {
                  var result5 = null;;
                };
              }
              if (result5 !== null) {
                if (input.substr(pos, 1) === "P") {
                  var result26 = "P";
                  pos += 1;
                } else {
                  var result26 = null;
                  if (reportMatchFailures) {
                    matchFailed("\"P\"");
                  }
                }
                if (result26 !== null) {
                  var result6 = result26;
                } else {
                  if (input.substr(pos, 1) === "p") {
                    var result25 = "p";
                    pos += 1;
                  } else {
                    var result25 = null;
                    if (reportMatchFailures) {
                      matchFailed("\"p\"");
                    }
                  }
                  if (result25 !== null) {
                    var result6 = result25;
                  } else {
                    var result6 = null;;
                  };
                }
                if (result6 !== null) {
                  if (input.substr(pos, 1) === "H") {
                    var result24 = "H";
                    pos += 1;
                  } else {
                    var result24 = null;
                    if (reportMatchFailures) {
                      matchFailed("\"H\"");
                    }
                  }
                  if (result24 !== null) {
                    var result7 = result24;
                  } else {
                    if (input.substr(pos, 1) === "h") {
                      var result23 = "h";
                      pos += 1;
                    } else {
                      var result23 = null;
                      if (reportMatchFailures) {
                        matchFailed("\"h\"");
                      }
                    }
                    if (result23 !== null) {
                      var result7 = result23;
                    } else {
                      var result7 = null;;
                    };
                  }
                  if (result7 !== null) {
                    var result8 = [];
                    var result22 = parse_WS();
                    while (result22 !== null) {
                      result8.push(result22);
                      var result22 = parse_WS();
                    }
                    if (result8 !== null) {
                      var result9 = parse_VarOrIRIref();
                      if (result9 !== null) {
                        var result10 = [];
                        var result21 = parse_WS();
                        while (result21 !== null) {
                          result10.push(result21);
                          var result21 = parse_WS();
                        }
                        if (result10 !== null) {
                          if (input.substr(pos, 1) === "{") {
                            var result11 = "{";
                            pos += 1;
                          } else {
                            var result11 = null;
                            if (reportMatchFailures) {
                              matchFailed("\"{\"");
                            }
                          }
                          if (result11 !== null) {
                            var result12 = [];
                            var result20 = parse_WS();
                            while (result20 !== null) {
                              result12.push(result20);
                              var result20 = parse_WS();
                            }
                            if (result12 !== null) {
                              var result19 = parse_TriplesTemplate();
                              var result13 = result19 !== null ? result19 : '';
                              if (result13 !== null) {
                                var result14 = [];
                                var result18 = parse_WS();
                                while (result18 !== null) {
                                  result14.push(result18);
                                  var result18 = parse_WS();
                                }
                                if (result14 !== null) {
                                  if (input.substr(pos, 1) === "}") {
                                    var result15 = "}";
                                    pos += 1;
                                  } else {
                                    var result15 = null;
                                    if (reportMatchFailures) {
                                      matchFailed("\"}\"");
                                    }
                                  }
                                  if (result15 !== null) {
                                    var result16 = [];
                                    var result17 = parse_WS();
                                    while (result17 !== null) {
                                      result16.push(result17);
                                      var result17 = parse_WS();
                                    }
                                    if (result16 !== null) {
                                      var result1 = [result2, result3, result4, result5, result6, result7, result8, result9, result10, result11, result12, result13, result14, result15, result16];
                                    } else {
                                      var result1 = null;
                                      pos = savedPos0;
                                    }
                                  } else {
                                    var result1 = null;
                                    pos = savedPos0;
                                  }
                                } else {
                                  var result1 = null;
                                  pos = savedPos0;
                                }
                              } else {
                                var result1 = null;
                                pos = savedPos0;
                              }
                            } else {
                              var result1 = null;
                              pos = savedPos0;
                            }
                          } else {
                            var result1 = null;
                            pos = savedPos0;
                          }
                        } else {
                          var result1 = null;
                          pos = savedPos0;
                        }
                      } else {
                        var result1 = null;
                        pos = savedPos0;
                      }
                    } else {
                      var result1 = null;
                      pos = savedPos0;
                    }
                  } else {
                    var result1 = null;
                    pos = savedPos0;
                  }
                } else {
                  var result1 = null;
                  pos = savedPos0;
                }
              } else {
                var result1 = null;
                pos = savedPos0;
              }
            } else {
              var result1 = null;
              pos = savedPos0;
            }
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        var result0 = result1 !== null
          ? (function(g, ts) {
                var quads = []
                for(var i=0; i<ts.triplesContext.length; i++) {
                    var triple = ts.triplesContext[i]
                    triple.graph = g;
                    quads.push(triple)
                }
          
                return {token:'quadsnottriples',
                        quadsContext: quads}
          })(result1[7], result1[11])
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[48] QuadsNotTriples");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_TriplesTemplate() {
        var cacheKey = 'TriplesTemplate@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        var result2 = parse_TriplesSameSubject();
        if (result2 !== null) {
          var savedPos1 = pos;
          var result5 = [];
          var result11 = parse_WS();
          while (result11 !== null) {
            result5.push(result11);
            var result11 = parse_WS();
          }
          if (result5 !== null) {
            if (input.substr(pos, 1) === ".") {
              var result6 = ".";
              pos += 1;
            } else {
              var result6 = null;
              if (reportMatchFailures) {
                matchFailed("\".\"");
              }
            }
            if (result6 !== null) {
              var result7 = [];
              var result10 = parse_WS();
              while (result10 !== null) {
                result7.push(result10);
                var result10 = parse_WS();
              }
              if (result7 !== null) {
                var result9 = parse_TriplesTemplate();
                var result8 = result9 !== null ? result9 : '';
                if (result8 !== null) {
                  var result4 = [result5, result6, result7, result8];
                } else {
                  var result4 = null;
                  pos = savedPos1;
                }
              } else {
                var result4 = null;
                pos = savedPos1;
              }
            } else {
              var result4 = null;
              pos = savedPos1;
            }
          } else {
            var result4 = null;
            pos = savedPos1;
          }
          var result3 = result4 !== null ? result4 : '';
          if (result3 !== null) {
            var result1 = [result2, result3];
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        var result0 = result1 !== null
          ? (function(b, bs) {
               var triples = b.triplesContext;
               var toTest = null;
                if(typeof(bs) === 'object') {
                      if(bs.length != null) {
                            if(bs[3].triplesContext!=null) {
                               triples = triples.concat(bs[3].triplesContext);
                        }
                     }
                }
          
               return {token:'triplestemplate',
                       triplesContext: triples}
          })(result1[0], result1[1])
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[49] TriplesTemplate");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_GroupGraphPattern() {
        var cacheKey = 'GroupGraphPattern@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos1 = pos;
        if (input.substr(pos, 1) === "{") {
          var result12 = "{";
          pos += 1;
        } else {
          var result12 = null;
          if (reportMatchFailures) {
            matchFailed("\"{\"");
          }
        }
        if (result12 !== null) {
          var result13 = [];
          var result18 = parse_WS();
          while (result18 !== null) {
            result13.push(result18);
            var result18 = parse_WS();
          }
          if (result13 !== null) {
            var result14 = parse_SubSelect();
            if (result14 !== null) {
              var result15 = [];
              var result17 = parse_WS();
              while (result17 !== null) {
                result15.push(result17);
                var result17 = parse_WS();
              }
              if (result15 !== null) {
                if (input.substr(pos, 1) === "}") {
                  var result16 = "}";
                  pos += 1;
                } else {
                  var result16 = null;
                  if (reportMatchFailures) {
                    matchFailed("\"}\"");
                  }
                }
                if (result16 !== null) {
                  var result11 = [result12, result13, result14, result15, result16];
                } else {
                  var result11 = null;
                  pos = savedPos1;
                }
              } else {
                var result11 = null;
                pos = savedPos1;
              }
            } else {
              var result11 = null;
              pos = savedPos1;
            }
          } else {
            var result11 = null;
            pos = savedPos1;
          }
        } else {
          var result11 = null;
          pos = savedPos1;
        }
        var result10 = result11 !== null
          ? (function(p) {
                return p;
          })(result11[2])
          : null;
        if (result10 !== null) {
          var result0 = result10;
        } else {
          var savedPos0 = pos;
          if (input.substr(pos, 1) === "{") {
            var result3 = "{";
            pos += 1;
          } else {
            var result3 = null;
            if (reportMatchFailures) {
              matchFailed("\"{\"");
            }
          }
          if (result3 !== null) {
            var result4 = [];
            var result9 = parse_WS();
            while (result9 !== null) {
              result4.push(result9);
              var result9 = parse_WS();
            }
            if (result4 !== null) {
              var result5 = parse_GroupGraphPatternSub();
              if (result5 !== null) {
                var result6 = [];
                var result8 = parse_WS();
                while (result8 !== null) {
                  result6.push(result8);
                  var result8 = parse_WS();
                }
                if (result6 !== null) {
                  if (input.substr(pos, 1) === "}") {
                    var result7 = "}";
                    pos += 1;
                  } else {
                    var result7 = null;
                    if (reportMatchFailures) {
                      matchFailed("\"}\"");
                    }
                  }
                  if (result7 !== null) {
                    var result2 = [result3, result4, result5, result6, result7];
                  } else {
                    var result2 = null;
                    pos = savedPos0;
                  }
                } else {
                  var result2 = null;
                  pos = savedPos0;
                }
              } else {
                var result2 = null;
                pos = savedPos0;
              }
            } else {
              var result2 = null;
              pos = savedPos0;
            }
          } else {
            var result2 = null;
            pos = savedPos0;
          }
          var result1 = result2 !== null
            ? (function(p) {
                  return p;
            })(result2[2])
            : null;
          if (result1 !== null) {
            var result0 = result1;
          } else {
            var result0 = null;;
          };
        }
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[50] GroupGraphPattern");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_GroupGraphPatternSub() {
        var cacheKey = 'GroupGraphPatternSub@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        var result16 = parse_TriplesBlock();
        var result2 = result16 !== null ? result16 : '';
        if (result2 !== null) {
          var result3 = [];
          var result15 = parse_WS();
          while (result15 !== null) {
            result3.push(result15);
            var result15 = parse_WS();
          }
          if (result3 !== null) {
            var result4 = [];
            var savedPos1 = pos;
            var result6 = parse_GraphPatternNotTriples();
            if (result6 !== null) {
              var result7 = [];
              var result14 = parse_WS();
              while (result14 !== null) {
                result7.push(result14);
                var result14 = parse_WS();
              }
              if (result7 !== null) {
                if (input.substr(pos, 1) === ".") {
                  var result13 = ".";
                  pos += 1;
                } else {
                  var result13 = null;
                  if (reportMatchFailures) {
                    matchFailed("\".\"");
                  }
                }
                var result8 = result13 !== null ? result13 : '';
                if (result8 !== null) {
                  var result9 = [];
                  var result12 = parse_WS();
                  while (result12 !== null) {
                    result9.push(result12);
                    var result12 = parse_WS();
                  }
                  if (result9 !== null) {
                    var result11 = parse_TriplesBlock();
                    var result10 = result11 !== null ? result11 : '';
                    if (result10 !== null) {
                      var result5 = [result6, result7, result8, result9, result10];
                    } else {
                      var result5 = null;
                      pos = savedPos1;
                    }
                  } else {
                    var result5 = null;
                    pos = savedPos1;
                  }
                } else {
                  var result5 = null;
                  pos = savedPos1;
                }
              } else {
                var result5 = null;
                pos = savedPos1;
              }
            } else {
              var result5 = null;
              pos = savedPos1;
            }
            while (result5 !== null) {
              result4.push(result5);
              var savedPos1 = pos;
              var result6 = parse_GraphPatternNotTriples();
              if (result6 !== null) {
                var result7 = [];
                var result14 = parse_WS();
                while (result14 !== null) {
                  result7.push(result14);
                  var result14 = parse_WS();
                }
                if (result7 !== null) {
                  if (input.substr(pos, 1) === ".") {
                    var result13 = ".";
                    pos += 1;
                  } else {
                    var result13 = null;
                    if (reportMatchFailures) {
                      matchFailed("\".\"");
                    }
                  }
                  var result8 = result13 !== null ? result13 : '';
                  if (result8 !== null) {
                    var result9 = [];
                    var result12 = parse_WS();
                    while (result12 !== null) {
                      result9.push(result12);
                      var result12 = parse_WS();
                    }
                    if (result9 !== null) {
                      var result11 = parse_TriplesBlock();
                      var result10 = result11 !== null ? result11 : '';
                      if (result10 !== null) {
                        var result5 = [result6, result7, result8, result9, result10];
                      } else {
                        var result5 = null;
                        pos = savedPos1;
                      }
                    } else {
                      var result5 = null;
                      pos = savedPos1;
                    }
                  } else {
                    var result5 = null;
                    pos = savedPos1;
                  }
                } else {
                  var result5 = null;
                  pos = savedPos1;
                }
              } else {
                var result5 = null;
                pos = savedPos1;
              }
            }
            if (result4 !== null) {
              var result1 = [result2, result3, result4];
            } else {
              var result1 = null;
              pos = savedPos0;
            }
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        var result0 = result1 !== null
          ? (function(tb, tbs) {
                var subpatterns = [];
                if(tb != null && tb != []) {
                    subpatterns.push(tb);
                }
          
                for(var i=0; i<tbs.length; i++) {
                    for(var j=0; j< tbs[i].length; j++) {
                        if(tbs[i][j].token != null) {
                            subpatterns.push(tbs[i][j]);
                        }
                    }
                }
          
                var compactedSubpatterns = [];
          
                var currentBasicGraphPatterns = [];
                var currentFilters = [];
          
                for(var i=0; i<subpatterns.length; i++) {
                    if(subpatterns[i].token!='triplespattern' && subpatterns[i].token != 'filter') {
                        if(currentBasicGraphPatterns.length != 0 || currentFilters.length != 0) {
                            var triplesContext = [];
                            for(var j=0; j<currentBasicGraphPatterns.length; j++) {
                                triplesContext = triplesContext.concat(currentBasicGraphPatterns[j].triplesContext);
                            }
                            if(triplesContext.length > 0) {  
                                compactedSubpatterns.push({token: 'basicgraphpattern',
                                                           triplesContext: triplesContext});
                            }
                            currentBasicGraphPatterns = [];
                        }
                        compactedSubpatterns.push(subpatterns[i]);
                    } else {
                        if(subpatterns[i].token === 'triplespattern') {
                            currentBasicGraphPatterns.push(subpatterns[i]);
                        } else {
                            currentFilters.push(subpatterns[i]);
                        }
                    }
                }
          
                if(currentBasicGraphPatterns.length != 0 || currentFilters.length != 0) {
                    var triplesContext = [];
                    for(var j=0; j<currentBasicGraphPatterns.length; j++) {
                        triplesContext = triplesContext.concat(currentBasicGraphPatterns[j].triplesContext);
                    }
                    if(triplesContext.length > 0) {
                      compactedSubpatterns.push({token: 'basicgraphpattern',
                                                 triplesContext: triplesContext});
                    }
                }
          
          //      if(compactedSubpatterns.length == 1) {
          //          compactedSubpatterns[0].filters = currentFilters;
          //          return compactedSubpatterns[0];
          //      } else  {
                    return { token: 'groupgraphpattern',
                             patterns: compactedSubpatterns,
                             filters: currentFilters }
          //      }
          })(result1[0], result1[2])
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[51] GroupGraphPatternSub");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_TriplesBlock() {
        var cacheKey = 'TriplesBlock@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        var result2 = parse_TriplesSameSubject();
        if (result2 !== null) {
          var savedPos1 = pos;
          var result5 = [];
          var result9 = parse_WS();
          while (result9 !== null) {
            result5.push(result9);
            var result9 = parse_WS();
          }
          if (result5 !== null) {
            if (input.substr(pos, 1) === ".") {
              var result6 = ".";
              pos += 1;
            } else {
              var result6 = null;
              if (reportMatchFailures) {
                matchFailed("\".\"");
              }
            }
            if (result6 !== null) {
              var result8 = parse_TriplesBlock();
              var result7 = result8 !== null ? result8 : '';
              if (result7 !== null) {
                var result4 = [result5, result6, result7];
              } else {
                var result4 = null;
                pos = savedPos1;
              }
            } else {
              var result4 = null;
              pos = savedPos1;
            }
          } else {
            var result4 = null;
            pos = savedPos1;
          }
          var result3 = result4 !== null ? result4 : '';
          if (result3 !== null) {
            var result1 = [result2, result3];
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        var result0 = result1 !== null
          ? (function(b, bs) {
               var triples = b.triplesContext;
               var toTest = null;
                if(typeof(bs) === 'object') {
                      if(bs.length != null) {
                            if(bs[2].triplesContext!=null) {
                               triples = triples.concat(bs[2].triplesContext);
                        }
                     }
                }
          
               return {token:'triplespattern',
                       triplesContext: triples}
          })(result1[0], result1[1])
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[54] TriplesBlock");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_GraphPatternNotTriples() {
        var cacheKey = 'GraphPatternNotTriples@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var result6 = parse_GroupOrUnionGraphPattern();
        if (result6 !== null) {
          var result0 = result6;
        } else {
          var result5 = parse_OptionalGraphPattern();
          if (result5 !== null) {
            var result0 = result5;
          } else {
            var result4 = parse_MinusGraphPattern();
            if (result4 !== null) {
              var result0 = result4;
            } else {
              var result3 = parse_GraphGraphPattern();
              if (result3 !== null) {
                var result0 = result3;
              } else {
                var result2 = parse_ServiceGraphPattern();
                if (result2 !== null) {
                  var result0 = result2;
                } else {
                  var result1 = parse_Filter();
                  if (result1 !== null) {
                    var result0 = result1;
                  } else {
                    var result0 = null;;
                  };
                };
              };
            };
          };
        }
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[53] GraphPatternNotTriples");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_OptionalGraphPattern() {
        var cacheKey = 'OptionalGraphPattern@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        var result2 = [];
        var result7 = parse_WS();
        while (result7 !== null) {
          result2.push(result7);
          var result7 = parse_WS();
        }
        if (result2 !== null) {
          if (input.substr(pos, 8) === "OPTIONAL") {
            var result3 = "OPTIONAL";
            pos += 8;
          } else {
            var result3 = null;
            if (reportMatchFailures) {
              matchFailed("\"OPTIONAL\"");
            }
          }
          if (result3 !== null) {
            var result4 = [];
            var result6 = parse_WS();
            while (result6 !== null) {
              result4.push(result6);
              var result6 = parse_WS();
            }
            if (result4 !== null) {
              var result5 = parse_GroupGraphPattern();
              if (result5 !== null) {
                var result1 = [result2, result3, result4, result5];
              } else {
                var result1 = null;
                pos = savedPos0;
              }
            } else {
              var result1 = null;
              pos = savedPos0;
            }
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        var result0 = result1 !== null
          ? (function(v) {
                return { token: 'optionalgraphpattern',
                         value: v }
          })(result1[3])
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[54] OptionalGraphPattern");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_GraphGraphPattern() {
        var cacheKey = 'GraphGraphPattern@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        var result2 = [];
        var result10 = parse_WS();
        while (result10 !== null) {
          result2.push(result10);
          var result10 = parse_WS();
        }
        if (result2 !== null) {
          if (input.substr(pos, 5) === "GRAPH") {
            var result3 = "GRAPH";
            pos += 5;
          } else {
            var result3 = null;
            if (reportMatchFailures) {
              matchFailed("\"GRAPH\"");
            }
          }
          if (result3 !== null) {
            var result4 = [];
            var result9 = parse_WS();
            while (result9 !== null) {
              result4.push(result9);
              var result9 = parse_WS();
            }
            if (result4 !== null) {
              var result5 = parse_VarOrIRIref();
              if (result5 !== null) {
                var result6 = [];
                var result8 = parse_WS();
                while (result8 !== null) {
                  result6.push(result8);
                  var result8 = parse_WS();
                }
                if (result6 !== null) {
                  var result7 = parse_GroupGraphPattern();
                  if (result7 !== null) {
                    var result1 = [result2, result3, result4, result5, result6, result7];
                  } else {
                    var result1 = null;
                    pos = savedPos0;
                  }
                } else {
                  var result1 = null;
                  pos = savedPos0;
                }
              } else {
                var result1 = null;
                pos = savedPos0;
              }
            } else {
              var result1 = null;
              pos = savedPos0;
            }
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        var result0 = result1 !== null
          ? (function(g, gg) {
                for(var i=0; i<gg.patterns.length; i++) {
                  var quads = []
                  var ts = gg.patterns[i];
                  for(var j=0; j<ts.triplesContext.length; j++) {
                      var triple = ts.triplesContext[j]
                      triple.graph = g;
                  }
                }
          
                gg.token = 'groupgraphpattern'
                return gg;
          })(result1[3], result1[5])
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[55] GraphGraphPattern");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_ServiceGraphPattern() {
        var cacheKey = 'ServiceGraphPattern@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        if (input.substr(pos, 7) === "SERVICE") {
          var result2 = "SERVICE";
          pos += 7;
        } else {
          var result2 = null;
          if (reportMatchFailures) {
            matchFailed("\"SERVICE\"");
          }
        }
        if (result2 !== null) {
          var result3 = parse_VarOrIRIref();
          if (result3 !== null) {
            var result4 = parse_GroupGraphPattern();
            if (result4 !== null) {
              var result1 = [result2, result3, result4];
            } else {
              var result1 = null;
              pos = savedPos0;
            }
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        var result0 = result1 !== null
          ? (function(v, ts) {
                return {token: 'servicegraphpattern',
                        status: 'todo',
                        value: [v,ts] }
          })(result1[1], result1[2])
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[56] ServiceGraphPattern");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_MinusGraphPattern() {
        var cacheKey = 'MinusGraphPattern@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        if (input.substr(pos, 5) === "MINUS") {
          var result2 = "MINUS";
          pos += 5;
        } else {
          var result2 = null;
          if (reportMatchFailures) {
            matchFailed("\"MINUS\"");
          }
        }
        if (result2 !== null) {
          var result3 = parse_GroupGraphPattern();
          if (result3 !== null) {
            var result1 = [result2, result3];
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        var result0 = result1 !== null
          ? (function(ts) {
                return {token: 'minusgraphpattern',
                        status: 'todo',
                        value: ts}
          })(result1[1])
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[57] MinusGraphPattern");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_GroupOrUnionGraphPattern() {
        var cacheKey = 'GroupOrUnionGraphPattern@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        var result2 = parse_GroupGraphPattern();
        if (result2 !== null) {
          var result3 = [];
          var savedPos1 = pos;
          var result5 = [];
          var result10 = parse_WS();
          while (result10 !== null) {
            result5.push(result10);
            var result10 = parse_WS();
          }
          if (result5 !== null) {
            if (input.substr(pos, 5) === "UNION") {
              var result6 = "UNION";
              pos += 5;
            } else {
              var result6 = null;
              if (reportMatchFailures) {
                matchFailed("\"UNION\"");
              }
            }
            if (result6 !== null) {
              var result7 = [];
              var result9 = parse_WS();
              while (result9 !== null) {
                result7.push(result9);
                var result9 = parse_WS();
              }
              if (result7 !== null) {
                var result8 = parse_GroupGraphPattern();
                if (result8 !== null) {
                  var result4 = [result5, result6, result7, result8];
                } else {
                  var result4 = null;
                  pos = savedPos1;
                }
              } else {
                var result4 = null;
                pos = savedPos1;
              }
            } else {
              var result4 = null;
              pos = savedPos1;
            }
          } else {
            var result4 = null;
            pos = savedPos1;
          }
          while (result4 !== null) {
            result3.push(result4);
            var savedPos1 = pos;
            var result5 = [];
            var result10 = parse_WS();
            while (result10 !== null) {
              result5.push(result10);
              var result10 = parse_WS();
            }
            if (result5 !== null) {
              if (input.substr(pos, 5) === "UNION") {
                var result6 = "UNION";
                pos += 5;
              } else {
                var result6 = null;
                if (reportMatchFailures) {
                  matchFailed("\"UNION\"");
                }
              }
              if (result6 !== null) {
                var result7 = [];
                var result9 = parse_WS();
                while (result9 !== null) {
                  result7.push(result9);
                  var result9 = parse_WS();
                }
                if (result7 !== null) {
                  var result8 = parse_GroupGraphPattern();
                  if (result8 !== null) {
                    var result4 = [result5, result6, result7, result8];
                  } else {
                    var result4 = null;
                    pos = savedPos1;
                  }
                } else {
                  var result4 = null;
                  pos = savedPos1;
                }
              } else {
                var result4 = null;
                pos = savedPos1;
              }
            } else {
              var result4 = null;
              pos = savedPos1;
            }
          }
          if (result3 !== null) {
            var result1 = [result2, result3];
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        var result0 = result1 !== null
          ? (function(a, b) {
                if(b.length === 0) {
                    return a;
                } else {
          
                    var lastToken = {token: 'graphunionpattern',
                                     value: [a]};
          
                    for(var i=0; i<b.length; i++) {
                        if(i==b.length-1) {
                            lastToken.value.push(b[i][3]);
                        } else {
                            lastToken.value.push(b[i][3]);
                            var newToken = {token: 'graphunionpattern',
                                            value: [lastToken]}
          
                            lastToken = newToken;
                        }
                    }
          
                    return lastToken;
          
                }
          })(result1[0], result1[1])
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[58] GroupOrUnionGraphPattern");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_Filter() {
        var cacheKey = 'Filter@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        var result2 = [];
        var result24 = parse_WS();
        while (result24 !== null) {
          result2.push(result24);
          var result24 = parse_WS();
        }
        if (result2 !== null) {
          if (input.substr(pos, 1) === "F") {
            var result23 = "F";
            pos += 1;
          } else {
            var result23 = null;
            if (reportMatchFailures) {
              matchFailed("\"F\"");
            }
          }
          if (result23 !== null) {
            var result3 = result23;
          } else {
            if (input.substr(pos, 1) === "f") {
              var result22 = "f";
              pos += 1;
            } else {
              var result22 = null;
              if (reportMatchFailures) {
                matchFailed("\"f\"");
              }
            }
            if (result22 !== null) {
              var result3 = result22;
            } else {
              var result3 = null;;
            };
          }
          if (result3 !== null) {
            if (input.substr(pos, 1) === "I") {
              var result21 = "I";
              pos += 1;
            } else {
              var result21 = null;
              if (reportMatchFailures) {
                matchFailed("\"I\"");
              }
            }
            if (result21 !== null) {
              var result4 = result21;
            } else {
              if (input.substr(pos, 1) === "i") {
                var result20 = "i";
                pos += 1;
              } else {
                var result20 = null;
                if (reportMatchFailures) {
                  matchFailed("\"i\"");
                }
              }
              if (result20 !== null) {
                var result4 = result20;
              } else {
                var result4 = null;;
              };
            }
            if (result4 !== null) {
              if (input.substr(pos, 1) === "L") {
                var result19 = "L";
                pos += 1;
              } else {
                var result19 = null;
                if (reportMatchFailures) {
                  matchFailed("\"L\"");
                }
              }
              if (result19 !== null) {
                var result5 = result19;
              } else {
                if (input.substr(pos, 1) === "l") {
                  var result18 = "l";
                  pos += 1;
                } else {
                  var result18 = null;
                  if (reportMatchFailures) {
                    matchFailed("\"l\"");
                  }
                }
                if (result18 !== null) {
                  var result5 = result18;
                } else {
                  var result5 = null;;
                };
              }
              if (result5 !== null) {
                if (input.substr(pos, 1) === "T") {
                  var result17 = "T";
                  pos += 1;
                } else {
                  var result17 = null;
                  if (reportMatchFailures) {
                    matchFailed("\"T\"");
                  }
                }
                if (result17 !== null) {
                  var result6 = result17;
                } else {
                  if (input.substr(pos, 1) === "t") {
                    var result16 = "t";
                    pos += 1;
                  } else {
                    var result16 = null;
                    if (reportMatchFailures) {
                      matchFailed("\"t\"");
                    }
                  }
                  if (result16 !== null) {
                    var result6 = result16;
                  } else {
                    var result6 = null;;
                  };
                }
                if (result6 !== null) {
                  if (input.substr(pos, 1) === "E") {
                    var result15 = "E";
                    pos += 1;
                  } else {
                    var result15 = null;
                    if (reportMatchFailures) {
                      matchFailed("\"E\"");
                    }
                  }
                  if (result15 !== null) {
                    var result7 = result15;
                  } else {
                    if (input.substr(pos, 1) === "e") {
                      var result14 = "e";
                      pos += 1;
                    } else {
                      var result14 = null;
                      if (reportMatchFailures) {
                        matchFailed("\"e\"");
                      }
                    }
                    if (result14 !== null) {
                      var result7 = result14;
                    } else {
                      var result7 = null;;
                    };
                  }
                  if (result7 !== null) {
                    if (input.substr(pos, 1) === "R") {
                      var result13 = "R";
                      pos += 1;
                    } else {
                      var result13 = null;
                      if (reportMatchFailures) {
                        matchFailed("\"R\"");
                      }
                    }
                    if (result13 !== null) {
                      var result8 = result13;
                    } else {
                      if (input.substr(pos, 1) === "r") {
                        var result12 = "r";
                        pos += 1;
                      } else {
                        var result12 = null;
                        if (reportMatchFailures) {
                          matchFailed("\"r\"");
                        }
                      }
                      if (result12 !== null) {
                        var result8 = result12;
                      } else {
                        var result8 = null;;
                      };
                    }
                    if (result8 !== null) {
                      var result9 = [];
                      var result11 = parse_WS();
                      while (result11 !== null) {
                        result9.push(result11);
                        var result11 = parse_WS();
                      }
                      if (result9 !== null) {
                        var result10 = parse_Constraint();
                        if (result10 !== null) {
                          var result1 = [result2, result3, result4, result5, result6, result7, result8, result9, result10];
                        } else {
                          var result1 = null;
                          pos = savedPos0;
                        }
                      } else {
                        var result1 = null;
                        pos = savedPos0;
                      }
                    } else {
                      var result1 = null;
                      pos = savedPos0;
                    }
                  } else {
                    var result1 = null;
                    pos = savedPos0;
                  }
                } else {
                  var result1 = null;
                  pos = savedPos0;
                }
              } else {
                var result1 = null;
                pos = savedPos0;
              }
            } else {
              var result1 = null;
              pos = savedPos0;
            }
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        var result0 = result1 !== null
          ? (function(c) {
                return {token: 'filter',
                        value: c}
          })(result1[8])
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[59] Filter");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_Constraint() {
        var cacheKey = 'Constraint@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var result3 = parse_BrackettedExpression();
        if (result3 !== null) {
          var result0 = result3;
        } else {
          var result2 = parse_BuiltInCall();
          if (result2 !== null) {
            var result0 = result2;
          } else {
            var result1 = parse_FunctionCall();
            if (result1 !== null) {
              var result0 = result1;
            } else {
              var result0 = null;;
            };
          };
        }
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[60] Constraint");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_FunctionCall() {
        var cacheKey = 'FunctionCall@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        var result2 = parse_IRIref();
        if (result2 !== null) {
          var result3 = parse_ArgList();
          if (result3 !== null) {
            var result1 = [result2, result3];
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        var result0 = result1 !== null
          ? (function(i, args) {
                var fcall = {};
                fcall.token = "expression";
                fcall.expressionType = 'irireforfunction'
                fcall.iriref = i;
                fcall.args = args.value;
          
                return fcall;
          })(result1[0], result1[1])
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[61] FunctionCall");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_ArgList() {
        var cacheKey = 'ArgList@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var result13 = parse_NIL();
        var result12 = result13 !== null
          ? (function() {
                var args = {};
                args.token = 'args';
                args.value = [];
                return args;
          })()
          : null;
        if (result12 !== null) {
          var result0 = result12;
        } else {
          var savedPos0 = pos;
          if (input.substr(pos, 1) === "(") {
            var result3 = "(";
            pos += 1;
          } else {
            var result3 = null;
            if (reportMatchFailures) {
              matchFailed("\"(\"");
            }
          }
          if (result3 !== null) {
            if (input.substr(pos, 8) === "DISTINCT") {
              var result11 = "DISTINCT";
              pos += 8;
            } else {
              var result11 = null;
              if (reportMatchFailures) {
                matchFailed("\"DISTINCT\"");
              }
            }
            var result4 = result11 !== null ? result11 : '';
            if (result4 !== null) {
              var result5 = parse_ConditionalOrExpression();
              if (result5 !== null) {
                var result6 = [];
                var savedPos1 = pos;
                if (input.substr(pos, 1) === ",") {
                  var result9 = ",";
                  pos += 1;
                } else {
                  var result9 = null;
                  if (reportMatchFailures) {
                    matchFailed("\",\"");
                  }
                }
                if (result9 !== null) {
                  var result10 = parse_ConditionalOrExpression();
                  if (result10 !== null) {
                    var result8 = [result9, result10];
                  } else {
                    var result8 = null;
                    pos = savedPos1;
                  }
                } else {
                  var result8 = null;
                  pos = savedPos1;
                }
                while (result8 !== null) {
                  result6.push(result8);
                  var savedPos1 = pos;
                  if (input.substr(pos, 1) === ",") {
                    var result9 = ",";
                    pos += 1;
                  } else {
                    var result9 = null;
                    if (reportMatchFailures) {
                      matchFailed("\",\"");
                    }
                  }
                  if (result9 !== null) {
                    var result10 = parse_ConditionalOrExpression();
                    if (result10 !== null) {
                      var result8 = [result9, result10];
                    } else {
                      var result8 = null;
                      pos = savedPos1;
                    }
                  } else {
                    var result8 = null;
                    pos = savedPos1;
                  }
                }
                if (result6 !== null) {
                  if (input.substr(pos, 1) === ")") {
                    var result7 = ")";
                    pos += 1;
                  } else {
                    var result7 = null;
                    if (reportMatchFailures) {
                      matchFailed("\")\"");
                    }
                  }
                  if (result7 !== null) {
                    var result2 = [result3, result4, result5, result6, result7];
                  } else {
                    var result2 = null;
                    pos = savedPos0;
                  }
                } else {
                  var result2 = null;
                  pos = savedPos0;
                }
              } else {
                var result2 = null;
                pos = savedPos0;
              }
            } else {
              var result2 = null;
              pos = savedPos0;
            }
          } else {
            var result2 = null;
            pos = savedPos0;
          }
          var result1 = result2 !== null
            ? (function(d, e, es) {
                  cleanEx = [];
            
                  for(var i=0; i<es.length; i++) {
                      cleanEx.push(es[i][1]);
                  }
                  var args = {};
                  args.token = 'args';
                  args.value = [e].concat(cleanEx);
            
                  if(d==="DISTINCT") {
                      args.distinct = true;
                  } else {
                      args.distinct = false;
                  }
            
                  return args;
            })(result2[1], result2[2], result2[3])
            : null;
          if (result1 !== null) {
            var result0 = result1;
          } else {
            var result0 = null;;
          };
        }
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[62] ArgList");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_ExpressionList() {
        var cacheKey = 'ExpressionList@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var result11 = parse_NIL();
        var result10 = result11 !== null
          ? (function() {
                var args = {};
                args.token = 'args';
                args.value = [];
                return args;
          })()
          : null;
        if (result10 !== null) {
          var result0 = result10;
        } else {
          var savedPos0 = pos;
          if (input.substr(pos, 1) === "(") {
            var result3 = "(";
            pos += 1;
          } else {
            var result3 = null;
            if (reportMatchFailures) {
              matchFailed("\"(\"");
            }
          }
          if (result3 !== null) {
            var result4 = parse_ConditionalOrExpression();
            if (result4 !== null) {
              var result5 = [];
              var savedPos1 = pos;
              if (input.substr(pos, 1) === ",") {
                var result8 = ",";
                pos += 1;
              } else {
                var result8 = null;
                if (reportMatchFailures) {
                  matchFailed("\",\"");
                }
              }
              if (result8 !== null) {
                var result9 = parse_ConditionalOrExpression();
                if (result9 !== null) {
                  var result7 = [result8, result9];
                } else {
                  var result7 = null;
                  pos = savedPos1;
                }
              } else {
                var result7 = null;
                pos = savedPos1;
              }
              while (result7 !== null) {
                result5.push(result7);
                var savedPos1 = pos;
                if (input.substr(pos, 1) === ",") {
                  var result8 = ",";
                  pos += 1;
                } else {
                  var result8 = null;
                  if (reportMatchFailures) {
                    matchFailed("\",\"");
                  }
                }
                if (result8 !== null) {
                  var result9 = parse_ConditionalOrExpression();
                  if (result9 !== null) {
                    var result7 = [result8, result9];
                  } else {
                    var result7 = null;
                    pos = savedPos1;
                  }
                } else {
                  var result7 = null;
                  pos = savedPos1;
                }
              }
              if (result5 !== null) {
                if (input.substr(pos, 1) === ")") {
                  var result6 = ")";
                  pos += 1;
                } else {
                  var result6 = null;
                  if (reportMatchFailures) {
                    matchFailed("\")\"");
                  }
                }
                if (result6 !== null) {
                  var result2 = [result3, result4, result5, result6];
                } else {
                  var result2 = null;
                  pos = savedPos0;
                }
              } else {
                var result2 = null;
                pos = savedPos0;
              }
            } else {
              var result2 = null;
              pos = savedPos0;
            }
          } else {
            var result2 = null;
            pos = savedPos0;
          }
          var result1 = result2 !== null
            ? (function(e, es) {
                  cleanEx = [];
            
                  for(var i=0; i<es.length; i++) {
                      cleanEx.push(es[i][1]);
                  }
                  var args = {};
                  args.token = 'args';
                  args.value = [e].concat(cleanEx);
            
                  return args;
            })(result2[1], result2[2])
            : null;
          if (result1 !== null) {
            var result0 = result1;
          } else {
            var result0 = null;;
          };
        }
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[63] ExpressionList");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_ConstructTemplate() {
        var cacheKey = 'ConstructTemplate@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        if (input.substr(pos, 1) === "{") {
          var result2 = "{";
          pos += 1;
        } else {
          var result2 = null;
          if (reportMatchFailures) {
            matchFailed("\"{\"");
          }
        }
        if (result2 !== null) {
          var result3 = [];
          var result9 = parse_WS();
          while (result9 !== null) {
            result3.push(result9);
            var result9 = parse_WS();
          }
          if (result3 !== null) {
            var result8 = parse_ConstructTriples();
            var result4 = result8 !== null ? result8 : '';
            if (result4 !== null) {
              var result5 = [];
              var result7 = parse_WS();
              while (result7 !== null) {
                result5.push(result7);
                var result7 = parse_WS();
              }
              if (result5 !== null) {
                if (input.substr(pos, 1) === "}") {
                  var result6 = "}";
                  pos += 1;
                } else {
                  var result6 = null;
                  if (reportMatchFailures) {
                    matchFailed("\"}\"");
                  }
                }
                if (result6 !== null) {
                  var result1 = [result2, result3, result4, result5, result6];
                } else {
                  var result1 = null;
                  pos = savedPos0;
                }
              } else {
                var result1 = null;
                pos = savedPos0;
              }
            } else {
              var result1 = null;
              pos = savedPos0;
            }
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        var result0 = result1 !== null
          ? (function(ts) {
                return ts;
          })(result1[2])
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[64] ConstructTemplate");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_ConstructTriples() {
        var cacheKey = 'ConstructTriples@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        var result2 = parse_TriplesSameSubject();
        if (result2 !== null) {
          var savedPos1 = pos;
          var result5 = [];
          var result11 = parse_WS();
          while (result11 !== null) {
            result5.push(result11);
            var result11 = parse_WS();
          }
          if (result5 !== null) {
            if (input.substr(pos, 1) === ".") {
              var result6 = ".";
              pos += 1;
            } else {
              var result6 = null;
              if (reportMatchFailures) {
                matchFailed("\".\"");
              }
            }
            if (result6 !== null) {
              var result7 = [];
              var result10 = parse_WS();
              while (result10 !== null) {
                result7.push(result10);
                var result10 = parse_WS();
              }
              if (result7 !== null) {
                var result9 = parse_ConstructTriples();
                var result8 = result9 !== null ? result9 : '';
                if (result8 !== null) {
                  var result4 = [result5, result6, result7, result8];
                } else {
                  var result4 = null;
                  pos = savedPos1;
                }
              } else {
                var result4 = null;
                pos = savedPos1;
              }
            } else {
              var result4 = null;
              pos = savedPos1;
            }
          } else {
            var result4 = null;
            pos = savedPos1;
          }
          var result3 = result4 !== null ? result4 : '';
          if (result3 !== null) {
            var result1 = [result2, result3];
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        var result0 = result1 !== null
          ? (function(b, bs) {
               var triples = b.triplesContext;
               var toTest = null;
                if(typeof(bs) === 'object') {
                      if(bs.length != null) {
                            if(bs[3].triplesContext!=null) {
                               triples = triples.concat(bs[3].triplesContext);
                        }
                     }
                }
          
               return {token:'triplestemplate',
                       triplesContext: triples}
          })(result1[0], result1[1])
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[65] ConstructTriples");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_TriplesSameSubject() {
        var cacheKey = 'TriplesSameSubject@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos1 = pos;
        var result11 = [];
        var result16 = parse_WS();
        while (result16 !== null) {
          result11.push(result16);
          var result16 = parse_WS();
        }
        if (result11 !== null) {
          var result12 = parse_VarOrTerm();
          if (result12 !== null) {
            var result13 = [];
            var result15 = parse_WS();
            while (result15 !== null) {
              result13.push(result15);
              var result15 = parse_WS();
            }
            if (result13 !== null) {
              var result14 = parse_PropertyListNotEmpty();
              if (result14 !== null) {
                var result10 = [result11, result12, result13, result14];
              } else {
                var result10 = null;
                pos = savedPos1;
              }
            } else {
              var result10 = null;
              pos = savedPos1;
            }
          } else {
            var result10 = null;
            pos = savedPos1;
          }
        } else {
          var result10 = null;
          pos = savedPos1;
        }
        var result9 = result10 !== null
          ? (function(s, pairs) {
                var triplesContext = pairs.triplesContext;
                var subject = s;
                if(pairs.pairs) {
                  for(var i=0; i< pairs.pairs.length; i++) {
                      var pair = pairs.pairs[i];
                      var triple = null;
                      if(subject.token && subject.token==='triplesnodecollection') {
                          triple = {subject: subject.chainSubject[0], predicate: pair[0], object: pair[1]}
                          triplesContext.push(triple);
                          triplesContext = triplesContext.concat(subject.triplesContext);
                      } else {
                          triple = {subject: subject, predicate: pair[0], object: pair[1]}
                          triplesContext.push(triple);
                      }
                  }
                }
          
                var token = {};
                token.token = "triplessamesubject";
                token.triplesContext = triplesContext;
                token.chainSubject = subject;
          
                return token;
            })(result10[1], result10[3])
          : null;
        if (result9 !== null) {
          var result0 = result9;
        } else {
          var savedPos0 = pos;
          var result3 = [];
          var result8 = parse_WS();
          while (result8 !== null) {
            result3.push(result8);
            var result8 = parse_WS();
          }
          if (result3 !== null) {
            var result4 = parse_TriplesNode();
            if (result4 !== null) {
              var result5 = [];
              var result7 = parse_WS();
              while (result7 !== null) {
                result5.push(result7);
                var result7 = parse_WS();
              }
              if (result5 !== null) {
                var result6 = parse_PropertyList();
                if (result6 !== null) {
                  var result2 = [result3, result4, result5, result6];
                } else {
                  var result2 = null;
                  pos = savedPos0;
                }
              } else {
                var result2 = null;
                pos = savedPos0;
              }
            } else {
              var result2 = null;
              pos = savedPos0;
            }
          } else {
            var result2 = null;
            pos = savedPos0;
          }
          var result1 = result2 !== null
            ? (function(tn, pairs) {
                  var triplesContext = tn.triplesContext;
                  var subject = tn.chainSubject;
            
                  if(pairs.pairs) {
                    for(var i=0; i< pairs.pairs.length; i++) {
                        var pair = pairs.pairs[i];
                        if(tn.token === "triplesnodecollection") {
                            for(var j=0; j<subject.length; j++) {
                                var subj = subject[j];
                                if(subj.triplesContext != null) {
                                    var triple = {subject: subj.chainSubject, predicate: pair[0], object: pair[1]}
                                    triplesContext.concat(subj.triplesContext);
                                } else {
                                    var triple = {subject: subject[j], predicate: pair[0], object: pair[1]}
                                    triplesContext.push(triple);
                                }
                            }
                        } else {
                            var triple = {subject: subject, predicate: pair[0], object: pair[1]}
                            triplesContext.push(triple);
                        }
                    }
                  }
            
                  var token = {};
                  token.token = "triplessamesubject";
                  token.triplesContext = triplesContext;
                  token.chainSubject = subject;
            
                  return token;
              })(result2[1], result2[3])
            : null;
          if (result1 !== null) {
            var result0 = result1;
          } else {
            var result0 = null;;
          };
        }
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[66] TriplesSameSubject");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_PropertyListNotEmpty() {
        var cacheKey = 'PropertyListNotEmpty@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        var result2 = parse_Verb();
        if (result2 !== null) {
          var result3 = [];
          var result18 = parse_WS();
          while (result18 !== null) {
            result3.push(result18);
            var result18 = parse_WS();
          }
          if (result3 !== null) {
            var result4 = parse_ObjectList();
            if (result4 !== null) {
              var result5 = [];
              var savedPos1 = pos;
              var result7 = [];
              var result17 = parse_WS();
              while (result17 !== null) {
                result7.push(result17);
                var result17 = parse_WS();
              }
              if (result7 !== null) {
                if (input.substr(pos, 1) === ";") {
                  var result8 = ";";
                  pos += 1;
                } else {
                  var result8 = null;
                  if (reportMatchFailures) {
                    matchFailed("\";\"");
                  }
                }
                if (result8 !== null) {
                  var result9 = [];
                  var result16 = parse_WS();
                  while (result16 !== null) {
                    result9.push(result16);
                    var result16 = parse_WS();
                  }
                  if (result9 !== null) {
                    var savedPos2 = pos;
                    var result12 = parse_Verb();
                    if (result12 !== null) {
                      var result13 = [];
                      var result15 = parse_WS();
                      while (result15 !== null) {
                        result13.push(result15);
                        var result15 = parse_WS();
                      }
                      if (result13 !== null) {
                        var result14 = parse_ObjectList();
                        if (result14 !== null) {
                          var result11 = [result12, result13, result14];
                        } else {
                          var result11 = null;
                          pos = savedPos2;
                        }
                      } else {
                        var result11 = null;
                        pos = savedPos2;
                      }
                    } else {
                      var result11 = null;
                      pos = savedPos2;
                    }
                    var result10 = result11 !== null ? result11 : '';
                    if (result10 !== null) {
                      var result6 = [result7, result8, result9, result10];
                    } else {
                      var result6 = null;
                      pos = savedPos1;
                    }
                  } else {
                    var result6 = null;
                    pos = savedPos1;
                  }
                } else {
                  var result6 = null;
                  pos = savedPos1;
                }
              } else {
                var result6 = null;
                pos = savedPos1;
              }
              while (result6 !== null) {
                result5.push(result6);
                var savedPos1 = pos;
                var result7 = [];
                var result17 = parse_WS();
                while (result17 !== null) {
                  result7.push(result17);
                  var result17 = parse_WS();
                }
                if (result7 !== null) {
                  if (input.substr(pos, 1) === ";") {
                    var result8 = ";";
                    pos += 1;
                  } else {
                    var result8 = null;
                    if (reportMatchFailures) {
                      matchFailed("\";\"");
                    }
                  }
                  if (result8 !== null) {
                    var result9 = [];
                    var result16 = parse_WS();
                    while (result16 !== null) {
                      result9.push(result16);
                      var result16 = parse_WS();
                    }
                    if (result9 !== null) {
                      var savedPos2 = pos;
                      var result12 = parse_Verb();
                      if (result12 !== null) {
                        var result13 = [];
                        var result15 = parse_WS();
                        while (result15 !== null) {
                          result13.push(result15);
                          var result15 = parse_WS();
                        }
                        if (result13 !== null) {
                          var result14 = parse_ObjectList();
                          if (result14 !== null) {
                            var result11 = [result12, result13, result14];
                          } else {
                            var result11 = null;
                            pos = savedPos2;
                          }
                        } else {
                          var result11 = null;
                          pos = savedPos2;
                        }
                      } else {
                        var result11 = null;
                        pos = savedPos2;
                      }
                      var result10 = result11 !== null ? result11 : '';
                      if (result10 !== null) {
                        var result6 = [result7, result8, result9, result10];
                      } else {
                        var result6 = null;
                        pos = savedPos1;
                      }
                    } else {
                      var result6 = null;
                      pos = savedPos1;
                    }
                  } else {
                    var result6 = null;
                    pos = savedPos1;
                  }
                } else {
                  var result6 = null;
                  pos = savedPos1;
                }
              }
              if (result5 !== null) {
                var result1 = [result2, result3, result4, result5];
              } else {
                var result1 = null;
                pos = savedPos0;
              }
            } else {
              var result1 = null;
              pos = savedPos0;
            }
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        var result0 = result1 !== null
          ? (function(v, ol, rest) {
                token = {}
                token.token = 'propertylist';
                var triplesContext = [];
                var pairs = [];
                var test = [];
          
                for( var i=0; i<ol.length; i++) {
          
                   if(ol[i].triplesContext != null) {
                       triplesContext = triplesContext.concat(ol[i].triplesContext);
                       if(ol[i].token==='triplesnodecollection' && ol[i].chainSubject.length != null) {
                           pairs.push([v, ol[i].chainSubject[0]]);
                       } else {
                           pairs.push([v, ol[i].chainSubject]);
                       }
          
                    } else {
                        pairs.push([v, ol[i]])
                    }
          
                }
          
          
                for(var i=0; i<rest.length; i++) {
                    var tok = rest[i][3];
                    var newVerb  = tok[0];
                    var newObjsList = tok[2] || [];
          
                    for(var j=0; j<newObjsList.length; j++) {
                     if(newObjsList[j].triplesContext != null) {
                        triplesContext = triplesContext.concat(newObjsList[j].triplesContext);
                       pairs.push([newVerb, newObjsList[j].chainSubject]);
                      } else {
                        pairs.push([newVerb, newObjsList[j]])
                      }
                    }
                }
          
                token.pairs = pairs;
                token.triplesContext = triplesContext;
          
                return token;
          
          })(result1[0], result1[2], result1[3])
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[67] PropertyListNotEmpty");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_PropertyList() {
        var cacheKey = 'PropertyList@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var result1 = parse_PropertyListNotEmpty();
        var result0 = result1 !== null ? result1 : '';
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[68] PropertyList");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_ObjectList() {
        var cacheKey = 'ObjectList@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        var result2 = parse_GraphNode();
        if (result2 !== null) {
          var result3 = [];
          var result10 = parse_WS();
          while (result10 !== null) {
            result3.push(result10);
            var result10 = parse_WS();
          }
          if (result3 !== null) {
            var result4 = [];
            var savedPos1 = pos;
            if (input.substr(pos, 1) === ",") {
              var result6 = ",";
              pos += 1;
            } else {
              var result6 = null;
              if (reportMatchFailures) {
                matchFailed("\",\"");
              }
            }
            if (result6 !== null) {
              var result7 = [];
              var result9 = parse_WS();
              while (result9 !== null) {
                result7.push(result9);
                var result9 = parse_WS();
              }
              if (result7 !== null) {
                var result8 = parse_GraphNode();
                if (result8 !== null) {
                  var result5 = [result6, result7, result8];
                } else {
                  var result5 = null;
                  pos = savedPos1;
                }
              } else {
                var result5 = null;
                pos = savedPos1;
              }
            } else {
              var result5 = null;
              pos = savedPos1;
            }
            while (result5 !== null) {
              result4.push(result5);
              var savedPos1 = pos;
              if (input.substr(pos, 1) === ",") {
                var result6 = ",";
                pos += 1;
              } else {
                var result6 = null;
                if (reportMatchFailures) {
                  matchFailed("\",\"");
                }
              }
              if (result6 !== null) {
                var result7 = [];
                var result9 = parse_WS();
                while (result9 !== null) {
                  result7.push(result9);
                  var result9 = parse_WS();
                }
                if (result7 !== null) {
                  var result8 = parse_GraphNode();
                  if (result8 !== null) {
                    var result5 = [result6, result7, result8];
                  } else {
                    var result5 = null;
                    pos = savedPos1;
                  }
                } else {
                  var result5 = null;
                  pos = savedPos1;
                }
              } else {
                var result5 = null;
                pos = savedPos1;
              }
            }
            if (result4 !== null) {
              var result1 = [result2, result3, result4];
            } else {
              var result1 = null;
              pos = savedPos0;
            }
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        var result0 = result1 !== null
          ? (function(obj, objs) {
          
                  var toReturn = [];
          
                  toReturn.push(obj);
          
                  for(var i=0; i<objs.length; i++) {
                      for(var j=0; j<objs[i].length; j++) {
                          if(typeof(objs[i][j])=="object" && objs[i][j].token != null) {
                              toReturn.push(objs[i][j]);
                          }
                      }
                  }
          
                  return toReturn;
              })(result1[0], result1[2])
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[69] ObjectList");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_Verb() {
        var cacheKey = 'Verb@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var result3 = parse_VarOrIRIref();
        if (result3 !== null) {
          var result0 = result3;
        } else {
          if (input.substr(pos, 1) === "a") {
            var result2 = "a";
            pos += 1;
          } else {
            var result2 = null;
            if (reportMatchFailures) {
              matchFailed("\"a\"");
            }
          }
          var result1 = result2 !== null
            ? (function() {
                  return{token: 'uri', prefix:null, suffix:null, value:"http://www.w3.org/1999/02/22-rdf-syntax-ns#type"}
              })()
            : null;
          if (result1 !== null) {
            var result0 = result1;
          } else {
            var result0 = null;;
          };
        }
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[71] Verb");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_PropertyListNotEmptyPath() {
        var cacheKey = 'PropertyListNotEmptyPath@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        var result13 = parse_VerbPath();
        if (result13 !== null) {
          var result1 = result13;
        } else {
          var result12 = parse_Var();
          if (result12 !== null) {
            var result1 = result12;
          } else {
            var result1 = null;;
          };
        }
        if (result1 !== null) {
          var result2 = parse_ObjectList();
          if (result2 !== null) {
            var result3 = [];
            var savedPos1 = pos;
            if (input.substr(pos, 1) === ";") {
              var result5 = ";";
              pos += 1;
            } else {
              var result5 = null;
              if (reportMatchFailures) {
                matchFailed("\";\"");
              }
            }
            if (result5 !== null) {
              var savedPos2 = pos;
              var result11 = parse_VerbPath();
              if (result11 !== null) {
                var result8 = result11;
              } else {
                var result10 = parse_Var();
                if (result10 !== null) {
                  var result8 = result10;
                } else {
                  var result8 = null;;
                };
              }
              if (result8 !== null) {
                var result9 = parse_ObjectList();
                if (result9 !== null) {
                  var result7 = [result8, result9];
                } else {
                  var result7 = null;
                  pos = savedPos2;
                }
              } else {
                var result7 = null;
                pos = savedPos2;
              }
              var result6 = result7 !== null ? result7 : '';
              if (result6 !== null) {
                var result4 = [result5, result6];
              } else {
                var result4 = null;
                pos = savedPos1;
              }
            } else {
              var result4 = null;
              pos = savedPos1;
            }
            while (result4 !== null) {
              result3.push(result4);
              var savedPos1 = pos;
              if (input.substr(pos, 1) === ";") {
                var result5 = ";";
                pos += 1;
              } else {
                var result5 = null;
                if (reportMatchFailures) {
                  matchFailed("\";\"");
                }
              }
              if (result5 !== null) {
                var savedPos2 = pos;
                var result11 = parse_VerbPath();
                if (result11 !== null) {
                  var result8 = result11;
                } else {
                  var result10 = parse_Var();
                  if (result10 !== null) {
                    var result8 = result10;
                  } else {
                    var result8 = null;;
                  };
                }
                if (result8 !== null) {
                  var result9 = parse_ObjectList();
                  if (result9 !== null) {
                    var result7 = [result8, result9];
                  } else {
                    var result7 = null;
                    pos = savedPos2;
                  }
                } else {
                  var result7 = null;
                  pos = savedPos2;
                }
                var result6 = result7 !== null ? result7 : '';
                if (result6 !== null) {
                  var result4 = [result5, result6];
                } else {
                  var result4 = null;
                  pos = savedPos1;
                }
              } else {
                var result4 = null;
                pos = savedPos1;
              }
            }
            if (result3 !== null) {
              var result0 = [result1, result2, result3];
            } else {
              var result0 = null;
              pos = savedPos0;
            }
          } else {
            var result0 = null;
            pos = savedPos0;
          }
        } else {
          var result0 = null;
          pos = savedPos0;
        }
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[73] PropertyListNotEmptyPath");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_PropertyListPath() {
        var cacheKey = 'PropertyListPath@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var result1 = parse_PropertyListNotEmpty();
        var result0 = result1 !== null ? result1 : '';
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[74] PropertyListPath");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_VerbPath() {
        var cacheKey = 'VerbPath@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var result1 = parse_PathAlternative();
        var result0 = result1 !== null
          ? (function(p) {
                var path = {};
                path.token = 'path';
                path.value = p;
          
                return p;
          })(result1)
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[75]");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_PathAlternative() {
        var cacheKey = 'PathAlternative@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        var result1 = parse_PathSequence();
        if (result1 !== null) {
          var result2 = [];
          var savedPos1 = pos;
          if (input.substr(pos, 1) === "|") {
            var result4 = "|";
            pos += 1;
          } else {
            var result4 = null;
            if (reportMatchFailures) {
              matchFailed("\"|\"");
            }
          }
          if (result4 !== null) {
            var result5 = parse_PathSequence();
            if (result5 !== null) {
              var result3 = [result4, result5];
            } else {
              var result3 = null;
              pos = savedPos1;
            }
          } else {
            var result3 = null;
            pos = savedPos1;
          }
          while (result3 !== null) {
            result2.push(result3);
            var savedPos1 = pos;
            if (input.substr(pos, 1) === "|") {
              var result4 = "|";
              pos += 1;
            } else {
              var result4 = null;
              if (reportMatchFailures) {
                matchFailed("\"|\"");
              }
            }
            if (result4 !== null) {
              var result5 = parse_PathSequence();
              if (result5 !== null) {
                var result3 = [result4, result5];
              } else {
                var result3 = null;
                pos = savedPos1;
              }
            } else {
              var result3 = null;
              pos = savedPos1;
            }
          }
          if (result2 !== null) {
            var result0 = [result1, result2];
          } else {
            var result0 = null;
            pos = savedPos0;
          }
        } else {
          var result0 = null;
          pos = savedPos0;
        }
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[78] PathAlternative");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_PathSequence() {
        var cacheKey = 'PathSequence@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        var result1 = parse_PathEltOrInverse();
        if (result1 !== null) {
          var result2 = [];
          var savedPos1 = pos;
          if (input.substr(pos, 1) === "/") {
            var result4 = "/";
            pos += 1;
          } else {
            var result4 = null;
            if (reportMatchFailures) {
              matchFailed("\"/\"");
            }
          }
          if (result4 !== null) {
            var result5 = parse_PathEltOrInverse();
            if (result5 !== null) {
              var result3 = [result4, result5];
            } else {
              var result3 = null;
              pos = savedPos1;
            }
          } else {
            var result3 = null;
            pos = savedPos1;
          }
          while (result3 !== null) {
            result2.push(result3);
            var savedPos1 = pos;
            if (input.substr(pos, 1) === "/") {
              var result4 = "/";
              pos += 1;
            } else {
              var result4 = null;
              if (reportMatchFailures) {
                matchFailed("\"/\"");
              }
            }
            if (result4 !== null) {
              var result5 = parse_PathEltOrInverse();
              if (result5 !== null) {
                var result3 = [result4, result5];
              } else {
                var result3 = null;
                pos = savedPos1;
              }
            } else {
              var result3 = null;
              pos = savedPos1;
            }
          }
          if (result2 !== null) {
            var result0 = [result1, result2];
          } else {
            var result0 = null;
            pos = savedPos0;
          }
        } else {
          var result0 = null;
          pos = savedPos0;
        }
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[79] PathSequence");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_PathElt() {
        var cacheKey = 'PathElt@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        var result1 = parse_PathPrimary();
        if (result1 !== null) {
          var result3 = parse_PathMod();
          var result2 = result3 !== null ? result3 : '';
          if (result2 !== null) {
            var result0 = [result1, result2];
          } else {
            var result0 = null;
            pos = savedPos0;
          }
        } else {
          var result0 = null;
          pos = savedPos0;
        }
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[88] PathElt");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_PathEltOrInverse() {
        var cacheKey = 'PathEltOrInverse@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var result4 = parse_PathElt();
        if (result4 !== null) {
          var result0 = result4;
        } else {
          var savedPos0 = pos;
          if (input.substr(pos, 1) === "^") {
            var result2 = "^";
            pos += 1;
          } else {
            var result2 = null;
            if (reportMatchFailures) {
              matchFailed("\"^\"");
            }
          }
          if (result2 !== null) {
            var result3 = parse_PathElt();
            if (result3 !== null) {
              var result1 = [result2, result3];
            } else {
              var result1 = null;
              pos = savedPos0;
            }
          } else {
            var result1 = null;
            pos = savedPos0;
          }
          if (result1 !== null) {
            var result0 = result1;
          } else {
            var result0 = null;;
          };
        }
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[81] PathEltOrInverse");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_PathMod() {
        var cacheKey = 'PathMod@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        if (input.substr(pos, 1) === "*") {
          var result21 = "*";
          pos += 1;
        } else {
          var result21 = null;
          if (reportMatchFailures) {
            matchFailed("\"*\"");
          }
        }
        if (result21 !== null) {
          var result0 = result21;
        } else {
          if (input.substr(pos, 1) === "?") {
            var result20 = "?";
            pos += 1;
          } else {
            var result20 = null;
            if (reportMatchFailures) {
              matchFailed("\"?\"");
            }
          }
          if (result20 !== null) {
            var result0 = result20;
          } else {
            if (input.substr(pos, 1) === "+") {
              var result19 = "+";
              pos += 1;
            } else {
              var result19 = null;
              if (reportMatchFailures) {
                matchFailed("\"+\"");
              }
            }
            if (result19 !== null) {
              var result0 = result19;
            } else {
              var savedPos0 = pos;
              if (input.substr(pos, 1) === "{") {
                var result2 = "{";
                pos += 1;
              } else {
                var result2 = null;
                if (reportMatchFailures) {
                  matchFailed("\"{\"");
                }
              }
              if (result2 !== null) {
                var savedPos2 = pos;
                var result9 = parse_INTEGER();
                if (result9 !== null) {
                  var savedPos3 = pos;
                  if (input.substr(pos, 1) === ",") {
                    var result13 = ",";
                    pos += 1;
                  } else {
                    var result13 = null;
                    if (reportMatchFailures) {
                      matchFailed("\",\"");
                    }
                  }
                  if (result13 !== null) {
                    if (input.substr(pos, 1) === "}") {
                      var result18 = "}";
                      pos += 1;
                    } else {
                      var result18 = null;
                      if (reportMatchFailures) {
                        matchFailed("\"}\"");
                      }
                    }
                    if (result18 !== null) {
                      var result14 = result18;
                    } else {
                      var savedPos4 = pos;
                      var result16 = parse_INTEGER();
                      if (result16 !== null) {
                        if (input.substr(pos, 1) === "}") {
                          var result17 = "}";
                          pos += 1;
                        } else {
                          var result17 = null;
                          if (reportMatchFailures) {
                            matchFailed("\"}\"");
                          }
                        }
                        if (result17 !== null) {
                          var result15 = [result16, result17];
                        } else {
                          var result15 = null;
                          pos = savedPos4;
                        }
                      } else {
                        var result15 = null;
                        pos = savedPos4;
                      }
                      if (result15 !== null) {
                        var result14 = result15;
                      } else {
                        var result14 = null;;
                      };
                    }
                    if (result14 !== null) {
                      var result12 = [result13, result14];
                    } else {
                      var result12 = null;
                      pos = savedPos3;
                    }
                  } else {
                    var result12 = null;
                    pos = savedPos3;
                  }
                  if (result12 !== null) {
                    var result10 = result12;
                  } else {
                    if (input.substr(pos, 1) === "}") {
                      var result11 = "}";
                      pos += 1;
                    } else {
                      var result11 = null;
                      if (reportMatchFailures) {
                        matchFailed("\"}\"");
                      }
                    }
                    if (result11 !== null) {
                      var result10 = result11;
                    } else {
                      var result10 = null;;
                    };
                  }
                  if (result10 !== null) {
                    var result8 = [result9, result10];
                  } else {
                    var result8 = null;
                    pos = savedPos2;
                  }
                } else {
                  var result8 = null;
                  pos = savedPos2;
                }
                if (result8 !== null) {
                  var result3 = result8;
                } else {
                  var savedPos1 = pos;
                  if (input.substr(pos, 1) === ",") {
                    var result5 = ",";
                    pos += 1;
                  } else {
                    var result5 = null;
                    if (reportMatchFailures) {
                      matchFailed("\",\"");
                    }
                  }
                  if (result5 !== null) {
                    var result6 = parse_INTEGER();
                    if (result6 !== null) {
                      if (input.substr(pos, 1) === "}") {
                        var result7 = "}";
                        pos += 1;
                      } else {
                        var result7 = null;
                        if (reportMatchFailures) {
                          matchFailed("\"}\"");
                        }
                      }
                      if (result7 !== null) {
                        var result4 = [result5, result6, result7];
                      } else {
                        var result4 = null;
                        pos = savedPos1;
                      }
                    } else {
                      var result4 = null;
                      pos = savedPos1;
                    }
                  } else {
                    var result4 = null;
                    pos = savedPos1;
                  }
                  if (result4 !== null) {
                    var result3 = result4;
                  } else {
                    var result3 = null;;
                  };
                }
                if (result3 !== null) {
                  var result1 = [result2, result3];
                } else {
                  var result1 = null;
                  pos = savedPos0;
                }
              } else {
                var result1 = null;
                pos = savedPos0;
              }
              if (result1 !== null) {
                var result0 = result1;
              } else {
                var result0 = null;;
              };
            };
          };
        }
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[82] PathMod");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_PathPrimary() {
        var cacheKey = 'PathPrimary@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var result9 = parse_IRIref();
        if (result9 !== null) {
          var result0 = result9;
        } else {
          if (input.substr(pos, 1) === "a") {
            var result8 = "a";
            pos += 1;
          } else {
            var result8 = null;
            if (reportMatchFailures) {
              matchFailed("\"a\"");
            }
          }
          if (result8 !== null) {
            var result0 = result8;
          } else {
            var savedPos1 = pos;
            if (input.substr(pos, 1) === "!") {
              var result6 = "!";
              pos += 1;
            } else {
              var result6 = null;
              if (reportMatchFailures) {
                matchFailed("\"!\"");
              }
            }
            if (result6 !== null) {
              var result7 = parse_PathNegatedPropertySet();
              if (result7 !== null) {
                var result5 = [result6, result7];
              } else {
                var result5 = null;
                pos = savedPos1;
              }
            } else {
              var result5 = null;
              pos = savedPos1;
            }
            if (result5 !== null) {
              var result0 = result5;
            } else {
              var savedPos0 = pos;
              if (input.substr(pos, 1) === "(") {
                var result2 = "(";
                pos += 1;
              } else {
                var result2 = null;
                if (reportMatchFailures) {
                  matchFailed("\"(\"");
                }
              }
              if (result2 !== null) {
                var result3 = parse_PathAlternative();
                if (result3 !== null) {
                  if (input.substr(pos, 1) === ")") {
                    var result4 = ")";
                    pos += 1;
                  } else {
                    var result4 = null;
                    if (reportMatchFailures) {
                      matchFailed("\")\"");
                    }
                  }
                  if (result4 !== null) {
                    var result1 = [result2, result3, result4];
                  } else {
                    var result1 = null;
                    pos = savedPos0;
                  }
                } else {
                  var result1 = null;
                  pos = savedPos0;
                }
              } else {
                var result1 = null;
                pos = savedPos0;
              }
              if (result1 !== null) {
                var result0 = result1;
              } else {
                var result0 = null;;
              };
            };
          };
        }
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[83] PathPrimary");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_PathNegatedPropertySet() {
        var cacheKey = 'PathNegatedPropertySet@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        
        var result11 = parse_PathOneInPropertySet();
        if (result11 !== null) {
          var result0 = result11;
        } else {
          var savedPos0 = pos;
          if (input.substr(pos, 1) === "(") {
            var result2 = "(";
            pos += 1;
          } else {
            var result2 = null;
            if (reportMatchFailures) {
              matchFailed("\"(\"");
            }
          }
          if (result2 !== null) {
            var savedPos1 = pos;
            var result6 = parse_PathOneInPropertySet();
            if (result6 !== null) {
              var result7 = [];
              var savedPos2 = pos;
              if (input.substr(pos, 1) === "|") {
                var result9 = "|";
                pos += 1;
              } else {
                var result9 = null;
                if (reportMatchFailures) {
                  matchFailed("\"|\"");
                }
              }
              if (result9 !== null) {
                var result10 = parse_PathOneInPropertySet();
                if (result10 !== null) {
                  var result8 = [result9, result10];
                } else {
                  var result8 = null;
                  pos = savedPos2;
                }
              } else {
                var result8 = null;
                pos = savedPos2;
              }
              while (result8 !== null) {
                result7.push(result8);
                var savedPos2 = pos;
                if (input.substr(pos, 1) === "|") {
                  var result9 = "|";
                  pos += 1;
                } else {
                  var result9 = null;
                  if (reportMatchFailures) {
                    matchFailed("\"|\"");
                  }
                }
                if (result9 !== null) {
                  var result10 = parse_PathOneInPropertySet();
                  if (result10 !== null) {
                    var result8 = [result9, result10];
                  } else {
                    var result8 = null;
                    pos = savedPos2;
                  }
                } else {
                  var result8 = null;
                  pos = savedPos2;
                }
              }
              if (result7 !== null) {
                var result5 = [result6, result7];
              } else {
                var result5 = null;
                pos = savedPos1;
              }
            } else {
              var result5 = null;
              pos = savedPos1;
            }
            var result3 = result5 !== null ? result5 : '';
            if (result3 !== null) {
              if (input.substr(pos, 1) === ")") {
                var result4 = ")";
                pos += 1;
              } else {
                var result4 = null;
                if (reportMatchFailures) {
                  matchFailed("\")\"");
                }
              }
              if (result4 !== null) {
                var result1 = [result2, result3, result4];
              } else {
                var result1 = null;
                pos = savedPos0;
              }
            } else {
              var result1 = null;
              pos = savedPos0;
            }
          } else {
            var result1 = null;
            pos = savedPos0;
          }
          if (result1 !== null) {
            var result0 = result1;
          } else {
            var result0 = null;;
          };
        }
        
        
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_PathOneInPropertySet() {
        var cacheKey = 'PathOneInPropertySet@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var result7 = parse_IRIref();
        if (result7 !== null) {
          var result0 = result7;
        } else {
          if (input.substr(pos, 1) === "a") {
            var result6 = "a";
            pos += 1;
          } else {
            var result6 = null;
            if (reportMatchFailures) {
              matchFailed("\"a\"");
            }
          }
          if (result6 !== null) {
            var result0 = result6;
          } else {
            var savedPos0 = pos;
            if (input.substr(pos, 1) === "^") {
              var result2 = "^";
              pos += 1;
            } else {
              var result2 = null;
              if (reportMatchFailures) {
                matchFailed("\"^\"");
              }
            }
            if (result2 !== null) {
              var result5 = parse_IRIref();
              if (result5 !== null) {
                var result3 = result5;
              } else {
                if (input.substr(pos, 1) === "a") {
                  var result4 = "a";
                  pos += 1;
                } else {
                  var result4 = null;
                  if (reportMatchFailures) {
                    matchFailed("\"a\"");
                  }
                }
                if (result4 !== null) {
                  var result3 = result4;
                } else {
                  var result3 = null;;
                };
              }
              if (result3 !== null) {
                var result1 = [result2, result3];
              } else {
                var result1 = null;
                pos = savedPos0;
              }
            } else {
              var result1 = null;
              pos = savedPos0;
            }
            if (result1 !== null) {
              var result0 = result1;
            } else {
              var result0 = null;;
            };
          };
        }
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[85] PathOneInPropertySet");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_TriplesNode() {
        var cacheKey = 'TriplesNode@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var result3 = parse_Collection();
        var result2 = result3 !== null
          ? (function(c) {
                triplesContext = [];
                chainSubject = [];
          
                var triple = null;
          
                // catch NIL
                /*
                if(c.length == 1 && c[0].token && c[0].token === 'nil') {
                    GlobalBlankNodeCounter++;
                    return  {token: "triplesnodecollection", 
                             triplesContext:[{subject: {token:'blank', label:("_:"+GlobalBlankNodeCounter)},
                                              predicate:{token:'uri', prefix:null, suffix:null, value:'http://www.w3.org/1999/02/22-rdf-syntax-ns#rest'},
                                              object:  {token:'blank', label:("_:"+(GlobalBlankNodeCounter+1))}}], 
                             chainSubject:{token:'blank', label:("_:"+GlobalBlankNodeCounter)}};
          
                }
                */
          
                // other cases
                for(var i=0; i<c.length; i++) {
                    GlobalBlankNodeCounter++;
                    //_:b0  rdf:first  1 ;
                    //rdf:rest   _:b1 .
                    var nextObject = null;
                    if(c[i].chainSubject == null && c[i].triplesContext == null) {
                        nextObject = c[i];
                    } else {
                        nextObject = c[i].chainSubject;
                        triplesContext = triplesContext.concat(nextSubject.triplesContext);
                    }
                    var currentSubject = null;
                    triple = {subject: {token:'blank', label:("_:"+GlobalBlankNodeCounter)},
                              predicate:{token:'uri', prefix:null, suffix:null, value:'http://www.w3.org/1999/02/22-rdf-syntax-ns#first'},
                              object:nextObject };
          
                    if(i==0) {
                        chainSubject.push(triple.subject);
                    }
          
                    triplesContext.push(triple);
          
                    if(i===(c.length-1)) {
                        triple = {subject: {token:'blank', label:("_:"+GlobalBlankNodeCounter)},
                                  predicate:{token:'uri', prefix:null, suffix:null, value:'http://www.w3.org/1999/02/22-rdf-syntax-ns#rest'},
                                  object:   {token:'uri', prefix:null, suffix:null, value:'http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'}};
                    } else {
                        triple = {subject: {token:'blank', label:("_:"+GlobalBlankNodeCounter)},
                                  predicate:{token:'uri', prefix:null, suffix:null, value:'http://www.w3.org/1999/02/22-rdf-syntax-ns#rest'},
                                  object:  {token:'blank', label:("_:"+(GlobalBlankNodeCounter+1))} };
                    }
          
                    triplesContext.push(triple);
                }
          
                return {token:"triplesnodecollection", triplesContext:triplesContext, chainSubject:chainSubject};
          })(result3)
          : null;
        if (result2 !== null) {
          var result0 = result2;
        } else {
          var result1 = parse_BlankNodePropertyList();
          if (result1 !== null) {
            var result0 = result1;
          } else {
            var result0 = null;;
          };
        }
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[87] TriplesNode");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_BlankNodePropertyList() {
        var cacheKey = 'BlankNodePropertyList@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        var result2 = [];
        var result12 = parse_WS();
        while (result12 !== null) {
          result2.push(result12);
          var result12 = parse_WS();
        }
        if (result2 !== null) {
          if (input.substr(pos, 1) === "[") {
            var result3 = "[";
            pos += 1;
          } else {
            var result3 = null;
            if (reportMatchFailures) {
              matchFailed("\"[\"");
            }
          }
          if (result3 !== null) {
            var result4 = [];
            var result11 = parse_WS();
            while (result11 !== null) {
              result4.push(result11);
              var result11 = parse_WS();
            }
            if (result4 !== null) {
              var result5 = parse_PropertyListNotEmpty();
              if (result5 !== null) {
                var result6 = [];
                var result10 = parse_WS();
                while (result10 !== null) {
                  result6.push(result10);
                  var result10 = parse_WS();
                }
                if (result6 !== null) {
                  if (input.substr(pos, 1) === "]") {
                    var result7 = "]";
                    pos += 1;
                  } else {
                    var result7 = null;
                    if (reportMatchFailures) {
                      matchFailed("\"]\"");
                    }
                  }
                  if (result7 !== null) {
                    var result8 = [];
                    var result9 = parse_WS();
                    while (result9 !== null) {
                      result8.push(result9);
                      var result9 = parse_WS();
                    }
                    if (result8 !== null) {
                      var result1 = [result2, result3, result4, result5, result6, result7, result8];
                    } else {
                      var result1 = null;
                      pos = savedPos0;
                    }
                  } else {
                    var result1 = null;
                    pos = savedPos0;
                  }
                } else {
                  var result1 = null;
                  pos = savedPos0;
                }
              } else {
                var result1 = null;
                pos = savedPos0;
              }
            } else {
              var result1 = null;
              pos = savedPos0;
            }
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        var result0 = result1 !== null
          ? (function(pl) {
          
                GlobalBlankNodeCounter++;
                var subject = {token:'blank', label:''+GlobalBlankNodeCounter};
                var newTriples =  [];
          
                for(var i=0; i< pl.pairs.length; i++) {
                    var pair = pl.pairs[i];
                    var triple = {}
                    triple.subject = subject;
                    triple.predicate = pair[0];
                    triple.object = pair[1];
                    newTriples.push(triple);
                }
          
                return {token: 'triplesnode',
                        kind: 'blanknodepropertylist',
                        triplesContext: pl.triplesContext.concat(newTriples),
                        chainSubject: subject};
          })(result1[3])
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[88] BlankNodePropertyList");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_Collection() {
        var cacheKey = 'Collection@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        var result2 = [];
        var result13 = parse_WS();
        while (result13 !== null) {
          result2.push(result13);
          var result13 = parse_WS();
        }
        if (result2 !== null) {
          if (input.substr(pos, 1) === "(") {
            var result3 = "(";
            pos += 1;
          } else {
            var result3 = null;
            if (reportMatchFailures) {
              matchFailed("\"(\"");
            }
          }
          if (result3 !== null) {
            var result4 = [];
            var result12 = parse_WS();
            while (result12 !== null) {
              result4.push(result12);
              var result12 = parse_WS();
            }
            if (result4 !== null) {
              var result11 = parse_GraphNode();
              if (result11 !== null) {
                var result5 = [];
                while (result11 !== null) {
                  result5.push(result11);
                  var result11 = parse_GraphNode();
                }
              } else {
                var result5 = null;
              }
              if (result5 !== null) {
                var result6 = [];
                var result10 = parse_WS();
                while (result10 !== null) {
                  result6.push(result10);
                  var result10 = parse_WS();
                }
                if (result6 !== null) {
                  if (input.substr(pos, 1) === ")") {
                    var result7 = ")";
                    pos += 1;
                  } else {
                    var result7 = null;
                    if (reportMatchFailures) {
                      matchFailed("\")\"");
                    }
                  }
                  if (result7 !== null) {
                    var result8 = [];
                    var result9 = parse_WS();
                    while (result9 !== null) {
                      result8.push(result9);
                      var result9 = parse_WS();
                    }
                    if (result8 !== null) {
                      var result1 = [result2, result3, result4, result5, result6, result7, result8];
                    } else {
                      var result1 = null;
                      pos = savedPos0;
                    }
                  } else {
                    var result1 = null;
                    pos = savedPos0;
                  }
                } else {
                  var result1 = null;
                  pos = savedPos0;
                }
              } else {
                var result1 = null;
                pos = savedPos0;
              }
            } else {
              var result1 = null;
              pos = savedPos0;
            }
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        var result0 = result1 !== null
          ? (function(gn) {
                return gn;
          })(result1[3])
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[89] Collection");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_GraphNode() {
        var cacheKey = 'GraphNode@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos1 = pos;
        var result9 = [];
        var result13 = parse_WS();
        while (result13 !== null) {
          result9.push(result13);
          var result13 = parse_WS();
        }
        if (result9 !== null) {
          var result10 = parse_VarOrTerm();
          if (result10 !== null) {
            var result11 = [];
            var result12 = parse_WS();
            while (result12 !== null) {
              result11.push(result12);
              var result12 = parse_WS();
            }
            if (result11 !== null) {
              var result8 = [result9, result10, result11];
            } else {
              var result8 = null;
              pos = savedPos1;
            }
          } else {
            var result8 = null;
            pos = savedPos1;
          }
        } else {
          var result8 = null;
          pos = savedPos1;
        }
        if (result8 !== null) {
          var result1 = result8;
        } else {
          var savedPos0 = pos;
          var result3 = [];
          var result7 = parse_WS();
          while (result7 !== null) {
            result3.push(result7);
            var result7 = parse_WS();
          }
          if (result3 !== null) {
            var result4 = parse_TriplesNode();
            if (result4 !== null) {
              var result5 = [];
              var result6 = parse_WS();
              while (result6 !== null) {
                result5.push(result6);
                var result6 = parse_WS();
              }
              if (result5 !== null) {
                var result2 = [result3, result4, result5];
              } else {
                var result2 = null;
                pos = savedPos0;
              }
            } else {
              var result2 = null;
              pos = savedPos0;
            }
          } else {
            var result2 = null;
            pos = savedPos0;
          }
          if (result2 !== null) {
            var result1 = result2;
          } else {
            var result1 = null;;
          };
        }
        var result0 = result1 !== null
          ? (function(gn) {
            return gn[1];
          })(result1)
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[90] GraphNode");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_VarOrTerm() {
        var cacheKey = 'VarOrTerm@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var result2 = parse_Var();
        if (result2 !== null) {
          var result0 = result2;
        } else {
          var result1 = parse_GraphTerm();
          if (result1 !== null) {
            var result0 = result1;
          } else {
            var result0 = null;;
          };
        }
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[91] VarOrTerm");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_VarOrIRIref() {
        var cacheKey = 'VarOrIRIref@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var result2 = parse_Var();
        if (result2 !== null) {
          var result0 = result2;
        } else {
          var result1 = parse_IRIref();
          if (result1 !== null) {
            var result0 = result1;
          } else {
            var result0 = null;;
          };
        }
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[92] VarOrIRIref");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_Var() {
        var cacheKey = 'Var@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var result3 = parse_VAR1();
        if (result3 !== null) {
          var result1 = result3;
        } else {
          var result2 = parse_VAR2();
          if (result2 !== null) {
            var result1 = result2;
          } else {
            var result1 = null;;
          };
        }
        var result0 = result1 !== null
          ? (function(v) {
                var term = {};
                term.token = 'var';
                term.value = v;
                return term;
            })(result1)
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[93] Var");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_GraphTerm() {
        var cacheKey = 'GraphTerm@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var result6 = parse_IRIref();
        if (result6 !== null) {
          var result0 = result6;
        } else {
          var result5 = parse_RDFLiteral();
          if (result5 !== null) {
            var result0 = result5;
          } else {
            var result4 = parse_NumericLiteral();
            if (result4 !== null) {
              var result0 = result4;
            } else {
              var result3 = parse_BooleanLiteral();
              if (result3 !== null) {
                var result0 = result3;
              } else {
                var result2 = parse_BlankNode();
                if (result2 !== null) {
                  var result0 = result2;
                } else {
                  var result1 = parse_NIL();
                  if (result1 !== null) {
                    var result0 = result1;
                  } else {
                    var result0 = null;;
                  };
                };
              };
            };
          };
        }
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[94] GraphTerm");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_ConditionalOrExpression() {
        var cacheKey = 'ConditionalOrExpression@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        var result2 = parse_ConditionalAndExpression();
        if (result2 !== null) {
          var result3 = [];
          var savedPos1 = pos;
          var result5 = [];
          var result10 = parse_WS();
          while (result10 !== null) {
            result5.push(result10);
            var result10 = parse_WS();
          }
          if (result5 !== null) {
            if (input.substr(pos, 2) === "||") {
              var result6 = "||";
              pos += 2;
            } else {
              var result6 = null;
              if (reportMatchFailures) {
                matchFailed("\"||\"");
              }
            }
            if (result6 !== null) {
              var result7 = [];
              var result9 = parse_WS();
              while (result9 !== null) {
                result7.push(result9);
                var result9 = parse_WS();
              }
              if (result7 !== null) {
                var result8 = parse_ConditionalAndExpression();
                if (result8 !== null) {
                  var result4 = [result5, result6, result7, result8];
                } else {
                  var result4 = null;
                  pos = savedPos1;
                }
              } else {
                var result4 = null;
                pos = savedPos1;
              }
            } else {
              var result4 = null;
              pos = savedPos1;
            }
          } else {
            var result4 = null;
            pos = savedPos1;
          }
          while (result4 !== null) {
            result3.push(result4);
            var savedPos1 = pos;
            var result5 = [];
            var result10 = parse_WS();
            while (result10 !== null) {
              result5.push(result10);
              var result10 = parse_WS();
            }
            if (result5 !== null) {
              if (input.substr(pos, 2) === "||") {
                var result6 = "||";
                pos += 2;
              } else {
                var result6 = null;
                if (reportMatchFailures) {
                  matchFailed("\"||\"");
                }
              }
              if (result6 !== null) {
                var result7 = [];
                var result9 = parse_WS();
                while (result9 !== null) {
                  result7.push(result9);
                  var result9 = parse_WS();
                }
                if (result7 !== null) {
                  var result8 = parse_ConditionalAndExpression();
                  if (result8 !== null) {
                    var result4 = [result5, result6, result7, result8];
                  } else {
                    var result4 = null;
                    pos = savedPos1;
                  }
                } else {
                  var result4 = null;
                  pos = savedPos1;
                }
              } else {
                var result4 = null;
                pos = savedPos1;
              }
            } else {
              var result4 = null;
              pos = savedPos1;
            }
          }
          if (result3 !== null) {
            var result1 = [result2, result3];
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        var result0 = result1 !== null
          ? (function(v, vs) {
                if(vs.length === 0) {
                    return v;
                }
          
                var exp = {};
                exp.token = "expression";
                exp.expressionType = "conditionalor";
                var ops = [v];
          
                for(var i=0; i<vs.length; i++) {
                    ops.push(vs[i][3]);
                }
          
                exp.operands = ops;
          
                return exp;
          })(result1[0], result1[1])
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[96] ConditionalOrExpression");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_ConditionalAndExpression() {
        var cacheKey = 'ConditionalAndExpression@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        var result2 = parse_RelationalExpression();
        if (result2 !== null) {
          var result3 = [];
          var savedPos1 = pos;
          var result5 = [];
          var result10 = parse_WS();
          while (result10 !== null) {
            result5.push(result10);
            var result10 = parse_WS();
          }
          if (result5 !== null) {
            if (input.substr(pos, 2) === "&&") {
              var result6 = "&&";
              pos += 2;
            } else {
              var result6 = null;
              if (reportMatchFailures) {
                matchFailed("\"&&\"");
              }
            }
            if (result6 !== null) {
              var result7 = [];
              var result9 = parse_WS();
              while (result9 !== null) {
                result7.push(result9);
                var result9 = parse_WS();
              }
              if (result7 !== null) {
                var result8 = parse_RelationalExpression();
                if (result8 !== null) {
                  var result4 = [result5, result6, result7, result8];
                } else {
                  var result4 = null;
                  pos = savedPos1;
                }
              } else {
                var result4 = null;
                pos = savedPos1;
              }
            } else {
              var result4 = null;
              pos = savedPos1;
            }
          } else {
            var result4 = null;
            pos = savedPos1;
          }
          while (result4 !== null) {
            result3.push(result4);
            var savedPos1 = pos;
            var result5 = [];
            var result10 = parse_WS();
            while (result10 !== null) {
              result5.push(result10);
              var result10 = parse_WS();
            }
            if (result5 !== null) {
              if (input.substr(pos, 2) === "&&") {
                var result6 = "&&";
                pos += 2;
              } else {
                var result6 = null;
                if (reportMatchFailures) {
                  matchFailed("\"&&\"");
                }
              }
              if (result6 !== null) {
                var result7 = [];
                var result9 = parse_WS();
                while (result9 !== null) {
                  result7.push(result9);
                  var result9 = parse_WS();
                }
                if (result7 !== null) {
                  var result8 = parse_RelationalExpression();
                  if (result8 !== null) {
                    var result4 = [result5, result6, result7, result8];
                  } else {
                    var result4 = null;
                    pos = savedPos1;
                  }
                } else {
                  var result4 = null;
                  pos = savedPos1;
                }
              } else {
                var result4 = null;
                pos = savedPos1;
              }
            } else {
              var result4 = null;
              pos = savedPos1;
            }
          }
          if (result3 !== null) {
            var result1 = [result2, result3];
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        var result0 = result1 !== null
          ? (function(v, vs) {
                if(vs.length === 0) {
                    return v;
                }
                var exp = {};
                exp.token = "expression";
                exp.expressionType = "conditionaland";
                var ops = [v];
          
                for(var i=0; i<vs.length; i++) {
                    ops.push(vs[i][3]);
                }
          
                exp.operands = ops;
          
                return exp;
          })(result1[0], result1[1])
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[97] ConditionalAndExpression");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_RelationalExpression() {
        var cacheKey = 'RelationalExpression@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        var result2 = parse_AdditiveExpression();
        if (result2 !== null) {
          var result3 = [];
          var savedPos6 = pos;
          var result41 = [];
          var result46 = parse_WS();
          while (result46 !== null) {
            result41.push(result46);
            var result46 = parse_WS();
          }
          if (result41 !== null) {
            if (input.substr(pos, 1) === "=") {
              var result42 = "=";
              pos += 1;
            } else {
              var result42 = null;
              if (reportMatchFailures) {
                matchFailed("\"=\"");
              }
            }
            if (result42 !== null) {
              var result43 = [];
              var result45 = parse_WS();
              while (result45 !== null) {
                result43.push(result45);
                var result45 = parse_WS();
              }
              if (result43 !== null) {
                var result44 = parse_AdditiveExpression();
                if (result44 !== null) {
                  var result40 = [result41, result42, result43, result44];
                } else {
                  var result40 = null;
                  pos = savedPos6;
                }
              } else {
                var result40 = null;
                pos = savedPos6;
              }
            } else {
              var result40 = null;
              pos = savedPos6;
            }
          } else {
            var result40 = null;
            pos = savedPos6;
          }
          if (result40 !== null) {
            var result4 = result40;
          } else {
            var savedPos5 = pos;
            var result34 = [];
            var result39 = parse_WS();
            while (result39 !== null) {
              result34.push(result39);
              var result39 = parse_WS();
            }
            if (result34 !== null) {
              if (input.substr(pos, 2) === "!=") {
                var result35 = "!=";
                pos += 2;
              } else {
                var result35 = null;
                if (reportMatchFailures) {
                  matchFailed("\"!=\"");
                }
              }
              if (result35 !== null) {
                var result36 = [];
                var result38 = parse_WS();
                while (result38 !== null) {
                  result36.push(result38);
                  var result38 = parse_WS();
                }
                if (result36 !== null) {
                  var result37 = parse_AdditiveExpression();
                  if (result37 !== null) {
                    var result33 = [result34, result35, result36, result37];
                  } else {
                    var result33 = null;
                    pos = savedPos5;
                  }
                } else {
                  var result33 = null;
                  pos = savedPos5;
                }
              } else {
                var result33 = null;
                pos = savedPos5;
              }
            } else {
              var result33 = null;
              pos = savedPos5;
            }
            if (result33 !== null) {
              var result4 = result33;
            } else {
              var savedPos4 = pos;
              var result27 = [];
              var result32 = parse_WS();
              while (result32 !== null) {
                result27.push(result32);
                var result32 = parse_WS();
              }
              if (result27 !== null) {
                if (input.substr(pos, 1) === "<") {
                  var result28 = "<";
                  pos += 1;
                } else {
                  var result28 = null;
                  if (reportMatchFailures) {
                    matchFailed("\"<\"");
                  }
                }
                if (result28 !== null) {
                  var result29 = [];
                  var result31 = parse_WS();
                  while (result31 !== null) {
                    result29.push(result31);
                    var result31 = parse_WS();
                  }
                  if (result29 !== null) {
                    var result30 = parse_AdditiveExpression();
                    if (result30 !== null) {
                      var result26 = [result27, result28, result29, result30];
                    } else {
                      var result26 = null;
                      pos = savedPos4;
                    }
                  } else {
                    var result26 = null;
                    pos = savedPos4;
                  }
                } else {
                  var result26 = null;
                  pos = savedPos4;
                }
              } else {
                var result26 = null;
                pos = savedPos4;
              }
              if (result26 !== null) {
                var result4 = result26;
              } else {
                var savedPos3 = pos;
                var result20 = [];
                var result25 = parse_WS();
                while (result25 !== null) {
                  result20.push(result25);
                  var result25 = parse_WS();
                }
                if (result20 !== null) {
                  if (input.substr(pos, 1) === ">") {
                    var result21 = ">";
                    pos += 1;
                  } else {
                    var result21 = null;
                    if (reportMatchFailures) {
                      matchFailed("\">\"");
                    }
                  }
                  if (result21 !== null) {
                    var result22 = [];
                    var result24 = parse_WS();
                    while (result24 !== null) {
                      result22.push(result24);
                      var result24 = parse_WS();
                    }
                    if (result22 !== null) {
                      var result23 = parse_AdditiveExpression();
                      if (result23 !== null) {
                        var result19 = [result20, result21, result22, result23];
                      } else {
                        var result19 = null;
                        pos = savedPos3;
                      }
                    } else {
                      var result19 = null;
                      pos = savedPos3;
                    }
                  } else {
                    var result19 = null;
                    pos = savedPos3;
                  }
                } else {
                  var result19 = null;
                  pos = savedPos3;
                }
                if (result19 !== null) {
                  var result4 = result19;
                } else {
                  var savedPos2 = pos;
                  var result13 = [];
                  var result18 = parse_WS();
                  while (result18 !== null) {
                    result13.push(result18);
                    var result18 = parse_WS();
                  }
                  if (result13 !== null) {
                    if (input.substr(pos, 2) === "<=") {
                      var result14 = "<=";
                      pos += 2;
                    } else {
                      var result14 = null;
                      if (reportMatchFailures) {
                        matchFailed("\"<=\"");
                      }
                    }
                    if (result14 !== null) {
                      var result15 = [];
                      var result17 = parse_WS();
                      while (result17 !== null) {
                        result15.push(result17);
                        var result17 = parse_WS();
                      }
                      if (result15 !== null) {
                        var result16 = parse_AdditiveExpression();
                        if (result16 !== null) {
                          var result12 = [result13, result14, result15, result16];
                        } else {
                          var result12 = null;
                          pos = savedPos2;
                        }
                      } else {
                        var result12 = null;
                        pos = savedPos2;
                      }
                    } else {
                      var result12 = null;
                      pos = savedPos2;
                    }
                  } else {
                    var result12 = null;
                    pos = savedPos2;
                  }
                  if (result12 !== null) {
                    var result4 = result12;
                  } else {
                    var savedPos1 = pos;
                    var result6 = [];
                    var result11 = parse_WS();
                    while (result11 !== null) {
                      result6.push(result11);
                      var result11 = parse_WS();
                    }
                    if (result6 !== null) {
                      if (input.substr(pos, 2) === ">=") {
                        var result7 = ">=";
                        pos += 2;
                      } else {
                        var result7 = null;
                        if (reportMatchFailures) {
                          matchFailed("\">=\"");
                        }
                      }
                      if (result7 !== null) {
                        var result8 = [];
                        var result10 = parse_WS();
                        while (result10 !== null) {
                          result8.push(result10);
                          var result10 = parse_WS();
                        }
                        if (result8 !== null) {
                          var result9 = parse_AdditiveExpression();
                          if (result9 !== null) {
                            var result5 = [result6, result7, result8, result9];
                          } else {
                            var result5 = null;
                            pos = savedPos1;
                          }
                        } else {
                          var result5 = null;
                          pos = savedPos1;
                        }
                      } else {
                        var result5 = null;
                        pos = savedPos1;
                      }
                    } else {
                      var result5 = null;
                      pos = savedPos1;
                    }
                    if (result5 !== null) {
                      var result4 = result5;
                    } else {
                      var result4 = null;;
                    };
                  };
                };
              };
            };
          }
          while (result4 !== null) {
            result3.push(result4);
            var savedPos6 = pos;
            var result41 = [];
            var result46 = parse_WS();
            while (result46 !== null) {
              result41.push(result46);
              var result46 = parse_WS();
            }
            if (result41 !== null) {
              if (input.substr(pos, 1) === "=") {
                var result42 = "=";
                pos += 1;
              } else {
                var result42 = null;
                if (reportMatchFailures) {
                  matchFailed("\"=\"");
                }
              }
              if (result42 !== null) {
                var result43 = [];
                var result45 = parse_WS();
                while (result45 !== null) {
                  result43.push(result45);
                  var result45 = parse_WS();
                }
                if (result43 !== null) {
                  var result44 = parse_AdditiveExpression();
                  if (result44 !== null) {
                    var result40 = [result41, result42, result43, result44];
                  } else {
                    var result40 = null;
                    pos = savedPos6;
                  }
                } else {
                  var result40 = null;
                  pos = savedPos6;
                }
              } else {
                var result40 = null;
                pos = savedPos6;
              }
            } else {
              var result40 = null;
              pos = savedPos6;
            }
            if (result40 !== null) {
              var result4 = result40;
            } else {
              var savedPos5 = pos;
              var result34 = [];
              var result39 = parse_WS();
              while (result39 !== null) {
                result34.push(result39);
                var result39 = parse_WS();
              }
              if (result34 !== null) {
                if (input.substr(pos, 2) === "!=") {
                  var result35 = "!=";
                  pos += 2;
                } else {
                  var result35 = null;
                  if (reportMatchFailures) {
                    matchFailed("\"!=\"");
                  }
                }
                if (result35 !== null) {
                  var result36 = [];
                  var result38 = parse_WS();
                  while (result38 !== null) {
                    result36.push(result38);
                    var result38 = parse_WS();
                  }
                  if (result36 !== null) {
                    var result37 = parse_AdditiveExpression();
                    if (result37 !== null) {
                      var result33 = [result34, result35, result36, result37];
                    } else {
                      var result33 = null;
                      pos = savedPos5;
                    }
                  } else {
                    var result33 = null;
                    pos = savedPos5;
                  }
                } else {
                  var result33 = null;
                  pos = savedPos5;
                }
              } else {
                var result33 = null;
                pos = savedPos5;
              }
              if (result33 !== null) {
                var result4 = result33;
              } else {
                var savedPos4 = pos;
                var result27 = [];
                var result32 = parse_WS();
                while (result32 !== null) {
                  result27.push(result32);
                  var result32 = parse_WS();
                }
                if (result27 !== null) {
                  if (input.substr(pos, 1) === "<") {
                    var result28 = "<";
                    pos += 1;
                  } else {
                    var result28 = null;
                    if (reportMatchFailures) {
                      matchFailed("\"<\"");
                    }
                  }
                  if (result28 !== null) {
                    var result29 = [];
                    var result31 = parse_WS();
                    while (result31 !== null) {
                      result29.push(result31);
                      var result31 = parse_WS();
                    }
                    if (result29 !== null) {
                      var result30 = parse_AdditiveExpression();
                      if (result30 !== null) {
                        var result26 = [result27, result28, result29, result30];
                      } else {
                        var result26 = null;
                        pos = savedPos4;
                      }
                    } else {
                      var result26 = null;
                      pos = savedPos4;
                    }
                  } else {
                    var result26 = null;
                    pos = savedPos4;
                  }
                } else {
                  var result26 = null;
                  pos = savedPos4;
                }
                if (result26 !== null) {
                  var result4 = result26;
                } else {
                  var savedPos3 = pos;
                  var result20 = [];
                  var result25 = parse_WS();
                  while (result25 !== null) {
                    result20.push(result25);
                    var result25 = parse_WS();
                  }
                  if (result20 !== null) {
                    if (input.substr(pos, 1) === ">") {
                      var result21 = ">";
                      pos += 1;
                    } else {
                      var result21 = null;
                      if (reportMatchFailures) {
                        matchFailed("\">\"");
                      }
                    }
                    if (result21 !== null) {
                      var result22 = [];
                      var result24 = parse_WS();
                      while (result24 !== null) {
                        result22.push(result24);
                        var result24 = parse_WS();
                      }
                      if (result22 !== null) {
                        var result23 = parse_AdditiveExpression();
                        if (result23 !== null) {
                          var result19 = [result20, result21, result22, result23];
                        } else {
                          var result19 = null;
                          pos = savedPos3;
                        }
                      } else {
                        var result19 = null;
                        pos = savedPos3;
                      }
                    } else {
                      var result19 = null;
                      pos = savedPos3;
                    }
                  } else {
                    var result19 = null;
                    pos = savedPos3;
                  }
                  if (result19 !== null) {
                    var result4 = result19;
                  } else {
                    var savedPos2 = pos;
                    var result13 = [];
                    var result18 = parse_WS();
                    while (result18 !== null) {
                      result13.push(result18);
                      var result18 = parse_WS();
                    }
                    if (result13 !== null) {
                      if (input.substr(pos, 2) === "<=") {
                        var result14 = "<=";
                        pos += 2;
                      } else {
                        var result14 = null;
                        if (reportMatchFailures) {
                          matchFailed("\"<=\"");
                        }
                      }
                      if (result14 !== null) {
                        var result15 = [];
                        var result17 = parse_WS();
                        while (result17 !== null) {
                          result15.push(result17);
                          var result17 = parse_WS();
                        }
                        if (result15 !== null) {
                          var result16 = parse_AdditiveExpression();
                          if (result16 !== null) {
                            var result12 = [result13, result14, result15, result16];
                          } else {
                            var result12 = null;
                            pos = savedPos2;
                          }
                        } else {
                          var result12 = null;
                          pos = savedPos2;
                        }
                      } else {
                        var result12 = null;
                        pos = savedPos2;
                      }
                    } else {
                      var result12 = null;
                      pos = savedPos2;
                    }
                    if (result12 !== null) {
                      var result4 = result12;
                    } else {
                      var savedPos1 = pos;
                      var result6 = [];
                      var result11 = parse_WS();
                      while (result11 !== null) {
                        result6.push(result11);
                        var result11 = parse_WS();
                      }
                      if (result6 !== null) {
                        if (input.substr(pos, 2) === ">=") {
                          var result7 = ">=";
                          pos += 2;
                        } else {
                          var result7 = null;
                          if (reportMatchFailures) {
                            matchFailed("\">=\"");
                          }
                        }
                        if (result7 !== null) {
                          var result8 = [];
                          var result10 = parse_WS();
                          while (result10 !== null) {
                            result8.push(result10);
                            var result10 = parse_WS();
                          }
                          if (result8 !== null) {
                            var result9 = parse_AdditiveExpression();
                            if (result9 !== null) {
                              var result5 = [result6, result7, result8, result9];
                            } else {
                              var result5 = null;
                              pos = savedPos1;
                            }
                          } else {
                            var result5 = null;
                            pos = savedPos1;
                          }
                        } else {
                          var result5 = null;
                          pos = savedPos1;
                        }
                      } else {
                        var result5 = null;
                        pos = savedPos1;
                      }
                      if (result5 !== null) {
                        var result4 = result5;
                      } else {
                        var result4 = null;;
                      };
                    };
                  };
                };
              };
            }
          }
          if (result3 !== null) {
            var result1 = [result2, result3];
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        var result0 = result1 !== null
          ? (function(op1, op2) {
                if(op2.length === 0) {
                    return op1;
                } else {
                  var exp = {};
                  exp.expressionType = "relationalexpression"
                  exp.operator = op2[0][1];
                  exp.op1 = op1;
                  exp.op2 = op2[0][3];
                  exp.token = "expression";
          
                  return exp;
                }
            })(result1[0], result1[1])
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[99] RelationalExpression");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_AdditiveExpression() {
        var cacheKey = 'AdditiveExpression@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        var result2 = parse_MultiplicativeExpression();
        if (result2 !== null) {
          var result3 = [];
          var savedPos5 = pos;
          var result33 = [];
          var result38 = parse_WS();
          while (result38 !== null) {
            result33.push(result38);
            var result38 = parse_WS();
          }
          if (result33 !== null) {
            if (input.substr(pos, 1) === "+") {
              var result34 = "+";
              pos += 1;
            } else {
              var result34 = null;
              if (reportMatchFailures) {
                matchFailed("\"+\"");
              }
            }
            if (result34 !== null) {
              var result35 = [];
              var result37 = parse_WS();
              while (result37 !== null) {
                result35.push(result37);
                var result37 = parse_WS();
              }
              if (result35 !== null) {
                var result36 = parse_MultiplicativeExpression();
                if (result36 !== null) {
                  var result32 = [result33, result34, result35, result36];
                } else {
                  var result32 = null;
                  pos = savedPos5;
                }
              } else {
                var result32 = null;
                pos = savedPos5;
              }
            } else {
              var result32 = null;
              pos = savedPos5;
            }
          } else {
            var result32 = null;
            pos = savedPos5;
          }
          if (result32 !== null) {
            var result4 = result32;
          } else {
            var savedPos4 = pos;
            var result26 = [];
            var result31 = parse_WS();
            while (result31 !== null) {
              result26.push(result31);
              var result31 = parse_WS();
            }
            if (result26 !== null) {
              if (input.substr(pos, 1) === "-") {
                var result27 = "-";
                pos += 1;
              } else {
                var result27 = null;
                if (reportMatchFailures) {
                  matchFailed("\"-\"");
                }
              }
              if (result27 !== null) {
                var result28 = [];
                var result30 = parse_WS();
                while (result30 !== null) {
                  result28.push(result30);
                  var result30 = parse_WS();
                }
                if (result28 !== null) {
                  var result29 = parse_MultiplicativeExpression();
                  if (result29 !== null) {
                    var result25 = [result26, result27, result28, result29];
                  } else {
                    var result25 = null;
                    pos = savedPos4;
                  }
                } else {
                  var result25 = null;
                  pos = savedPos4;
                }
              } else {
                var result25 = null;
                pos = savedPos4;
              }
            } else {
              var result25 = null;
              pos = savedPos4;
            }
            if (result25 !== null) {
              var result4 = result25;
            } else {
              var savedPos1 = pos;
              var result24 = parse_NumericLiteralNegative();
              if (result24 !== null) {
                var result6 = result24;
              } else {
                var result23 = parse_NumericLiteralNegative();
                if (result23 !== null) {
                  var result6 = result23;
                } else {
                  var result6 = null;;
                };
              }
              if (result6 !== null) {
                var savedPos3 = pos;
                var result17 = [];
                var result22 = parse_WS();
                while (result22 !== null) {
                  result17.push(result22);
                  var result22 = parse_WS();
                }
                if (result17 !== null) {
                  if (input.substr(pos, 1) === "*") {
                    var result18 = "*";
                    pos += 1;
                  } else {
                    var result18 = null;
                    if (reportMatchFailures) {
                      matchFailed("\"*\"");
                    }
                  }
                  if (result18 !== null) {
                    var result19 = [];
                    var result21 = parse_WS();
                    while (result21 !== null) {
                      result19.push(result21);
                      var result21 = parse_WS();
                    }
                    if (result19 !== null) {
                      var result20 = parse_UnaryExpression();
                      if (result20 !== null) {
                        var result16 = [result17, result18, result19, result20];
                      } else {
                        var result16 = null;
                        pos = savedPos3;
                      }
                    } else {
                      var result16 = null;
                      pos = savedPos3;
                    }
                  } else {
                    var result16 = null;
                    pos = savedPos3;
                  }
                } else {
                  var result16 = null;
                  pos = savedPos3;
                }
                if (result16 !== null) {
                  var result8 = result16;
                } else {
                  var savedPos2 = pos;
                  var result10 = [];
                  var result15 = parse_WS();
                  while (result15 !== null) {
                    result10.push(result15);
                    var result15 = parse_WS();
                  }
                  if (result10 !== null) {
                    if (input.substr(pos, 1) === "/") {
                      var result11 = "/";
                      pos += 1;
                    } else {
                      var result11 = null;
                      if (reportMatchFailures) {
                        matchFailed("\"/\"");
                      }
                    }
                    if (result11 !== null) {
                      var result12 = [];
                      var result14 = parse_WS();
                      while (result14 !== null) {
                        result12.push(result14);
                        var result14 = parse_WS();
                      }
                      if (result12 !== null) {
                        var result13 = parse_UnaryExpression();
                        if (result13 !== null) {
                          var result9 = [result10, result11, result12, result13];
                        } else {
                          var result9 = null;
                          pos = savedPos2;
                        }
                      } else {
                        var result9 = null;
                        pos = savedPos2;
                      }
                    } else {
                      var result9 = null;
                      pos = savedPos2;
                    }
                  } else {
                    var result9 = null;
                    pos = savedPos2;
                  }
                  if (result9 !== null) {
                    var result8 = result9;
                  } else {
                    var result8 = null;;
                  };
                }
                var result7 = result8 !== null ? result8 : '';
                if (result7 !== null) {
                  var result5 = [result6, result7];
                } else {
                  var result5 = null;
                  pos = savedPos1;
                }
              } else {
                var result5 = null;
                pos = savedPos1;
              }
              if (result5 !== null) {
                var result4 = result5;
              } else {
                var result4 = null;;
              };
            };
          }
          while (result4 !== null) {
            result3.push(result4);
            var savedPos5 = pos;
            var result33 = [];
            var result38 = parse_WS();
            while (result38 !== null) {
              result33.push(result38);
              var result38 = parse_WS();
            }
            if (result33 !== null) {
              if (input.substr(pos, 1) === "+") {
                var result34 = "+";
                pos += 1;
              } else {
                var result34 = null;
                if (reportMatchFailures) {
                  matchFailed("\"+\"");
                }
              }
              if (result34 !== null) {
                var result35 = [];
                var result37 = parse_WS();
                while (result37 !== null) {
                  result35.push(result37);
                  var result37 = parse_WS();
                }
                if (result35 !== null) {
                  var result36 = parse_MultiplicativeExpression();
                  if (result36 !== null) {
                    var result32 = [result33, result34, result35, result36];
                  } else {
                    var result32 = null;
                    pos = savedPos5;
                  }
                } else {
                  var result32 = null;
                  pos = savedPos5;
                }
              } else {
                var result32 = null;
                pos = savedPos5;
              }
            } else {
              var result32 = null;
              pos = savedPos5;
            }
            if (result32 !== null) {
              var result4 = result32;
            } else {
              var savedPos4 = pos;
              var result26 = [];
              var result31 = parse_WS();
              while (result31 !== null) {
                result26.push(result31);
                var result31 = parse_WS();
              }
              if (result26 !== null) {
                if (input.substr(pos, 1) === "-") {
                  var result27 = "-";
                  pos += 1;
                } else {
                  var result27 = null;
                  if (reportMatchFailures) {
                    matchFailed("\"-\"");
                  }
                }
                if (result27 !== null) {
                  var result28 = [];
                  var result30 = parse_WS();
                  while (result30 !== null) {
                    result28.push(result30);
                    var result30 = parse_WS();
                  }
                  if (result28 !== null) {
                    var result29 = parse_MultiplicativeExpression();
                    if (result29 !== null) {
                      var result25 = [result26, result27, result28, result29];
                    } else {
                      var result25 = null;
                      pos = savedPos4;
                    }
                  } else {
                    var result25 = null;
                    pos = savedPos4;
                  }
                } else {
                  var result25 = null;
                  pos = savedPos4;
                }
              } else {
                var result25 = null;
                pos = savedPos4;
              }
              if (result25 !== null) {
                var result4 = result25;
              } else {
                var savedPos1 = pos;
                var result24 = parse_NumericLiteralNegative();
                if (result24 !== null) {
                  var result6 = result24;
                } else {
                  var result23 = parse_NumericLiteralNegative();
                  if (result23 !== null) {
                    var result6 = result23;
                  } else {
                    var result6 = null;;
                  };
                }
                if (result6 !== null) {
                  var savedPos3 = pos;
                  var result17 = [];
                  var result22 = parse_WS();
                  while (result22 !== null) {
                    result17.push(result22);
                    var result22 = parse_WS();
                  }
                  if (result17 !== null) {
                    if (input.substr(pos, 1) === "*") {
                      var result18 = "*";
                      pos += 1;
                    } else {
                      var result18 = null;
                      if (reportMatchFailures) {
                        matchFailed("\"*\"");
                      }
                    }
                    if (result18 !== null) {
                      var result19 = [];
                      var result21 = parse_WS();
                      while (result21 !== null) {
                        result19.push(result21);
                        var result21 = parse_WS();
                      }
                      if (result19 !== null) {
                        var result20 = parse_UnaryExpression();
                        if (result20 !== null) {
                          var result16 = [result17, result18, result19, result20];
                        } else {
                          var result16 = null;
                          pos = savedPos3;
                        }
                      } else {
                        var result16 = null;
                        pos = savedPos3;
                      }
                    } else {
                      var result16 = null;
                      pos = savedPos3;
                    }
                  } else {
                    var result16 = null;
                    pos = savedPos3;
                  }
                  if (result16 !== null) {
                    var result8 = result16;
                  } else {
                    var savedPos2 = pos;
                    var result10 = [];
                    var result15 = parse_WS();
                    while (result15 !== null) {
                      result10.push(result15);
                      var result15 = parse_WS();
                    }
                    if (result10 !== null) {
                      if (input.substr(pos, 1) === "/") {
                        var result11 = "/";
                        pos += 1;
                      } else {
                        var result11 = null;
                        if (reportMatchFailures) {
                          matchFailed("\"/\"");
                        }
                      }
                      if (result11 !== null) {
                        var result12 = [];
                        var result14 = parse_WS();
                        while (result14 !== null) {
                          result12.push(result14);
                          var result14 = parse_WS();
                        }
                        if (result12 !== null) {
                          var result13 = parse_UnaryExpression();
                          if (result13 !== null) {
                            var result9 = [result10, result11, result12, result13];
                          } else {
                            var result9 = null;
                            pos = savedPos2;
                          }
                        } else {
                          var result9 = null;
                          pos = savedPos2;
                        }
                      } else {
                        var result9 = null;
                        pos = savedPos2;
                      }
                    } else {
                      var result9 = null;
                      pos = savedPos2;
                    }
                    if (result9 !== null) {
                      var result8 = result9;
                    } else {
                      var result8 = null;;
                    };
                  }
                  var result7 = result8 !== null ? result8 : '';
                  if (result7 !== null) {
                    var result5 = [result6, result7];
                  } else {
                    var result5 = null;
                    pos = savedPos1;
                  }
                } else {
                  var result5 = null;
                  pos = savedPos1;
                }
                if (result5 !== null) {
                  var result4 = result5;
                } else {
                  var result4 = null;;
                };
              };
            }
          }
          if (result3 !== null) {
            var result1 = [result2, result3];
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        var result0 = result1 !== null
          ? (function(op1, ops) {
                if(ops.length === 0) {
                    return op1;
                }
          
                var ex = {};
                ex.token = 'expression';
                ex.expressionType = 'additiveexpression';
                ex.summand = op1;
                ex.summands = [];
          
                for(var i=0; i<ops.length; i++) {
                    var summand = ops[i];
                    var sum = {};
                    if(summand.length == 4 && typeof(summand[1]) === "string") {
                        sum.operator = summand[1];
                        sum.expression = summand[3];
                    } else {
                        var subexp = {}
                        var firstFactor = sum[0];
                        var operator = sum[1][1];
                        var secondFactor = sum[1][3];
                        var operator = null;
                        if(firstFactor.value < 0) {
                            sum.operator = '-';
                            firstFactor.value = - firstFactor.value;
                        } else {
                            sum.operator = '+';
                        }
                        subexp.token = 'expression';
                        subexp.expressionType = 'multiplicativeexpression';
                        subexp.operator = firstFactor;
                        subexp.factors = [{operator: operator, expression: secondFactor}];
          
                        sum.expression = subexp;
                    }
                    ex.summands.push(sum);
                }
          
                return ex;
          })(result1[0], result1[1])
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[101] AdditiveExpression");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_MultiplicativeExpression() {
        var cacheKey = 'MultiplicativeExpression@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        var result2 = parse_UnaryExpression();
        if (result2 !== null) {
          var result3 = [];
          var savedPos2 = pos;
          var result13 = [];
          var result18 = parse_WS();
          while (result18 !== null) {
            result13.push(result18);
            var result18 = parse_WS();
          }
          if (result13 !== null) {
            if (input.substr(pos, 1) === "*") {
              var result14 = "*";
              pos += 1;
            } else {
              var result14 = null;
              if (reportMatchFailures) {
                matchFailed("\"*\"");
              }
            }
            if (result14 !== null) {
              var result15 = [];
              var result17 = parse_WS();
              while (result17 !== null) {
                result15.push(result17);
                var result17 = parse_WS();
              }
              if (result15 !== null) {
                var result16 = parse_UnaryExpression();
                if (result16 !== null) {
                  var result12 = [result13, result14, result15, result16];
                } else {
                  var result12 = null;
                  pos = savedPos2;
                }
              } else {
                var result12 = null;
                pos = savedPos2;
              }
            } else {
              var result12 = null;
              pos = savedPos2;
            }
          } else {
            var result12 = null;
            pos = savedPos2;
          }
          if (result12 !== null) {
            var result4 = result12;
          } else {
            var savedPos1 = pos;
            var result6 = [];
            var result11 = parse_WS();
            while (result11 !== null) {
              result6.push(result11);
              var result11 = parse_WS();
            }
            if (result6 !== null) {
              if (input.substr(pos, 1) === "/") {
                var result7 = "/";
                pos += 1;
              } else {
                var result7 = null;
                if (reportMatchFailures) {
                  matchFailed("\"/\"");
                }
              }
              if (result7 !== null) {
                var result8 = [];
                var result10 = parse_WS();
                while (result10 !== null) {
                  result8.push(result10);
                  var result10 = parse_WS();
                }
                if (result8 !== null) {
                  var result9 = parse_UnaryExpression();
                  if (result9 !== null) {
                    var result5 = [result6, result7, result8, result9];
                  } else {
                    var result5 = null;
                    pos = savedPos1;
                  }
                } else {
                  var result5 = null;
                  pos = savedPos1;
                }
              } else {
                var result5 = null;
                pos = savedPos1;
              }
            } else {
              var result5 = null;
              pos = savedPos1;
            }
            if (result5 !== null) {
              var result4 = result5;
            } else {
              var result4 = null;;
            };
          }
          while (result4 !== null) {
            result3.push(result4);
            var savedPos2 = pos;
            var result13 = [];
            var result18 = parse_WS();
            while (result18 !== null) {
              result13.push(result18);
              var result18 = parse_WS();
            }
            if (result13 !== null) {
              if (input.substr(pos, 1) === "*") {
                var result14 = "*";
                pos += 1;
              } else {
                var result14 = null;
                if (reportMatchFailures) {
                  matchFailed("\"*\"");
                }
              }
              if (result14 !== null) {
                var result15 = [];
                var result17 = parse_WS();
                while (result17 !== null) {
                  result15.push(result17);
                  var result17 = parse_WS();
                }
                if (result15 !== null) {
                  var result16 = parse_UnaryExpression();
                  if (result16 !== null) {
                    var result12 = [result13, result14, result15, result16];
                  } else {
                    var result12 = null;
                    pos = savedPos2;
                  }
                } else {
                  var result12 = null;
                  pos = savedPos2;
                }
              } else {
                var result12 = null;
                pos = savedPos2;
              }
            } else {
              var result12 = null;
              pos = savedPos2;
            }
            if (result12 !== null) {
              var result4 = result12;
            } else {
              var savedPos1 = pos;
              var result6 = [];
              var result11 = parse_WS();
              while (result11 !== null) {
                result6.push(result11);
                var result11 = parse_WS();
              }
              if (result6 !== null) {
                if (input.substr(pos, 1) === "/") {
                  var result7 = "/";
                  pos += 1;
                } else {
                  var result7 = null;
                  if (reportMatchFailures) {
                    matchFailed("\"/\"");
                  }
                }
                if (result7 !== null) {
                  var result8 = [];
                  var result10 = parse_WS();
                  while (result10 !== null) {
                    result8.push(result10);
                    var result10 = parse_WS();
                  }
                  if (result8 !== null) {
                    var result9 = parse_UnaryExpression();
                    if (result9 !== null) {
                      var result5 = [result6, result7, result8, result9];
                    } else {
                      var result5 = null;
                      pos = savedPos1;
                    }
                  } else {
                    var result5 = null;
                    pos = savedPos1;
                  }
                } else {
                  var result5 = null;
                  pos = savedPos1;
                }
              } else {
                var result5 = null;
                pos = savedPos1;
              }
              if (result5 !== null) {
                var result4 = result5;
              } else {
                var result4 = null;;
              };
            }
          }
          if (result3 !== null) {
            var result1 = [result2, result3];
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        var result0 = result1 !== null
          ? (function(exp, exps) {
                if(exps.length === 0) {
                    return exp;
                }
          
                var ex = {};
                ex.token = 'expression';
                ex.expressionType = 'multiplicativeexpression';
                ex.factor = exp;
                ex.factors = [];
                for(var i=0; i<exps.length; i++) {
                    var factor = exps[i];
                    var fact = {};
                    fact.operator = factor[1];
                    fact.expression = factor[3];
                    ex.factors.push(fact);
                }
          
                return ex;
          })(result1[0], result1[1])
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[102] MultiplicativeExpression");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_UnaryExpression() {
        var cacheKey = 'UnaryExpression@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos2 = pos;
        if (input.substr(pos, 1) === "!") {
          var result16 = "!";
          pos += 1;
        } else {
          var result16 = null;
          if (reportMatchFailures) {
            matchFailed("\"!\"");
          }
        }
        if (result16 !== null) {
          var result17 = [];
          var result19 = parse_WS();
          while (result19 !== null) {
            result17.push(result19);
            var result19 = parse_WS();
          }
          if (result17 !== null) {
            var result18 = parse_PrimaryExpression();
            if (result18 !== null) {
              var result15 = [result16, result17, result18];
            } else {
              var result15 = null;
              pos = savedPos2;
            }
          } else {
            var result15 = null;
            pos = savedPos2;
          }
        } else {
          var result15 = null;
          pos = savedPos2;
        }
        var result14 = result15 !== null
          ? (function(e) {
                var ex = {};
                ex.token = 'expression';
                ex.expressionType = 'unaryexpression';
                ex.unaryexpression = "!";
                ex.expression = e;
          
                return ex;
            })(result15[2])
          : null;
        if (result14 !== null) {
          var result0 = result14;
        } else {
          var savedPos1 = pos;
          if (input.substr(pos, 1) === "+") {
            var result10 = "+";
            pos += 1;
          } else {
            var result10 = null;
            if (reportMatchFailures) {
              matchFailed("\"+\"");
            }
          }
          if (result10 !== null) {
            var result11 = [];
            var result13 = parse_WS();
            while (result13 !== null) {
              result11.push(result13);
              var result13 = parse_WS();
            }
            if (result11 !== null) {
              var result12 = parse_PrimaryExpression();
              if (result12 !== null) {
                var result9 = [result10, result11, result12];
              } else {
                var result9 = null;
                pos = savedPos1;
              }
            } else {
              var result9 = null;
              pos = savedPos1;
            }
          } else {
            var result9 = null;
            pos = savedPos1;
          }
          var result8 = result9 !== null
            ? (function(v) {
                  var ex = {};
                  ex.token = 'expression';
                  ex.expressionType = 'unaryexpression';
                  ex.unaryexpression = "+";
                  ex.expression = v;
            
                  return ex;
              })(result9[2])
            : null;
          if (result8 !== null) {
            var result0 = result8;
          } else {
            var savedPos0 = pos;
            if (input.substr(pos, 1) === "-") {
              var result4 = "-";
              pos += 1;
            } else {
              var result4 = null;
              if (reportMatchFailures) {
                matchFailed("\"-\"");
              }
            }
            if (result4 !== null) {
              var result5 = [];
              var result7 = parse_WS();
              while (result7 !== null) {
                result5.push(result7);
                var result7 = parse_WS();
              }
              if (result5 !== null) {
                var result6 = parse_PrimaryExpression();
                if (result6 !== null) {
                  var result3 = [result4, result5, result6];
                } else {
                  var result3 = null;
                  pos = savedPos0;
                }
              } else {
                var result3 = null;
                pos = savedPos0;
              }
            } else {
              var result3 = null;
              pos = savedPos0;
            }
            var result2 = result3 !== null
              ? (function(v) {
                    var ex = {};
                    ex.token = 'expression';
                    ex.expressionType = 'unaryexpression';
                    ex.unaryexpression = "-";
                    ex.expression = v;
              
                    return ex;
                })(result3[2])
              : null;
            if (result2 !== null) {
              var result0 = result2;
            } else {
              var result1 = parse_PrimaryExpression();
              if (result1 !== null) {
                var result0 = result1;
              } else {
                var result0 = null;;
              };
            };
          };
        }
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[103] UnaryExpression");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_PrimaryExpression() {
        var cacheKey = 'PrimaryExpression@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var result12 = parse_BrackettedExpression();
        if (result12 !== null) {
          var result0 = result12;
        } else {
          var result11 = parse_BuiltInCall();
          if (result11 !== null) {
            var result0 = result11;
          } else {
            var result10 = parse_IRIrefOrFunction();
            if (result10 !== null) {
              var result0 = result10;
            } else {
              var result9 = parse_RDFLiteral();
              var result8 = result9 !== null
                ? (function(v) {
                      var ex = {};
                      ex.token = 'expression';
                      ex.expressionType = 'atomic';
                      ex.primaryexpression = 'rdfliteral';
                      ex.value = v;
                
                      return ex;
                  })(result9)
                : null;
              if (result8 !== null) {
                var result0 = result8;
              } else {
                var result7 = parse_NumericLiteral();
                var result6 = result7 !== null
                  ? (function(v) {
                        var ex = {};
                        ex.token = 'expression';
                        ex.expressionType = 'atomic';
                        ex.primaryexpression = 'numericliteral';
                        ex.value = v;
                  
                        return ex;
                    })(result7)
                  : null;
                if (result6 !== null) {
                  var result0 = result6;
                } else {
                  var result5 = parse_BooleanLiteral();
                  var result4 = result5 !== null
                    ? (function(v) {
                          var ex = {};
                          ex.token = 'expression';
                          ex.expressionType = 'atomic';
                          ex.primaryexpression = 'booleanliteral';
                          ex.value = v;
                    
                          return ex;
                      })(result5)
                    : null;
                  if (result4 !== null) {
                    var result0 = result4;
                  } else {
                    var result3 = parse_Aggregate();
                    if (result3 !== null) {
                      var result0 = result3;
                    } else {
                      var result2 = parse_Var();
                      var result1 = result2 !== null
                        ? (function(v) {
                              var ex = {};
                              ex.token = 'expression';
                              ex.expressionType = 'atomic';
                              ex.primaryexpression = 'var';
                              ex.value = v;
                        
                              return ex;
                          })(result2)
                        : null;
                      if (result1 !== null) {
                        var result0 = result1;
                      } else {
                        var result0 = null;;
                      };
                    };
                  };
                };
              };
            };
          };
        }
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[104] PrimaryExpression");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_BrackettedExpression() {
        var cacheKey = 'BrackettedExpression@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos0 = pos;
        if (input.substr(pos, 1) === "(") {
          var result2 = "(";
          pos += 1;
        } else {
          var result2 = null;
          if (reportMatchFailures) {
            matchFailed("\"(\"");
          }
        }
        if (result2 !== null) {
          var result3 = [];
          var result8 = parse_WS();
          while (result8 !== null) {
            result3.push(result8);
            var result8 = parse_WS();
          }
          if (result3 !== null) {
            var result4 = parse_ConditionalOrExpression();
            if (result4 !== null) {
              var result5 = [];
              var result7 = parse_WS();
              while (result7 !== null) {
                result5.push(result7);
                var result7 = parse_WS();
              }
              if (result5 !== null) {
                if (input.substr(pos, 1) === ")") {
                  var result6 = ")";
                  pos += 1;
                } else {
                  var result6 = null;
                  if (reportMatchFailures) {
                    matchFailed("\")\"");
                  }
                }
                if (result6 !== null) {
                  var result1 = [result2, result3, result4, result5, result6];
                } else {
                  var result1 = null;
                  pos = savedPos0;
                }
              } else {
                var result1 = null;
                pos = savedPos0;
              }
            } else {
              var result1 = null;
              pos = savedPos0;
            }
          } else {
            var result1 = null;
            pos = savedPos0;
          }
        } else {
          var result1 = null;
          pos = savedPos0;
        }
        var result0 = result1 !== null
          ? (function(e) {
                return e;
          })(result1[2])
          : null;
        reportMatchFailures = savedReportMatchFailures;
        if (reportMatchFailures && result0 === null) {
          matchFailed("[105] BrackettedExpression");
        }
        
        cache[cacheKey] = {
          nextPos: pos,
          result:  result0
        };
        return result0;
      }
      
      function parse_BuiltInCall() {
        var cacheKey = 'BuiltInCall@' + pos;
        var cachedResult = cache[cacheKey];
        if (cachedResult) {
          pos = cachedResult.nextPos;
          return cachedResult.result;
        }
        
        var savedReportMatchFailures = reportMatchFailures;
        reportMatchFailures = false;
        var savedPos15 = pos;
        if (input.substr(pos, 1) === "S") {
          var result272 = "S";
          pos += 1;
        } else {
          var result272 = null;
          if (reportMatchFailures) {
            matchFailed("\"S\"");
          }
        }
        if (result272 !== null) {
          var result255 = result272;
        } else {
          if (input.substr(pos, 1) === "s") {
            var result271 = "s";
            pos += 1;
          } else {
            var result271 = null;
            if (reportMatchFailures) {
              matchFailed("\"s\"");
            }
          }
          if (result271 !== null) {
            var result255 = result271;
          } else {
            var result255 = null;;
          };
        }
        if (result255 !== null) {
          if (input.substr(pos, 1) === "T") {
            var result270 = "T";
            pos += 1;
          } else {
            var result270 = null;
            if (reportMatchFailures) {
              matchFailed("\"T\"");
            }
          }
          if (result270 !== null) {
            var result256 = result270;
          } else {
            if (input.substr(pos, 1) === "t") {
              var result269 = "t";
              pos += 1;
            } else {
              var result269 = null;
              if (reportMatchFailures) {
                matchFailed("\"t\"");
              }
            }
            if (result269 !== null) {
              var result256 = result269;
            } else {
              var result256 = null;;
            };
          }
          if (result256 !== null) {
            if (input.substr(pos, 1) === "R") {
              var result268 = "R";
              pos += 1;
            } else {
              var result268 = null;
              if (reportMatchFailures) {
                matchFailed("\"R\"");
              }
            }
            if (result268 !== null) {
              var result257 = result268;
            } else {
              if (input.substr(pos, 1) === "r") {
                var result267 = "r";
                pos += 1;
              } else {
                var result267 = null;
                if (reportMatchFailures) {
                  matchFailed("\"r\"");
                }
              }
              if (result267 !== null) {
                var result257 = result267;
              } else {
                var result257 = null;;
              };
            }
            if (result257 !== null) {
              var result258 = [];
              var result266 = parse_WS();
              while (result266 !== null) {
                result258.push(result266);
                var result266 = parse_WS();
              }
              if (result258 !== null) {
                if (input.substr(pos, 1) === "(") {
                  var result259 = "(";
                  pos += 1;
                } else {
                  var result259 = null;
                  if (reportMatchFailures) {
                    matchFailed("\"(\"");
                  }
                }
                if (result259 !== null) {
                  var result260 = [];
                  var result265 = parse_WS();
                  while (result265 !== null) {
                    result260.push(result265);
                    var result265 = parse_WS();
                  }
                  if (result260 !== null) {
                    var result261 = parse_ConditionalOrExpression();
                    if (result261 !== null) {
                      var result262 = [];
                      var result264 = parse_WS();
                      while (result264 !== null) {
                        result262.push(result264);
                        var result264 = parse_WS();
                      }
                      if (result262 !== null) {
                        if (input.substr(pos, 1) === ")") {
                          var result263 = ")";
                          pos += 1;
                        } else {
                          var result263 = null;
                          if (reportMatchFailures) {
                            matchFailed("\")\"");
                          }
                        }
                        if (result263 !== null) {
                          var result254 = [result255, result256, result257, result258, result259, result260, result261, result262, result263];
                        } else {
                          var result254 = null;
                          pos = savedPos15;
                        }
                      } else {
                        var result254 = null;
                        pos = savedPos15;
                      }
                    } else {
                      var result254 = null;
                      pos = savedPos15;
                    }
                  } else {
                    var result254 = null;
                    pos = savedPos15;
                  }
                } else {
                  var result254 = null;
                  pos = savedPos15;
                }
              } else {
                var result254 = null;
                pos = savedPos15;
              }
            } else {
              var result254 = null;
              pos = savedPos15;
            }
          } else {
            var result254 = null;
            pos = savedPos15;
          }
        } else {
          var result254 = null;
          pos = savedPos15;
        }
        var result253 = result254 !== null
          ? (function(e) {
                var ex = {};
                ex.token = 'expression'
                ex.expressionType = 'builtincall'
                ex.builtincall = 'str'
                ex.args = [e]
          
                return ex;
            })(result254[6])
          : null;
        if (result253 !== null) {
          var result0 = result253;
        } else {
          var savedPos14 = pos;
          if (input.substr(pos, 1) === "L") {
            var result252 = "L";
            pos += 1;
          } else {
            var result252 = null;
            if (reportMatchFailures) {
              matchFailed("\"L\"");
            }
          }
          if (result252 !== null) {
            var result232 = result252;
          } else {
            if (input.substr(pos, 1) === "l") {
              var result251 = "l";
              pos += 1;
            } else {
              var result251 = null;
              if (reportMatchFailures) {
                matchFailed("\"l\"");
              }
            }
            if (result251 !== null) {
              var result232 = result251;
            } else {
              var result232 = null;;
            };
          }
          if (result232 !== null) {
            if (input.substr(pos, 1) === "A") {
              var result250 = "A";
              pos += 1;
            } else {
              var result250 = null;
              if (reportMatchFailures) {
                matchFailed("\"A\"");
              }
            }
            if (result250 !== null) {
              var result233 = result250;
            } else {
              if (input.substr(pos, 1) === "a") {
                var result249 = "a";
                pos += 1;
              } else {
                var result249 = null;
                if (reportMatchFailures) {
                  matchFailed("\"a\"");
                }
              }
              if (result249 !== null) {
                var result233 = result249;
              } else {
                var result233 = null;;
              };
            }
            if (result233 !== null) {
              if (input.substr(pos, 1) === "N") {
                var result248 = "N";
                pos += 1;
              } else {
                var result248 = null;
                if (reportMatchFailures) {
                  matchFailed("\"N\"");
                }
              }
              if (result248 !== null) {
                var result234 = result248;
              } else {
                if (input.substr(pos, 1) === "n") {
                  var result247 = "n";
                  pos += 1;
                } else {
                  var result247 = null;
                  if (reportMatchFailures) {
                    matchFailed("\"n\"");
                  }
                }
                if (result247 !== null) {
                  var result234 = result247;
                } else {
                  var result234 = null;;
                };
              }
              if (result234 !== null) {
                if (input.substr(pos, 1) === "G") {
                  var result246 = "G";
                  pos += 1;
                } else {
                  var result246 = null;
                  if (reportMatchFailures) {
                    matchFailed("\"G\"");
                  }
                }
                if (result246 !== null) {
                  var result235 = result246;
                } else {
                  if (input.substr(pos, 1) === "g") {
                    var result245 = "g";
                    pos += 1;
                  } else {
                    var result245 = null;
                    if (reportMatchFailures) {
                      matchFailed("\"g\"");
                    }
                  }
                  if (result245 !== null) {
                    var result235 = result245;
                  } else {
                    var result235 = null;;
                  };
                }
                if (result235 !== null) {
                  var result236 = [];
                  var result244 = parse_WS();
                  while (result244 !== null) {
                    result236.push(result244);
                    var result244 = parse_WS();
                  }
                  if (result236 !== null) {
                    if (input.substr(pos, 1) === "(") {
                      var result237 = "(";
                      pos += 1;
                    } else {
                      var result237 = null;
                      if (reportMatchFailures) {
                        matchFailed("\"(\"");
                      }
                    }
                    if (result237 !== null) {
                      var result238 = [];
                      var result243 = parse_WS();
                      while (result243 !== null) {
                        result238.push(result243);
                        var result243 = parse_WS();
                      }
                      if (result238 !== null) {
                        var result239 = parse_ConditionalOrExpression();
                        if (result239 !== null) {
                          var result240 = [];
                          var result242 = parse_WS();
                          while (result242 !== null) {
                            result240.push(result242);
                            var result242 = parse_WS();
                          }
                          if (result240 !== null) {
                            if (input.substr(pos, 1) === ")") {
                              var result241 = ")";
                              pos += 1;
                            } else {
                              var result241 = null;
                              if (reportMatchFailures) {
                                matchFailed("\")\"");
                              }
                            }
                            if (result241 !== null) {
                              var result231 = [result232, result233, result234, result235, result236, result237, result238, result239, result240, result241];
                            } else {
                              var result231 = null;
                              pos = savedPos14;
                            }
                          } else {
                            var result231 = null;
                            pos = savedPos14;
                          }
                        } else {
                          var result231 = null;
                          pos = savedPos14;
                        }
                      } else {
                        var result231 = null;
                        pos = savedPos14;
                      }
                    } else {
                      var result231 = null;
                      pos = savedPos14;
                    }
                  } else {
                    var result231 = null;
                    pos = savedPos14;
                  }
                } else {
                  var result231 = null;
                  pos = savedPos14;
                }
              } else {
                var result231 = null;
                pos = savedPos14;
              }
            } else {
              var result231 = null;
              pos = savedPos14;
            }
          } else {
            var result231 = null;
            pos = savedPos14;
          }
          var result230 = result231 !== null
            ? (function(e) {
                  var ex = {};
                  ex.token = 'expression'
                  ex.expressionType = 'builtincall'
                  ex.builtincall = 'lang'
                  ex.args = [e]
            
                  return ex;
            })(result231[7])
            : null;
          if (result230 !== null) {
            var result0 = result230;
          } else {
            var savedPos13 = pos;
            if (input.substr(pos, 11) === "LANGMATCHES") {
              var result214 = "LANGMATCHES";
              pos += 11;
            } else {
              var result214 = null;
              if (reportMatchFailures) {
                matchFailed("\"LANGMATCHES\"");
              }
            }
            if (result214 !== null) {
              var result215 = [];
              var result229 = parse_WS();
              while (result229 !== null) {
                result215.push(result229);
                var result229 = parse_WS();
              }
              if (result215 !== null) {
                if (input.substr(pos, 1) === "(") {
                  var result216 = "(";
                  pos += 1;
                } else {
                  var result216 = null;
                  if (reportMatchFailures) {
                    matchFailed("\"(\"");
                  }
                }
                if (result216 !== null) {
                  var result217 = [];
                  var result228 = parse_WS();
                  while (result228 !== null) {
                    result217.push(result228);
                    var result228 = parse_WS();
                  }
                  if (result217 !== null) {
                    var result218 = parse_ConditionalOrExpression();
                    if (result218 !== null) {
                      var result219 = [];
                      var result227 = parse_WS();
                      while (result227 !== null) {
                        result219.push(result227);
                        var result227 = parse_WS();
                      }
                      if (result219 !== null) {
                        if (input.substr(pos, 1) === ",") {
                          var result220 = ",";
                          pos += 1;
                        } else {
                          var result220 = null;
                          if (reportMatchFailures) {
                            matchFailed("\",\"");
                          }
                        }
                        if (result220 !== null) {
                          var result221 = [];
                          var result226 = parse_WS();
                          while (result226 !== null) {
                            result221.push(result226);
                            var result226 = parse_WS();
                          }
                          if (result221 !== null) {
                            var result222 = parse_ConditionalOrExpression();
                            if (result222 !== null) {
                              var result223 = [];
                              var result225 = parse_WS();
                              while (result225 !== null) {
                                result223.push(result225);
                                var result225 = parse_WS();
                              }
                              if (result223 !== null) {
                                if (input.substr(pos, 1) === ")") {
                                  var result224 = ")";
                                  pos += 1;
                                } else {
                                  var result224 = null;
                                  if (reportMatchFailures) {
                                    matchFailed("\")\"");
                                  }
                                }
                                if (result224 !== null) {
                                  var result213 = [result214, result215, result216, result217, result218, result219, result220, result221, result222, result223, result224];
                                } else {
                                  var result213 = null;
                                  pos = savedPos13;
                                }
                              } else {
                                var result213 = null;
                                pos = savedPos13;
                              }
                            } else {
                              var result213 = null;
                              pos = savedPos13;
                            }
                          } else {
                            var result213 = null;
                            pos = savedPos13;
                          }
                        } else {
                          var result213 = null;
                          pos = savedPos13;
                        }
                      } else {
                        var result213 = null;
                        pos = savedPos13;
                      }
                    } else {
                      var result213 = null;
                      pos = savedPos13;
                    }
                  } else {
                    var result213 = null;
                    pos = savedPos13;
                  }
                } else {
                  var result213 = null;
                  pos = savedPos13;
                }
              } else {
                var result213 = null;
                pos = savedPos13;
              }
            } else {
              var result213 = null;
              pos = savedPos13;
            }
            var result212 = result213 !== null
              ? (function(e1, e2) {
                    var ex = {};
                    ex.token = 'expression'
                    ex.expressionType = 'builtincall'
                    ex.builtincall = 'langmatches'
                    ex.args = [e1,e2]
              
                    return ex;
              })(result213[4], result213[8])
              : null;
            if (result212 !== null) {
              var result0 = result212;
            } else {
              var savedPos12 = pos;
              if (input.substr(pos, 1) === "D") {
                var result211 = "D";
                pos += 1;
              } else {
                var result211 = null;
                if (reportMatchFailures) {
                  matchFailed("\"D\"");
                }
              }
              if (result211 !== null) {
                var result179 = result211;
              } else {
                if (input.substr(pos, 1) === "d") {
                  var result210 = "d";
                  pos += 1;
                } else {
                  var result210 = null;
                  if (reportMatchFailures) {
                    matchFailed("\"d\"");
                  }
                }
                if (result210 !== null) {
                  var result179 = result210;
                } else {
                  var result179 = null;;
                };
              }
              if (result179 !== null) {
                if (input.substr(pos, 1) === "A") {
                  var result209 = "A";
                  pos += 1;
                } else {
                  var result209 = null;
                  if (reportMatchFailures) {
                    matchFailed("\"A\"");
                  }
                }
                if (result209 !== null) {
                  var result180 = result209;
                } else {
                  if (input.substr(pos, 1) === "a") {
                    var result208 = "a";
                    pos += 1;
                  } else {
                    var result208 = null;
                    if (reportMatchFailures) {
                      matchFailed("\"a\"");
                    }
                  }
                  if (result208 !== null) {
                    var result180 = result208;
                  } else {
                    var result180 = null;;
                  };
                }
                if (result180 !== null) {
                  if (input.substr(pos, 1) === "T") {
                    var result207 = "T";
                    pos += 1;
                  } else {
                    var result207 = null;
                    if (reportMatchFailures) {
                      matchFailed("\"T\"");
                    }
                  }
                  if (result207 !== null) {
                    var result181 = result207;
                  } else {
                    if (input.substr(pos, 1) === "t") {
                      var result206 = "t";
                      pos += 1;
                    } else {
                      var result206 = null;
                      if (reportMatchFailures) {
                        matchFailed("\"t\"");
                      }
                    }
                    if (result206 !== null) {
                      var result181 = result206;
                    } else {
                      var result181 = null;;
                    };
                  }
                  if (result181 !== null) {
                    if (input.substr(pos, 1) === "A") {
                      var result205 = "A";
                      pos += 1;
                    } else {
                      var result205 = null;
                      if (reportMatchFailures) {
                        matchFailed("\"A\"");
                      }
                    }
                    if (result205 !== null) {
                      var result182 = result205;
                    } else {
                      if (input.substr(pos, 1) === "a") {
                        var result204 = "a";
                        pos += 1;
                      } else {
                        var result204 = null;
                        if (reportMatchFailures) {
                          matchFailed("\"a\"");
                        }
                      }
                      if (result204 !== null) {
                        var result182 = result204;
                      } else {
                        var result182 = null;;
                      };
                    }
                    if (result182 !== null) {
                      if (input.substr(pos, 1) === "T") {
                        var result203 = "T";
                        pos += 1;
                      } else {
                        var result203 = null;
                        if (reportMatchFailures) {
                          matchFailed("\"T\"");
                        }
                      }
                      if (result203 !== null) {
                        var result183 = result203;
                      } else {
                        if (input.substr(pos, 1) === "t") {
                          var result202 = "t";
                          pos += 1;
                        } else {
                          var result202 = null;
                          if (reportMatchFailures) {
                            matchFailed("\"t\"");
                          }
                        }
                        if (result202 !== null) {
                          var result183 = result202;
                        } else {
                          var result183 = null;;
                        };
                      }
                      if (result183 !== null) {
                        if (input.substr(pos, 1) === "Y") {
                          var result201 = "Y";
                          pos += 1;
                        } else {
                          var result201 = null;
                          if (reportMatchFailures) {
                            matchFailed("\"Y\"");
                          }
                        }
                        if (result201 !== null) {
                          var result184 = result201;
                        } else {
                          if (input.substr(pos, 1) === "y") {
                            var result200 = "y";
                            pos += 1;
                          } else {
                            var result200 = null;
                            if (reportMatchFailures) {
                              matchFailed("\"y\"");
                            }
                          }
                          if (result200 !== null) {
                            var result184 = result200;
                          } else {
                            var result184 = null;;
                          };
                        }
                        if (result184 !== null) {
                          if (input.substr(pos, 1) === "P") {
                            var result199 = "P";
                            pos += 1;
                          } else {
                            var result199 = null;
                            if (reportMatchFailures) {
                              matchFailed("\"P\"");
                            }
                          }
                          if (result199 !== null) {
                            var result185 = result199;
                          } else {
                            if (input.substr(pos, 1) === "p") {
                              var result198 = "p";
                              pos += 1;
                            } else {
                              var result198 = null;
                              if (reportMatchFailures) {
                                matchFailed("\"p\"");
                              }
                            }
                            if (result198 !== null) {
                              var result185 = result198;
                            } else {
                              var result185 = null;;
                            };
                          }
                          if (result185 !== null) {
                            if (input.substr(pos, 1) === "E") {
                              var result197 = "E";
                              pos += 1;
                            } else {
                              var result197 = null;
                              if (reportMatchFailures) {
                                matchFailed("\"E\"");
                              }
                            }
                            if (result197 !== null) {
                              var result186 = result197;
                            } else {
                              if (input.substr(pos, 1) === "e") {
                                var result196 = "e";
                                pos += 1;
                              } else {
                                var result196 = null;
                                if (reportMatchFailures) {
                                  matchFailed("\"e\"");
                                }
                              }
                              if (result196 !== null) {
                                var result186 = result196;
                              } else {
                                var result186 = null;;
                              };
                            }
                            if (result186 !== null) {
                              var result187 = [];
                              var result195 = parse_WS();
                              while (result195 !== null) {
                                result187.push(result195);
                                var result195 = parse_WS();
                              }
                              if (result187 !== null) {
                                if (input.substr(pos, 1) === "(") {
                                  var result188 = "(";
                                  pos += 1;
                                } else {
                                  var result188 = null;
                                  if (reportMatchFailures) {
                                    matchFailed("\"(\"");
                                  }
                                }
                                if (result188 !== null) {
                                  var result189 = [];
                                  var result194 = parse_WS();
                                  while (result194 !== null) {
                                    result189.push(result194);
                                    var result194 = parse_WS();
                                  }
                                  if (result189 !== null) {
                                    var result190 = parse_ConditionalOrExpression();
                                    if (result190 !== null) {
                                      var result191 = [];
                                      var result193 = parse_WS();
                                      while (result193 !== null) {
                                        result191.push(result193);
                                        var result193 = parse_WS();
                                      }
                                      if (result191 !== null) {
                                        if (input.substr(pos, 1) === ")") {
                                          var result192 = ")";
                                          pos += 1;
                                        } else {
                                          var result192 = null;
                                          if (reportMatchFailures) {
                                            matchFailed("\")\"");
                                          }
                                        }
                                        if (result192 !== null) {
                                          var result178 = [result179, result180, result181, result182, result183, result184, result185, result186, result187, result188, result189, result190, result191, result192];
                                        } else {
                                          var result178 = null;
                                          pos = savedPos12;
                                        }
                                      } else {
                                        var result178 = null;
                                        pos = savedPos12;
                                      }
                                    } else {
                                      var result178 = null;
                                      pos = savedPos12;
                                    }
                                  } else {
                                    var result178 = null;
                                    pos = savedPos12;
                                  }
                                } else {
                                  var result178 = null;
                                  pos = savedPos12;
                                }
                              } else {
                                var result178 = null;
                                pos = savedPos12;
                              }
                            } else {
                              var result178 = null;
                              pos = savedPos12;
                            }
                          } else {
                            var result178 = null;
                            pos = savedPos12;
                          }
                        } else {
                          var result178 = null;
                          pos = savedPos12;
                        }
                      } else {
                        var result178 = null;
                        pos = savedPos12;
                      }
                    } else {
                      var result178 = null;
                      pos = savedPos12;
                    }
                  } else {
                    var result178 = null;
                    pos = savedPos12;
                  }
                } else {
                  var result178 = null;
                  pos = savedPos12;
                }
              } else {
                var result178 = null;
                pos = savedPos12;
              }
              var result177 = result178 !== null
                ? (function(e) {
                      var ex = {};
                      ex.token = 'expression'
                      ex.expressionType = 'builtincall'
                      ex.builtincall = 'datatype'
                      ex.args = [e]
                
                      return ex;
                })(result178[11])
                : null;
              if (result177 !== null) {
                var result0 = result177;
              } else {
                var savedPos11 = pos;
                if (input.substr(pos, 5) === "BOUND") {
                  var result167 = "BOUND";
                  pos += 5;
                } else {
                  var result167 = null;
                  if (reportMatchFailures) {
                    matchFailed("\"BOUND\"");
                  }
                }
                if (result167 !== null) {
                  var result168 = [];
                  var result176 = parse_WS();
                  while (result176 !== null) {
                    result168.push(result176);
                    var result176 = parse_WS();
                  }
                  if (result168 !== null) {
                    if (input.substr(pos, 1) === "(") {
                      var result169 = "(";
                      pos += 1;
                    } else {
                      var result169 = null;
                      if (reportMatchFailures) {
                        matchFailed("\"(\"");
                      }
                    }
                    if (result169 !== null) {
                      var result170 = [];
                      var result175 = parse_WS();
                      while (result175 !== null) {
                        result170.push(result175);
                        var result175 = parse_WS();
                      }
                      if (result170 !== null) {
                        var result171 = parse_Var();
                        if (result171 !== null) {
                          var result172 = [];
                          var result174 = parse_WS();
                          while (result174 !== null) {
                            result172.push(result174);
                            var result174 = parse_WS();
                          }
                          if (result172 !== null) {
                            if (input.substr(pos, 1) === ")") {
                              var result173 = ")";
                              pos += 1;
                            } else {
                              var result173 = null;
                              if (reportMatchFailures) {
                                matchFailed("\")\"");
                              }
                            }
                            if (result173 !== null) {
                              var result166 = [result167, result168, result169, result170, result171, result172, result173];
                            } else {
                              var result166 = null;
                              pos = savedPos11;
                            }
                          } else {
                            var result166 = null;
                            pos = savedPos11;
                          }
                        } else {
                          var result166 = null;
                          pos = savedPos11;
                        }
                      } else {
                        var result166 = null;
                        pos = savedPos11;
                      }
                    } else {
                      var result166 = null;
                      pos = savedPos11;
                    }
                  } else {
                    var result166 = null;
                    pos = savedPos11;
                  }
                } else {
                  var result166 = null;
                  pos = savedPos11;
                }
                var result165 = result166 !== null
                  ? (function(v) {
                        var ex = {};
                        ex.token = 'expression'
                        ex.expressionType = 'builtincall'
                        ex.builtincall = 'bound'
                        ex.args = [v]
                  
                        return ex;
                  })(result166[4])
                  : null;
                if (result165 !== null) {
                  var result0 = result165;
                } else {
                  var savedPos10 = pos;
                  if (input.substr(pos, 3) === "IRI") {
                    var result155 = "IRI";
                    pos += 3;
                  } else {
                    var result155 = null;
                    if (reportMatchFailures) {
                      matchFailed("\"IRI\"");
                    }
                  }
                  if (result155 !== null) {
                    var result156 = [];
                    var result164 = parse_WS();
                    while (result164 !== null) {
                      result156.push(result164);
                      var result164 = parse_WS();
                    }
                    if (result156 !== null) {
                      if (input.substr(pos, 1) === "(") {
                        var result157 = "(";
                        pos += 1;
                      } else {
                        var result157 = null;
                        if (reportMatchFailures) {
                          matchFailed("\"(\"");
                        }
                      }
                      if (result157 !== null) {
                        var result158 = [];
                        var result163 = parse_WS();
                        while (result163 !== null) {
                          result158.push(result163);
                          var result163 = parse_WS();
                        }
                        if (result158 !== null) {
                          var result159 = parse_ConditionalOrExpression();
                          if (result159 !== null) {
                            var result160 = [];
                            var result162 = parse_WS();
                            while (result162 !== null) {
                              result160.push(result162);
                              var result162 = parse_WS();
                            }
                            if (result160 !== null) {
                              if (input.substr(pos, 1) === ")") {
                                var result161 = ")";
                                pos += 1;
                              } else {
                                var result161 = null;
                                if (reportMatchFailures) {
                                  matchFailed("\")\"");
                                }
                              }
                              if (result161 !== null) {
                                var result154 = [result155, result156, result157, result158, result159, result160, result161];
                              } else {
                                var result154 = null;
                                pos = savedPos10;
                              }
                            } else {
                              var result154 = null;
                              pos = savedPos10;
                            }
                          } else {
                            var result154 = null;
                            pos = savedPos10;
                          }
                        } else {
                          var result154 = null;
                          pos = savedPos10;
                        }
                      } else {
                        var result154 = null;
                        pos = savedPos10;
                      }
                    } else {
                      var result154 = null;
                      pos = savedPos10;
                    }
                  } else {
                    var result154 = null;
                    pos = savedPos10;
                  }
                  var result153 = result154 !== null
                    ? (function(e) {
                          var ex = {};
                          ex.token = 'expression';
                          ex.expressionType = 'builtincall';
                          ex.builtincall = 'iri'
                          ex.args = [e];
                    
                          return ex;
                    })(result154[4])
                    : null;
                  if (result153 !== null) {
                    var result0 = result153;
                  } else {
                    var savedPos9 = pos;
                    if (input.substr(pos, 3) === "URI") {
                      var result143 = "URI";
                      pos += 3;
                    } else {
                      var result143 = null;
                      if (reportMatchFailures) {
                        matchFailed("\"URI\"");
                      }
                    }
                    if (result143 !== null) {
                      var result144 = [];
                      var result152 = parse_WS();
                      while (result152 !== null) {
                        result144.push(result152);
                        var result152 = parse_WS();
                      }
                      if (result144 !== null) {
                        if (input.substr(pos, 1) === "(") {
                          var result145 = "(";
                          pos += 1;
                        } else {
                          var result145 = null;
                          if (reportMatchFailures) {
                            matchFailed("\"(\"");
                          }
                        }
                        if (result145 !== null) {
                          var result146 = [];
                          var result151 = parse_WS();
                          while (result151 !== null) {
                            result146.push(result151);
                            var result151 = parse_WS();
                          }
                          if (result146 !== null) {
                            var result147 = parse_ConditionalOrExpression();
                            if (result147 !== null) {
                              var result148 = [];
                              var result150 = parse_WS();
                              while (result150 !== null) {
                                result148.push(result150);
                                var result150 = parse_WS();
                              }
                              if (result148 !== null) {
                                if (input.substr(pos, 1) === ")") {
                                  var result149 = ")";
                                  pos += 1;
                                } else {
                                  var result149 = null;
                                  if (reportMatchFailures) {
                                    matchFailed("\")\"");
                                  }
                                }
                                if (result149 !== null) {
                                  var result142 = [result143, result144, result145, result146, result147, result148, result149];
                                } else {
                                  var result142 = null;
                                  pos = savedPos9;
                                }
                              } else {
                                var result142 = null;
                                pos = savedPos9;
                              }
                            } else {
                              var result142 = null;
                              pos = savedPos9;
                            }
                          } else {
                            var result142 = null;
                            pos = savedPos9;
                          }
                        } else {
                          var result142 = null;
                          pos = savedPos9;
                        }
                      } else {
                        var result142 = null;
                        pos = savedPos9;
                      }
                    } else {
                      var result142 = null;
                      pos = savedPos9;
                    }
                    var result141 = result142 !== null
                      ? (function(e) {
                            var ex = {};
                            ex.token = 'expression';
                            ex.expressionType = 'builtincall';
                            ex.builtincall = 'uri'
                            ex.args = [e];
                      
                            return ex;
                      })(result142[4])
                      : null;
                    if (result141 !== null) {
                      var result0 = result141;
                    } else {
                      var savedPos7 = pos;
                      if (input.substr(pos, 5) === "BNODE") {
                        var result128 = "BNODE";
                        pos += 5;
                      } else {
                        var result128 = null;
                        if (reportMatchFailures) {
                          matchFailed("\"BNODE\"");
                        }
                      }
                      if (result128 !== null) {
                        var result129 = [];
                        var result140 = parse_WS();
                        while (result140 !== null) {
                          result129.push(result140);
                          var result140 = parse_WS();
                        }
                        if (result129 !== null) {
                          var savedPos8 = pos;
                          if (input.substr(pos, 1) === "(") {
                            var result133 = "(";
                            pos += 1;
                          } else {
                            var result133 = null;
                            if (reportMatchFailures) {
                              matchFailed("\"(\"");
                            }
                          }
                          if (result133 !== null) {
                            var result134 = [];
                            var result139 = parse_WS();
                            while (result139 !== null) {
                              result134.push(result139);
                              var result139 = parse_WS();
                            }
                            if (result134 !== null) {
                              var result135 = parse_ConditionalOrExpression();
                              if (result135 !== null) {
                                var result136 = [];
                                var result138 = parse_WS();
                                while (result138 !== null) {
                                  result136.push(result138);
                                  var result138 = parse_WS();
                                }
                                if (result136 !== null) {
                                  if (input.substr(pos, 1) === ")") {
                                    var result137 = ")";
                                    pos += 1;
                                  } else {
                                    var result137 = null;
                                    if (reportMatchFailures) {
                                      matchFailed("\")\"");
                                    }
                                  }
                                  if (result137 !== null) {
                                    var result132 = [result133, result134, result135, result136, result137];
                                  } else {
                                    var result132 = null;
                                    pos = savedPos8;
                                  }
                                } else {
                                  var result132 = null;
                                  pos = savedPos8;
                                }
                              } else {
                                var result132 = null;
                                pos = savedPos8;
                              }
                            } else {
                              var result132 = null;
                              pos = savedPos8;
                            }
                          } else {
                            var result132 = null;
                            pos = savedPos8;
                          }
                          if (result132 !== null) {
                            var result130 = result132;
                          } else {
                            var result131 = parse_NIL();
                            if (result131 !== null) {
                              var result130 = result131;
                            } else {
                              var result130 = null;;
                            };
                          }
                          if (result130 !== null) {
                            var result127 = [result128, result129, result130];
                          } else {
                            var result127 = null;
                            pos = savedPos7;
                          }
                        } else {
                          var result127 = null;
                          pos = savedPos7;
                        }
                      } else {
                        var result127 = null;
                        pos = savedPos7;
                      }
                      var result126 = result127 !== null
                        ? (function(arg) {
                              var ex = {};
                              ex.token = 'expression';
                              ex.expressionType = 'builtincall';
                              ex.builtincall = 'bnode';
                              if(arg.length === 5) {
                                  ex.args = [arg[2]];
                              } else {
                                  ex.args = null;
                              }
                        
                              return ex;
                        })(result127[2])
                        : null;
                      if (result126 !== null) {
                        var result0 = result126;
                      } else {
                        var savedPos6 = pos;
                        if (input.substr(pos, 8) === "COALESCE") {
                          var result122 = "COALESCE";
                          pos += 8;
                        } else {
                          var result122 = null;
                          if (reportMatchFailures) {
                            matchFailed("\"COALESCE\"");
                          }
                        }
                        if (result122 !== null) {
                          var result123 = [];
                          var result125 = parse_WS();
                          while (result125 !== null) {
                            result123.push(result125);
                            var result125 = parse_WS();
                          }
                          if (result123 !== null) {
                            var result124 = parse_ExpressionList();
                            if (result124 !== null) {
                              var result121 = [result122, result123, result124];
                            } else {
                              var result121 = null;
                              pos = savedPos6;
                            }
                          } else {
                            var result121 = null;
                            pos = savedPos6;
                          }
                        } else {
                          var result121 = null;
                          pos = savedPos6;
                        }
                        var result120 = result121 !== null
                          ? (function(args) {
                                var ex = {};
                                ex.token = 'expression';
                                ex.expressionType = 'builtincall';
                                ex.builtincall = 'coalesce';
                                ex.args = args;
                          
                                return ex;    
                          })(result121[2])
                          : null;
                        if (result120 !== null) {
                          var result0 = result120;
                        } else {
                          var savedPos5 = pos;
                          if (input.substr(pos, 2) === "IF") {
                            var result98 = "IF";
                            pos += 2;
                          } else {
                            var result98 = null;
                            if (reportMatchFailures) {
                              matchFailed("\"IF\"");
                            }
                          }
                          if (result98 !== null) {
                            var result99 = [];
                            var result119 = parse_WS();
                            while (result119 !== null) {
                              result99.push(result119);
                              var result119 = parse_WS();
                            }
                            if (result99 !== null) {
                              if (input.substr(pos, 1) === "(") {
                                var result100 = "(";
                                pos += 1;
                              } else {
                                var result100 = null;
                                if (reportMatchFailures) {
                                  matchFailed("\"(\"");
                                }
                              }
                              if (result100 !== null) {
                                var result101 = [];
                                var result118 = parse_WS();
                                while (result118 !== null) {
                                  result101.push(result118);
                                  var result118 = parse_WS();
                                }
                                if (result101 !== null) {
                                  var result102 = parse_ConditionalOrExpression();
                                  if (result102 !== null) {
                                    var result103 = [];
                                    var result117 = parse_WS();
                                    while (result117 !== null) {
                                      result103.push(result117);
                                      var result117 = parse_WS();
                                    }
                                    if (result103 !== null) {
                                      if (input.substr(pos, 1) === ",") {
                                        var result104 = ",";
                                        pos += 1;
                                      } else {
                                        var result104 = null;
                                        if (reportMatchFailures) {
                                          matchFailed("\",\"");
                                        }
                                      }
                                      if (result104 !== null) {
                                        var result105 = [];
                                        var result116 = parse_WS();
                                        while (result116 !== null) {
                                          result105.push(result116);
                                          var result116 = parse_WS();
                                        }
                                        if (result105 !== null) {
                                          var result106 = parse_ConditionalOrExpression();
                                          if (result106 !== null) {
                                            var result107 = [];
                                            var result115 = parse_WS();
                                            while (result115 !== null) {
                                              result107.push(result115);
                                              var result115 = parse_WS();
                                            }
                                            if (result107 !== null) {
                                              if (input.substr(pos, 1) === ",") {
                                                var result108 = ",";
                                                pos += 1;
                                              } else {
                                                var result108 = null;
                                                if (reportMatchFailures) {
                                                  matchFailed("\",\"");
                                                }
                                              }
                                              if (result108 !== null) {
                                                var result109 = [];
                                                var result114 = parse_WS();
                                                while (result114 !== null) {
                                                  result109.push(result114);
                                                  var result114 = parse_WS();
                                                }
                                                if (result109 !== null) {
                                                  var result110 = parse_ConditionalOrExpression();
                                                  if (result110 !== null) {
                                                    var result111 = [];
                                                    var result113 = parse_WS();
                                                    while (result113 !== null) {
                                                      result111.push(result113);
                                                      var result113 = parse_WS();
                                                    }
                                                    if (result111 !== null) {
                                                      if (input.substr(pos, 1) === ")") {
                                                        var result112 = ")";
                                                        pos += 1;
                                                      } else {
                                                        var result112 = null;
                                                        if (reportMatchFailures) {
                                                          matchFailed("\")\"");
                                                        }
                                                      }
                                                      if (result112 !== null) {
                                                        var result97 = [result98, result99, result100, result101, result102, result103, result104, result105, result106, result107, result108, result109, result110, result111, result112];
                                                      } else {
                                                        var result97 = null;
                                                        pos = savedPos5;
                                                      }
                                                    } else {
                                                      var result97 = null;
                                                      pos = savedPos5;
                                                    }
                                                  } else {
                                                    var result97 = null;
                                                    pos = savedPos5;
                                                  }
                                                } else {
                                                  var result97 = null;
                                                  pos = savedPos5;
                                                }
                                              } else {
                                                var result97 = null;
                                                pos = savedPos5;
                                              }
                                            } else {
                                              var result97 = null;
                                              pos = savedPos5;
                                            }
                                          } else {
                                            var result97 = null;
                                            pos = savedPos5;
                                          }
                                        } else {
                                          var result97 = null;
                                          pos = savedPos5;
                                        }
                                      } else {
                                        var result97 = null;
                                        pos = savedPos5;
                                      }
                                    } else {
                                      var result97 = null;
                                      pos = savedPos5;
                                    }
                                  } else {
                                    var result97 = null;
                                    pos = savedPos5;
                                  }
                                } else {
                                  var result97 = null;
                                  pos = savedPos5;
                                }
                              } else {
                                var result97 = null;
                                pos = savedPos5;
                              }
                            } else {
                              var result97 = null;
                              pos = savedPos5;
                            }
                          } else {
                            var result97 = null;
                            pos = savedPos5;
                          }
                          var result96 = result97 !== null
                            ? (function(test, trueCond, falseCond) {
                                var ex = {};
                                ex.token = 'expression';
                                ex.expressionType = 'builtincall';
                                ex.builtincall = 'if';
                                ex.args = [test,trueCond,falseCond];
                            
                                return ex;
                            })(result97[4], result97[8], result97[12])
                            : null;
                          if (result96 !== null) {
                            var result0 = result96;
                          } else {
                            var savedPos4 = pos;
                            if (input.substr(pos, 9) === "ISLITERAL") {
                              var result86 = "ISLITERAL";
                              pos += 9;
                            } else {
                              var result86 = null;
                              if (reportMatchFailures) {
                                matchFailed("\"ISLITERAL\"");
                              }
                            }
                            if (result86 !== null) {
                              var result87 = [];
                              var result95 = parse_WS();
                              while (result95 !== null) {
                                result87.push(result95);
                                var result95 = parse_WS();
                              }
                              if (result87 !== null) {
                                if (input.substr(pos, 1) === "(") {
                                  var result88 = "(";
                                  pos += 1;
                                } else {
                                  var result88 = null;
                                  if (reportMatchFailures) {
                                    matchFailed("\"(\"");
                                  }
                                }
                                if (result88 !== null) {
                                  var result89 = [];
                                  var result94 = parse_WS();
                                  while (result94 !== null) {
                                    result89.push(result94);
                                    var result94 = parse_WS();
                                  }
                                  if (result89 !== null) {
                                    var result90 = parse_ConditionalOrExpression();
                                    if (result90 !== null) {
                                      var result91 = [];
                                      var result93 = parse_WS();
                                      while (result93 !== null) {
                                        result91.push(result93);
                                        var result93 = parse_WS();
                                      }
                                      if (result91 !== null) {
                                        if (input.substr(pos, 1) === ")") {
                                          var result92 = ")";
                                          pos += 1;
                                        } else {
                                          var result92 = null;
                                          if (reportMatchFailures) {
                                            matchFailed("\")\"");
                                          }
                                        }
                                        if (result92 !== null) {
                                          var result85 = [result86, result87, result88, result89, result90, result91, result92];
                                        } else {
                                          var result85 = null;
                                          pos = savedPos4;
                                        }
                                      } else {
                                        var result85 = null;
                                        pos = savedPos4;
                                      }
                                    } else {
                                      var result85 = null;
                                      pos = savedPos4;
                                    }
                                  } else {
                                    var result85 = null;
                                    pos = savedPos4;
                                  }
                                } else {
                                  var result85 = null;
                                  pos = savedPos4;
                                }
                              } else {
                                var result85 = null;
                                pos = savedPos4;
                              }
                            } else {
                              var result85 = null;
                              pos = savedPos4;
                            }
                            var result84 = result85 !== null
                              ? (function(arg) {
                                  var ex = {};
                                  ex.token = 'expression';
                                  ex.expressionType = 'builtincall';
                                  ex.builtincall = 'isliteral';
                                  ex.args = [arg];
                              
                                  return ex;
                              })(result85[4])
                              : null;
                            if (result84 !== null) {
                              var result0 = result84;
                            } else {
                              var savedPos3 = pos;
                              if (input.substr(pos, 7) === "ISBLANK") {
                                var result74 = "ISBLANK";
                                pos += 7;
                              } else {
                                var result74 = null;
                                if (reportMatchFailures) {
                                  matchFailed("\"ISBLANK\"");
                                }
                              }
                              if (result74 !== null) {
                                var result75 = [];
                                var result83 = parse_WS();
                                while (result83 !== null) {
                                  result75.push(result83);
                                  var result83 = parse_WS();
                                }
                                if (result75 !== null) {
                                  if (input.substr(pos, 1) === "(") {
                                    var result76 = "(";
                                    pos += 1;
                                  } else {
                                    var result76 = null;
                                    if (reportMatchFailures) {
                                      matchFailed("\"(\"");
                                    }
                                  }
                                  if (result76 !== null) {
                                    var result77 = [];
                                    var result82 = parse_WS();
                                    while (result82 !== null) {
                                      result77.push(result82);
                                      var result82 = parse_WS();
                                    }
                                    if (result77 !== null) {
                                      var result78 = parse_ConditionalOrExpression();
                                      if (result78 !== null) {
                                        var result79 = [];
                                        var result81 = parse_WS();
                                        while (result81 !== null) {
                                          result79.push(result81);
                                          var result81 = parse_WS();
                                        }
                                        if (result79 !== null) {
                                          if (input.substr(pos, 1) === ")") {
                                            var result80 = ")";
                                            pos += 1;
                                          } else {
                                            var result80 = null;
                                            if (reportMatchFailures) {
                                              matchFailed("\")\"");
                                            }
                                          }
                                          if (result80 !== null) {
                                            var result73 = [result74, result75, result76, result77, result78, result79, result80];
                                          } else {
                                            var result73 = null;
                                            pos = savedPos3;
                                          }
                                        } else {
                                          var result73 = null;
                                          pos = savedPos3;
                                        }
                                      } else {
                                        var result73 = null;
                                        pos = savedPos3;
                                      }
                                    } else {
                                      var result73 = null;
                                      pos = savedPos3;
                                    }
                                  } else {
                                    var result73 = null;
                                    pos = savedPos3;
                                  }
                                } else {
                                  var result73 = null;
                                  pos = savedPos3;
                                }
                              } else {
                                var result73 = null;
                                pos = savedPos3;
                              }
                              var result72 = result73 !== null
                                ? (function(arg) {
                                    var ex = {};
                                    ex.token = 'expression';
                                    ex.expressionType = 'builtincall';
                                    ex.builtincall = 'isblank';
                                    ex.args = [arg];
                                
                                    return ex;
                                })(result73[4])
                                : null;
                              if (result72 !== null) {
                                var result0 = result72;
                              } else {
                                var savedPos2 = pos;
                                if (input.substr(pos, 8) === "SAMETERM") {
                                  var result56 = "SAMETERM";
                                  pos += 8;
                                } else {
                                  var result56 = null;
                                  if (reportMatchFailures) {
                                    matchFailed("\"SAMETERM\"");
                                  }
                                }
                                if (result56 !== null) {
                                  var result57 = [];
                                  var result71 = parse_WS();
                                  while (result71 !== null) {
                                    result57.push(result71);
                                    var result71 = parse_WS();
                                  }
                                  if (result57 !== null) {
                                    if (input.substr(pos, 1) === "(") {
                                      var result58 = "(";
                                      pos += 1;
                                    } else {
                                      var result58 = null;
                                      if (reportMatchFailures) {
                                        matchFailed("\"(\"");
                                      }
                                    }
                                    if (result58 !== null) {
                                      var result59 = [];
                                      var result70 = parse_WS();
                                      while (result70 !== null) {
                                        result59.push(result70);
                                        var result70 = parse_WS();
                                      }
                                      if (result59 !== null) {
                                        var result60 = parse_ConditionalOrExpression();
                                        if (result60 !== null) {
                                          var result61 = [];
                                          var result69 = parse_WS();
                                          while (result69 !== null) {
                                            result61.push(result69);
                                            var result69 = parse_WS();
                                          }
                                          if (result61 !== null) {
                                            if (input.substr(pos, 1) === ",") {
                                              var result62 = ",";
                                              pos += 1;
                                            } else {
                                              var result62 = null;
                                              if (reportMatchFailures) {
                                                matchFailed("\",\"");
                                              }
                                            }
                                            if (result62 !== null) {
                                              var result63 = [];
                                              var result68 = parse_WS();
                                              while (result68 !== null) {
                                                result63.push(result68);
                                                var result68 = parse_WS();
                                              }
                                              if (result63 !== null) {
                                                var result64 = parse_ConditionalOrExpression();
                                                if (result64 !== null) {
                                                  var result65 = [];
                                                  var result67 = parse_WS();
                                                  while (result67 !== null) {
                                                    result65.push(result67);
                                                    var result67 = parse_WS();
                                                  }
                                                  if (result65 !== null) {
                                                    if (input.substr(pos, 1) === ")") {
                                                      var result66 = ")";
                                                      pos += 1;
                                                    } else {
                                                      var result66 = null;
                                                      if (reportMatchFailures) {
                                                        matchFailed("\")\"");
                                                      }
                                                    }
                                                    if (result66 !== null) {
                                                      var result55 = [result56, result57, result58, result59, result60, result61, result62, result63, result64, result65, result66];
                                                    } else {
                                                      var result55 = null;
                                                      pos = savedPos2;
                                                    }
                                                  } else {
                                                    var result55 = null;
                                                    pos = savedPos2;
                                                  }
                                                } else {
                                                  var result55 = null;
                                                  pos = savedPos2;
                                                }
                                              } else {
                                                var result55 = null;
                                                pos = savedPos2;
                                              }
                                            } else {
                                              var result55 = null;
                                              pos = savedPos2;
                                            }
                                          } else {
                                            var result55 = null;
                                            pos = savedPos2;
                                          }
                                        } else {
                                          var result55 = null;
                                          pos = savedPos2;
                                        }
                                      } else {
                                        var result55 = null;
                                        pos = savedPos2;
                                      }
                                    } else {
                                      var result55 = null;
                                      pos = savedPos2;
                                    }
                                  } else {
                                    var result55 = null;
                                    pos = savedPos2;
                                  }
                                } else {
                                  var result55 = null;
                                  pos = savedPos2;
                                }
                                var result54 = result55 !== null
                                  ? (function(e1, e2) {
                                      var ex = {};
                                      ex.token = 'expression';
                                      ex.expressionType = 'builtincall';
                                      ex.builtincall = 'sameterm';
                                      ex.args = [e1, e2];
                                      return ex;
                                  })(result55[4], result55[8])
                                  : null;
                                if (result54 !== null) {
                                  var result0 = result54;
                                } else {
                                  var savedPos1 = pos;
                                  if (input.substr(pos, 1) === "I") {
                                    var result53 = "I";
                                    pos += 1;
                                  } else {
                                    var result53 = null;
                                    if (reportMatchFailures) {
                                      matchFailed("\"I\"");
                                    }
                                  }
                                  if (result53 !== null) {
                                    var result30 = result53;
                                  } else {
                                    if (input.substr(pos, 1) === "i") {
                                      var result52 = "i";
                                      pos += 1;
                                    } else {
                                      var result52 = null;
                                      if (reportMatchFailures) {
                                        matchFailed("\"i\"");
                                      }
                                    }
                                    if (result52 !== null) {
                                      var result30 = result52;
                                    } else {
                                      var result30 = null;;
                                    };
                                  }
                                  if (result30 !== null) {
                                    if (input.substr(pos, 1) === "S") {
                                      var result51 = "S";
                                      pos += 1;
                                    } else {
                                      var result51 = null;
                                      if (reportMatchFailures) {
                                        matchFailed("\"S\"");
                                      }
                                    }
                                    if (result51 !== null) {
                                      var result31 = result51;
                                    } else {
                                      if (input.substr(pos, 1) === "s") {
                                        var result50 = "s";
                                        pos += 1;
                                      } else {
                                        var result50 = null;
                                        if (reportMatchFailures) {
                                          matchFailed("\"s\"");
                                        }
                                      }
                                      if (result50 !== null) {
                                        var result31 = result50;
                                      } else {
                                        var result31 = null;;
                                      };
                                    }
                                    if (result31 !== null) {
                                      if (input.substr(pos, 1) === "U") {
                                        var result49 = "U";
                                        pos += 1;
                                      } else {
                                        var result49 = null;
                                        if (reportMatchFailures) {
                                          matchFailed("\"U\"");
                                        }
                                      }
                                      if (result49 !== null) {
                                        var result32 = result49;
                                      } else {
                                        if (input.substr(pos, 1) === "u") {
                                          var result48 = "u";
                                          pos += 1;
                                        } else {
                                          var result48 = null;
                                          if (reportMatchFailures) {
                                            matchFailed("\"u\"");
                                          }
                                        }
                                        if (result48 !== null) {
                                          var result32 = result48;
                                        } else {
                                          var result32 = null;;
                                        };
                                      }
                                      if (result32 !== null) {
                                        if (input.substr(pos, 1) === "R") {
                                          var result47 = "R";
                                          pos += 1;
                                        } else {
                                          var result47 = null;
                                          if (reportMatchFailures) {
                                            matchFailed("\"R\"");
                                          }
                                        }
                                        if (result47 !== null) {
                                          var result33 = result47;
                                        } else {
                                          if (input.substr(pos, 1) === "r") {
                                            var result46 = "r";
                                            pos += 1;
                                          } else {
                                            var result46 = null;
                                            if (reportMatchFailures) {
                                              matchFailed("\"r\"");
                                            }
                                          }
                                          if (result46 !== null) {
                                            var result33 = result46;
                                          } else {
                                            var result33 = null;;
                                          };
                                        }
                                        if (result33 !== null) {
                                          if (input.substr(pos, 1) === "I") {
                                            var result45 = "I";
                                            pos += 1;
                                          } else {
                                            var result45 = null;
                                            if (reportMatchFailures) {
                                              matchFailed("\"I\"");
                                            }
                                          }
                                          if (result45 !== null) {
                                            var result34 = result45;
                                          } else {
                                            if (input.substr(pos, 1) === "i") {
                                              var result44 = "i";
                                              pos += 1;
                                            } else {
                                              var result44 = null;
                                              if (reportMatchFailures) {
                                                matchFailed("\"i\"");
                                              }
                                            }
                                            if (result44 !== null) {
                                              var result34 = result44;
                                            } else {
                                              var result34 = null;;
                                            };
                                          }
                                          if (result34 !== null) {
                                            var result35 = [];
                                            var result43 = parse_WS();
                                            while (result43 !== null) {
                                              result35.push(result43);
                                              var result43 = parse_WS();
                                            }
                                            if (result35 !== null) {
                                              if (input.substr(pos, 1) === "(") {
                                                var result36 = "(";
                                                pos += 1;
                                              } else {
                                                var result36 = null;
                                                if (reportMatchFailures) {
                                                  matchFailed("\"(\"");
                                                }
                                              }
                                              if (result36 !== null) {
                                                var result37 = [];
                                                var result42 = parse_WS();
                                                while (result42 !== null) {
                                                  result37.push(result42);
                                                  var result42 = parse_WS();
                                                }
                                                if (result37 !== null) {
                                                  var result38 = parse_ConditionalOrExpression();
                                                  if (result38 !== null) {
                                                    var result39 = [];
                                                    var result41 = parse_WS();
                                                    while (result41 !== null) {
                                                      result39.push(result41);
                                                      var result41 = parse_WS();
                                                    }
                                                    if (result39 !== null) {
                                                      if (input.