module.exports = /*
 * Generated by PEG.js 0.10.0.
 *
 * http://pegjs.org/
 */
(function() {
  "use strict";

  function peg$subclass(child, parent) {
    function ctor() { this.constructor = child; }
    ctor.prototype = parent.prototype;
    child.prototype = new ctor();
  }

  function peg$SyntaxError(message, expected, found, location) {
    this.message  = message;
    this.expected = expected;
    this.found    = found;
    this.location = location;
    this.name     = "SyntaxError";

    if (typeof Error.captureStackTrace === "function") {
      Error.captureStackTrace(this, peg$SyntaxError);
    }
  }

  peg$subclass(peg$SyntaxError, Error);

  peg$SyntaxError.buildMessage = function(expected, found) {
    var DESCRIBE_EXPECTATION_FNS = {
          literal: function(expectation) {
            return "\"" + literalEscape(expectation.text) + "\"";
          },

          "class": function(expectation) {
            var escapedParts = "",
                i;

            for (i = 0; i < expectation.parts.length; i++) {
              escapedParts += expectation.parts[i] instanceof Array
                ? classEscape(expectation.parts[i][0]) + "-" + classEscape(expectation.parts[i][1])
                : classEscape(expectation.parts[i]);
            }

            return "[" + (expectation.inverted ? "^" : "") + escapedParts + "]";
          },

          any: function(expectation) {
            return "any character";
          },

          end: function(expectation) {
            return "end of input";
          },

          other: function(expectation) {
            return expectation.description;
          }
        };

    function hex(ch) {
      return ch.charCodeAt(0).toString(16).toUpperCase();
    }

    function literalEscape(s) {
      return s
        .replace(/\\/g, '\\\\')
        .replace(/"/g,  '\\"')
        .replace(/\0/g, '\\0')
        .replace(/\t/g, '\\t')
        .replace(/\n/g, '\\n')
        .replace(/\r/g, '\\r')
        .replace(/[\x00-\x0F]/g,          function(ch) { return '\\x0' + hex(ch); })
        .replace(/[\x10-\x1F\x7F-\x9F]/g, function(ch) { return '\\x'  + hex(ch); });
    }

    function classEscape(s) {
      return s
        .replace(/\\/g, '\\\\')
        .replace(/\]/g, '\\]')
        .replace(/\^/g, '\\^')
        .replace(/-/g,  '\\-')
        .replace(/\0/g, '\\0')
        .replace(/\t/g, '\\t')
        .replace(/\n/g, '\\n')
        .replace(/\r/g, '\\r')
        .replace(/[\x00-\x0F]/g,          function(ch) { return '\\x0' + hex(ch); })
        .replace(/[\x10-\x1F\x7F-\x9F]/g, function(ch) { return '\\x'  + hex(ch); });
    }

    function describeExpectation(expectation) {
      return DESCRIBE_EXPECTATION_FNS[expectation.type](expectation);
    }

    function describeExpected(expected) {
      var descriptions = new Array(expected.length),
          i, j;

      for (i = 0; i < expected.length; i++) {
        descriptions[i] = describeExpectation(expected[i]);
      }

      descriptions.sort();

      if (descriptions.length > 0) {
        for (i = 1, j = 1; i < descriptions.length; i++) {
          if (descriptions[i - 1] !== descriptions[i]) {
            descriptions[j] = descriptions[i];
            j++;
          }
        }
        descriptions.length = j;
      }

      switch (descriptions.length) {
        case 1:
          return descriptions[0];

        case 2:
          return descriptions[0] + " or " + descriptions[1];

        default:
          return descriptions.slice(0, -1).join(", ")
            + ", or "
            + descriptions[descriptions.length - 1];
      }
    }

    function describeFound(found) {
      return found ? "\"" + literalEscape(found) + "\"" : "end of input";
    }

    return "Expected " + describeExpected(expected) + " but " + describeFound(found) + " found.";
  };

  function peg$parse(input, options) {
    options = options !== void 0 ? options : {};

    var peg$FAILED = {},

        peg$startRuleFunctions = { DOCUMENT: peg$parseDOCUMENT },
        peg$startRuleFunction  = peg$parseDOCUMENT,

        peg$c0 = peg$otherExpectation("[1] QueryUnit"),
        peg$c1 = peg$otherExpectation("[2] Query"),
        peg$c2 = function(p, q, v) {
            return {
        	token: 'query',
        	kind: 'query',
        	prologue: p,
        	units: [q],
        	inlineData: v
            }
        },
        peg$c3 = peg$otherExpectation("[3] Prologue"),
        peg$c4 = function(b, pfx) {
            return { token: 'prologue',
        	base: b,
        	prefixes: pfx }
        },
        peg$c5 = peg$otherExpectation("[4] BaseDecl"),
        peg$c6 = "BASE",
        peg$c7 = peg$literalExpectation("BASE", false),
        peg$c8 = "base",
        peg$c9 = peg$literalExpectation("base", false),
        peg$c10 = function(i) {
            registerDefaultPrefix(i);

            var base = {};
            base.token = 'base';
            base.value = i;

            return base;
        },
        peg$c11 = peg$otherExpectation("[5] PrefixDecl"),
        peg$c12 = "PREFIX",
        peg$c13 = peg$literalExpectation("PREFIX", false),
        peg$c14 = "prefix",
        peg$c15 = peg$literalExpectation("prefix", false),
        peg$c16 = function(p, l) {

            registerPrefix(p,l);

            var prefix = {};
            prefix.token = 'prefix';
            prefix.prefix = p;
            prefix.local = l;

            return prefix;
        },
        peg$c17 = peg$otherExpectation("[6] SelectQuery"),
        peg$c18 = function(s, gs, w, sm) {

            var dataset = {'named':[], 'implicit':[]};
            for(var i=0; i<gs.length; i++) {
        	var g = gs[i];
        	if(g.kind === 'default') {
        	    dataset['implicit'].push(g.graph);
        	} else {
        	    dataset['named'].push(g.graph)
        	}
            }


            if(dataset['named'].length === 0 && dataset['implicit'].length === 0) {
        	dataset['implicit'].push({token:'uri',
        	    prefix:null,
        	    suffix:null,
        	    value:'https://github.com/antoniogarrote/rdfstore-js#default_graph'});
            }

            var query = {};
            query.kind = 'select';
            query.token = 'executableunit';
            query.dataset = dataset;
            query.projection = s.vars;
            query.modifier = s.modifier;
            query.pattern = w;

            if(sm!=null && sm.limit!=null) {
        	query.limit = sm.limit;
            }
            if(sm!=null && sm.offset!=null) {
        	query.offset = sm.offset;
            }
            if(sm!=null && (sm.order!=null && sm.order!="")) {
        	query.order = sm.order;
            }
            if(sm!=null && sm.group!=null) {
        	query.group = sm.group;
            }

            return query;
        },
        peg$c19 = peg$otherExpectation("[7] SubSelect"),
        peg$c20 = function(s, w, sm) {

            var query = {};
            query.kind = 'select';
            query.token = 'subselect';
            query.projection = s.vars;
            query.modifier = s.modifier;
            query.pattern = w;

            if(sm!=null && sm.limit!=null) {
        	query.limit = sm.limit;
            }
            if(sm!=null && sm.offset!=null) {
        	query.offset = sm.offset;
            }
            if(sm!=null && (sm.order!=null && sm.order!="")) {
        	query.order = sm.order;
            }
            if(sm!=null && sm.group!=null) {
        	query.group = sm.group;
            }

            return query;

        },
        peg$c21 = peg$otherExpectation("[8] SelectClause"),
        peg$c22 = "SELECT",
        peg$c23 = peg$literalExpectation("SELECT", false),
        peg$c24 = "select",
        peg$c25 = peg$literalExpectation("select", false),
        peg$c26 = "DISTINCT",
        peg$c27 = peg$literalExpectation("DISTINCT", false),
        peg$c28 = "distinct",
        peg$c29 = peg$literalExpectation("distinct", false),
        peg$c30 = "REDUCED",
        peg$c31 = peg$literalExpectation("REDUCED", false),
        peg$c32 = "reduced",
        peg$c33 = peg$literalExpectation("reduced", false),
        peg$c34 = "(",
        peg$c35 = peg$literalExpectation("(", false),
        peg$c36 = "AS",
        peg$c37 = peg$literalExpectation("AS", false),
        peg$c38 = "as",
        peg$c39 = peg$literalExpectation("as", false),
        peg$c40 = ")",
        peg$c41 = peg$literalExpectation(")", false),
        peg$c42 = "*",
        peg$c43 = peg$literalExpectation("*", false),
        peg$c44 = function(mod, proj) {
            var vars = [];
            if(proj.length === 3 && proj[1]==="*") {
        	return {vars: [{token: 'variable', kind:'*'}], modifier:arrayToString(mod)};
            }

            for(var i=0; i< proj.length; i++) {
        	var aVar = proj[i];

        	if(aVar.length === 3) {
        	    vars.push({token: 'variable', kind:'var', value:aVar[1]});
        	} else {
        	    vars.push({token: 'variable', kind:'aliased', expression: aVar[3], alias:aVar[7]})
        	}
            }

            return {vars: vars, modifier:arrayToString(mod)};
        },
        peg$c45 = peg$otherExpectation("[9] ConstructQuery"),
        peg$c46 = "CONSTRUCT",
        peg$c47 = peg$literalExpectation("CONSTRUCT", false),
        peg$c48 = "construct",
        peg$c49 = peg$literalExpectation("construct", false),
        peg$c50 = function(t, gs, w, sm) {
            var dataset = {'named':[], 'implicit':[]};
            for(var i=0; i<gs.length; i++) {
        	var g = gs[i];
        	if(g.kind === 'default') {
        	    dataset['implicit'].push(g.graph);
        	} else {
        	    dataset['named'].push(g.graph)
        	}
            }


            if(dataset['named'].length === 0 && dataset['implicit'].length === 0) {
        	dataset['implicit'].push({token:'uri',
        	    prefix:null,
        	    suffix:null,
        	    value:'https://github.com/antoniogarrote/rdfstore-js#default_graph'});
            }

            var query = {};
            query.kind = 'construct';
            query.token = 'executableunit'
            query.dataset = dataset;
            query.template = t;
            query.pattern = w;

            if(sm!=null && sm.limit!=null) {
        	query.limit = sm.limit;
            }
            if(sm!=null && sm.offset!=null) {
        	query.offset = sm.offset;
            }
            if(sm!=null && (sm.order!=null && sm.order!="")) {
        	query.order = sm.order;
            }
            return query

        },
        peg$c51 = "WHERE",
        peg$c52 = peg$literalExpectation("WHERE", false),
        peg$c53 = "where",
        peg$c54 = peg$literalExpectation("where", false),
        peg$c55 = "{",
        peg$c56 = peg$literalExpectation("{", false),
        peg$c57 = "}",
        peg$c58 = peg$literalExpectation("}", false),
        peg$c59 = function(gs, t, sm) {
            var dataset = {'named':[], 'implicit':[]};
            for(var i=0; i<gs.length; i++) {
        	var g = gs[i];
        	if(g.kind === 'default') {
        	    dataset['implicit'].push(g.graph);
        	} else {
        	    dataset['named'].push(g.graph)
        	}
            }


            if(dataset['named'].length === 0 && dataset['implicit'].length === 0) {
        	dataset['implicit'].push({token:'uri',
        	    prefix:null,
        	    suffix:null,
        	    value:'https://github.com/antoniogarrote/rdfstore-js#default_graph'});
            }

            var query = {};
            query.kind = 'construct';
            query.token = 'executableunit'
            query.dataset = dataset;
            query.template = t;
            query.pattern = {
        	token: "basicgraphpattern",
        	triplesContext: t.triplesContext
            };

            if(sm!=null && sm.limit!=null) {
        	query.limit = sm.limit;
            }
            if(sm!=null && sm.offset!=null) {
        	query.offset = sm.offset;
            }
            if(sm!=null && (sm.order!=null && sm.order!="")) {
        	query.order = sm.order;
            }
            return query
        },
        peg$c60 = peg$otherExpectation("[10] DescribeQuery"),
        peg$c61 = "DESCRIBE",
        peg$c62 = peg$literalExpectation("DESCRIBE", false),
        peg$c63 = peg$otherExpectation("[11] AskQuery"),
        peg$c64 = "ASK",
        peg$c65 = peg$literalExpectation("ASK", false),
        peg$c66 = "ask",
        peg$c67 = peg$literalExpectation("ask", false),
        peg$c68 = function(gs, w) {
            var dataset = {'named':[], 'implicit':[]};
            for(var i=0; i<gs.length; i++) {
        	var g = gs[i];
        	if(g.kind === 'implicit') {
        	    dataset['implicit'].push(g.graph);
        	} else {
        	    dataset['named'].push(g.graph)
        	}
            }


            if(dataset['named'].length === 0 && dataset['implicit'].length === 0) {
        	dataset['implicit'].push({token:'uri',
        	    prefix:null,
        	    suffix:null,
        	    value:'https://github.com/antoniogarrote/rdfstore-js#default_graph'});
            }

            var query = {};
            query.kind = 'ask';
            query.token = 'executableunit'
            query.dataset = dataset;
            query.pattern = w

            return query
        },
        peg$c69 = peg$otherExpectation("[12] DatasetClause"),
        peg$c70 = "FROM",
        peg$c71 = peg$literalExpectation("FROM", false),
        peg$c72 = "from",
        peg$c73 = peg$literalExpectation("from", false),
        peg$c74 = function(gs) {
            return gs;
        },
        peg$c75 = peg$otherExpectation("[13] DefaultGraphClause"),
        peg$c76 = function(s) {
            return {graph:s , kind:'default', token:'graphClause'}
        },
        peg$c77 = peg$otherExpectation("[14] NamedGraphClause"),
        peg$c78 = "NAMED",
        peg$c79 = peg$literalExpectation("NAMED", false),
        peg$c80 = "named",
        peg$c81 = peg$literalExpectation("named", false),
        peg$c82 = function(s) {
            return {graph:s, kind:'named', token:'graphCluase'};
        },
        peg$c83 = peg$otherExpectation("[15] SourceSelector"),
        peg$c84 = peg$otherExpectation("[16] WhereClause"),
        peg$c85 = function(g) {
            return g;
        },
        peg$c86 = peg$otherExpectation("[17] SolutionModifier"),
        peg$c87 = function(gc, oc, lo) {
            var acum = {};
        if(lo != null) {
            if(lo.limit != null) {
        	acum.limit = lo.limit;
            }
            if(lo.offset != null) {
        	acum.offset = lo.offset;
            }
        }

        if(gc != null) {
            acum.group = gc;
        }

        acum.order = oc;

        return acum
        },
        peg$c88 = peg$otherExpectation("[18] GroupClause"),
        peg$c89 = "GROUP",
        peg$c90 = peg$literalExpectation("GROUP", false),
        peg$c91 = "group",
        peg$c92 = peg$literalExpectation("group", false),
        peg$c93 = "BY",
        peg$c94 = peg$literalExpectation("BY", false),
        peg$c95 = "by",
        peg$c96 = peg$literalExpectation("by", false),
        peg$c97 = function(conds) {
            return conds;
        },
        peg$c98 = peg$otherExpectation("[19] GroupCondition"),
        peg$c99 = function(b) {
            return b;
        },
        peg$c100 = function(f) {
            return f;
        },
        peg$c101 = function(e, alias) {
            if(alias.length != 0) {
            return {token: 'aliased_expression',
        	expression: e,
        	alias: alias[2] };
        } else {
            return e;
        }
        },
        peg$c102 = function(v) {
            return v;
        },
        peg$c103 = peg$otherExpectation("[20] HavingClause"),
        peg$c104 = "HAVING",
        peg$c105 = peg$literalExpectation("HAVING", false),
        peg$c106 = peg$otherExpectation("[21] HavingCondition"),
        peg$c107 = peg$otherExpectation("[22] OrderClause"),
        peg$c108 = "ORDER",
        peg$c109 = peg$literalExpectation("ORDER", false),
        peg$c110 = "order",
        peg$c111 = peg$literalExpectation("order", false),
        peg$c112 = function(os) {
            return os;
        },
        peg$c113 = peg$otherExpectation("[23] OrderCondition"),
        peg$c114 = "ASC",
        peg$c115 = peg$literalExpectation("ASC", false),
        peg$c116 = "asc",
        peg$c117 = peg$literalExpectation("asc", false),
        peg$c118 = "DESC",
        peg$c119 = peg$literalExpectation("DESC", false),
        peg$c120 = "desc",
        peg$c121 = peg$literalExpectation("desc", false),
        peg$c122 = function(direction, e) {
            return { direction: direction.toUpperCase(), expression:e };
        },
        peg$c123 = function(e) {
            if(e.token === 'var') {
            var e = { token:'expression',
        	expressionType:'atomic',
        	primaryexpression: 'var',
        	value: e };
        }
        return { direction: 'ASC', expression:e };
        },
        peg$c124 = peg$otherExpectation("[24] LimitOffsetClauses"),
        peg$c125 = function(cls) {
            var acum = {};
            for(var i=0; i<cls.length; i++) {
        	var cl = cls[i];
        	if(cl != null && cl.limit != null) {
        	    acum['limit'] = cl.limit;
        	} else if(cl != null && cl.offset != null){
        	    acum['offset'] = cl.offset;
        	}
            }

            return acum;
        },
        peg$c126 = peg$otherExpectation("[25] LimitClause"),
        peg$c127 = "LIMIT",
        peg$c128 = peg$literalExpectation("LIMIT", false),
        peg$c129 = "limit",
        peg$c130 = peg$literalExpectation("limit", false),
        peg$c131 = function(i) {
            return { limit:parseInt(i.value) };
        },
        peg$c132 = peg$otherExpectation("[26] OffsetClause"),
        peg$c133 = "OFFSET",
        peg$c134 = peg$literalExpectation("OFFSET", false),
        peg$c135 = "offset",
        peg$c136 = peg$literalExpectation("offset", false),
        peg$c137 = function(i) {
            return { offset:parseInt(i.value) };
        },
        peg$c138 = peg$otherExpectation("[27] BindingsClause"),
        peg$c139 = "BINDINGS",
        peg$c140 = peg$literalExpectation("BINDINGS", false),
        peg$c141 = peg$otherExpectation("[28] BindingValue"),
        peg$c142 = "UNDEF",
        peg$c143 = peg$literalExpectation("UNDEF", false),
        peg$c144 = peg$otherExpectation("[28]\tValuesClause\t  ::=\t( 'VALUES' DataBlock )?"),
        peg$c145 = "VALUES",
        peg$c146 = peg$literalExpectation("VALUES", false),
        peg$c147 = "values",
        peg$c148 = peg$literalExpectation("values", false),
        peg$c149 = function(b) {
             if(b != null) {
               return b[1];
             } else {
               return null;
             }
        },
        peg$c150 = peg$otherExpectation("[29] UpdateUnit"),
        peg$c151 = peg$otherExpectation("[30] Update"),
        peg$c152 = ";",
        peg$c153 = peg$literalExpectation(";", false),
        peg$c154 = function(p, u, us) {

            var query = {};
        query.token = 'query';
        query.kind = 'update'
        query.prologue = p;

        var units = [u];

        if(us != null && us.length != null && us[3] != null && us[3].units != null) {
            units = units.concat(us[3].units);
        }

        query.units = units;
        return query;
        },
        peg$c155 = peg$otherExpectation("[31] Update1"),
        peg$c156 = peg$otherExpectation("[32] Load"),
        peg$c157 = "LOAD",
        peg$c158 = peg$literalExpectation("LOAD", false),
        peg$c159 = "load",
        peg$c160 = peg$literalExpectation("load", false),
        peg$c161 = "INTO",
        peg$c162 = peg$literalExpectation("INTO", false),
        peg$c163 = "into",
        peg$c164 = peg$literalExpectation("into", false),
        peg$c165 = function(sg, dg) {
            var query = {};
        query.kind = 'load';
        query.token = 'executableunit';
        query.sourceGraph = sg;
        if(dg != null) {
            query.destinyGraph = dg[2];
        }
        return query;
        },
        peg$c166 = peg$otherExpectation("[33] Clear"),
        peg$c167 = "CLEAR",
        peg$c168 = peg$literalExpectation("CLEAR", false),
        peg$c169 = "clear",
        peg$c170 = peg$literalExpectation("clear", false),
        peg$c171 = "SILENT",
        peg$c172 = peg$literalExpectation("SILENT", false),
        peg$c173 = "silent",
        peg$c174 = peg$literalExpectation("silent", false),
        peg$c175 = function(ref) {
            var query = {};
            query.kind = 'clear';
            query.token = 'executableunit'
            query.destinyGraph = ref;

            return query;
        },
        peg$c176 = peg$otherExpectation("[34] Drop"),
        peg$c177 = "DROP",
        peg$c178 = peg$literalExpectation("DROP", false),
        peg$c179 = "drop",
        peg$c180 = peg$literalExpectation("drop", false),
        peg$c181 = function(ref) {
            var query = {};
            query.kind = 'drop';
            query.token = 'executableunit'
            query.destinyGraph = ref;

            return query;
        },
        peg$c182 = peg$otherExpectation("[35] Create"),
        peg$c183 = "CREATE",
        peg$c184 = peg$literalExpectation("CREATE", false),
        peg$c185 = "create",
        peg$c186 = peg$literalExpectation("create", false),
        peg$c187 = function(ref) {
            var query = {};
            query.kind = 'create';
            query.token = 'executableunit'
            query.destinyGraph = ref;

            return query;
        },
        peg$c188 = peg$otherExpectation("[36] InsertData"),
        peg$c189 = "INSERT",
        peg$c190 = peg$literalExpectation("INSERT", false),
        peg$c191 = "insert",
        peg$c192 = peg$literalExpectation("insert", false),
        peg$c193 = "DATA",
        peg$c194 = peg$literalExpectation("DATA", false),
        peg$c195 = "data",
        peg$c196 = peg$literalExpectation("data", false),
        peg$c197 = function(qs) {
            var query = {};
            query.kind = 'insertdata';
            query.token = 'executableunit'
            query.quads = qs;

            return query;
        },
        peg$c198 = peg$otherExpectation("[37] DeleteData"),
        peg$c199 = "DELETE",
        peg$c200 = peg$literalExpectation("DELETE", false),
        peg$c201 = "delete",
        peg$c202 = peg$literalExpectation("delete", false),
        peg$c203 = function(qs) {
            var query = {};
            query.kind = 'deletedata';
            query.token = 'executableunit'
            query.quads = qs;

            return query;
        },
        peg$c204 = peg$otherExpectation("[38] DeleteWhere"),
        peg$c205 = function(p) {
            var query = {};
            query.kind = 'modify';
            query.pattern = p;
            query.with = null;
            query.using = null;

            var quads = [];


            var patternsCollection = p.patterns[0];
            if(patternsCollection.triplesContext == null && patternsCollection.patterns!=null) {
        	patternsCollection = patternsCollection.patterns[0].triplesContext;
            } else {
        	patternsCollection = patternsCollection.triplesContext;
            }

            for(var i=0; i<patternsCollection.length; i++) {
        	var quad = {};
        	var contextQuad = patternsCollection[i];

        	quad['subject'] = contextQuad['subject'];
        	quad['predicate'] = contextQuad['predicate'];
        	quad['object'] = contextQuad['object'];
        	quad['graph'] = contextQuad['graph'];

        	quads.push(quad);
            }

            query.delete = quads;

            return query;
        },
        peg$c206 = peg$otherExpectation("[39] Modify"),
        peg$c207 = "WITH",
        peg$c208 = peg$literalExpectation("WITH", false),
        peg$c209 = "with",
        peg$c210 = peg$literalExpectation("with", false),
        peg$c211 = function(wg, dic, uc, p) {
            var query = {};
        query.kind = 'modify';

        if(wg != "" && wg != null) {
            query.with = wg[2];
        } else {
            query.with = null;
        }


        if(dic.length === 3 && (dic[2] === ''|| dic[2] == null)) {
            query.delete = dic[0];
            query.insert = null;
        } else if(dic.length === 3 && dic[0].length != null && dic[1].length != null && dic[2].length != null) {
            query.delete = dic[0];
            query.insert = dic[2];
        } else  {
            query.insert = dic;
            query.delete = null;
        }

        if(uc != '') {
            query.using = uc;
        }

        query.pattern = p;

        return query;
        },
        peg$c212 = peg$otherExpectation("[40] DeleteClause"),
        peg$c213 = function(q) {
            return q;
        },
        peg$c214 = peg$otherExpectation("[41] InsertClause"),
        peg$c215 = peg$otherExpectation("[42] UsingClause"),
        peg$c216 = "USING",
        peg$c217 = peg$literalExpectation("USING", false),
        peg$c218 = "using",
        peg$c219 = peg$literalExpectation("using", false),
        peg$c220 = function(g) {
            if(g.length!=null) {
        	return {kind: 'named', uri: g[2]};
            } else {
        	return {kind: 'default', uri: g};
            }
        },
        peg$c221 = peg$otherExpectation("[43] GraphRef"),
        peg$c222 = "GRAPH",
        peg$c223 = peg$literalExpectation("GRAPH", false),
        peg$c224 = "graph",
        peg$c225 = peg$literalExpectation("graph", false),
        peg$c226 = function(i) {
            return i;
        },
        peg$c227 = peg$otherExpectation("[44] GraphRefAll"),
        peg$c228 = "DEFAULT",
        peg$c229 = peg$literalExpectation("DEFAULT", false),
        peg$c230 = "default",
        peg$c231 = peg$literalExpectation("default", false),
        peg$c232 = function() {
            return 'default';
        },
        peg$c233 = function() {
            return 'named';
        },
        peg$c234 = "ALL",
        peg$c235 = peg$literalExpectation("ALL", false),
        peg$c236 = "all",
        peg$c237 = peg$literalExpectation("all", false),
        peg$c238 = function() {
            return 'all';
        },
        peg$c239 = peg$otherExpectation("[45] QuadPattern"),
        peg$c240 = function(qs) {
            return qs.quadsContext;
        },
        peg$c241 = peg$otherExpectation("[46] QuadData"),
        peg$c242 = peg$otherExpectation("[47] Quads"),
        peg$c243 = ".",
        peg$c244 = peg$literalExpectation(".", false),
        peg$c245 = function(ts, qs) {
            var quads = [];
            if(ts != null && ts.triplesContext != null) {
        	for(var i=0; i<ts.triplesContext.length; i++) {
        	    var triple = ts.triplesContext[i]
        	    triple.graph = null;
        	    quads.push(triple)
        	}
            }

            if(qs && qs.length>0 && qs[0].length > 0) {
        	quads = quads.concat(qs[0][0].quadsContext);

        	if( qs[0][2] != null && qs[0][2].triplesContext != null) {
        	    for(var i=0; i<qs[0][2].triplesContext.length; i++) {
        		var triple = qs[0][2].triplesContext[i]
        		triple.graph = null;
        		quads.push(triple)
        	    }
        	}
            }

            return {token:'quads',
        	quadsContext: quads}
        },
        peg$c246 = peg$otherExpectation("[48] QuadsNotTriples"),
        peg$c247 = function(g, ts) {
            var quads = [];
            if(ts!=null) {
        	for (var i = 0; i < ts.triplesContext.length; i++) {
        	    var triple = ts.triplesContext[i];
        	    triple.graph = g;
        	    quads.push(triple)
        	}
            }

        return {token:'quadsnottriples',
            quadsContext: quads}
        },
        peg$c248 = peg$otherExpectation("[49] TriplesTemplate"),
        peg$c249 = function(b, bs) {
            var triples = b.triplesContext;
            if(bs != null && typeof(bs) === 'object') {
               if(bs.length != null) {
        	  if(bs[3] != null && bs[3].triplesContext!=null) {
        	      triples = triples.concat(bs[3].triplesContext);
        	  }
               }
            }

            return {
        	token:'triplestemplate',
        	triplesContext: triples
            };
        },
        peg$c250 = peg$otherExpectation("[50] GroupGraphPattern"),
        peg$c251 = function(p) {
            return p;
        },
        peg$c252 = peg$otherExpectation("[51] GroupGraphPatternSub"),
        peg$c253 = function(tb, tbs) {
            var subpatterns = [];
            if(tb != null && tb != []) {
        	subpatterns.push(tb);
            }

            for(var i=0; i<tbs.length; i++) {
        	for(var j=0; j< tbs[i].length; j++) {
        	    if(tbs[i][j] != null && tbs[i][j].token != null) {
        		subpatterns.push(tbs[i][j]);
        	    }
        	}
            }

            var compactedSubpatterns = [];

            var currentBasicGraphPatterns = [];
            var currentFilters = [];
            var currentBinds = [];

            for(var i=0; i<subpatterns.length; i++) {
        	if(subpatterns[i].token!=='triplespattern' && subpatterns[i].token !== 'filter' && subpatterns[i].token !== 'bind') {
        	    if(currentBasicGraphPatterns.length != 0 || currentFilters.length != 0) {
        		var triplesContext = [];
        		for(var j=0; j<currentBasicGraphPatterns.length; j++) {
        		    triplesContext = triplesContext.concat(currentBasicGraphPatterns[j].triplesContext);
        		}
        		if(triplesContext.length > 0) {
        		    compactedSubpatterns.push({token: 'basicgraphpattern',
        			triplesContext: triplesContext});
        		}
        		currentBasicGraphPatterns = [];
        	    }
        	    compactedSubpatterns.push(subpatterns[i]);
        	} else {
        	    if(subpatterns[i].token === 'triplespattern') {
        		currentBasicGraphPatterns.push(subpatterns[i]);
                    } else if(subpatterns[i].token === 'bind') {
                        currentBinds.push(subpatterns[i]);

        	    } else {
        		currentFilters.push(subpatterns[i]);
        	    }
        	}
            }

            if(currentBasicGraphPatterns.length != 0 || currentFilters.length != 0) {
        	var triplesContext = [];
        	for(var j=0; j<currentBasicGraphPatterns.length; j++) {
        	    triplesContext = triplesContext.concat(currentBasicGraphPatterns[j].triplesContext);
        	}
        	if(triplesContext.length > 0) {
        	    compactedSubpatterns.push({token: 'basicgraphpattern',
        		triplesContext: triplesContext});
        	}
            }

        //      if(compactedSubpatterns.length == 1) {
        //          compactedSubpatterns[0].filters = currentFilters;
        //          return compactedSubpatterns[0];
        //      } else  {
            return { token: 'groupgraphpattern',
        	patterns: compactedSubpatterns,
                filters: currentFilters,
                binds: currentBinds
            }
        //      }
        },
        peg$c254 = peg$otherExpectation("[54] TriplesBlock"),
        peg$c255 = function(b, bs) {
            var triples = b.triplesContext;
        if(bs != null && typeof(bs) === 'object') {
            if(bs != null && bs.length != null) {
        	if(bs[2] != null && bs[2].triplesContext!=null) {
        	    triples = triples.concat(bs[2].triplesContext);
        	}
            }
        }

        return {token:'triplespattern',
            triplesContext: triples}
        },
        peg$c256 = peg$otherExpectation("[53] GraphPatternNotTriples"),
        peg$c257 = peg$otherExpectation("[54] OptionalGraphPattern"),
        peg$c258 = "OPTIONAL",
        peg$c259 = peg$literalExpectation("OPTIONAL", false),
        peg$c260 = "optional",
        peg$c261 = peg$literalExpectation("optional", false),
        peg$c262 = function(v) {
            return { token: 'optionalgraphpattern',
        	value: v }
        },
        peg$c263 = peg$otherExpectation("[55] GraphGraphPattern"),
        peg$c264 = function(g, gg) {
            for(var i=0; i<gg.patterns.length; i++) {
        	var quads = []
        	var ts = gg.patterns[i];
        	for(var j=0; j<ts.triplesContext.length; j++) {
        	    var triple = ts.triplesContext[j]
        	    triple.graph = g;
        	}
            }

            gg.token = 'groupgraphpattern'
            return gg;
        },
        peg$c265 = peg$otherExpectation("[56] ServiceGraphPattern"),
        peg$c266 = "SERVICE",
        peg$c267 = peg$literalExpectation("SERVICE", false),
        peg$c268 = function(v, ts) {
            return {token: 'servicegraphpattern',
        	status: 'todo',
        	value: [v,ts] }
        },
        peg$c269 = peg$otherExpectation("[57] MinusGraphPattern"),
        peg$c270 = "MINUS",
        peg$c271 = peg$literalExpectation("MINUS", false),
        peg$c272 = "minus",
        peg$c273 = peg$literalExpectation("minus", false),
        peg$c274 = function(ts) {
            return {token: 'minusgraphpattern',
        	status: 'todo',
        	value: ts}
        },
        peg$c275 = peg$otherExpectation("[58] GroupOrUnionGraphPattern"),
        peg$c276 = "UNION",
        peg$c277 = peg$literalExpectation("UNION", false),
        peg$c278 = "union",
        peg$c279 = peg$literalExpectation("union", false),
        peg$c280 = function(a, b) {
            if(b.length === 0) {
        	return a;
            } else {

        	var lastToken = {token: 'graphunionpattern',
        	    value: [a]};

        	for(var i=0; i<b.length; i++) {
        	    if(i==b.length-1) {
        		lastToken.value.push(b[i][3]);
        	    } else {
        		lastToken.value.push(b[i][3]);
        		var newToken = {token: 'graphunionpattern',
        		    value: [lastToken]}

        		lastToken = newToken;
        	    }
        	}

        	return lastToken;

            }
        },
        peg$c281 = peg$otherExpectation("[59] Filter"),
        peg$c282 = "FILTER",
        peg$c283 = peg$literalExpectation("FILTER", false),
        peg$c284 = "filter",
        peg$c285 = peg$literalExpectation("filter", false),
        peg$c286 = function(c) {
            return {token: 'filter',
        	value: c}
        },
        peg$c287 = peg$otherExpectation("[60] Bind"),
        peg$c288 = "BIND",
        peg$c289 = peg$literalExpectation("BIND", false),
        peg$c290 = "bind",
        peg$c291 = peg$literalExpectation("bind", false),
        peg$c292 = function(ex, v) {
            return {token: 'bind',
        	    expression: ex,
        	    as: v};
        },
        peg$c293 = peg$otherExpectation("[60] Constraint"),
        peg$c294 = peg$otherExpectation("[61] InlineData"),
        peg$c295 = function(d) {
            return d;
        },
        peg$c296 = peg$otherExpectation("[62] DataBlock"),
        peg$c297 = peg$otherExpectation("[63] InlineDataOneVar"),
        peg$c298 = function(v, d) {
            var result =  {
        	token: 'inlineData',
        	values: [{
        	    'var': v,
        	    'value': d
        	}]
            };

            return result;
        },
        peg$c299 = peg$otherExpectation("[64] InlineDataFull"),
        peg$c300 = function(vars, vals) {
            var result = {
        	token: 'inlineData',
        	values: [],
        	todo: true
            };
            return result;
        },
        peg$c301 = peg$otherExpectation("[65] DataBlockValue"),
        peg$c302 = peg$otherExpectation("[61] FunctionCall"),
        peg$c303 = function(i, args) {
            var fcall = {};
            fcall.token = "expression";
            fcall.expressionType = 'irireforfunction'
            fcall.iriref = i;
            fcall.args = args.value;

            return fcall;
        },
        peg$c304 = peg$otherExpectation("[62] ArgList"),
        peg$c305 = function() {
            var args = {};
            args.token = 'args';
            args.value = [];
            return args;
        },
        peg$c306 = ",",
        peg$c307 = peg$literalExpectation(",", false),
        peg$c308 = function(d, e, es) {
            var cleanEx = [];

            for(var i=0; i<es.length; i++) {
        	cleanEx.push(es[i][2]);
            }
            var args = {};
            args.token = 'args';
            args.value = [e].concat(cleanEx);

            if(d!=null && d.toUpperCase()==="DISTINCT") {
        	args.distinct = true;
            } else {
        	args.distinct = false;
            }

            return args;
        },
        peg$c309 = peg$otherExpectation("[63] ExpressionList"),
        peg$c310 = function(e, es) {
            var cleanEx = [];

            for(var i=0; i<es.length; i++) {
        	cleanEx.push(es[i][2]);
            }
            var args = {};
            args.token = 'args';
            args.value = [e].concat(cleanEx);

            return args;
        },
        peg$c311 = peg$otherExpectation("[64] ConstructTemplate"),
        peg$c312 = function(ts) {
            return ts;
        },
        peg$c313 = peg$otherExpectation("[65] ConstructTriples"),
        peg$c314 = function(b, bs) {
            var triples = b.triplesContext;
        var toTest = null;
        if(bs != null && typeof(bs) === 'object') {
            if(bs.length != null) {
        	if(bs[3] != null && bs[3].triplesContext!=null) {
        	    triples = triples.concat(bs[3].triplesContext);
        	}
            }
        }

        return {token:'triplestemplate',
            triplesContext: triples}
        },
        peg$c315 = peg$otherExpectation("[66] TriplesSameSubject"),
        peg$c316 = function(s, pairs) {
            var triplesContext = pairs.triplesContext;
            var subject = s;
            if(pairs.pairs) {
        	for(var i=0; i< pairs.pairs.length; i++) {
        	    var pair = pairs.pairs[i];
        	    var triple = null;
        	    if(pair[1].length != null)
        		pair[1] = pair[1][0]
        	    if(subject.token && subject.token==='triplesnodecollection') {
        		triple = {subject: subject.chainSubject[0], predicate: pair[0], object: pair[1]}
        		triplesContext.push(triple);
        		triplesContext = triplesContext.concat(subject.triplesContext);
        	    } else {
        		triple = {subject: subject, predicate: pair[0], object: pair[1]}
        		triplesContext.push(triple);
        	    }
        	}
            }

            var token = {};
            token.token = "triplessamesubject";
            token.triplesContext = triplesContext;
            token.chainSubject = subject;

            return token;
        },
        peg$c317 = function(tn, pairs) {
            var triplesContext = tn.triplesContext;
            var subject = tn.chainSubject;

            if(pairs.pairs) {
        	for(var i=0; i< pairs.pairs.length; i++) {
        	    var pair = pairs.pairs[i];
        	    if(pair[1].length != null)
        		pair[1] = pair[1][0]

        	    if(tn.token === "triplesnodecollection") {
        		for(var j=0; j<subject.length; j++) {
        		    var subj = subject[j];
        		    if(subj.triplesContext != null) {
        			var triple = {subject: subj.chainSubject, predicate: pair[0], object: pair[1]}
        			triplesContext.concat(subj.triplesContext);
        		    } else {
        			var triple = {subject: subject[j], predicate: pair[0], object: pair[1]}
        			triplesContext.push(triple);
        		    }
        		}
        	    } else {
        		var triple = {subject: subject, predicate: pair[0], object: pair[1]}
        		triplesContext.push(triple);
        	    }
        	}
            }

            var token = {};
            token.token = "triplessamesubject";
            token.triplesContext = triplesContext;
            token.chainSubject = subject;

            return token;
        },
        peg$c318 = peg$otherExpectation("[83] PropertyListPathNotEmpty"),
        peg$c319 = function(v, ol, rest) {
            var tokenParsed = {};
            tokenParsed.token = 'propertylist';
            var triplesContext = [];
            var pairs = [];
            var test = [];

            for( var i=0; i<ol.length; i++) {

        	if(ol[i].triplesContext != null) {
        	    triplesContext = triplesContext.concat(ol[i].triplesContext);
        	    if(ol[i].token==='triplesnodecollection' && ol[i].chainSubject.length != null) {
        		pairs.push([v, ol[i].chainSubject[0]]);
        	    } else {
        		pairs.push([v, ol[i].chainSubject]);
        	    }

        	} else {
        	    pairs.push([v, ol[i]])
        	}

            }


            for(var i=0; i<rest.length; i++) {
        	var tok = rest[i][3];
        	var newVerb  = tok[0];
        	var newObjsList = tok[2] || [];

        	for(var j=0; j<newObjsList.length; j++) {
        	    if(newObjsList[j].triplesContext != null) {
        		triplesContext = triplesContext.concat(newObjsList[j].triplesContext);
        		pairs.push([newVerb, newObjsList[j].chainSubject]);
        	    } else {
        		pairs.push([newVerb, newObjsList[j]])
        	    }
        	}
            }

            tokenParsed.pairs = pairs;
            tokenParsed.triplesContext = triplesContext;

            return tokenParsed;
        },
        peg$c320 = peg$otherExpectation("[67] PropertyListNotEmpty"),
        peg$c321 = function(v, ol, rest) {
            var tokenParsed = {};
            tokenParsed.token = 'propertylist';
            var triplesContext = [];
            var pairs = [];
            var test = [];

            for( var i=0; i<ol.length; i++) {

        	if(ol[i].triplesContext != null) {
        	    triplesContext = triplesContext.concat(ol[i].triplesContext);
        	    if(ol[i].token==='triplesnodecollection' && ol[i].chainSubject.length != null) {
        		pairs.push([v, ol[i].chainSubject[0]]);
        	    } else {
        		pairs.push([v, ol[i].chainSubject]);
        	    }

        	} else {
        	    pairs.push([v, ol[i]])
        	}

            }


            for(var i=0; i<rest.length; i++) {
        	var tok = rest[i][3];
        	var newVerb  = tok[0];
        	var newObjsList = tok[2] || [];

        	for(var j=0; j<newObjsList.length; j++) {
        	    if(newObjsList[j].triplesContext != null) {
        		triplesContext = triplesContext.concat(newObjsList[j].triplesContext);
        		pairs.push([newVerb, newObjsList[j].chainSubject]);
        	    } else {
        		pairs.push([newVerb, newObjsList[j]])
        	    }
        	}
            }

            tokenParsed.pairs = pairs;
            tokenParsed.triplesContext = triplesContext;

            return tokenParsed;

        },
        peg$c322 = peg$otherExpectation("[68] PropertyList"),
        peg$c323 = peg$otherExpectation("[86] ObjectListPath"),
        peg$c324 = function(obj, objs) {
            var toReturn = [];

            toReturn.push(obj);

            for(var i=0; i<objs.length; i++) {
        	for(var j=0; j<objs[i].length; j++) {
        	    if(typeof(objs[i][j])=="object" && objs[i][j].token != null) {
        		toReturn.push(objs[i][j]);
        	    }
        	}
            }

            return toReturn;
        },
        peg$c325 = peg$otherExpectation("[69] ObjectList"),
        peg$c326 = function(obj, objs) {

            var toReturn = [];

            toReturn.push(obj);

            for(var i=0; i<objs.length; i++) {
        	for(var j=0; j<objs[i].length; j++) {
        	    if(typeof(objs[i][j])=="object" && objs[i][j].token != null) {
        		toReturn.push(objs[i][j]);
        	    }
        	}
            }

            return toReturn;
        },
        peg$c327 = peg$otherExpectation("[87] ObjectPath"),
        peg$c328 = peg$otherExpectation("[70] Object"),
        peg$c329 = peg$otherExpectation("[71] Verb"),
        peg$c330 = "a",
        peg$c331 = peg$literalExpectation("a", false),
        peg$c332 = function() {
            return{token: 'uri', prefix:null, suffix:null, value:"http://www.w3.org/1999/02/22-rdf-syntax-ns#type"}
        },
        peg$c333 = peg$otherExpectation("[72] TriplesSameSubjectPath"),
        peg$c334 = function(s, pairs) {
            var triplesContext = pairs.triplesContext;
            var subject = s;
            if(pairs.pairs) {
        	for(var i=0; i< pairs.pairs.length; i++) {
        	    var pair = pairs.pairs[i];
        	    var triple = null;
        	    if(pair[1].length != null)
        		pair[1] = pair[1][0]
        	    if(subject.token && subject.token==='triplesnodecollection') {
        		triple = {subject: subject.chainSubject[0], predicate: pair[0], object: pair[1]};
        		if(triple.predicate.token === 'path' && triple.predicate.kind === 'element') {
        		    triple.predicate = triple.predicate.value;
        		}
        		triplesContext.push(triple);
        		triplesContext = triplesContext.concat(subject.triplesContext);
        	    } else {
        		triple = {subject: subject, predicate: pair[0], object: pair[1]}
        		if(triple.predicate.token === 'path' && triple.predicate.kind === 'element') {
        		    triple.predicate = triple.predicate.value;
        		}
        		triplesContext.push(triple);
        	    }
        	}
            }

            var tokenParsed = {};
            tokenParsed.token = "triplessamesubject";
            tokenParsed.triplesContext = triplesContext;
            tokenParsed.chainSubject = subject;

            return tokenParsed;
        },
        peg$c335 = function(tn, pairs) {
            var triplesContext = tn.triplesContext;
            var subject = tn.chainSubject;

            if(pairs != null && pairs.pairs != null) {
        	for(var i=0; i< pairs.pairs.length; i++) {
        	    var pair = pairs.pairs[i];
        	    if(pair[1].length != null)
        		pair[1] = pair[1][0]

        	    if(tn.token === "triplesnodecollection") {
        		for(var j=0; j<subject.length; j++) {
        		    var subj = subject[j];
        		    if(subj.triplesContext != null) {
        			var triple = {subject: subj.chainSubject, predicate: pair[0], object: pair[1]}
        			triplesContext.concat(subj.triplesContext);
        		    } else {
        			var triple = {subject: subject[j], predicate: pair[0], object: pair[1]}
        			triplesContext.push(triple);
        		    }
        		}
        	    } else {
        		var triple = {subject: subject, predicate: pair[0], object: pair[1]}
        		triplesContext.push(triple);
        	    }
        	}
            }

            var tokenParsed = {};
            tokenParsed.token = "triplessamesubject";
            tokenParsed.triplesContext = triplesContext;
            tokenParsed.chainSubject = subject;

            return tokenParsed;

        },
        peg$c336 = peg$otherExpectation("[73] PropertyListNotEmptyPath"),
        peg$c337 = function(v, ol, rest) {
            var token = {}
            token.token = 'propertylist';
            var triplesContext = [];
            var pairs = [];
            var test = [];

            for( var i=0; i<ol.length; i++) {

        	if(ol[i].triplesContext != null) {
        	    triplesContext = triplesContext.concat(ol[i].triplesContext);
        	    if(ol[i].token==='triplesnodecollection' && ol[i].chainSubject.length != null) {
        		pairs.push([v, ol[i].chainSubject[0]]);
        	    } else {
        		pairs.push([v, ol[i].chainSubject]);
        	    }

        	} else {
        	    pairs.push([v, ol[i]])
        	}

            }


            for(var i=0; i<rest.length; i++) {
        	var tok = rest[i][3];
        	var newVerb  = tok[0];
        	var newObjsList = tok[1] || [];

        	for(var j=0; j<newObjsList.length; j++) {
        	    if(newObjsList[j].triplesContext != null) {
        		triplesContext = triplesContext.concat(newObjsList[j].triplesContext);
        		pairs.push([newVerb, newObjsList[j].chainSubject]);
        	    } else {
        		pairs.push([newVerb, newObjsList[j]])
        	    }
        	}
            }

            token.pairs = pairs;
            token.triplesContext = triplesContext;

            return token;
        },
        peg$c338 = peg$otherExpectation("[74] PropertyListPath"),
        peg$c339 = peg$otherExpectation("[75]"),
        peg$c340 = function(p) {
            var path = {};
            path.token = 'path';
            path.kind = 'element';
            path.value = p;

            return p;
        },
        peg$c341 = peg$otherExpectation("[76] VerbSimple"),
        peg$c342 = peg$otherExpectation("[77] Path"),
        peg$c343 = peg$otherExpectation("[78] PathAlternative"),
        peg$c344 = "|",
        peg$c345 = peg$literalExpectation("|", false),
        peg$c346 = function(first, rest) {
            if(rest == null || rest.length === 0) {
        	return first;
            } else {
        	var acum = [];
        	for(var i=0; i<rest.length; i++)
        	    acum.push(rest[1]);

        	var path = {};
        	path.token = 'path';
        	path.kind = 'alternative';
        	path.value = acum;

        	return path;
            }
        },
        peg$c347 = peg$otherExpectation("[79] PathSequence"),
        peg$c348 = "/",
        peg$c349 = peg$literalExpectation("/", false),
        peg$c350 = function(first, rest) {
            if(rest == null || rest.length === 0) {
        	return first;
            } else {
        	var acum = [first];

        	for(var i=0; i<rest.length; i++)
        	    acum.push(rest[i][1]);

        	var path = {};
        	path.token = 'path';
        	path.kind = 'sequence';

        	path.value = acum;

        	return path;
            }
        },
        peg$c351 = peg$otherExpectation("[88] PathElt"),
        peg$c352 = function(p, mod) {
            if(p.token && p.token != 'path' && mod == '') {
            return p;
        } else if(p.token && p.token != path && mod != '') {
            var path = {};
            path.token = 'path';
            path.kind = 'element';
            path.value = p;
            path.modifier = mod;
            return path;
        } else {
            p.modifier = mod;
            return p;
        }
        },
        peg$c353 = peg$otherExpectation("[81] PathEltOrInverse"),
        peg$c354 = "^",
        peg$c355 = peg$literalExpectation("^", false),
        peg$c356 = function(elt) {
            var path = {};
            path.token = 'path';
            path.kind = 'inversePath';
            path.value = elt;

            return path;
        },
        peg$c357 = peg$otherExpectation("[82] PathMod"),
        peg$c358 = "?",
        peg$c359 = peg$literalExpectation("?", false),
        peg$c360 = "+",
        peg$c361 = peg$literalExpectation("+", false),
        peg$c362 = peg$otherExpectation("[83] PathPrimary"),
        peg$c363 = "!",
        peg$c364 = peg$literalExpectation("!", false),
        peg$c365 = peg$otherExpectation("[85] PathOneInPropertySet"),
        peg$c366 = peg$otherExpectation("[86] Integer"),
        peg$c367 = peg$otherExpectation("[100] TriplesNodePath"),
        peg$c368 = function(c) {
            var triplesContext = [];
            var chainSubject = [];

            var triple = null;

            // catch NIL
            /*
             if(c.length == 1 && c[0].token && c[0].token === 'nil') {
             GlobalBlankNodeCounter++;
             return  {token: "triplesnodecollection",
             triplesContext:[{subject: {token:'blank', value:("_:"+GlobalBlankNodeCounter)},
             predicate:{token:'uri', prefix:null, suffix:null, value:'http://www.w3.org/1999/02/22-rdf-syntax-ns#rest'},
             object:  {token:'blank', value:("_:"+(GlobalBlankNodeCounter+1))}}],
             chainSubject:{token:'blank', value:("_:"+GlobalBlankNodeCounter)}};

             }
             */

            // other cases
            for(var i=0; i<c.length; i++) {
        	GlobalBlankNodeCounter++;
        	//_:b0  rdf:first  1 ;
        	//rdf:rest   _:b1 .
        	var nextObject = null;
        	if(c[i].chainSubject == null && c[i].triplesContext == null) {
        	    nextObject = c[i];
        	} else {
        	    nextObject = c[i].chainSubject;
        	    triplesContext = triplesContext.concat(c[i].triplesContext);
        	}
        	triple = {
        	    subject: {token:'blank', value:("_:"+GlobalBlankNodeCounter)},
        	    predicate:{token:'uri', prefix:null, suffix:null, value:'http://www.w3.org/1999/02/22-rdf-syntax-ns#first'},
        	    object:nextObject
        	};

        	if(i==0) {
        	    chainSubject.push(triple.subject);
        	}

        	triplesContext.push(triple);

        	if(i===(c.length-1)) {
        	    triple = {subject: {token:'blank', value:("_:"+GlobalBlankNodeCounter)},
        		predicate:{token:'uri', prefix:null, suffix:null, value:'http://www.w3.org/1999/02/22-rdf-syntax-ns#rest'},
        		object:   {token:'uri', prefix:null, suffix:null, value:'http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'}};
        	} else {
        	    triple = {subject: {token:'blank', value:("_:"+GlobalBlankNodeCounter)},
        		predicate:{token:'uri', prefix:null, suffix:null, value:'http://www.w3.org/1999/02/22-rdf-syntax-ns#rest'},
        		object:  {token:'blank', value:("_:"+(GlobalBlankNodeCounter+1))} };
        	}

        	triplesContext.push(triple);
            }

            return {token:"triplesnodecollection", triplesContext:triplesContext, chainSubject:chainSubject};
        },
        peg$c369 = peg$otherExpectation("[87] TriplesNode"),
        peg$c370 = function(c) {
            var triplesContext = [];
            var chainSubject = [];

            var triple = null;

            // catch NIL
            /*
             if(c.length == 1 && c[0].token && c[0].token === 'nil') {
             GlobalBlankNodeCounter++;
             return  {token: "triplesnodecollection",
             triplesContext:[{subject: {token:'blank', value:("_:"+GlobalBlankNodeCounter)},
             predicate:{token:'uri', prefix:null, suffix:null, value:'http://www.w3.org/1999/02/22-rdf-syntax-ns#rest'},
             object:  {token:'blank', value:("_:"+(GlobalBlankNodeCounter+1))}}],
             chainSubject:{token:'blank', value:("_:"+GlobalBlankNodeCounter)}};

             }
             */

            // other cases
            for(var i=0; i<c.length; i++) {
        	GlobalBlankNodeCounter++;
        	//_:b0  rdf:first  1 ;
        	//rdf:rest   _:b1 .
        	var nextObject = null;
        	if(c[i].chainSubject == null && c[i].triplesContext == null) {
        	    nextObject = c[i];
        	} else {
        	    nextObject = c[i].chainSubject;
        	    triplesContext = triplesContext.concat(nextObject.triplesContext);
        	}
        	triple = {subject: {token:'blank', value:("_:"+GlobalBlankNodeCounter)},
        	    predicate:{token:'uri', prefix:null, suffix:null, value:'http://www.w3.org/1999/02/22-rdf-syntax-ns#first'},
        	    object:nextObject };

        	if(i==0) {
        	    chainSubject.push(triple.subject);
        	}

        	triplesContext.push(triple);

        	if(i===(c.length-1)) {
        	    triple = {subject: {token:'blank', value:("_:"+GlobalBlankNodeCounter)},
        		predicate:{token:'uri', prefix:null, suffix:null, value:'http://www.w3.org/1999/02/22-rdf-syntax-ns#rest'},
        		object:   {token:'uri', prefix:null, suffix:null, value:'http://www.w3.org/1999/02/22-rdf-syntax-ns#nil'}};
        	} else {
        	    triple = {subject: {token:'blank', value:("_:"+GlobalBlankNodeCounter)},
        		predicate:{token:'uri', prefix:null, suffix:null, value:'http://www.w3.org/1999/02/22-rdf-syntax-ns#rest'},
        		object:  {token:'blank', value:("_:"+(GlobalBlankNodeCounter+1))} };
        	}

        	triplesContext.push(triple);
            }

            return {token:"triplesnodecollection", triplesContext:triplesContext, chainSubject:chainSubject};
        },
        peg$c371 = peg$otherExpectation("[101] BlankNodePropertyListPath"),
        peg$c372 = "[",
        peg$c373 = peg$literalExpectation("[", false),
        peg$c374 = "]",
        peg$c375 = peg$literalExpectation("]", false),
        peg$c376 = function(pl) {
            GlobalBlankNodeCounter++;
            var subject = {token:'blank', value:'_:'+GlobalBlankNodeCounter};
             var newTriples =  [];

            for(var i=0; i< pl.pairs.length; i++) {
        	var pair = pl.pairs[i];
        	var triple = {}
        	triple.subject = subject;
        	triple.predicate = pair[0];
        	if(pair[1].length != null)
        	    pair[1] = pair[1][0]
        	triple.object = pair[1];
        	newTriples.push(triple);
            }

            return {
        	token: 'triplesnode',
        	kind: 'blanknodepropertylist',
        	triplesContext: pl.triplesContext.concat(newTriples),
        	chainSubject: subject
            };
        },
        peg$c377 = peg$otherExpectation("[88] BlankNodePropertyList"),
        peg$c378 = function(pl) {

            GlobalBlankNodeCounter++;
            var subject = {token:'blank', value:'_:'+GlobalBlankNodeCounter};
            var newTriples =  [];

            for(var i=0; i< pl.pairs.length; i++) {
        	var pair = pl.pairs[i];
        	var triple = {}
        	triple.subject = subject;
        	triple.predicate = pair[0];
        	if(pair[1].length != null)
        	    pair[1] = pair[1][0]
        	triple.object = pair[1];
        	newTriples.push(triple);
            }

            return {
        	token: 'triplesnode',
        	kind: 'blanknodepropertylist',
        	triplesContext: pl.triplesContext.concat(newTriples),
        	chainSubject: subject
            };
        },
        peg$c379 = peg$otherExpectation("[103] CollectionPath"),
        peg$c380 = function(gn) {
            return gn;
        },
        peg$c381 = peg$otherExpectation("[89] Collection"),
        peg$c382 = peg$otherExpectation("[105] GraphNodePath"),
        peg$c383 = function(gn) {
            return gn[1];
        },
        peg$c384 = peg$otherExpectation("[90] GraphNode"),
        peg$c385 = peg$otherExpectation("[91] VarOrTerm"),
        peg$c386 = peg$otherExpectation("[92] VarOrIRIref"),
        peg$c387 = peg$otherExpectation("[93] Var"),
        peg$c388 = function(v) {
            var term = {};
            term.token = 'var';
            term.value = v;
            return term;
        },
        peg$c389 = peg$otherExpectation("[94] GraphTerm"),
        peg$c390 = peg$otherExpectation("[95] Expression"),
        peg$c391 = peg$otherExpectation("[96] ConditionalOrExpression"),
        peg$c392 = "||",
        peg$c393 = peg$literalExpectation("||", false),
        peg$c394 = function(v, vs) {
            if(vs.length === 0) {
        	return v;
            }

            var exp = {};
            exp.token = "expression";
            exp.expressionType = "conditionalor";
            var ops = [v];

            for(var i=0; i<vs.length; i++) {
        	ops.push(vs[i][3]);
            }

            exp.operands = ops;

            return exp;
        },
        peg$c395 = peg$otherExpectation("[97] ConditionalAndExpression"),
        peg$c396 = "&&",
        peg$c397 = peg$literalExpectation("&&", false),
        peg$c398 = function(v, vs) {
            if(vs.length === 0) {
        	return v;
            }
            var exp = {};
            exp.token = "expression";
            exp.expressionType = "conditionaland";
            var ops = [v];

            for(var i=0; i<vs.length; i++) {
        	ops.push(vs[i][3]);
            }

            exp.operands = ops;

            return exp;
        },
        peg$c399 = peg$otherExpectation("[98] ValueLogical"),
        peg$c400 = peg$otherExpectation("[99] RelationalExpression"),
        peg$c401 = "=",
        peg$c402 = peg$literalExpectation("=", false),
        peg$c403 = "!=",
        peg$c404 = peg$literalExpectation("!=", false),
        peg$c405 = "<",
        peg$c406 = peg$literalExpectation("<", false),
        peg$c407 = ">",
        peg$c408 = peg$literalExpectation(">", false),
        peg$c409 = "<=",
        peg$c410 = peg$literalExpectation("<=", false),
        peg$c411 = ">=",
        peg$c412 = peg$literalExpectation(">=", false),
        peg$c413 = "I",
        peg$c414 = peg$literalExpectation("I", false),
        peg$c415 = "i",
        peg$c416 = peg$literalExpectation("i", false),
        peg$c417 = "N",
        peg$c418 = peg$literalExpectation("N", false),
        peg$c419 = "n",
        peg$c420 = peg$literalExpectation("n", false),
        peg$c421 = "O",
        peg$c422 = peg$literalExpectation("O", false),
        peg$c423 = "o",
        peg$c424 = peg$literalExpectation("o", false),
        peg$c425 = "T",
        peg$c426 = peg$literalExpectation("T", false),
        peg$c427 = "t",
        peg$c428 = peg$literalExpectation("t", false),
        peg$c429 = function(op1, op2) {
            if(op2.length === 0) {
        	return op1;
            } else if(op2[0][1] === 'i' || op2[0][1] === 'I' || op2[0][1] === 'n' || op2[0][1] === 'N'){
        	var exp = {};

        	if(op2[0][1] === 'i' || op2[0][1] === 'I') {
        	    var operator = "=";
        	    exp.expressionType = "conditionalor"
        	} else {
        	    var operator = "!=";
        	    exp.expressionType = "conditionaland"
        	}
        	var lop = op1;
        	var rops = []
        	for(var opi=0; opi<op2[0].length; opi++) {
        	    if(op2[0][opi].token ==="args") {
        		rops = op2[0][opi].value;
        		break;
        	    }
        	}

        	exp.token = "expression";
        	exp.operands = [];
        	for(var i=0; i<rops.length; i++) {
        	    var nextOperand = {};
        	    nextOperand.token = "expression";
        	    nextOperand.expressionType = "relationalexpression";
        	    nextOperand.operator = operator;
        	    nextOperand.op1 = lop;
        	    nextOperand.op2 = rops[i];

        	    exp.operands.push(nextOperand);
        	}
        	return exp;
            } else {
        	var exp = {};
        	exp.expressionType = "relationalexpression"
        	exp.operator = op2[0][1];
        	exp.op1 = op1;
        	exp.op2 = op2[0][3];
        	exp.token = "expression";

        	return exp;
            }
        },
        peg$c430 = peg$otherExpectation("[100] NumericExpression"),
        peg$c431 = peg$otherExpectation("[101] AdditiveExpression"),
        peg$c432 = "-",
        peg$c433 = peg$literalExpectation("-", false),
        peg$c434 = function(op1, ops) {
            if(ops.length === 0) {
        	return op1;
            }

            var ex = {};
            ex.token = 'expression';
            ex.expressionType = 'additiveexpression';
            ex.summand = op1;
            ex.summands = [];

            for(var i=0; i<ops.length; i++) {
        	var summand = ops[i];
        	var sum = {};
        	if(summand.length == 4 && typeof(summand[1]) === "string") {
        	    sum.operator = summand[1];
        	    sum.expression = summand[3];
        	} else {
        	    var subexp = {}
        	    var firstFactor = sum[0];
        	    var operator = sum[1][1];
        	    var secondFactor = sum[1][3];
        	    var operator = null;
        	    if(firstFactor.value < 0) {
        		sum.operator = '-';
        		firstFactor.value = - firstFactor.value;
        	    } else {
        		sum.operator = '+';
        	    }
        	    subexp.token = 'expression';
        	    subexp.expressionType = 'multiplicativeexpression';
        	    subexp.operator = firstFactor;
        	    subexp.factors = [{operator: operator, expression: secondFactor}];

        	    sum.expression = subexp;
        	}
        	ex.summands.push(sum);
            }

            return ex;
        },
        peg$c435 = peg$otherExpectation("[102] MultiplicativeExpression"),
        peg$c436 = function(exp, exps) {
            if(exps.length === 0) {
        	return exp;
            }

            var ex = {};
            ex.token = 'expression';
            ex.expressionType = 'multiplicativeexpression';
            ex.factor = exp;
            ex.factors = [];
            for(var i=0; i<exps.length; i++) {
        	var factor = exps[i];
        	var fact = {};
        	fact.operator = factor[1];
        	fact.expression = factor[3];
        	ex.factors.push(fact);
            }

            return ex;
        },
        peg$c437 = peg$otherExpectation("[103] UnaryExpression"),
        peg$c438 = function(e) {
            var ex = {};
            ex.token = 'expression';
            ex.expressionType = 'unaryexpression';
            ex.unaryexpression = "!";
            ex.expression = e;

            return ex;
        },
        peg$c439 = function(v) {
            var ex = {};
            ex.token = 'expression';
            ex.expressionType = 'unaryexpression';
            ex.unaryexpression = "+";
            ex.expression = v;

            return ex;
        },
        peg$c440 = function(v) {
            var ex = {};
            ex.token = 'expression';
            ex.expressionType = 'unaryexpression';
            ex.unaryexpression = "-";
            ex.expression = v;

            return ex;
        },
        peg$c441 = peg$otherExpectation("[104] PrimaryExpression"),
        peg$c442 = function(v) {
            var ex = {};
            ex.token = 'expression';
            ex.expressionType = 'atomic';
            ex.primaryexpression = 'rdfliteral';
            ex.value = v;

            return ex;
        },
        peg$c443 = function(v) {
            var ex = {};
            ex.token = 'expression';
            ex.expressionType = 'atomic';
            ex.primaryexpression = 'numericliteral';
            ex.value = v;

            return ex;
        },
        peg$c444 = function(v) {
            var ex = {};
            ex.token = 'expression';
            ex.expressionType = 'atomic';
            ex.primaryexpression = 'booleanliteral';
            ex.value = v;

            return ex;
        },
        peg$c445 = function(v) {
            var ex = {};
            ex.token = 'expression';
            ex.expressionType = 'atomic';
            ex.primaryexpression = 'var';
            ex.value = v;

            return ex;
        },
        peg$c446 = peg$otherExpectation("[105] BrackettedExpression"),
        peg$c447 = function(e) {
            return e;
        },
        peg$c448 = peg$otherExpectation("[106] BuiltInCall"),
        peg$c449 = "STR",
        peg$c450 = peg$literalExpectation("STR", false),
        peg$c451 = "str",
        peg$c452 = peg$literalExpectation("str", false),
        peg$c453 = function(e) {
            var ex = {};
            ex.token = 'expression'
            ex.expressionType = 'builtincall'
            ex.builtincall = 'str'
            ex.args = [e]

            return ex;
        },
        peg$c454 = "LANG",
        peg$c455 = peg$literalExpectation("LANG", false),
        peg$c456 = "lang",
        peg$c457 = peg$literalExpectation("lang", false),
        peg$c458 = function(e) {
            var ex = {};
            ex.token = 'expression'
            ex.expressionType = 'builtincall'
            ex.builtincall = 'lang'
            ex.args = [e]

            return ex;
        },
        peg$c459 = "LANGMATCHES",
        peg$c460 = peg$literalExpectation("LANGMATCHES", false),
        peg$c461 = "langmatches",
        peg$c462 = peg$literalExpectation("langmatches", false),
        peg$c463 = function(e1, e2) {
            var ex = {};
            ex.token = 'expression'
            ex.expressionType = 'builtincall'
            ex.builtincall = 'langmatches'
            ex.args = [e1,e2]

            return ex;
        },
        peg$c464 = "DATATYPE",
        peg$c465 = peg$literalExpectation("DATATYPE", false),
        peg$c466 = "datatype",
        peg$c467 = peg$literalExpectation("datatype", false),
        peg$c468 = function(e) {
            var ex = {};
            ex.token = 'expression'
            ex.expressionType = 'builtincall'
            ex.builtincall = 'datatype'
            ex.args = [e]

            return ex;
        },
        peg$c469 = "BOUND",
        peg$c470 = peg$literalExpectation("BOUND", false),
        peg$c471 = "bound",
        peg$c472 = peg$literalExpectation("bound", false),
        peg$c473 = function(v) {
            var ex = {};
            ex.token = 'expression'
            ex.expressionType = 'builtincall'
            ex.builtincall = 'bound'
            ex.args = [v]

            return ex;
        },
        peg$c474 = "IRI",
        peg$c475 = peg$literalExpectation("IRI", false),
        peg$c476 = "iri",
        peg$c477 = peg$literalExpectation("iri", false),
        peg$c478 = function(e) {
            var ex = {};
            ex.token = 'expression';
            ex.expressionType = 'builtincall';
            ex.builtincall = 'iri'
            ex.args = [e];

            return ex;
        },
        peg$c479 = "URI",
        peg$c480 = peg$literalExpectation("URI", false),
        peg$c481 = "uri",
        peg$c482 = peg$literalExpectation("uri", false),
        peg$c483 = function(e) {
            var ex = {};
            ex.token = 'expression';
            ex.expressionType = 'builtincall';
            ex.builtincall = 'uri'
            ex.args = [e];

            return ex;
        },
        peg$c484 = "BNODE",
        peg$c485 = peg$literalExpectation("BNODE", false),
        peg$c486 = "bnode",
        peg$c487 = peg$literalExpectation("bnode", false),
        peg$c488 = function(arg) {
            var ex = {};
            ex.token = 'expression';
            ex.expressionType = 'builtincall';
            ex.builtincall = 'bnode';
            if(arg.length === 5) {
        	ex.args = [arg[2]];
            } else {
        	ex.args = null;
            }

            return ex;
        },
        peg$c489 = "COALESCE",
        peg$c490 = peg$literalExpectation("COALESCE", false),
        peg$c491 = "coalesce",
        peg$c492 = peg$literalExpectation("coalesce", false),
        peg$c493 = function(args) {
            var ex = {};
            ex.token = 'expression';
            ex.expressionType = 'builtincall';
            ex.builtincall = 'coalesce';
            ex.args = args;

            return ex;
        },
        peg$c494 = "IF",
        peg$c495 = peg$literalExpectation("IF", false),
        peg$c496 = "if",
        peg$c497 = peg$literalExpectation("if", false),
        peg$c498 = function(test, trueCond, falseCond) {
            var ex = {};
            ex.token = 'expression';
            ex.expressionType = 'builtincall';
            ex.builtincall = 'if';
            ex.args = [test,trueCond,falseCond];

            return ex;
        },
        peg$c499 = "ISLITERAL",
        peg$c500 = peg$literalExpectation("ISLITERAL", false),
        peg$c501 = "isliteral",
        peg$c502 = peg$literalExpectation("isliteral", false),
        peg$c503 = "isLITERAL",
        peg$c504 = peg$literalExpectation("isLITERAL", false),
        peg$c505 = function(arg) {
            var ex = {};
            ex.token = 'expression';
            ex.expressionType = 'builtincall';
            ex.builtincall = 'isliteral';
            ex.args = [arg];

            return ex;
        },
        peg$c506 = "ISBLANK",
        peg$c507 = peg$literalExpectation("ISBLANK", false),
        peg$c508 = "isblank",
        peg$c509 = peg$literalExpectation("isblank", false),
        peg$c510 = "isBLANK",
        peg$c511 = peg$literalExpectation("isBLANK", false),
        peg$c512 = function(arg) {
            var ex = {};
            ex.token = 'expression';
            ex.expressionType = 'builtincall';
            ex.builtincall = 'isblank';
            ex.args = [arg];

            return ex;
        },
        peg$c513 = "SAMETERM",
        peg$c514 = peg$literalExpectation("SAMETERM", false),
        peg$c515 = "sameterm",
        peg$c516 = peg$literalExpectation("sameterm", false),
        peg$c517 = function(e1, e2) {
            var ex = {};
            ex.token = 'expression';
            ex.expressionType = 'builtincall';
            ex.builtincall = 'sameterm';
            ex.args = [e1, e2];
            return ex;
        },
        peg$c518 = "ISURI",
        peg$c519 = peg$literalExpectation("ISURI", false),
        peg$c520 = "isuri",
        peg$c521 = peg$literalExpectation("isuri", false),
        peg$c522 = "isURI",
        peg$c523 = peg$literalExpectation("isURI", false),
        peg$c524 = "ISIRI",
        peg$c525 = peg$literalExpectation("ISIRI", false),
        peg$c526 = "isiri",
        peg$c527 = peg$literalExpectation("isiri", false),
        peg$c528 = "isIRI",
        peg$c529 = peg$literalExpectation("isIRI", false),
        peg$c530 = function(arg) {
            var ex = {};
            ex.token = 'expression';
            ex.expressionType = 'builtincall';
            ex.builtincall = 'isuri';
            ex.args = [arg];

            return ex;
        },
        peg$c531 = "custom:",
        peg$c532 = peg$literalExpectation("custom:", false),
        peg$c533 = "CUSTOM:",
        peg$c534 = peg$literalExpectation("CUSTOM:", false),
        peg$c535 = /^[a-zA-Z0-9_]/,
        peg$c536 = peg$classExpectation([["a", "z"], ["A", "Z"], ["0", "9"], "_"], false, false),
        peg$c537 = function(fnname, alter, finalarg) {
            var ex = {};
            ex.token = 'expression';
            ex.expressionType = 'custom';
            ex.name = fnname.join('');
            var acum = [];
            for(var i=0; i<alter.length; i++)
        	acum.push(alter[i][1]);
            acum.push(finalarg);
            ex.args = acum;

            return ex;
        },
        peg$c538 = peg$otherExpectation("[107] RegexExpression"),
        peg$c539 = "REGEX",
        peg$c540 = peg$literalExpectation("REGEX", false),
        peg$c541 = "regex",
        peg$c542 = peg$literalExpectation("regex", false),
        peg$c543 = function(e1, e2, eo) {
            var regex = {};
        regex.token = 'expression';
        regex.expressionType = 'regex';
        regex.text = e1;
        regex.pattern = e2;
        if(eo != null) {
          regex.flags = eo[2];
        }

        return regex;
        },
        peg$c544 = peg$otherExpectation("[108] ExistsFunc"),
        peg$c545 = "EXISTS",
        peg$c546 = peg$literalExpectation("EXISTS", false),
        peg$c547 = "exists",
        peg$c548 = peg$literalExpectation("exists", false),
        peg$c549 = function(ggp) {
            var ex = {};
            ex.token = 'expression';
            ex.expressionType = 'builtincall';
            ex.builtincall = 'exists';
            ex.args = [ggp];

            return ex;
        },
        peg$c550 = peg$otherExpectation("[109] NotExistsFunc"),
        peg$c551 = "NOT",
        peg$c552 = peg$literalExpectation("NOT", false),
        peg$c553 = "not",
        peg$c554 = peg$literalExpectation("not", false),
        peg$c555 = function(ggp) {
            var ex = {};
            ex.token = 'expression';
            ex.expressionType = 'builtincall';
            ex.builtincall = 'notexists';
            ex.args = [ggp];

            return ex;
        },
        peg$c556 = peg$otherExpectation("[110] Aggregate"),
        peg$c557 = "COUNT",
        peg$c558 = peg$literalExpectation("COUNT", false),
        peg$c559 = "count",
        peg$c560 = peg$literalExpectation("count", false),
        peg$c561 = function(d, e) {
            var exp = {};
        exp.token = 'expression';
        exp.expressionType = 'aggregate';
        exp.aggregateType = 'count';
        exp.distinct = ((d != "" && d != null) ? 'DISTINCT' : d);
        exp.expression = e;

        return exp;

        },
        peg$c562 = "GROUP_CONCAT",
        peg$c563 = peg$literalExpectation("GROUP_CONCAT", false),
        peg$c564 = "group_concat",
        peg$c565 = peg$literalExpectation("group_concat", false),
        peg$c566 = "SEPARATOR",
        peg$c567 = peg$literalExpectation("SEPARATOR", false),
        peg$c568 = function(d, e, s) {
            var exp = {};
            exp.token = 'expression';
            exp.expressionType = 'aggregate';
            exp.aggregateType = 'group_concat';
            exp.distinct = ((d != "" && d != null) ? 'DISTINCT' : d);
            exp.expression = e;
            exp.separator = s;

            return exp;

        },
        peg$c569 = "SUM",
        peg$c570 = peg$literalExpectation("SUM", false),
        peg$c571 = "sum",
        peg$c572 = peg$literalExpectation("sum", false),
        peg$c573 = function(d, e) {
            var exp = {};
        exp.token = 'expression';
        exp.expressionType = 'aggregate';
        exp.aggregateType = 'sum';
        exp.distinct = ((d != "" && d != null) ? 'DISTINCT' : d);
        exp.expression = e;

        return exp;

        },
        peg$c574 = "MIN",
        peg$c575 = peg$literalExpectation("MIN", false),
        peg$c576 = "min",
        peg$c577 = peg$literalExpectation("min", false),
        peg$c578 = function(d, e) {
            var exp = {};
        exp.token = 'expression';
        exp.expressionType = 'aggregate';
        exp.aggregateType = 'min';
        exp.distinct = ((d != "" && d != null) ? 'DISTINCT' : d);
        exp.expression = e;

        return exp;

        },
        peg$c579 = "MAX",
        peg$c580 = peg$literalExpectation("MAX", false),
        peg$c581 = "max",
        peg$c582 = peg$literalExpectation("max", false),
        peg$c583 = function(d, e) {
            var exp = {};
        exp.token = 'expression'
        exp.expressionType = 'aggregate'
        exp.aggregateType = 'max'
        exp.distinct = ((d != "" && d != null) ? 'DISTINCT' : d);
        exp.expression = e

        return exp

        },
        peg$c584 = "AVG",
        peg$c585 = peg$literalExpectation("AVG", false),
        peg$c586 = "avg",
        peg$c587 = peg$literalExpectation("avg", false),
        peg$c588 = function(d, e) {
            var exp = {};
        exp.token = 'expression'
        exp.expressionType = 'aggregate'
        exp.aggregateType = 'avg'
        exp.distinct = ((d != "" && d != null) ? 'DISTINCT' : d);
        exp.expression = e

        return exp

        },
        peg$c589 = peg$otherExpectation("[117] IRIrefOrFunction"),
        peg$c590 = function(i, args) {
            var fcall = {};
        fcall.token = "expression";
        fcall.expressionType = 'irireforfunction';
        fcall.iriref = i;
        fcall.args = (args != null ? args.value : args);

        return fcall;
        },
        peg$c591 = peg$otherExpectation("[112] RDFLiteral"),
        peg$c592 = "^^",
        peg$c593 = peg$literalExpectation("^^", false),
        peg$c594 = function(s, e) {
            if(typeof(e) === "string" && e.length > 0) {
            return {token:'literal', value:s.value, lang:e.slice(1), type:null}
        } else {
            if(e != null && typeof(e) === "object") {
        	e.shift(); // remove the '^^' char
        	return {token:'literal', value:s.value, lang:null, type:e[0] }
            } else {
        	return { token:'literal', value:s.value, lang:null, type:null }
            }
        }
        },
        peg$c595 = peg$otherExpectation("[113] NumericLiteral"),
        peg$c596 = peg$otherExpectation("[114] NumericLiteralUnsigned"),
        peg$c597 = peg$otherExpectation("[115] NumericLiteralPositive"),
        peg$c598 = peg$otherExpectation("[116] NumericLiteralNegative"),
        peg$c599 = peg$otherExpectation("[117] BooleanLiteral"),
        peg$c600 = "TRUE",
        peg$c601 = peg$literalExpectation("TRUE", false),
        peg$c602 = "true",
        peg$c603 = peg$literalExpectation("true", false),
        peg$c604 = function() {
            var lit = {};
            lit.token = "literal";
            lit.lang = null;
            lit.type = "http://www.w3.org/2001/XMLSchema#boolean";
            lit.value = true;
            return lit;
        },
        peg$c605 = "FALSE",
        peg$c606 = peg$literalExpectation("FALSE", false),
        peg$c607 = "false",
        peg$c608 = peg$literalExpectation("false", false),
        peg$c609 = function() {
            var lit = {};
            lit.token = "literal";
            lit.lang = null;
            lit.type = "http://www.w3.org/2001/XMLSchema#boolean";
            lit.value = false;
            return lit;
        },
        peg$c610 = peg$otherExpectation("[118] String"),
        peg$c611 = function(s) { return {token:'string', value:s} },
        peg$c612 = peg$otherExpectation("[119] IRIref"),
        peg$c613 = function(iri) { return {token: 'uri', prefix:null, suffix:null, value:iri} },
        peg$c614 = function(p) { return p },
        peg$c615 = peg$otherExpectation("[120] PrefixedName"),
        peg$c616 = function(p) { return {token: 'uri', prefix:p[0], suffix:p[1], value:null } },
        peg$c617 = function(p) { return {token: 'uri', prefix:p, suffix:'', value:null } },
        peg$c618 = peg$otherExpectation("[121] BlankNode"),
        peg$c619 = function(l) { return {token:'blank', value:l}},
        peg$c620 = function() { GlobalBlankNodeCounter++; return {token:'blank', value:'_:'+GlobalBlankNodeCounter} },
        peg$c621 = peg$otherExpectation("[122] IRI_REF"),
        peg$c622 = /^[^<>"{}|\^`\\]/,
        peg$c623 = peg$classExpectation(["<", ">", "\"", "{", "}", "|", "^", "`", "\\"], true, false),
        peg$c624 = function(iri_ref) { return iri_ref.join('') },
        peg$c625 = peg$otherExpectation("[123] PNAME_NS"),
        peg$c626 = ":",
        peg$c627 = peg$literalExpectation(":", false),
        peg$c628 = peg$otherExpectation("[124] PNAME_LN"),
        peg$c629 = function(p, s) { return [p, s] },
        peg$c630 = peg$otherExpectation("[125] BLANK_NODE_LABEL"),
        peg$c631 = "_:",
        peg$c632 = peg$literalExpectation("_:", false),
        peg$c633 = function(l) { return l },
        peg$c634 = peg$otherExpectation("[126] VAR1"),
        peg$c635 = function(v) { return v },
        peg$c636 = peg$otherExpectation("[127] VAR2"),
        peg$c637 = "$",
        peg$c638 = peg$literalExpectation("$", false),
        peg$c639 = peg$otherExpectation("[128] LANGTAG"),
        peg$c640 = "@",
        peg$c641 = peg$literalExpectation("@", false),
        peg$c642 = /^[a-zA-Z]/,
        peg$c643 = peg$classExpectation([["a", "z"], ["A", "Z"]], false, false),
        peg$c644 = /^[a-zA-Z0-9]/,
        peg$c645 = peg$classExpectation([["a", "z"], ["A", "Z"], ["0", "9"]], false, false),
        peg$c646 = function(a, b) {

            if(b.length===0) {
            return ("@"+a.join('')).toLowerCase();
            } else {
            return ("@"+a.join('')+"-"+b[0][1].join('')).toLowerCase();
            }
            },
        peg$c647 = peg$otherExpectation("[129] INTEGER"),
        peg$c648 = /^[0-9]/,
        peg$c649 = peg$classExpectation([["0", "9"]], false, false),
        peg$c650 = function(d) {
            var lit = {};
            lit.token = "literal";
            lit.lang = null;
            lit.type = "http://www.w3.org/2001/XMLSchema#integer";
            lit.value = flattenString(d);
            return lit;
            },
        peg$c651 = peg$otherExpectation("[130] DECIMAL"),
        peg$c652 = function(a, b, c) {

            var lit = {};
            lit.token = "literal";
            lit.lang = null;
            lit.type = "http://www.w3.org/2001/XMLSchema#decimal";
            lit.value = flattenString([a,b,c]);
            return lit;
            },
        peg$c653 = function(a, b) {
            var lit = {};
            lit.token = "literal";
            lit.lang = null;
            lit.type = "http://www.w3.org/2001/XMLSchema#decimal";
            lit.value = flattenString([a,b]);
            return lit;
            },
        peg$c654 = peg$otherExpectation("[131] DOUBLE"),
        peg$c655 = function(a, b, c, e) {
            var lit = {};
            lit.token = "literal";
            lit.lang = null;
            lit.type = "http://www.w3.org/2001/XMLSchema#double";
            lit.value = flattenString([a,b,c,e]);
            return lit;
            },
        peg$c656 = function(a, b, c) {
            var lit = {};
            lit.token = "literal";
            lit.lang = null;
            lit.type = "http://www.w3.org/2001/XMLSchema#double";
            lit.value = flattenString([a,b,c]);
            return lit;
            },
        peg$c657 = function(a, b) {
            var lit = {};
            lit.token = "literal";
            lit.lang = null;
            lit.type = "http://www.w3.org/2001/XMLSchema#double";
            lit.value = flattenString([a,b]);
            return lit;
            },
        peg$c658 = peg$otherExpectation("[132] INTEGER_POSITIVE"),
        peg$c659 = function(d) { d.value = "+"+d.value; return d; },
        peg$c660 = peg$otherExpectation("[133] DECIMAL_POSITIVE"),
        peg$c661 = function(d) { d.value = "+"+d.value; return d },
        peg$c662 = peg$otherExpectation("[134] DOUBLE_POSITIVE"),
        peg$c663 = peg$otherExpectation("[135] INTEGER_NEGATIVE"),
        peg$c664 = function(d) { d.value = "-"+d.value; return d; },
        peg$c665 = peg$otherExpectation("[136] DECIMAL_NEGATIVE"),
        peg$c666 = peg$otherExpectation("[137] DOUBLE_NEGATIVE"),
        peg$c667 = peg$otherExpectation("[138] EXPONENT"),
        peg$c668 = /^[eE]/,
        peg$c669 = peg$classExpectation(["e", "E"], false, false),
        peg$c670 = /^[+\-]/,
        peg$c671 = peg$classExpectation(["+", "-"], false, false),
        peg$c672 = function(a, b, c) { return flattenString([a,b,c]) },
        peg$c673 = peg$otherExpectation("[139] STRING_LITERAL1"),
        peg$c674 = "'",
        peg$c675 = peg$literalExpectation("'", false),
        peg$c676 = /^[^'\\\n\r]/,
        peg$c677 = peg$classExpectation(["'", "\\", "\n", "\r"], true, false),
        peg$c678 = function(content) { return flattenString(content) },
        peg$c679 = peg$otherExpectation("[140] STRING_LITERAL2"),
        peg$c680 = "\"",
        peg$c681 = peg$literalExpectation("\"", false),
        peg$c682 = /^[^"\\\n\r]/,
        peg$c683 = peg$classExpectation(["\"", "\\", "\n", "\r"], true, false),
        peg$c684 = peg$otherExpectation("[141] STRING_LITERAL_LONG1"),
        peg$c685 = "'''",
        peg$c686 = peg$literalExpectation("'''", false),
        peg$c687 = /^[^'\\]/,
        peg$c688 = peg$classExpectation(["'", "\\"], true, false),
        peg$c689 = peg$otherExpectation("[142] STRING_LITERAL_LONG2"),
        peg$c690 = "\"\"\"",
        peg$c691 = peg$literalExpectation("\"\"\"", false),
        peg$c692 = /^[^"\\]/,
        peg$c693 = peg$classExpectation(["\"", "\\"], true, false),
        peg$c694 = peg$otherExpectation("[143] ECHAR"),
        peg$c695 = "\\",
        peg$c696 = peg$literalExpectation("\\", false),
        peg$c697 = /^[tbnrf"']/,
        peg$c698 = peg$classExpectation(["t", "b", "n", "r", "f", "\"", "'"], false, false),
        peg$c699 = peg$otherExpectation("[144] NIL"),
        peg$c700 = function() {

            return  {token: "triplesnodecollection",
            triplesContext:[],
            chainSubject:[{token:'uri', value:"http://www.w3.org/1999/02/22-rdf-syntax-ns#nil"}]};
            },
        peg$c701 = peg$otherExpectation("[145] WS"),
        peg$c702 = /^[ ]/,
        peg$c703 = peg$classExpectation([" "], false, false),
        peg$c704 = /^[\t]/,
        peg$c705 = peg$classExpectation(["\t"], false, false),
        peg$c706 = /^[\r]/,
        peg$c707 = peg$classExpectation(["\r"], false, false),
        peg$c708 = /^[\n]/,
        peg$c709 = peg$classExpectation(["\n"], false, false),
        peg$c710 = peg$otherExpectation(" COMMENT"),
        peg$c711 = "#",
        peg$c712 = peg$literalExpectation("#", false),
        peg$c713 = /^[^\n\r]/,
        peg$c714 = peg$classExpectation(["\n", "\r"], true, false),
        peg$c715 = peg$otherExpectation("[146] ANON"),
        peg$c716 = peg$otherExpectation("[147] PN_CHARS_BASE"),
        peg$c717 = /^[A-Z]/,
        peg$c718 = peg$classExpectation([["A", "Z"]], false, false),
        peg$c719 = /^[a-z]/,
        peg$c720 = peg$classExpectation([["a", "z"]], false, false),
        peg$c721 = /^[\xC0-\xD6]/,
        peg$c722 = peg$classExpectation([["\xC0", "\xD6"]], false, false),
        peg$c723 = /^[\xD8-\xF6]/,
        peg$c724 = peg$classExpectation([["\xD8", "\xF6"]], false, false),
        peg$c725 = /^[\xF8-\u02FF]/,
        peg$c726 = peg$classExpectation([["\xF8", "\u02FF"]], false, false),
        peg$c727 = /^[\u0370-\u037D]/,
        peg$c728 = peg$classExpectation([["\u0370", "\u037D"]], false, false),
        peg$c729 = /^[\u037F-\u1FFF]/,
        peg$c730 = peg$classExpectation([["\u037F", "\u1FFF"]], false, false),
        peg$c731 = /^[\u200C-\u200D]/,
        peg$c732 = peg$classExpectation([["\u200C", "\u200D"]], false, false),
        peg$c733 = /^[\u2070-\u218F]/,
        peg$c734 = peg$classExpectation([["\u2070", "\u218F"]], false, false),
        peg$c735 = /^[\u2C00-\u2FEF]/,
        peg$c736 = peg$classExpectation([["\u2C00", "\u2FEF"]], false, false),
        peg$c737 = /^[\u3001-\uD7FF]/,
        peg$c738 = peg$classExpectation([["\u3001", "\uD7FF"]], false, false),
        peg$c739 = /^[\uF900-\uFDCF]/,
        peg$c740 = peg$classExpectation([["\uF900", "\uFDCF"]], false, false),
        peg$c741 = /^[\uFDF0-\uFFFD]/,
        peg$c742 = peg$classExpectation([["\uFDF0", "\uFFFD"]], false, false),
        peg$c743 = /^[\u1000-\uEFFF]/,
        peg$c744 = peg$classExpectation([["\u1000", "\uEFFF"]], false, false),
        peg$c745 = peg$otherExpectation("[148] PN_CHARS_U"),
        peg$c746 = "_",
        peg$c747 = peg$literalExpectation("_", false),
        peg$c748 = peg$otherExpectation("[149] VARNAME"),
        peg$c749 = /^[\xB7]/,
        peg$c750 = peg$classExpectation(["\xB7"], false, false),
        peg$c751 = /^[\u0300-\u036F]/,
        peg$c752 = peg$classExpectation([["\u0300", "\u036F"]], false, false),
        peg$c753 = /^[\u203F-\u2040]/,
        peg$c754 = peg$classExpectation([["\u203F", "\u2040"]], false, false),
        peg$c755 = function(init, rpart) { return init+rpart.join('') },
        peg$c756 = peg$otherExpectation("[150] PN_CHARS"),
        peg$c757 = peg$otherExpectation("[151] PN_PREFIX"),
        peg$c758 = function(base, rest) { if(rest[rest.length-1] == '.'){
            throw new Error("Wrong PN_PREFIX, cannot finish with '.'")
            } else {
            return base + rest.join('');
            }},
        peg$c759 = peg$otherExpectation("[152] PN_LOCAL"),
        peg$c760 = function(base, rest) {
          return base + (rest||[]).join('');
        },
        peg$c761 = peg$otherExpectation("[170] PLX"),
        peg$c762 = peg$otherExpectation("[171] PERCENT"),
        peg$c763 = "%",
        peg$c764 = peg$literalExpectation("%", false),
        peg$c765 = function(h) {
          return h.join("");
        },
        peg$c766 = peg$otherExpectation("[172] HEX"),
        peg$c767 = /^[A-F]/,
        peg$c768 = peg$classExpectation([["A", "F"]], false, false),
        peg$c769 = /^[a-f]/,
        peg$c770 = peg$classExpectation([["a", "f"]], false, false),
        peg$c771 = peg$otherExpectation("[173] PN_LOCAL_ESC"),
        peg$c772 = "~",
        peg$c773 = peg$literalExpectation("~", false),
        peg$c774 = "&",
        peg$c775 = peg$literalExpectation("&", false),
        peg$c776 = function(c) {
           return "\\"+c;
        },

        peg$currPos          = 0,
        peg$savedPos         = 0,
        peg$posDetailsCache  = [{ line: 1, column: 1 }],
        peg$maxFailPos       = 0,
        peg$maxFailExpected  = [],
        peg$silentFails      = 0,

        peg$result;

    if ("startRule" in options) {
      if (!(options.startRule in peg$startRuleFunctions)) {
        throw new Error("Can't start parsing from rule \"" + options.startRule + "\".");
      }

      peg$startRuleFunction = peg$startRuleFunctions[options.startRule];
    }

    function text() {
      return input.substring(peg$savedPos, peg$currPos);
    }

    function location() {
      return peg$computeLocation(peg$savedPos, peg$currPos);
    }

    function expected(description, location) {
      location = location !== void 0 ? location : peg$computeLocation(peg$savedPos, peg$currPos)

      throw peg$buildStructuredError(
        [peg$otherExpectation(description)],
        input.substring(peg$savedPos, peg$currPos),
        location
      );
    }

    function error(message, location) {
      location = location !== void 0 ? location : peg$computeLocation(peg$savedPos, peg$currPos)

      throw peg$buildSimpleError(message, location);
    }

    function peg$literalExpectation(text, ignoreCase) {
      return { type: "literal", text: text, ignoreCase: ignoreCase };
    }

    function peg$classExpectation(parts, inverted, ignoreCase) {
      return { type: "class", parts: parts, inverted: inverted, ignoreCase: ignoreCase };
    }

    function peg$anyExpectation() {
      return { type: "any" };
    }

    function peg$endExpectation() {
      return { type: "end" };
    }

    function peg$otherExpectation(description) {
      return { type: "other", description: description };
    }

    function peg$computePosDetails(pos) {
      var details = peg$posDetailsCache[pos], p;

      if (details) {
        return details;
      } else {
        p = pos - 1;
        while (!peg$posDetailsCache[p]) {
          p--;
        }

        details = peg$posDetailsCache[p];
        details = {
          line:   details.line,
          column: details.column
        };

        while (p < pos) {
          if (input.charCodeAt(p) === 10) {
            details.line++;
            details.column = 1;
          } else {
            details.column++;
          }

          p++;
        }

        peg$posDetailsCache[pos] = details;
        return details;
      }
    }

    function peg$computeLocation(startPos, endPos) {
      var startPosDetails = peg$computePosDetails(startPos),
          endPosDetails   = peg$computePosDetails(endPos);

      return {
        start: {
          offset: startPos,
          line:   startPosDetails.line,
          column: startPosDetails.column
        },
        end: {
          offset: endPos,
          line:   endPosDetails.line,
          column: endPosDetails.column
        }
      };
    }

    function peg$fail(expected) {
      if (peg$currPos < peg$maxFailPos) { return; }

      if (peg$currPos > peg$maxFailPos) {
        peg$maxFailPos = peg$currPos;
        peg$maxFailExpected = [];
      }

      peg$maxFailExpected.push(expected);
    }

    function peg$buildSimpleError(message, location) {
      return new peg$SyntaxError(message, null, null, location);
    }

    function peg$buildStructuredError(expected, found, location) {
      return new peg$SyntaxError(
        peg$SyntaxError.buildMessage(expected, found),
        expected,
        found,
        location
      );
    }

    function peg$parseDOCUMENT() {
      var s0;

      s0 = peg$parseSPARQL();

      return s0;
    }

    function peg$parseSPARQL() {
      var s0;

      s0 = peg$parseQueryUnit();
      if (s0 === peg$FAILED) {
        s0 = peg$parseUpdateUnit();
      }

      return s0;
    }

    function peg$parseQueryUnit() {
      var s0, s1;

      peg$silentFails++;
      s0 = peg$parseQuery();
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c0); }
      }

      return s0;
    }

    function peg$parseQuery() {
      var s0, s1, s2, s3;

      peg$silentFails++;
      s0 = peg$currPos;
      s1 = peg$parsePrologue();
      if (s1 !== peg$FAILED) {
        s2 = peg$parseSelectQuery();
        if (s2 === peg$FAILED) {
          s2 = peg$parseConstructQuery();
          if (s2 === peg$FAILED) {
            s2 = peg$parseDescribeQuery();
            if (s2 === peg$FAILED) {
              s2 = peg$parseAskQuery();
            }
          }
        }
        if (s2 !== peg$FAILED) {
          s3 = peg$parseValuesClause();
          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c2(s1, s2, s3);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c1); }
      }

      return s0;
    }

    function peg$parsePrologue() {
      var s0, s1, s2, s3, s4;

      peg$silentFails++;
      s0 = peg$currPos;
      s1 = peg$parseBaseDecl();
      if (s1 === peg$FAILED) {
        s1 = null;
      }
      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$parseWS();
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parseWS();
        }
        if (s2 !== peg$FAILED) {
          s3 = [];
          s4 = peg$parsePrefixDecl();
          while (s4 !== peg$FAILED) {
            s3.push(s4);
            s4 = peg$parsePrefixDecl();
          }
          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c4(s1, s3);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c3); }
      }

      return s0;
    }

    function peg$parseBaseDecl() {
      var s0, s1, s2, s3, s4;

      peg$silentFails++;
      s0 = peg$currPos;
      s1 = [];
      s2 = peg$parseWS();
      while (s2 !== peg$FAILED) {
        s1.push(s2);
        s2 = peg$parseWS();
      }
      if (s1 !== peg$FAILED) {
        if (input.substr(peg$currPos, 4) === peg$c6) {
          s2 = peg$c6;
          peg$currPos += 4;
        } else {
          s2 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c7); }
        }
        if (s2 === peg$FAILED) {
          if (input.substr(peg$currPos, 4) === peg$c8) {
            s2 = peg$c8;
            peg$currPos += 4;
          } else {
            s2 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c9); }
          }
        }
        if (s2 !== peg$FAILED) {
          s3 = [];
          s4 = peg$parseWS();
          while (s4 !== peg$FAILED) {
            s3.push(s4);
            s4 = peg$parseWS();
          }
          if (s3 !== peg$FAILED) {
            s4 = peg$parseIRI_REF();
            if (s4 !== peg$FAILED) {
              peg$savedPos = s0;
              s1 = peg$c10(s4);
              s0 = s1;
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c5); }
      }

      return s0;
    }

    function peg$parsePrefixDecl() {
      var s0, s1, s2, s3, s4, s5, s6;

      peg$silentFails++;
      s0 = peg$currPos;
      s1 = [];
      s2 = peg$parseWS();
      while (s2 !== peg$FAILED) {
        s1.push(s2);
        s2 = peg$parseWS();
      }
      if (s1 !== peg$FAILED) {
        if (input.substr(peg$currPos, 6) === peg$c12) {
          s2 = peg$c12;
          peg$currPos += 6;
        } else {
          s2 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c13); }
        }
        if (s2 === peg$FAILED) {
          if (input.substr(peg$currPos, 6) === peg$c14) {
            s2 = peg$c14;
            peg$currPos += 6;
          } else {
            s2 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c15); }
          }
        }
        if (s2 !== peg$FAILED) {
          s3 = [];
          s4 = peg$parseWS();
          while (s4 !== peg$FAILED) {
            s3.push(s4);
            s4 = peg$parseWS();
          }
          if (s3 !== peg$FAILED) {
            s4 = peg$parsePNAME_NS();
            if (s4 !== peg$FAILED) {
              s5 = [];
              s6 = peg$parseWS();
              while (s6 !== peg$FAILED) {
                s5.push(s6);
                s6 = peg$parseWS();
              }
              if (s5 !== peg$FAILED) {
                s6 = peg$parseIRI_REF();
                if (s6 !== peg$FAILED) {
                  peg$savedPos = s0;
                  s1 = peg$c16(s4, s6);
                  s0 = s1;
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c11); }
      }

      return s0;
    }

    function peg$parseSelectQuery() {
      var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9;

      peg$silentFails++;
      s0 = peg$currPos;
      s1 = peg$parseSelectClause();
      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$parseWS();
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parseWS();
        }
        if (s2 !== peg$FAILED) {
          s3 = [];
          s4 = peg$parseDatasetClause();
          while (s4 !== peg$FAILED) {
            s3.push(s4);
            s4 = peg$parseDatasetClause();
          }
          if (s3 !== peg$FAILED) {
            s4 = [];
            s5 = peg$parseWS();
            while (s5 !== peg$FAILED) {
              s4.push(s5);
              s5 = peg$parseWS();
            }
            if (s4 !== peg$FAILED) {
              s5 = peg$parseWhereClause();
              if (s5 !== peg$FAILED) {
                s6 = [];
                s7 = peg$parseWS();
                while (s7 !== peg$FAILED) {
                  s6.push(s7);
                  s7 = peg$parseWS();
                }
                if (s6 !== peg$FAILED) {
                  s7 = peg$parseSolutionModifier();
                  if (s7 !== peg$FAILED) {
                    s8 = [];
                    s9 = peg$parseWS();
                    while (s9 !== peg$FAILED) {
                      s8.push(s9);
                      s9 = peg$parseWS();
                    }
                    if (s8 !== peg$FAILED) {
                      s9 = peg$parseBindingsClause();
                      if (s9 !== peg$FAILED) {
                        peg$savedPos = s0;
                        s1 = peg$c18(s1, s3, s5, s7);
                        s0 = s1;
                      } else {
                        peg$currPos = s0;
                        s0 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s0;
                      s0 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c17); }
      }

      return s0;
    }

    function peg$parseSubSelect() {
      var s0, s1, s2, s3;

      peg$silentFails++;
      s0 = peg$currPos;
      s1 = peg$parseSelectClause();
      if (s1 !== peg$FAILED) {
        s2 = peg$parseWhereClause();
        if (s2 !== peg$FAILED) {
          s3 = peg$parseSolutionModifier();
          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c20(s1, s2, s3);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c19); }
      }

      return s0;
    }

    function peg$parseSelectClause() {
      var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15, s16, s17, s18, s19;

      peg$silentFails++;
      s0 = peg$currPos;
      s1 = [];
      s2 = peg$parseWS();
      while (s2 !== peg$FAILED) {
        s1.push(s2);
        s2 = peg$parseWS();
      }
      if (s1 !== peg$FAILED) {
        if (input.substr(peg$currPos, 6) === peg$c22) {
          s2 = peg$c22;
          peg$currPos += 6;
        } else {
          s2 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c23); }
        }
        if (s2 === peg$FAILED) {
          if (input.substr(peg$currPos, 6) === peg$c24) {
            s2 = peg$c24;
            peg$currPos += 6;
          } else {
            s2 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c25); }
          }
        }
        if (s2 !== peg$FAILED) {
          s3 = [];
          s4 = peg$parseWS();
          while (s4 !== peg$FAILED) {
            s3.push(s4);
            s4 = peg$parseWS();
          }
          if (s3 !== peg$FAILED) {
            if (input.substr(peg$currPos, 8) === peg$c26) {
              s4 = peg$c26;
              peg$currPos += 8;
            } else {
              s4 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c27); }
            }
            if (s4 === peg$FAILED) {
              if (input.substr(peg$currPos, 8) === peg$c28) {
                s4 = peg$c28;
                peg$currPos += 8;
              } else {
                s4 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c29); }
              }
            }
            if (s4 === peg$FAILED) {
              if (input.substr(peg$currPos, 7) === peg$c30) {
                s4 = peg$c30;
                peg$currPos += 7;
              } else {
                s4 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c31); }
              }
              if (s4 === peg$FAILED) {
                if (input.substr(peg$currPos, 7) === peg$c32) {
                  s4 = peg$c32;
                  peg$currPos += 7;
                } else {
                  s4 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c33); }
                }
              }
            }
            if (s4 === peg$FAILED) {
              s4 = null;
            }
            if (s4 !== peg$FAILED) {
              s5 = [];
              s6 = peg$parseWS();
              while (s6 !== peg$FAILED) {
                s5.push(s6);
                s6 = peg$parseWS();
              }
              if (s5 !== peg$FAILED) {
                s6 = [];
                s7 = peg$currPos;
                s8 = [];
                s9 = peg$parseWS();
                while (s9 !== peg$FAILED) {
                  s8.push(s9);
                  s9 = peg$parseWS();
                }
                if (s8 !== peg$FAILED) {
                  s9 = peg$parseVar();
                  if (s9 !== peg$FAILED) {
                    s10 = [];
                    s11 = peg$parseWS();
                    while (s11 !== peg$FAILED) {
                      s10.push(s11);
                      s11 = peg$parseWS();
                    }
                    if (s10 !== peg$FAILED) {
                      s8 = [s8, s9, s10];
                      s7 = s8;
                    } else {
                      peg$currPos = s7;
                      s7 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s7;
                    s7 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s7;
                  s7 = peg$FAILED;
                }
                if (s7 === peg$FAILED) {
                  s7 = peg$currPos;
                  s8 = [];
                  s9 = peg$parseWS();
                  while (s9 !== peg$FAILED) {
                    s8.push(s9);
                    s9 = peg$parseWS();
                  }
                  if (s8 !== peg$FAILED) {
                    if (input.charCodeAt(peg$currPos) === 40) {
                      s9 = peg$c34;
                      peg$currPos++;
                    } else {
                      s9 = peg$FAILED;
                      if (peg$silentFails === 0) { peg$fail(peg$c35); }
                    }
                    if (s9 !== peg$FAILED) {
                      s10 = [];
                      s11 = peg$parseWS();
                      while (s11 !== peg$FAILED) {
                        s10.push(s11);
                        s11 = peg$parseWS();
                      }
                      if (s10 !== peg$FAILED) {
                        s11 = peg$parseExpression();
                        if (s11 !== peg$FAILED) {
                          s12 = [];
                          s13 = peg$parseWS();
                          while (s13 !== peg$FAILED) {
                            s12.push(s13);
                            s13 = peg$parseWS();
                          }
                          if (s12 !== peg$FAILED) {
                            if (input.substr(peg$currPos, 2) === peg$c36) {
                              s13 = peg$c36;
                              peg$currPos += 2;
                            } else {
                              s13 = peg$FAILED;
                              if (peg$silentFails === 0) { peg$fail(peg$c37); }
                            }
                            if (s13 === peg$FAILED) {
                              if (input.substr(peg$currPos, 2) === peg$c38) {
                                s13 = peg$c38;
                                peg$currPos += 2;
                              } else {
                                s13 = peg$FAILED;
                                if (peg$silentFails === 0) { peg$fail(peg$c39); }
                              }
                            }
                            if (s13 !== peg$FAILED) {
                              s14 = [];
                              s15 = peg$parseWS();
                              while (s15 !== peg$FAILED) {
                                s14.push(s15);
                                s15 = peg$parseWS();
                              }
                              if (s14 !== peg$FAILED) {
                                s15 = peg$parseVar();
                                if (s15 !== peg$FAILED) {
                                  s16 = [];
                                  s17 = peg$parseWS();
                                  while (s17 !== peg$FAILED) {
                                    s16.push(s17);
                                    s17 = peg$parseWS();
                                  }
                                  if (s16 !== peg$FAILED) {
                                    if (input.charCodeAt(peg$currPos) === 41) {
                                      s17 = peg$c40;
                                      peg$currPos++;
                                    } else {
                                      s17 = peg$FAILED;
                                      if (peg$silentFails === 0) { peg$fail(peg$c41); }
                                    }
                                    if (s17 !== peg$FAILED) {
                                      s18 = [];
                                      s19 = peg$parseWS();
                                      while (s19 !== peg$FAILED) {
                                        s18.push(s19);
                                        s19 = peg$parseWS();
                                      }
                                      if (s18 !== peg$FAILED) {
                                        s8 = [s8, s9, s10, s11, s12, s13, s14, s15, s16, s17, s18];
                                        s7 = s8;
                                      } else {
                                        peg$currPos = s7;
                                        s7 = peg$FAILED;
                                      }
                                    } else {
                                      peg$currPos = s7;
                                      s7 = peg$FAILED;
                                    }
                                  } else {
                                    peg$currPos = s7;
                                    s7 = peg$FAILED;
                                  }
                                } else {
                                  peg$currPos = s7;
                                  s7 = peg$FAILED;
                                }
                              } else {
                                peg$currPos = s7;
                                s7 = peg$FAILED;
                              }
                            } else {
                              peg$currPos = s7;
                              s7 = peg$FAILED;
                            }
                          } else {
                            peg$currPos = s7;
                            s7 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s7;
                          s7 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s7;
                        s7 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s7;
                      s7 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s7;
                    s7 = peg$FAILED;
                  }
                }
                if (s7 !== peg$FAILED) {
                  while (s7 !== peg$FAILED) {
                    s6.push(s7);
                    s7 = peg$currPos;
                    s8 = [];
                    s9 = peg$parseWS();
                    while (s9 !== peg$FAILED) {
                      s8.push(s9);
                      s9 = peg$parseWS();
                    }
                    if (s8 !== peg$FAILED) {
                      s9 = peg$parseVar();
                      if (s9 !== peg$FAILED) {
                        s10 = [];
                        s11 = peg$parseWS();
                        while (s11 !== peg$FAILED) {
                          s10.push(s11);
                          s11 = peg$parseWS();
                        }
                        if (s10 !== peg$FAILED) {
                          s8 = [s8, s9, s10];
                          s7 = s8;
                        } else {
                          peg$currPos = s7;
                          s7 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s7;
                        s7 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s7;
                      s7 = peg$FAILED;
                    }
                    if (s7 === peg$FAILED) {
                      s7 = peg$currPos;
                      s8 = [];
                      s9 = peg$parseWS();
                      while (s9 !== peg$FAILED) {
                        s8.push(s9);
                        s9 = peg$parseWS();
                      }
                      if (s8 !== peg$FAILED) {
                        if (input.charCodeAt(peg$currPos) === 40) {
                          s9 = peg$c34;
                          peg$currPos++;
                        } else {
                          s9 = peg$FAILED;
                          if (peg$silentFails === 0) { peg$fail(peg$c35); }
                        }
                        if (s9 !== peg$FAILED) {
                          s10 = [];
                          s11 = peg$parseWS();
                          while (s11 !== peg$FAILED) {
                            s10.push(s11);
                            s11 = peg$parseWS();
                          }
                          if (s10 !== peg$FAILED) {
                            s11 = peg$parseExpression();
                            if (s11 !== peg$FAILED) {
                              s12 = [];
                              s13 = peg$parseWS();
                              while (s13 !== peg$FAILED) {
                                s12.push(s13);
                                s13 = peg$parseWS();
                              }
                              if (s12 !== peg$FAILED) {
                                if (input.substr(peg$currPos, 2) === peg$c36) {
                                  s13 = peg$c36;
                                  peg$currPos += 2;
                                } else {
                                  s13 = peg$FAILED;
                                  if (peg$silentFails === 0) { peg$fail(peg$c37); }
                                }
                                if (s13 === peg$FAILED) {
                                  if (input.substr(peg$currPos, 2) === peg$c38) {
                                    s13 = peg$c38;
                                    peg$currPos += 2;
                                  } else {
                                    s13 = peg$FAILED;
                                    if (peg$silentFails === 0) { peg$fail(peg$c39); }
                                  }
                                }
                                if (s13 !== peg$FAILED) {
                                  s14 = [];
                                  s15 = peg$parseWS();
                                  while (s15 !== peg$FAILED) {
                                    s14.push(s15);
                                    s15 = peg$parseWS();
                                  }
                                  if (s14 !== peg$FAILED) {
                                    s15 = peg$parseVar();
                                    if (s15 !== peg$FAILED) {
                                      s16 = [];
                                      s17 = peg$parseWS();
                                      while (s17 !== peg$FAILED) {
                                        s16.push(s17);
                                        s17 = peg$parseWS();
                                      }
                                      if (s16 !== peg$FAILED) {
                                        if (input.charCodeAt(peg$currPos) === 41) {
                                          s17 = peg$c40;
                                          peg$currPos++;
                                        } else {
                                          s17 = peg$FAILED;
                                          if (peg$silentFails === 0) { peg$fail(peg$c41); }
                                        }
                                        if (s17 !== peg$FAILED) {
                                          s18 = [];
                                          s19 = peg$parseWS();
                                          while (s19 !== peg$FAILED) {
                                            s18.push(s19);
                                            s19 = peg$parseWS();
                                          }
                                          if (s18 !== peg$FAILED) {
                                            s8 = [s8, s9, s10, s11, s12, s13, s14, s15, s16, s17, s18];
                                            s7 = s8;
                                          } else {
                                            peg$currPos = s7;
                                            s7 = peg$FAILED;
                                          }
                                        } else {
                                          peg$currPos = s7;
                                          s7 = peg$FAILED;
                                        }
                                      } else {
                                        peg$currPos = s7;
                                        s7 = peg$FAILED;
                                      }
                                    } else {
                                      peg$currPos = s7;
                                      s7 = peg$FAILED;
                                    }
                                  } else {
                                    peg$currPos = s7;
                                    s7 = peg$FAILED;
                                  }
                                } else {
                                  peg$currPos = s7;
                                  s7 = peg$FAILED;
                                }
                              } else {
                                peg$currPos = s7;
                                s7 = peg$FAILED;
                              }
                            } else {
                              peg$currPos = s7;
                              s7 = peg$FAILED;
                            }
                          } else {
                            peg$currPos = s7;
                            s7 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s7;
                          s7 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s7;
                        s7 = peg$FAILED;
                      }
                    }
                  }
                } else {
                  s6 = peg$FAILED;
                }
                if (s6 === peg$FAILED) {
                  s6 = peg$currPos;
                  s7 = [];
                  s8 = peg$parseWS();
                  while (s8 !== peg$FAILED) {
                    s7.push(s8);
                    s8 = peg$parseWS();
                  }
                  if (s7 !== peg$FAILED) {
                    if (input.charCodeAt(peg$currPos) === 42) {
                      s8 = peg$c42;
                      peg$currPos++;
                    } else {
                      s8 = peg$FAILED;
                      if (peg$silentFails === 0) { peg$fail(peg$c43); }
                    }
                    if (s8 !== peg$FAILED) {
                      s9 = [];
                      s10 = peg$parseWS();
                      while (s10 !== peg$FAILED) {
                        s9.push(s10);
                        s10 = peg$parseWS();
                      }
                      if (s9 !== peg$FAILED) {
                        s7 = [s7, s8, s9];
                        s6 = s7;
                      } else {
                        peg$currPos = s6;
                        s6 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s6;
                      s6 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s6;
                    s6 = peg$FAILED;
                  }
                }
                if (s6 !== peg$FAILED) {
                  peg$savedPos = s0;
                  s1 = peg$c44(s4, s6);
                  s0 = s1;
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c21); }
      }

      return s0;
    }

    function peg$parseConstructQuery() {
      var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14;

      peg$silentFails++;
      s0 = peg$currPos;
      s1 = [];
      s2 = peg$parseWS();
      while (s2 !== peg$FAILED) {
        s1.push(s2);
        s2 = peg$parseWS();
      }
      if (s1 !== peg$FAILED) {
        if (input.substr(peg$currPos, 9) === peg$c46) {
          s2 = peg$c46;
          peg$currPos += 9;
        } else {
          s2 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c47); }
        }
        if (s2 === peg$FAILED) {
          if (input.substr(peg$currPos, 9) === peg$c48) {
            s2 = peg$c48;
            peg$currPos += 9;
          } else {
            s2 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c49); }
          }
        }
        if (s2 !== peg$FAILED) {
          s3 = [];
          s4 = peg$parseWS();
          while (s4 !== peg$FAILED) {
            s3.push(s4);
            s4 = peg$parseWS();
          }
          if (s3 !== peg$FAILED) {
            s4 = peg$parseConstructTemplate();
            if (s4 !== peg$FAILED) {
              s5 = [];
              s6 = peg$parseWS();
              while (s6 !== peg$FAILED) {
                s5.push(s6);
                s6 = peg$parseWS();
              }
              if (s5 !== peg$FAILED) {
                s6 = [];
                s7 = peg$parseDatasetClause();
                while (s7 !== peg$FAILED) {
                  s6.push(s7);
                  s7 = peg$parseDatasetClause();
                }
                if (s6 !== peg$FAILED) {
                  s7 = [];
                  s8 = peg$parseWS();
                  while (s8 !== peg$FAILED) {
                    s7.push(s8);
                    s8 = peg$parseWS();
                  }
                  if (s7 !== peg$FAILED) {
                    s8 = peg$parseWhereClause();
                    if (s8 !== peg$FAILED) {
                      s9 = [];
                      s10 = peg$parseWS();
                      while (s10 !== peg$FAILED) {
                        s9.push(s10);
                        s10 = peg$parseWS();
                      }
                      if (s9 !== peg$FAILED) {
                        s10 = peg$parseSolutionModifier();
                        if (s10 !== peg$FAILED) {
                          peg$savedPos = s0;
                          s1 = peg$c50(s4, s6, s8, s10);
                          s0 = s1;
                        } else {
                          peg$currPos = s0;
                          s0 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s0;
                        s0 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s0;
                      s0 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        s1 = [];
        s2 = peg$parseWS();
        while (s2 !== peg$FAILED) {
          s1.push(s2);
          s2 = peg$parseWS();
        }
        if (s1 !== peg$FAILED) {
          if (input.substr(peg$currPos, 9) === peg$c46) {
            s2 = peg$c46;
            peg$currPos += 9;
          } else {
            s2 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c47); }
          }
          if (s2 === peg$FAILED) {
            if (input.substr(peg$currPos, 9) === peg$c48) {
              s2 = peg$c48;
              peg$currPos += 9;
            } else {
              s2 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c49); }
            }
          }
          if (s2 !== peg$FAILED) {
            s3 = [];
            s4 = peg$parseWS();
            while (s4 !== peg$FAILED) {
              s3.push(s4);
              s4 = peg$parseWS();
            }
            if (s3 !== peg$FAILED) {
              s4 = [];
              s5 = peg$parseDatasetClause();
              while (s5 !== peg$FAILED) {
                s4.push(s5);
                s5 = peg$parseDatasetClause();
              }
              if (s4 !== peg$FAILED) {
                s5 = [];
                s6 = peg$parseWS();
                while (s6 !== peg$FAILED) {
                  s5.push(s6);
                  s6 = peg$parseWS();
                }
                if (s5 !== peg$FAILED) {
                  if (input.substr(peg$currPos, 5) === peg$c51) {
                    s6 = peg$c51;
                    peg$currPos += 5;
                  } else {
                    s6 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$c52); }
                  }
                  if (s6 === peg$FAILED) {
                    if (input.substr(peg$currPos, 5) === peg$c53) {
                      s6 = peg$c53;
                      peg$currPos += 5;
                    } else {
                      s6 = peg$FAILED;
                      if (peg$silentFails === 0) { peg$fail(peg$c54); }
                    }
                  }
                  if (s6 !== peg$FAILED) {
                    s7 = [];
                    s8 = peg$parseWS();
                    while (s8 !== peg$FAILED) {
                      s7.push(s8);
                      s8 = peg$parseWS();
                    }
                    if (s7 !== peg$FAILED) {
                      if (input.charCodeAt(peg$currPos) === 123) {
                        s8 = peg$c55;
                        peg$currPos++;
                      } else {
                        s8 = peg$FAILED;
                        if (peg$silentFails === 0) { peg$fail(peg$c56); }
                      }
                      if (s8 !== peg$FAILED) {
                        s9 = [];
                        s10 = peg$parseWS();
                        while (s10 !== peg$FAILED) {
                          s9.push(s10);
                          s10 = peg$parseWS();
                        }
                        if (s9 !== peg$FAILED) {
                          s10 = peg$parseTriplesTemplate();
                          if (s10 === peg$FAILED) {
                            s10 = null;
                          }
                          if (s10 !== peg$FAILED) {
                            s11 = [];
                            s12 = peg$parseWS();
                            while (s12 !== peg$FAILED) {
                              s11.push(s12);
                              s12 = peg$parseWS();
                            }
                            if (s11 !== peg$FAILED) {
                              if (input.charCodeAt(peg$currPos) === 125) {
                                s12 = peg$c57;
                                peg$currPos++;
                              } else {
                                s12 = peg$FAILED;
                                if (peg$silentFails === 0) { peg$fail(peg$c58); }
                              }
                              if (s12 !== peg$FAILED) {
                                s13 = [];
                                s14 = peg$parseWS();
                                while (s14 !== peg$FAILED) {
                                  s13.push(s14);
                                  s14 = peg$parseWS();
                                }
                                if (s13 !== peg$FAILED) {
                                  s14 = peg$parseSolutionModifier();
                                  if (s14 !== peg$FAILED) {
                                    peg$savedPos = s0;
                                    s1 = peg$c59(s4, s10, s14);
                                    s0 = s1;
                                  } else {
                                    peg$currPos = s0;
                                    s0 = peg$FAILED;
                                  }
                                } else {
                                  peg$currPos = s0;
                                  s0 = peg$FAILED;
                                }
                              } else {
                                peg$currPos = s0;
                                s0 = peg$FAILED;
                              }
                            } else {
                              peg$currPos = s0;
                              s0 = peg$FAILED;
                            }
                          } else {
                            peg$currPos = s0;
                            s0 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s0;
                          s0 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s0;
                        s0 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s0;
                      s0 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c45); }
      }

      return s0;
    }

    function peg$parseDescribeQuery() {
      var s0, s1, s2, s3, s4, s5;

      peg$silentFails++;
      s0 = peg$currPos;
      if (input.substr(peg$currPos, 8) === peg$c61) {
        s1 = peg$c61;
        peg$currPos += 8;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c62); }
      }
      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$parseVarOrIRIref();
        if (s3 !== peg$FAILED) {
          while (s3 !== peg$FAILED) {
            s2.push(s3);
            s3 = peg$parseVarOrIRIref();
          }
        } else {
          s2 = peg$FAILED;
        }
        if (s2 === peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 42) {
            s2 = peg$c42;
            peg$currPos++;
          } else {
            s2 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c43); }
          }
        }
        if (s2 !== peg$FAILED) {
          s3 = [];
          s4 = peg$parseDatasetClause();
          while (s4 !== peg$FAILED) {
            s3.push(s4);
            s4 = peg$parseDatasetClause();
          }
          if (s3 !== peg$FAILED) {
            s4 = peg$parseWhereClause();
            if (s4 === peg$FAILED) {
              s4 = null;
            }
            if (s4 !== peg$FAILED) {
              s5 = peg$parseSolutionModifier();
              if (s5 !== peg$FAILED) {
                s1 = [s1, s2, s3, s4, s5];
                s0 = s1;
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c60); }
      }

      return s0;
    }

    function peg$parseAskQuery() {
      var s0, s1, s2, s3, s4, s5, s6;

      peg$silentFails++;
      s0 = peg$currPos;
      s1 = [];
      s2 = peg$parseWS();
      while (s2 !== peg$FAILED) {
        s1.push(s2);
        s2 = peg$parseWS();
      }
      if (s1 !== peg$FAILED) {
        if (input.substr(peg$currPos, 3) === peg$c64) {
          s2 = peg$c64;
          peg$currPos += 3;
        } else {
          s2 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c65); }
        }
        if (s2 === peg$FAILED) {
          if (input.substr(peg$currPos, 3) === peg$c66) {
            s2 = peg$c66;
            peg$currPos += 3;
          } else {
            s2 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c67); }
          }
        }
        if (s2 !== peg$FAILED) {
          s3 = [];
          s4 = peg$parseWS();
          while (s4 !== peg$FAILED) {
            s3.push(s4);
            s4 = peg$parseWS();
          }
          if (s3 !== peg$FAILED) {
            s4 = [];
            s5 = peg$parseDatasetClause();
            while (s5 !== peg$FAILED) {
              s4.push(s5);
              s5 = peg$parseDatasetClause();
            }
            if (s4 !== peg$FAILED) {
              s5 = [];
              s6 = peg$parseWS();
              while (s6 !== peg$FAILED) {
                s5.push(s6);
                s6 = peg$parseWS();
              }
              if (s5 !== peg$FAILED) {
                s6 = peg$parseWhereClause();
                if (s6 !== peg$FAILED) {
                  peg$savedPos = s0;
                  s1 = peg$c68(s4, s6);
                  s0 = s1;
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c63); }
      }

      return s0;
    }

    function peg$parseDatasetClause() {
      var s0, s1, s2, s3, s4, s5;

      peg$silentFails++;
      s0 = peg$currPos;
      if (input.substr(peg$currPos, 4) === peg$c70) {
        s1 = peg$c70;
        peg$currPos += 4;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c71); }
      }
      if (s1 === peg$FAILED) {
        if (input.substr(peg$currPos, 4) === peg$c72) {
          s1 = peg$c72;
          peg$currPos += 4;
        } else {
          s1 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c73); }
        }
      }
      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$parseWS();
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parseWS();
        }
        if (s2 !== peg$FAILED) {
          s3 = peg$parseDefaultGraphClause();
          if (s3 === peg$FAILED) {
            s3 = peg$parseNamedGraphClause();
          }
          if (s3 !== peg$FAILED) {
            s4 = [];
            s5 = peg$parseWS();
            while (s5 !== peg$FAILED) {
              s4.push(s5);
              s5 = peg$parseWS();
            }
            if (s4 !== peg$FAILED) {
              peg$savedPos = s0;
              s1 = peg$c74(s3);
              s0 = s1;
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c69); }
      }

      return s0;
    }

    function peg$parseDefaultGraphClause() {
      var s0, s1, s2;

      peg$silentFails++;
      s0 = peg$currPos;
      s1 = [];
      s2 = peg$parseWS();
      while (s2 !== peg$FAILED) {
        s1.push(s2);
        s2 = peg$parseWS();
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parseSourceSelector();
        if (s2 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c76(s2);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c75); }
      }

      return s0;
    }

    function peg$parseNamedGraphClause() {
      var s0, s1, s2, s3;

      peg$silentFails++;
      s0 = peg$currPos;
      if (input.substr(peg$currPos, 5) === peg$c78) {
        s1 = peg$c78;
        peg$currPos += 5;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c79); }
      }
      if (s1 === peg$FAILED) {
        if (input.substr(peg$currPos, 5) === peg$c80) {
          s1 = peg$c80;
          peg$currPos += 5;
        } else {
          s1 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c81); }
        }
      }
      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$parseWS();
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parseWS();
        }
        if (s2 !== peg$FAILED) {
          s3 = peg$parseSourceSelector();
          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c82(s3);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c77); }
      }

      return s0;
    }

    function peg$parseSourceSelector() {
      var s0, s1;

      peg$silentFails++;
      s0 = peg$parseIRIref();
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c83); }
      }

      return s0;
    }

    function peg$parseWhereClause() {
      var s0, s1, s2, s3, s4, s5;

      peg$silentFails++;
      s0 = peg$currPos;
      if (input.substr(peg$currPos, 5) === peg$c51) {
        s1 = peg$c51;
        peg$currPos += 5;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c52); }
      }
      if (s1 === peg$FAILED) {
        if (input.substr(peg$currPos, 5) === peg$c53) {
          s1 = peg$c53;
          peg$currPos += 5;
        } else {
          s1 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c54); }
        }
      }
      if (s1 === peg$FAILED) {
        s1 = null;
      }
      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$parseWS();
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parseWS();
        }
        if (s2 !== peg$FAILED) {
          s3 = peg$parseGroupGraphPattern();
          if (s3 !== peg$FAILED) {
            s4 = [];
            s5 = peg$parseWS();
            while (s5 !== peg$FAILED) {
              s4.push(s5);
              s5 = peg$parseWS();
            }
            if (s4 !== peg$FAILED) {
              peg$savedPos = s0;
              s1 = peg$c85(s3);
              s0 = s1;
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c84); }
      }

      return s0;
    }

    function peg$parseSolutionModifier() {
      var s0, s1, s2, s3, s4;

      peg$silentFails++;
      s0 = peg$currPos;
      s1 = peg$parseGroupClause();
      if (s1 === peg$FAILED) {
        s1 = null;
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parseHavingClause();
        if (s2 === peg$FAILED) {
          s2 = null;
        }
        if (s2 !== peg$FAILED) {
          s3 = peg$parseOrderClause();
          if (s3 === peg$FAILED) {
            s3 = null;
          }
          if (s3 !== peg$FAILED) {
            s4 = peg$parseLimitOffsetClauses();
            if (s4 === peg$FAILED) {
              s4 = null;
            }
            if (s4 !== peg$FAILED) {
              peg$savedPos = s0;
              s1 = peg$c87(s1, s3, s4);
              s0 = s1;
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c86); }
      }

      return s0;
    }

    function peg$parseGroupClause() {
      var s0, s1, s2, s3, s4, s5, s6;

      peg$silentFails++;
      s0 = peg$currPos;
      if (input.substr(peg$currPos, 5) === peg$c89) {
        s1 = peg$c89;
        peg$currPos += 5;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c90); }
      }
      if (s1 === peg$FAILED) {
        if (input.substr(peg$currPos, 5) === peg$c91) {
          s1 = peg$c91;
          peg$currPos += 5;
        } else {
          s1 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c92); }
        }
      }
      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$parseWS();
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parseWS();
        }
        if (s2 !== peg$FAILED) {
          if (input.substr(peg$currPos, 2) === peg$c93) {
            s3 = peg$c93;
            peg$currPos += 2;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c94); }
          }
          if (s3 === peg$FAILED) {
            if (input.substr(peg$currPos, 2) === peg$c95) {
              s3 = peg$c95;
              peg$currPos += 2;
            } else {
              s3 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c96); }
            }
          }
          if (s3 !== peg$FAILED) {
            s4 = [];
            s5 = peg$parseWS();
            while (s5 !== peg$FAILED) {
              s4.push(s5);
              s5 = peg$parseWS();
            }
            if (s4 !== peg$FAILED) {
              s5 = [];
              s6 = peg$parseGroupCondition();
              if (s6 !== peg$FAILED) {
                while (s6 !== peg$FAILED) {
                  s5.push(s6);
                  s6 = peg$parseGroupCondition();
                }
              } else {
                s5 = peg$FAILED;
              }
              if (s5 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c97(s5);
                s0 = s1;
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c88); }
      }

      return s0;
    }

    function peg$parseGroupCondition() {
      var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10;

      peg$silentFails++;
      s0 = peg$currPos;
      s1 = [];
      s2 = peg$parseWS();
      while (s2 !== peg$FAILED) {
        s1.push(s2);
        s2 = peg$parseWS();
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parseBuiltInCall();
        if (s2 !== peg$FAILED) {
          s3 = [];
          s4 = peg$parseWS();
          while (s4 !== peg$FAILED) {
            s3.push(s4);
            s4 = peg$parseWS();
          }
          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c99(s2);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        s1 = [];
        s2 = peg$parseWS();
        while (s2 !== peg$FAILED) {
          s1.push(s2);
          s2 = peg$parseWS();
        }
        if (s1 !== peg$FAILED) {
          s2 = peg$parseFunctionCall();
          if (s2 !== peg$FAILED) {
            s3 = [];
            s4 = peg$parseWS();
            while (s4 !== peg$FAILED) {
              s3.push(s4);
              s4 = peg$parseWS();
            }
            if (s3 !== peg$FAILED) {
              peg$savedPos = s0;
              s1 = peg$c100(s2);
              s0 = s1;
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
        if (s0 === peg$FAILED) {
          s0 = peg$currPos;
          s1 = [];
          s2 = peg$parseWS();
          while (s2 !== peg$FAILED) {
            s1.push(s2);
            s2 = peg$parseWS();
          }
          if (s1 !== peg$FAILED) {
            if (input.charCodeAt(peg$currPos) === 40) {
              s2 = peg$c34;
              peg$currPos++;
            } else {
              s2 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c35); }
            }
            if (s2 !== peg$FAILED) {
              s3 = [];
              s4 = peg$parseWS();
              while (s4 !== peg$FAILED) {
                s3.push(s4);
                s4 = peg$parseWS();
              }
              if (s3 !== peg$FAILED) {
                s4 = peg$parseExpression();
                if (s4 !== peg$FAILED) {
                  s5 = [];
                  s6 = peg$parseWS();
                  while (s6 !== peg$FAILED) {
                    s5.push(s6);
                    s6 = peg$parseWS();
                  }
                  if (s5 !== peg$FAILED) {
                    s6 = peg$currPos;
                    if (input.substr(peg$currPos, 2) === peg$c36) {
                      s7 = peg$c36;
                      peg$currPos += 2;
                    } else {
                      s7 = peg$FAILED;
                      if (peg$silentFails === 0) { peg$fail(peg$c37); }
                    }
                    if (s7 === peg$FAILED) {
                      if (input.substr(peg$currPos, 2) === peg$c38) {
                        s7 = peg$c38;
                        peg$currPos += 2;
                      } else {
                        s7 = peg$FAILED;
                        if (peg$silentFails === 0) { peg$fail(peg$c39); }
                      }
                    }
                    if (s7 !== peg$FAILED) {
                      s8 = [];
                      s9 = peg$parseWS();
                      while (s9 !== peg$FAILED) {
                        s8.push(s9);
                        s9 = peg$parseWS();
                      }
                      if (s8 !== peg$FAILED) {
                        s9 = peg$parseVar();
                        if (s9 !== peg$FAILED) {
                          s7 = [s7, s8, s9];
                          s6 = s7;
                        } else {
                          peg$currPos = s6;
                          s6 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s6;
                        s6 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s6;
                      s6 = peg$FAILED;
                    }
                    if (s6 === peg$FAILED) {
                      s6 = null;
                    }
                    if (s6 !== peg$FAILED) {
                      s7 = [];
                      s8 = peg$parseWS();
                      while (s8 !== peg$FAILED) {
                        s7.push(s8);
                        s8 = peg$parseWS();
                      }
                      if (s7 !== peg$FAILED) {
                        if (input.charCodeAt(peg$currPos) === 41) {
                          s8 = peg$c40;
                          peg$currPos++;
                        } else {
                          s8 = peg$FAILED;
                          if (peg$silentFails === 0) { peg$fail(peg$c41); }
                        }
                        if (s8 !== peg$FAILED) {
                          s9 = [];
                          s10 = peg$parseWS();
                          while (s10 !== peg$FAILED) {
                            s9.push(s10);
                            s10 = peg$parseWS();
                          }
                          if (s9 !== peg$FAILED) {
                            peg$savedPos = s0;
                            s1 = peg$c101(s4, s6);
                            s0 = s1;
                          } else {
                            peg$currPos = s0;
                            s0 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s0;
                          s0 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s0;
                        s0 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s0;
                      s0 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
          if (s0 === peg$FAILED) {
            s0 = peg$currPos;
            s1 = [];
            s2 = peg$parseWS();
            while (s2 !== peg$FAILED) {
              s1.push(s2);
              s2 = peg$parseWS();
            }
            if (s1 !== peg$FAILED) {
              s2 = peg$parseVar();
              if (s2 !== peg$FAILED) {
                s3 = [];
                s4 = peg$parseWS();
                while (s4 !== peg$FAILED) {
                  s3.push(s4);
                  s4 = peg$parseWS();
                }
                if (s3 !== peg$FAILED) {
                  peg$savedPos = s0;
                  s1 = peg$c102(s2);
                  s0 = s1;
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          }
        }
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c98); }
      }

      return s0;
    }

    function peg$parseHavingClause() {
      var s0, s1, s2, s3;

      peg$silentFails++;
      s0 = peg$currPos;
      if (input.substr(peg$currPos, 6) === peg$c104) {
        s1 = peg$c104;
        peg$currPos += 6;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c105); }
      }
      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$parseHavingCondition();
        if (s3 !== peg$FAILED) {
          while (s3 !== peg$FAILED) {
            s2.push(s3);
            s3 = peg$parseHavingCondition();
          }
        } else {
          s2 = peg$FAILED;
        }
        if (s2 !== peg$FAILED) {
          s1 = [s1, s2];
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c103); }
      }

      return s0;
    }

    function peg$parseHavingCondition() {
      var s0, s1;

      peg$silentFails++;
      s0 = peg$parseConstraint();
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c106); }
      }

      return s0;
    }

    function peg$parseOrderClause() {
      var s0, s1, s2, s3, s4, s5, s6, s7;

      peg$silentFails++;
      s0 = peg$currPos;
      if (input.substr(peg$currPos, 5) === peg$c108) {
        s1 = peg$c108;
        peg$currPos += 5;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c109); }
      }
      if (s1 === peg$FAILED) {
        if (input.substr(peg$currPos, 5) === peg$c110) {
          s1 = peg$c110;
          peg$currPos += 5;
        } else {
          s1 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c111); }
        }
      }
      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$parseWS();
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parseWS();
        }
        if (s2 !== peg$FAILED) {
          if (input.substr(peg$currPos, 2) === peg$c93) {
            s3 = peg$c93;
            peg$currPos += 2;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c94); }
          }
          if (s3 === peg$FAILED) {
            if (input.substr(peg$currPos, 2) === peg$c95) {
              s3 = peg$c95;
              peg$currPos += 2;
            } else {
              s3 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c96); }
            }
          }
          if (s3 !== peg$FAILED) {
            s4 = [];
            s5 = peg$parseWS();
            while (s5 !== peg$FAILED) {
              s4.push(s5);
              s5 = peg$parseWS();
            }
            if (s4 !== peg$FAILED) {
              s5 = [];
              s6 = peg$parseOrderCondition();
              if (s6 !== peg$FAILED) {
                while (s6 !== peg$FAILED) {
                  s5.push(s6);
                  s6 = peg$parseOrderCondition();
                }
              } else {
                s5 = peg$FAILED;
              }
              if (s5 !== peg$FAILED) {
                s6 = [];
                s7 = peg$parseWS();
                while (s7 !== peg$FAILED) {
                  s6.push(s7);
                  s7 = peg$parseWS();
                }
                if (s6 !== peg$FAILED) {
                  peg$savedPos = s0;
                  s1 = peg$c112(s5);
                  s0 = s1;
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c107); }
      }

      return s0;
    }

    function peg$parseOrderCondition() {
      var s0, s1, s2, s3, s4, s5;

      peg$silentFails++;
      s0 = peg$currPos;
      if (input.substr(peg$currPos, 3) === peg$c114) {
        s1 = peg$c114;
        peg$currPos += 3;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c115); }
      }
      if (s1 === peg$FAILED) {
        if (input.substr(peg$currPos, 3) === peg$c116) {
          s1 = peg$c116;
          peg$currPos += 3;
        } else {
          s1 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c117); }
        }
        if (s1 === peg$FAILED) {
          if (input.substr(peg$currPos, 4) === peg$c118) {
            s1 = peg$c118;
            peg$currPos += 4;
          } else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c119); }
          }
          if (s1 === peg$FAILED) {
            if (input.substr(peg$currPos, 4) === peg$c120) {
              s1 = peg$c120;
              peg$currPos += 4;
            } else {
              s1 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c121); }
            }
          }
        }
      }
      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$parseWS();
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parseWS();
        }
        if (s2 !== peg$FAILED) {
          s3 = peg$parseBrackettedExpression();
          if (s3 !== peg$FAILED) {
            s4 = [];
            s5 = peg$parseWS();
            while (s5 !== peg$FAILED) {
              s4.push(s5);
              s5 = peg$parseWS();
            }
            if (s4 !== peg$FAILED) {
              peg$savedPos = s0;
              s1 = peg$c122(s1, s3);
              s0 = s1;
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        s1 = peg$parseConstraint();
        if (s1 === peg$FAILED) {
          s1 = peg$parseVar();
        }
        if (s1 !== peg$FAILED) {
          s2 = [];
          s3 = peg$parseWS();
          while (s3 !== peg$FAILED) {
            s2.push(s3);
            s3 = peg$parseWS();
          }
          if (s2 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c123(s1);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c113); }
      }

      return s0;
    }

    function peg$parseLimitOffsetClauses() {
      var s0, s1, s2, s3;

      peg$silentFails++;
      s0 = peg$currPos;
      s1 = peg$currPos;
      s2 = peg$parseLimitClause();
      if (s2 !== peg$FAILED) {
        s3 = peg$parseOffsetClause();
        if (s3 === peg$FAILED) {
          s3 = null;
        }
        if (s3 !== peg$FAILED) {
          s2 = [s2, s3];
          s1 = s2;
        } else {
          peg$currPos = s1;
          s1 = peg$FAILED;
        }
      } else {
        peg$currPos = s1;
        s1 = peg$FAILED;
      }
      if (s1 === peg$FAILED) {
        s1 = peg$currPos;
        s2 = peg$parseOffsetClause();
        if (s2 !== peg$FAILED) {
          s3 = peg$parseLimitClause();
          if (s3 === peg$FAILED) {
            s3 = null;
          }
          if (s3 !== peg$FAILED) {
            s2 = [s2, s3];
            s1 = s2;
          } else {
            peg$currPos = s1;
            s1 = peg$FAILED;
          }
        } else {
          peg$currPos = s1;
          s1 = peg$FAILED;
        }
      }
      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$c125(s1);
      }
      s0 = s1;
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c124); }
      }

      return s0;
    }

    function peg$parseLimitClause() {
      var s0, s1, s2, s3, s4, s5;

      peg$silentFails++;
      s0 = peg$currPos;
      if (input.substr(peg$currPos, 5) === peg$c127) {
        s1 = peg$c127;
        peg$currPos += 5;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c128); }
      }
      if (s1 === peg$FAILED) {
        if (input.substr(peg$currPos, 5) === peg$c129) {
          s1 = peg$c129;
          peg$currPos += 5;
        } else {
          s1 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c130); }
        }
      }
      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$parseWS();
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parseWS();
        }
        if (s2 !== peg$FAILED) {
          s3 = peg$parseINTEGER();
          if (s3 !== peg$FAILED) {
            s4 = [];
            s5 = peg$parseWS();
            while (s5 !== peg$FAILED) {
              s4.push(s5);
              s5 = peg$parseWS();
            }
            if (s4 !== peg$FAILED) {
              peg$savedPos = s0;
              s1 = peg$c131(s3);
              s0 = s1;
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c126); }
      }

      return s0;
    }

    function peg$parseOffsetClause() {
      var s0, s1, s2, s3, s4, s5;

      peg$silentFails++;
      s0 = peg$currPos;
      if (input.substr(peg$currPos, 6) === peg$c133) {
        s1 = peg$c133;
        peg$currPos += 6;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c134); }
      }
      if (s1 === peg$FAILED) {
        if (input.substr(peg$currPos, 6) === peg$c135) {
          s1 = peg$c135;
          peg$currPos += 6;
        } else {
          s1 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c136); }
        }
      }
      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$parseWS();
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parseWS();
        }
        if (s2 !== peg$FAILED) {
          s3 = peg$parseINTEGER();
          if (s3 !== peg$FAILED) {
            s4 = [];
            s5 = peg$parseWS();
            while (s5 !== peg$FAILED) {
              s4.push(s5);
              s5 = peg$parseWS();
            }
            if (s4 !== peg$FAILED) {
              peg$savedPos = s0;
              s1 = peg$c137(s3);
              s0 = s1;
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c132); }
      }

      return s0;
    }

    function peg$parseBindingsClause() {
      var s0, s1, s2, s3, s4, s5, s6, s7, s8;

      peg$silentFails++;
      s0 = peg$currPos;
      if (input.substr(peg$currPos, 8) === peg$c139) {
        s1 = peg$c139;
        peg$currPos += 8;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c140); }
      }
      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$parseVar();
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parseVar();
        }
        if (s2 !== peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 123) {
            s3 = peg$c55;
            peg$currPos++;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c56); }
          }
          if (s3 !== peg$FAILED) {
            s4 = [];
            s5 = peg$currPos;
            if (input.charCodeAt(peg$currPos) === 40) {
              s6 = peg$c34;
              peg$currPos++;
            } else {
              s6 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c35); }
            }
            if (s6 !== peg$FAILED) {
              s7 = [];
              s8 = peg$parseBindingValue();
              if (s8 !== peg$FAILED) {
                while (s8 !== peg$FAILED) {
                  s7.push(s8);
                  s8 = peg$parseBindingValue();
                }
              } else {
                s7 = peg$FAILED;
              }
              if (s7 !== peg$FAILED) {
                if (input.charCodeAt(peg$currPos) === 41) {
                  s8 = peg$c40;
                  peg$currPos++;
                } else {
                  s8 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c41); }
                }
                if (s8 !== peg$FAILED) {
                  s6 = [s6, s7, s8];
                  s5 = s6;
                } else {
                  peg$currPos = s5;
                  s5 = peg$FAILED;
                }
              } else {
                peg$currPos = s5;
                s5 = peg$FAILED;
              }
            } else {
              peg$currPos = s5;
              s5 = peg$FAILED;
            }
            if (s5 === peg$FAILED) {
              s5 = peg$parseNIL();
            }
            while (s5 !== peg$FAILED) {
              s4.push(s5);
              s5 = peg$currPos;
              if (input.charCodeAt(peg$currPos) === 40) {
                s6 = peg$c34;
                peg$currPos++;
              } else {
                s6 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c35); }
              }
              if (s6 !== peg$FAILED) {
                s7 = [];
                s8 = peg$parseBindingValue();
                if (s8 !== peg$FAILED) {
                  while (s8 !== peg$FAILED) {
                    s7.push(s8);
                    s8 = peg$parseBindingValue();
                  }
                } else {
                  s7 = peg$FAILED;
                }
                if (s7 !== peg$FAILED) {
                  if (input.charCodeAt(peg$currPos) === 41) {
                    s8 = peg$c40;
                    peg$currPos++;
                  } else {
                    s8 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$c41); }
                  }
                  if (s8 !== peg$FAILED) {
                    s6 = [s6, s7, s8];
                    s5 = s6;
                  } else {
                    peg$currPos = s5;
                    s5 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s5;
                  s5 = peg$FAILED;
                }
              } else {
                peg$currPos = s5;
                s5 = peg$FAILED;
              }
              if (s5 === peg$FAILED) {
                s5 = peg$parseNIL();
              }
            }
            if (s4 !== peg$FAILED) {
              if (input.charCodeAt(peg$currPos) === 125) {
                s5 = peg$c57;
                peg$currPos++;
              } else {
                s5 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c58); }
              }
              if (s5 !== peg$FAILED) {
                s1 = [s1, s2, s3, s4, s5];
                s0 = s1;
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      if (s0 === peg$FAILED) {
        s0 = null;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c138); }
      }

      return s0;
    }

    function peg$parseBindingValue() {
      var s0, s1;

      peg$silentFails++;
      s0 = peg$parseIRIref();
      if (s0 === peg$FAILED) {
        s0 = peg$parseRDFLiteral();
        if (s0 === peg$FAILED) {
          s0 = peg$parseNumericLiteral();
          if (s0 === peg$FAILED) {
            s0 = peg$parseBooleanLiteral();
            if (s0 === peg$FAILED) {
              if (input.substr(peg$currPos, 5) === peg$c142) {
                s0 = peg$c142;
                peg$currPos += 5;
              } else {
                s0 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c143); }
              }
            }
          }
        }
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c141); }
      }

      return s0;
    }

    function peg$parseValuesClause() {
      var s0, s1, s2, s3;

      peg$silentFails++;
      s0 = peg$currPos;
      s1 = peg$currPos;
      if (input.substr(peg$currPos, 6) === peg$c145) {
        s2 = peg$c145;
        peg$currPos += 6;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c146); }
      }
      if (s2 === peg$FAILED) {
        if (input.substr(peg$currPos, 6) === peg$c147) {
          s2 = peg$c147;
          peg$currPos += 6;
        } else {
          s2 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c148); }
        }
      }
      if (s2 !== peg$FAILED) {
        s3 = peg$parseDataBlock();
        if (s3 !== peg$FAILED) {
          s2 = [s2, s3];
          s1 = s2;
        } else {
          peg$currPos = s1;
          s1 = peg$FAILED;
        }
      } else {
        peg$currPos = s1;
        s1 = peg$FAILED;
      }
      if (s1 === peg$FAILED) {
        s1 = null;
      }
      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$c149(s1);
      }
      s0 = s1;
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c144); }
      }

      return s0;
    }

    function peg$parseUpdateUnit() {
      var s0, s1;

      peg$silentFails++;
      s0 = peg$parseUpdate();
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c150); }
      }

      return s0;
    }

    function peg$parseUpdate() {
      var s0, s1, s2, s3, s4, s5, s6, s7, s8;

      peg$silentFails++;
      s0 = peg$currPos;
      s1 = peg$parsePrologue();
      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$parseWS();
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parseWS();
        }
        if (s2 !== peg$FAILED) {
          s3 = peg$parseUpdate1();
          if (s3 !== peg$FAILED) {
            s4 = peg$currPos;
            s5 = [];
            s6 = peg$parseWS();
            while (s6 !== peg$FAILED) {
              s5.push(s6);
              s6 = peg$parseWS();
            }
            if (s5 !== peg$FAILED) {
              if (input.charCodeAt(peg$currPos) === 59) {
                s6 = peg$c152;
                peg$currPos++;
              } else {
                s6 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c153); }
              }
              if (s6 !== peg$FAILED) {
                s7 = [];
                s8 = peg$parseWS();
                while (s8 !== peg$FAILED) {
                  s7.push(s8);
                  s8 = peg$parseWS();
                }
                if (s7 !== peg$FAILED) {
                  s8 = peg$parseUpdate();
                  if (s8 === peg$FAILED) {
                    s8 = null;
                  }
                  if (s8 !== peg$FAILED) {
                    s5 = [s5, s6, s7, s8];
                    s4 = s5;
                  } else {
                    peg$currPos = s4;
                    s4 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s4;
                  s4 = peg$FAILED;
                }
              } else {
                peg$currPos = s4;
                s4 = peg$FAILED;
              }
            } else {
              peg$currPos = s4;
              s4 = peg$FAILED;
            }
            if (s4 === peg$FAILED) {
              s4 = null;
            }
            if (s4 !== peg$FAILED) {
              peg$savedPos = s0;
              s1 = peg$c154(s1, s3, s4);
              s0 = s1;
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c151); }
      }

      return s0;
    }

    function peg$parseUpdate1() {
      var s0, s1;

      peg$silentFails++;
      s0 = peg$parseLoad();
      if (s0 === peg$FAILED) {
        s0 = peg$parseClear();
        if (s0 === peg$FAILED) {
          s0 = peg$parseDrop();
          if (s0 === peg$FAILED) {
            s0 = peg$parseCreate();
            if (s0 === peg$FAILED) {
              s0 = peg$parseInsertData();
              if (s0 === peg$FAILED) {
                s0 = peg$parseDeleteData();
                if (s0 === peg$FAILED) {
                  s0 = peg$parseDeleteWhere();
                  if (s0 === peg$FAILED) {
                    s0 = peg$parseModify();
                  }
                }
              }
            }
          }
        }
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c155); }
      }

      return s0;
    }

    function peg$parseLoad() {
      var s0, s1, s2, s3, s4, s5, s6, s7, s8;

      peg$silentFails++;
      s0 = peg$currPos;
      if (input.substr(peg$currPos, 4) === peg$c157) {
        s1 = peg$c157;
        peg$currPos += 4;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c158); }
      }
      if (s1 === peg$FAILED) {
        if (input.substr(peg$currPos, 4) === peg$c159) {
          s1 = peg$c159;
          peg$currPos += 4;
        } else {
          s1 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c160); }
        }
      }
      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$parseWS();
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parseWS();
        }
        if (s2 !== peg$FAILED) {
          s3 = peg$parseIRIref();
          if (s3 !== peg$FAILED) {
            s4 = [];
            s5 = peg$parseWS();
            while (s5 !== peg$FAILED) {
              s4.push(s5);
              s5 = peg$parseWS();
            }
            if (s4 !== peg$FAILED) {
              s5 = peg$currPos;
              if (input.substr(peg$currPos, 4) === peg$c161) {
                s6 = peg$c161;
                peg$currPos += 4;
              } else {
                s6 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c162); }
              }
              if (s6 === peg$FAILED) {
                if (input.substr(peg$currPos, 4) === peg$c163) {
                  s6 = peg$c163;
                  peg$currPos += 4;
                } else {
                  s6 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c164); }
                }
              }
              if (s6 !== peg$FAILED) {
                s7 = [];
                s8 = peg$parseWS();
                while (s8 !== peg$FAILED) {
                  s7.push(s8);
                  s8 = peg$parseWS();
                }
                if (s7 !== peg$FAILED) {
                  s8 = peg$parseGraphRef();
                  if (s8 !== peg$FAILED) {
                    s6 = [s6, s7, s8];
                    s5 = s6;
                  } else {
                    peg$currPos = s5;
                    s5 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s5;
                  s5 = peg$FAILED;
                }
              } else {
                peg$currPos = s5;
                s5 = peg$FAILED;
              }
              if (s5 === peg$FAILED) {
                s5 = null;
              }
              if (s5 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c165(s3, s5);
                s0 = s1;
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c156); }
      }

      return s0;
    }

    function peg$parseClear() {
      var s0, s1, s2, s3, s4, s5;

      peg$silentFails++;
      s0 = peg$currPos;
      if (input.substr(peg$currPos, 5) === peg$c167) {
        s1 = peg$c167;
        peg$currPos += 5;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c168); }
      }
      if (s1 === peg$FAILED) {
        if (input.substr(peg$currPos, 5) === peg$c169) {
          s1 = peg$c169;
          peg$currPos += 5;
        } else {
          s1 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c170); }
        }
      }
      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$parseWS();
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parseWS();
        }
        if (s2 !== peg$FAILED) {
          if (input.substr(peg$currPos, 6) === peg$c171) {
            s3 = peg$c171;
            peg$currPos += 6;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c172); }
          }
          if (s3 === peg$FAILED) {
            if (input.substr(peg$currPos, 6) === peg$c173) {
              s3 = peg$c173;
              peg$currPos += 6;
            } else {
              s3 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c174); }
            }
          }
          if (s3 === peg$FAILED) {
            s3 = null;
          }
          if (s3 !== peg$FAILED) {
            s4 = [];
            s5 = peg$parseWS();
            while (s5 !== peg$FAILED) {
              s4.push(s5);
              s5 = peg$parseWS();
            }
            if (s4 !== peg$FAILED) {
              s5 = peg$parseGraphRefAll();
              if (s5 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c175(s5);
                s0 = s1;
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c166); }
      }

      return s0;
    }

    function peg$parseDrop() {
      var s0, s1, s2, s3, s4, s5;

      peg$silentFails++;
      s0 = peg$currPos;
      if (input.substr(peg$currPos, 4) === peg$c177) {
        s1 = peg$c177;
        peg$currPos += 4;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c178); }
      }
      if (s1 === peg$FAILED) {
        if (input.substr(peg$currPos, 4) === peg$c179) {
          s1 = peg$c179;
          peg$currPos += 4;
        } else {
          s1 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c180); }
        }
      }
      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$parseWS();
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parseWS();
        }
        if (s2 !== peg$FAILED) {
          if (input.substr(peg$currPos, 6) === peg$c171) {
            s3 = peg$c171;
            peg$currPos += 6;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c172); }
          }
          if (s3 === peg$FAILED) {
            if (input.substr(peg$currPos, 6) === peg$c173) {
              s3 = peg$c173;
              peg$currPos += 6;
            } else {
              s3 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c174); }
            }
          }
          if (s3 === peg$FAILED) {
            s3 = null;
          }
          if (s3 !== peg$FAILED) {
            s4 = [];
            s5 = peg$parseWS();
            while (s5 !== peg$FAILED) {
              s4.push(s5);
              s5 = peg$parseWS();
            }
            if (s4 !== peg$FAILED) {
              s5 = peg$parseGraphRefAll();
              if (s5 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c181(s5);
                s0 = s1;
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c176); }
      }

      return s0;
    }

    function peg$parseCreate() {
      var s0, s1, s2, s3, s4, s5;

      peg$silentFails++;
      s0 = peg$currPos;
      if (input.substr(peg$currPos, 6) === peg$c183) {
        s1 = peg$c183;
        peg$currPos += 6;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c184); }
      }
      if (s1 === peg$FAILED) {
        if (input.substr(peg$currPos, 6) === peg$c185) {
          s1 = peg$c185;
          peg$currPos += 6;
        } else {
          s1 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c186); }
        }
      }
      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$parseWS();
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parseWS();
        }
        if (s2 !== peg$FAILED) {
          if (input.substr(peg$currPos, 6) === peg$c171) {
            s3 = peg$c171;
            peg$currPos += 6;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c172); }
          }
          if (s3 === peg$FAILED) {
            if (input.substr(peg$currPos, 6) === peg$c173) {
              s3 = peg$c173;
              peg$currPos += 6;
            } else {
              s3 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c174); }
            }
          }
          if (s3 === peg$FAILED) {
            s3 = null;
          }
          if (s3 !== peg$FAILED) {
            s4 = [];
            s5 = peg$parseWS();
            while (s5 !== peg$FAILED) {
              s4.push(s5);
              s5 = peg$parseWS();
            }
            if (s4 !== peg$FAILED) {
              s5 = peg$parseGraphRef();
              if (s5 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c187(s5);
                s0 = s1;
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c182); }
      }

      return s0;
    }

    function peg$parseInsertData() {
      var s0, s1, s2, s3, s4, s5;

      peg$silentFails++;
      s0 = peg$currPos;
      if (input.substr(peg$currPos, 6) === peg$c189) {
        s1 = peg$c189;
        peg$currPos += 6;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c190); }
      }
      if (s1 === peg$FAILED) {
        if (input.substr(peg$currPos, 6) === peg$c191) {
          s1 = peg$c191;
          peg$currPos += 6;
        } else {
          s1 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c192); }
        }
      }
      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$parseWS();
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parseWS();
        }
        if (s2 !== peg$FAILED) {
          if (input.substr(peg$currPos, 4) === peg$c193) {
            s3 = peg$c193;
            peg$currPos += 4;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c194); }
          }
          if (s3 === peg$FAILED) {
            if (input.substr(peg$currPos, 4) === peg$c195) {
              s3 = peg$c195;
              peg$currPos += 4;
            } else {
              s3 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c196); }
            }
          }
          if (s3 !== peg$FAILED) {
            s4 = [];
            s5 = peg$parseWS();
            while (s5 !== peg$FAILED) {
              s4.push(s5);
              s5 = peg$parseWS();
            }
            if (s4 !== peg$FAILED) {
              s5 = peg$parseQuadData();
              if (s5 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c197(s5);
                s0 = s1;
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c188); }
      }

      return s0;
    }

    function peg$parseDeleteData() {
      var s0, s1, s2, s3, s4;

      peg$silentFails++;
      s0 = peg$currPos;
      if (input.substr(peg$currPos, 6) === peg$c199) {
        s1 = peg$c199;
        peg$currPos += 6;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c200); }
      }
      if (s1 === peg$FAILED) {
        if (input.substr(peg$currPos, 6) === peg$c201) {
          s1 = peg$c201;
          peg$currPos += 6;
        } else {
          s1 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c202); }
        }
      }
      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$parseWS();
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parseWS();
        }
        if (s2 !== peg$FAILED) {
          if (input.substr(peg$currPos, 4) === peg$c193) {
            s3 = peg$c193;
            peg$currPos += 4;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c194); }
          }
          if (s3 === peg$FAILED) {
            if (input.substr(peg$currPos, 4) === peg$c195) {
              s3 = peg$c195;
              peg$currPos += 4;
            } else {
              s3 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c196); }
            }
          }
          if (s3 !== peg$FAILED) {
            s4 = peg$parseQuadData();
            if (s4 !== peg$FAILED) {
              peg$savedPos = s0;
              s1 = peg$c203(s4);
              s0 = s1;
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c198); }
      }

      return s0;
    }

    function peg$parseDeleteWhere() {
      var s0, s1, s2, s3, s4, s5;

      peg$silentFails++;
      s0 = peg$currPos;
      if (input.substr(peg$currPos, 6) === peg$c199) {
        s1 = peg$c199;
        peg$currPos += 6;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c200); }
      }
      if (s1 === peg$FAILED) {
        if (input.substr(peg$currPos, 6) === peg$c201) {
          s1 = peg$c201;
          peg$currPos += 6;
        } else {
          s1 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c202); }
        }
      }
      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$parseWS();
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parseWS();
        }
        if (s2 !== peg$FAILED) {
          if (input.substr(peg$currPos, 5) === peg$c51) {
            s3 = peg$c51;
            peg$currPos += 5;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c52); }
          }
          if (s3 === peg$FAILED) {
            if (input.substr(peg$currPos, 5) === peg$c53) {
              s3 = peg$c53;
              peg$currPos += 5;
            } else {
              s3 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c54); }
            }
          }
          if (s3 !== peg$FAILED) {
            s4 = [];
            s5 = peg$parseWS();
            while (s5 !== peg$FAILED) {
              s4.push(s5);
              s5 = peg$parseWS();
            }
            if (s4 !== peg$FAILED) {
              s5 = peg$parseGroupGraphPattern();
              if (s5 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c205(s5);
                s0 = s1;
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c204); }
      }

      return s0;
    }

    function peg$parseModify() {
      var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11;

      peg$silentFails++;
      s0 = peg$currPos;
      s1 = peg$currPos;
      if (input.substr(peg$currPos, 4) === peg$c207) {
        s2 = peg$c207;
        peg$currPos += 4;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c208); }
      }
      if (s2 === peg$FAILED) {
        if (input.substr(peg$currPos, 4) === peg$c209) {
          s2 = peg$c209;
          peg$currPos += 4;
        } else {
          s2 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c210); }
        }
      }
      if (s2 !== peg$FAILED) {
        s3 = [];
        s4 = peg$parseWS();
        while (s4 !== peg$FAILED) {
          s3.push(s4);
          s4 = peg$parseWS();
        }
        if (s3 !== peg$FAILED) {
          s4 = peg$parseIRIref();
          if (s4 !== peg$FAILED) {
            s2 = [s2, s3, s4];
            s1 = s2;
          } else {
            peg$currPos = s1;
            s1 = peg$FAILED;
          }
        } else {
          peg$currPos = s1;
          s1 = peg$FAILED;
        }
      } else {
        peg$currPos = s1;
        s1 = peg$FAILED;
      }
      if (s1 === peg$FAILED) {
        s1 = null;
      }
      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$parseWS();
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parseWS();
        }
        if (s2 !== peg$FAILED) {
          s3 = peg$currPos;
          s4 = peg$parseDeleteClause();
          if (s4 !== peg$FAILED) {
            s5 = [];
            s6 = peg$parseWS();
            while (s6 !== peg$FAILED) {
              s5.push(s6);
              s6 = peg$parseWS();
            }
            if (s5 !== peg$FAILED) {
              s6 = peg$parseInsertClause();
              if (s6 === peg$FAILED) {
                s6 = null;
              }
              if (s6 !== peg$FAILED) {
                s4 = [s4, s5, s6];
                s3 = s4;
              } else {
                peg$currPos = s3;
                s3 = peg$FAILED;
              }
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
          if (s3 === peg$FAILED) {
            s3 = peg$parseInsertClause();
          }
          if (s3 !== peg$FAILED) {
            s4 = [];
            s5 = peg$parseWS();
            while (s5 !== peg$FAILED) {
              s4.push(s5);
              s5 = peg$parseWS();
            }
            if (s4 !== peg$FAILED) {
              s5 = [];
              s6 = peg$parseUsingClause();
              while (s6 !== peg$FAILED) {
                s5.push(s6);
                s6 = peg$parseUsingClause();
              }
              if (s5 !== peg$FAILED) {
                s6 = [];
                s7 = peg$parseWS();
                while (s7 !== peg$FAILED) {
                  s6.push(s7);
                  s7 = peg$parseWS();
                }
                if (s6 !== peg$FAILED) {
                  if (input.substr(peg$currPos, 5) === peg$c51) {
                    s7 = peg$c51;
                    peg$currPos += 5;
                  } else {
                    s7 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$c52); }
                  }
                  if (s7 === peg$FAILED) {
                    if (input.substr(peg$currPos, 5) === peg$c53) {
                      s7 = peg$c53;
                      peg$currPos += 5;
                    } else {
                      s7 = peg$FAILED;
                      if (peg$silentFails === 0) { peg$fail(peg$c54); }
                    }
                  }
                  if (s7 !== peg$FAILED) {
                    s8 = [];
                    s9 = peg$parseWS();
                    while (s9 !== peg$FAILED) {
                      s8.push(s9);
                      s9 = peg$parseWS();
                    }
                    if (s8 !== peg$FAILED) {
                      s9 = peg$parseGroupGraphPattern();
                      if (s9 !== peg$FAILED) {
                        s10 = [];
                        s11 = peg$parseWS();
                        while (s11 !== peg$FAILED) {
                          s10.push(s11);
                          s11 = peg$parseWS();
                        }
                        if (s10 !== peg$FAILED) {
                          peg$savedPos = s0;
                          s1 = peg$c211(s1, s3, s5, s9);
                          s0 = s1;
                        } else {
                          peg$currPos = s0;
                          s0 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s0;
                        s0 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s0;
                      s0 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c206); }
      }

      return s0;
    }

    function peg$parseDeleteClause() {
      var s0, s1, s2;

      peg$silentFails++;
      s0 = peg$currPos;
      if (input.substr(peg$currPos, 6) === peg$c199) {
        s1 = peg$c199;
        peg$currPos += 6;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c200); }
      }
      if (s1 === peg$FAILED) {
        if (input.substr(peg$currPos, 6) === peg$c201) {
          s1 = peg$c201;
          peg$currPos += 6;
        } else {
          s1 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c202); }
        }
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parseQuadPattern();
        if (s2 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c213(s2);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c212); }
      }

      return s0;
    }

    function peg$parseInsertClause() {
      var s0, s1, s2;

      peg$silentFails++;
      s0 = peg$currPos;
      if (input.substr(peg$currPos, 6) === peg$c189) {
        s1 = peg$c189;
        peg$currPos += 6;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c190); }
      }
      if (s1 === peg$FAILED) {
        if (input.substr(peg$currPos, 6) === peg$c191) {
          s1 = peg$c191;
          peg$currPos += 6;
        } else {
          s1 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c192); }
        }
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parseQuadPattern();
        if (s2 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c213(s2);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c214); }
      }

      return s0;
    }

    function peg$parseUsingClause() {
      var s0, s1, s2, s3, s4, s5, s6, s7;

      peg$silentFails++;
      s0 = peg$currPos;
      s1 = [];
      s2 = peg$parseWS();
      while (s2 !== peg$FAILED) {
        s1.push(s2);
        s2 = peg$parseWS();
      }
      if (s1 !== peg$FAILED) {
        if (input.substr(peg$currPos, 5) === peg$c216) {
          s2 = peg$c216;
          peg$currPos += 5;
        } else {
          s2 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c217); }
        }
        if (s2 === peg$FAILED) {
          if (input.substr(peg$currPos, 5) === peg$c218) {
            s2 = peg$c218;
            peg$currPos += 5;
          } else {
            s2 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c219); }
          }
        }
        if (s2 !== peg$FAILED) {
          s3 = [];
          s4 = peg$parseWS();
          while (s4 !== peg$FAILED) {
            s3.push(s4);
            s4 = peg$parseWS();
          }
          if (s3 !== peg$FAILED) {
            s4 = peg$parseIRIref();
            if (s4 === peg$FAILED) {
              s4 = peg$currPos;
              if (input.substr(peg$currPos, 5) === peg$c78) {
                s5 = peg$c78;
                peg$currPos += 5;
              } else {
                s5 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c79); }
              }
              if (s5 === peg$FAILED) {
                if (input.substr(peg$currPos, 5) === peg$c80) {
                  s5 = peg$c80;
                  peg$currPos += 5;
                } else {
                  s5 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c81); }
                }
              }
              if (s5 !== peg$FAILED) {
                s6 = [];
                s7 = peg$parseWS();
                while (s7 !== peg$FAILED) {
                  s6.push(s7);
                  s7 = peg$parseWS();
                }
                if (s6 !== peg$FAILED) {
                  s7 = peg$parseIRIref();
                  if (s7 !== peg$FAILED) {
                    s5 = [s5, s6, s7];
                    s4 = s5;
                  } else {
                    peg$currPos = s4;
                    s4 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s4;
                  s4 = peg$FAILED;
                }
              } else {
                peg$currPos = s4;
                s4 = peg$FAILED;
              }
            }
            if (s4 !== peg$FAILED) {
              peg$savedPos = s0;
              s1 = peg$c220(s4);
              s0 = s1;
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c215); }
      }

      return s0;
    }

    function peg$parseGraphRef() {
      var s0, s1, s2, s3;

      peg$silentFails++;
      s0 = peg$currPos;
      if (input.substr(peg$currPos, 5) === peg$c222) {
        s1 = peg$c222;
        peg$currPos += 5;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c223); }
      }
      if (s1 === peg$FAILED) {
        if (input.substr(peg$currPos, 5) === peg$c224) {
          s1 = peg$c224;
          peg$currPos += 5;
        } else {
          s1 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c225); }
        }
      }
      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$parseWS();
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parseWS();
        }
        if (s2 !== peg$FAILED) {
          s3 = peg$parseIRIref();
          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c226(s3);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c221); }
      }

      return s0;
    }

    function peg$parseGraphRefAll() {
      var s0, s1;

      peg$silentFails++;
      s0 = peg$currPos;
      s1 = peg$parseGraphRef();
      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$c85(s1);
      }
      s0 = s1;
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        if (input.substr(peg$currPos, 7) === peg$c228) {
          s1 = peg$c228;
          peg$currPos += 7;
        } else {
          s1 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c229); }
        }
        if (s1 === peg$FAILED) {
          if (input.substr(peg$currPos, 7) === peg$c230) {
            s1 = peg$c230;
            peg$currPos += 7;
          } else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c231); }
          }
        }
        if (s1 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c232();
        }
        s0 = s1;
        if (s0 === peg$FAILED) {
          s0 = peg$currPos;
          if (input.substr(peg$currPos, 5) === peg$c78) {
            s1 = peg$c78;
            peg$currPos += 5;
          } else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c79); }
          }
          if (s1 === peg$FAILED) {
            if (input.substr(peg$currPos, 5) === peg$c80) {
              s1 = peg$c80;
              peg$currPos += 5;
            } else {
              s1 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c81); }
            }
          }
          if (s1 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c233();
          }
          s0 = s1;
          if (s0 === peg$FAILED) {
            s0 = peg$currPos;
            if (input.substr(peg$currPos, 3) === peg$c234) {
              s1 = peg$c234;
              peg$currPos += 3;
            } else {
              s1 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c235); }
            }
            if (s1 === peg$FAILED) {
              if (input.substr(peg$currPos, 3) === peg$c236) {
                s1 = peg$c236;
                peg$currPos += 3;
              } else {
                s1 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c237); }
              }
            }
            if (s1 !== peg$FAILED) {
              peg$savedPos = s0;
              s1 = peg$c238();
            }
            s0 = s1;
          }
        }
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c227); }
      }

      return s0;
    }

    function peg$parseQuadPattern() {
      var s0, s1, s2, s3, s4, s5, s6, s7, s8;

      peg$silentFails++;
      s0 = peg$currPos;
      s1 = [];
      s2 = peg$parseWS();
      while (s2 !== peg$FAILED) {
        s1.push(s2);
        s2 = peg$parseWS();
      }
      if (s1 !== peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 123) {
          s2 = peg$c55;
          peg$currPos++;
        } else {
          s2 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c56); }
        }
        if (s2 !== peg$FAILED) {
          s3 = [];
          s4 = peg$parseWS();
          while (s4 !== peg$FAILED) {
            s3.push(s4);
            s4 = peg$parseWS();
          }
          if (s3 !== peg$FAILED) {
            s4 = peg$parseQuads();
            if (s4 !== peg$FAILED) {
              s5 = [];
              s6 = peg$parseWS();
              while (s6 !== peg$FAILED) {
                s5.push(s6);
                s6 = peg$parseWS();
              }
              if (s5 !== peg$FAILED) {
                if (input.charCodeAt(peg$currPos) === 125) {
                  s6 = peg$c57;
                  peg$currPos++;
                } else {
                  s6 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c58); }
                }
                if (s6 !== peg$FAILED) {
                  s7 = [];
                  s8 = peg$parseWS();
                  while (s8 !== peg$FAILED) {
                    s7.push(s8);
                    s8 = peg$parseWS();
                  }
                  if (s7 !== peg$FAILED) {
                    peg$savedPos = s0;
                    s1 = peg$c240(s4);
                    s0 = s1;
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c239); }
      }

      return s0;
    }

    function peg$parseQuadData() {
      var s0, s1, s2, s3, s4, s5, s6, s7, s8;

      peg$silentFails++;
      s0 = peg$currPos;
      s1 = [];
      s2 = peg$parseWS();
      while (s2 !== peg$FAILED) {
        s1.push(s2);
        s2 = peg$parseWS();
      }
      if (s1 !== peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 123) {
          s2 = peg$c55;
          peg$currPos++;
        } else {
          s2 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c56); }
        }
        if (s2 !== peg$FAILED) {
          s3 = [];
          s4 = peg$parseWS();
          while (s4 !== peg$FAILED) {
            s3.push(s4);
            s4 = peg$parseWS();
          }
          if (s3 !== peg$FAILED) {
            s4 = peg$parseQuads();
            if (s4 !== peg$FAILED) {
              s5 = [];
              s6 = peg$parseWS();
              while (s6 !== peg$FAILED) {
                s5.push(s6);
                s6 = peg$parseWS();
              }
              if (s5 !== peg$FAILED) {
                if (input.charCodeAt(peg$currPos) === 125) {
                  s6 = peg$c57;
                  peg$currPos++;
                } else {
                  s6 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c58); }
                }
                if (s6 !== peg$FAILED) {
                  s7 = [];
                  s8 = peg$parseWS();
                  while (s8 !== peg$FAILED) {
                    s7.push(s8);
                    s8 = peg$parseWS();
                  }
                  if (s7 !== peg$FAILED) {
                    peg$savedPos = s0;
                    s1 = peg$c240(s4);
                    s0 = s1;
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c241); }
      }

      return s0;
    }

    function peg$parseQuads() {
      var s0, s1, s2, s3, s4, s5, s6;

      peg$silentFails++;
      s0 = peg$currPos;
      s1 = peg$parseTriplesTemplate();
      if (s1 === peg$FAILED) {
        s1 = null;
      }
      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$currPos;
        s4 = peg$parseQuadsNotTriples();
        if (s4 !== peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 46) {
            s5 = peg$c243;
            peg$currPos++;
          } else {
            s5 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c244); }
          }
          if (s5 === peg$FAILED) {
            s5 = null;
          }
          if (s5 !== peg$FAILED) {
            s6 = peg$parseTriplesTemplate();
            if (s6 === peg$FAILED) {
              s6 = null;
            }
            if (s6 !== peg$FAILED) {
              s4 = [s4, s5, s6];
              s3 = s4;
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$currPos;
          s4 = peg$parseQuadsNotTriples();
          if (s4 !== peg$FAILED) {
            if (input.charCodeAt(peg$currPos) === 46) {
              s5 = peg$c243;
              peg$currPos++;
            } else {
              s5 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c244); }
            }
            if (s5 === peg$FAILED) {
              s5 = null;
            }
            if (s5 !== peg$FAILED) {
              s6 = peg$parseTriplesTemplate();
              if (s6 === peg$FAILED) {
                s6 = null;
              }
              if (s6 !== peg$FAILED) {
                s4 = [s4, s5, s6];
                s3 = s4;
              } else {
                peg$currPos = s3;
                s3 = peg$FAILED;
              }
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        }
        if (s2 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c245(s1, s2);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c242); }
      }

      return s0;
    }

    function peg$parseQuadsNotTriples() {
      var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12;

      peg$silentFails++;
      s0 = peg$currPos;
      s1 = [];
      s2 = peg$parseWS();
      while (s2 !== peg$FAILED) {
        s1.push(s2);
        s2 = peg$parseWS();
      }
      if (s1 !== peg$FAILED) {
        if (input.substr(peg$currPos, 5) === peg$c222) {
          s2 = peg$c222;
          peg$currPos += 5;
        } else {
          s2 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c223); }
        }
        if (s2 === peg$FAILED) {
          if (input.substr(peg$currPos, 5) === peg$c224) {
            s2 = peg$c224;
            peg$currPos += 5;
          } else {
            s2 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c225); }
          }
        }
        if (s2 !== peg$FAILED) {
          s3 = [];
          s4 = peg$parseWS();
          while (s4 !== peg$FAILED) {
            s3.push(s4);
            s4 = peg$parseWS();
          }
          if (s3 !== peg$FAILED) {
            s4 = peg$parseVarOrIRIref();
            if (s4 !== peg$FAILED) {
              s5 = [];
              s6 = peg$parseWS();
              while (s6 !== peg$FAILED) {
                s5.push(s6);
                s6 = peg$parseWS();
              }
              if (s5 !== peg$FAILED) {
                if (input.charCodeAt(peg$currPos) === 123) {
                  s6 = peg$c55;
                  peg$currPos++;
                } else {
                  s6 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c56); }
                }
                if (s6 !== peg$FAILED) {
                  s7 = [];
                  s8 = peg$parseWS();
                  while (s8 !== peg$FAILED) {
                    s7.push(s8);
                    s8 = peg$parseWS();
                  }
                  if (s7 !== peg$FAILED) {
                    s8 = peg$parseTriplesTemplate();
                    if (s8 === peg$FAILED) {
                      s8 = null;
                    }
                    if (s8 !== peg$FAILED) {
                      s9 = [];
                      s10 = peg$parseWS();
                      while (s10 !== peg$FAILED) {
                        s9.push(s10);
                        s10 = peg$parseWS();
                      }
                      if (s9 !== peg$FAILED) {
                        if (input.charCodeAt(peg$currPos) === 125) {
                          s10 = peg$c57;
                          peg$currPos++;
                        } else {
                          s10 = peg$FAILED;
                          if (peg$silentFails === 0) { peg$fail(peg$c58); }
                        }
                        if (s10 !== peg$FAILED) {
                          s11 = [];
                          s12 = peg$parseWS();
                          while (s12 !== peg$FAILED) {
                            s11.push(s12);
                            s12 = peg$parseWS();
                          }
                          if (s11 !== peg$FAILED) {
                            peg$savedPos = s0;
                            s1 = peg$c247(s4, s8);
                            s0 = s1;
                          } else {
                            peg$currPos = s0;
                            s0 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s0;
                          s0 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s0;
                        s0 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s0;
                      s0 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c246); }
      }

      return s0;
    }

    function peg$parseTriplesTemplate() {
      var s0, s1, s2, s3, s4, s5, s6;

      peg$silentFails++;
      s0 = peg$currPos;
      s1 = peg$parseTriplesSameSubject();
      if (s1 !== peg$FAILED) {
        s2 = peg$currPos;
        s3 = [];
        s4 = peg$parseWS();
        while (s4 !== peg$FAILED) {
          s3.push(s4);
          s4 = peg$parseWS();
        }
        if (s3 !== peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 46) {
            s4 = peg$c243;
            peg$currPos++;
          } else {
            s4 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c244); }
          }
          if (s4 !== peg$FAILED) {
            s5 = [];
            s6 = peg$parseWS();
            while (s6 !== peg$FAILED) {
              s5.push(s6);
              s6 = peg$parseWS();
            }
            if (s5 !== peg$FAILED) {
              s6 = peg$parseTriplesTemplate();
              if (s6 === peg$FAILED) {
                s6 = null;
              }
              if (s6 !== peg$FAILED) {
                s3 = [s3, s4, s5, s6];
                s2 = s3;
              } else {
                peg$currPos = s2;
                s2 = peg$FAILED;
              }
            } else {
              peg$currPos = s2;
              s2 = peg$FAILED;
            }
          } else {
            peg$currPos = s2;
            s2 = peg$FAILED;
          }
        } else {
          peg$currPos = s2;
          s2 = peg$FAILED;
        }
        if (s2 === peg$FAILED) {
          s2 = null;
        }
        if (s2 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c249(s1, s2);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c248); }
      }

      return s0;
    }

    function peg$parseGroupGraphPattern() {
      var s0, s1, s2, s3, s4, s5;

      peg$silentFails++;
      s0 = peg$currPos;
      if (input.charCodeAt(peg$currPos) === 123) {
        s1 = peg$c55;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c56); }
      }
      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$parseWS();
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parseWS();
        }
        if (s2 !== peg$FAILED) {
          s3 = peg$parseSubSelect();
          if (s3 !== peg$FAILED) {
            s4 = [];
            s5 = peg$parseWS();
            while (s5 !== peg$FAILED) {
              s4.push(s5);
              s5 = peg$parseWS();
            }
            if (s4 !== peg$FAILED) {
              if (input.charCodeAt(peg$currPos) === 125) {
                s5 = peg$c57;
                peg$currPos++;
              } else {
                s5 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c58); }
              }
              if (s5 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c251(s3);
                s0 = s1;
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        if (input.charCodeAt(peg$currPos) === 123) {
          s1 = peg$c55;
          peg$currPos++;
        } else {
          s1 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c56); }
        }
        if (s1 !== peg$FAILED) {
          s2 = [];
          s3 = peg$parseWS();
          while (s3 !== peg$FAILED) {
            s2.push(s3);
            s3 = peg$parseWS();
          }
          if (s2 !== peg$FAILED) {
            s3 = peg$parseGroupGraphPatternSub();
            if (s3 !== peg$FAILED) {
              s4 = [];
              s5 = peg$parseWS();
              while (s5 !== peg$FAILED) {
                s4.push(s5);
                s5 = peg$parseWS();
              }
              if (s4 !== peg$FAILED) {
                if (input.charCodeAt(peg$currPos) === 125) {
                  s5 = peg$c57;
                  peg$currPos++;
                } else {
                  s5 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c58); }
                }
                if (s5 !== peg$FAILED) {
                  peg$savedPos = s0;
                  s1 = peg$c251(s3);
                  s0 = s1;
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c250); }
      }

      return s0;
    }

    function peg$parseGroupGraphPatternSub() {
      var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9;

      peg$silentFails++;
      s0 = peg$currPos;
      s1 = peg$parseTriplesBlock();
      if (s1 === peg$FAILED) {
        s1 = null;
      }
      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$parseWS();
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parseWS();
        }
        if (s2 !== peg$FAILED) {
          s3 = [];
          s4 = peg$currPos;
          s5 = peg$parseGraphPatternNotTriples();
          if (s5 !== peg$FAILED) {
            s6 = [];
            s7 = peg$parseWS();
            while (s7 !== peg$FAILED) {
              s6.push(s7);
              s7 = peg$parseWS();
            }
            if (s6 !== peg$FAILED) {
              if (input.charCodeAt(peg$currPos) === 46) {
                s7 = peg$c243;
                peg$currPos++;
              } else {
                s7 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c244); }
              }
              if (s7 === peg$FAILED) {
                s7 = null;
              }
              if (s7 !== peg$FAILED) {
                s8 = [];
                s9 = peg$parseWS();
                while (s9 !== peg$FAILED) {
                  s8.push(s9);
                  s9 = peg$parseWS();
                }
                if (s8 !== peg$FAILED) {
                  s9 = peg$parseTriplesBlock();
                  if (s9 === peg$FAILED) {
                    s9 = null;
                  }
                  if (s9 !== peg$FAILED) {
                    s5 = [s5, s6, s7, s8, s9];
                    s4 = s5;
                  } else {
                    peg$currPos = s4;
                    s4 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s4;
                  s4 = peg$FAILED;
                }
              } else {
                peg$currPos = s4;
                s4 = peg$FAILED;
              }
            } else {
              peg$currPos = s4;
              s4 = peg$FAILED;
            }
          } else {
            peg$currPos = s4;
            s4 = peg$FAILED;
          }
          while (s4 !== peg$FAILED) {
            s3.push(s4);
            s4 = peg$currPos;
            s5 = peg$parseGraphPatternNotTriples();
            if (s5 !== peg$FAILED) {
              s6 = [];
              s7 = peg$parseWS();
              while (s7 !== peg$FAILED) {
                s6.push(s7);
                s7 = peg$parseWS();
              }
              if (s6 !== peg$FAILED) {
                if (input.charCodeAt(peg$currPos) === 46) {
                  s7 = peg$c243;
                  peg$currPos++;
                } else {
                  s7 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c244); }
                }
                if (s7 === peg$FAILED) {
                  s7 = null;
                }
                if (s7 !== peg$FAILED) {
                  s8 = [];
                  s9 = peg$parseWS();
                  while (s9 !== peg$FAILED) {
                    s8.push(s9);
                    s9 = peg$parseWS();
                  }
                  if (s8 !== peg$FAILED) {
                    s9 = peg$parseTriplesBlock();
                    if (s9 === peg$FAILED) {
                      s9 = null;
                    }
                    if (s9 !== peg$FAILED) {
                      s5 = [s5, s6, s7, s8, s9];
                      s4 = s5;
                    } else {
                      peg$currPos = s4;
                      s4 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s4;
                    s4 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s4;
                  s4 = peg$FAILED;
                }
              } else {
                peg$currPos = s4;
                s4 = peg$FAILED;
              }
            } else {
              peg$currPos = s4;
              s4 = peg$FAILED;
            }
          }
          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c253(s1, s3);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c252); }
      }

      return s0;
    }

    function peg$parseTriplesBlock() {
      var s0, s1, s2, s3, s4, s5;

      peg$silentFails++;
      s0 = peg$currPos;
      s1 = peg$parseTriplesSameSubjectPath();
      if (s1 !== peg$FAILED) {
        s2 = peg$currPos;
        s3 = [];
        s4 = peg$parseWS();
        while (s4 !== peg$FAILED) {
          s3.push(s4);
          s4 = peg$parseWS();
        }
        if (s3 !== peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 46) {
            s4 = peg$c243;
            peg$currPos++;
          } else {
            s4 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c244); }
          }
          if (s4 !== peg$FAILED) {
            s5 = peg$parseTriplesBlock();
            if (s5 === peg$FAILED) {
              s5 = null;
            }
            if (s5 !== peg$FAILED) {
              s3 = [s3, s4, s5];
              s2 = s3;
            } else {
              peg$currPos = s2;
              s2 = peg$FAILED;
            }
          } else {
            peg$currPos = s2;
            s2 = peg$FAILED;
          }
        } else {
          peg$currPos = s2;
          s2 = peg$FAILED;
        }
        if (s2 === peg$FAILED) {
          s2 = null;
        }
        if (s2 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c255(s1, s2);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c254); }
      }

      return s0;
    }

    function peg$parseGraphPatternNotTriples() {
      var s0, s1;

      peg$silentFails++;
      s0 = peg$parseGroupOrUnionGraphPattern();
      if (s0 === peg$FAILED) {
        s0 = peg$parseOptionalGraphPattern();
        if (s0 === peg$FAILED) {
          s0 = peg$parseMinusGraphPattern();
          if (s0 === peg$FAILED) {
            s0 = peg$parseGraphGraphPattern();
            if (s0 === peg$FAILED) {
              s0 = peg$parseServiceGraphPattern();
              if (s0 === peg$FAILED) {
                s0 = peg$parseFilter();
                if (s0 === peg$FAILED) {
                  s0 = peg$parseBind();
                  if (s0 === peg$FAILED) {
                    s0 = peg$parseInlineData();
                  }
                }
              }
            }
          }
        }
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c256); }
      }

      return s0;
    }

    function peg$parseOptionalGraphPattern() {
      var s0, s1, s2, s3, s4;

      peg$silentFails++;
      s0 = peg$currPos;
      s1 = [];
      s2 = peg$parseWS();
      while (s2 !== peg$FAILED) {
        s1.push(s2);
        s2 = peg$parseWS();
      }
      if (s1 !== peg$FAILED) {
        if (input.substr(peg$currPos, 8) === peg$c258) {
          s2 = peg$c258;
          peg$currPos += 8;
        } else {
          s2 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c259); }
        }
        if (s2 === peg$FAILED) {
          if (input.substr(peg$currPos, 8) === peg$c260) {
            s2 = peg$c260;
            peg$currPos += 8;
          } else {
            s2 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c261); }
          }
        }
        if (s2 !== peg$FAILED) {
          s3 = [];
          s4 = peg$parseWS();
          while (s4 !== peg$FAILED) {
            s3.push(s4);
            s4 = peg$parseWS();
          }
          if (s3 !== peg$FAILED) {
            s4 = peg$parseGroupGraphPattern();
            if (s4 !== peg$FAILED) {
              peg$savedPos = s0;
              s1 = peg$c262(s4);
              s0 = s1;
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c257); }
      }

      return s0;
    }

    function peg$parseGraphGraphPattern() {
      var s0, s1, s2, s3, s4, s5, s6;

      peg$silentFails++;
      s0 = peg$currPos;
      s1 = [];
      s2 = peg$parseWS();
      while (s2 !== peg$FAILED) {
        s1.push(s2);
        s2 = peg$parseWS();
      }
      if (s1 !== peg$FAILED) {
        if (input.substr(peg$currPos, 5) === peg$c222) {
          s2 = peg$c222;
          peg$currPos += 5;
        } else {
          s2 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c223); }
        }
        if (s2 === peg$FAILED) {
          if (input.substr(peg$currPos, 5) === peg$c224) {
            s2 = peg$c224;
            peg$currPos += 5;
          } else {
            s2 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c225); }
          }
        }
        if (s2 !== peg$FAILED) {
          s3 = [];
          s4 = peg$parseWS();
          while (s4 !== peg$FAILED) {
            s3.push(s4);
            s4 = peg$parseWS();
          }
          if (s3 !== peg$FAILED) {
            s4 = peg$parseVarOrIRIref();
            if (s4 !== peg$FAILED) {
              s5 = [];
              s6 = peg$parseWS();
              while (s6 !== peg$FAILED) {
                s5.push(s6);
                s6 = peg$parseWS();
              }
              if (s5 !== peg$FAILED) {
                s6 = peg$parseGroupGraphPattern();
                if (s6 !== peg$FAILED) {
                  peg$savedPos = s0;
                  s1 = peg$c264(s4, s6);
                  s0 = s1;
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c263); }
      }

      return s0;
    }

    function peg$parseServiceGraphPattern() {
      var s0, s1, s2, s3;

      peg$silentFails++;
      s0 = peg$currPos;
      if (input.substr(peg$currPos, 7) === peg$c266) {
        s1 = peg$c266;
        peg$currPos += 7;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c267); }
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parseVarOrIRIref();
        if (s2 !== peg$FAILED) {
          s3 = peg$parseGroupGraphPattern();
          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c268(s2, s3);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c265); }
      }

      return s0;
    }

    function peg$parseMinusGraphPattern() {
      var s0, s1, s2, s3;

      peg$silentFails++;
      s0 = peg$currPos;
      if (input.substr(peg$currPos, 5) === peg$c270) {
        s1 = peg$c270;
        peg$currPos += 5;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c271); }
      }
      if (s1 === peg$FAILED) {
        if (input.substr(peg$currPos, 5) === peg$c272) {
          s1 = peg$c272;
          peg$currPos += 5;
        } else {
          s1 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c273); }
        }
      }
      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$parseWS();
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parseWS();
        }
        if (s2 !== peg$FAILED) {
          s3 = peg$parseGroupGraphPattern();
          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c274(s3);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c269); }
      }

      return s0;
    }

    function peg$parseGroupOrUnionGraphPattern() {
      var s0, s1, s2, s3, s4, s5, s6, s7;

      peg$silentFails++;
      s0 = peg$currPos;
      s1 = peg$parseGroupGraphPattern();
      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$currPos;
        s4 = [];
        s5 = peg$parseWS();
        while (s5 !== peg$FAILED) {
          s4.push(s5);
          s5 = peg$parseWS();
        }
        if (s4 !== peg$FAILED) {
          if (input.substr(peg$currPos, 5) === peg$c276) {
            s5 = peg$c276;
            peg$currPos += 5;
          } else {
            s5 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c277); }
          }
          if (s5 === peg$FAILED) {
            if (input.substr(peg$currPos, 5) === peg$c278) {
              s5 = peg$c278;
              peg$currPos += 5;
            } else {
              s5 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c279); }
            }
          }
          if (s5 !== peg$FAILED) {
            s6 = [];
            s7 = peg$parseWS();
            while (s7 !== peg$FAILED) {
              s6.push(s7);
              s7 = peg$parseWS();
            }
            if (s6 !== peg$FAILED) {
              s7 = peg$parseGroupGraphPattern();
              if (s7 !== peg$FAILED) {
                s4 = [s4, s5, s6, s7];
                s3 = s4;
              } else {
                peg$currPos = s3;
                s3 = peg$FAILED;
              }
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$currPos;
          s4 = [];
          s5 = peg$parseWS();
          while (s5 !== peg$FAILED) {
            s4.push(s5);
            s5 = peg$parseWS();
          }
          if (s4 !== peg$FAILED) {
            if (input.substr(peg$currPos, 5) === peg$c276) {
              s5 = peg$c276;
              peg$currPos += 5;
            } else {
              s5 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c277); }
            }
            if (s5 === peg$FAILED) {
              if (input.substr(peg$currPos, 5) === peg$c278) {
                s5 = peg$c278;
                peg$currPos += 5;
              } else {
                s5 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c279); }
              }
            }
            if (s5 !== peg$FAILED) {
              s6 = [];
              s7 = peg$parseWS();
              while (s7 !== peg$FAILED) {
                s6.push(s7);
                s7 = peg$parseWS();
              }
              if (s6 !== peg$FAILED) {
                s7 = peg$parseGroupGraphPattern();
                if (s7 !== peg$FAILED) {
                  s4 = [s4, s5, s6, s7];
                  s3 = s4;
                } else {
                  peg$currPos = s3;
                  s3 = peg$FAILED;
                }
              } else {
                peg$currPos = s3;
                s3 = peg$FAILED;
              }
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        }
        if (s2 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c280(s1, s2);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c275); }
      }

      return s0;
    }

    function peg$parseFilter() {
      var s0, s1, s2, s3, s4;

      peg$silentFails++;
      s0 = peg$currPos;
      s1 = [];
      s2 = peg$parseWS();
      while (s2 !== peg$FAILED) {
        s1.push(s2);
        s2 = peg$parseWS();
      }
      if (s1 !== peg$FAILED) {
        if (input.substr(peg$currPos, 6) === peg$c282) {
          s2 = peg$c282;
          peg$currPos += 6;
        } else {
          s2 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c283); }
        }
        if (s2 === peg$FAILED) {
          if (input.substr(peg$currPos, 6) === peg$c284) {
            s2 = peg$c284;
            peg$currPos += 6;
          } else {
            s2 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c285); }
          }
        }
        if (s2 !== peg$FAILED) {
          s3 = [];
          s4 = peg$parseWS();
          while (s4 !== peg$FAILED) {
            s3.push(s4);
            s4 = peg$parseWS();
          }
          if (s3 !== peg$FAILED) {
            s4 = peg$parseConstraint();
            if (s4 !== peg$FAILED) {
              peg$savedPos = s0;
              s1 = peg$c286(s4);
              s0 = s1;
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c281); }
      }

      return s0;
    }

    function peg$parseBind() {
      var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12;

      peg$silentFails++;
      s0 = peg$currPos;
      s1 = [];
      s2 = peg$parseWS();
      while (s2 !== peg$FAILED) {
        s1.push(s2);
        s2 = peg$parseWS();
      }
      if (s1 !== peg$FAILED) {
        if (input.substr(peg$currPos, 4) === peg$c288) {
          s2 = peg$c288;
          peg$currPos += 4;
        } else {
          s2 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c289); }
        }
        if (s2 === peg$FAILED) {
          if (input.substr(peg$currPos, 4) === peg$c290) {
            s2 = peg$c290;
            peg$currPos += 4;
          } else {
            s2 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c291); }
          }
        }
        if (s2 !== peg$FAILED) {
          s3 = [];
          s4 = peg$parseWS();
          while (s4 !== peg$FAILED) {
            s3.push(s4);
            s4 = peg$parseWS();
          }
          if (s3 !== peg$FAILED) {
            if (input.charCodeAt(peg$currPos) === 40) {
              s4 = peg$c34;
              peg$currPos++;
            } else {
              s4 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c35); }
            }
            if (s4 !== peg$FAILED) {
              s5 = [];
              s6 = peg$parseWS();
              while (s6 !== peg$FAILED) {
                s5.push(s6);
                s6 = peg$parseWS();
              }
              if (s5 !== peg$FAILED) {
                s6 = peg$parseExpression();
                if (s6 !== peg$FAILED) {
                  s7 = [];
                  s8 = peg$parseWS();
                  while (s8 !== peg$FAILED) {
                    s7.push(s8);
                    s8 = peg$parseWS();
                  }
                  if (s7 !== peg$FAILED) {
                    if (input.substr(peg$currPos, 2) === peg$c38) {
                      s8 = peg$c38;
                      peg$currPos += 2;
                    } else {
                      s8 = peg$FAILED;
                      if (peg$silentFails === 0) { peg$fail(peg$c39); }
                    }
                    if (s8 === peg$FAILED) {
                      if (input.substr(peg$currPos, 2) === peg$c36) {
                        s8 = peg$c36;
                        peg$currPos += 2;
                      } else {
                        s8 = peg$FAILED;
                        if (peg$silentFails === 0) { peg$fail(peg$c37); }
                      }
                    }
                    if (s8 !== peg$FAILED) {
                      s9 = [];
                      s10 = peg$parseWS();
                      while (s10 !== peg$FAILED) {
                        s9.push(s10);
                        s10 = peg$parseWS();
                      }
                      if (s9 !== peg$FAILED) {
                        s10 = peg$parseVar();
                        if (s10 !== peg$FAILED) {
                          s11 = [];
                          s12 = peg$parseWS();
                          while (s12 !== peg$FAILED) {
                            s11.push(s12);
                            s12 = peg$parseWS();
                          }
                          if (s11 !== peg$FAILED) {
                            if (input.charCodeAt(peg$currPos) === 41) {
                              s12 = peg$c40;
                              peg$currPos++;
                            } else {
                              s12 = peg$FAILED;
                              if (peg$silentFails === 0) { peg$fail(peg$c41); }
                            }
                            if (s12 !== peg$FAILED) {
                              peg$savedPos = s0;
                              s1 = peg$c292(s6, s10);
                              s0 = s1;
                            } else {
                              peg$currPos = s0;
                              s0 = peg$FAILED;
                            }
                          } else {
                            peg$currPos = s0;
                            s0 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s0;
                          s0 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s0;
                        s0 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s0;
                      s0 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c287); }
      }

      return s0;
    }

    function peg$parseConstraint() {
      var s0, s1;

      peg$silentFails++;
      s0 = peg$parseBrackettedExpression();
      if (s0 === peg$FAILED) {
        s0 = peg$parseBuiltInCall();
        if (s0 === peg$FAILED) {
          s0 = peg$parseFunctionCall();
        }
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c293); }
      }

      return s0;
    }

    function peg$parseInlineData() {
      var s0, s1, s2, s3, s4;

      peg$silentFails++;
      s0 = peg$currPos;
      s1 = [];
      s2 = peg$parseWS();
      while (s2 !== peg$FAILED) {
        s1.push(s2);
        s2 = peg$parseWS();
      }
      if (s1 !== peg$FAILED) {
        if (input.substr(peg$currPos, 6) === peg$c145) {
          s2 = peg$c145;
          peg$currPos += 6;
        } else {
          s2 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c146); }
        }
        if (s2 === peg$FAILED) {
          if (input.substr(peg$currPos, 6) === peg$c147) {
            s2 = peg$c147;
            peg$currPos += 6;
          } else {
            s2 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c148); }
          }
        }
        if (s2 !== peg$FAILED) {
          s3 = [];
          s4 = peg$parseWS();
          while (s4 !== peg$FAILED) {
            s3.push(s4);
            s4 = peg$parseWS();
          }
          if (s3 !== peg$FAILED) {
            s4 = peg$parseDataBlock();
            if (s4 !== peg$FAILED) {
              peg$savedPos = s0;
              s1 = peg$c295(s4);
              s0 = s1;
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c294); }
      }

      return s0;
    }

    function peg$parseDataBlock() {
      var s0, s1;

      peg$silentFails++;
      s0 = peg$parseInlineDataOneVar();
      if (s0 === peg$FAILED) {
        s0 = peg$parseInlineDataFull();
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c296); }
      }

      return s0;
    }

    function peg$parseInlineDataOneVar() {
      var s0, s1, s2, s3, s4, s5, s6, s7;

      peg$silentFails++;
      s0 = peg$currPos;
      s1 = [];
      s2 = peg$parseWS();
      while (s2 !== peg$FAILED) {
        s1.push(s2);
        s2 = peg$parseWS();
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parseVar();
        if (s2 !== peg$FAILED) {
          s3 = [];
          s4 = peg$parseWS();
          while (s4 !== peg$FAILED) {
            s3.push(s4);
            s4 = peg$parseWS();
          }
          if (s3 !== peg$FAILED) {
            if (input.charCodeAt(peg$currPos) === 123) {
              s4 = peg$c55;
              peg$currPos++;
            } else {
              s4 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c56); }
            }
            if (s4 !== peg$FAILED) {
              s5 = [];
              s6 = peg$parseWS();
              while (s6 !== peg$FAILED) {
                s5.push(s6);
                s6 = peg$parseWS();
              }
              if (s5 !== peg$FAILED) {
                s6 = [];
                s7 = peg$parseDataBlockValue();
                while (s7 !== peg$FAILED) {
                  s6.push(s7);
                  s7 = peg$parseDataBlockValue();
                }
                if (s6 !== peg$FAILED) {
                  if (input.charCodeAt(peg$currPos) === 125) {
                    s7 = peg$c57;
                    peg$currPos++;
                  } else {
                    s7 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$c58); }
                  }
                  if (s7 !== peg$FAILED) {
                    peg$savedPos = s0;
                    s1 = peg$c298(s2, s6);
                    s0 = s1;
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c297); }
      }

      return s0;
    }

    function peg$parseInlineDataFull() {
      var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15;

      peg$silentFails++;
      s0 = peg$currPos;
      s1 = [];
      s2 = peg$parseWS();
      while (s2 !== peg$FAILED) {
        s1.push(s2);
        s2 = peg$parseWS();
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parseNIL();
        if (s2 === peg$FAILED) {
          s2 = peg$currPos;
          if (input.charCodeAt(peg$currPos) === 40) {
            s3 = peg$c34;
            peg$currPos++;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c35); }
          }
          if (s3 !== peg$FAILED) {
            s4 = [];
            s5 = peg$parseWS();
            while (s5 !== peg$FAILED) {
              s4.push(s5);
              s5 = peg$parseWS();
            }
            if (s4 !== peg$FAILED) {
              s5 = [];
              s6 = peg$parseVar();
              while (s6 !== peg$FAILED) {
                s5.push(s6);
                s6 = peg$parseVar();
              }
              if (s5 !== peg$FAILED) {
                s6 = [];
                s7 = peg$parseWS();
                while (s7 !== peg$FAILED) {
                  s6.push(s7);
                  s7 = peg$parseWS();
                }
                if (s6 !== peg$FAILED) {
                  if (input.charCodeAt(peg$currPos) === 41) {
                    s7 = peg$c40;
                    peg$currPos++;
                  } else {
                    s7 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$c41); }
                  }
                  if (s7 !== peg$FAILED) {
                    s3 = [s3, s4, s5, s6, s7];
                    s2 = s3;
                  } else {
                    peg$currPos = s2;
                    s2 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s2;
                  s2 = peg$FAILED;
                }
              } else {
                peg$currPos = s2;
                s2 = peg$FAILED;
              }
            } else {
              peg$currPos = s2;
              s2 = peg$FAILED;
            }
          } else {
            peg$currPos = s2;
            s2 = peg$FAILED;
          }
        }
        if (s2 !== peg$FAILED) {
          s3 = [];
          s4 = peg$parseWS();
          while (s4 !== peg$FAILED) {
            s3.push(s4);
            s4 = peg$parseWS();
          }
          if (s3 !== peg$FAILED) {
            if (input.charCodeAt(peg$currPos) === 123) {
              s4 = peg$c55;
              peg$currPos++;
            } else {
              s4 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c56); }
            }
            if (s4 !== peg$FAILED) {
              s5 = [];
              s6 = peg$parseWS();
              while (s6 !== peg$FAILED) {
                s5.push(s6);
                s6 = peg$parseWS();
              }
              if (s5 !== peg$FAILED) {
                s6 = [];
                s7 = peg$currPos;
                s8 = [];
                s9 = peg$parseWS();
                while (s9 !== peg$FAILED) {
                  s8.push(s9);
                  s9 = peg$parseWS();
                }
                if (s8 !== peg$FAILED) {
                  if (input.charCodeAt(peg$currPos) === 40) {
                    s9 = peg$c34;
                    peg$currPos++;
                  } else {
                    s9 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$c35); }
                  }
                  if (s9 !== peg$FAILED) {
                    s10 = [];
                    s11 = peg$parseWS();
                    while (s11 !== peg$FAILED) {
                      s10.push(s11);
                      s11 = peg$parseWS();
                    }
                    if (s10 !== peg$FAILED) {
                      s11 = [];
                      s12 = peg$parseDataBlockValue();
                      while (s12 !== peg$FAILED) {
                        s11.push(s12);
                        s12 = peg$parseDataBlockValue();
                      }
                      if (s11 !== peg$FAILED) {
                        s12 = [];
                        s13 = peg$parseWS();
                        while (s13 !== peg$FAILED) {
                          s12.push(s13);
                          s13 = peg$parseWS();
                        }
                        if (s12 !== peg$FAILED) {
                          if (input.charCodeAt(peg$currPos) === 41) {
                            s13 = peg$c40;
                            peg$currPos++;
                          } else {
                            s13 = peg$FAILED;
                            if (peg$silentFails === 0) { peg$fail(peg$c41); }
                          }
                          if (s13 !== peg$FAILED) {
                            s14 = [];
                            s15 = peg$parseWS();
                            while (s15 !== peg$FAILED) {
                              s14.push(s15);
                              s15 = peg$parseWS();
                            }
                            if (s14 !== peg$FAILED) {
                              s8 = [s8, s9, s10, s11, s12, s13, s14];
                              s7 = s8;
                            } else {
                              peg$currPos = s7;
                              s7 = peg$FAILED;
                            }
                          } else {
                            peg$currPos = s7;
                            s7 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s7;
                          s7 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s7;
                        s7 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s7;
                      s7 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s7;
                    s7 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s7;
                  s7 = peg$FAILED;
                }
                if (s7 === peg$FAILED) {
                  s7 = peg$parseNIL();
                }
                while (s7 !== peg$FAILED) {
                  s6.push(s7);
                  s7 = peg$currPos;
                  s8 = [];
                  s9 = peg$parseWS();
                  while (s9 !== peg$FAILED) {
                    s8.push(s9);
                    s9 = peg$parseWS();
                  }
                  if (s8 !== peg$FAILED) {
                    if (input.charCodeAt(peg$currPos) === 40) {
                      s9 = peg$c34;
                      peg$currPos++;
                    } else {
                      s9 = peg$FAILED;
                      if (peg$silentFails === 0) { peg$fail(peg$c35); }
                    }
                    if (s9 !== peg$FAILED) {
                      s10 = [];
                      s11 = peg$parseWS();
                      while (s11 !== peg$FAILED) {
                        s10.push(s11);
                        s11 = peg$parseWS();
                      }
                      if (s10 !== peg$FAILED) {
                        s11 = [];
                        s12 = peg$parseDataBlockValue();
                        while (s12 !== peg$FAILED) {
                          s11.push(s12);
                          s12 = peg$parseDataBlockValue();
                        }
                        if (s11 !== peg$FAILED) {
                          s12 = [];
                          s13 = peg$parseWS();
                          while (s13 !== peg$FAILED) {
                            s12.push(s13);
                            s13 = peg$parseWS();
                          }
                          if (s12 !== peg$FAILED) {
                            if (input.charCodeAt(peg$currPos) === 41) {
                              s13 = peg$c40;
                              peg$currPos++;
                            } else {
                              s13 = peg$FAILED;
                              if (peg$silentFails === 0) { peg$fail(peg$c41); }
                            }
                            if (s13 !== peg$FAILED) {
                              s14 = [];
                              s15 = peg$parseWS();
                              while (s15 !== peg$FAILED) {
                                s14.push(s15);
                                s15 = peg$parseWS();
                              }
                              if (s14 !== peg$FAILED) {
                                s8 = [s8, s9, s10, s11, s12, s13, s14];
                                s7 = s8;
                              } else {
                                peg$currPos = s7;
                                s7 = peg$FAILED;
                              }
                            } else {
                              peg$currPos = s7;
                              s7 = peg$FAILED;
                            }
                          } else {
                            peg$currPos = s7;
                            s7 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s7;
                          s7 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s7;
                        s7 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s7;
                      s7 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s7;
                    s7 = peg$FAILED;
                  }
                  if (s7 === peg$FAILED) {
                    s7 = peg$parseNIL();
                  }
                }
                if (s6 !== peg$FAILED) {
                  s7 = [];
                  s8 = peg$parseWS();
                  while (s8 !== peg$FAILED) {
                    s7.push(s8);
                    s8 = peg$parseWS();
                  }
                  if (s7 !== peg$FAILED) {
                    if (input.charCodeAt(peg$currPos) === 125) {
                      s8 = peg$c57;
                      peg$currPos++;
                    } else {
                      s8 = peg$FAILED;
                      if (peg$silentFails === 0) { peg$fail(peg$c58); }
                    }
                    if (s8 !== peg$FAILED) {
                      peg$savedPos = s0;
                      s1 = peg$c300(s2, s6);
                      s0 = s1;
                    } else {
                      peg$currPos = s0;
                      s0 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c299); }
      }

      return s0;
    }

    function peg$parseDataBlockValue() {
      var s0, s1, s2, s3, s4;

      peg$silentFails++;
      s0 = peg$currPos;
      s1 = [];
      s2 = peg$parseWS();
      while (s2 !== peg$FAILED) {
        s1.push(s2);
        s2 = peg$parseWS();
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parseIRI_REF();
        if (s2 === peg$FAILED) {
          s2 = peg$parseRDFLiteral();
          if (s2 === peg$FAILED) {
            s2 = peg$parseNumericLiteral();
            if (s2 === peg$FAILED) {
              s2 = peg$parseBooleanLiteral();
              if (s2 === peg$FAILED) {
                if (input.substr(peg$currPos, 5) === peg$c142) {
                  s2 = peg$c142;
                  peg$currPos += 5;
                } else {
                  s2 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c143); }
                }
              }
            }
          }
        }
        if (s2 !== peg$FAILED) {
          s3 = [];
          s4 = peg$parseWS();
          while (s4 !== peg$FAILED) {
            s3.push(s4);
            s4 = peg$parseWS();
          }
          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c102(s2);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c301); }
      }

      return s0;
    }

    function peg$parseFunctionCall() {
      var s0, s1, s2, s3;

      peg$silentFails++;
      s0 = peg$currPos;
      s1 = peg$parseIRIref();
      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$parseWS();
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parseWS();
        }
        if (s2 !== peg$FAILED) {
          s3 = peg$parseArgList();
          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c303(s1, s3);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c302); }
      }

      return s0;
    }

    function peg$parseArgList() {
      var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11;

      peg$silentFails++;
      s0 = peg$currPos;
      s1 = peg$parseNIL();
      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$c305();
      }
      s0 = s1;
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        if (input.charCodeAt(peg$currPos) === 40) {
          s1 = peg$c34;
          peg$currPos++;
        } else {
          s1 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c35); }
        }
        if (s1 !== peg$FAILED) {
          s2 = [];
          s3 = peg$parseWS();
          while (s3 !== peg$FAILED) {
            s2.push(s3);
            s3 = peg$parseWS();
          }
          if (s2 !== peg$FAILED) {
            if (input.substr(peg$currPos, 8) === peg$c26) {
              s3 = peg$c26;
              peg$currPos += 8;
            } else {
              s3 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c27); }
            }
            if (s3 === peg$FAILED) {
              if (input.substr(peg$currPos, 8) === peg$c28) {
                s3 = peg$c28;
                peg$currPos += 8;
              } else {
                s3 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c29); }
              }
            }
            if (s3 === peg$FAILED) {
              s3 = null;
            }
            if (s3 !== peg$FAILED) {
              s4 = [];
              s5 = peg$parseWS();
              while (s5 !== peg$FAILED) {
                s4.push(s5);
                s5 = peg$parseWS();
              }
              if (s4 !== peg$FAILED) {
                s5 = peg$parseExpression();
                if (s5 !== peg$FAILED) {
                  s6 = [];
                  s7 = peg$parseWS();
                  while (s7 !== peg$FAILED) {
                    s6.push(s7);
                    s7 = peg$parseWS();
                  }
                  if (s6 !== peg$FAILED) {
                    s7 = [];
                    s8 = peg$currPos;
                    if (input.charCodeAt(peg$currPos) === 44) {
                      s9 = peg$c306;
                      peg$currPos++;
                    } else {
                      s9 = peg$FAILED;
                      if (peg$silentFails === 0) { peg$fail(peg$c307); }
                    }
                    if (s9 !== peg$FAILED) {
                      s10 = [];
                      s11 = peg$parseWS();
                      while (s11 !== peg$FAILED) {
                        s10.push(s11);
                        s11 = peg$parseWS();
                      }
                      if (s10 !== peg$FAILED) {
                        s11 = peg$parseExpression();
                        if (s11 !== peg$FAILED) {
                          s9 = [s9, s10, s11];
                          s8 = s9;
                        } else {
                          peg$currPos = s8;
                          s8 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s8;
                        s8 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s8;
                      s8 = peg$FAILED;
                    }
                    while (s8 !== peg$FAILED) {
                      s7.push(s8);
                      s8 = peg$currPos;
                      if (input.charCodeAt(peg$currPos) === 44) {
                        s9 = peg$c306;
                        peg$currPos++;
                      } else {
                        s9 = peg$FAILED;
                        if (peg$silentFails === 0) { peg$fail(peg$c307); }
                      }
                      if (s9 !== peg$FAILED) {
                        s10 = [];
                        s11 = peg$parseWS();
                        while (s11 !== peg$FAILED) {
                          s10.push(s11);
                          s11 = peg$parseWS();
                        }
                        if (s10 !== peg$FAILED) {
                          s11 = peg$parseExpression();
                          if (s11 !== peg$FAILED) {
                            s9 = [s9, s10, s11];
                            s8 = s9;
                          } else {
                            peg$currPos = s8;
                            s8 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s8;
                          s8 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s8;
                        s8 = peg$FAILED;
                      }
                    }
                    if (s7 !== peg$FAILED) {
                      if (input.charCodeAt(peg$currPos) === 41) {
                        s8 = peg$c40;
                        peg$currPos++;
                      } else {
                        s8 = peg$FAILED;
                        if (peg$silentFails === 0) { peg$fail(peg$c41); }
                      }
                      if (s8 !== peg$FAILED) {
                        peg$savedPos = s0;
                        s1 = peg$c308(s3, s5, s7);
                        s0 = s1;
                      } else {
                        peg$currPos = s0;
                        s0 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s0;
                      s0 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c304); }
      }

      return s0;
    }

    function peg$parseExpressionList() {
      var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9;

      peg$silentFails++;
      s0 = peg$currPos;
      s1 = peg$parseNIL();
      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$c305();
      }
      s0 = s1;
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        if (input.charCodeAt(peg$currPos) === 40) {
          s1 = peg$c34;
          peg$currPos++;
        } else {
          s1 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c35); }
        }
        if (s1 !== peg$FAILED) {
          s2 = [];
          s3 = peg$parseWS();
          while (s3 !== peg$FAILED) {
            s2.push(s3);
            s3 = peg$parseWS();
          }
          if (s2 !== peg$FAILED) {
            s3 = peg$parseIRIref();
            if (s3 === peg$FAILED) {
              s3 = peg$parseExpression();
            }
            if (s3 !== peg$FAILED) {
              s4 = [];
              s5 = peg$parseWS();
              while (s5 !== peg$FAILED) {
                s4.push(s5);
                s5 = peg$parseWS();
              }
              if (s4 !== peg$FAILED) {
                s5 = [];
                s6 = peg$currPos;
                if (input.charCodeAt(peg$currPos) === 44) {
                  s7 = peg$c306;
                  peg$currPos++;
                } else {
                  s7 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c307); }
                }
                if (s7 !== peg$FAILED) {
                  s8 = [];
                  s9 = peg$parseWS();
                  while (s9 !== peg$FAILED) {
                    s8.push(s9);
                    s9 = peg$parseWS();
                  }
                  if (s8 !== peg$FAILED) {
                    s9 = peg$parseIRIref();
                    if (s9 === peg$FAILED) {
                      s9 = peg$parseExpression();
                    }
                    if (s9 !== peg$FAILED) {
                      s7 = [s7, s8, s9];
                      s6 = s7;
                    } else {
                      peg$currPos = s6;
                      s6 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s6;
                    s6 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s6;
                  s6 = peg$FAILED;
                }
                while (s6 !== peg$FAILED) {
                  s5.push(s6);
                  s6 = peg$currPos;
                  if (input.charCodeAt(peg$currPos) === 44) {
                    s7 = peg$c306;
                    peg$currPos++;
                  } else {
                    s7 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$c307); }
                  }
                  if (s7 !== peg$FAILED) {
                    s8 = [];
                    s9 = peg$parseWS();
                    while (s9 !== peg$FAILED) {
                      s8.push(s9);
                      s9 = peg$parseWS();
                    }
                    if (s8 !== peg$FAILED) {
                      s9 = peg$parseIRIref();
                      if (s9 === peg$FAILED) {
                        s9 = peg$parseExpression();
                      }
                      if (s9 !== peg$FAILED) {
                        s7 = [s7, s8, s9];
                        s6 = s7;
                      } else {
                        peg$currPos = s6;
                        s6 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s6;
                      s6 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s6;
                    s6 = peg$FAILED;
                  }
                }
                if (s5 !== peg$FAILED) {
                  if (input.charCodeAt(peg$currPos) === 41) {
                    s6 = peg$c40;
                    peg$currPos++;
                  } else {
                    s6 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$c41); }
                  }
                  if (s6 !== peg$FAILED) {
                    peg$savedPos = s0;
                    s1 = peg$c310(s3, s5);
                    s0 = s1;
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c309); }
      }

      return s0;
    }

    function peg$parseConstructTemplate() {
      var s0, s1, s2, s3, s4, s5;

      peg$silentFails++;
      s0 = peg$currPos;
      if (input.charCodeAt(peg$currPos) === 123) {
        s1 = peg$c55;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c56); }
      }
      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$parseWS();
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parseWS();
        }
        if (s2 !== peg$FAILED) {
          s3 = peg$parseConstructTriples();
          if (s3 === peg$FAILED) {
            s3 = null;
          }
          if (s3 !== peg$FAILED) {
            s4 = [];
            s5 = peg$parseWS();
            while (s5 !== peg$FAILED) {
              s4.push(s5);
              s5 = peg$parseWS();
            }
            if (s4 !== peg$FAILED) {
              if (input.charCodeAt(peg$currPos) === 125) {
                s5 = peg$c57;
                peg$currPos++;
              } else {
                s5 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c58); }
              }
              if (s5 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c312(s3);
                s0 = s1;
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c311); }
      }

      return s0;
    }

    function peg$parseConstructTriples() {
      var s0, s1, s2, s3, s4, s5, s6;

      peg$silentFails++;
      s0 = peg$currPos;
      s1 = peg$parseTriplesSameSubject();
      if (s1 !== peg$FAILED) {
        s2 = peg$currPos;
        s3 = [];
        s4 = peg$parseWS();
        while (s4 !== peg$FAILED) {
          s3.push(s4);
          s4 = peg$parseWS();
        }
        if (s3 !== peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 46) {
            s4 = peg$c243;
            peg$currPos++;
          } else {
            s4 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c244); }
          }
          if (s4 !== peg$FAILED) {
            s5 = [];
            s6 = peg$parseWS();
            while (s6 !== peg$FAILED) {
              s5.push(s6);
              s6 = peg$parseWS();
            }
            if (s5 !== peg$FAILED) {
              s6 = peg$parseConstructTriples();
              if (s6 === peg$FAILED) {
                s6 = null;
              }
              if (s6 !== peg$FAILED) {
                s3 = [s3, s4, s5, s6];
                s2 = s3;
              } else {
                peg$currPos = s2;
                s2 = peg$FAILED;
              }
            } else {
              peg$currPos = s2;
              s2 = peg$FAILED;
            }
          } else {
            peg$currPos = s2;
            s2 = peg$FAILED;
          }
        } else {
          peg$currPos = s2;
          s2 = peg$FAILED;
        }
        if (s2 === peg$FAILED) {
          s2 = null;
        }
        if (s2 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c314(s1, s2);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c313); }
      }

      return s0;
    }

    function peg$parseTriplesSameSubject() {
      var s0, s1, s2, s3, s4;

      peg$silentFails++;
      s0 = peg$currPos;
      s1 = [];
      s2 = peg$parseWS();
      while (s2 !== peg$FAILED) {
        s1.push(s2);
        s2 = peg$parseWS();
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parseVarOrTerm();
        if (s2 !== peg$FAILED) {
          s3 = [];
          s4 = peg$parseWS();
          while (s4 !== peg$FAILED) {
            s3.push(s4);
            s4 = peg$parseWS();
          }
          if (s3 !== peg$FAILED) {
            s4 = peg$parsePropertyListNotEmpty();
            if (s4 !== peg$FAILED) {
              peg$savedPos = s0;
              s1 = peg$c316(s2, s4);
              s0 = s1;
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        s1 = [];
        s2 = peg$parseWS();
        while (s2 !== peg$FAILED) {
          s1.push(s2);
          s2 = peg$parseWS();
        }
        if (s1 !== peg$FAILED) {
          s2 = peg$parseTriplesNode();
          if (s2 !== peg$FAILED) {
            s3 = [];
            s4 = peg$parseWS();
            while (s4 !== peg$FAILED) {
              s3.push(s4);
              s4 = peg$parseWS();
            }
            if (s3 !== peg$FAILED) {
              s4 = peg$parsePropertyList();
              if (s4 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c317(s2, s4);
                s0 = s1;
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c315); }
      }

      return s0;
    }

    function peg$parsePropertyListPathNotEmpty() {
      var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12;

      peg$silentFails++;
      s0 = peg$currPos;
      s1 = peg$parseVerbPath();
      if (s1 === peg$FAILED) {
        s1 = peg$parseVerbSimple();
      }
      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$parseWS();
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parseWS();
        }
        if (s2 !== peg$FAILED) {
          s3 = peg$parseObjectListPath();
          if (s3 !== peg$FAILED) {
            s4 = [];
            s5 = peg$currPos;
            s6 = [];
            s7 = peg$parseWS();
            while (s7 !== peg$FAILED) {
              s6.push(s7);
              s7 = peg$parseWS();
            }
            if (s6 !== peg$FAILED) {
              if (input.charCodeAt(peg$currPos) === 59) {
                s7 = peg$c152;
                peg$currPos++;
              } else {
                s7 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c153); }
              }
              if (s7 !== peg$FAILED) {
                s8 = [];
                s9 = peg$parseWS();
                while (s9 !== peg$FAILED) {
                  s8.push(s9);
                  s9 = peg$parseWS();
                }
                if (s8 !== peg$FAILED) {
                  s9 = peg$currPos;
                  s10 = peg$parseVerbPath();
                  if (s10 === peg$FAILED) {
                    s10 = peg$parseVerbSimple();
                  }
                  if (s10 !== peg$FAILED) {
                    s11 = [];
                    s12 = peg$parseWS();
                    while (s12 !== peg$FAILED) {
                      s11.push(s12);
                      s12 = peg$parseWS();
                    }
                    if (s11 !== peg$FAILED) {
                      s12 = peg$parseObjectList();
                      if (s12 !== peg$FAILED) {
                        s10 = [s10, s11, s12];
                        s9 = s10;
                      } else {
                        peg$currPos = s9;
                        s9 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s9;
                      s9 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s9;
                    s9 = peg$FAILED;
                  }
                  if (s9 === peg$FAILED) {
                    s9 = null;
                  }
                  if (s9 !== peg$FAILED) {
                    s6 = [s6, s7, s8, s9];
                    s5 = s6;
                  } else {
                    peg$currPos = s5;
                    s5 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s5;
                  s5 = peg$FAILED;
                }
              } else {
                peg$currPos = s5;
                s5 = peg$FAILED;
              }
            } else {
              peg$currPos = s5;
              s5 = peg$FAILED;
            }
            while (s5 !== peg$FAILED) {
              s4.push(s5);
              s5 = peg$currPos;
              s6 = [];
              s7 = peg$parseWS();
              while (s7 !== peg$FAILED) {
                s6.push(s7);
                s7 = peg$parseWS();
              }
              if (s6 !== peg$FAILED) {
                if (input.charCodeAt(peg$currPos) === 59) {
                  s7 = peg$c152;
                  peg$currPos++;
                } else {
                  s7 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c153); }
                }
                if (s7 !== peg$FAILED) {
                  s8 = [];
                  s9 = peg$parseWS();
                  while (s9 !== peg$FAILED) {
                    s8.push(s9);
                    s9 = peg$parseWS();
                  }
                  if (s8 !== peg$FAILED) {
                    s9 = peg$currPos;
                    s10 = peg$parseVerbPath();
                    if (s10 === peg$FAILED) {
                      s10 = peg$parseVerbSimple();
                    }
                    if (s10 !== peg$FAILED) {
                      s11 = [];
                      s12 = peg$parseWS();
                      while (s12 !== peg$FAILED) {
                        s11.push(s12);
                        s12 = peg$parseWS();
                      }
                      if (s11 !== peg$FAILED) {
                        s12 = peg$parseObjectList();
                        if (s12 !== peg$FAILED) {
                          s10 = [s10, s11, s12];
                          s9 = s10;
                        } else {
                          peg$currPos = s9;
                          s9 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s9;
                        s9 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s9;
                      s9 = peg$FAILED;
                    }
                    if (s9 === peg$FAILED) {
                      s9 = null;
                    }
                    if (s9 !== peg$FAILED) {
                      s6 = [s6, s7, s8, s9];
                      s5 = s6;
                    } else {
                      peg$currPos = s5;
                      s5 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s5;
                    s5 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s5;
                  s5 = peg$FAILED;
                }
              } else {
                peg$currPos = s5;
                s5 = peg$FAILED;
              }
            }
            if (s4 !== peg$FAILED) {
              peg$savedPos = s0;
              s1 = peg$c319(s1, s3, s4);
              s0 = s1;
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c318); }
      }

      return s0;
    }

    function peg$parsePropertyListNotEmpty() {
      var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12;

      peg$silentFails++;
      s0 = peg$currPos;
      s1 = peg$parseVerb();
      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$parseWS();
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parseWS();
        }
        if (s2 !== peg$FAILED) {
          s3 = peg$parseObjectList();
          if (s3 !== peg$FAILED) {
            s4 = [];
            s5 = peg$currPos;
            s6 = [];
            s7 = peg$parseWS();
            while (s7 !== peg$FAILED) {
              s6.push(s7);
              s7 = peg$parseWS();
            }
            if (s6 !== peg$FAILED) {
              if (input.charCodeAt(peg$currPos) === 59) {
                s7 = peg$c152;
                peg$currPos++;
              } else {
                s7 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c153); }
              }
              if (s7 !== peg$FAILED) {
                s8 = [];
                s9 = peg$parseWS();
                while (s9 !== peg$FAILED) {
                  s8.push(s9);
                  s9 = peg$parseWS();
                }
                if (s8 !== peg$FAILED) {
                  s9 = peg$currPos;
                  s10 = peg$parseVerb();
                  if (s10 !== peg$FAILED) {
                    s11 = [];
                    s12 = peg$parseWS();
                    while (s12 !== peg$FAILED) {
                      s11.push(s12);
                      s12 = peg$parseWS();
                    }
                    if (s11 !== peg$FAILED) {
                      s12 = peg$parseObjectList();
                      if (s12 !== peg$FAILED) {
                        s10 = [s10, s11, s12];
                        s9 = s10;
                      } else {
                        peg$currPos = s9;
                        s9 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s9;
                      s9 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s9;
                    s9 = peg$FAILED;
                  }
                  if (s9 === peg$FAILED) {
                    s9 = null;
                  }
                  if (s9 !== peg$FAILED) {
                    s6 = [s6, s7, s8, s9];
                    s5 = s6;
                  } else {
                    peg$currPos = s5;
                    s5 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s5;
                  s5 = peg$FAILED;
                }
              } else {
                peg$currPos = s5;
                s5 = peg$FAILED;
              }
            } else {
              peg$currPos = s5;
              s5 = peg$FAILED;
            }
            while (s5 !== peg$FAILED) {
              s4.push(s5);
              s5 = peg$currPos;
              s6 = [];
              s7 = peg$parseWS();
              while (s7 !== peg$FAILED) {
                s6.push(s7);
                s7 = peg$parseWS();
              }
              if (s6 !== peg$FAILED) {
                if (input.charCodeAt(peg$currPos) === 59) {
                  s7 = peg$c152;
                  peg$currPos++;
                } else {
                  s7 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c153); }
                }
                if (s7 !== peg$FAILED) {
                  s8 = [];
                  s9 = peg$parseWS();
                  while (s9 !== peg$FAILED) {
                    s8.push(s9);
                    s9 = peg$parseWS();
                  }
                  if (s8 !== peg$FAILED) {
                    s9 = peg$currPos;
                    s10 = peg$parseVerb();
                    if (s10 !== peg$FAILED) {
                      s11 = [];
                      s12 = peg$parseWS();
                      while (s12 !== peg$FAILED) {
                        s11.push(s12);
                        s12 = peg$parseWS();
                      }
                      if (s11 !== peg$FAILED) {
                        s12 = peg$parseObjectList();
                        if (s12 !== peg$FAILED) {
                          s10 = [s10, s11, s12];
                          s9 = s10;
                        } else {
                          peg$currPos = s9;
                          s9 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s9;
                        s9 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s9;
                      s9 = peg$FAILED;
                    }
                    if (s9 === peg$FAILED) {
                      s9 = null;
                    }
                    if (s9 !== peg$FAILED) {
                      s6 = [s6, s7, s8, s9];
                      s5 = s6;
                    } else {
                      peg$currPos = s5;
                      s5 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s5;
                    s5 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s5;
                  s5 = peg$FAILED;
                }
              } else {
                peg$currPos = s5;
                s5 = peg$FAILED;
              }
            }
            if (s4 !== peg$FAILED) {
              peg$savedPos = s0;
              s1 = peg$c321(s1, s3, s4);
              s0 = s1;
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c320); }
      }

      return s0;
    }

    function peg$parsePropertyList() {
      var s0, s1;

      peg$silentFails++;
      s0 = peg$parsePropertyListNotEmpty();
      if (s0 === peg$FAILED) {
        s0 = null;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c322); }
      }

      return s0;
    }

    function peg$parseObjectListPath() {
      var s0, s1, s2, s3, s4, s5, s6, s7;

      peg$silentFails++;
      s0 = peg$currPos;
      s1 = peg$parseObjectPath();
      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$parseWS();
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parseWS();
        }
        if (s2 !== peg$FAILED) {
          s3 = [];
          s4 = peg$currPos;
          if (input.charCodeAt(peg$currPos) === 44) {
            s5 = peg$c306;
            peg$currPos++;
          } else {
            s5 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c307); }
          }
          if (s5 !== peg$FAILED) {
            s6 = [];
            s7 = peg$parseWS();
            while (s7 !== peg$FAILED) {
              s6.push(s7);
              s7 = peg$parseWS();
            }
            if (s6 !== peg$FAILED) {
              s7 = peg$parseObjectPath();
              if (s7 !== peg$FAILED) {
                s5 = [s5, s6, s7];
                s4 = s5;
              } else {
                peg$currPos = s4;
                s4 = peg$FAILED;
              }
            } else {
              peg$currPos = s4;
              s4 = peg$FAILED;
            }
          } else {
            peg$currPos = s4;
            s4 = peg$FAILED;
          }
          while (s4 !== peg$FAILED) {
            s3.push(s4);
            s4 = peg$currPos;
            if (input.charCodeAt(peg$currPos) === 44) {
              s5 = peg$c306;
              peg$currPos++;
            } else {
              s5 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c307); }
            }
            if (s5 !== peg$FAILED) {
              s6 = [];
              s7 = peg$parseWS();
              while (s7 !== peg$FAILED) {
                s6.push(s7);
                s7 = peg$parseWS();
              }
              if (s6 !== peg$FAILED) {
                s7 = peg$parseObjectPath();
                if (s7 !== peg$FAILED) {
                  s5 = [s5, s6, s7];
                  s4 = s5;
                } else {
                  peg$currPos = s4;
                  s4 = peg$FAILED;
                }
              } else {
                peg$currPos = s4;
                s4 = peg$FAILED;
              }
            } else {
              peg$currPos = s4;
              s4 = peg$FAILED;
            }
          }
          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c324(s1, s3);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c323); }
      }

      return s0;
    }

    function peg$parseObjectList() {
      var s0, s1, s2, s3, s4, s5, s6, s7;

      peg$silentFails++;
      s0 = peg$currPos;
      s1 = peg$parseObject();
      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$parseWS();
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parseWS();
        }
        if (s2 !== peg$FAILED) {
          s3 = [];
          s4 = peg$currPos;
          if (input.charCodeAt(peg$currPos) === 44) {
            s5 = peg$c306;
            peg$currPos++;
          } else {
            s5 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c307); }
          }
          if (s5 !== peg$FAILED) {
            s6 = [];
            s7 = peg$parseWS();
            while (s7 !== peg$FAILED) {
              s6.push(s7);
              s7 = peg$parseWS();
            }
            if (s6 !== peg$FAILED) {
              s7 = peg$parseObject();
              if (s7 !== peg$FAILED) {
                s5 = [s5, s6, s7];
                s4 = s5;
              } else {
                peg$currPos = s4;
                s4 = peg$FAILED;
              }
            } else {
              peg$currPos = s4;
              s4 = peg$FAILED;
            }
          } else {
            peg$currPos = s4;
            s4 = peg$FAILED;
          }
          while (s4 !== peg$FAILED) {
            s3.push(s4);
            s4 = peg$currPos;
            if (input.charCodeAt(peg$currPos) === 44) {
              s5 = peg$c306;
              peg$currPos++;
            } else {
              s5 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c307); }
            }
            if (s5 !== peg$FAILED) {
              s6 = [];
              s7 = peg$parseWS();
              while (s7 !== peg$FAILED) {
                s6.push(s7);
                s7 = peg$parseWS();
              }
              if (s6 !== peg$FAILED) {
                s7 = peg$parseObject();
                if (s7 !== peg$FAILED) {
                  s5 = [s5, s6, s7];
                  s4 = s5;
                } else {
                  peg$currPos = s4;
                  s4 = peg$FAILED;
                }
              } else {
                peg$currPos = s4;
                s4 = peg$FAILED;
              }
            } else {
              peg$currPos = s4;
              s4 = peg$FAILED;
            }
          }
          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c326(s1, s3);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c325); }
      }

      return s0;
    }

    function peg$parseObjectPath() {
      var s0, s1;

      peg$silentFails++;
      s0 = peg$parseGraphNodePath();
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c327); }
      }

      return s0;
    }

    function peg$parseObject() {
      var s0, s1;

      peg$silentFails++;
      s0 = peg$parseGraphNode();
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c328); }
      }

      return s0;
    }

    function peg$parseVerb() {
      var s0, s1;

      peg$silentFails++;
      s0 = peg$parseVarOrIRIref();
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        if (input.charCodeAt(peg$currPos) === 97) {
          s1 = peg$c330;
          peg$currPos++;
        } else {
          s1 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c331); }
        }
        if (s1 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c332();
        }
        s0 = s1;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c329); }
      }

      return s0;
    }

    function peg$parseTriplesSameSubjectPath() {
      var s0, s1, s2, s3, s4;

      peg$silentFails++;
      s0 = peg$currPos;
      s1 = [];
      s2 = peg$parseWS();
      while (s2 !== peg$FAILED) {
        s1.push(s2);
        s2 = peg$parseWS();
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parseVarOrTerm();
        if (s2 !== peg$FAILED) {
          s3 = [];
          s4 = peg$parseWS();
          while (s4 !== peg$FAILED) {
            s3.push(s4);
            s4 = peg$parseWS();
          }
          if (s3 !== peg$FAILED) {
            s4 = peg$parsePropertyListNotEmptyPath();
            if (s4 !== peg$FAILED) {
              peg$savedPos = s0;
              s1 = peg$c334(s2, s4);
              s0 = s1;
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        s1 = [];
        s2 = peg$parseWS();
        while (s2 !== peg$FAILED) {
          s1.push(s2);
          s2 = peg$parseWS();
        }
        if (s1 !== peg$FAILED) {
          s2 = peg$parseTriplesNodePath();
          if (s2 !== peg$FAILED) {
            s3 = [];
            s4 = peg$parseWS();
            while (s4 !== peg$FAILED) {
              s3.push(s4);
              s4 = peg$parseWS();
            }
            if (s3 !== peg$FAILED) {
              s4 = peg$parsePropertyListPath();
              if (s4 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c335(s2, s4);
                s0 = s1;
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c333); }
      }

      return s0;
    }

    function peg$parsePropertyListNotEmptyPath() {
      var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11;

      peg$silentFails++;
      s0 = peg$currPos;
      s1 = peg$parseVerbPath();
      if (s1 === peg$FAILED) {
        s1 = peg$parseVerbSimple();
      }
      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$parseWS();
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parseWS();
        }
        if (s2 !== peg$FAILED) {
          s3 = peg$parseObjectListPath();
          if (s3 !== peg$FAILED) {
            s4 = [];
            s5 = peg$currPos;
            s6 = [];
            s7 = peg$parseWS();
            while (s7 !== peg$FAILED) {
              s6.push(s7);
              s7 = peg$parseWS();
            }
            if (s6 !== peg$FAILED) {
              if (input.charCodeAt(peg$currPos) === 59) {
                s7 = peg$c152;
                peg$currPos++;
              } else {
                s7 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c153); }
              }
              if (s7 !== peg$FAILED) {
                s8 = [];
                s9 = peg$parseWS();
                while (s9 !== peg$FAILED) {
                  s8.push(s9);
                  s9 = peg$parseWS();
                }
                if (s8 !== peg$FAILED) {
                  s9 = peg$currPos;
                  s10 = peg$parseVerbPath();
                  if (s10 === peg$FAILED) {
                    s10 = peg$parseVerbSimple();
                  }
                  if (s10 !== peg$FAILED) {
                    s11 = peg$parseObjectList();
                    if (s11 !== peg$FAILED) {
                      s10 = [s10, s11];
                      s9 = s10;
                    } else {
                      peg$currPos = s9;
                      s9 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s9;
                    s9 = peg$FAILED;
                  }
                  if (s9 === peg$FAILED) {
                    s9 = null;
                  }
                  if (s9 !== peg$FAILED) {
                    s6 = [s6, s7, s8, s9];
                    s5 = s6;
                  } else {
                    peg$currPos = s5;
                    s5 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s5;
                  s5 = peg$FAILED;
                }
              } else {
                peg$currPos = s5;
                s5 = peg$FAILED;
              }
            } else {
              peg$currPos = s5;
              s5 = peg$FAILED;
            }
            while (s5 !== peg$FAILED) {
              s4.push(s5);
              s5 = peg$currPos;
              s6 = [];
              s7 = peg$parseWS();
              while (s7 !== peg$FAILED) {
                s6.push(s7);
                s7 = peg$parseWS();
              }
              if (s6 !== peg$FAILED) {
                if (input.charCodeAt(peg$currPos) === 59) {
                  s7 = peg$c152;
                  peg$currPos++;
                } else {
                  s7 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c153); }
                }
                if (s7 !== peg$FAILED) {
                  s8 = [];
                  s9 = peg$parseWS();
                  while (s9 !== peg$FAILED) {
                    s8.push(s9);
                    s9 = peg$parseWS();
                  }
                  if (s8 !== peg$FAILED) {
                    s9 = peg$currPos;
                    s10 = peg$parseVerbPath();
                    if (s10 === peg$FAILED) {
                      s10 = peg$parseVerbSimple();
                    }
                    if (s10 !== peg$FAILED) {
                      s11 = peg$parseObjectList();
                      if (s11 !== peg$FAILED) {
                        s10 = [s10, s11];
                        s9 = s10;
                      } else {
                        peg$currPos = s9;
                        s9 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s9;
                      s9 = peg$FAILED;
                    }
                    if (s9 === peg$FAILED) {
                      s9 = null;
                    }
                    if (s9 !== peg$FAILED) {
                      s6 = [s6, s7, s8, s9];
                      s5 = s6;
                    } else {
                      peg$currPos = s5;
                      s5 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s5;
                    s5 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s5;
                  s5 = peg$FAILED;
                }
              } else {
                peg$currPos = s5;
                s5 = peg$FAILED;
              }
            }
            if (s4 !== peg$FAILED) {
              peg$savedPos = s0;
              s1 = peg$c337(s1, s3, s4);
              s0 = s1;
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c336); }
      }

      return s0;
    }

    function peg$parsePropertyListPath() {
      var s0, s1;

      peg$silentFails++;
      s0 = peg$parsePropertyListPathNotEmpty();
      if (s0 === peg$FAILED) {
        s0 = null;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c338); }
      }

      return s0;
    }

    function peg$parseVerbPath() {
      var s0, s1;

      peg$silentFails++;
      s0 = peg$currPos;
      s1 = peg$parsePath();
      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$c340(s1);
      }
      s0 = s1;
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c339); }
      }

      return s0;
    }

    function peg$parseVerbSimple() {
      var s0, s1;

      peg$silentFails++;
      s0 = peg$parseVar();
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c341); }
      }

      return s0;
    }

    function peg$parsePath() {
      var s0, s1;

      peg$silentFails++;
      s0 = peg$parsePathAlternative();
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c342); }
      }

      return s0;
    }

    function peg$parsePathAlternative() {
      var s0, s1, s2, s3, s4, s5;

      peg$silentFails++;
      s0 = peg$currPos;
      s1 = peg$parsePathSequence();
      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$currPos;
        if (input.charCodeAt(peg$currPos) === 124) {
          s4 = peg$c344;
          peg$currPos++;
        } else {
          s4 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c345); }
        }
        if (s4 !== peg$FAILED) {
          s5 = peg$parsePathSequence();
          if (s5 !== peg$FAILED) {
            s4 = [s4, s5];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$currPos;
          if (input.charCodeAt(peg$currPos) === 124) {
            s4 = peg$c344;
            peg$currPos++;
          } else {
            s4 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c345); }
          }
          if (s4 !== peg$FAILED) {
            s5 = peg$parsePathSequence();
            if (s5 !== peg$FAILED) {
              s4 = [s4, s5];
              s3 = s4;
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        }
        if (s2 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c346(s1, s2);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c343); }
      }

      return s0;
    }

    function peg$parsePathSequence() {
      var s0, s1, s2, s3, s4, s5;

      peg$silentFails++;
      s0 = peg$currPos;
      s1 = peg$parsePathEltOrInverse();
      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$currPos;
        if (input.charCodeAt(peg$currPos) === 47) {
          s4 = peg$c348;
          peg$currPos++;
        } else {
          s4 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c349); }
        }
        if (s4 !== peg$FAILED) {
          s5 = peg$parsePathEltOrInverse();
          if (s5 !== peg$FAILED) {
            s4 = [s4, s5];
            s3 = s4;
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$currPos;
          if (input.charCodeAt(peg$currPos) === 47) {
            s4 = peg$c348;
            peg$currPos++;
          } else {
            s4 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c349); }
          }
          if (s4 !== peg$FAILED) {
            s5 = peg$parsePathEltOrInverse();
            if (s5 !== peg$FAILED) {
              s4 = [s4, s5];
              s3 = s4;
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        }
        if (s2 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c350(s1, s2);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c347); }
      }

      return s0;
    }

    function peg$parsePathElt() {
      var s0, s1, s2;

      peg$silentFails++;
      s0 = peg$currPos;
      s1 = peg$parsePathPrimary();
      if (s1 !== peg$FAILED) {
        s2 = peg$parsePathMod();
        if (s2 === peg$FAILED) {
          s2 = null;
        }
        if (s2 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c352(s1, s2);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c351); }
      }

      return s0;
    }

    function peg$parsePathEltOrInverse() {
      var s0, s1, s2;

      peg$silentFails++;
      s0 = peg$parsePathElt();
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        if (input.charCodeAt(peg$currPos) === 94) {
          s1 = peg$c354;
          peg$currPos++;
        } else {
          s1 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c355); }
        }
        if (s1 !== peg$FAILED) {
          s2 = peg$parsePathElt();
          if (s2 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c356(s2);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c353); }
      }

      return s0;
    }

    function peg$parsePathMod() {
      var s0, s1, s2, s3, s4, s5, s6, s7, s8;

      peg$silentFails++;
      if (input.charCodeAt(peg$currPos) === 42) {
        s0 = peg$c42;
        peg$currPos++;
      } else {
        s0 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c43); }
      }
      if (s0 === peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 63) {
          s0 = peg$c358;
          peg$currPos++;
        } else {
          s0 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c359); }
        }
        if (s0 === peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 43) {
            s0 = peg$c360;
            peg$currPos++;
          } else {
            s0 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c361); }
          }
          if (s0 === peg$FAILED) {
            s0 = peg$currPos;
            if (input.charCodeAt(peg$currPos) === 123) {
              s1 = peg$c55;
              peg$currPos++;
            } else {
              s1 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c56); }
            }
            if (s1 !== peg$FAILED) {
              s2 = peg$currPos;
              s3 = peg$parseInteger();
              if (s3 !== peg$FAILED) {
                s4 = peg$currPos;
                if (input.charCodeAt(peg$currPos) === 44) {
                  s5 = peg$c306;
                  peg$currPos++;
                } else {
                  s5 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c307); }
                }
                if (s5 !== peg$FAILED) {
                  if (input.charCodeAt(peg$currPos) === 125) {
                    s6 = peg$c57;
                    peg$currPos++;
                  } else {
                    s6 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$c58); }
                  }
                  if (s6 === peg$FAILED) {
                    s6 = peg$currPos;
                    s7 = peg$parseInteger();
                    if (s7 !== peg$FAILED) {
                      if (input.charCodeAt(peg$currPos) === 125) {
                        s8 = peg$c57;
                        peg$currPos++;
                      } else {
                        s8 = peg$FAILED;
                        if (peg$silentFails === 0) { peg$fail(peg$c58); }
                      }
                      if (s8 !== peg$FAILED) {
                        s7 = [s7, s8];
                        s6 = s7;
                      } else {
                        peg$currPos = s6;
                        s6 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s6;
                      s6 = peg$FAILED;
                    }
                  }
                  if (s6 !== peg$FAILED) {
                    s5 = [s5, s6];
                    s4 = s5;
                  } else {
                    peg$currPos = s4;
                    s4 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s4;
                  s4 = peg$FAILED;
                }
                if (s4 === peg$FAILED) {
                  if (input.charCodeAt(peg$currPos) === 125) {
                    s4 = peg$c57;
                    peg$currPos++;
                  } else {
                    s4 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$c58); }
                  }
                }
                if (s4 !== peg$FAILED) {
                  s3 = [s3, s4];
                  s2 = s3;
                } else {
                  peg$currPos = s2;
                  s2 = peg$FAILED;
                }
              } else {
                peg$currPos = s2;
                s2 = peg$FAILED;
              }
              if (s2 === peg$FAILED) {
                s2 = peg$currPos;
                if (input.charCodeAt(peg$currPos) === 44) {
                  s3 = peg$c306;
                  peg$currPos++;
                } else {
                  s3 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c307); }
                }
                if (s3 !== peg$FAILED) {
                  s4 = peg$parseInteger();
                  if (s4 !== peg$FAILED) {
                    if (input.charCodeAt(peg$currPos) === 125) {
                      s5 = peg$c57;
                      peg$currPos++;
                    } else {
                      s5 = peg$FAILED;
                      if (peg$silentFails === 0) { peg$fail(peg$c58); }
                    }
                    if (s5 !== peg$FAILED) {
                      s3 = [s3, s4, s5];
                      s2 = s3;
                    } else {
                      peg$currPos = s2;
                      s2 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s2;
                    s2 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s2;
                  s2 = peg$FAILED;
                }
              }
              if (s2 !== peg$FAILED) {
                s1 = [s1, s2];
                s0 = s1;
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          }
        }
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c357); }
      }

      return s0;
    }

    function peg$parsePathPrimary() {
      var s0, s1, s2, s3;

      peg$silentFails++;
      s0 = peg$parseIRIref();
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        if (input.charCodeAt(peg$currPos) === 97) {
          s1 = peg$c330;
          peg$currPos++;
        } else {
          s1 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c331); }
        }
        if (s1 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c332();
        }
        s0 = s1;
        if (s0 === peg$FAILED) {
          s0 = peg$currPos;
          if (input.charCodeAt(peg$currPos) === 33) {
            s1 = peg$c363;
            peg$currPos++;
          } else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c364); }
          }
          if (s1 !== peg$FAILED) {
            s2 = peg$parsePathNegatedPropertySet();
            if (s2 !== peg$FAILED) {
              s1 = [s1, s2];
              s0 = s1;
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
          if (s0 === peg$FAILED) {
            s0 = peg$currPos;
            if (input.charCodeAt(peg$currPos) === 40) {
              s1 = peg$c34;
              peg$currPos++;
            } else {
              s1 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c35); }
            }
            if (s1 !== peg$FAILED) {
              s2 = peg$parsePath();
              if (s2 !== peg$FAILED) {
                if (input.charCodeAt(peg$currPos) === 41) {
                  s3 = peg$c40;
                  peg$currPos++;
                } else {
                  s3 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c41); }
                }
                if (s3 !== peg$FAILED) {
                  peg$savedPos = s0;
                  s1 = peg$c251(s2);
                  s0 = s1;
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          }
        }
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c362); }
      }

      return s0;
    }

    function peg$parsePathNegatedPropertySet() {
      var s0, s1, s2, s3, s4, s5, s6, s7;

      s0 = peg$parsePathOneInPropertySet();
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        if (input.charCodeAt(peg$currPos) === 40) {
          s1 = peg$c34;
          peg$currPos++;
        } else {
          s1 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c35); }
        }
        if (s1 !== peg$FAILED) {
          s2 = peg$currPos;
          s3 = peg$parsePathOneInPropertySet();
          if (s3 !== peg$FAILED) {
            s4 = [];
            s5 = peg$currPos;
            if (input.charCodeAt(peg$currPos) === 124) {
              s6 = peg$c344;
              peg$currPos++;
            } else {
              s6 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c345); }
            }
            if (s6 !== peg$FAILED) {
              s7 = peg$parsePathOneInPropertySet();
              if (s7 !== peg$FAILED) {
                s6 = [s6, s7];
                s5 = s6;
              } else {
                peg$currPos = s5;
                s5 = peg$FAILED;
              }
            } else {
              peg$currPos = s5;
              s5 = peg$FAILED;
            }
            while (s5 !== peg$FAILED) {
              s4.push(s5);
              s5 = peg$currPos;
              if (input.charCodeAt(peg$currPos) === 124) {
                s6 = peg$c344;
                peg$currPos++;
              } else {
                s6 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c345); }
              }
              if (s6 !== peg$FAILED) {
                s7 = peg$parsePathOneInPropertySet();
                if (s7 !== peg$FAILED) {
                  s6 = [s6, s7];
                  s5 = s6;
                } else {
                  peg$currPos = s5;
                  s5 = peg$FAILED;
                }
              } else {
                peg$currPos = s5;
                s5 = peg$FAILED;
              }
            }
            if (s4 !== peg$FAILED) {
              s3 = [s3, s4];
              s2 = s3;
            } else {
              peg$currPos = s2;
              s2 = peg$FAILED;
            }
          } else {
            peg$currPos = s2;
            s2 = peg$FAILED;
          }
          if (s2 === peg$FAILED) {
            s2 = null;
          }
          if (s2 !== peg$FAILED) {
            if (input.charCodeAt(peg$currPos) === 41) {
              s3 = peg$c40;
              peg$currPos++;
            } else {
              s3 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c41); }
            }
            if (s3 !== peg$FAILED) {
              s1 = [s1, s2, s3];
              s0 = s1;
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      }

      return s0;
    }

    function peg$parsePathOneInPropertySet() {
      var s0, s1, s2;

      peg$silentFails++;
      s0 = peg$parseIRIref();
      if (s0 === peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 97) {
          s0 = peg$c330;
          peg$currPos++;
        } else {
          s0 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c331); }
        }
        if (s0 === peg$FAILED) {
          s0 = peg$currPos;
          if (input.charCodeAt(peg$currPos) === 94) {
            s1 = peg$c354;
            peg$currPos++;
          } else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c355); }
          }
          if (s1 !== peg$FAILED) {
            s2 = peg$parseIRIref();
            if (s2 === peg$FAILED) {
              if (input.charCodeAt(peg$currPos) === 97) {
                s2 = peg$c330;
                peg$currPos++;
              } else {
                s2 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c331); }
              }
            }
            if (s2 !== peg$FAILED) {
              s1 = [s1, s2];
              s0 = s1;
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        }
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c365); }
      }

      return s0;
    }

    function peg$parseInteger() {
      var s0, s1;

      peg$silentFails++;
      s0 = peg$parseINTEGER();
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c366); }
      }

      return s0;
    }

    function peg$parseTriplesNodePath() {
      var s0, s1;

      peg$silentFails++;
      s0 = peg$currPos;
      s1 = peg$parseCollectionPath();
      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$c368(s1);
      }
      s0 = s1;
      if (s0 === peg$FAILED) {
        s0 = peg$parseBlankNodePropertyListPath();
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c367); }
      }

      return s0;
    }

    function peg$parseTriplesNode() {
      var s0, s1;

      peg$silentFails++;
      s0 = peg$currPos;
      s1 = peg$parseCollection();
      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$c370(s1);
      }
      s0 = s1;
      if (s0 === peg$FAILED) {
        s0 = peg$parseBlankNodePropertyList();
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c369); }
      }

      return s0;
    }

    function peg$parseBlankNodePropertyListPath() {
      var s0, s1, s2, s3, s4, s5, s6, s7;

      peg$silentFails++;
      s0 = peg$currPos;
      s1 = [];
      s2 = peg$parseWS();
      while (s2 !== peg$FAILED) {
        s1.push(s2);
        s2 = peg$parseWS();
      }
      if (s1 !== peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 91) {
          s2 = peg$c372;
          peg$currPos++;
        } else {
          s2 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c373); }
        }
        if (s2 !== peg$FAILED) {
          s3 = [];
          s4 = peg$parseWS();
          while (s4 !== peg$FAILED) {
            s3.push(s4);
            s4 = peg$parseWS();
          }
          if (s3 !== peg$FAILED) {
            s4 = peg$parsePropertyListNotEmptyPath();
            if (s4 !== peg$FAILED) {
              if (input.charCodeAt(peg$currPos) === 93) {
                s5 = peg$c374;
                peg$currPos++;
              } else {
                s5 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c375); }
              }
              if (s5 !== peg$FAILED) {
                s6 = [];
                s7 = peg$parseWS();
                while (s7 !== peg$FAILED) {
                  s6.push(s7);
                  s7 = peg$parseWS();
                }
                if (s6 !== peg$FAILED) {
                  peg$savedPos = s0;
                  s1 = peg$c376(s4);
                  s0 = s1;
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c371); }
      }

      return s0;
    }

    function peg$parseBlankNodePropertyList() {
      var s0, s1, s2, s3, s4, s5, s6, s7, s8;

      peg$silentFails++;
      s0 = peg$currPos;
      s1 = [];
      s2 = peg$parseWS();
      while (s2 !== peg$FAILED) {
        s1.push(s2);
        s2 = peg$parseWS();
      }
      if (s1 !== peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 91) {
          s2 = peg$c372;
          peg$currPos++;
        } else {
          s2 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c373); }
        }
        if (s2 !== peg$FAILED) {
          s3 = [];
          s4 = peg$parseWS();
          while (s4 !== peg$FAILED) {
            s3.push(s4);
            s4 = peg$parseWS();
          }
          if (s3 !== peg$FAILED) {
            s4 = peg$parsePropertyListNotEmpty();
            if (s4 !== peg$FAILED) {
              s5 = [];
              s6 = peg$parseWS();
              while (s6 !== peg$FAILED) {
                s5.push(s6);
                s6 = peg$parseWS();
              }
              if (s5 !== peg$FAILED) {
                if (input.charCodeAt(peg$currPos) === 93) {
                  s6 = peg$c374;
                  peg$currPos++;
                } else {
                  s6 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c375); }
                }
                if (s6 !== peg$FAILED) {
                  s7 = [];
                  s8 = peg$parseWS();
                  while (s8 !== peg$FAILED) {
                    s7.push(s8);
                    s8 = peg$parseWS();
                  }
                  if (s7 !== peg$FAILED) {
                    peg$savedPos = s0;
                    s1 = peg$c378(s4);
                    s0 = s1;
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c377); }
      }

      return s0;
    }

    function peg$parseCollectionPath() {
      var s0, s1, s2, s3, s4, s5, s6, s7, s8;

      peg$silentFails++;
      s0 = peg$currPos;
      s1 = [];
      s2 = peg$parseWS();
      while (s2 !== peg$FAILED) {
        s1.push(s2);
        s2 = peg$parseWS();
      }
      if (s1 !== peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 40) {
          s2 = peg$c34;
          peg$currPos++;
        } else {
          s2 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c35); }
        }
        if (s2 !== peg$FAILED) {
          s3 = [];
          s4 = peg$parseWS();
          while (s4 !== peg$FAILED) {
            s3.push(s4);
            s4 = peg$parseWS();
          }
          if (s3 !== peg$FAILED) {
            s4 = [];
            s5 = peg$parseGraphNodePath();
            if (s5 !== peg$FAILED) {
              while (s5 !== peg$FAILED) {
                s4.push(s5);
                s5 = peg$parseGraphNodePath();
              }
            } else {
              s4 = peg$FAILED;
            }
            if (s4 !== peg$FAILED) {
              s5 = [];
              s6 = peg$parseWS();
              while (s6 !== peg$FAILED) {
                s5.push(s6);
                s6 = peg$parseWS();
              }
              if (s5 !== peg$FAILED) {
                if (input.charCodeAt(peg$currPos) === 41) {
                  s6 = peg$c40;
                  peg$currPos++;
                } else {
                  s6 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c41); }
                }
                if (s6 !== peg$FAILED) {
                  s7 = [];
                  s8 = peg$parseWS();
                  while (s8 !== peg$FAILED) {
                    s7.push(s8);
                    s8 = peg$parseWS();
                  }
                  if (s7 !== peg$FAILED) {
                    peg$savedPos = s0;
                    s1 = peg$c380(s4);
                    s0 = s1;
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c379); }
      }

      return s0;
    }

    function peg$parseCollection() {
      var s0, s1, s2, s3, s4, s5, s6, s7, s8;

      peg$silentFails++;
      s0 = peg$currPos;
      s1 = [];
      s2 = peg$parseWS();
      while (s2 !== peg$FAILED) {
        s1.push(s2);
        s2 = peg$parseWS();
      }
      if (s1 !== peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 40) {
          s2 = peg$c34;
          peg$currPos++;
        } else {
          s2 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c35); }
        }
        if (s2 !== peg$FAILED) {
          s3 = [];
          s4 = peg$parseWS();
          while (s4 !== peg$FAILED) {
            s3.push(s4);
            s4 = peg$parseWS();
          }
          if (s3 !== peg$FAILED) {
            s4 = [];
            s5 = peg$parseGraphNode();
            if (s5 !== peg$FAILED) {
              while (s5 !== peg$FAILED) {
                s4.push(s5);
                s5 = peg$parseGraphNode();
              }
            } else {
              s4 = peg$FAILED;
            }
            if (s4 !== peg$FAILED) {
              s5 = [];
              s6 = peg$parseWS();
              while (s6 !== peg$FAILED) {
                s5.push(s6);
                s6 = peg$parseWS();
              }
              if (s5 !== peg$FAILED) {
                if (input.charCodeAt(peg$currPos) === 41) {
                  s6 = peg$c40;
                  peg$currPos++;
                } else {
                  s6 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c41); }
                }
                if (s6 !== peg$FAILED) {
                  s7 = [];
                  s8 = peg$parseWS();
                  while (s8 !== peg$FAILED) {
                    s7.push(s8);
                    s8 = peg$parseWS();
                  }
                  if (s7 !== peg$FAILED) {
                    peg$savedPos = s0;
                    s1 = peg$c380(s4);
                    s0 = s1;
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c381); }
      }

      return s0;
    }

    function peg$parseGraphNodePath() {
      var s0, s1, s2, s3, s4, s5;

      peg$silentFails++;
      s0 = peg$currPos;
      s1 = peg$currPos;
      s2 = [];
      s3 = peg$parseWS();
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$parseWS();
      }
      if (s2 !== peg$FAILED) {
        s3 = peg$parseVarOrTerm();
        if (s3 !== peg$FAILED) {
          s4 = [];
          s5 = peg$parseWS();
          while (s5 !== peg$FAILED) {
            s4.push(s5);
            s5 = peg$parseWS();
          }
          if (s4 !== peg$FAILED) {
            s2 = [s2, s3, s4];
            s1 = s2;
          } else {
            peg$currPos = s1;
            s1 = peg$FAILED;
          }
        } else {
          peg$currPos = s1;
          s1 = peg$FAILED;
        }
      } else {
        peg$currPos = s1;
        s1 = peg$FAILED;
      }
      if (s1 === peg$FAILED) {
        s1 = peg$currPos;
        s2 = [];
        s3 = peg$parseWS();
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parseWS();
        }
        if (s2 !== peg$FAILED) {
          s3 = peg$parseTriplesNodePath();
          if (s3 !== peg$FAILED) {
            s4 = [];
            s5 = peg$parseWS();
            while (s5 !== peg$FAILED) {
              s4.push(s5);
              s5 = peg$parseWS();
            }
            if (s4 !== peg$FAILED) {
              s2 = [s2, s3, s4];
              s1 = s2;
            } else {
              peg$currPos = s1;
              s1 = peg$FAILED;
            }
          } else {
            peg$currPos = s1;
            s1 = peg$FAILED;
          }
        } else {
          peg$currPos = s1;
          s1 = peg$FAILED;
        }
      }
      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$c383(s1);
      }
      s0 = s1;
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c382); }
      }

      return s0;
    }

    function peg$parseGraphNode() {
      var s0, s1, s2, s3, s4, s5;

      peg$silentFails++;
      s0 = peg$currPos;
      s1 = peg$currPos;
      s2 = [];
      s3 = peg$parseWS();
      while (s3 !== peg$FAILED) {
        s2.push(s3);
        s3 = peg$parseWS();
      }
      if (s2 !== peg$FAILED) {
        s3 = peg$parseVarOrTerm();
        if (s3 !== peg$FAILED) {
          s4 = [];
          s5 = peg$parseWS();
          while (s5 !== peg$FAILED) {
            s4.push(s5);
            s5 = peg$parseWS();
          }
          if (s4 !== peg$FAILED) {
            s2 = [s2, s3, s4];
            s1 = s2;
          } else {
            peg$currPos = s1;
            s1 = peg$FAILED;
          }
        } else {
          peg$currPos = s1;
          s1 = peg$FAILED;
        }
      } else {
        peg$currPos = s1;
        s1 = peg$FAILED;
      }
      if (s1 === peg$FAILED) {
        s1 = peg$currPos;
        s2 = [];
        s3 = peg$parseWS();
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parseWS();
        }
        if (s2 !== peg$FAILED) {
          s3 = peg$parseTriplesNode();
          if (s3 !== peg$FAILED) {
            s4 = [];
            s5 = peg$parseWS();
            while (s5 !== peg$FAILED) {
              s4.push(s5);
              s5 = peg$parseWS();
            }
            if (s4 !== peg$FAILED) {
              s2 = [s2, s3, s4];
              s1 = s2;
            } else {
              peg$currPos = s1;
              s1 = peg$FAILED;
            }
          } else {
            peg$currPos = s1;
            s1 = peg$FAILED;
          }
        } else {
          peg$currPos = s1;
          s1 = peg$FAILED;
        }
      }
      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$c383(s1);
      }
      s0 = s1;
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c384); }
      }

      return s0;
    }

    function peg$parseVarOrTerm() {
      var s0, s1;

      peg$silentFails++;
      s0 = peg$parseVar();
      if (s0 === peg$FAILED) {
        s0 = peg$parseGraphTerm();
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c385); }
      }

      return s0;
    }

    function peg$parseVarOrIRIref() {
      var s0, s1;

      peg$silentFails++;
      s0 = peg$parseVar();
      if (s0 === peg$FAILED) {
        s0 = peg$parseIRIref();
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c386); }
      }

      return s0;
    }

    function peg$parseVar() {
      var s0, s1, s2, s3, s4;

      peg$silentFails++;
      s0 = peg$currPos;
      s1 = [];
      s2 = peg$parseWS();
      while (s2 !== peg$FAILED) {
        s1.push(s2);
        s2 = peg$parseWS();
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parseVAR1();
        if (s2 === peg$FAILED) {
          s2 = peg$parseVAR2();
        }
        if (s2 !== peg$FAILED) {
          s3 = [];
          s4 = peg$parseWS();
          while (s4 !== peg$FAILED) {
            s3.push(s4);
            s4 = peg$parseWS();
          }
          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c388(s2);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c387); }
      }

      return s0;
    }

    function peg$parseGraphTerm() {
      var s0, s1;

      peg$silentFails++;
      s0 = peg$parseIRIref();
      if (s0 === peg$FAILED) {
        s0 = peg$parseRDFLiteral();
        if (s0 === peg$FAILED) {
          s0 = peg$parseNumericLiteral();
          if (s0 === peg$FAILED) {
            s0 = peg$parseBooleanLiteral();
            if (s0 === peg$FAILED) {
              s0 = peg$parseBlankNode();
              if (s0 === peg$FAILED) {
                s0 = peg$parseNIL();
              }
            }
          }
        }
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c389); }
      }

      return s0;
    }

    function peg$parseExpression() {
      var s0, s1;

      peg$silentFails++;
      s0 = peg$parseConditionalOrExpression();
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c390); }
      }

      return s0;
    }

    function peg$parseConditionalOrExpression() {
      var s0, s1, s2, s3, s4, s5, s6, s7;

      peg$silentFails++;
      s0 = peg$currPos;
      s1 = peg$parseConditionalAndExpression();
      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$currPos;
        s4 = [];
        s5 = peg$parseWS();
        while (s5 !== peg$FAILED) {
          s4.push(s5);
          s5 = peg$parseWS();
        }
        if (s4 !== peg$FAILED) {
          if (input.substr(peg$currPos, 2) === peg$c392) {
            s5 = peg$c392;
            peg$currPos += 2;
          } else {
            s5 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c393); }
          }
          if (s5 !== peg$FAILED) {
            s6 = [];
            s7 = peg$parseWS();
            while (s7 !== peg$FAILED) {
              s6.push(s7);
              s7 = peg$parseWS();
            }
            if (s6 !== peg$FAILED) {
              s7 = peg$parseConditionalAndExpression();
              if (s7 !== peg$FAILED) {
                s4 = [s4, s5, s6, s7];
                s3 = s4;
              } else {
                peg$currPos = s3;
                s3 = peg$FAILED;
              }
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$currPos;
          s4 = [];
          s5 = peg$parseWS();
          while (s5 !== peg$FAILED) {
            s4.push(s5);
            s5 = peg$parseWS();
          }
          if (s4 !== peg$FAILED) {
            if (input.substr(peg$currPos, 2) === peg$c392) {
              s5 = peg$c392;
              peg$currPos += 2;
            } else {
              s5 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c393); }
            }
            if (s5 !== peg$FAILED) {
              s6 = [];
              s7 = peg$parseWS();
              while (s7 !== peg$FAILED) {
                s6.push(s7);
                s7 = peg$parseWS();
              }
              if (s6 !== peg$FAILED) {
                s7 = peg$parseConditionalAndExpression();
                if (s7 !== peg$FAILED) {
                  s4 = [s4, s5, s6, s7];
                  s3 = s4;
                } else {
                  peg$currPos = s3;
                  s3 = peg$FAILED;
                }
              } else {
                peg$currPos = s3;
                s3 = peg$FAILED;
              }
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        }
        if (s2 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c394(s1, s2);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c391); }
      }

      return s0;
    }

    function peg$parseConditionalAndExpression() {
      var s0, s1, s2, s3, s4, s5, s6, s7;

      peg$silentFails++;
      s0 = peg$currPos;
      s1 = peg$parseValueLogical();
      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$currPos;
        s4 = [];
        s5 = peg$parseWS();
        while (s5 !== peg$FAILED) {
          s4.push(s5);
          s5 = peg$parseWS();
        }
        if (s4 !== peg$FAILED) {
          if (input.substr(peg$currPos, 2) === peg$c396) {
            s5 = peg$c396;
            peg$currPos += 2;
          } else {
            s5 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c397); }
          }
          if (s5 !== peg$FAILED) {
            s6 = [];
            s7 = peg$parseWS();
            while (s7 !== peg$FAILED) {
              s6.push(s7);
              s7 = peg$parseWS();
            }
            if (s6 !== peg$FAILED) {
              s7 = peg$parseValueLogical();
              if (s7 !== peg$FAILED) {
                s4 = [s4, s5, s6, s7];
                s3 = s4;
              } else {
                peg$currPos = s3;
                s3 = peg$FAILED;
              }
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$currPos;
          s4 = [];
          s5 = peg$parseWS();
          while (s5 !== peg$FAILED) {
            s4.push(s5);
            s5 = peg$parseWS();
          }
          if (s4 !== peg$FAILED) {
            if (input.substr(peg$currPos, 2) === peg$c396) {
              s5 = peg$c396;
              peg$currPos += 2;
            } else {
              s5 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c397); }
            }
            if (s5 !== peg$FAILED) {
              s6 = [];
              s7 = peg$parseWS();
              while (s7 !== peg$FAILED) {
                s6.push(s7);
                s7 = peg$parseWS();
              }
              if (s6 !== peg$FAILED) {
                s7 = peg$parseValueLogical();
                if (s7 !== peg$FAILED) {
                  s4 = [s4, s5, s6, s7];
                  s3 = s4;
                } else {
                  peg$currPos = s3;
                  s3 = peg$FAILED;
                }
              } else {
                peg$currPos = s3;
                s3 = peg$FAILED;
              }
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        }
        if (s2 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c398(s1, s2);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c395); }
      }

      return s0;
    }

    function peg$parseValueLogical() {
      var s0, s1;

      peg$silentFails++;
      s0 = peg$parseRelationalExpression();
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c399); }
      }

      return s0;
    }

    function peg$parseRelationalExpression() {
      var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12;

      peg$silentFails++;
      s0 = peg$currPos;
      s1 = peg$parseNumericExpression();
      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$currPos;
        s4 = [];
        s5 = peg$parseWS();
        while (s5 !== peg$FAILED) {
          s4.push(s5);
          s5 = peg$parseWS();
        }
        if (s4 !== peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 61) {
            s5 = peg$c401;
            peg$currPos++;
          } else {
            s5 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c402); }
          }
          if (s5 !== peg$FAILED) {
            s6 = [];
            s7 = peg$parseWS();
            while (s7 !== peg$FAILED) {
              s6.push(s7);
              s7 = peg$parseWS();
            }
            if (s6 !== peg$FAILED) {
              s7 = peg$parseNumericExpression();
              if (s7 !== peg$FAILED) {
                s4 = [s4, s5, s6, s7];
                s3 = s4;
              } else {
                peg$currPos = s3;
                s3 = peg$FAILED;
              }
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
        if (s3 === peg$FAILED) {
          s3 = peg$currPos;
          s4 = [];
          s5 = peg$parseWS();
          while (s5 !== peg$FAILED) {
            s4.push(s5);
            s5 = peg$parseWS();
          }
          if (s4 !== peg$FAILED) {
            if (input.substr(peg$currPos, 2) === peg$c403) {
              s5 = peg$c403;
              peg$currPos += 2;
            } else {
              s5 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c404); }
            }
            if (s5 !== peg$FAILED) {
              s6 = [];
              s7 = peg$parseWS();
              while (s7 !== peg$FAILED) {
                s6.push(s7);
                s7 = peg$parseWS();
              }
              if (s6 !== peg$FAILED) {
                s7 = peg$parseNumericExpression();
                if (s7 !== peg$FAILED) {
                  s4 = [s4, s5, s6, s7];
                  s3 = s4;
                } else {
                  peg$currPos = s3;
                  s3 = peg$FAILED;
                }
              } else {
                peg$currPos = s3;
                s3 = peg$FAILED;
              }
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
          if (s3 === peg$FAILED) {
            s3 = peg$currPos;
            s4 = [];
            s5 = peg$parseWS();
            while (s5 !== peg$FAILED) {
              s4.push(s5);
              s5 = peg$parseWS();
            }
            if (s4 !== peg$FAILED) {
              if (input.charCodeAt(peg$currPos) === 60) {
                s5 = peg$c405;
                peg$currPos++;
              } else {
                s5 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c406); }
              }
              if (s5 !== peg$FAILED) {
                s6 = [];
                s7 = peg$parseWS();
                while (s7 !== peg$FAILED) {
                  s6.push(s7);
                  s7 = peg$parseWS();
                }
                if (s6 !== peg$FAILED) {
                  s7 = peg$parseNumericExpression();
                  if (s7 !== peg$FAILED) {
                    s4 = [s4, s5, s6, s7];
                    s3 = s4;
                  } else {
                    peg$currPos = s3;
                    s3 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s3;
                  s3 = peg$FAILED;
                }
              } else {
                peg$currPos = s3;
                s3 = peg$FAILED;
              }
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
            if (s3 === peg$FAILED) {
              s3 = peg$currPos;
              s4 = [];
              s5 = peg$parseWS();
              while (s5 !== peg$FAILED) {
                s4.push(s5);
                s5 = peg$parseWS();
              }
              if (s4 !== peg$FAILED) {
                if (input.charCodeAt(peg$currPos) === 62) {
                  s5 = peg$c407;
                  peg$currPos++;
                } else {
                  s5 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c408); }
                }
                if (s5 !== peg$FAILED) {
                  s6 = [];
                  s7 = peg$parseWS();
                  while (s7 !== peg$FAILED) {
                    s6.push(s7);
                    s7 = peg$parseWS();
                  }
                  if (s6 !== peg$FAILED) {
                    s7 = peg$parseNumericExpression();
                    if (s7 !== peg$FAILED) {
                      s4 = [s4, s5, s6, s7];
                      s3 = s4;
                    } else {
                      peg$currPos = s3;
                      s3 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s3;
                    s3 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s3;
                  s3 = peg$FAILED;
                }
              } else {
                peg$currPos = s3;
                s3 = peg$FAILED;
              }
              if (s3 === peg$FAILED) {
                s3 = peg$currPos;
                s4 = [];
                s5 = peg$parseWS();
                while (s5 !== peg$FAILED) {
                  s4.push(s5);
                  s5 = peg$parseWS();
                }
                if (s4 !== peg$FAILED) {
                  if (input.substr(peg$currPos, 2) === peg$c409) {
                    s5 = peg$c409;
                    peg$currPos += 2;
                  } else {
                    s5 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$c410); }
                  }
                  if (s5 !== peg$FAILED) {
                    s6 = [];
                    s7 = peg$parseWS();
                    while (s7 !== peg$FAILED) {
                      s6.push(s7);
                      s7 = peg$parseWS();
                    }
                    if (s6 !== peg$FAILED) {
                      s7 = peg$parseNumericExpression();
                      if (s7 !== peg$FAILED) {
                        s4 = [s4, s5, s6, s7];
                        s3 = s4;
                      } else {
                        peg$currPos = s3;
                        s3 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s3;
                      s3 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s3;
                    s3 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s3;
                  s3 = peg$FAILED;
                }
                if (s3 === peg$FAILED) {
                  s3 = peg$currPos;
                  s4 = [];
                  s5 = peg$parseWS();
                  while (s5 !== peg$FAILED) {
                    s4.push(s5);
                    s5 = peg$parseWS();
                  }
                  if (s4 !== peg$FAILED) {
                    if (input.substr(peg$currPos, 2) === peg$c411) {
                      s5 = peg$c411;
                      peg$currPos += 2;
                    } else {
                      s5 = peg$FAILED;
                      if (peg$silentFails === 0) { peg$fail(peg$c412); }
                    }
                    if (s5 !== peg$FAILED) {
                      s6 = [];
                      s7 = peg$parseWS();
                      while (s7 !== peg$FAILED) {
                        s6.push(s7);
                        s7 = peg$parseWS();
                      }
                      if (s6 !== peg$FAILED) {
                        s7 = peg$parseNumericExpression();
                        if (s7 !== peg$FAILED) {
                          s4 = [s4, s5, s6, s7];
                          s3 = s4;
                        } else {
                          peg$currPos = s3;
                          s3 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s3;
                        s3 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s3;
                      s3 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s3;
                    s3 = peg$FAILED;
                  }
                  if (s3 === peg$FAILED) {
                    s3 = peg$currPos;
                    s4 = [];
                    s5 = peg$parseWS();
                    while (s5 !== peg$FAILED) {
                      s4.push(s5);
                      s5 = peg$parseWS();
                    }
                    if (s4 !== peg$FAILED) {
                      if (input.charCodeAt(peg$currPos) === 73) {
                        s5 = peg$c413;
                        peg$currPos++;
                      } else {
                        s5 = peg$FAILED;
                        if (peg$silentFails === 0) { peg$fail(peg$c414); }
                      }
                      if (s5 === peg$FAILED) {
                        if (input.charCodeAt(peg$currPos) === 105) {
                          s5 = peg$c415;
                          peg$currPos++;
                        } else {
                          s5 = peg$FAILED;
                          if (peg$silentFails === 0) { peg$fail(peg$c416); }
                        }
                      }
                      if (s5 !== peg$FAILED) {
                        if (input.charCodeAt(peg$currPos) === 78) {
                          s6 = peg$c417;
                          peg$currPos++;
                        } else {
                          s6 = peg$FAILED;
                          if (peg$silentFails === 0) { peg$fail(peg$c418); }
                        }
                        if (s6 === peg$FAILED) {
                          if (input.charCodeAt(peg$currPos) === 110) {
                            s6 = peg$c419;
                            peg$currPos++;
                          } else {
                            s6 = peg$FAILED;
                            if (peg$silentFails === 0) { peg$fail(peg$c420); }
                          }
                        }
                        if (s6 !== peg$FAILED) {
                          s7 = [];
                          s8 = peg$parseWS();
                          while (s8 !== peg$FAILED) {
                            s7.push(s8);
                            s8 = peg$parseWS();
                          }
                          if (s7 !== peg$FAILED) {
                            s8 = peg$parseExpressionList();
                            if (s8 !== peg$FAILED) {
                              s4 = [s4, s5, s6, s7, s8];
                              s3 = s4;
                            } else {
                              peg$currPos = s3;
                              s3 = peg$FAILED;
                            }
                          } else {
                            peg$currPos = s3;
                            s3 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s3;
                          s3 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s3;
                        s3 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s3;
                      s3 = peg$FAILED;
                    }
                    if (s3 === peg$FAILED) {
                      s3 = peg$currPos;
                      s4 = [];
                      s5 = peg$parseWS();
                      while (s5 !== peg$FAILED) {
                        s4.push(s5);
                        s5 = peg$parseWS();
                      }
                      if (s4 !== peg$FAILED) {
                        if (input.charCodeAt(peg$currPos) === 78) {
                          s5 = peg$c417;
                          peg$currPos++;
                        } else {
                          s5 = peg$FAILED;
                          if (peg$silentFails === 0) { peg$fail(peg$c418); }
                        }
                        if (s5 === peg$FAILED) {
                          if (input.charCodeAt(peg$currPos) === 110) {
                            s5 = peg$c419;
                            peg$currPos++;
                          } else {
                            s5 = peg$FAILED;
                            if (peg$silentFails === 0) { peg$fail(peg$c420); }
                          }
                        }
                        if (s5 !== peg$FAILED) {
                          if (input.charCodeAt(peg$currPos) === 79) {
                            s6 = peg$c421;
                            peg$currPos++;
                          } else {
                            s6 = peg$FAILED;
                            if (peg$silentFails === 0) { peg$fail(peg$c422); }
                          }
                          if (s6 === peg$FAILED) {
                            if (input.charCodeAt(peg$currPos) === 111) {
                              s6 = peg$c423;
                              peg$currPos++;
                            } else {
                              s6 = peg$FAILED;
                              if (peg$silentFails === 0) { peg$fail(peg$c424); }
                            }
                          }
                          if (s6 !== peg$FAILED) {
                            if (input.charCodeAt(peg$currPos) === 84) {
                              s7 = peg$c425;
                              peg$currPos++;
                            } else {
                              s7 = peg$FAILED;
                              if (peg$silentFails === 0) { peg$fail(peg$c426); }
                            }
                            if (s7 === peg$FAILED) {
                              if (input.charCodeAt(peg$currPos) === 116) {
                                s7 = peg$c427;
                                peg$currPos++;
                              } else {
                                s7 = peg$FAILED;
                                if (peg$silentFails === 0) { peg$fail(peg$c428); }
                              }
                            }
                            if (s7 !== peg$FAILED) {
                              s8 = [];
                              s9 = peg$parseWS();
                              while (s9 !== peg$FAILED) {
                                s8.push(s9);
                                s9 = peg$parseWS();
                              }
                              if (s8 !== peg$FAILED) {
                                if (input.charCodeAt(peg$currPos) === 73) {
                                  s9 = peg$c413;
                                  peg$currPos++;
                                } else {
                                  s9 = peg$FAILED;
                                  if (peg$silentFails === 0) { peg$fail(peg$c414); }
                                }
                                if (s9 === peg$FAILED) {
                                  if (input.charCodeAt(peg$currPos) === 105) {
                                    s9 = peg$c415;
                                    peg$currPos++;
                                  } else {
                                    s9 = peg$FAILED;
                                    if (peg$silentFails === 0) { peg$fail(peg$c416); }
                                  }
                                }
                                if (s9 !== peg$FAILED) {
                                  if (input.charCodeAt(peg$currPos) === 78) {
                                    s10 = peg$c417;
                                    peg$currPos++;
                                  } else {
                                    s10 = peg$FAILED;
                                    if (peg$silentFails === 0) { peg$fail(peg$c418); }
                                  }
                                  if (s10 === peg$FAILED) {
                                    if (input.charCodeAt(peg$currPos) === 110) {
                                      s10 = peg$c419;
                                      peg$currPos++;
                                    } else {
                                      s10 = peg$FAILED;
                                      if (peg$silentFails === 0) { peg$fail(peg$c420); }
                                    }
                                  }
                                  if (s10 !== peg$FAILED) {
                                    s11 = [];
                                    s12 = peg$parseWS();
                                    while (s12 !== peg$FAILED) {
                                      s11.push(s12);
                                      s12 = peg$parseWS();
                                    }
                                    if (s11 !== peg$FAILED) {
                                      s12 = peg$parseExpressionList();
                                      if (s12 !== peg$FAILED) {
                                        s4 = [s4, s5, s6, s7, s8, s9, s10, s11, s12];
                                        s3 = s4;
                                      } else {
                                        peg$currPos = s3;
                                        s3 = peg$FAILED;
                                      }
                                    } else {
                                      peg$currPos = s3;
                                      s3 = peg$FAILED;
                                    }
                                  } else {
                                    peg$currPos = s3;
                                    s3 = peg$FAILED;
                                  }
                                } else {
                                  peg$currPos = s3;
                                  s3 = peg$FAILED;
                                }
                              } else {
                                peg$currPos = s3;
                                s3 = peg$FAILED;
                              }
                            } else {
                              peg$currPos = s3;
                              s3 = peg$FAILED;
                            }
                          } else {
                            peg$currPos = s3;
                            s3 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s3;
                          s3 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s3;
                        s3 = peg$FAILED;
                      }
                    }
                  }
                }
              }
            }
          }
        }
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$currPos;
          s4 = [];
          s5 = peg$parseWS();
          while (s5 !== peg$FAILED) {
            s4.push(s5);
            s5 = peg$parseWS();
          }
          if (s4 !== peg$FAILED) {
            if (input.charCodeAt(peg$currPos) === 61) {
              s5 = peg$c401;
              peg$currPos++;
            } else {
              s5 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c402); }
            }
            if (s5 !== peg$FAILED) {
              s6 = [];
              s7 = peg$parseWS();
              while (s7 !== peg$FAILED) {
                s6.push(s7);
                s7 = peg$parseWS();
              }
              if (s6 !== peg$FAILED) {
                s7 = peg$parseNumericExpression();
                if (s7 !== peg$FAILED) {
                  s4 = [s4, s5, s6, s7];
                  s3 = s4;
                } else {
                  peg$currPos = s3;
                  s3 = peg$FAILED;
                }
              } else {
                peg$currPos = s3;
                s3 = peg$FAILED;
              }
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
          if (s3 === peg$FAILED) {
            s3 = peg$currPos;
            s4 = [];
            s5 = peg$parseWS();
            while (s5 !== peg$FAILED) {
              s4.push(s5);
              s5 = peg$parseWS();
            }
            if (s4 !== peg$FAILED) {
              if (input.substr(peg$currPos, 2) === peg$c403) {
                s5 = peg$c403;
                peg$currPos += 2;
              } else {
                s5 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c404); }
              }
              if (s5 !== peg$FAILED) {
                s6 = [];
                s7 = peg$parseWS();
                while (s7 !== peg$FAILED) {
                  s6.push(s7);
                  s7 = peg$parseWS();
                }
                if (s6 !== peg$FAILED) {
                  s7 = peg$parseNumericExpression();
                  if (s7 !== peg$FAILED) {
                    s4 = [s4, s5, s6, s7];
                    s3 = s4;
                  } else {
                    peg$currPos = s3;
                    s3 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s3;
                  s3 = peg$FAILED;
                }
              } else {
                peg$currPos = s3;
                s3 = peg$FAILED;
              }
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
            if (s3 === peg$FAILED) {
              s3 = peg$currPos;
              s4 = [];
              s5 = peg$parseWS();
              while (s5 !== peg$FAILED) {
                s4.push(s5);
                s5 = peg$parseWS();
              }
              if (s4 !== peg$FAILED) {
                if (input.charCodeAt(peg$currPos) === 60) {
                  s5 = peg$c405;
                  peg$currPos++;
                } else {
                  s5 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c406); }
                }
                if (s5 !== peg$FAILED) {
                  s6 = [];
                  s7 = peg$parseWS();
                  while (s7 !== peg$FAILED) {
                    s6.push(s7);
                    s7 = peg$parseWS();
                  }
                  if (s6 !== peg$FAILED) {
                    s7 = peg$parseNumericExpression();
                    if (s7 !== peg$FAILED) {
                      s4 = [s4, s5, s6, s7];
                      s3 = s4;
                    } else {
                      peg$currPos = s3;
                      s3 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s3;
                    s3 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s3;
                  s3 = peg$FAILED;
                }
              } else {
                peg$currPos = s3;
                s3 = peg$FAILED;
              }
              if (s3 === peg$FAILED) {
                s3 = peg$currPos;
                s4 = [];
                s5 = peg$parseWS();
                while (s5 !== peg$FAILED) {
                  s4.push(s5);
                  s5 = peg$parseWS();
                }
                if (s4 !== peg$FAILED) {
                  if (input.charCodeAt(peg$currPos) === 62) {
                    s5 = peg$c407;
                    peg$currPos++;
                  } else {
                    s5 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$c408); }
                  }
                  if (s5 !== peg$FAILED) {
                    s6 = [];
                    s7 = peg$parseWS();
                    while (s7 !== peg$FAILED) {
                      s6.push(s7);
                      s7 = peg$parseWS();
                    }
                    if (s6 !== peg$FAILED) {
                      s7 = peg$parseNumericExpression();
                      if (s7 !== peg$FAILED) {
                        s4 = [s4, s5, s6, s7];
                        s3 = s4;
                      } else {
                        peg$currPos = s3;
                        s3 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s3;
                      s3 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s3;
                    s3 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s3;
                  s3 = peg$FAILED;
                }
                if (s3 === peg$FAILED) {
                  s3 = peg$currPos;
                  s4 = [];
                  s5 = peg$parseWS();
                  while (s5 !== peg$FAILED) {
                    s4.push(s5);
                    s5 = peg$parseWS();
                  }
                  if (s4 !== peg$FAILED) {
                    if (input.substr(peg$currPos, 2) === peg$c409) {
                      s5 = peg$c409;
                      peg$currPos += 2;
                    } else {
                      s5 = peg$FAILED;
                      if (peg$silentFails === 0) { peg$fail(peg$c410); }
                    }
                    if (s5 !== peg$FAILED) {
                      s6 = [];
                      s7 = peg$parseWS();
                      while (s7 !== peg$FAILED) {
                        s6.push(s7);
                        s7 = peg$parseWS();
                      }
                      if (s6 !== peg$FAILED) {
                        s7 = peg$parseNumericExpression();
                        if (s7 !== peg$FAILED) {
                          s4 = [s4, s5, s6, s7];
                          s3 = s4;
                        } else {
                          peg$currPos = s3;
                          s3 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s3;
                        s3 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s3;
                      s3 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s3;
                    s3 = peg$FAILED;
                  }
                  if (s3 === peg$FAILED) {
                    s3 = peg$currPos;
                    s4 = [];
                    s5 = peg$parseWS();
                    while (s5 !== peg$FAILED) {
                      s4.push(s5);
                      s5 = peg$parseWS();
                    }
                    if (s4 !== peg$FAILED) {
                      if (input.substr(peg$currPos, 2) === peg$c411) {
                        s5 = peg$c411;
                        peg$currPos += 2;
                      } else {
                        s5 = peg$FAILED;
                        if (peg$silentFails === 0) { peg$fail(peg$c412); }
                      }
                      if (s5 !== peg$FAILED) {
                        s6 = [];
                        s7 = peg$parseWS();
                        while (s7 !== peg$FAILED) {
                          s6.push(s7);
                          s7 = peg$parseWS();
                        }
                        if (s6 !== peg$FAILED) {
                          s7 = peg$parseNumericExpression();
                          if (s7 !== peg$FAILED) {
                            s4 = [s4, s5, s6, s7];
                            s3 = s4;
                          } else {
                            peg$currPos = s3;
                            s3 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s3;
                          s3 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s3;
                        s3 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s3;
                      s3 = peg$FAILED;
                    }
                    if (s3 === peg$FAILED) {
                      s3 = peg$currPos;
                      s4 = [];
                      s5 = peg$parseWS();
                      while (s5 !== peg$FAILED) {
                        s4.push(s5);
                        s5 = peg$parseWS();
                      }
                      if (s4 !== peg$FAILED) {
                        if (input.charCodeAt(peg$currPos) === 73) {
                          s5 = peg$c413;
                          peg$currPos++;
                        } else {
                          s5 = peg$FAILED;
                          if (peg$silentFails === 0) { peg$fail(peg$c414); }
                        }
                        if (s5 === peg$FAILED) {
                          if (input.charCodeAt(peg$currPos) === 105) {
                            s5 = peg$c415;
                            peg$currPos++;
                          } else {
                            s5 = peg$FAILED;
                            if (peg$silentFails === 0) { peg$fail(peg$c416); }
                          }
                        }
                        if (s5 !== peg$FAILED) {
                          if (input.charCodeAt(peg$currPos) === 78) {
                            s6 = peg$c417;
                            peg$currPos++;
                          } else {
                            s6 = peg$FAILED;
                            if (peg$silentFails === 0) { peg$fail(peg$c418); }
                          }
                          if (s6 === peg$FAILED) {
                            if (input.charCodeAt(peg$currPos) === 110) {
                              s6 = peg$c419;
                              peg$currPos++;
                            } else {
                              s6 = peg$FAILED;
                              if (peg$silentFails === 0) { peg$fail(peg$c420); }
                            }
                          }
                          if (s6 !== peg$FAILED) {
                            s7 = [];
                            s8 = peg$parseWS();
                            while (s8 !== peg$FAILED) {
                              s7.push(s8);
                              s8 = peg$parseWS();
                            }
                            if (s7 !== peg$FAILED) {
                              s8 = peg$parseExpressionList();
                              if (s8 !== peg$FAILED) {
                                s4 = [s4, s5, s6, s7, s8];
                                s3 = s4;
                              } else {
                                peg$currPos = s3;
                                s3 = peg$FAILED;
                              }
                            } else {
                              peg$currPos = s3;
                              s3 = peg$FAILED;
                            }
                          } else {
                            peg$currPos = s3;
                            s3 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s3;
                          s3 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s3;
                        s3 = peg$FAILED;
                      }
                      if (s3 === peg$FAILED) {
                        s3 = peg$currPos;
                        s4 = [];
                        s5 = peg$parseWS();
                        while (s5 !== peg$FAILED) {
                          s4.push(s5);
                          s5 = peg$parseWS();
                        }
                        if (s4 !== peg$FAILED) {
                          if (input.charCodeAt(peg$currPos) === 78) {
                            s5 = peg$c417;
                            peg$currPos++;
                          } else {
                            s5 = peg$FAILED;
                            if (peg$silentFails === 0) { peg$fail(peg$c418); }
                          }
                          if (s5 === peg$FAILED) {
                            if (input.charCodeAt(peg$currPos) === 110) {
                              s5 = peg$c419;
                              peg$currPos++;
                            } else {
                              s5 = peg$FAILED;
                              if (peg$silentFails === 0) { peg$fail(peg$c420); }
                            }
                          }
                          if (s5 !== peg$FAILED) {
                            if (input.charCodeAt(peg$currPos) === 79) {
                              s6 = peg$c421;
                              peg$currPos++;
                            } else {
                              s6 = peg$FAILED;
                              if (peg$silentFails === 0) { peg$fail(peg$c422); }
                            }
                            if (s6 === peg$FAILED) {
                              if (input.charCodeAt(peg$currPos) === 111) {
                                s6 = peg$c423;
                                peg$currPos++;
                              } else {
                                s6 = peg$FAILED;
                                if (peg$silentFails === 0) { peg$fail(peg$c424); }
                              }
                            }
                            if (s6 !== peg$FAILED) {
                              if (input.charCodeAt(peg$currPos) === 84) {
                                s7 = peg$c425;
                                peg$currPos++;
                              } else {
                                s7 = peg$FAILED;
                                if (peg$silentFails === 0) { peg$fail(peg$c426); }
                              }
                              if (s7 === peg$FAILED) {
                                if (input.charCodeAt(peg$currPos) === 116) {
                                  s7 = peg$c427;
                                  peg$currPos++;
                                } else {
                                  s7 = peg$FAILED;
                                  if (peg$silentFails === 0) { peg$fail(peg$c428); }
                                }
                              }
                              if (s7 !== peg$FAILED) {
                                s8 = [];
                                s9 = peg$parseWS();
                                while (s9 !== peg$FAILED) {
                                  s8.push(s9);
                                  s9 = peg$parseWS();
                                }
                                if (s8 !== peg$FAILED) {
                                  if (input.charCodeAt(peg$currPos) === 73) {
                                    s9 = peg$c413;
                                    peg$currPos++;
                                  } else {
                                    s9 = peg$FAILED;
                                    if (peg$silentFails === 0) { peg$fail(peg$c414); }
                                  }
                                  if (s9 === peg$FAILED) {
                                    if (input.charCodeAt(peg$currPos) === 105) {
                                      s9 = peg$c415;
                                      peg$currPos++;
                                    } else {
                                      s9 = peg$FAILED;
                                      if (peg$silentFails === 0) { peg$fail(peg$c416); }
                                    }
                                  }
                                  if (s9 !== peg$FAILED) {
                                    if (input.charCodeAt(peg$currPos) === 78) {
                                      s10 = peg$c417;
                                      peg$currPos++;
                                    } else {
                                      s10 = peg$FAILED;
                                      if (peg$silentFails === 0) { peg$fail(peg$c418); }
                                    }
                                    if (s10 === peg$FAILED) {
                                      if (input.charCodeAt(peg$currPos) === 110) {
                                        s10 = peg$c419;
                                        peg$currPos++;
                                      } else {
                                        s10 = peg$FAILED;
                                        if (peg$silentFails === 0) { peg$fail(peg$c420); }
                                      }
                                    }
                                    if (s10 !== peg$FAILED) {
                                      s11 = [];
                                      s12 = peg$parseWS();
                                      while (s12 !== peg$FAILED) {
                                        s11.push(s12);
                                        s12 = peg$parseWS();
                                      }
                                      if (s11 !== peg$FAILED) {
                                        s12 = peg$parseExpressionList();
                                        if (s12 !== peg$FAILED) {
                                          s4 = [s4, s5, s6, s7, s8, s9, s10, s11, s12];
                                          s3 = s4;
                                        } else {
                                          peg$currPos = s3;
                                          s3 = peg$FAILED;
                                        }
                                      } else {
                                        peg$currPos = s3;
                                        s3 = peg$FAILED;
                                      }
                                    } else {
                                      peg$currPos = s3;
                                      s3 = peg$FAILED;
                                    }
                                  } else {
                                    peg$currPos = s3;
                                    s3 = peg$FAILED;
                                  }
                                } else {
                                  peg$currPos = s3;
                                  s3 = peg$FAILED;
                                }
                              } else {
                                peg$currPos = s3;
                                s3 = peg$FAILED;
                              }
                            } else {
                              peg$currPos = s3;
                              s3 = peg$FAILED;
                            }
                          } else {
                            peg$currPos = s3;
                            s3 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s3;
                          s3 = peg$FAILED;
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
        if (s2 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c429(s1, s2);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c400); }
      }

      return s0;
    }

    function peg$parseNumericExpression() {
      var s0, s1;

      peg$silentFails++;
      s0 = peg$parseAdditiveExpression();
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c430); }
      }

      return s0;
    }

    function peg$parseAdditiveExpression() {
      var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9;

      peg$silentFails++;
      s0 = peg$currPos;
      s1 = peg$parseMultiplicativeExpression();
      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$currPos;
        s4 = [];
        s5 = peg$parseWS();
        while (s5 !== peg$FAILED) {
          s4.push(s5);
          s5 = peg$parseWS();
        }
        if (s4 !== peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 43) {
            s5 = peg$c360;
            peg$currPos++;
          } else {
            s5 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c361); }
          }
          if (s5 !== peg$FAILED) {
            s6 = [];
            s7 = peg$parseWS();
            while (s7 !== peg$FAILED) {
              s6.push(s7);
              s7 = peg$parseWS();
            }
            if (s6 !== peg$FAILED) {
              s7 = peg$parseMultiplicativeExpression();
              if (s7 !== peg$FAILED) {
                s4 = [s4, s5, s6, s7];
                s3 = s4;
              } else {
                peg$currPos = s3;
                s3 = peg$FAILED;
              }
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
        if (s3 === peg$FAILED) {
          s3 = peg$currPos;
          s4 = [];
          s5 = peg$parseWS();
          while (s5 !== peg$FAILED) {
            s4.push(s5);
            s5 = peg$parseWS();
          }
          if (s4 !== peg$FAILED) {
            if (input.charCodeAt(peg$currPos) === 45) {
              s5 = peg$c432;
              peg$currPos++;
            } else {
              s5 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c433); }
            }
            if (s5 !== peg$FAILED) {
              s6 = [];
              s7 = peg$parseWS();
              while (s7 !== peg$FAILED) {
                s6.push(s7);
                s7 = peg$parseWS();
              }
              if (s6 !== peg$FAILED) {
                s7 = peg$parseMultiplicativeExpression();
                if (s7 !== peg$FAILED) {
                  s4 = [s4, s5, s6, s7];
                  s3 = s4;
                } else {
                  peg$currPos = s3;
                  s3 = peg$FAILED;
                }
              } else {
                peg$currPos = s3;
                s3 = peg$FAILED;
              }
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
          if (s3 === peg$FAILED) {
            s3 = peg$currPos;
            s4 = peg$parseNumericLiteralNegative();
            if (s4 === peg$FAILED) {
              s4 = peg$parseNumericLiteralNegative();
            }
            if (s4 !== peg$FAILED) {
              s5 = peg$currPos;
              s6 = [];
              s7 = peg$parseWS();
              while (s7 !== peg$FAILED) {
                s6.push(s7);
                s7 = peg$parseWS();
              }
              if (s6 !== peg$FAILED) {
                if (input.charCodeAt(peg$currPos) === 42) {
                  s7 = peg$c42;
                  peg$currPos++;
                } else {
                  s7 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c43); }
                }
                if (s7 !== peg$FAILED) {
                  s8 = [];
                  s9 = peg$parseWS();
                  while (s9 !== peg$FAILED) {
                    s8.push(s9);
                    s9 = peg$parseWS();
                  }
                  if (s8 !== peg$FAILED) {
                    s9 = peg$parseUnaryExpression();
                    if (s9 !== peg$FAILED) {
                      s6 = [s6, s7, s8, s9];
                      s5 = s6;
                    } else {
                      peg$currPos = s5;
                      s5 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s5;
                    s5 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s5;
                  s5 = peg$FAILED;
                }
              } else {
                peg$currPos = s5;
                s5 = peg$FAILED;
              }
              if (s5 === peg$FAILED) {
                s5 = peg$currPos;
                s6 = [];
                s7 = peg$parseWS();
                while (s7 !== peg$FAILED) {
                  s6.push(s7);
                  s7 = peg$parseWS();
                }
                if (s6 !== peg$FAILED) {
                  if (input.charCodeAt(peg$currPos) === 47) {
                    s7 = peg$c348;
                    peg$currPos++;
                  } else {
                    s7 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$c349); }
                  }
                  if (s7 !== peg$FAILED) {
                    s8 = [];
                    s9 = peg$parseWS();
                    while (s9 !== peg$FAILED) {
                      s8.push(s9);
                      s9 = peg$parseWS();
                    }
                    if (s8 !== peg$FAILED) {
                      s9 = peg$parseUnaryExpression();
                      if (s9 !== peg$FAILED) {
                        s6 = [s6, s7, s8, s9];
                        s5 = s6;
                      } else {
                        peg$currPos = s5;
                        s5 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s5;
                      s5 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s5;
                    s5 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s5;
                  s5 = peg$FAILED;
                }
              }
              if (s5 === peg$FAILED) {
                s5 = null;
              }
              if (s5 !== peg$FAILED) {
                s4 = [s4, s5];
                s3 = s4;
              } else {
                peg$currPos = s3;
                s3 = peg$FAILED;
              }
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          }
        }
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$currPos;
          s4 = [];
          s5 = peg$parseWS();
          while (s5 !== peg$FAILED) {
            s4.push(s5);
            s5 = peg$parseWS();
          }
          if (s4 !== peg$FAILED) {
            if (input.charCodeAt(peg$currPos) === 43) {
              s5 = peg$c360;
              peg$currPos++;
            } else {
              s5 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c361); }
            }
            if (s5 !== peg$FAILED) {
              s6 = [];
              s7 = peg$parseWS();
              while (s7 !== peg$FAILED) {
                s6.push(s7);
                s7 = peg$parseWS();
              }
              if (s6 !== peg$FAILED) {
                s7 = peg$parseMultiplicativeExpression();
                if (s7 !== peg$FAILED) {
                  s4 = [s4, s5, s6, s7];
                  s3 = s4;
                } else {
                  peg$currPos = s3;
                  s3 = peg$FAILED;
                }
              } else {
                peg$currPos = s3;
                s3 = peg$FAILED;
              }
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
          if (s3 === peg$FAILED) {
            s3 = peg$currPos;
            s4 = [];
            s5 = peg$parseWS();
            while (s5 !== peg$FAILED) {
              s4.push(s5);
              s5 = peg$parseWS();
            }
            if (s4 !== peg$FAILED) {
              if (input.charCodeAt(peg$currPos) === 45) {
                s5 = peg$c432;
                peg$currPos++;
              } else {
                s5 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c433); }
              }
              if (s5 !== peg$FAILED) {
                s6 = [];
                s7 = peg$parseWS();
                while (s7 !== peg$FAILED) {
                  s6.push(s7);
                  s7 = peg$parseWS();
                }
                if (s6 !== peg$FAILED) {
                  s7 = peg$parseMultiplicativeExpression();
                  if (s7 !== peg$FAILED) {
                    s4 = [s4, s5, s6, s7];
                    s3 = s4;
                  } else {
                    peg$currPos = s3;
                    s3 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s3;
                  s3 = peg$FAILED;
                }
              } else {
                peg$currPos = s3;
                s3 = peg$FAILED;
              }
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
            if (s3 === peg$FAILED) {
              s3 = peg$currPos;
              s4 = peg$parseNumericLiteralNegative();
              if (s4 === peg$FAILED) {
                s4 = peg$parseNumericLiteralNegative();
              }
              if (s4 !== peg$FAILED) {
                s5 = peg$currPos;
                s6 = [];
                s7 = peg$parseWS();
                while (s7 !== peg$FAILED) {
                  s6.push(s7);
                  s7 = peg$parseWS();
                }
                if (s6 !== peg$FAILED) {
                  if (input.charCodeAt(peg$currPos) === 42) {
                    s7 = peg$c42;
                    peg$currPos++;
                  } else {
                    s7 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$c43); }
                  }
                  if (s7 !== peg$FAILED) {
                    s8 = [];
                    s9 = peg$parseWS();
                    while (s9 !== peg$FAILED) {
                      s8.push(s9);
                      s9 = peg$parseWS();
                    }
                    if (s8 !== peg$FAILED) {
                      s9 = peg$parseUnaryExpression();
                      if (s9 !== peg$FAILED) {
                        s6 = [s6, s7, s8, s9];
                        s5 = s6;
                      } else {
                        peg$currPos = s5;
                        s5 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s5;
                      s5 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s5;
                    s5 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s5;
                  s5 = peg$FAILED;
                }
                if (s5 === peg$FAILED) {
                  s5 = peg$currPos;
                  s6 = [];
                  s7 = peg$parseWS();
                  while (s7 !== peg$FAILED) {
                    s6.push(s7);
                    s7 = peg$parseWS();
                  }
                  if (s6 !== peg$FAILED) {
                    if (input.charCodeAt(peg$currPos) === 47) {
                      s7 = peg$c348;
                      peg$currPos++;
                    } else {
                      s7 = peg$FAILED;
                      if (peg$silentFails === 0) { peg$fail(peg$c349); }
                    }
                    if (s7 !== peg$FAILED) {
                      s8 = [];
                      s9 = peg$parseWS();
                      while (s9 !== peg$FAILED) {
                        s8.push(s9);
                        s9 = peg$parseWS();
                      }
                      if (s8 !== peg$FAILED) {
                        s9 = peg$parseUnaryExpression();
                        if (s9 !== peg$FAILED) {
                          s6 = [s6, s7, s8, s9];
                          s5 = s6;
                        } else {
                          peg$currPos = s5;
                          s5 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s5;
                        s5 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s5;
                      s5 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s5;
                    s5 = peg$FAILED;
                  }
                }
                if (s5 === peg$FAILED) {
                  s5 = null;
                }
                if (s5 !== peg$FAILED) {
                  s4 = [s4, s5];
                  s3 = s4;
                } else {
                  peg$currPos = s3;
                  s3 = peg$FAILED;
                }
              } else {
                peg$currPos = s3;
                s3 = peg$FAILED;
              }
            }
          }
        }
        if (s2 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c434(s1, s2);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c431); }
      }

      return s0;
    }

    function peg$parseMultiplicativeExpression() {
      var s0, s1, s2, s3, s4, s5, s6, s7;

      peg$silentFails++;
      s0 = peg$currPos;
      s1 = peg$parseUnaryExpression();
      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$currPos;
        s4 = [];
        s5 = peg$parseWS();
        while (s5 !== peg$FAILED) {
          s4.push(s5);
          s5 = peg$parseWS();
        }
        if (s4 !== peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 42) {
            s5 = peg$c42;
            peg$currPos++;
          } else {
            s5 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c43); }
          }
          if (s5 !== peg$FAILED) {
            s6 = [];
            s7 = peg$parseWS();
            while (s7 !== peg$FAILED) {
              s6.push(s7);
              s7 = peg$parseWS();
            }
            if (s6 !== peg$FAILED) {
              s7 = peg$parseUnaryExpression();
              if (s7 !== peg$FAILED) {
                s4 = [s4, s5, s6, s7];
                s3 = s4;
              } else {
                peg$currPos = s3;
                s3 = peg$FAILED;
              }
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        } else {
          peg$currPos = s3;
          s3 = peg$FAILED;
        }
        if (s3 === peg$FAILED) {
          s3 = peg$currPos;
          s4 = [];
          s5 = peg$parseWS();
          while (s5 !== peg$FAILED) {
            s4.push(s5);
            s5 = peg$parseWS();
          }
          if (s4 !== peg$FAILED) {
            if (input.charCodeAt(peg$currPos) === 47) {
              s5 = peg$c348;
              peg$currPos++;
            } else {
              s5 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c349); }
            }
            if (s5 !== peg$FAILED) {
              s6 = [];
              s7 = peg$parseWS();
              while (s7 !== peg$FAILED) {
                s6.push(s7);
                s7 = peg$parseWS();
              }
              if (s6 !== peg$FAILED) {
                s7 = peg$parseUnaryExpression();
                if (s7 !== peg$FAILED) {
                  s4 = [s4, s5, s6, s7];
                  s3 = s4;
                } else {
                  peg$currPos = s3;
                  s3 = peg$FAILED;
                }
              } else {
                peg$currPos = s3;
                s3 = peg$FAILED;
              }
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
        }
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$currPos;
          s4 = [];
          s5 = peg$parseWS();
          while (s5 !== peg$FAILED) {
            s4.push(s5);
            s5 = peg$parseWS();
          }
          if (s4 !== peg$FAILED) {
            if (input.charCodeAt(peg$currPos) === 42) {
              s5 = peg$c42;
              peg$currPos++;
            } else {
              s5 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c43); }
            }
            if (s5 !== peg$FAILED) {
              s6 = [];
              s7 = peg$parseWS();
              while (s7 !== peg$FAILED) {
                s6.push(s7);
                s7 = peg$parseWS();
              }
              if (s6 !== peg$FAILED) {
                s7 = peg$parseUnaryExpression();
                if (s7 !== peg$FAILED) {
                  s4 = [s4, s5, s6, s7];
                  s3 = s4;
                } else {
                  peg$currPos = s3;
                  s3 = peg$FAILED;
                }
              } else {
                peg$currPos = s3;
                s3 = peg$FAILED;
              }
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          } else {
            peg$currPos = s3;
            s3 = peg$FAILED;
          }
          if (s3 === peg$FAILED) {
            s3 = peg$currPos;
            s4 = [];
            s5 = peg$parseWS();
            while (s5 !== peg$FAILED) {
              s4.push(s5);
              s5 = peg$parseWS();
            }
            if (s4 !== peg$FAILED) {
              if (input.charCodeAt(peg$currPos) === 47) {
                s5 = peg$c348;
                peg$currPos++;
              } else {
                s5 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c349); }
              }
              if (s5 !== peg$FAILED) {
                s6 = [];
                s7 = peg$parseWS();
                while (s7 !== peg$FAILED) {
                  s6.push(s7);
                  s7 = peg$parseWS();
                }
                if (s6 !== peg$FAILED) {
                  s7 = peg$parseUnaryExpression();
                  if (s7 !== peg$FAILED) {
                    s4 = [s4, s5, s6, s7];
                    s3 = s4;
                  } else {
                    peg$currPos = s3;
                    s3 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s3;
                  s3 = peg$FAILED;
                }
              } else {
                peg$currPos = s3;
                s3 = peg$FAILED;
              }
            } else {
              peg$currPos = s3;
              s3 = peg$FAILED;
            }
          }
        }
        if (s2 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c436(s1, s2);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c435); }
      }

      return s0;
    }

    function peg$parseUnaryExpression() {
      var s0, s1, s2, s3;

      peg$silentFails++;
      s0 = peg$currPos;
      if (input.charCodeAt(peg$currPos) === 33) {
        s1 = peg$c363;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c364); }
      }
      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$parseWS();
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parseWS();
        }
        if (s2 !== peg$FAILED) {
          s3 = peg$parsePrimaryExpression();
          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c438(s3);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        if (input.charCodeAt(peg$currPos) === 43) {
          s1 = peg$c360;
          peg$currPos++;
        } else {
          s1 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c361); }
        }
        if (s1 !== peg$FAILED) {
          s2 = [];
          s3 = peg$parseWS();
          while (s3 !== peg$FAILED) {
            s2.push(s3);
            s3 = peg$parseWS();
          }
          if (s2 !== peg$FAILED) {
            s3 = peg$parsePrimaryExpression();
            if (s3 !== peg$FAILED) {
              peg$savedPos = s0;
              s1 = peg$c439(s3);
              s0 = s1;
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
        if (s0 === peg$FAILED) {
          s0 = peg$currPos;
          if (input.charCodeAt(peg$currPos) === 45) {
            s1 = peg$c432;
            peg$currPos++;
          } else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c433); }
          }
          if (s1 !== peg$FAILED) {
            s2 = [];
            s3 = peg$parseWS();
            while (s3 !== peg$FAILED) {
              s2.push(s3);
              s3 = peg$parseWS();
            }
            if (s2 !== peg$FAILED) {
              s3 = peg$parsePrimaryExpression();
              if (s3 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c440(s3);
                s0 = s1;
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
          if (s0 === peg$FAILED) {
            s0 = peg$parsePrimaryExpression();
          }
        }
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c437); }
      }

      return s0;
    }

    function peg$parsePrimaryExpression() {
      var s0, s1;

      peg$silentFails++;
      s0 = peg$parseBrackettedExpression();
      if (s0 === peg$FAILED) {
        s0 = peg$parseBuiltInCall();
        if (s0 === peg$FAILED) {
          s0 = peg$parseIRIrefOrFunction();
          if (s0 === peg$FAILED) {
            s0 = peg$currPos;
            s1 = peg$parseRDFLiteral();
            if (s1 !== peg$FAILED) {
              peg$savedPos = s0;
              s1 = peg$c442(s1);
            }
            s0 = s1;
            if (s0 === peg$FAILED) {
              s0 = peg$currPos;
              s1 = peg$parseNumericLiteral();
              if (s1 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c443(s1);
              }
              s0 = s1;
              if (s0 === peg$FAILED) {
                s0 = peg$currPos;
                s1 = peg$parseBooleanLiteral();
                if (s1 !== peg$FAILED) {
                  peg$savedPos = s0;
                  s1 = peg$c444(s1);
                }
                s0 = s1;
                if (s0 === peg$FAILED) {
                  s0 = peg$parseAggregate();
                  if (s0 === peg$FAILED) {
                    s0 = peg$currPos;
                    s1 = peg$parseVar();
                    if (s1 !== peg$FAILED) {
                      peg$savedPos = s0;
                      s1 = peg$c445(s1);
                    }
                    s0 = s1;
                  }
                }
              }
            }
          }
        }
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c441); }
      }

      return s0;
    }

    function peg$parseBrackettedExpression() {
      var s0, s1, s2, s3, s4, s5;

      peg$silentFails++;
      s0 = peg$currPos;
      if (input.charCodeAt(peg$currPos) === 40) {
        s1 = peg$c34;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c35); }
      }
      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$parseWS();
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parseWS();
        }
        if (s2 !== peg$FAILED) {
          s3 = peg$parseExpression();
          if (s3 !== peg$FAILED) {
            s4 = [];
            s5 = peg$parseWS();
            while (s5 !== peg$FAILED) {
              s4.push(s5);
              s5 = peg$parseWS();
            }
            if (s4 !== peg$FAILED) {
              if (input.charCodeAt(peg$currPos) === 41) {
                s5 = peg$c40;
                peg$currPos++;
              } else {
                s5 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c41); }
              }
              if (s5 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c447(s3);
                s0 = s1;
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c446); }
      }

      return s0;
    }

    function peg$parseBuiltInCall() {
      var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15;

      peg$silentFails++;
      s0 = peg$currPos;
      if (input.substr(peg$currPos, 3) === peg$c449) {
        s1 = peg$c449;
        peg$currPos += 3;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c450); }
      }
      if (s1 === peg$FAILED) {
        if (input.substr(peg$currPos, 3) === peg$c451) {
          s1 = peg$c451;
          peg$currPos += 3;
        } else {
          s1 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c452); }
        }
      }
      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$parseWS();
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parseWS();
        }
        if (s2 !== peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 40) {
            s3 = peg$c34;
            peg$currPos++;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c35); }
          }
          if (s3 !== peg$FAILED) {
            s4 = [];
            s5 = peg$parseWS();
            while (s5 !== peg$FAILED) {
              s4.push(s5);
              s5 = peg$parseWS();
            }
            if (s4 !== peg$FAILED) {
              s5 = peg$parseExpression();
              if (s5 !== peg$FAILED) {
                s6 = [];
                s7 = peg$parseWS();
                while (s7 !== peg$FAILED) {
                  s6.push(s7);
                  s7 = peg$parseWS();
                }
                if (s6 !== peg$FAILED) {
                  if (input.charCodeAt(peg$currPos) === 41) {
                    s7 = peg$c40;
                    peg$currPos++;
                  } else {
                    s7 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$c41); }
                  }
                  if (s7 !== peg$FAILED) {
                    peg$savedPos = s0;
                    s1 = peg$c453(s5);
                    s0 = s1;
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        if (input.substr(peg$currPos, 4) === peg$c454) {
          s1 = peg$c454;
          peg$currPos += 4;
        } else {
          s1 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c455); }
        }
        if (s1 === peg$FAILED) {
          if (input.substr(peg$currPos, 4) === peg$c456) {
            s1 = peg$c456;
            peg$currPos += 4;
          } else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c457); }
          }
        }
        if (s1 !== peg$FAILED) {
          s2 = [];
          s3 = peg$parseWS();
          while (s3 !== peg$FAILED) {
            s2.push(s3);
            s3 = peg$parseWS();
          }
          if (s2 !== peg$FAILED) {
            if (input.charCodeAt(peg$currPos) === 40) {
              s3 = peg$c34;
              peg$currPos++;
            } else {
              s3 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c35); }
            }
            if (s3 !== peg$FAILED) {
              s4 = [];
              s5 = peg$parseWS();
              while (s5 !== peg$FAILED) {
                s4.push(s5);
                s5 = peg$parseWS();
              }
              if (s4 !== peg$FAILED) {
                s5 = peg$parseExpression();
                if (s5 !== peg$FAILED) {
                  s6 = [];
                  s7 = peg$parseWS();
                  while (s7 !== peg$FAILED) {
                    s6.push(s7);
                    s7 = peg$parseWS();
                  }
                  if (s6 !== peg$FAILED) {
                    if (input.charCodeAt(peg$currPos) === 41) {
                      s7 = peg$c40;
                      peg$currPos++;
                    } else {
                      s7 = peg$FAILED;
                      if (peg$silentFails === 0) { peg$fail(peg$c41); }
                    }
                    if (s7 !== peg$FAILED) {
                      peg$savedPos = s0;
                      s1 = peg$c458(s5);
                      s0 = s1;
                    } else {
                      peg$currPos = s0;
                      s0 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
        if (s0 === peg$FAILED) {
          s0 = peg$currPos;
          if (input.substr(peg$currPos, 11) === peg$c459) {
            s1 = peg$c459;
            peg$currPos += 11;
          } else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c460); }
          }
          if (s1 === peg$FAILED) {
            if (input.substr(peg$currPos, 11) === peg$c461) {
              s1 = peg$c461;
              peg$currPos += 11;
            } else {
              s1 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c462); }
            }
          }
          if (s1 !== peg$FAILED) {
            s2 = [];
            s3 = peg$parseWS();
            while (s3 !== peg$FAILED) {
              s2.push(s3);
              s3 = peg$parseWS();
            }
            if (s2 !== peg$FAILED) {
              if (input.charCodeAt(peg$currPos) === 40) {
                s3 = peg$c34;
                peg$currPos++;
              } else {
                s3 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c35); }
              }
              if (s3 !== peg$FAILED) {
                s4 = [];
                s5 = peg$parseWS();
                while (s5 !== peg$FAILED) {
                  s4.push(s5);
                  s5 = peg$parseWS();
                }
                if (s4 !== peg$FAILED) {
                  s5 = peg$parseExpression();
                  if (s5 !== peg$FAILED) {
                    s6 = [];
                    s7 = peg$parseWS();
                    while (s7 !== peg$FAILED) {
                      s6.push(s7);
                      s7 = peg$parseWS();
                    }
                    if (s6 !== peg$FAILED) {
                      if (input.charCodeAt(peg$currPos) === 44) {
                        s7 = peg$c306;
                        peg$currPos++;
                      } else {
                        s7 = peg$FAILED;
                        if (peg$silentFails === 0) { peg$fail(peg$c307); }
                      }
                      if (s7 !== peg$FAILED) {
                        s8 = [];
                        s9 = peg$parseWS();
                        while (s9 !== peg$FAILED) {
                          s8.push(s9);
                          s9 = peg$parseWS();
                        }
                        if (s8 !== peg$FAILED) {
                          s9 = peg$parseExpression();
                          if (s9 !== peg$FAILED) {
                            s10 = [];
                            s11 = peg$parseWS();
                            while (s11 !== peg$FAILED) {
                              s10.push(s11);
                              s11 = peg$parseWS();
                            }
                            if (s10 !== peg$FAILED) {
                              if (input.charCodeAt(peg$currPos) === 41) {
                                s11 = peg$c40;
                                peg$currPos++;
                              } else {
                                s11 = peg$FAILED;
                                if (peg$silentFails === 0) { peg$fail(peg$c41); }
                              }
                              if (s11 !== peg$FAILED) {
                                peg$savedPos = s0;
                                s1 = peg$c463(s5, s9);
                                s0 = s1;
                              } else {
                                peg$currPos = s0;
                                s0 = peg$FAILED;
                              }
                            } else {
                              peg$currPos = s0;
                              s0 = peg$FAILED;
                            }
                          } else {
                            peg$currPos = s0;
                            s0 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s0;
                          s0 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s0;
                        s0 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s0;
                      s0 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
          if (s0 === peg$FAILED) {
            s0 = peg$currPos;
            if (input.substr(peg$currPos, 8) === peg$c464) {
              s1 = peg$c464;
              peg$currPos += 8;
            } else {
              s1 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c465); }
            }
            if (s1 === peg$FAILED) {
              if (input.substr(peg$currPos, 8) === peg$c466) {
                s1 = peg$c466;
                peg$currPos += 8;
              } else {
                s1 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c467); }
              }
            }
            if (s1 !== peg$FAILED) {
              s2 = [];
              s3 = peg$parseWS();
              while (s3 !== peg$FAILED) {
                s2.push(s3);
                s3 = peg$parseWS();
              }
              if (s2 !== peg$FAILED) {
                if (input.charCodeAt(peg$currPos) === 40) {
                  s3 = peg$c34;
                  peg$currPos++;
                } else {
                  s3 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c35); }
                }
                if (s3 !== peg$FAILED) {
                  s4 = [];
                  s5 = peg$parseWS();
                  while (s5 !== peg$FAILED) {
                    s4.push(s5);
                    s5 = peg$parseWS();
                  }
                  if (s4 !== peg$FAILED) {
                    s5 = peg$parseExpression();
                    if (s5 !== peg$FAILED) {
                      s6 = [];
                      s7 = peg$parseWS();
                      while (s7 !== peg$FAILED) {
                        s6.push(s7);
                        s7 = peg$parseWS();
                      }
                      if (s6 !== peg$FAILED) {
                        if (input.charCodeAt(peg$currPos) === 41) {
                          s7 = peg$c40;
                          peg$currPos++;
                        } else {
                          s7 = peg$FAILED;
                          if (peg$silentFails === 0) { peg$fail(peg$c41); }
                        }
                        if (s7 !== peg$FAILED) {
                          peg$savedPos = s0;
                          s1 = peg$c468(s5);
                          s0 = s1;
                        } else {
                          peg$currPos = s0;
                          s0 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s0;
                        s0 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s0;
                      s0 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
            if (s0 === peg$FAILED) {
              s0 = peg$currPos;
              if (input.substr(peg$currPos, 5) === peg$c469) {
                s1 = peg$c469;
                peg$currPos += 5;
              } else {
                s1 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c470); }
              }
              if (s1 === peg$FAILED) {
                if (input.substr(peg$currPos, 5) === peg$c471) {
                  s1 = peg$c471;
                  peg$currPos += 5;
                } else {
                  s1 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c472); }
                }
              }
              if (s1 !== peg$FAILED) {
                s2 = [];
                s3 = peg$parseWS();
                while (s3 !== peg$FAILED) {
                  s2.push(s3);
                  s3 = peg$parseWS();
                }
                if (s2 !== peg$FAILED) {
                  if (input.charCodeAt(peg$currPos) === 40) {
                    s3 = peg$c34;
                    peg$currPos++;
                  } else {
                    s3 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$c35); }
                  }
                  if (s3 !== peg$FAILED) {
                    s4 = [];
                    s5 = peg$parseWS();
                    while (s5 !== peg$FAILED) {
                      s4.push(s5);
                      s5 = peg$parseWS();
                    }
                    if (s4 !== peg$FAILED) {
                      s5 = peg$parseVar();
                      if (s5 !== peg$FAILED) {
                        s6 = [];
                        s7 = peg$parseWS();
                        while (s7 !== peg$FAILED) {
                          s6.push(s7);
                          s7 = peg$parseWS();
                        }
                        if (s6 !== peg$FAILED) {
                          if (input.charCodeAt(peg$currPos) === 41) {
                            s7 = peg$c40;
                            peg$currPos++;
                          } else {
                            s7 = peg$FAILED;
                            if (peg$silentFails === 0) { peg$fail(peg$c41); }
                          }
                          if (s7 !== peg$FAILED) {
                            peg$savedPos = s0;
                            s1 = peg$c473(s5);
                            s0 = s1;
                          } else {
                            peg$currPos = s0;
                            s0 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s0;
                          s0 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s0;
                        s0 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s0;
                      s0 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
              if (s0 === peg$FAILED) {
                s0 = peg$currPos;
                if (input.substr(peg$currPos, 3) === peg$c474) {
                  s1 = peg$c474;
                  peg$currPos += 3;
                } else {
                  s1 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c475); }
                }
                if (s1 === peg$FAILED) {
                  if (input.substr(peg$currPos, 3) === peg$c476) {
                    s1 = peg$c476;
                    peg$currPos += 3;
                  } else {
                    s1 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$c477); }
                  }
                }
                if (s1 !== peg$FAILED) {
                  s2 = [];
                  s3 = peg$parseWS();
                  while (s3 !== peg$FAILED) {
                    s2.push(s3);
                    s3 = peg$parseWS();
                  }
                  if (s2 !== peg$FAILED) {
                    if (input.charCodeAt(peg$currPos) === 40) {
                      s3 = peg$c34;
                      peg$currPos++;
                    } else {
                      s3 = peg$FAILED;
                      if (peg$silentFails === 0) { peg$fail(peg$c35); }
                    }
                    if (s3 !== peg$FAILED) {
                      s4 = [];
                      s5 = peg$parseWS();
                      while (s5 !== peg$FAILED) {
                        s4.push(s5);
                        s5 = peg$parseWS();
                      }
                      if (s4 !== peg$FAILED) {
                        s5 = peg$parseExpression();
                        if (s5 !== peg$FAILED) {
                          s6 = [];
                          s7 = peg$parseWS();
                          while (s7 !== peg$FAILED) {
                            s6.push(s7);
                            s7 = peg$parseWS();
                          }
                          if (s6 !== peg$FAILED) {
                            if (input.charCodeAt(peg$currPos) === 41) {
                              s7 = peg$c40;
                              peg$currPos++;
                            } else {
                              s7 = peg$FAILED;
                              if (peg$silentFails === 0) { peg$fail(peg$c41); }
                            }
                            if (s7 !== peg$FAILED) {
                              peg$savedPos = s0;
                              s1 = peg$c478(s5);
                              s0 = s1;
                            } else {
                              peg$currPos = s0;
                              s0 = peg$FAILED;
                            }
                          } else {
                            peg$currPos = s0;
                            s0 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s0;
                          s0 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s0;
                        s0 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s0;
                      s0 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
                if (s0 === peg$FAILED) {
                  s0 = peg$currPos;
                  if (input.substr(peg$currPos, 3) === peg$c479) {
                    s1 = peg$c479;
                    peg$currPos += 3;
                  } else {
                    s1 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$c480); }
                  }
                  if (s1 === peg$FAILED) {
                    if (input.substr(peg$currPos, 3) === peg$c481) {
                      s1 = peg$c481;
                      peg$currPos += 3;
                    } else {
                      s1 = peg$FAILED;
                      if (peg$silentFails === 0) { peg$fail(peg$c482); }
                    }
                  }
                  if (s1 !== peg$FAILED) {
                    s2 = [];
                    s3 = peg$parseWS();
                    while (s3 !== peg$FAILED) {
                      s2.push(s3);
                      s3 = peg$parseWS();
                    }
                    if (s2 !== peg$FAILED) {
                      if (input.charCodeAt(peg$currPos) === 40) {
                        s3 = peg$c34;
                        peg$currPos++;
                      } else {
                        s3 = peg$FAILED;
                        if (peg$silentFails === 0) { peg$fail(peg$c35); }
                      }
                      if (s3 !== peg$FAILED) {
                        s4 = [];
                        s5 = peg$parseWS();
                        while (s5 !== peg$FAILED) {
                          s4.push(s5);
                          s5 = peg$parseWS();
                        }
                        if (s4 !== peg$FAILED) {
                          s5 = peg$parseExpression();
                          if (s5 !== peg$FAILED) {
                            s6 = [];
                            s7 = peg$parseWS();
                            while (s7 !== peg$FAILED) {
                              s6.push(s7);
                              s7 = peg$parseWS();
                            }
                            if (s6 !== peg$FAILED) {
                              if (input.charCodeAt(peg$currPos) === 41) {
                                s7 = peg$c40;
                                peg$currPos++;
                              } else {
                                s7 = peg$FAILED;
                                if (peg$silentFails === 0) { peg$fail(peg$c41); }
                              }
                              if (s7 !== peg$FAILED) {
                                peg$savedPos = s0;
                                s1 = peg$c483(s5);
                                s0 = s1;
                              } else {
                                peg$currPos = s0;
                                s0 = peg$FAILED;
                              }
                            } else {
                              peg$currPos = s0;
                              s0 = peg$FAILED;
                            }
                          } else {
                            peg$currPos = s0;
                            s0 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s0;
                          s0 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s0;
                        s0 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s0;
                      s0 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                  if (s0 === peg$FAILED) {
                    s0 = peg$currPos;
                    if (input.substr(peg$currPos, 5) === peg$c484) {
                      s1 = peg$c484;
                      peg$currPos += 5;
                    } else {
                      s1 = peg$FAILED;
                      if (peg$silentFails === 0) { peg$fail(peg$c485); }
                    }
                    if (s1 === peg$FAILED) {
                      if (input.substr(peg$currPos, 5) === peg$c486) {
                        s1 = peg$c486;
                        peg$currPos += 5;
                      } else {
                        s1 = peg$FAILED;
                        if (peg$silentFails === 0) { peg$fail(peg$c487); }
                      }
                    }
                    if (s1 !== peg$FAILED) {
                      s2 = [];
                      s3 = peg$parseWS();
                      while (s3 !== peg$FAILED) {
                        s2.push(s3);
                        s3 = peg$parseWS();
                      }
                      if (s2 !== peg$FAILED) {
                        s3 = peg$currPos;
                        if (input.charCodeAt(peg$currPos) === 40) {
                          s4 = peg$c34;
                          peg$currPos++;
                        } else {
                          s4 = peg$FAILED;
                          if (peg$silentFails === 0) { peg$fail(peg$c35); }
                        }
                        if (s4 !== peg$FAILED) {
                          s5 = [];
                          s6 = peg$parseWS();
                          while (s6 !== peg$FAILED) {
                            s5.push(s6);
                            s6 = peg$parseWS();
                          }
                          if (s5 !== peg$FAILED) {
                            s6 = peg$parseExpression();
                            if (s6 !== peg$FAILED) {
                              s7 = [];
                              s8 = peg$parseWS();
                              while (s8 !== peg$FAILED) {
                                s7.push(s8);
                                s8 = peg$parseWS();
                              }
                              if (s7 !== peg$FAILED) {
                                if (input.charCodeAt(peg$currPos) === 41) {
                                  s8 = peg$c40;
                                  peg$currPos++;
                                } else {
                                  s8 = peg$FAILED;
                                  if (peg$silentFails === 0) { peg$fail(peg$c41); }
                                }
                                if (s8 !== peg$FAILED) {
                                  s4 = [s4, s5, s6, s7, s8];
                                  s3 = s4;
                                } else {
                                  peg$currPos = s3;
                                  s3 = peg$FAILED;
                                }
                              } else {
                                peg$currPos = s3;
                                s3 = peg$FAILED;
                              }
                            } else {
                              peg$currPos = s3;
                              s3 = peg$FAILED;
                            }
                          } else {
                            peg$currPos = s3;
                            s3 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s3;
                          s3 = peg$FAILED;
                        }
                        if (s3 === peg$FAILED) {
                          s3 = peg$parseNIL();
                        }
                        if (s3 !== peg$FAILED) {
                          peg$savedPos = s0;
                          s1 = peg$c488(s3);
                          s0 = s1;
                        } else {
                          peg$currPos = s0;
                          s0 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s0;
                        s0 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s0;
                      s0 = peg$FAILED;
                    }
                    if (s0 === peg$FAILED) {
                      s0 = peg$currPos;
                      if (input.substr(peg$currPos, 8) === peg$c489) {
                        s1 = peg$c489;
                        peg$currPos += 8;
                      } else {
                        s1 = peg$FAILED;
                        if (peg$silentFails === 0) { peg$fail(peg$c490); }
                      }
                      if (s1 === peg$FAILED) {
                        if (input.substr(peg$currPos, 8) === peg$c491) {
                          s1 = peg$c491;
                          peg$currPos += 8;
                        } else {
                          s1 = peg$FAILED;
                          if (peg$silentFails === 0) { peg$fail(peg$c492); }
                        }
                      }
                      if (s1 !== peg$FAILED) {
                        s2 = [];
                        s3 = peg$parseWS();
                        while (s3 !== peg$FAILED) {
                          s2.push(s3);
                          s3 = peg$parseWS();
                        }
                        if (s2 !== peg$FAILED) {
                          s3 = peg$parseExpressionList();
                          if (s3 !== peg$FAILED) {
                            peg$savedPos = s0;
                            s1 = peg$c493(s3);
                            s0 = s1;
                          } else {
                            peg$currPos = s0;
                            s0 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s0;
                          s0 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s0;
                        s0 = peg$FAILED;
                      }
                      if (s0 === peg$FAILED) {
                        s0 = peg$currPos;
                        if (input.substr(peg$currPos, 2) === peg$c494) {
                          s1 = peg$c494;
                          peg$currPos += 2;
                        } else {
                          s1 = peg$FAILED;
                          if (peg$silentFails === 0) { peg$fail(peg$c495); }
                        }
                        if (s1 === peg$FAILED) {
                          if (input.substr(peg$currPos, 2) === peg$c496) {
                            s1 = peg$c496;
                            peg$currPos += 2;
                          } else {
                            s1 = peg$FAILED;
                            if (peg$silentFails === 0) { peg$fail(peg$c497); }
                          }
                        }
                        if (s1 !== peg$FAILED) {
                          s2 = [];
                          s3 = peg$parseWS();
                          while (s3 !== peg$FAILED) {
                            s2.push(s3);
                            s3 = peg$parseWS();
                          }
                          if (s2 !== peg$FAILED) {
                            if (input.charCodeAt(peg$currPos) === 40) {
                              s3 = peg$c34;
                              peg$currPos++;
                            } else {
                              s3 = peg$FAILED;
                              if (peg$silentFails === 0) { peg$fail(peg$c35); }
                            }
                            if (s3 !== peg$FAILED) {
                              s4 = [];
                              s5 = peg$parseWS();
                              while (s5 !== peg$FAILED) {
                                s4.push(s5);
                                s5 = peg$parseWS();
                              }
                              if (s4 !== peg$FAILED) {
                                s5 = peg$parseExpression();
                                if (s5 !== peg$FAILED) {
                                  s6 = [];
                                  s7 = peg$parseWS();
                                  while (s7 !== peg$FAILED) {
                                    s6.push(s7);
                                    s7 = peg$parseWS();
                                  }
                                  if (s6 !== peg$FAILED) {
                                    if (input.charCodeAt(peg$currPos) === 44) {
                                      s7 = peg$c306;
                                      peg$currPos++;
                                    } else {
                                      s7 = peg$FAILED;
                                      if (peg$silentFails === 0) { peg$fail(peg$c307); }
                                    }
                                    if (s7 !== peg$FAILED) {
                                      s8 = [];
                                      s9 = peg$parseWS();
                                      while (s9 !== peg$FAILED) {
                                        s8.push(s9);
                                        s9 = peg$parseWS();
                                      }
                                      if (s8 !== peg$FAILED) {
                                        s9 = peg$parseExpression();
                                        if (s9 !== peg$FAILED) {
                                          s10 = [];
                                          s11 = peg$parseWS();
                                          while (s11 !== peg$FAILED) {
                                            s10.push(s11);
                                            s11 = peg$parseWS();
                                          }
                                          if (s10 !== peg$FAILED) {
                                            if (input.charCodeAt(peg$currPos) === 44) {
                                              s11 = peg$c306;
                                              peg$currPos++;
                                            } else {
                                              s11 = peg$FAILED;
                                              if (peg$silentFails === 0) { peg$fail(peg$c307); }
                                            }
                                            if (s11 !== peg$FAILED) {
                                              s12 = [];
                                              s13 = peg$parseWS();
                                              while (s13 !== peg$FAILED) {
                                                s12.push(s13);
                                                s13 = peg$parseWS();
                                              }
                                              if (s12 !== peg$FAILED) {
                                                s13 = peg$parseExpression();
                                                if (s13 !== peg$FAILED) {
                                                  s14 = [];
                                                  s15 = peg$parseWS();
                                                  while (s15 !== peg$FAILED) {
                                                    s14.push(s15);
                                                    s15 = peg$parseWS();
                                                  }
                                                  if (s14 !== peg$FAILED) {
                                                    if (input.charCodeAt(peg$currPos) === 41) {
                                                      s15 = peg$c40;
                                                      peg$currPos++;
                                                    } else {
                                                      s15 = peg$FAILED;
                                                      if (peg$silentFails === 0) { peg$fail(peg$c41); }
                                                    }
                                                    if (s15 !== peg$FAILED) {
                                                      peg$savedPos = s0;
                                                      s1 = peg$c498(s5, s9, s13);
                                                      s0 = s1;
                                                    } else {
                                                      peg$currPos = s0;
                                                      s0 = peg$FAILED;
                                                    }
                                                  } else {
                                                    peg$currPos = s0;
                                                    s0 = peg$FAILED;
                                                  }
                                                } else {
                                                  peg$currPos = s0;
                                                  s0 = peg$FAILED;
                                                }
                                              } else {
                                                peg$currPos = s0;
                                                s0 = peg$FAILED;
                                              }
                                            } else {
                                              peg$currPos = s0;
                                              s0 = peg$FAILED;
                                            }
                                          } else {
                                            peg$currPos = s0;
                                            s0 = peg$FAILED;
                                          }
                                        } else {
                                          peg$currPos = s0;
                                          s0 = peg$FAILED;
                                        }
                                      } else {
                                        peg$currPos = s0;
                                        s0 = peg$FAILED;
                                      }
                                    } else {
                                      peg$currPos = s0;
                                      s0 = peg$FAILED;
                                    }
                                  } else {
                                    peg$currPos = s0;
                                    s0 = peg$FAILED;
                                  }
                                } else {
                                  peg$currPos = s0;
                                  s0 = peg$FAILED;
                                }
                              } else {
                                peg$currPos = s0;
                                s0 = peg$FAILED;
                              }
                            } else {
                              peg$currPos = s0;
                              s0 = peg$FAILED;
                            }
                          } else {
                            peg$currPos = s0;
                            s0 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s0;
                          s0 = peg$FAILED;
                        }
                        if (s0 === peg$FAILED) {
                          s0 = peg$currPos;
                          if (input.substr(peg$currPos, 9) === peg$c499) {
                            s1 = peg$c499;
                            peg$currPos += 9;
                          } else {
                            s1 = peg$FAILED;
                            if (peg$silentFails === 0) { peg$fail(peg$c500); }
                          }
                          if (s1 === peg$FAILED) {
                            if (input.substr(peg$currPos, 9) === peg$c501) {
                              s1 = peg$c501;
                              peg$currPos += 9;
                            } else {
                              s1 = peg$FAILED;
                              if (peg$silentFails === 0) { peg$fail(peg$c502); }
                            }
                            if (s1 === peg$FAILED) {
                              if (input.substr(peg$currPos, 9) === peg$c503) {
                                s1 = peg$c503;
                                peg$currPos += 9;
                              } else {
                                s1 = peg$FAILED;
                                if (peg$silentFails === 0) { peg$fail(peg$c504); }
                              }
                            }
                          }
                          if (s1 !== peg$FAILED) {
                            s2 = [];
                            s3 = peg$parseWS();
                            while (s3 !== peg$FAILED) {
                              s2.push(s3);
                              s3 = peg$parseWS();
                            }
                            if (s2 !== peg$FAILED) {
                              if (input.charCodeAt(peg$currPos) === 40) {
                                s3 = peg$c34;
                                peg$currPos++;
                              } else {
                                s3 = peg$FAILED;
                                if (peg$silentFails === 0) { peg$fail(peg$c35); }
                              }
                              if (s3 !== peg$FAILED) {
                                s4 = [];
                                s5 = peg$parseWS();
                                while (s5 !== peg$FAILED) {
                                  s4.push(s5);
                                  s5 = peg$parseWS();
                                }
                                if (s4 !== peg$FAILED) {
                                  s5 = peg$parseExpression();
                                  if (s5 !== peg$FAILED) {
                                    s6 = [];
                                    s7 = peg$parseWS();
                                    while (s7 !== peg$FAILED) {
                                      s6.push(s7);
                                      s7 = peg$parseWS();
                                    }
                                    if (s6 !== peg$FAILED) {
                                      if (input.charCodeAt(peg$currPos) === 41) {
                                        s7 = peg$c40;
                                        peg$currPos++;
                                      } else {
                                        s7 = peg$FAILED;
                                        if (peg$silentFails === 0) { peg$fail(peg$c41); }
                                      }
                                      if (s7 !== peg$FAILED) {
                                        peg$savedPos = s0;
                                        s1 = peg$c505(s5);
                                        s0 = s1;
                                      } else {
                                        peg$currPos = s0;
                                        s0 = peg$FAILED;
                                      }
                                    } else {
                                      peg$currPos = s0;
                                      s0 = peg$FAILED;
                                    }
                                  } else {
                                    peg$currPos = s0;
                                    s0 = peg$FAILED;
                                  }
                                } else {
                                  peg$currPos = s0;
                                  s0 = peg$FAILED;
                                }
                              } else {
                                peg$currPos = s0;
                                s0 = peg$FAILED;
                              }
                            } else {
                              peg$currPos = s0;
                              s0 = peg$FAILED;
                            }
                          } else {
                            peg$currPos = s0;
                            s0 = peg$FAILED;
                          }
                          if (s0 === peg$FAILED) {
                            s0 = peg$currPos;
                            if (input.substr(peg$currPos, 7) === peg$c506) {
                              s1 = peg$c506;
                              peg$currPos += 7;
                            } else {
                              s1 = peg$FAILED;
                              if (peg$silentFails === 0) { peg$fail(peg$c507); }
                            }
                            if (s1 === peg$FAILED) {
                              if (input.substr(peg$currPos, 7) === peg$c508) {
                                s1 = peg$c508;
                                peg$currPos += 7;
                              } else {
                                s1 = peg$FAILED;
                                if (peg$silentFails === 0) { peg$fail(peg$c509); }
                              }
                              if (s1 === peg$FAILED) {
                                if (input.substr(peg$currPos, 7) === peg$c510) {
                                  s1 = peg$c510;
                                  peg$currPos += 7;
                                } else {
                                  s1 = peg$FAILED;
                                  if (peg$silentFails === 0) { peg$fail(peg$c511); }
                                }
                              }
                            }
                            if (s1 !== peg$FAILED) {
                              s2 = [];
                              s3 = peg$parseWS();
                              while (s3 !== peg$FAILED) {
                                s2.push(s3);
                                s3 = peg$parseWS();
                              }
                              if (s2 !== peg$FAILED) {
                                if (input.charCodeAt(peg$currPos) === 40) {
                                  s3 = peg$c34;
                                  peg$currPos++;
                                } else {
                                  s3 = peg$FAILED;
                                  if (peg$silentFails === 0) { peg$fail(peg$c35); }
                                }
                                if (s3 !== peg$FAILED) {
                                  s4 = [];
                                  s5 = peg$parseWS();
                                  while (s5 !== peg$FAILED) {
                                    s4.push(s5);
                                    s5 = peg$parseWS();
                                  }
                                  if (s4 !== peg$FAILED) {
                                    s5 = peg$parseExpression();
                                    if (s5 !== peg$FAILED) {
                                      s6 = [];
                                      s7 = peg$parseWS();
                                      while (s7 !== peg$FAILED) {
                                        s6.push(s7);
                                        s7 = peg$parseWS();
                                      }
                                      if (s6 !== peg$FAILED) {
                                        if (input.charCodeAt(peg$currPos) === 41) {
                                          s7 = peg$c40;
                                          peg$currPos++;
                                        } else {
                                          s7 = peg$FAILED;
                                          if (peg$silentFails === 0) { peg$fail(peg$c41); }
                                        }
                                        if (s7 !== peg$FAILED) {
                                          peg$savedPos = s0;
                                          s1 = peg$c512(s5);
                                          s0 = s1;
                                        } else {
                                          peg$currPos = s0;
                                          s0 = peg$FAILED;
                                        }
                                      } else {
                                        peg$currPos = s0;
                                        s0 = peg$FAILED;
                                      }
                                    } else {
                                      peg$currPos = s0;
                                      s0 = peg$FAILED;
                                    }
                                  } else {
                                    peg$currPos = s0;
                                    s0 = peg$FAILED;
                                  }
                                } else {
                                  peg$currPos = s0;
                                  s0 = peg$FAILED;
                                }
                              } else {
                                peg$currPos = s0;
                                s0 = peg$FAILED;
                              }
                            } else {
                              peg$currPos = s0;
                              s0 = peg$FAILED;
                            }
                            if (s0 === peg$FAILED) {
                              s0 = peg$currPos;
                              if (input.substr(peg$currPos, 8) === peg$c513) {
                                s1 = peg$c513;
                                peg$currPos += 8;
                              } else {
                                s1 = peg$FAILED;
                                if (peg$silentFails === 0) { peg$fail(peg$c514); }
                              }
                              if (s1 === peg$FAILED) {
                                if (input.substr(peg$currPos, 8) === peg$c515) {
                                  s1 = peg$c515;
                                  peg$currPos += 8;
                                } else {
                                  s1 = peg$FAILED;
                                  if (peg$silentFails === 0) { peg$fail(peg$c516); }
                                }
                              }
                              if (s1 !== peg$FAILED) {
                                s2 = [];
                                s3 = peg$parseWS();
                                while (s3 !== peg$FAILED) {
                                  s2.push(s3);
                                  s3 = peg$parseWS();
                                }
                                if (s2 !== peg$FAILED) {
                                  if (input.charCodeAt(peg$currPos) === 40) {
                                    s3 = peg$c34;
                                    peg$currPos++;
                                  } else {
                                    s3 = peg$FAILED;
                                    if (peg$silentFails === 0) { peg$fail(peg$c35); }
                                  }
                                  if (s3 !== peg$FAILED) {
                                    s4 = [];
                                    s5 = peg$parseWS();
                                    while (s5 !== peg$FAILED) {
                                      s4.push(s5);
                                      s5 = peg$parseWS();
                                    }
                                    if (s4 !== peg$FAILED) {
                                      s5 = peg$parseExpression();
                                      if (s5 !== peg$FAILED) {
                                        s6 = [];
                                        s7 = peg$parseWS();
                                        while (s7 !== peg$FAILED) {
                                          s6.push(s7);
                                          s7 = peg$parseWS();
                                        }
                                        if (s6 !== peg$FAILED) {
                                          if (input.charCodeAt(peg$currPos) === 44) {
                                            s7 = peg$c306;
                                            peg$currPos++;
                                          } else {
                                            s7 = peg$FAILED;
                                            if (peg$silentFails === 0) { peg$fail(peg$c307); }
                                          }
                                          if (s7 !== peg$FAILED) {
                                            s8 = [];
                                            s9 = peg$parseWS();
                                            while (s9 !== peg$FAILED) {
                                              s8.push(s9);
                                              s9 = peg$parseWS();
                                            }
                                            if (s8 !== peg$FAILED) {
                                              s9 = peg$parseExpression();
                                              if (s9 !== peg$FAILED) {
                                                s10 = [];
                                                s11 = peg$parseWS();
                                                while (s11 !== peg$FAILED) {
                                                  s10.push(s11);
                                                  s11 = peg$parseWS();
                                                }
                                                if (s10 !== peg$FAILED) {
                                                  if (input.charCodeAt(peg$currPos) === 41) {
                                                    s11 = peg$c40;
                                                    peg$currPos++;
                                                  } else {
                                                    s11 = peg$FAILED;
                                                    if (peg$silentFails === 0) { peg$fail(peg$c41); }
                                                  }
                                                  if (s11 !== peg$FAILED) {
                                                    peg$savedPos = s0;
                                                    s1 = peg$c517(s5, s9);
                                                    s0 = s1;
                                                  } else {
                                                    peg$currPos = s0;
                                                    s0 = peg$FAILED;
                                                  }
                                                } else {
                                                  peg$currPos = s0;
                                                  s0 = peg$FAILED;
                                                }
                                              } else {
                                                peg$currPos = s0;
                                                s0 = peg$FAILED;
                                              }
                                            } else {
                                              peg$currPos = s0;
                                              s0 = peg$FAILED;
                                            }
                                          } else {
                                            peg$currPos = s0;
                                            s0 = peg$FAILED;
                                          }
                                        } else {
                                          peg$currPos = s0;
                                          s0 = peg$FAILED;
                                        }
                                      } else {
                                        peg$currPos = s0;
                                        s0 = peg$FAILED;
                                      }
                                    } else {
                                      peg$currPos = s0;
                                      s0 = peg$FAILED;
                                    }
                                  } else {
                                    peg$currPos = s0;
                                    s0 = peg$FAILED;
                                  }
                                } else {
                                  peg$currPos = s0;
                                  s0 = peg$FAILED;
                                }
                              } else {
                                peg$currPos = s0;
                                s0 = peg$FAILED;
                              }
                              if (s0 === peg$FAILED) {
                                s0 = peg$currPos;
                                if (input.substr(peg$currPos, 5) === peg$c518) {
                                  s1 = peg$c518;
                                  peg$currPos += 5;
                                } else {
                                  s1 = peg$FAILED;
                                  if (peg$silentFails === 0) { peg$fail(peg$c519); }
                                }
                                if (s1 === peg$FAILED) {
                                  if (input.substr(peg$currPos, 5) === peg$c520) {
                                    s1 = peg$c520;
                                    peg$currPos += 5;
                                  } else {
                                    s1 = peg$FAILED;
                                    if (peg$silentFails === 0) { peg$fail(peg$c521); }
                                  }
                                  if (s1 === peg$FAILED) {
                                    if (input.substr(peg$currPos, 5) === peg$c522) {
                                      s1 = peg$c522;
                                      peg$currPos += 5;
                                    } else {
                                      s1 = peg$FAILED;
                                      if (peg$silentFails === 0) { peg$fail(peg$c523); }
                                    }
                                    if (s1 === peg$FAILED) {
                                      if (input.substr(peg$currPos, 5) === peg$c524) {
                                        s1 = peg$c524;
                                        peg$currPos += 5;
                                      } else {
                                        s1 = peg$FAILED;
                                        if (peg$silentFails === 0) { peg$fail(peg$c525); }
                                      }
                                      if (s1 === peg$FAILED) {
                                        if (input.substr(peg$currPos, 5) === peg$c526) {
                                          s1 = peg$c526;
                                          peg$currPos += 5;
                                        } else {
                                          s1 = peg$FAILED;
                                          if (peg$silentFails === 0) { peg$fail(peg$c527); }
                                        }
                                        if (s1 === peg$FAILED) {
                                          if (input.substr(peg$currPos, 5) === peg$c528) {
                                            s1 = peg$c528;
                                            peg$currPos += 5;
                                          } else {
                                            s1 = peg$FAILED;
                                            if (peg$silentFails === 0) { peg$fail(peg$c529); }
                                          }
                                        }
                                      }
                                    }
                                  }
                                }
                                if (s1 !== peg$FAILED) {
                                  s2 = [];
                                  s3 = peg$parseWS();
                                  while (s3 !== peg$FAILED) {
                                    s2.push(s3);
                                    s3 = peg$parseWS();
                                  }
                                  if (s2 !== peg$FAILED) {
                                    if (input.charCodeAt(peg$currPos) === 40) {
                                      s3 = peg$c34;
                                      peg$currPos++;
                                    } else {
                                      s3 = peg$FAILED;
                                      if (peg$silentFails === 0) { peg$fail(peg$c35); }
                                    }
                                    if (s3 !== peg$FAILED) {
                                      s4 = [];
                                      s5 = peg$parseWS();
                                      while (s5 !== peg$FAILED) {
                                        s4.push(s5);
                                        s5 = peg$parseWS();
                                      }
                                      if (s4 !== peg$FAILED) {
                                        s5 = peg$parseExpression();
                                        if (s5 !== peg$FAILED) {
                                          s6 = [];
                                          s7 = peg$parseWS();
                                          while (s7 !== peg$FAILED) {
                                            s6.push(s7);
                                            s7 = peg$parseWS();
                                          }
                                          if (s6 !== peg$FAILED) {
                                            if (input.charCodeAt(peg$currPos) === 41) {
                                              s7 = peg$c40;
                                              peg$currPos++;
                                            } else {
                                              s7 = peg$FAILED;
                                              if (peg$silentFails === 0) { peg$fail(peg$c41); }
                                            }
                                            if (s7 !== peg$FAILED) {
                                              peg$savedPos = s0;
                                              s1 = peg$c530(s5);
                                              s0 = s1;
                                            } else {
                                              peg$currPos = s0;
                                              s0 = peg$FAILED;
                                            }
                                          } else {
                                            peg$currPos = s0;
                                            s0 = peg$FAILED;
                                          }
                                        } else {
                                          peg$currPos = s0;
                                          s0 = peg$FAILED;
                                        }
                                      } else {
                                        peg$currPos = s0;
                                        s0 = peg$FAILED;
                                      }
                                    } else {
                                      peg$currPos = s0;
                                      s0 = peg$FAILED;
                                    }
                                  } else {
                                    peg$currPos = s0;
                                    s0 = peg$FAILED;
                                  }
                                } else {
                                  peg$currPos = s0;
                                  s0 = peg$FAILED;
                                }
                                if (s0 === peg$FAILED) {
                                  s0 = peg$currPos;
                                  if (input.substr(peg$currPos, 7) === peg$c531) {
                                    s1 = peg$c531;
                                    peg$currPos += 7;
                                  } else {
                                    s1 = peg$FAILED;
                                    if (peg$silentFails === 0) { peg$fail(peg$c532); }
                                  }
                                  if (s1 === peg$FAILED) {
                                    if (input.substr(peg$currPos, 7) === peg$c533) {
                                      s1 = peg$c533;
                                      peg$currPos += 7;
                                    } else {
                                      s1 = peg$FAILED;
                                      if (peg$silentFails === 0) { peg$fail(peg$c534); }
                                    }
                                  }
                                  if (s1 !== peg$FAILED) {
                                    s2 = [];
                                    if (peg$c535.test(input.charAt(peg$currPos))) {
                                      s3 = input.charAt(peg$currPos);
                                      peg$currPos++;
                                    } else {
                                      s3 = peg$FAILED;
                                      if (peg$silentFails === 0) { peg$fail(peg$c536); }
                                    }
                                    if (s3 !== peg$FAILED) {
                                      while (s3 !== peg$FAILED) {
                                        s2.push(s3);
                                        if (peg$c535.test(input.charAt(peg$currPos))) {
                                          s3 = input.charAt(peg$currPos);
                                          peg$currPos++;
                                        } else {
                                          s3 = peg$FAILED;
                                          if (peg$silentFails === 0) { peg$fail(peg$c536); }
                                        }
                                      }
                                    } else {
                                      s2 = peg$FAILED;
                                    }
                                    if (s2 !== peg$FAILED) {
                                      s3 = [];
                                      s4 = peg$parseWS();
                                      while (s4 !== peg$FAILED) {
                                        s3.push(s4);
                                        s4 = peg$parseWS();
                                      }
                                      if (s3 !== peg$FAILED) {
                                        if (input.charCodeAt(peg$currPos) === 40) {
                                          s4 = peg$c34;
                                          peg$currPos++;
                                        } else {
                                          s4 = peg$FAILED;
                                          if (peg$silentFails === 0) { peg$fail(peg$c35); }
                                        }
                                        if (s4 !== peg$FAILED) {
                                          s5 = [];
                                          s6 = peg$currPos;
                                          s7 = [];
                                          s8 = peg$parseWS();
                                          while (s8 !== peg$FAILED) {
                                            s7.push(s8);
                                            s8 = peg$parseWS();
                                          }
                                          if (s7 !== peg$FAILED) {
                                            s8 = peg$parseExpression();
                                            if (s8 !== peg$FAILED) {
                                              if (input.charCodeAt(peg$currPos) === 44) {
                                                s9 = peg$c306;
                                                peg$currPos++;
                                              } else {
                                                s9 = peg$FAILED;
                                                if (peg$silentFails === 0) { peg$fail(peg$c307); }
                                              }
                                              if (s9 !== peg$FAILED) {
                                                s7 = [s7, s8, s9];
                                                s6 = s7;
                                              } else {
                                                peg$currPos = s6;
                                                s6 = peg$FAILED;
                                              }
                                            } else {
                                              peg$currPos = s6;
                                              s6 = peg$FAILED;
                                            }
                                          } else {
                                            peg$currPos = s6;
                                            s6 = peg$FAILED;
                                          }
                                          while (s6 !== peg$FAILED) {
                                            s5.push(s6);
                                            s6 = peg$currPos;
                                            s7 = [];
                                            s8 = peg$parseWS();
                                            while (s8 !== peg$FAILED) {
                                              s7.push(s8);
                                              s8 = peg$parseWS();
                                            }
                                            if (s7 !== peg$FAILED) {
                                              s8 = peg$parseExpression();
                                              if (s8 !== peg$FAILED) {
                                                if (input.charCodeAt(peg$currPos) === 44) {
                                                  s9 = peg$c306;
                                                  peg$currPos++;
                                                } else {
                                                  s9 = peg$FAILED;
                                                  if (peg$silentFails === 0) { peg$fail(peg$c307); }
                                                }
                                                if (s9 !== peg$FAILED) {
                                                  s7 = [s7, s8, s9];
                                                  s6 = s7;
                                                } else {
                                                  peg$currPos = s6;
                                                  s6 = peg$FAILED;
                                                }
                                              } else {
                                                peg$currPos = s6;
                                                s6 = peg$FAILED;
                                              }
                                            } else {
                                              peg$currPos = s6;
                                              s6 = peg$FAILED;
                                            }
                                          }
                                          if (s5 !== peg$FAILED) {
                                            s6 = [];
                                            s7 = peg$parseWS();
                                            while (s7 !== peg$FAILED) {
                                              s6.push(s7);
                                              s7 = peg$parseWS();
                                            }
                                            if (s6 !== peg$FAILED) {
                                              s7 = peg$parseExpression();
                                              if (s7 !== peg$FAILED) {
                                                s8 = [];
                                                s9 = peg$parseWS();
                                                while (s9 !== peg$FAILED) {
                                                  s8.push(s9);
                                                  s9 = peg$parseWS();
                                                }
                                                if (s8 !== peg$FAILED) {
                                                  if (input.charCodeAt(peg$currPos) === 41) {
                                                    s9 = peg$c40;
                                                    peg$currPos++;
                                                  } else {
                                                    s9 = peg$FAILED;
                                                    if (peg$silentFails === 0) { peg$fail(peg$c41); }
                                                  }
                                                  if (s9 !== peg$FAILED) {
                                                    peg$savedPos = s0;
                                                    s1 = peg$c537(s2, s5, s7);
                                                    s0 = s1;
                                                  } else {
                                                    peg$currPos = s0;
                                                    s0 = peg$FAILED;
                                                  }
                                                } else {
                                                  peg$currPos = s0;
                                                  s0 = peg$FAILED;
                                                }
                                              } else {
                                                peg$currPos = s0;
                                                s0 = peg$FAILED;
                                              }
                                            } else {
                                              peg$currPos = s0;
                                              s0 = peg$FAILED;
                                            }
                                          } else {
                                            peg$currPos = s0;
                                            s0 = peg$FAILED;
                                          }
                                        } else {
                                          peg$currPos = s0;
                                          s0 = peg$FAILED;
                                        }
                                      } else {
                                        peg$currPos = s0;
                                        s0 = peg$FAILED;
                                      }
                                    } else {
                                      peg$currPos = s0;
                                      s0 = peg$FAILED;
                                    }
                                  } else {
                                    peg$currPos = s0;
                                    s0 = peg$FAILED;
                                  }
                                  if (s0 === peg$FAILED) {
                                    s0 = peg$parseRegexExpression();
                                    if (s0 === peg$FAILED) {
                                      s0 = peg$parseExistsFunc();
                                      if (s0 === peg$FAILED) {
                                        s0 = peg$parseNotExistsFunc();
                                      }
                                    }
                                  }
                                }
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c448); }
      }

      return s0;
    }

    function peg$parseRegexExpression() {
      var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14;

      peg$silentFails++;
      s0 = peg$currPos;
      if (input.substr(peg$currPos, 5) === peg$c539) {
        s1 = peg$c539;
        peg$currPos += 5;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c540); }
      }
      if (s1 === peg$FAILED) {
        if (input.substr(peg$currPos, 5) === peg$c541) {
          s1 = peg$c541;
          peg$currPos += 5;
        } else {
          s1 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c542); }
        }
      }
      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$parseWS();
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parseWS();
        }
        if (s2 !== peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 40) {
            s3 = peg$c34;
            peg$currPos++;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c35); }
          }
          if (s3 !== peg$FAILED) {
            s4 = [];
            s5 = peg$parseWS();
            while (s5 !== peg$FAILED) {
              s4.push(s5);
              s5 = peg$parseWS();
            }
            if (s4 !== peg$FAILED) {
              s5 = peg$parseExpression();
              if (s5 !== peg$FAILED) {
                s6 = [];
                s7 = peg$parseWS();
                while (s7 !== peg$FAILED) {
                  s6.push(s7);
                  s7 = peg$parseWS();
                }
                if (s6 !== peg$FAILED) {
                  if (input.charCodeAt(peg$currPos) === 44) {
                    s7 = peg$c306;
                    peg$currPos++;
                  } else {
                    s7 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$c307); }
                  }
                  if (s7 !== peg$FAILED) {
                    s8 = [];
                    s9 = peg$parseWS();
                    while (s9 !== peg$FAILED) {
                      s8.push(s9);
                      s9 = peg$parseWS();
                    }
                    if (s8 !== peg$FAILED) {
                      s9 = peg$parseExpression();
                      if (s9 !== peg$FAILED) {
                        s10 = [];
                        s11 = peg$parseWS();
                        while (s11 !== peg$FAILED) {
                          s10.push(s11);
                          s11 = peg$parseWS();
                        }
                        if (s10 !== peg$FAILED) {
                          s11 = peg$currPos;
                          if (input.charCodeAt(peg$currPos) === 44) {
                            s12 = peg$c306;
                            peg$currPos++;
                          } else {
                            s12 = peg$FAILED;
                            if (peg$silentFails === 0) { peg$fail(peg$c307); }
                          }
                          if (s12 !== peg$FAILED) {
                            s13 = [];
                            s14 = peg$parseWS();
                            while (s14 !== peg$FAILED) {
                              s13.push(s14);
                              s14 = peg$parseWS();
                            }
                            if (s13 !== peg$FAILED) {
                              s14 = peg$parseExpression();
                              if (s14 !== peg$FAILED) {
                                s12 = [s12, s13, s14];
                                s11 = s12;
                              } else {
                                peg$currPos = s11;
                                s11 = peg$FAILED;
                              }
                            } else {
                              peg$currPos = s11;
                              s11 = peg$FAILED;
                            }
                          } else {
                            peg$currPos = s11;
                            s11 = peg$FAILED;
                          }
                          if (s11 === peg$FAILED) {
                            s11 = null;
                          }
                          if (s11 !== peg$FAILED) {
                            s12 = [];
                            s13 = peg$parseWS();
                            while (s13 !== peg$FAILED) {
                              s12.push(s13);
                              s13 = peg$parseWS();
                            }
                            if (s12 !== peg$FAILED) {
                              if (input.charCodeAt(peg$currPos) === 41) {
                                s13 = peg$c40;
                                peg$currPos++;
                              } else {
                                s13 = peg$FAILED;
                                if (peg$silentFails === 0) { peg$fail(peg$c41); }
                              }
                              if (s13 !== peg$FAILED) {
                                peg$savedPos = s0;
                                s1 = peg$c543(s5, s9, s11);
                                s0 = s1;
                              } else {
                                peg$currPos = s0;
                                s0 = peg$FAILED;
                              }
                            } else {
                              peg$currPos = s0;
                              s0 = peg$FAILED;
                            }
                          } else {
                            peg$currPos = s0;
                            s0 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s0;
                          s0 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s0;
                        s0 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s0;
                      s0 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c538); }
      }

      return s0;
    }

    function peg$parseExistsFunc() {
      var s0, s1, s2, s3;

      peg$silentFails++;
      s0 = peg$currPos;
      if (input.substr(peg$currPos, 6) === peg$c545) {
        s1 = peg$c545;
        peg$currPos += 6;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c546); }
      }
      if (s1 === peg$FAILED) {
        if (input.substr(peg$currPos, 6) === peg$c547) {
          s1 = peg$c547;
          peg$currPos += 6;
        } else {
          s1 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c548); }
        }
      }
      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$parseWS();
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parseWS();
        }
        if (s2 !== peg$FAILED) {
          s3 = peg$parseGroupGraphPattern();
          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c549(s3);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c544); }
      }

      return s0;
    }

    function peg$parseNotExistsFunc() {
      var s0, s1, s2, s3, s4, s5;

      peg$silentFails++;
      s0 = peg$currPos;
      if (input.substr(peg$currPos, 3) === peg$c551) {
        s1 = peg$c551;
        peg$currPos += 3;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c552); }
      }
      if (s1 === peg$FAILED) {
        if (input.substr(peg$currPos, 3) === peg$c553) {
          s1 = peg$c553;
          peg$currPos += 3;
        } else {
          s1 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c554); }
        }
      }
      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$parseWS();
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parseWS();
        }
        if (s2 !== peg$FAILED) {
          if (input.substr(peg$currPos, 6) === peg$c545) {
            s3 = peg$c545;
            peg$currPos += 6;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c546); }
          }
          if (s3 === peg$FAILED) {
            if (input.substr(peg$currPos, 6) === peg$c547) {
              s3 = peg$c547;
              peg$currPos += 6;
            } else {
              s3 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c548); }
            }
          }
          if (s3 !== peg$FAILED) {
            s4 = [];
            s5 = peg$parseWS();
            while (s5 !== peg$FAILED) {
              s4.push(s5);
              s5 = peg$parseWS();
            }
            if (s4 !== peg$FAILED) {
              s5 = peg$parseGroupGraphPattern();
              if (s5 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c555(s5);
                s0 = s1;
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c550); }
      }

      return s0;
    }

    function peg$parseAggregate() {
      var s0, s1, s2, s3, s4, s5, s6, s7, s8, s9, s10, s11, s12, s13, s14, s15, s16, s17;

      peg$silentFails++;
      s0 = peg$currPos;
      if (input.substr(peg$currPos, 5) === peg$c557) {
        s1 = peg$c557;
        peg$currPos += 5;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c558); }
      }
      if (s1 === peg$FAILED) {
        if (input.substr(peg$currPos, 5) === peg$c559) {
          s1 = peg$c559;
          peg$currPos += 5;
        } else {
          s1 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c560); }
        }
      }
      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$parseWS();
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parseWS();
        }
        if (s2 !== peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 40) {
            s3 = peg$c34;
            peg$currPos++;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c35); }
          }
          if (s3 !== peg$FAILED) {
            s4 = [];
            s5 = peg$parseWS();
            while (s5 !== peg$FAILED) {
              s4.push(s5);
              s5 = peg$parseWS();
            }
            if (s4 !== peg$FAILED) {
              if (input.substr(peg$currPos, 8) === peg$c26) {
                s5 = peg$c26;
                peg$currPos += 8;
              } else {
                s5 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c27); }
              }
              if (s5 === peg$FAILED) {
                if (input.substr(peg$currPos, 8) === peg$c28) {
                  s5 = peg$c28;
                  peg$currPos += 8;
                } else {
                  s5 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c29); }
                }
              }
              if (s5 === peg$FAILED) {
                s5 = null;
              }
              if (s5 !== peg$FAILED) {
                s6 = [];
                s7 = peg$parseWS();
                while (s7 !== peg$FAILED) {
                  s6.push(s7);
                  s7 = peg$parseWS();
                }
                if (s6 !== peg$FAILED) {
                  if (input.charCodeAt(peg$currPos) === 42) {
                    s7 = peg$c42;
                    peg$currPos++;
                  } else {
                    s7 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$c43); }
                  }
                  if (s7 === peg$FAILED) {
                    s7 = peg$parseExpression();
                  }
                  if (s7 !== peg$FAILED) {
                    s8 = [];
                    s9 = peg$parseWS();
                    while (s9 !== peg$FAILED) {
                      s8.push(s9);
                      s9 = peg$parseWS();
                    }
                    if (s8 !== peg$FAILED) {
                      if (input.charCodeAt(peg$currPos) === 41) {
                        s9 = peg$c40;
                        peg$currPos++;
                      } else {
                        s9 = peg$FAILED;
                        if (peg$silentFails === 0) { peg$fail(peg$c41); }
                      }
                      if (s9 !== peg$FAILED) {
                        s10 = [];
                        s11 = peg$parseWS();
                        while (s11 !== peg$FAILED) {
                          s10.push(s11);
                          s11 = peg$parseWS();
                        }
                        if (s10 !== peg$FAILED) {
                          peg$savedPos = s0;
                          s1 = peg$c561(s5, s7);
                          s0 = s1;
                        } else {
                          peg$currPos = s0;
                          s0 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s0;
                        s0 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s0;
                      s0 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        if (input.substr(peg$currPos, 12) === peg$c562) {
          s1 = peg$c562;
          peg$currPos += 12;
        } else {
          s1 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c563); }
        }
        if (s1 === peg$FAILED) {
          if (input.substr(peg$currPos, 12) === peg$c564) {
            s1 = peg$c564;
            peg$currPos += 12;
          } else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c565); }
          }
        }
        if (s1 !== peg$FAILED) {
          s2 = [];
          s3 = peg$parseWS();
          while (s3 !== peg$FAILED) {
            s2.push(s3);
            s3 = peg$parseWS();
          }
          if (s2 !== peg$FAILED) {
            if (input.charCodeAt(peg$currPos) === 40) {
              s3 = peg$c34;
              peg$currPos++;
            } else {
              s3 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c35); }
            }
            if (s3 !== peg$FAILED) {
              s4 = [];
              s5 = peg$parseWS();
              while (s5 !== peg$FAILED) {
                s4.push(s5);
                s5 = peg$parseWS();
              }
              if (s4 !== peg$FAILED) {
                if (input.substr(peg$currPos, 8) === peg$c26) {
                  s5 = peg$c26;
                  peg$currPos += 8;
                } else {
                  s5 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c27); }
                }
                if (s5 === peg$FAILED) {
                  if (input.substr(peg$currPos, 8) === peg$c28) {
                    s5 = peg$c28;
                    peg$currPos += 8;
                  } else {
                    s5 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$c29); }
                  }
                }
                if (s5 === peg$FAILED) {
                  s5 = null;
                }
                if (s5 !== peg$FAILED) {
                  s6 = [];
                  s7 = peg$parseWS();
                  while (s7 !== peg$FAILED) {
                    s6.push(s7);
                    s7 = peg$parseWS();
                  }
                  if (s6 !== peg$FAILED) {
                    s7 = peg$parseExpression();
                    if (s7 !== peg$FAILED) {
                      s8 = peg$currPos;
                      if (input.charCodeAt(peg$currPos) === 59) {
                        s9 = peg$c152;
                        peg$currPos++;
                      } else {
                        s9 = peg$FAILED;
                        if (peg$silentFails === 0) { peg$fail(peg$c153); }
                      }
                      if (s9 !== peg$FAILED) {
                        s10 = [];
                        s11 = peg$parseWS();
                        while (s11 !== peg$FAILED) {
                          s10.push(s11);
                          s11 = peg$parseWS();
                        }
                        if (s10 !== peg$FAILED) {
                          if (input.substr(peg$currPos, 9) === peg$c566) {
                            s11 = peg$c566;
                            peg$currPos += 9;
                          } else {
                            s11 = peg$FAILED;
                            if (peg$silentFails === 0) { peg$fail(peg$c567); }
                          }
                          if (s11 !== peg$FAILED) {
                            s12 = [];
                            s13 = peg$parseWS();
                            while (s13 !== peg$FAILED) {
                              s12.push(s13);
                              s13 = peg$parseWS();
                            }
                            if (s12 !== peg$FAILED) {
                              if (input.charCodeAt(peg$currPos) === 61) {
                                s13 = peg$c401;
                                peg$currPos++;
                              } else {
                                s13 = peg$FAILED;
                                if (peg$silentFails === 0) { peg$fail(peg$c402); }
                              }
                              if (s13 !== peg$FAILED) {
                                s14 = [];
                                s15 = peg$parseWS();
                                while (s15 !== peg$FAILED) {
                                  s14.push(s15);
                                  s15 = peg$parseWS();
                                }
                                if (s14 !== peg$FAILED) {
                                  s15 = peg$parseString();
                                  if (s15 !== peg$FAILED) {
                                    s16 = [];
                                    s17 = peg$parseWS();
                                    while (s17 !== peg$FAILED) {
                                      s16.push(s17);
                                      s17 = peg$parseWS();
                                    }
                                    if (s16 !== peg$FAILED) {
                                      s9 = [s9, s10, s11, s12, s13, s14, s15, s16];
                                      s8 = s9;
                                    } else {
                                      peg$currPos = s8;
                                      s8 = peg$FAILED;
                                    }
                                  } else {
                                    peg$currPos = s8;
                                    s8 = peg$FAILED;
                                  }
                                } else {
                                  peg$currPos = s8;
                                  s8 = peg$FAILED;
                                }
                              } else {
                                peg$currPos = s8;
                                s8 = peg$FAILED;
                              }
                            } else {
                              peg$currPos = s8;
                              s8 = peg$FAILED;
                            }
                          } else {
                            peg$currPos = s8;
                            s8 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s8;
                          s8 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s8;
                        s8 = peg$FAILED;
                      }
                      if (s8 === peg$FAILED) {
                        s8 = null;
                      }
                      if (s8 !== peg$FAILED) {
                        if (input.charCodeAt(peg$currPos) === 41) {
                          s9 = peg$c40;
                          peg$currPos++;
                        } else {
                          s9 = peg$FAILED;
                          if (peg$silentFails === 0) { peg$fail(peg$c41); }
                        }
                        if (s9 !== peg$FAILED) {
                          s10 = [];
                          s11 = peg$parseWS();
                          while (s11 !== peg$FAILED) {
                            s10.push(s11);
                            s11 = peg$parseWS();
                          }
                          if (s10 !== peg$FAILED) {
                            peg$savedPos = s0;
                            s1 = peg$c568(s5, s7, s8);
                            s0 = s1;
                          } else {
                            peg$currPos = s0;
                            s0 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s0;
                          s0 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s0;
                        s0 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s0;
                      s0 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
        if (s0 === peg$FAILED) {
          s0 = peg$currPos;
          if (input.substr(peg$currPos, 3) === peg$c569) {
            s1 = peg$c569;
            peg$currPos += 3;
          } else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c570); }
          }
          if (s1 === peg$FAILED) {
            if (input.substr(peg$currPos, 3) === peg$c571) {
              s1 = peg$c571;
              peg$currPos += 3;
            } else {
              s1 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c572); }
            }
          }
          if (s1 !== peg$FAILED) {
            s2 = [];
            s3 = peg$parseWS();
            while (s3 !== peg$FAILED) {
              s2.push(s3);
              s3 = peg$parseWS();
            }
            if (s2 !== peg$FAILED) {
              if (input.charCodeAt(peg$currPos) === 40) {
                s3 = peg$c34;
                peg$currPos++;
              } else {
                s3 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c35); }
              }
              if (s3 !== peg$FAILED) {
                s4 = [];
                s5 = peg$parseWS();
                while (s5 !== peg$FAILED) {
                  s4.push(s5);
                  s5 = peg$parseWS();
                }
                if (s4 !== peg$FAILED) {
                  if (input.substr(peg$currPos, 8) === peg$c26) {
                    s5 = peg$c26;
                    peg$currPos += 8;
                  } else {
                    s5 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$c27); }
                  }
                  if (s5 === peg$FAILED) {
                    if (input.substr(peg$currPos, 8) === peg$c28) {
                      s5 = peg$c28;
                      peg$currPos += 8;
                    } else {
                      s5 = peg$FAILED;
                      if (peg$silentFails === 0) { peg$fail(peg$c29); }
                    }
                  }
                  if (s5 === peg$FAILED) {
                    s5 = null;
                  }
                  if (s5 !== peg$FAILED) {
                    s6 = [];
                    s7 = peg$parseWS();
                    while (s7 !== peg$FAILED) {
                      s6.push(s7);
                      s7 = peg$parseWS();
                    }
                    if (s6 !== peg$FAILED) {
                      s7 = peg$parseExpression();
                      if (s7 !== peg$FAILED) {
                        s8 = [];
                        s9 = peg$parseWS();
                        while (s9 !== peg$FAILED) {
                          s8.push(s9);
                          s9 = peg$parseWS();
                        }
                        if (s8 !== peg$FAILED) {
                          if (input.charCodeAt(peg$currPos) === 41) {
                            s9 = peg$c40;
                            peg$currPos++;
                          } else {
                            s9 = peg$FAILED;
                            if (peg$silentFails === 0) { peg$fail(peg$c41); }
                          }
                          if (s9 !== peg$FAILED) {
                            s10 = [];
                            s11 = peg$parseWS();
                            while (s11 !== peg$FAILED) {
                              s10.push(s11);
                              s11 = peg$parseWS();
                            }
                            if (s10 !== peg$FAILED) {
                              peg$savedPos = s0;
                              s1 = peg$c573(s5, s7);
                              s0 = s1;
                            } else {
                              peg$currPos = s0;
                              s0 = peg$FAILED;
                            }
                          } else {
                            peg$currPos = s0;
                            s0 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s0;
                          s0 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s0;
                        s0 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s0;
                      s0 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
          if (s0 === peg$FAILED) {
            s0 = peg$currPos;
            if (input.substr(peg$currPos, 3) === peg$c574) {
              s1 = peg$c574;
              peg$currPos += 3;
            } else {
              s1 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c575); }
            }
            if (s1 === peg$FAILED) {
              if (input.substr(peg$currPos, 3) === peg$c576) {
                s1 = peg$c576;
                peg$currPos += 3;
              } else {
                s1 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c577); }
              }
            }
            if (s1 !== peg$FAILED) {
              s2 = [];
              s3 = peg$parseWS();
              while (s3 !== peg$FAILED) {
                s2.push(s3);
                s3 = peg$parseWS();
              }
              if (s2 !== peg$FAILED) {
                if (input.charCodeAt(peg$currPos) === 40) {
                  s3 = peg$c34;
                  peg$currPos++;
                } else {
                  s3 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c35); }
                }
                if (s3 !== peg$FAILED) {
                  s4 = [];
                  s5 = peg$parseWS();
                  while (s5 !== peg$FAILED) {
                    s4.push(s5);
                    s5 = peg$parseWS();
                  }
                  if (s4 !== peg$FAILED) {
                    if (input.substr(peg$currPos, 8) === peg$c26) {
                      s5 = peg$c26;
                      peg$currPos += 8;
                    } else {
                      s5 = peg$FAILED;
                      if (peg$silentFails === 0) { peg$fail(peg$c27); }
                    }
                    if (s5 === peg$FAILED) {
                      if (input.substr(peg$currPos, 8) === peg$c28) {
                        s5 = peg$c28;
                        peg$currPos += 8;
                      } else {
                        s5 = peg$FAILED;
                        if (peg$silentFails === 0) { peg$fail(peg$c29); }
                      }
                    }
                    if (s5 === peg$FAILED) {
                      s5 = null;
                    }
                    if (s5 !== peg$FAILED) {
                      s6 = [];
                      s7 = peg$parseWS();
                      while (s7 !== peg$FAILED) {
                        s6.push(s7);
                        s7 = peg$parseWS();
                      }
                      if (s6 !== peg$FAILED) {
                        s7 = peg$parseExpression();
                        if (s7 !== peg$FAILED) {
                          s8 = [];
                          s9 = peg$parseWS();
                          while (s9 !== peg$FAILED) {
                            s8.push(s9);
                            s9 = peg$parseWS();
                          }
                          if (s8 !== peg$FAILED) {
                            if (input.charCodeAt(peg$currPos) === 41) {
                              s9 = peg$c40;
                              peg$currPos++;
                            } else {
                              s9 = peg$FAILED;
                              if (peg$silentFails === 0) { peg$fail(peg$c41); }
                            }
                            if (s9 !== peg$FAILED) {
                              s10 = [];
                              s11 = peg$parseWS();
                              while (s11 !== peg$FAILED) {
                                s10.push(s11);
                                s11 = peg$parseWS();
                              }
                              if (s10 !== peg$FAILED) {
                                peg$savedPos = s0;
                                s1 = peg$c578(s5, s7);
                                s0 = s1;
                              } else {
                                peg$currPos = s0;
                                s0 = peg$FAILED;
                              }
                            } else {
                              peg$currPos = s0;
                              s0 = peg$FAILED;
                            }
                          } else {
                            peg$currPos = s0;
                            s0 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s0;
                          s0 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s0;
                        s0 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s0;
                      s0 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
            if (s0 === peg$FAILED) {
              s0 = peg$currPos;
              if (input.substr(peg$currPos, 3) === peg$c579) {
                s1 = peg$c579;
                peg$currPos += 3;
              } else {
                s1 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c580); }
              }
              if (s1 === peg$FAILED) {
                if (input.substr(peg$currPos, 3) === peg$c581) {
                  s1 = peg$c581;
                  peg$currPos += 3;
                } else {
                  s1 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c582); }
                }
              }
              if (s1 !== peg$FAILED) {
                s2 = [];
                s3 = peg$parseWS();
                while (s3 !== peg$FAILED) {
                  s2.push(s3);
                  s3 = peg$parseWS();
                }
                if (s2 !== peg$FAILED) {
                  if (input.charCodeAt(peg$currPos) === 40) {
                    s3 = peg$c34;
                    peg$currPos++;
                  } else {
                    s3 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$c35); }
                  }
                  if (s3 !== peg$FAILED) {
                    s4 = [];
                    s5 = peg$parseWS();
                    while (s5 !== peg$FAILED) {
                      s4.push(s5);
                      s5 = peg$parseWS();
                    }
                    if (s4 !== peg$FAILED) {
                      if (input.substr(peg$currPos, 8) === peg$c26) {
                        s5 = peg$c26;
                        peg$currPos += 8;
                      } else {
                        s5 = peg$FAILED;
                        if (peg$silentFails === 0) { peg$fail(peg$c27); }
                      }
                      if (s5 === peg$FAILED) {
                        if (input.substr(peg$currPos, 8) === peg$c28) {
                          s5 = peg$c28;
                          peg$currPos += 8;
                        } else {
                          s5 = peg$FAILED;
                          if (peg$silentFails === 0) { peg$fail(peg$c29); }
                        }
                      }
                      if (s5 === peg$FAILED) {
                        s5 = null;
                      }
                      if (s5 !== peg$FAILED) {
                        s6 = [];
                        s7 = peg$parseWS();
                        while (s7 !== peg$FAILED) {
                          s6.push(s7);
                          s7 = peg$parseWS();
                        }
                        if (s6 !== peg$FAILED) {
                          s7 = peg$parseExpression();
                          if (s7 !== peg$FAILED) {
                            s8 = [];
                            s9 = peg$parseWS();
                            while (s9 !== peg$FAILED) {
                              s8.push(s9);
                              s9 = peg$parseWS();
                            }
                            if (s8 !== peg$FAILED) {
                              if (input.charCodeAt(peg$currPos) === 41) {
                                s9 = peg$c40;
                                peg$currPos++;
                              } else {
                                s9 = peg$FAILED;
                                if (peg$silentFails === 0) { peg$fail(peg$c41); }
                              }
                              if (s9 !== peg$FAILED) {
                                s10 = [];
                                s11 = peg$parseWS();
                                while (s11 !== peg$FAILED) {
                                  s10.push(s11);
                                  s11 = peg$parseWS();
                                }
                                if (s10 !== peg$FAILED) {
                                  peg$savedPos = s0;
                                  s1 = peg$c583(s5, s7);
                                  s0 = s1;
                                } else {
                                  peg$currPos = s0;
                                  s0 = peg$FAILED;
                                }
                              } else {
                                peg$currPos = s0;
                                s0 = peg$FAILED;
                              }
                            } else {
                              peg$currPos = s0;
                              s0 = peg$FAILED;
                            }
                          } else {
                            peg$currPos = s0;
                            s0 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s0;
                          s0 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s0;
                        s0 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s0;
                      s0 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              } else {
                peg$currPos = s0;
                s0 = peg$FAILED;
              }
              if (s0 === peg$FAILED) {
                s0 = peg$currPos;
                if (input.substr(peg$currPos, 3) === peg$c584) {
                  s1 = peg$c584;
                  peg$currPos += 3;
                } else {
                  s1 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c585); }
                }
                if (s1 === peg$FAILED) {
                  if (input.substr(peg$currPos, 3) === peg$c586) {
                    s1 = peg$c586;
                    peg$currPos += 3;
                  } else {
                    s1 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$c587); }
                  }
                }
                if (s1 !== peg$FAILED) {
                  s2 = [];
                  s3 = peg$parseWS();
                  while (s3 !== peg$FAILED) {
                    s2.push(s3);
                    s3 = peg$parseWS();
                  }
                  if (s2 !== peg$FAILED) {
                    if (input.charCodeAt(peg$currPos) === 40) {
                      s3 = peg$c34;
                      peg$currPos++;
                    } else {
                      s3 = peg$FAILED;
                      if (peg$silentFails === 0) { peg$fail(peg$c35); }
                    }
                    if (s3 !== peg$FAILED) {
                      s4 = [];
                      s5 = peg$parseWS();
                      while (s5 !== peg$FAILED) {
                        s4.push(s5);
                        s5 = peg$parseWS();
                      }
                      if (s4 !== peg$FAILED) {
                        if (input.substr(peg$currPos, 8) === peg$c26) {
                          s5 = peg$c26;
                          peg$currPos += 8;
                        } else {
                          s5 = peg$FAILED;
                          if (peg$silentFails === 0) { peg$fail(peg$c27); }
                        }
                        if (s5 === peg$FAILED) {
                          if (input.substr(peg$currPos, 8) === peg$c28) {
                            s5 = peg$c28;
                            peg$currPos += 8;
                          } else {
                            s5 = peg$FAILED;
                            if (peg$silentFails === 0) { peg$fail(peg$c29); }
                          }
                        }
                        if (s5 === peg$FAILED) {
                          s5 = null;
                        }
                        if (s5 !== peg$FAILED) {
                          s6 = [];
                          s7 = peg$parseWS();
                          while (s7 !== peg$FAILED) {
                            s6.push(s7);
                            s7 = peg$parseWS();
                          }
                          if (s6 !== peg$FAILED) {
                            s7 = peg$parseExpression();
                            if (s7 !== peg$FAILED) {
                              s8 = [];
                              s9 = peg$parseWS();
                              while (s9 !== peg$FAILED) {
                                s8.push(s9);
                                s9 = peg$parseWS();
                              }
                              if (s8 !== peg$FAILED) {
                                if (input.charCodeAt(peg$currPos) === 41) {
                                  s9 = peg$c40;
                                  peg$currPos++;
                                } else {
                                  s9 = peg$FAILED;
                                  if (peg$silentFails === 0) { peg$fail(peg$c41); }
                                }
                                if (s9 !== peg$FAILED) {
                                  s10 = [];
                                  s11 = peg$parseWS();
                                  while (s11 !== peg$FAILED) {
                                    s10.push(s11);
                                    s11 = peg$parseWS();
                                  }
                                  if (s10 !== peg$FAILED) {
                                    peg$savedPos = s0;
                                    s1 = peg$c588(s5, s7);
                                    s0 = s1;
                                  } else {
                                    peg$currPos = s0;
                                    s0 = peg$FAILED;
                                  }
                                } else {
                                  peg$currPos = s0;
                                  s0 = peg$FAILED;
                                }
                              } else {
                                peg$currPos = s0;
                                s0 = peg$FAILED;
                              }
                            } else {
                              peg$currPos = s0;
                              s0 = peg$FAILED;
                            }
                          } else {
                            peg$currPos = s0;
                            s0 = peg$FAILED;
                          }
                        } else {
                          peg$currPos = s0;
                          s0 = peg$FAILED;
                        }
                      } else {
                        peg$currPos = s0;
                        s0 = peg$FAILED;
                      }
                    } else {
                      peg$currPos = s0;
                      s0 = peg$FAILED;
                    }
                  } else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                  }
                } else {
                  peg$currPos = s0;
                  s0 = peg$FAILED;
                }
              }
            }
          }
        }
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c556); }
      }

      return s0;
    }

    function peg$parseIRIrefOrFunction() {
      var s0, s1, s2, s3;

      peg$silentFails++;
      s0 = peg$currPos;
      s1 = peg$parseIRIref();
      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$parseWS();
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parseWS();
        }
        if (s2 !== peg$FAILED) {
          s3 = peg$parseArgList();
          if (s3 === peg$FAILED) {
            s3 = null;
          }
          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c590(s1, s3);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c589); }
      }

      return s0;
    }

    function peg$parseRDFLiteral() {
      var s0, s1, s2, s3, s4;

      peg$silentFails++;
      s0 = peg$currPos;
      s1 = peg$parseString();
      if (s1 !== peg$FAILED) {
        s2 = peg$parseLANGTAG();
        if (s2 === peg$FAILED) {
          s2 = peg$currPos;
          if (input.substr(peg$currPos, 2) === peg$c592) {
            s3 = peg$c592;
            peg$currPos += 2;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c593); }
          }
          if (s3 !== peg$FAILED) {
            s4 = peg$parseIRIref();
            if (s4 !== peg$FAILED) {
              s3 = [s3, s4];
              s2 = s3;
            } else {
              peg$currPos = s2;
              s2 = peg$FAILED;
            }
          } else {
            peg$currPos = s2;
            s2 = peg$FAILED;
          }
        }
        if (s2 === peg$FAILED) {
          s2 = null;
        }
        if (s2 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c594(s1, s2);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c591); }
      }

      return s0;
    }

    function peg$parseNumericLiteral() {
      var s0, s1;

      peg$silentFails++;
      s0 = peg$parseNumericLiteralUnsigned();
      if (s0 === peg$FAILED) {
        s0 = peg$parseNumericLiteralPositive();
        if (s0 === peg$FAILED) {
          s0 = peg$parseNumericLiteralNegative();
        }
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c595); }
      }

      return s0;
    }

    function peg$parseNumericLiteralUnsigned() {
      var s0, s1;

      peg$silentFails++;
      s0 = peg$parseDOUBLE();
      if (s0 === peg$FAILED) {
        s0 = peg$parseDECIMAL();
        if (s0 === peg$FAILED) {
          s0 = peg$parseINTEGER();
        }
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c596); }
      }

      return s0;
    }

    function peg$parseNumericLiteralPositive() {
      var s0, s1;

      peg$silentFails++;
      s0 = peg$parseDOUBLE_POSITIVE();
      if (s0 === peg$FAILED) {
        s0 = peg$parseDECIMAL_POSITIVE();
        if (s0 === peg$FAILED) {
          s0 = peg$parseINTEGER_POSITIVE();
        }
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c597); }
      }

      return s0;
    }

    function peg$parseNumericLiteralNegative() {
      var s0, s1;

      peg$silentFails++;
      s0 = peg$parseDOUBLE_NEGATIVE();
      if (s0 === peg$FAILED) {
        s0 = peg$parseDECIMAL_NEGATIVE();
        if (s0 === peg$FAILED) {
          s0 = peg$parseINTEGER_NEGATIVE();
        }
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c598); }
      }

      return s0;
    }

    function peg$parseBooleanLiteral() {
      var s0, s1;

      peg$silentFails++;
      s0 = peg$currPos;
      if (input.substr(peg$currPos, 4) === peg$c600) {
        s1 = peg$c600;
        peg$currPos += 4;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c601); }
      }
      if (s1 === peg$FAILED) {
        if (input.substr(peg$currPos, 4) === peg$c602) {
          s1 = peg$c602;
          peg$currPos += 4;
        } else {
          s1 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c603); }
        }
      }
      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$c604();
      }
      s0 = s1;
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        if (input.substr(peg$currPos, 5) === peg$c605) {
          s1 = peg$c605;
          peg$currPos += 5;
        } else {
          s1 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c606); }
        }
        if (s1 === peg$FAILED) {
          if (input.substr(peg$currPos, 5) === peg$c607) {
            s1 = peg$c607;
            peg$currPos += 5;
          } else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c608); }
          }
        }
        if (s1 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c609();
        }
        s0 = s1;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c599); }
      }

      return s0;
    }

    function peg$parseString() {
      var s0, s1;

      peg$silentFails++;
      s0 = peg$currPos;
      s1 = peg$parseSTRING_LITERAL_LONG1();
      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$c611(s1);
      }
      s0 = s1;
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        s1 = peg$parseSTRING_LITERAL_LONG2();
        if (s1 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c611(s1);
        }
        s0 = s1;
        if (s0 === peg$FAILED) {
          s0 = peg$currPos;
          s1 = peg$parseSTRING_LITERAL1();
          if (s1 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c611(s1);
          }
          s0 = s1;
          if (s0 === peg$FAILED) {
            s0 = peg$currPos;
            s1 = peg$parseSTRING_LITERAL2();
            if (s1 !== peg$FAILED) {
              peg$savedPos = s0;
              s1 = peg$c611(s1);
            }
            s0 = s1;
          }
        }
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c610); }
      }

      return s0;
    }

    function peg$parseIRIref() {
      var s0, s1;

      peg$silentFails++;
      s0 = peg$currPos;
      s1 = peg$parseIRI_REF();
      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$c613(s1);
      }
      s0 = s1;
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        s1 = peg$parsePrefixedName();
        if (s1 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c614(s1);
        }
        s0 = s1;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c612); }
      }

      return s0;
    }

    function peg$parsePrefixedName() {
      var s0, s1;

      peg$silentFails++;
      s0 = peg$currPos;
      s1 = peg$parsePNAME_LN();
      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$c616(s1);
      }
      s0 = s1;
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        s1 = peg$parsePNAME_NS();
        if (s1 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c617(s1);
        }
        s0 = s1;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c615); }
      }

      return s0;
    }

    function peg$parseBlankNode() {
      var s0, s1;

      peg$silentFails++;
      s0 = peg$currPos;
      s1 = peg$parseBLANK_NODE_LABEL();
      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$c619(s1);
      }
      s0 = s1;
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        s1 = peg$parseANON();
        if (s1 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c620();
        }
        s0 = s1;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c618); }
      }

      return s0;
    }

    function peg$parseIRI_REF() {
      var s0, s1, s2, s3;

      peg$silentFails++;
      s0 = peg$currPos;
      if (input.charCodeAt(peg$currPos) === 60) {
        s1 = peg$c405;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c406); }
      }
      if (s1 !== peg$FAILED) {
        s2 = [];
        if (peg$c622.test(input.charAt(peg$currPos))) {
          s3 = input.charAt(peg$currPos);
          peg$currPos++;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c623); }
        }
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          if (peg$c622.test(input.charAt(peg$currPos))) {
            s3 = input.charAt(peg$currPos);
            peg$currPos++;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c623); }
          }
        }
        if (s2 !== peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 62) {
            s3 = peg$c407;
            peg$currPos++;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c408); }
          }
          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c624(s2);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c621); }
      }

      return s0;
    }

    function peg$parsePNAME_NS() {
      var s0, s1, s2;

      peg$silentFails++;
      s0 = peg$currPos;
      s1 = peg$parsePN_PREFIX();
      if (s1 === peg$FAILED) {
        s1 = null;
      }
      if (s1 !== peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 58) {
          s2 = peg$c626;
          peg$currPos++;
        } else {
          s2 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c627); }
        }
        if (s2 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c614(s1);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c625); }
      }

      return s0;
    }

    function peg$parsePNAME_LN() {
      var s0, s1, s2;

      peg$silentFails++;
      s0 = peg$currPos;
      s1 = peg$parsePNAME_NS();
      if (s1 !== peg$FAILED) {
        s2 = peg$parsePN_LOCAL();
        if (s2 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c629(s1, s2);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c628); }
      }

      return s0;
    }

    function peg$parseBLANK_NODE_LABEL() {
      var s0, s1, s2;

      peg$silentFails++;
      s0 = peg$currPos;
      if (input.substr(peg$currPos, 2) === peg$c631) {
        s1 = peg$c631;
        peg$currPos += 2;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c632); }
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parsePN_LOCAL();
        if (s2 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c633(s2);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c630); }
      }

      return s0;
    }

    function peg$parseVAR1() {
      var s0, s1, s2;

      peg$silentFails++;
      s0 = peg$currPos;
      if (input.charCodeAt(peg$currPos) === 63) {
        s1 = peg$c358;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c359); }
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parseVARNAME();
        if (s2 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c635(s2);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c634); }
      }

      return s0;
    }

    function peg$parseVAR2() {
      var s0, s1, s2;

      peg$silentFails++;
      s0 = peg$currPos;
      if (input.charCodeAt(peg$currPos) === 36) {
        s1 = peg$c637;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c638); }
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parseVARNAME();
        if (s2 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c635(s2);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c636); }
      }

      return s0;
    }

    function peg$parseLANGTAG() {
      var s0, s1, s2, s3, s4, s5, s6, s7;

      peg$silentFails++;
      s0 = peg$currPos;
      if (input.charCodeAt(peg$currPos) === 64) {
        s1 = peg$c640;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c641); }
      }
      if (s1 !== peg$FAILED) {
        s2 = [];
        if (peg$c642.test(input.charAt(peg$currPos))) {
          s3 = input.charAt(peg$currPos);
          peg$currPos++;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c643); }
        }
        if (s3 !== peg$FAILED) {
          while (s3 !== peg$FAILED) {
            s2.push(s3);
            if (peg$c642.test(input.charAt(peg$currPos))) {
              s3 = input.charAt(peg$currPos);
              peg$currPos++;
            } else {
              s3 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c643); }
            }
          }
        } else {
          s2 = peg$FAILED;
        }
        if (s2 !== peg$FAILED) {
          s3 = [];
          s4 = peg$currPos;
          if (input.charCodeAt(peg$currPos) === 45) {
            s5 = peg$c432;
            peg$currPos++;
          } else {
            s5 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c433); }
          }
          if (s5 !== peg$FAILED) {
            s6 = [];
            if (peg$c644.test(input.charAt(peg$currPos))) {
              s7 = input.charAt(peg$currPos);
              peg$currPos++;
            } else {
              s7 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c645); }
            }
            if (s7 !== peg$FAILED) {
              while (s7 !== peg$FAILED) {
                s6.push(s7);
                if (peg$c644.test(input.charAt(peg$currPos))) {
                  s7 = input.charAt(peg$currPos);
                  peg$currPos++;
                } else {
                  s7 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c645); }
                }
              }
            } else {
              s6 = peg$FAILED;
            }
            if (s6 !== peg$FAILED) {
              s5 = [s5, s6];
              s4 = s5;
            } else {
              peg$currPos = s4;
              s4 = peg$FAILED;
            }
          } else {
            peg$currPos = s4;
            s4 = peg$FAILED;
          }
          while (s4 !== peg$FAILED) {
            s3.push(s4);
            s4 = peg$currPos;
            if (input.charCodeAt(peg$currPos) === 45) {
              s5 = peg$c432;
              peg$currPos++;
            } else {
              s5 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c433); }
            }
            if (s5 !== peg$FAILED) {
              s6 = [];
              if (peg$c644.test(input.charAt(peg$currPos))) {
                s7 = input.charAt(peg$currPos);
                peg$currPos++;
              } else {
                s7 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c645); }
              }
              if (s7 !== peg$FAILED) {
                while (s7 !== peg$FAILED) {
                  s6.push(s7);
                  if (peg$c644.test(input.charAt(peg$currPos))) {
                    s7 = input.charAt(peg$currPos);
                    peg$currPos++;
                  } else {
                    s7 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$c645); }
                  }
                }
              } else {
                s6 = peg$FAILED;
              }
              if (s6 !== peg$FAILED) {
                s5 = [s5, s6];
                s4 = s5;
              } else {
                peg$currPos = s4;
                s4 = peg$FAILED;
              }
            } else {
              peg$currPos = s4;
              s4 = peg$FAILED;
            }
          }
          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c646(s2, s3);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c639); }
      }

      return s0;
    }

    function peg$parseINTEGER() {
      var s0, s1, s2;

      peg$silentFails++;
      s0 = peg$currPos;
      s1 = [];
      if (peg$c648.test(input.charAt(peg$currPos))) {
        s2 = input.charAt(peg$currPos);
        peg$currPos++;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c649); }
      }
      if (s2 !== peg$FAILED) {
        while (s2 !== peg$FAILED) {
          s1.push(s2);
          if (peg$c648.test(input.charAt(peg$currPos))) {
            s2 = input.charAt(peg$currPos);
            peg$currPos++;
          } else {
            s2 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c649); }
          }
        }
      } else {
        s1 = peg$FAILED;
      }
      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$c650(s1);
      }
      s0 = s1;
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c647); }
      }

      return s0;
    }

    function peg$parseDECIMAL() {
      var s0, s1, s2, s3, s4;

      peg$silentFails++;
      s0 = peg$currPos;
      s1 = [];
      if (peg$c648.test(input.charAt(peg$currPos))) {
        s2 = input.charAt(peg$currPos);
        peg$currPos++;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c649); }
      }
      if (s2 !== peg$FAILED) {
        while (s2 !== peg$FAILED) {
          s1.push(s2);
          if (peg$c648.test(input.charAt(peg$currPos))) {
            s2 = input.charAt(peg$currPos);
            peg$currPos++;
          } else {
            s2 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c649); }
          }
        }
      } else {
        s1 = peg$FAILED;
      }
      if (s1 !== peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 46) {
          s2 = peg$c243;
          peg$currPos++;
        } else {
          s2 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c244); }
        }
        if (s2 !== peg$FAILED) {
          s3 = [];
          if (peg$c648.test(input.charAt(peg$currPos))) {
            s4 = input.charAt(peg$currPos);
            peg$currPos++;
          } else {
            s4 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c649); }
          }
          while (s4 !== peg$FAILED) {
            s3.push(s4);
            if (peg$c648.test(input.charAt(peg$currPos))) {
              s4 = input.charAt(peg$currPos);
              peg$currPos++;
            } else {
              s4 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c649); }
            }
          }
          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c652(s1, s2, s3);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        if (input.charCodeAt(peg$currPos) === 46) {
          s1 = peg$c243;
          peg$currPos++;
        } else {
          s1 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c244); }
        }
        if (s1 !== peg$FAILED) {
          s2 = [];
          if (peg$c648.test(input.charAt(peg$currPos))) {
            s3 = input.charAt(peg$currPos);
            peg$currPos++;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c649); }
          }
          if (s3 !== peg$FAILED) {
            while (s3 !== peg$FAILED) {
              s2.push(s3);
              if (peg$c648.test(input.charAt(peg$currPos))) {
                s3 = input.charAt(peg$currPos);
                peg$currPos++;
              } else {
                s3 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c649); }
              }
            }
          } else {
            s2 = peg$FAILED;
          }
          if (s2 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c653(s1, s2);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c651); }
      }

      return s0;
    }

    function peg$parseDOUBLE() {
      var s0, s1, s2, s3, s4;

      peg$silentFails++;
      s0 = peg$currPos;
      s1 = [];
      if (peg$c648.test(input.charAt(peg$currPos))) {
        s2 = input.charAt(peg$currPos);
        peg$currPos++;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c649); }
      }
      if (s2 !== peg$FAILED) {
        while (s2 !== peg$FAILED) {
          s1.push(s2);
          if (peg$c648.test(input.charAt(peg$currPos))) {
            s2 = input.charAt(peg$currPos);
            peg$currPos++;
          } else {
            s2 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c649); }
          }
        }
      } else {
        s1 = peg$FAILED;
      }
      if (s1 !== peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 46) {
          s2 = peg$c243;
          peg$currPos++;
        } else {
          s2 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c244); }
        }
        if (s2 !== peg$FAILED) {
          s3 = [];
          if (peg$c648.test(input.charAt(peg$currPos))) {
            s4 = input.charAt(peg$currPos);
            peg$currPos++;
          } else {
            s4 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c649); }
          }
          while (s4 !== peg$FAILED) {
            s3.push(s4);
            if (peg$c648.test(input.charAt(peg$currPos))) {
              s4 = input.charAt(peg$currPos);
              peg$currPos++;
            } else {
              s4 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c649); }
            }
          }
          if (s3 !== peg$FAILED) {
            s4 = peg$parseEXPONENT();
            if (s4 !== peg$FAILED) {
              peg$savedPos = s0;
              s1 = peg$c655(s1, s2, s3, s4);
              s0 = s1;
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      if (s0 === peg$FAILED) {
        s0 = peg$currPos;
        if (input.charCodeAt(peg$currPos) === 46) {
          s1 = peg$c243;
          peg$currPos++;
        } else {
          s1 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c244); }
        }
        if (s1 !== peg$FAILED) {
          s2 = [];
          if (peg$c648.test(input.charAt(peg$currPos))) {
            s3 = input.charAt(peg$currPos);
            peg$currPos++;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c649); }
          }
          if (s3 !== peg$FAILED) {
            while (s3 !== peg$FAILED) {
              s2.push(s3);
              if (peg$c648.test(input.charAt(peg$currPos))) {
                s3 = input.charAt(peg$currPos);
                peg$currPos++;
              } else {
                s3 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c649); }
              }
            }
          } else {
            s2 = peg$FAILED;
          }
          if (s2 !== peg$FAILED) {
            s3 = peg$parseEXPONENT();
            if (s3 !== peg$FAILED) {
              peg$savedPos = s0;
              s1 = peg$c656(s1, s2, s3);
              s0 = s1;
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
        if (s0 === peg$FAILED) {
          s0 = peg$currPos;
          s1 = [];
          if (peg$c648.test(input.charAt(peg$currPos))) {
            s2 = input.charAt(peg$currPos);
            peg$currPos++;
          } else {
            s2 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c649); }
          }
          if (s2 !== peg$FAILED) {
            while (s2 !== peg$FAILED) {
              s1.push(s2);
              if (peg$c648.test(input.charAt(peg$currPos))) {
                s2 = input.charAt(peg$currPos);
                peg$currPos++;
              } else {
                s2 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c649); }
              }
            }
          } else {
            s1 = peg$FAILED;
          }
          if (s1 !== peg$FAILED) {
            s2 = peg$parseEXPONENT();
            if (s2 !== peg$FAILED) {
              peg$savedPos = s0;
              s1 = peg$c657(s1, s2);
              s0 = s1;
            } else {
              peg$currPos = s0;
              s0 = peg$FAILED;
            }
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        }
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c654); }
      }

      return s0;
    }

    function peg$parseINTEGER_POSITIVE() {
      var s0, s1, s2;

      peg$silentFails++;
      s0 = peg$currPos;
      if (input.charCodeAt(peg$currPos) === 43) {
        s1 = peg$c360;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c361); }
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parseINTEGER();
        if (s2 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c659(s2);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c658); }
      }

      return s0;
    }

    function peg$parseDECIMAL_POSITIVE() {
      var s0, s1, s2;

      peg$silentFails++;
      s0 = peg$currPos;
      if (input.charCodeAt(peg$currPos) === 43) {
        s1 = peg$c360;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c361); }
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parseDECIMAL();
        if (s2 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c661(s2);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c660); }
      }

      return s0;
    }

    function peg$parseDOUBLE_POSITIVE() {
      var s0, s1, s2;

      peg$silentFails++;
      s0 = peg$currPos;
      if (input.charCodeAt(peg$currPos) === 43) {
        s1 = peg$c360;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c361); }
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parseDOUBLE();
        if (s2 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c661(s2);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c662); }
      }

      return s0;
    }

    function peg$parseINTEGER_NEGATIVE() {
      var s0, s1, s2;

      peg$silentFails++;
      s0 = peg$currPos;
      if (input.charCodeAt(peg$currPos) === 45) {
        s1 = peg$c432;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c433); }
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parseINTEGER();
        if (s2 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c664(s2);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c663); }
      }

      return s0;
    }

    function peg$parseDECIMAL_NEGATIVE() {
      var s0, s1, s2;

      peg$silentFails++;
      s0 = peg$currPos;
      if (input.charCodeAt(peg$currPos) === 45) {
        s1 = peg$c432;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c433); }
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parseDECIMAL();
        if (s2 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c664(s2);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c665); }
      }

      return s0;
    }

    function peg$parseDOUBLE_NEGATIVE() {
      var s0, s1, s2;

      peg$silentFails++;
      s0 = peg$currPos;
      if (input.charCodeAt(peg$currPos) === 45) {
        s1 = peg$c432;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c433); }
      }
      if (s1 !== peg$FAILED) {
        s2 = peg$parseDOUBLE();
        if (s2 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c664(s2);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c666); }
      }

      return s0;
    }

    function peg$parseEXPONENT() {
      var s0, s1, s2, s3, s4;

      peg$silentFails++;
      s0 = peg$currPos;
      if (peg$c668.test(input.charAt(peg$currPos))) {
        s1 = input.charAt(peg$currPos);
        peg$currPos++;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c669); }
      }
      if (s1 !== peg$FAILED) {
        if (peg$c670.test(input.charAt(peg$currPos))) {
          s2 = input.charAt(peg$currPos);
          peg$currPos++;
        } else {
          s2 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c671); }
        }
        if (s2 === peg$FAILED) {
          s2 = null;
        }
        if (s2 !== peg$FAILED) {
          s3 = [];
          if (peg$c648.test(input.charAt(peg$currPos))) {
            s4 = input.charAt(peg$currPos);
            peg$currPos++;
          } else {
            s4 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c649); }
          }
          if (s4 !== peg$FAILED) {
            while (s4 !== peg$FAILED) {
              s3.push(s4);
              if (peg$c648.test(input.charAt(peg$currPos))) {
                s4 = input.charAt(peg$currPos);
                peg$currPos++;
              } else {
                s4 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c649); }
              }
            }
          } else {
            s3 = peg$FAILED;
          }
          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c672(s1, s2, s3);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c667); }
      }

      return s0;
    }

    function peg$parseSTRING_LITERAL1() {
      var s0, s1, s2, s3;

      peg$silentFails++;
      s0 = peg$currPos;
      if (input.charCodeAt(peg$currPos) === 39) {
        s1 = peg$c674;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c675); }
      }
      if (s1 !== peg$FAILED) {
        s2 = [];
        if (peg$c676.test(input.charAt(peg$currPos))) {
          s3 = input.charAt(peg$currPos);
          peg$currPos++;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c677); }
        }
        if (s3 === peg$FAILED) {
          s3 = peg$parseECHAR();
        }
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          if (peg$c676.test(input.charAt(peg$currPos))) {
            s3 = input.charAt(peg$currPos);
            peg$currPos++;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c677); }
          }
          if (s3 === peg$FAILED) {
            s3 = peg$parseECHAR();
          }
        }
        if (s2 !== peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 39) {
            s3 = peg$c674;
            peg$currPos++;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c675); }
          }
          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c678(s2);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c673); }
      }

      return s0;
    }

    function peg$parseSTRING_LITERAL2() {
      var s0, s1, s2, s3;

      peg$silentFails++;
      s0 = peg$currPos;
      if (input.charCodeAt(peg$currPos) === 34) {
        s1 = peg$c680;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c681); }
      }
      if (s1 !== peg$FAILED) {
        s2 = [];
        if (peg$c682.test(input.charAt(peg$currPos))) {
          s3 = input.charAt(peg$currPos);
          peg$currPos++;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c683); }
        }
        if (s3 === peg$FAILED) {
          s3 = peg$parseECHAR();
        }
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          if (peg$c682.test(input.charAt(peg$currPos))) {
            s3 = input.charAt(peg$currPos);
            peg$currPos++;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c683); }
          }
          if (s3 === peg$FAILED) {
            s3 = peg$parseECHAR();
          }
        }
        if (s2 !== peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 34) {
            s3 = peg$c680;
            peg$currPos++;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c681); }
          }
          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c678(s2);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c679); }
      }

      return s0;
    }

    function peg$parseSTRING_LITERAL_LONG1() {
      var s0, s1, s2, s3;

      peg$silentFails++;
      s0 = peg$currPos;
      if (input.substr(peg$currPos, 3) === peg$c685) {
        s1 = peg$c685;
        peg$currPos += 3;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c686); }
      }
      if (s1 !== peg$FAILED) {
        s2 = [];
        if (peg$c687.test(input.charAt(peg$currPos))) {
          s3 = input.charAt(peg$currPos);
          peg$currPos++;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c688); }
        }
        if (s3 === peg$FAILED) {
          s3 = peg$parseECHAR();
        }
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          if (peg$c687.test(input.charAt(peg$currPos))) {
            s3 = input.charAt(peg$currPos);
            peg$currPos++;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c688); }
          }
          if (s3 === peg$FAILED) {
            s3 = peg$parseECHAR();
          }
        }
        if (s2 !== peg$FAILED) {
          if (input.substr(peg$currPos, 3) === peg$c685) {
            s3 = peg$c685;
            peg$currPos += 3;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c686); }
          }
          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c678(s2);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c684); }
      }

      return s0;
    }

    function peg$parseSTRING_LITERAL_LONG2() {
      var s0, s1, s2, s3;

      peg$silentFails++;
      s0 = peg$currPos;
      if (input.substr(peg$currPos, 3) === peg$c690) {
        s1 = peg$c690;
        peg$currPos += 3;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c691); }
      }
      if (s1 !== peg$FAILED) {
        s2 = [];
        if (peg$c692.test(input.charAt(peg$currPos))) {
          s3 = input.charAt(peg$currPos);
          peg$currPos++;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c693); }
        }
        if (s3 === peg$FAILED) {
          s3 = peg$parseECHAR();
        }
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          if (peg$c692.test(input.charAt(peg$currPos))) {
            s3 = input.charAt(peg$currPos);
            peg$currPos++;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c693); }
          }
          if (s3 === peg$FAILED) {
            s3 = peg$parseECHAR();
          }
        }
        if (s2 !== peg$FAILED) {
          if (input.substr(peg$currPos, 3) === peg$c690) {
            s3 = peg$c690;
            peg$currPos += 3;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c691); }
          }
          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c678(s2);
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c689); }
      }

      return s0;
    }

    function peg$parseECHAR() {
      var s0, s1, s2;

      peg$silentFails++;
      s0 = peg$currPos;
      if (input.charCodeAt(peg$currPos) === 92) {
        s1 = peg$c695;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c696); }
      }
      if (s1 !== peg$FAILED) {
        if (peg$c697.test(input.charAt(peg$currPos))) {
          s2 = input.charAt(peg$currPos);
          peg$currPos++;
        } else {
          s2 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c698); }
        }
        if (s2 !== peg$FAILED) {
          s1 = [s1, s2];
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c694); }
      }

      return s0;
    }

    function peg$parseNIL() {
      var s0, s1, s2, s3;

      peg$silentFails++;
      s0 = peg$currPos;
      if (input.charCodeAt(peg$currPos) === 40) {
        s1 = peg$c34;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c35); }
      }
      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$parseWS();
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parseWS();
        }
        if (s2 !== peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 41) {
            s3 = peg$c40;
            peg$currPos++;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c41); }
          }
          if (s3 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c700();
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c699); }
      }

      return s0;
    }

    function peg$parseWS() {
      var s0, s1;

      peg$silentFails++;
      if (peg$c702.test(input.charAt(peg$currPos))) {
        s0 = input.charAt(peg$currPos);
        peg$currPos++;
      } else {
        s0 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c703); }
      }
      if (s0 === peg$FAILED) {
        if (peg$c704.test(input.charAt(peg$currPos))) {
          s0 = input.charAt(peg$currPos);
          peg$currPos++;
        } else {
          s0 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c705); }
        }
        if (s0 === peg$FAILED) {
          if (peg$c706.test(input.charAt(peg$currPos))) {
            s0 = input.charAt(peg$currPos);
            peg$currPos++;
          } else {
            s0 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c707); }
          }
          if (s0 === peg$FAILED) {
            if (peg$c708.test(input.charAt(peg$currPos))) {
              s0 = input.charAt(peg$currPos);
              peg$currPos++;
            } else {
              s0 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c709); }
            }
            if (s0 === peg$FAILED) {
              s0 = peg$parseCOMMENT();
            }
          }
        }
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c701); }
      }

      return s0;
    }

    function peg$parseCOMMENT() {
      var s0, s1, s2, s3;

      peg$silentFails++;
      s0 = peg$currPos;
      if (input.charCodeAt(peg$currPos) === 35) {
        s1 = peg$c711;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c712); }
      }
      if (s1 !== peg$FAILED) {
        s2 = [];
        if (peg$c713.test(input.charAt(peg$currPos))) {
          s3 = input.charAt(peg$currPos);
          peg$currPos++;
        } else {
          s3 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c714); }
        }
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          if (peg$c713.test(input.charAt(peg$currPos))) {
            s3 = input.charAt(peg$currPos);
            peg$currPos++;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c714); }
          }
        }
        if (s2 !== peg$FAILED) {
          s1 = [s1, s2];
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c710); }
      }

      return s0;
    }

    function peg$parseANON() {
      var s0, s1, s2, s3;

      peg$silentFails++;
      s0 = peg$currPos;
      if (input.charCodeAt(peg$currPos) === 91) {
        s1 = peg$c372;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c373); }
      }
      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$parseWS();
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parseWS();
        }
        if (s2 !== peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 93) {
            s3 = peg$c374;
            peg$currPos++;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c375); }
          }
          if (s3 !== peg$FAILED) {
            s1 = [s1, s2, s3];
            s0 = s1;
          } else {
            peg$currPos = s0;
            s0 = peg$FAILED;
          }
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c715); }
      }

      return s0;
    }

    function peg$parsePN_CHARS_BASE() {
      var s0, s1;

      peg$silentFails++;
      if (peg$c717.test(input.charAt(peg$currPos))) {
        s0 = input.charAt(peg$currPos);
        peg$currPos++;
      } else {
        s0 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c718); }
      }
      if (s0 === peg$FAILED) {
        if (peg$c719.test(input.charAt(peg$currPos))) {
          s0 = input.charAt(peg$currPos);
          peg$currPos++;
        } else {
          s0 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c720); }
        }
        if (s0 === peg$FAILED) {
          if (peg$c721.test(input.charAt(peg$currPos))) {
            s0 = input.charAt(peg$currPos);
            peg$currPos++;
          } else {
            s0 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c722); }
          }
          if (s0 === peg$FAILED) {
            if (peg$c723.test(input.charAt(peg$currPos))) {
              s0 = input.charAt(peg$currPos);
              peg$currPos++;
            } else {
              s0 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c724); }
            }
            if (s0 === peg$FAILED) {
              if (peg$c725.test(input.charAt(peg$currPos))) {
                s0 = input.charAt(peg$currPos);
                peg$currPos++;
              } else {
                s0 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c726); }
              }
              if (s0 === peg$FAILED) {
                if (peg$c727.test(input.charAt(peg$currPos))) {
                  s0 = input.charAt(peg$currPos);
                  peg$currPos++;
                } else {
                  s0 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c728); }
                }
                if (s0 === peg$FAILED) {
                  if (peg$c729.test(input.charAt(peg$currPos))) {
                    s0 = input.charAt(peg$currPos);
                    peg$currPos++;
                  } else {
                    s0 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$c730); }
                  }
                  if (s0 === peg$FAILED) {
                    if (peg$c731.test(input.charAt(peg$currPos))) {
                      s0 = input.charAt(peg$currPos);
                      peg$currPos++;
                    } else {
                      s0 = peg$FAILED;
                      if (peg$silentFails === 0) { peg$fail(peg$c732); }
                    }
                    if (s0 === peg$FAILED) {
                      if (peg$c733.test(input.charAt(peg$currPos))) {
                        s0 = input.charAt(peg$currPos);
                        peg$currPos++;
                      } else {
                        s0 = peg$FAILED;
                        if (peg$silentFails === 0) { peg$fail(peg$c734); }
                      }
                      if (s0 === peg$FAILED) {
                        if (peg$c735.test(input.charAt(peg$currPos))) {
                          s0 = input.charAt(peg$currPos);
                          peg$currPos++;
                        } else {
                          s0 = peg$FAILED;
                          if (peg$silentFails === 0) { peg$fail(peg$c736); }
                        }
                        if (s0 === peg$FAILED) {
                          if (peg$c737.test(input.charAt(peg$currPos))) {
                            s0 = input.charAt(peg$currPos);
                            peg$currPos++;
                          } else {
                            s0 = peg$FAILED;
                            if (peg$silentFails === 0) { peg$fail(peg$c738); }
                          }
                          if (s0 === peg$FAILED) {
                            if (peg$c739.test(input.charAt(peg$currPos))) {
                              s0 = input.charAt(peg$currPos);
                              peg$currPos++;
                            } else {
                              s0 = peg$FAILED;
                              if (peg$silentFails === 0) { peg$fail(peg$c740); }
                            }
                            if (s0 === peg$FAILED) {
                              if (peg$c741.test(input.charAt(peg$currPos))) {
                                s0 = input.charAt(peg$currPos);
                                peg$currPos++;
                              } else {
                                s0 = peg$FAILED;
                                if (peg$silentFails === 0) { peg$fail(peg$c742); }
                              }
                              if (s0 === peg$FAILED) {
                                if (peg$c743.test(input.charAt(peg$currPos))) {
                                  s0 = input.charAt(peg$currPos);
                                  peg$currPos++;
                                } else {
                                  s0 = peg$FAILED;
                                  if (peg$silentFails === 0) { peg$fail(peg$c744); }
                                }
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c716); }
      }

      return s0;
    }

    function peg$parsePN_CHARS_U() {
      var s0, s1;

      peg$silentFails++;
      s0 = peg$parsePN_CHARS_BASE();
      if (s0 === peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 95) {
          s0 = peg$c746;
          peg$currPos++;
        } else {
          s0 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c747); }
        }
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c745); }
      }

      return s0;
    }

    function peg$parseVARNAME() {
      var s0, s1, s2, s3;

      peg$silentFails++;
      s0 = peg$currPos;
      s1 = peg$parsePN_CHARS_U();
      if (s1 === peg$FAILED) {
        if (peg$c648.test(input.charAt(peg$currPos))) {
          s1 = input.charAt(peg$currPos);
          peg$currPos++;
        } else {
          s1 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c649); }
        }
      }
      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$parsePN_CHARS_U();
        if (s3 === peg$FAILED) {
          if (peg$c648.test(input.charAt(peg$currPos))) {
            s3 = input.charAt(peg$currPos);
            peg$currPos++;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c649); }
          }
          if (s3 === peg$FAILED) {
            if (peg$c749.test(input.charAt(peg$currPos))) {
              s3 = input.charAt(peg$currPos);
              peg$currPos++;
            } else {
              s3 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c750); }
            }
            if (s3 === peg$FAILED) {
              if (peg$c751.test(input.charAt(peg$currPos))) {
                s3 = input.charAt(peg$currPos);
                peg$currPos++;
              } else {
                s3 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c752); }
              }
              if (s3 === peg$FAILED) {
                if (peg$c753.test(input.charAt(peg$currPos))) {
                  s3 = input.charAt(peg$currPos);
                  peg$currPos++;
                } else {
                  s3 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c754); }
                }
              }
            }
          }
        }
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parsePN_CHARS_U();
          if (s3 === peg$FAILED) {
            if (peg$c648.test(input.charAt(peg$currPos))) {
              s3 = input.charAt(peg$currPos);
              peg$currPos++;
            } else {
              s3 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c649); }
            }
            if (s3 === peg$FAILED) {
              if (peg$c749.test(input.charAt(peg$currPos))) {
                s3 = input.charAt(peg$currPos);
                peg$currPos++;
              } else {
                s3 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c750); }
              }
              if (s3 === peg$FAILED) {
                if (peg$c751.test(input.charAt(peg$currPos))) {
                  s3 = input.charAt(peg$currPos);
                  peg$currPos++;
                } else {
                  s3 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c752); }
                }
                if (s3 === peg$FAILED) {
                  if (peg$c753.test(input.charAt(peg$currPos))) {
                    s3 = input.charAt(peg$currPos);
                    peg$currPos++;
                  } else {
                    s3 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$c754); }
                  }
                }
              }
            }
          }
        }
        if (s2 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c755(s1, s2);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c748); }
      }

      return s0;
    }

    function peg$parsePN_CHARS() {
      var s0, s1;

      peg$silentFails++;
      s0 = peg$parsePN_CHARS_U();
      if (s0 === peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 45) {
          s0 = peg$c432;
          peg$currPos++;
        } else {
          s0 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c433); }
        }
        if (s0 === peg$FAILED) {
          if (peg$c648.test(input.charAt(peg$currPos))) {
            s0 = input.charAt(peg$currPos);
            peg$currPos++;
          } else {
            s0 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c649); }
          }
          if (s0 === peg$FAILED) {
            if (peg$c749.test(input.charAt(peg$currPos))) {
              s0 = input.charAt(peg$currPos);
              peg$currPos++;
            } else {
              s0 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c750); }
            }
            if (s0 === peg$FAILED) {
              if (peg$c751.test(input.charAt(peg$currPos))) {
                s0 = input.charAt(peg$currPos);
                peg$currPos++;
              } else {
                s0 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c752); }
              }
              if (s0 === peg$FAILED) {
                if (peg$c753.test(input.charAt(peg$currPos))) {
                  s0 = input.charAt(peg$currPos);
                  peg$currPos++;
                } else {
                  s0 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c754); }
                }
              }
            }
          }
        }
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c756); }
      }

      return s0;
    }

    function peg$parsePN_PREFIX() {
      var s0, s1, s2, s3;

      peg$silentFails++;
      s0 = peg$currPos;
      s1 = peg$parsePN_CHARS_BASE();
      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$parsePN_CHARS();
        if (s3 === peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 46) {
            s3 = peg$c243;
            peg$currPos++;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c244); }
          }
        }
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parsePN_CHARS();
          if (s3 === peg$FAILED) {
            if (input.charCodeAt(peg$currPos) === 46) {
              s3 = peg$c243;
              peg$currPos++;
            } else {
              s3 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c244); }
            }
          }
        }
        if (s2 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c758(s1, s2);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c757); }
      }

      return s0;
    }

    function peg$parsePN_LOCAL() {
      var s0, s1, s2, s3;

      peg$silentFails++;
      s0 = peg$currPos;
      s1 = peg$parsePN_CHARS_U();
      if (s1 === peg$FAILED) {
        if (peg$c648.test(input.charAt(peg$currPos))) {
          s1 = input.charAt(peg$currPos);
          peg$currPos++;
        } else {
          s1 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c649); }
        }
        if (s1 === peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 58) {
            s1 = peg$c626;
            peg$currPos++;
          } else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c627); }
          }
          if (s1 === peg$FAILED) {
            s1 = peg$parsePLX();
          }
        }
      }
      if (s1 !== peg$FAILED) {
        s2 = [];
        s3 = peg$parsePN_CHARS();
        if (s3 === peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 46) {
            s3 = peg$c243;
            peg$currPos++;
          } else {
            s3 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c244); }
          }
          if (s3 === peg$FAILED) {
            if (input.charCodeAt(peg$currPos) === 58) {
              s3 = peg$c626;
              peg$currPos++;
            } else {
              s3 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c627); }
            }
            if (s3 === peg$FAILED) {
              s3 = peg$parsePLX();
            }
          }
        }
        while (s3 !== peg$FAILED) {
          s2.push(s3);
          s3 = peg$parsePN_CHARS();
          if (s3 === peg$FAILED) {
            if (input.charCodeAt(peg$currPos) === 46) {
              s3 = peg$c243;
              peg$currPos++;
            } else {
              s3 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c244); }
            }
            if (s3 === peg$FAILED) {
              if (input.charCodeAt(peg$currPos) === 58) {
                s3 = peg$c626;
                peg$currPos++;
              } else {
                s3 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c627); }
              }
              if (s3 === peg$FAILED) {
                s3 = peg$parsePLX();
              }
            }
          }
        }
        if (s2 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c760(s1, s2);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c759); }
      }

      return s0;
    }

    function peg$parsePLX() {
      var s0, s1;

      peg$silentFails++;
      s0 = peg$parsePERCENT();
      if (s0 === peg$FAILED) {
        s0 = peg$parsePN_LOCAL_ESC();
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c761); }
      }

      return s0;
    }

    function peg$parsePERCENT() {
      var s0, s1, s2, s3, s4;

      peg$silentFails++;
      s0 = peg$currPos;
      s1 = peg$currPos;
      if (input.charCodeAt(peg$currPos) === 37) {
        s2 = peg$c763;
        peg$currPos++;
      } else {
        s2 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c764); }
      }
      if (s2 !== peg$FAILED) {
        s3 = peg$parseHEX();
        if (s3 !== peg$FAILED) {
          s4 = peg$parseHEX();
          if (s4 !== peg$FAILED) {
            s2 = [s2, s3, s4];
            s1 = s2;
          } else {
            peg$currPos = s1;
            s1 = peg$FAILED;
          }
        } else {
          peg$currPos = s1;
          s1 = peg$FAILED;
        }
      } else {
        peg$currPos = s1;
        s1 = peg$FAILED;
      }
      if (s1 !== peg$FAILED) {
        peg$savedPos = s0;
        s1 = peg$c765(s1);
      }
      s0 = s1;
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c762); }
      }

      return s0;
    }

    function peg$parseHEX() {
      var s0, s1;

      peg$silentFails++;
      if (peg$c648.test(input.charAt(peg$currPos))) {
        s0 = input.charAt(peg$currPos);
        peg$currPos++;
      } else {
        s0 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c649); }
      }
      if (s0 === peg$FAILED) {
        if (peg$c767.test(input.charAt(peg$currPos))) {
          s0 = input.charAt(peg$currPos);
          peg$currPos++;
        } else {
          s0 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c768); }
        }
        if (s0 === peg$FAILED) {
          if (peg$c769.test(input.charAt(peg$currPos))) {
            s0 = input.charAt(peg$currPos);
            peg$currPos++;
          } else {
            s0 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c770); }
          }
        }
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c766); }
      }

      return s0;
    }

    function peg$parsePN_LOCAL_ESC() {
      var s0, s1, s2;

      peg$silentFails++;
      s0 = peg$currPos;
      if (input.charCodeAt(peg$currPos) === 92) {
        s1 = peg$c695;
        peg$currPos++;
      } else {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c696); }
      }
      if (s1 !== peg$FAILED) {
        if (input.charCodeAt(peg$currPos) === 95) {
          s2 = peg$c746;
          peg$currPos++;
        } else {
          s2 = peg$FAILED;
          if (peg$silentFails === 0) { peg$fail(peg$c747); }
        }
        if (s2 === peg$FAILED) {
          if (input.charCodeAt(peg$currPos) === 126) {
            s2 = peg$c772;
            peg$currPos++;
          } else {
            s2 = peg$FAILED;
            if (peg$silentFails === 0) { peg$fail(peg$c773); }
          }
          if (s2 === peg$FAILED) {
            if (input.charCodeAt(peg$currPos) === 46) {
              s2 = peg$c243;
              peg$currPos++;
            } else {
              s2 = peg$FAILED;
              if (peg$silentFails === 0) { peg$fail(peg$c244); }
            }
            if (s2 === peg$FAILED) {
              if (input.charCodeAt(peg$currPos) === 45) {
                s2 = peg$c432;
                peg$currPos++;
              } else {
                s2 = peg$FAILED;
                if (peg$silentFails === 0) { peg$fail(peg$c433); }
              }
              if (s2 === peg$FAILED) {
                if (input.charCodeAt(peg$currPos) === 33) {
                  s2 = peg$c363;
                  peg$currPos++;
                } else {
                  s2 = peg$FAILED;
                  if (peg$silentFails === 0) { peg$fail(peg$c364); }
                }
                if (s2 === peg$FAILED) {
                  if (input.charCodeAt(peg$currPos) === 36) {
                    s2 = peg$c637;
                    peg$currPos++;
                  } else {
                    s2 = peg$FAILED;
                    if (peg$silentFails === 0) { peg$fail(peg$c638); }
                  }
                  if (s2 === peg$FAILED) {
                    if (input.charCodeAt(peg$currPos) === 38) {
                      s2 = peg$c774;
                      peg$currPos++;
                    } else {
                      s2 = peg$FAILED;
                      if (peg$silentFails === 0) { peg$fail(peg$c775); }
                    }
                    if (s2 === peg$FAILED) {
                      if (input.charCodeAt(peg$currPos) === 39) {
                        s2 = peg$c674;
                        peg$currPos++;
                      } else {
                        s2 = peg$FAILED;
                        if (peg$silentFails === 0) { peg$fail(peg$c675); }
                      }
                      if (s2 === peg$FAILED) {
                        if (input.charCodeAt(peg$currPos) === 40) {
                          s2 = peg$c34;
                          peg$currPos++;
                        } else {
                          s2 = peg$FAILED;
                          if (peg$silentFails === 0) { peg$fail(peg$c35); }
                        }
                        if (s2 === peg$FAILED) {
                          if (input.charCodeAt(peg$currPos) === 41) {
                            s2 = peg$c40;
                            peg$currPos++;
                          } else {
                            s2 = peg$FAILED;
                            if (peg$silentFails === 0) { peg$fail(peg$c41); }
                          }
                          if (s2 === peg$FAILED) {
                            if (input.charCodeAt(peg$currPos) === 42) {
                              s2 = peg$c42;
                              peg$currPos++;
                            } else {
                              s2 = peg$FAILED;
                              if (peg$silentFails === 0) { peg$fail(peg$c43); }
                            }
                            if (s2 === peg$FAILED) {
                              if (input.charCodeAt(peg$currPos) === 43) {
                                s2 = peg$c360;
                                peg$currPos++;
                              } else {
                                s2 = peg$FAILED;
                                if (peg$silentFails === 0) { peg$fail(peg$c361); }
                              }
                              if (s2 === peg$FAILED) {
                                if (input.charCodeAt(peg$currPos) === 44) {
                                  s2 = peg$c306;
                                  peg$currPos++;
                                } else {
                                  s2 = peg$FAILED;
                                  if (peg$silentFails === 0) { peg$fail(peg$c307); }
                                }
                                if (s2 === peg$FAILED) {
                                  if (input.charCodeAt(peg$currPos) === 59) {
                                    s2 = peg$c152;
                                    peg$currPos++;
                                  } else {
                                    s2 = peg$FAILED;
                                    if (peg$silentFails === 0) { peg$fail(peg$c153); }
                                  }
                                  if (s2 === peg$FAILED) {
                                    if (input.charCodeAt(peg$currPos) === 58) {
                                      s2 = peg$c626;
                                      peg$currPos++;
                                    } else {
                                      s2 = peg$FAILED;
                                      if (peg$silentFails === 0) { peg$fail(peg$c627); }
                                    }
                                    if (s2 === peg$FAILED) {
                                      if (input.charCodeAt(peg$currPos) === 61) {
                                        s2 = peg$c401;
                                        peg$currPos++;
                                      } else {
                                        s2 = peg$FAILED;
                                        if (peg$silentFails === 0) { peg$fail(peg$c402); }
                                      }
                                      if (s2 === peg$FAILED) {
                                        if (input.charCodeAt(peg$currPos) === 47) {
                                          s2 = peg$c348;
                                          peg$currPos++;
                                        } else {
                                          s2 = peg$FAILED;
                                          if (peg$silentFails === 0) { peg$fail(peg$c349); }
                                        }
                                        if (s2 === peg$FAILED) {
                                          if (input.charCodeAt(peg$currPos) === 63) {
                                            s2 = peg$c358;
                                            peg$currPos++;
                                          } else {
                                            s2 = peg$FAILED;
                                            if (peg$silentFails === 0) { peg$fail(peg$c359); }
                                          }
                                          if (s2 === peg$FAILED) {
                                            if (input.charCodeAt(peg$currPos) === 35) {
                                              s2 = peg$c711;
                                              peg$currPos++;
                                            } else {
                                              s2 = peg$FAILED;
                                              if (peg$silentFails === 0) { peg$fail(peg$c712); }
                                            }
                                            if (s2 === peg$FAILED) {
                                              if (input.charCodeAt(peg$currPos) === 64) {
                                                s2 = peg$c640;
                                                peg$currPos++;
                                              } else {
                                                s2 = peg$FAILED;
                                                if (peg$silentFails === 0) { peg$fail(peg$c641); }
                                              }
                                              if (s2 === peg$FAILED) {
                                                if (input.charCodeAt(peg$currPos) === 37) {
                                                  s2 = peg$c763;
                                                  peg$currPos++;
                                                } else {
                                                  s2 = peg$FAILED;
                                                  if (peg$silentFails === 0) { peg$fail(peg$c764); }
                                                }
                                              }
                                            }
                                          }
                                        }
                                      }
                                    }
                                  }
                                }
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
        if (s2 !== peg$FAILED) {
          peg$savedPos = s0;
          s1 = peg$c776(s2);
          s0 = s1;
        } else {
          peg$currPos = s0;
          s0 = peg$FAILED;
        }
      } else {
        peg$currPos = s0;
        s0 = peg$FAILED;
      }
      peg$silentFails--;
      if (s0 === peg$FAILED) {
        s1 = peg$FAILED;
        if (peg$silentFails === 0) { peg$fail(peg$c771); }
      }

      return s0;
    }


        var flattenString = function(arrs) {
    	var acum ="";
    	for(var i=0; i< arrs.length; i++) {
    	  if(typeof(arrs[i])==='string') {
    	    acum = acum + arrs[i];
    	  } else {
    	    acum = acum + arrs[i].join('');
    	  }
    	}

    	return acum;
        }


        var GlobalBlankNodeCounter = 0;

        var prefixes = {};

        var registerPrefix = function(prefix, uri) {
    	prefixes[prefix] = uri;
        }

        var registerDefaultPrefix = function(uri) {
    	prefixes[null] = uri;
        }

        var arrayToString = function(array) {
    	var tmp = "";
    	if(array == null)
    	  return null;

    	for(var i=0; i<array.length; i++) {
    	    tmp = tmp + array[i];
    	}

    	return tmp.toUpperCase();
        }


    peg$result = peg$startRuleFunction();

    if (peg$result !== peg$FAILED && peg$currPos === input.length) {
      return peg$result;
    } else {
      if (peg$result !== peg$FAILED && peg$currPos < input.length) {
        peg$fail(peg$endExpectation());
      }

      throw peg$buildStructuredError(
        peg$maxFailExpected,
        peg$maxFailPos < input.length ? input.charAt(peg$maxFailPos) : null,
        peg$maxFailPos < input.length
          ? peg$computeLocation(peg$maxFailPos, peg$maxFailPos + 1)
          : peg$computeLocation(peg$maxFailPos, peg$maxFailPos)
      );
    }
  }

  return {
    SyntaxError: peg$SyntaxError,
    parse:       peg$parse
  };
})()