"use strict";
/**
  * @reach/dialog v0.18.0-pre.5
  *
  * Copyright (c) 2018-2022, React Training LLC
  *
  * This source code is licensed under the MIT license found in the
  * LICENSE.md file in the root directory of this source tree.
  *
  * @license MIT
  */

var __create = Object.create;
var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target, mod));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/reach-dialog.tsx
var reach_dialog_exports = {};
__export(reach_dialog_exports, {
  Dialog: () => Dialog,
  DialogContent: () => DialogContent,
  DialogInner: () => DialogInner,
  DialogOverlay: () => DialogOverlay,
  unstable_DialogWrapper: () => DialogWrapper
});
module.exports = __toCommonJS(reach_dialog_exports);
var React = __toESM(require("react"));
var import_portal = require("@reach/portal");
var import_utils = require("@reach/utils");
var import_react_focus_lock = __toESM(require("react-focus-lock"));
var import_react_remove_scroll = require("react-remove-scroll");
var [DialogContextProvider, useDialogContext] = (0, import_utils.createContext)("DialogContext", {
  isOpen: false
});
function DialogWrapper(_a) {
  var _b = _a, {
    isOpen = true,
    children
  } = _b, props = __objRest(_b, [
    "isOpen",
    "children"
  ]);
  React.useEffect(() => {
    if (isOpen) {
      window.__REACH_DISABLE_TOOLTIPS = true;
    } else {
      window.requestAnimationFrame(() => {
        window.__REACH_DISABLE_TOOLTIPS = false;
      });
    }
  }, [isOpen]);
  return /* @__PURE__ */ React.createElement(import_portal.Portal, __spreadValues({
    "data-reach-dialog-wrapper": "",
    "data-state": isOpen ? "open" /* Open */ : "closed" /* Closed */
  }, props), /* @__PURE__ */ React.createElement(DialogContextProvider, {
    isOpen
  }, children));
}
DialogWrapper.displayName = "unstable_DialogWrapper";
var DialogInner = React.forwardRef(function DialogInner2(_a, forwardedRef) {
  var _b = _a, {
    allowPinchZoom,
    as: Comp = "div",
    dangerouslyBypassFocusLock,
    dangerouslyBypassScrollLock,
    initialFocusRef,
    onClick,
    onDismiss = import_utils.noop,
    onKeyDown,
    onMouseDown,
    unstable_lockFocusAcrossFrames
  } = _b, props = __objRest(_b, [
    "allowPinchZoom",
    "as",
    "dangerouslyBypassFocusLock",
    "dangerouslyBypassScrollLock",
    "initialFocusRef",
    "onClick",
    "onDismiss",
    "onKeyDown",
    "onMouseDown",
    "unstable_lockFocusAcrossFrames"
  ]);
  let { isOpen } = useDialogContext("DialogInner");
  let lockFocusAcrossFramesIsDefined = unstable_lockFocusAcrossFrames !== void 0;
  if (true) {
    React.useEffect(() => {
      if (lockFocusAcrossFramesIsDefined) {
        console.warn(`The unstable_lockFocusAcrossFrames in @reach/dialog is deprecated. It will be removed in the next minor release.`);
      }
    }, [lockFocusAcrossFramesIsDefined]);
  }
  const mouseDownTarget = React.useRef(null);
  const overlayNode = React.useRef(null);
  const ref = (0, import_utils.useComposedRefs)(overlayNode, forwardedRef);
  const activateFocusLock = React.useCallback(() => {
    if (initialFocusRef && initialFocusRef.current) {
      initialFocusRef.current.focus();
    }
  }, [initialFocusRef]);
  function handleClick(event) {
    if (mouseDownTarget.current === event.target) {
      event.stopPropagation();
      onDismiss(event);
    }
  }
  function handleKeyDown(event) {
    if (event.key === "Escape") {
      event.stopPropagation();
      onDismiss(event);
    }
  }
  function handleMouseDown(event) {
    mouseDownTarget.current = event.target;
  }
  React.useEffect(() => {
    return overlayNode.current ? createAriaHider(overlayNode.current) : void 0;
  }, []);
  return /* @__PURE__ */ React.createElement(import_react_focus_lock.default, {
    autoFocus: true,
    returnFocus: true,
    onActivation: activateFocusLock,
    disabled: dangerouslyBypassFocusLock != null ? dangerouslyBypassFocusLock : !isOpen,
    crossFrame: unstable_lockFocusAcrossFrames != null ? unstable_lockFocusAcrossFrames : true
  }, /* @__PURE__ */ React.createElement(import_react_remove_scroll.RemoveScroll, {
    allowPinchZoom,
    enabled: dangerouslyBypassScrollLock != null ? !dangerouslyBypassScrollLock : isOpen
  }, /* @__PURE__ */ React.createElement(Comp, __spreadProps(__spreadValues({}, props), {
    ref,
    "data-reach-dialog-inner": "",
    "data-state": isOpen ? "open" /* Open */ : "closed" /* Closed */,
    onClick: (0, import_utils.composeEventHandlers)(onClick, handleClick),
    onKeyDown: (0, import_utils.composeEventHandlers)(onKeyDown, handleKeyDown),
    onMouseDown: (0, import_utils.composeEventHandlers)(onMouseDown, handleMouseDown)
  }))));
});
DialogInner.displayName = "DialogInner";
var DialogOverlay = React.forwardRef(function DialogOverlay2(_a, forwardedRef) {
  var _b = _a, { as: Comp = "div", isOpen = true } = _b, props = __objRest(_b, ["as", "isOpen"]);
  return isOpen ? /* @__PURE__ */ React.createElement(DialogWrapper, {
    isOpen
  }, /* @__PURE__ */ React.createElement(DialogInner, __spreadValues({
    "data-reach-dialog-overlay": "",
    ref: forwardedRef,
    as: Comp
  }, props))) : null;
});
DialogOverlay.displayName = "DialogOverlay";
var DialogContent = React.forwardRef(function DialogContent2(_a, forwardedRef) {
  var _b = _a, { as: Comp = "div", onClick, onKeyDown } = _b, props = __objRest(_b, ["as", "onClick", "onKeyDown"]);
  let { isOpen } = useDialogContext("DialogContent");
  return /* @__PURE__ */ React.createElement(Comp, __spreadProps(__spreadValues({
    "aria-modal": "true",
    role: "dialog",
    tabIndex: -1
  }, props), {
    ref: forwardedRef,
    "data-reach-dialog-content": "",
    "data-state": isOpen ? "open" /* Open */ : "closed" /* Closed */,
    onClick: (0, import_utils.composeEventHandlers)(onClick, (event) => {
      event.stopPropagation();
    })
  }));
});
DialogContent.displayName = "DialogContent";
var Dialog = React.forwardRef(function Dialog2(_a, forwardedRef) {
  var _b = _a, {
    allowPinchZoom = false,
    initialFocusRef,
    isOpen,
    onDismiss = import_utils.noop
  } = _b, props = __objRest(_b, [
    "allowPinchZoom",
    "initialFocusRef",
    "isOpen",
    "onDismiss"
  ]);
  return /* @__PURE__ */ React.createElement(DialogOverlay, {
    allowPinchZoom,
    initialFocusRef,
    isOpen,
    onDismiss
  }, /* @__PURE__ */ React.createElement(DialogContent, __spreadValues({
    ref: forwardedRef
  }, props)));
});
Dialog.displayName = "Dialog";
function createAriaHider(dialogNode) {
  let originalValues = [];
  let rootNodes = [];
  let ownerDocument = (0, import_utils.getOwnerDocument)(dialogNode);
  if (!dialogNode) {
    if (true) {
      console.warn("A ref has not yet been attached to a dialog node when attempting to call `createAriaHider`.");
    }
    return import_utils.noop;
  }
  Array.prototype.forEach.call(ownerDocument.querySelectorAll("body > *"), (node) => {
    var _a, _b;
    const portalNode = (_b = (_a = dialogNode.parentNode) == null ? void 0 : _a.parentNode) == null ? void 0 : _b.parentNode;
    if (node === portalNode) {
      return;
    }
    let attr = node.getAttribute("aria-hidden");
    let alreadyHidden = attr !== null && attr !== "false";
    if (alreadyHidden) {
      return;
    }
    originalValues.push(attr);
    rootNodes.push(node);
    node.setAttribute("aria-hidden", "true");
  });
  return () => {
    rootNodes.forEach((node, index) => {
      let originalValue = originalValues[index];
      if (originalValue === null) {
        node.removeAttribute("aria-hidden");
      } else {
        node.setAttribute("aria-hidden", originalValue);
      }
    });
  };
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  Dialog,
  DialogContent,
  DialogInner,
  DialogOverlay,
  unstable_DialogWrapper
});
//# sourceMappingURL=reach-dialog.cjs.dev.js.map