"use strict";
/**
  * @reach/machine v0.18.0-pre.5
  *
  * Copyright (c) 2018-2022, React Training LLC
  *
  * This source code is licensed under the MIT license found in the
  * LICENSE.md file in the root directory of this source tree.
  *
  * @license MIT
  */

var __create = Object.create;
var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target, mod));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/reach-machine.ts
var reach_machine_exports = {};
__export(reach_machine_exports, {
  InterpreterStatus: () => import_fsm.InterpreterStatus,
  assign: () => import_fsm.assign,
  createMachine: () => import_fsm.createMachine,
  interpret: () => import_fsm.interpret,
  unwrapRefs: () => unwrapRefs,
  useCreateMachine: () => useCreateMachine,
  useMachine: () => useMachine
});
module.exports = __toCommonJS(reach_machine_exports);
var React = __toESM(require("react"));
var import_fsm = require("@xstate/fsm");
var import_utils = require("@reach/utils");
var getServiceState = (service) => {
  let currentValue;
  service.subscribe((state) => {
    currentValue = state;
  }).unsubscribe();
  return currentValue;
};
function useMachine(initialMachine, refs, DEBUG) {
  let machineRef = React.useRef(initialMachine);
  let service = (0, import_utils.useConstant)(() => (0, import_fsm.interpret)(machineRef.current).start());
  let lastEventType = React.useRef(null);
  let [state, setState] = React.useState(() => getServiceState(service));
  let send = React.useCallback((rawEvent) => {
    let event = (0, import_utils.isString)(rawEvent) ? { type: rawEvent } : rawEvent;
    let refValues = unwrapRefs(refs);
    service.send(__spreadProps(__spreadValues({}, event), {
      lastEventType: lastEventType.current,
      refs: refValues
    }));
    lastEventType.current = event.type;
    if (true) {
      if (DEBUG) {
        console.group("Event Sent");
        console.log("Event:", event);
        console.groupEnd();
      }
    }
  }, [DEBUG]);
  React.useEffect(() => {
    service.subscribe(function setStateIfChanged(newState) {
      if (newState.changed) {
        setState(newState);
      }
    });
    return () => {
      service.stop();
    };
  }, [service]);
  React.useEffect(() => {
    if (true) {
      if (DEBUG && state.changed) {
        console.group("State Updated");
        console.log("State:", state);
        console.groupEnd();
      }
    }
  }, [DEBUG, state]);
  const memoizedState = React.useMemo(() => __spreadProps(__spreadValues({}, state), {
    matches: (value) => value === state.value
  }), [state.changed, state.context, state.value]);
  return [memoizedState, send, service];
}
function unwrapRefs(refs) {
  return Object.entries(refs).reduce((value, [name, ref]) => {
    value[name] = ref.current;
    return value;
  }, {});
}
function useCreateMachine(machineDefinition, options) {
  return (0, import_utils.useConstant)(() => (0, import_fsm.createMachine)(machineDefinition, options));
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  InterpreterStatus,
  assign,
  createMachine,
  interpret,
  unwrapRefs,
  useCreateMachine,
  useMachine
});
//# sourceMappingURL=reach-machine.cjs.dev.js.map