"use strict";
/**
  * @reach/menu-button v0.18.0-pre.5
  *
  * Copyright (c) 2018-2022, React Training LLC
  *
  * This source code is licensed under the MIT license found in the
  * LICENSE.md file in the root directory of this source tree.
  *
  * @license MIT
  */

var __create = Object.create;
var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target, mod));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/reach-menu-button.tsx
var reach_menu_button_exports = {};
__export(reach_menu_button_exports, {
  Menu: () => Menu,
  MenuButton: () => MenuButton,
  MenuItem: () => MenuItem,
  MenuItems: () => MenuItems,
  MenuLink: () => MenuLink,
  MenuList: () => MenuList,
  MenuPopover: () => MenuPopover,
  useMenuButtonContext: () => useMenuButtonContext
});
module.exports = __toCommonJS(reach_menu_button_exports);
var React = __toESM(require("react"));
var import_popover = require("@reach/popover");
var import_dropdown = require("@reach/dropdown");
var import_utils = require("@reach/utils");
var import_react_is = require("react-is");
var Menu = React.forwardRef((_a, forwardedRef) => {
  var _b = _a, { as: Comp = React.Fragment, id, children } = _b, rest = __objRest(_b, ["as", "id", "children"]);
  let parentIsFragment = React.useMemo(() => {
    try {
      return (0, import_react_is.isFragment)(/* @__PURE__ */ React.createElement(Comp, null));
    } catch (err) {
      return false;
    }
  }, [Comp]);
  let props = parentIsFragment ? {} : __spreadValues({
    ref: forwardedRef,
    id,
    "data-reach-menu": ""
  }, rest);
  return /* @__PURE__ */ React.createElement(Comp, __spreadValues({}, props), /* @__PURE__ */ React.createElement(import_dropdown.DropdownProvider, {
    id,
    children
  }));
});
Menu.displayName = "Menu";
var MenuButton = React.forwardRef((_a, forwardedRef) => {
  var _b = _a, { as: Comp = "button" } = _b, rest = __objRest(_b, ["as"]);
  let {
    data: { isExpanded, controls },
    props
  } = (0, import_dropdown.useDropdownTrigger)(__spreadProps(__spreadValues({}, rest), { ref: forwardedRef }));
  return /* @__PURE__ */ React.createElement(Comp, __spreadProps(__spreadValues({
    "aria-expanded": isExpanded ? true : void 0,
    "aria-haspopup": true,
    "aria-controls": controls
  }, props), {
    "data-reach-menu-button": ""
  }));
});
MenuButton.displayName = "MenuButton";
var MenuItemImpl = React.forwardRef((_a, forwardedRef) => {
  var _b = _a, { as: Comp = "div" } = _b, rest = __objRest(_b, ["as"]);
  let {
    data: { disabled },
    props
  } = (0, import_dropdown.useDropdownItem)(__spreadProps(__spreadValues({}, rest), { ref: forwardedRef }));
  return /* @__PURE__ */ React.createElement(Comp, __spreadProps(__spreadValues({
    role: "menuitem"
  }, props), {
    "aria-disabled": disabled || void 0,
    "data-reach-menu-item": ""
  }));
});
MenuItemImpl.displayName = "MenuItemImpl";
var MenuItem = React.forwardRef((_a, forwardedRef) => {
  var _b = _a, { as = "div" } = _b, props = __objRest(_b, ["as"]);
  return /* @__PURE__ */ React.createElement(MenuItemImpl, __spreadProps(__spreadValues({}, props), {
    ref: forwardedRef,
    as
  }));
});
MenuItem.displayName = "MenuItem";
var MenuItems = React.forwardRef((_a, forwardedRef) => {
  var _b = _a, { as: Comp = "div" } = _b, rest = __objRest(_b, ["as"]);
  let {
    data: { activeDescendant, triggerId },
    props
  } = (0, import_dropdown.useDropdownItems)(__spreadProps(__spreadValues({}, rest), { ref: forwardedRef }));
  return /* @__PURE__ */ React.createElement(Comp, __spreadProps(__spreadValues({
    "aria-activedescendant": activeDescendant,
    "aria-labelledby": triggerId || void 0,
    role: "menu"
  }, props), {
    "data-reach-menu-items": ""
  }));
});
MenuItems.displayName = "MenuItems";
var MenuLink = React.forwardRef((_a, forwardedRef) => {
  var _b = _a, {
    as = "a",
    component,
    onSelect
  } = _b, props = __objRest(_b, [
    "as",
    "component",
    "onSelect"
  ]);
  if (true) {
    React.useEffect(() => {
      if (component) {
        console.warn("[@reach/menu-button]: Please use the `as` prop instead of `component`");
      }
    }, [component]);
  }
  return /* @__PURE__ */ React.createElement(MenuItemImpl, __spreadProps(__spreadValues({}, props), {
    ref: forwardedRef,
    "data-reach-menu-link": "",
    as,
    isLink: true,
    onSelect: onSelect || import_utils.noop
  }));
});
MenuLink.displayName = "MenuLink";
var MenuList = React.forwardRef((_a, forwardedRef) => {
  var _b = _a, { portal = true } = _b, props = __objRest(_b, ["portal"]);
  return /* @__PURE__ */ React.createElement(MenuPopover, {
    portal
  }, /* @__PURE__ */ React.createElement(MenuItems, __spreadProps(__spreadValues({}, props), {
    ref: forwardedRef,
    "data-reach-menu-list": ""
  })));
});
MenuList.displayName = "MenuList";
var MenuPopover = React.forwardRef((_a, forwardedRef) => {
  var _b = _a, { as: Comp = "div" } = _b, rest = __objRest(_b, ["as"]);
  let {
    data: { portal, targetRef, position },
    props
  } = (0, import_dropdown.useDropdownPopover)(__spreadProps(__spreadValues({}, rest), { ref: forwardedRef }));
  let sharedProps = {
    "data-reach-menu-popover": ""
  };
  return portal ? /* @__PURE__ */ React.createElement(import_popover.Popover, __spreadProps(__spreadValues(__spreadValues({}, props), sharedProps), {
    as: Comp,
    targetRef,
    position,
    unstable_skipInitialPortalRender: true
  })) : /* @__PURE__ */ React.createElement(Comp, __spreadValues(__spreadValues({}, props), sharedProps));
});
MenuPopover.displayName = "MenuPopover";
function useMenuButtonContext() {
  let {
    state: { isExpanded }
  } = (0, import_dropdown.useDropdownContext)("useMenuButtonContext");
  return React.useMemo(() => ({ isExpanded }), [isExpanded]);
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  Menu,
  MenuButton,
  MenuItem,
  MenuItems,
  MenuLink,
  MenuList,
  MenuPopover,
  useMenuButtonContext
});
//# sourceMappingURL=reach-menu-button.cjs.dev.js.map