"use strict";
/**
  * @reach/menu-button v0.18.0-pre.5
  *
  * Copyright (c) 2018-2022, React Training LLC
  *
  * This source code is licensed under the MIT license found in the
  * LICENSE.md file in the root directory of this source tree.
  *
  * @license MIT
  */


// src/reach-menu-button.tsx
import * as React from "react";
import { Popover } from "@reach/popover";
import {
  DropdownProvider,
  useDropdownItem,
  useDropdownItems,
  useDropdownPopover,
  useDropdownTrigger,
  useDropdownContext
} from "@reach/dropdown";
import { noop } from "@reach/utils";
import { isFragment } from "react-is";
var Menu = React.forwardRef(({ as: Comp = React.Fragment, id, children, ...rest }, forwardedRef) => {
  let parentIsFragment = React.useMemo(() => {
    try {
      return isFragment(/* @__PURE__ */ React.createElement(Comp, null));
    } catch (err) {
      return false;
    }
  }, [Comp]);
  let props = parentIsFragment ? {} : {
    ref: forwardedRef,
    id,
    "data-reach-menu": "",
    ...rest
  };
  return /* @__PURE__ */ React.createElement(Comp, {
    ...props
  }, /* @__PURE__ */ React.createElement(DropdownProvider, {
    id,
    children
  }));
});
Menu.displayName = "Menu";
var MenuButton = React.forwardRef(({ as: Comp = "button", ...rest }, forwardedRef) => {
  let {
    data: { isExpanded, controls },
    props
  } = useDropdownTrigger({ ...rest, ref: forwardedRef });
  return /* @__PURE__ */ React.createElement(Comp, {
    "aria-expanded": isExpanded ? true : void 0,
    "aria-haspopup": true,
    "aria-controls": controls,
    ...props,
    "data-reach-menu-button": ""
  });
});
MenuButton.displayName = "MenuButton";
var MenuItemImpl = React.forwardRef(({ as: Comp = "div", ...rest }, forwardedRef) => {
  let {
    data: { disabled },
    props
  } = useDropdownItem({ ...rest, ref: forwardedRef });
  return /* @__PURE__ */ React.createElement(Comp, {
    role: "menuitem",
    ...props,
    "aria-disabled": disabled || void 0,
    "data-reach-menu-item": ""
  });
});
MenuItemImpl.displayName = "MenuItemImpl";
var MenuItem = React.forwardRef(({ as = "div", ...props }, forwardedRef) => {
  return /* @__PURE__ */ React.createElement(MenuItemImpl, {
    ...props,
    ref: forwardedRef,
    as
  });
});
MenuItem.displayName = "MenuItem";
var MenuItems = React.forwardRef(({ as: Comp = "div", ...rest }, forwardedRef) => {
  let {
    data: { activeDescendant, triggerId },
    props
  } = useDropdownItems({ ...rest, ref: forwardedRef });
  return /* @__PURE__ */ React.createElement(Comp, {
    "aria-activedescendant": activeDescendant,
    "aria-labelledby": triggerId || void 0,
    role: "menu",
    ...props,
    "data-reach-menu-items": ""
  });
});
MenuItems.displayName = "MenuItems";
var MenuLink = React.forwardRef(({
  as = "a",
  component,
  onSelect,
  ...props
}, forwardedRef) => {
  if (true) {
    React.useEffect(() => {
      if (component) {
        console.warn("[@reach/menu-button]: Please use the `as` prop instead of `component`");
      }
    }, [component]);
  }
  return /* @__PURE__ */ React.createElement(MenuItemImpl, {
    ...props,
    ref: forwardedRef,
    "data-reach-menu-link": "",
    as,
    isLink: true,
    onSelect: onSelect || noop
  });
});
MenuLink.displayName = "MenuLink";
var MenuList = React.forwardRef(({ portal = true, ...props }, forwardedRef) => {
  return /* @__PURE__ */ React.createElement(MenuPopover, {
    portal
  }, /* @__PURE__ */ React.createElement(MenuItems, {
    ...props,
    ref: forwardedRef,
    "data-reach-menu-list": ""
  }));
});
MenuList.displayName = "MenuList";
var MenuPopover = React.forwardRef(({ as: Comp = "div", ...rest }, forwardedRef) => {
  let {
    data: { portal, targetRef, position },
    props
  } = useDropdownPopover({ ...rest, ref: forwardedRef });
  let sharedProps = {
    "data-reach-menu-popover": ""
  };
  return portal ? /* @__PURE__ */ React.createElement(Popover, {
    ...props,
    ...sharedProps,
    as: Comp,
    targetRef,
    position,
    unstable_skipInitialPortalRender: true
  }) : /* @__PURE__ */ React.createElement(Comp, {
    ...props,
    ...sharedProps
  });
});
MenuPopover.displayName = "MenuPopover";
function useMenuButtonContext() {
  let {
    state: { isExpanded }
  } = useDropdownContext("useMenuButtonContext");
  return React.useMemo(() => ({ isExpanded }), [isExpanded]);
}
export {
  Menu,
  MenuButton,
  MenuItem,
  MenuItems,
  MenuLink,
  MenuList,
  MenuPopover,
  useMenuButtonContext
};
