"use strict";
/**
  * @reach/popover v0.18.0-pre.5
  *
  * Copyright (c) 2018-2022, React Training LLC
  *
  * This source code is licensed under the MIT license found in the
  * LICENSE.md file in the root directory of this source tree.
  *
  * @license MIT
  */

var __create = Object.create;
var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target, mod));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/reach-popover.tsx
var reach_popover_exports = {};
__export(reach_popover_exports, {
  Popover: () => Popover,
  getCollisions: () => getCollisions,
  positionDefault: () => positionDefault,
  positionMatchWidth: () => positionMatchWidth,
  positionRight: () => positionRight
});
module.exports = __toCommonJS(reach_popover_exports);
var React = __toESM(require("react"));
var import_portal = require("@reach/portal");
var import_rect = require("@reach/rect");
var import_utils = require("@reach/utils");
var import_tabbable = require("tabbable");
var Popover = React.forwardRef(function Popover2(_a, ref) {
  var _b = _a, { unstable_skipInitialPortalRender } = _b, props = __objRest(_b, ["unstable_skipInitialPortalRender"]);
  return /* @__PURE__ */ React.createElement(import_portal.Portal, {
    unstable_skipInitialRender: unstable_skipInitialPortalRender
  }, /* @__PURE__ */ React.createElement(PopoverImpl, __spreadValues({
    ref
  }, props)));
});
Popover.displayName = "Popover";
var PopoverImpl = React.forwardRef(function PopoverImpl2(_a, forwardedRef) {
  var _b = _a, {
    as: Comp = "div",
    targetRef,
    position = positionDefault,
    unstable_observableRefs = []
  } = _b, props = __objRest(_b, [
    "as",
    "targetRef",
    "position",
    "unstable_observableRefs"
  ]);
  const popoverRef = React.useRef(null);
  const popoverRect = (0, import_rect.useRect)(popoverRef, { observe: !props.hidden });
  const targetRect = (0, import_rect.useRect)(targetRef, { observe: true });
  const ref = (0, import_utils.useComposedRefs)(popoverRef, forwardedRef);
  useSimulateTabNavigationForReactTree(targetRef, popoverRef);
  return /* @__PURE__ */ React.createElement(Comp, __spreadProps(__spreadValues({
    "data-reach-popover": "",
    ref
  }, props), {
    style: __spreadValues(__spreadValues({
      position: "absolute"
    }, getStyles(position, targetRect, popoverRect, ...unstable_observableRefs)), props.style)
  }));
});
PopoverImpl.displayName = "PopoverImpl";
function getStyles(position, targetRect, popoverRect, ...unstable_observableRefs) {
  return popoverRect ? position(targetRect, popoverRect, ...unstable_observableRefs.map((ref) => ref.current)) : { visibility: "hidden" };
}
function getTopPosition(targetRect, popoverRect, isDirectionUp) {
  return {
    top: isDirectionUp ? `${targetRect.top - popoverRect.height + window.pageYOffset}px` : `${targetRect.top + targetRect.height + window.pageYOffset}px`
  };
}
var positionDefault = (targetRect, popoverRect) => {
  if (!targetRect || !popoverRect) {
    return {};
  }
  const { directionRight, directionUp } = getCollisions(targetRect, popoverRect);
  return __spreadValues({
    left: directionRight ? `${targetRect.right - popoverRect.width + window.pageXOffset}px` : `${targetRect.left + window.pageXOffset}px`
  }, getTopPosition(targetRect, popoverRect, directionUp));
};
var positionRight = (targetRect, popoverRect) => {
  if (!targetRect || !popoverRect) {
    return {};
  }
  const { directionLeft, directionUp } = getCollisions(targetRect, popoverRect);
  return __spreadValues({
    left: directionLeft ? `${targetRect.left + window.pageXOffset}px` : `${targetRect.right - popoverRect.width + window.pageXOffset}px`
  }, getTopPosition(targetRect, popoverRect, directionUp));
};
var positionMatchWidth = (targetRect, popoverRect) => {
  if (!targetRect || !popoverRect) {
    return {};
  }
  const { directionUp } = getCollisions(targetRect, popoverRect);
  return __spreadValues({
    width: targetRect.width,
    left: targetRect.left
  }, getTopPosition(targetRect, popoverRect, directionUp));
};
function getCollisions(targetRect, popoverRect, offsetLeft = 0, offsetBottom = 0) {
  const collisions = {
    top: targetRect.top - popoverRect.height < 0,
    right: window.innerWidth < targetRect.left + popoverRect.width - offsetLeft,
    bottom: window.innerHeight < targetRect.bottom + popoverRect.height - offsetBottom,
    left: targetRect.left + targetRect.width - popoverRect.width < 0
  };
  const directionRight = collisions.right && !collisions.left;
  const directionLeft = collisions.left && !collisions.right;
  const directionUp = collisions.bottom && !collisions.top;
  const directionDown = collisions.top && !collisions.bottom;
  return { directionRight, directionLeft, directionUp, directionDown };
}
function useSimulateTabNavigationForReactTree(triggerRef, popoverRef) {
  const ownerDocument = (0, import_utils.getOwnerDocument)(triggerRef.current);
  function handleKeyDown(event) {
    if (event.key === "Tab" && popoverRef.current && (0, import_tabbable.tabbable)(popoverRef.current).length === 0) {
      return;
    }
    if (event.key === "Tab" && event.shiftKey) {
      if (shiftTabbedFromElementAfterTrigger(event)) {
        focusLastTabbableInPopover(event);
      } else if (shiftTabbedOutOfPopover(event)) {
        focusTriggerRef(event);
      } else if (shiftTabbedToBrowserChrome(event)) {
        disableTabbablesInPopover();
      }
    } else if (event.key === "Tab") {
      if (tabbedFromTriggerToPopover()) {
        focusFirstPopoverTabbable(event);
      } else if (tabbedOutOfPopover()) {
        focusTabbableAfterTrigger(event);
      } else if (tabbedToBrowserChrome(event)) {
        disableTabbablesInPopover();
      }
    }
  }
  React.useEffect(() => {
    ownerDocument.addEventListener("keydown", handleKeyDown);
    return () => {
      ownerDocument.removeEventListener("keydown", handleKeyDown);
    };
  }, []);
  function getElementAfterTrigger() {
    const elements = (0, import_tabbable.tabbable)(ownerDocument);
    const targetIndex = elements && triggerRef.current ? elements.indexOf(triggerRef.current) : -1;
    const elementAfterTrigger = elements && elements[targetIndex + 1];
    return popoverRef.current && popoverRef.current.contains(elementAfterTrigger || null) ? false : elementAfterTrigger;
  }
  function tabbedFromTriggerToPopover() {
    return triggerRef.current ? triggerRef.current === ownerDocument.activeElement : false;
  }
  function focusFirstPopoverTabbable(event) {
    const elements = popoverRef.current && (0, import_tabbable.tabbable)(popoverRef.current);
    if (elements && elements[0]) {
      event.preventDefault();
      elements[0].focus();
    }
  }
  function tabbedOutOfPopover() {
    const inPopover = popoverRef.current ? popoverRef.current.contains(ownerDocument.activeElement || null) : false;
    if (inPopover) {
      const elements = popoverRef.current && (0, import_tabbable.tabbable)(popoverRef.current);
      return Boolean(elements && elements[elements.length - 1] === ownerDocument.activeElement);
    }
    return false;
  }
  function focusTabbableAfterTrigger(event) {
    const elementAfterTrigger = getElementAfterTrigger();
    if (elementAfterTrigger) {
      event.preventDefault();
      elementAfterTrigger.focus();
    }
  }
  function shiftTabbedFromElementAfterTrigger(event) {
    if (!event.shiftKey)
      return;
    const elementAfterTrigger = getElementAfterTrigger();
    return event.target === elementAfterTrigger;
  }
  function focusLastTabbableInPopover(event) {
    const elements = popoverRef.current && (0, import_tabbable.tabbable)(popoverRef.current);
    const last = elements && elements[elements.length - 1];
    if (last) {
      event.preventDefault();
      last.focus();
    }
  }
  function shiftTabbedOutOfPopover(event) {
    const elements = popoverRef.current && (0, import_tabbable.tabbable)(popoverRef.current);
    if (elements) {
      return elements.length === 0 ? false : event.target === elements[0];
    }
    return false;
  }
  function focusTriggerRef(event) {
    var _a;
    event.preventDefault();
    (_a = triggerRef.current) == null ? void 0 : _a.focus();
  }
  function tabbedToBrowserChrome(event) {
    const elements = popoverRef.current ? (0, import_tabbable.tabbable)(ownerDocument).filter((element) => !popoverRef.current.contains(element)) : null;
    return elements ? event.target === elements[elements.length - 1] : false;
  }
  function shiftTabbedToBrowserChrome(event) {
    return event.target === (0, import_tabbable.tabbable)(ownerDocument)[0];
  }
  let restoreTabIndexTupl\u00E9s = [];
  function disableTabbablesInPopover() {
    const elements = popoverRef.current && (0, import_tabbable.tabbable)(popoverRef.current);
    if (elements) {
      elements.forEach((element) => {
        restoreTabIndexTupl\u00E9s.push([element, element.tabIndex]);
        element.tabIndex = -1;
      });
      ownerDocument.addEventListener("focusin", enableTabbablesInPopover);
    }
  }
  function enableTabbablesInPopover() {
    ownerDocument.removeEventListener("focusin", enableTabbablesInPopover);
    restoreTabIndexTupl\u00E9s.forEach(([element, tabIndex]) => {
      element.tabIndex = tabIndex;
    });
  }
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  Popover,
  getCollisions,
  positionDefault,
  positionMatchWidth,
  positionRight
});
//# sourceMappingURL=reach-popover.cjs.dev.js.map