"use strict";
/**
  * @reach/rect v0.18.0-pre.5
  *
  * Copyright (c) 2018-2022, React Training LLC
  *
  * This source code is licensed under the MIT license found in the
  * LICENSE.md file in the root directory of this source tree.
  *
  * @license MIT
  */

var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target, mod));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/reach-rect.tsx
var reach_rect_exports = {};
__export(reach_rect_exports, {
  Rect: () => Rect,
  useRect: () => useRect
});
module.exports = __toCommonJS(reach_rect_exports);
var React = __toESM(require("react"));
var import_observe_rect = __toESM(require("@reach/observe-rect"));
var import_utils = require("@reach/utils");
var Rect = ({ onChange, observe = true, children }) => {
  const ref = React.useRef(null);
  const rect = useRect(ref, { observe, onChange });
  return children({ ref, rect });
};
Rect.displayName = "Rect";
function useRect(nodeRef, observeOrOptions, deprecated_onChange) {
  var _a;
  let observe;
  let onChange;
  if ((0, import_utils.isBoolean)(observeOrOptions)) {
    observe = observeOrOptions;
  } else {
    observe = (_a = observeOrOptions == null ? void 0 : observeOrOptions.observe) != null ? _a : true;
    onChange = observeOrOptions == null ? void 0 : observeOrOptions.onChange;
  }
  if ((0, import_utils.isFunction)(deprecated_onChange)) {
    onChange = deprecated_onChange;
  }
  if (true) {
    React.useEffect(() => {
      if ((0, import_utils.isBoolean)(observeOrOptions)) {
        console.warn("Passing `observe` as the second argument to `useRect` is deprecated and will be removed in a future version of Reach UI. Instead, you can pass an object of options with an `observe` property as the second argument (`useRect(ref, { observe })`).\nSee https://reach.tech/rect#userect-observe");
      }
    }, [observeOrOptions]);
    React.useEffect(() => {
      if ((0, import_utils.isFunction)(deprecated_onChange)) {
        console.warn("Passing `onChange` as the third argument to `useRect` is deprecated and will be removed in a future version of Reach UI. Instead, you can pass an object of options with an `onChange` property as the second argument (`useRect(ref, { onChange })`).\nSee https://reach.tech/rect#userect-onchange");
      }
    }, [deprecated_onChange]);
  }
  let [element, setElement] = React.useState(nodeRef.current);
  let initialRectIsSet = React.useRef(false);
  let initialRefIsSet = React.useRef(false);
  let [rect, setRect] = React.useState(null);
  let onChangeRef = React.useRef(onChange);
  (0, import_utils.useIsomorphicLayoutEffect)(() => {
    onChangeRef.current = onChange;
    if (nodeRef.current !== element) {
      setElement(nodeRef.current);
    }
  });
  (0, import_utils.useIsomorphicLayoutEffect)(() => {
    if (element && !initialRectIsSet.current) {
      initialRectIsSet.current = true;
      setRect(element.getBoundingClientRect());
    }
  }, [element]);
  (0, import_utils.useIsomorphicLayoutEffect)(() => {
    if (!observe) {
      return;
    }
    let elem = element;
    if (!initialRefIsSet.current) {
      initialRefIsSet.current = true;
      elem = nodeRef.current;
    }
    if (!elem) {
      if (true) {
        console.warn("You need to place the ref");
      }
      return;
    }
    let observer = (0, import_observe_rect.default)(elem, (rect2) => {
      var _a2;
      (_a2 = onChangeRef.current) == null ? void 0 : _a2.call(onChangeRef, rect2);
      setRect(rect2);
    });
    observer.observe();
    return () => {
      observer.unobserve();
    };
  }, [observe, element, nodeRef]);
  return rect;
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  Rect,
  useRect
});
//# sourceMappingURL=reach-rect.cjs.dev.js.map