"use strict";
/**
  * @reach/tooltip v0.18.0-pre.5
  *
  * Copyright (c) 2018-2022, React Training LLC
  *
  * This source code is licensed under the MIT license found in the
  * LICENSE.md file in the root directory of this source tree.
  *
  * @license MIT
  */

var __create = Object.create;
var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target, mod));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/reach-tooltip.tsx
var reach_tooltip_exports = {};
__export(reach_tooltip_exports, {
  LEAVE_TIMEOUT: () => LEAVE_TIMEOUT,
  MOUSE_REST_TIMEOUT: () => MOUSE_REST_TIMEOUT,
  Tooltip: () => Tooltip,
  TooltipPopup: () => TooltipPopup,
  positionTooltip: () => positionTooltip,
  useTooltip: () => useTooltip
});
module.exports = __toCommonJS(reach_tooltip_exports);
var React = __toESM(require("react"));
var import_auto_id = require("@reach/auto-id");
var import_utils = require("@reach/utils");
var import_portal = require("@reach/portal");
var import_visually_hidden = require("@reach/visually-hidden");
var import_rect = require("@reach/rect");
var MOUSE_REST_TIMEOUT = 100;
var LEAVE_TIMEOUT = 500;
var chart = {
  initial: "IDLE" /* Idle */,
  states: {
    ["IDLE" /* Idle */]: {
      enter: clearContextId,
      on: {
        ["MOUSE_ENTER" /* MouseEnter */]: "FOCUSED" /* Focused */,
        ["FOCUS" /* Focus */]: "VISIBLE" /* Visible */
      }
    },
    ["FOCUSED" /* Focused */]: {
      enter: startRestTimer,
      leave: clearRestTimer,
      on: {
        ["MOUSE_MOVE" /* MouseMove */]: "FOCUSED" /* Focused */,
        ["MOUSE_LEAVE" /* MouseLeave */]: "IDLE" /* Idle */,
        ["MOUSE_DOWN" /* MouseDown */]: "DISMISSED" /* Dismissed */,
        ["BLUR" /* Blur */]: "IDLE" /* Idle */,
        ["REST" /* Rest */]: "VISIBLE" /* Visible */
      }
    },
    ["VISIBLE" /* Visible */]: {
      on: {
        ["FOCUS" /* Focus */]: "FOCUSED" /* Focused */,
        ["MOUSE_ENTER" /* MouseEnter */]: "FOCUSED" /* Focused */,
        ["MOUSE_LEAVE" /* MouseLeave */]: "LEAVING_VISIBLE" /* LeavingVisible */,
        ["BLUR" /* Blur */]: "LEAVING_VISIBLE" /* LeavingVisible */,
        ["MOUSE_DOWN" /* MouseDown */]: "DISMISSED" /* Dismissed */,
        ["SELECT_WITH_KEYBOARD" /* SelectWithKeyboard */]: "DISMISSED" /* Dismissed */,
        ["GLOBAL_MOUSE_MOVE" /* GlobalMouseMove */]: "LEAVING_VISIBLE" /* LeavingVisible */
      }
    },
    ["LEAVING_VISIBLE" /* LeavingVisible */]: {
      enter: startLeavingVisibleTimer,
      leave: () => {
        clearLeavingVisibleTimer();
        clearContextId();
      },
      on: {
        ["MOUSE_ENTER" /* MouseEnter */]: "VISIBLE" /* Visible */,
        ["FOCUS" /* Focus */]: "VISIBLE" /* Visible */,
        ["TIME_COMPLETE" /* TimeComplete */]: "IDLE" /* Idle */
      }
    },
    ["DISMISSED" /* Dismissed */]: {
      leave: () => {
        clearContextId();
      },
      on: {
        ["MOUSE_LEAVE" /* MouseLeave */]: "IDLE" /* Idle */,
        ["BLUR" /* Blur */]: "IDLE" /* Idle */
      }
    }
  }
};
var state = {
  value: chart.initial,
  context: { id: null }
};
var subscriptions = [];
function subscribe(fn) {
  subscriptions.push(fn);
  return () => {
    subscriptions.splice(subscriptions.indexOf(fn), 1);
  };
}
function notify() {
  subscriptions.forEach((fn) => fn(state));
}
var restTimeout;
function startRestTimer() {
  window.clearTimeout(restTimeout);
  restTimeout = window.setTimeout(() => {
    send({ type: "REST" /* Rest */ });
  }, MOUSE_REST_TIMEOUT);
}
function clearRestTimer() {
  window.clearTimeout(restTimeout);
}
var leavingVisibleTimer;
function startLeavingVisibleTimer() {
  window.clearTimeout(leavingVisibleTimer);
  leavingVisibleTimer = window.setTimeout(() => send({ type: "TIME_COMPLETE" /* TimeComplete */ }), LEAVE_TIMEOUT);
}
function clearLeavingVisibleTimer() {
  window.clearTimeout(leavingVisibleTimer);
}
function clearContextId() {
  state.context.id = null;
}
function useTooltip({
  id: idProp,
  onPointerEnter,
  onPointerMove,
  onPointerLeave,
  onPointerDown,
  onMouseEnter,
  onMouseMove,
  onMouseLeave,
  onMouseDown,
  onFocus,
  onBlur,
  onKeyDown,
  disabled,
  ref: forwardedRef,
  DEBUG_STYLE
} = {}) {
  let id = String((0, import_auto_id.useId)(idProp));
  let [isVisible, setIsVisible] = React.useState(DEBUG_STYLE ? true : isTooltipVisible(id, true));
  let ownRef = React.useRef(null);
  let ref = (0, import_utils.useComposedRefs)(forwardedRef, ownRef);
  let triggerRect = (0, import_rect.useRect)(ownRef, { observe: isVisible });
  React.useEffect(() => {
    return subscribe(() => {
      setIsVisible(isTooltipVisible(id));
    });
  }, [id]);
  React.useEffect(() => {
    let ownerDocument = (0, import_utils.getOwnerDocument)(ownRef.current);
    function listener(event) {
      if ((event.key === "Escape" || event.key === "Esc") && state.value === "VISIBLE" /* Visible */) {
        send({ type: "SELECT_WITH_KEYBOARD" /* SelectWithKeyboard */ });
      }
    }
    ownerDocument.addEventListener("keydown", listener);
    return () => ownerDocument.removeEventListener("keydown", listener);
  }, []);
  useDisabledTriggerOnSafari({ disabled, isVisible, ref: ownRef });
  function wrapMouseEvent(theirHandler, ourHandler) {
    if (typeof window !== "undefined" && "PointerEvent" in window) {
      return theirHandler;
    }
    return (0, import_utils.composeEventHandlers)(theirHandler, ourHandler);
  }
  function wrapPointerEventHandler(handler) {
    return function onPointerEvent(event) {
      if (event.pointerType !== "mouse") {
        return;
      }
      handler(event);
    };
  }
  function handleMouseEnter() {
    send({ type: "MOUSE_ENTER" /* MouseEnter */, id });
  }
  function handleMouseMove() {
    send({ type: "MOUSE_MOVE" /* MouseMove */, id });
  }
  function handleMouseLeave() {
    send({ type: "MOUSE_LEAVE" /* MouseLeave */ });
  }
  function handleMouseDown() {
    if (state.context.id === id) {
      send({ type: "MOUSE_DOWN" /* MouseDown */ });
    }
  }
  function handleFocus() {
    if (window.__REACH_DISABLE_TOOLTIPS) {
      return;
    }
    send({ type: "FOCUS" /* Focus */, id });
  }
  function handleBlur() {
    if (state.context.id === id) {
      send({ type: "BLUR" /* Blur */ });
    }
  }
  function handleKeyDown(event) {
    if (event.key === "Enter" || event.key === " ") {
      send({ type: "SELECT_WITH_KEYBOARD" /* SelectWithKeyboard */ });
    }
  }
  let trigger = {
    "aria-describedby": isVisible ? (0, import_utils.makeId)("tooltip", id) : void 0,
    "data-state": isVisible ? "tooltip-visible" : "tooltip-hidden",
    "data-reach-tooltip-trigger": "",
    ref,
    onPointerEnter: (0, import_utils.composeEventHandlers)(onPointerEnter, wrapPointerEventHandler(handleMouseEnter)),
    onPointerMove: (0, import_utils.composeEventHandlers)(onPointerMove, wrapPointerEventHandler(handleMouseMove)),
    onPointerLeave: (0, import_utils.composeEventHandlers)(onPointerLeave, wrapPointerEventHandler(handleMouseLeave)),
    onPointerDown: (0, import_utils.composeEventHandlers)(onPointerDown, wrapPointerEventHandler(handleMouseDown)),
    onMouseEnter: wrapMouseEvent(onMouseEnter, handleMouseEnter),
    onMouseMove: wrapMouseEvent(onMouseMove, handleMouseMove),
    onMouseLeave: wrapMouseEvent(onMouseLeave, handleMouseLeave),
    onMouseDown: wrapMouseEvent(onMouseDown, handleMouseDown),
    onFocus: (0, import_utils.composeEventHandlers)(onFocus, handleFocus),
    onBlur: (0, import_utils.composeEventHandlers)(onBlur, handleBlur),
    onKeyDown: (0, import_utils.composeEventHandlers)(onKeyDown, handleKeyDown)
  };
  let tooltip = {
    id,
    triggerRect,
    isVisible
  };
  return [trigger, tooltip, isVisible];
}
var Tooltip = React.forwardRef(function(_a, forwardedRef) {
  var _b = _a, {
    children,
    label,
    ariaLabel: DEPRECATED_ariaLabel,
    id,
    DEBUG_STYLE
  } = _b, props = __objRest(_b, [
    "children",
    "label",
    "ariaLabel",
    "id",
    "DEBUG_STYLE"
  ]);
  let child = React.Children.only(children);
  if (true) {
    React.useEffect(() => {
      if (DEPRECATED_ariaLabel) {
        console.warn("The `ariaLabel prop is deprecated and will be removed from @reach/tooltip in a future version of Reach UI. Please use `aria-label` instead.");
      }
    }, [DEPRECATED_ariaLabel]);
  }
  let [trigger, tooltip] = useTooltip({
    id,
    onPointerEnter: child.props.onPointerEnter,
    onPointerMove: child.props.onPointerMove,
    onPointerLeave: child.props.onPointerLeave,
    onPointerDown: child.props.onPointerDown,
    onMouseEnter: child.props.onMouseEnter,
    onMouseMove: child.props.onMouseMove,
    onMouseLeave: child.props.onMouseLeave,
    onMouseDown: child.props.onMouseDown,
    onFocus: child.props.onFocus,
    onBlur: child.props.onBlur,
    onKeyDown: child.props.onKeyDown,
    disabled: child.props.disabled,
    ref: child.ref,
    DEBUG_STYLE
  });
  return /* @__PURE__ */ React.createElement(React.Fragment, null, React.cloneElement(child, trigger), /* @__PURE__ */ React.createElement(TooltipPopup, __spreadValues(__spreadValues({
    ref: forwardedRef,
    label,
    "aria-label": DEPRECATED_ariaLabel
  }, tooltip), props)));
});
Tooltip.displayName = "Tooltip";
var TooltipPopup = React.forwardRef(function TooltipPopup2(_a, forwardRef2) {
  var _b = _a, {
    label,
    ariaLabel: DEPRECATED_ariaLabel,
    isVisible,
    id
  } = _b, props = __objRest(_b, [
    "label",
    "ariaLabel",
    "isVisible",
    "id"
  ]);
  return isVisible ? /* @__PURE__ */ React.createElement(import_portal.Portal, null, /* @__PURE__ */ React.createElement(TooltipContent, __spreadProps(__spreadValues({
    ref: forwardRef2,
    label,
    "aria-label": DEPRECATED_ariaLabel,
    isVisible
  }, props), {
    id: (0, import_utils.makeId)("tooltip", String(id))
  }))) : null;
});
TooltipPopup.displayName = "TooltipPopup";
var TooltipContent = React.forwardRef(function TooltipContent2(_a, forwardedRef) {
  var _b = _a, {
    ariaLabel,
    "aria-label": realAriaLabel,
    as: Comp = "div",
    id,
    isVisible,
    label,
    position = positionTooltip,
    style,
    triggerRect
  } = _b, props = __objRest(_b, [
    "ariaLabel",
    "aria-label",
    "as",
    "id",
    "isVisible",
    "label",
    "position",
    "style",
    "triggerRect"
  ]);
  let hasAriaLabel = (realAriaLabel || ariaLabel) != null;
  let ownRef = React.useRef(null);
  let ref = (0, import_utils.useComposedRefs)(forwardedRef, ownRef);
  let tooltipRect = (0, import_rect.useRect)(ownRef, { observe: isVisible });
  return /* @__PURE__ */ React.createElement(React.Fragment, null, /* @__PURE__ */ React.createElement(Comp, __spreadProps(__spreadValues({
    role: hasAriaLabel ? void 0 : "tooltip"
  }, props), {
    ref,
    "data-reach-tooltip": "",
    id: hasAriaLabel ? void 0 : id,
    style: __spreadValues(__spreadValues({}, style), getStyles(position, triggerRect, tooltipRect))
  }), label), hasAriaLabel && /* @__PURE__ */ React.createElement(import_visually_hidden.VisuallyHidden, {
    role: "tooltip",
    id
  }, realAriaLabel || ariaLabel));
});
TooltipContent.displayName = "TooltipContent";
function getStyles(position, triggerRect, tooltipRect) {
  let haventMeasuredTooltipYet = !tooltipRect;
  if (haventMeasuredTooltipYet) {
    return { visibility: "hidden" };
  }
  return position(triggerRect, tooltipRect);
}
var OFFSET_DEFAULT = 8;
var positionTooltip = (triggerRect, tooltipRect, offset = OFFSET_DEFAULT) => {
  let { width: windowWidth, height: windowHeight } = (0, import_utils.getDocumentDimensions)();
  if (!triggerRect || !tooltipRect) {
    return {};
  }
  let collisions = {
    top: triggerRect.top - tooltipRect.height < 0,
    right: windowWidth < triggerRect.left + tooltipRect.width,
    bottom: windowHeight < triggerRect.bottom + tooltipRect.height + offset,
    left: triggerRect.left - tooltipRect.width < 0
  };
  let directionRight = collisions.right && !collisions.left;
  let directionUp = collisions.bottom && !collisions.top;
  return {
    left: directionRight ? `${triggerRect.right - tooltipRect.width + window.pageXOffset}px` : `${triggerRect.left + window.pageXOffset}px`,
    top: directionUp ? `${triggerRect.top - offset - tooltipRect.height + window.pageYOffset}px` : `${triggerRect.top + offset + triggerRect.height + window.pageYOffset}px`
  };
};
function useDisabledTriggerOnSafari({
  disabled,
  isVisible,
  ref
}) {
  React.useEffect(() => {
    if (!(typeof window !== "undefined" && "PointerEvent" in window) || !disabled || !isVisible) {
      return;
    }
    let ownerDocument = (0, import_utils.getOwnerDocument)(ref.current);
    function handleMouseMove(event) {
      if (!isVisible) {
        return;
      }
      if (event.target instanceof Element && event.target.closest("[data-reach-tooltip-trigger][data-state='tooltip-visible']")) {
        return;
      }
      send({ type: "GLOBAL_MOUSE_MOVE" /* GlobalMouseMove */ });
    }
    ownerDocument.addEventListener("mousemove", handleMouseMove);
    return () => {
      ownerDocument.removeEventListener("mousemove", handleMouseMove);
    };
  }, [disabled, isVisible, ref]);
}
function send(event) {
  let { value, context, changed } = transition(state, event);
  if (changed) {
    state = { value, context };
    notify();
  }
}
function transition(currentState, event) {
  let stateDef = chart.states[currentState.value];
  let nextState = stateDef && stateDef.on && stateDef.on[event.type];
  if (!nextState) {
    return __spreadProps(__spreadValues({}, currentState), { changed: false });
  }
  if (stateDef && stateDef.leave) {
    stateDef.leave(currentState.context, event);
  }
  const _a = event, { type: _ } = _a, payload = __objRest(_a, ["type"]);
  let context = __spreadValues(__spreadValues({}, state.context), payload);
  let nextStateValue = typeof nextState === "string" ? nextState : nextState.target;
  let nextDef = chart.states[nextStateValue];
  if (nextDef && nextDef.enter) {
    nextDef.enter(currentState.context, event);
  }
  return {
    value: nextStateValue,
    context,
    changed: true
  };
}
function isTooltipVisible(id, initial) {
  return state.context.id === id && (initial ? state.value === "VISIBLE" /* Visible */ : state.value === "VISIBLE" /* Visible */ || state.value === "LEAVING_VISIBLE" /* LeavingVisible */);
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  LEAVE_TIMEOUT,
  MOUSE_REST_TIMEOUT,
  Tooltip,
  TooltipPopup,
  positionTooltip,
  useTooltip
});
//# sourceMappingURL=reach-tooltip.cjs.dev.js.map