import type * as React from "react";
/**
 * Check if a component is controlled or uncontrolled and return the correct
 * state value and setter accordingly. If the component state is controlled by
 * the app, the setter is a noop.
 *
 * @param controlledValue
 * @param defaultValue
 */
export declare function useControlledState<T = any>({ controlledValue, defaultValue, calledFrom, }: {
    controlledValue: T | undefined;
    defaultValue: T | (() => T);
    calledFrom?: string;
}): [T, React.Dispatch<React.SetStateAction<T>>];
