"use strict";
/**
  * @reach/utils v0.18.0-pre.5
  *
  * Copyright (c) 2018-2022, React Training LLC
  *
  * This source code is licensed under the MIT license found in the
  * LICENSE.md file in the root directory of this source tree.
  *
  * @license MIT
  */

var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target, mod));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/reach-utils.ts
var reach_utils_exports = {};
__export(reach_utils_exports, {
  assignRef: () => assignRef,
  canUseDOM: () => canUseDOM,
  cloneValidElement: () => cloneValidElement,
  composeEventHandlers: () => composeEventHandlers,
  createContext: () => createContext2,
  createNamedContext: () => createNamedContext,
  getComputedStyle: () => getComputedStyle,
  getComputedStyles: () => getComputedStyles,
  getDocumentDimensions: () => getDocumentDimensions,
  getOwnerDocument: () => getOwnerDocument,
  getOwnerWindow: () => getOwnerWindow,
  getScrollPosition: () => getScrollPosition,
  getScrollbarOffset: () => getScrollbarOffset,
  isBoolean: () => isBoolean,
  isFunction: () => isFunction,
  isNumber: () => isNumber,
  isRightClick: () => isRightClick,
  isString: () => isString,
  makeId: () => makeId,
  noop: () => noop,
  useComposedRefs: () => useComposedRefs,
  useConstant: () => useConstant,
  useControlledState: () => useControlledState,
  useControlledSwitchWarning: () => useControlledSwitchWarning,
  useEventListener: () => useEventListener,
  useFocusChange: () => useFocusChange,
  useForceUpdate: () => useForceUpdate,
  useIsomorphicLayoutEffect: () => useIsomorphicLayoutEffect,
  useLazyRef: () => useLazyRef,
  usePrevious: () => usePrevious,
  useStableCallback: () => useStableCallback,
  useStableLayoutCallback: () => useStableLayoutCallback,
  useStatefulRefValue: () => useStatefulRefValue,
  useUpdateEffect: () => useUpdateEffect
});
module.exports = __toCommonJS(reach_utils_exports);

// src/can-use-dom.ts
function canUseDOM() {
  return !!(typeof window !== "undefined" && window.document && window.document.createElement);
}

// src/clone-valid-element.ts
var import_react = require("react");
function cloneValidElement(element, props, ...children) {
  return (0, import_react.isValidElement)(element) ? (0, import_react.cloneElement)(element, props, ...children) : element;
}

// src/compose-event-handlers.ts
function composeEventHandlers(theirHandler, ourHandler) {
  return (event) => {
    theirHandler && theirHandler(event);
    if (!event.defaultPrevented) {
      return ourHandler(event);
    }
  };
}

// src/compose-refs.ts
var import_react2 = require("react");

// src/type-check.ts
function isBoolean(value) {
  return typeof value === "boolean";
}
function isFunction(value) {
  return !!(value && {}.toString.call(value) == "[object Function]");
}
function isNumber(value) {
  return typeof value === "number" && !isNaN(value);
}
function isString(value) {
  return typeof value === "string";
}

// src/compose-refs.ts
function assignRef(ref, value) {
  if (ref == null)
    return;
  if (isFunction(ref)) {
    ref(value);
  } else {
    try {
      ref.current = value;
    } catch (error) {
      throw new Error(`Cannot assign value "${value}" to ref "${ref}"`);
    }
  }
}
function useComposedRefs(...refs) {
  return (0, import_react2.useCallback)((node) => {
    for (let ref of refs) {
      assignRef(ref, node);
    }
  }, refs);
}

// src/owner-document.ts
function getOwnerDocument(element) {
  return canUseDOM() ? element ? element.ownerDocument : document : null;
}
function getOwnerWindow(element) {
  let ownerDocument = getOwnerDocument(element);
  return ownerDocument ? ownerDocument.defaultView || window : null;
}

// src/computed-styles.ts
function getComputedStyles(element) {
  let ownerWindow = getOwnerWindow(element);
  if (ownerWindow) {
    return ownerWindow.getComputedStyle(element, null);
  }
  return null;
}
function getComputedStyle(element, styleProp) {
  var _a;
  return ((_a = getComputedStyles(element)) == null ? void 0 : _a.getPropertyValue(styleProp)) || null;
}

// src/context.tsx
var React = __toESM(require("react"));
function createNamedContext(name, defaultValue) {
  let Ctx = React.createContext(defaultValue);
  Ctx.displayName = name;
  return Ctx;
}
function createContext2(rootComponentName, defaultContext) {
  let Ctx = React.createContext(defaultContext);
  function Provider(props) {
    let _a = props, { children } = _a, context = __objRest(_a, ["children"]);
    let value = React.useMemo(() => context, Object.values(context));
    return /* @__PURE__ */ React.createElement(Ctx.Provider, {
      value
    }, children);
  }
  function useContext2(callerComponentName) {
    let context = React.useContext(Ctx);
    if (context) {
      return context;
    }
    if (defaultContext) {
      return defaultContext;
    }
    throw Error(`${callerComponentName} must be rendered inside of a ${rootComponentName} component.`);
  }
  Ctx.displayName = `${rootComponentName}Context`;
  Provider.displayName = `${rootComponentName}Provider`;
  return [Provider, useContext2];
}

// src/dev-utils.ts
var import_react3 = require("react");
function useControlledSwitchWarning(controlledValue, controlledPropName, componentName) {
  if (true) {
    let controlledRef = (0, import_react3.useRef)(controlledValue != null);
    let nameCache = (0, import_react3.useRef)({ componentName, controlledPropName });
    (0, import_react3.useEffect)(() => {
      nameCache.current = { componentName, controlledPropName };
    }, [componentName, controlledPropName]);
    (0, import_react3.useEffect)(() => {
      let { current: wasControlled } = controlledRef;
      let { componentName: componentName2, controlledPropName: controlledPropName2 } = nameCache.current;
      let isControlled = controlledValue != null;
      if (wasControlled !== isControlled) {
        console.error(`A component is changing an ${wasControlled ? "" : "un"}controlled \`${controlledPropName2}\` state of ${componentName2} to be ${wasControlled ? "un" : ""}controlled. This is likely caused by the value changing from undefined to a defined value, which should not happen. Decide between using a controlled or uncontrolled ${componentName2} element for the lifetime of the component.
      More info: https://fb.me/react-controlled-components`);
      }
    }, [controlledValue]);
  }
}

// src/get-document-dimensions.ts
function getDocumentDimensions(element) {
  var _a, _b;
  let ownerDocument = getOwnerDocument(element);
  let ownerWindow = ownerDocument.defaultView || window;
  if (!ownerDocument) {
    return {
      width: 0,
      height: 0
    };
  }
  return {
    width: (_a = ownerDocument.documentElement.clientWidth) != null ? _a : ownerWindow.innerWidth,
    height: (_b = ownerDocument.documentElement.clientHeight) != null ? _b : ownerWindow.innerHeight
  };
}

// src/get-scroll-position.ts
function getScrollPosition(element) {
  let ownerWindow = getOwnerWindow(element);
  if (!ownerWindow) {
    return {
      scrollX: 0,
      scrollY: 0
    };
  }
  return {
    scrollX: ownerWindow.scrollX,
    scrollY: ownerWindow.scrollY
  };
}

// src/get-scrollbar-offset.ts
function getScrollbarOffset() {
  try {
    if (window.innerWidth > document.documentElement.clientWidth) {
      return window.innerWidth - document.documentElement.clientWidth;
    }
  } catch (err) {
  }
  return 0;
}

// src/is-right-click.ts
function isRightClick(nativeEvent) {
  return "which" in nativeEvent ? nativeEvent.which === 3 : "button" in nativeEvent ? nativeEvent.button === 2 : false;
}

// src/make-id.ts
function makeId(...args) {
  return args.filter((val) => val != null).join("--");
}

// src/noop.ts
function noop() {
}

// src/use-constant.ts
var import_react4 = require("react");
function useConstant(fn) {
  const ref = (0, import_react4.useRef)();
  if (!ref.current) {
    ref.current = { v: fn() };
  }
  return ref.current.v;
}

// src/use-controlled-state.ts
var import_react5 = require("react");
function useControlledState({
  controlledValue,
  defaultValue,
  calledFrom = "A component"
}) {
  let wasControlled = controlledValue !== void 0;
  let isControlledRef = (0, import_react5.useRef)(wasControlled);
  if (true) {
    if (!isControlledRef.current && wasControlled) {
      console.warn(`${calledFrom} is changing from controlled to uncontrolled. Components should not switch from controlled to uncontrolled (or vice versa). Decide between using a controlled or uncontrolled value for the lifetime of the component.`);
    }
    if (isControlledRef.current && !wasControlled) {
      console.warn(`${calledFrom} is changing from uncontrolled to controlled. Components should not switch from uncontrolled to controlled (or vice versa). Decide between using a controlled or uncontrolled value for the lifetime of the component.`);
    }
  }
  let [valueState, setValue] = (0, import_react5.useState)(isControlledRef.current ? controlledValue : defaultValue);
  let set = (0, import_react5.useCallback)((n) => {
    if (!isControlledRef.current) {
      setValue(n);
    }
  }, []);
  return [isControlledRef.current ? controlledValue : valueState, set];
}

// src/use-event-listener.ts
var import_react6 = require("react");
function useEventListener(eventName, listener, element = window) {
  const savedHandler = (0, import_react6.useRef)(listener);
  (0, import_react6.useEffect)(() => {
    savedHandler.current = listener;
  }, [listener]);
  (0, import_react6.useEffect)(() => {
    const isSupported = element && element.addEventListener;
    if (!isSupported) {
      if (true) {
        console.warn("Event listener not supported on the element provided");
      }
      return;
    }
    function eventListener(event) {
      savedHandler.current(event);
    }
    element.addEventListener(eventName, eventListener);
    return () => {
      element.removeEventListener(eventName, eventListener);
    };
  }, [eventName, element]);
}

// src/use-focus-change.ts
var import_react7 = require("react");
function useFocusChange(handleChange = console.log, when = "focus", ownerDocument = document) {
  let lastActiveElement = (0, import_react7.useRef)(ownerDocument.activeElement);
  (0, import_react7.useEffect)(() => {
    lastActiveElement.current = ownerDocument.activeElement;
    function onChange(event) {
      if (lastActiveElement.current !== ownerDocument.activeElement) {
        handleChange(ownerDocument.activeElement, lastActiveElement.current, event);
        lastActiveElement.current = ownerDocument.activeElement;
      }
    }
    ownerDocument.addEventListener(when, onChange, true);
    return () => {
      ownerDocument.removeEventListener(when, onChange);
    };
  }, [when, handleChange, ownerDocument]);
}

// src/use-force-update.ts
var import_react8 = require("react");
function useForceUpdate() {
  let [, dispatch] = (0, import_react8.useState)(/* @__PURE__ */ Object.create(null));
  return (0, import_react8.useCallback)(() => {
    dispatch(/* @__PURE__ */ Object.create(null));
  }, []);
}

// src/use-isomorphic-layout-effect.ts
var import_react9 = require("react");
var useIsomorphicLayoutEffect = canUseDOM() ? import_react9.useLayoutEffect : import_react9.useEffect;

// src/use-lazy-ref.ts
var import_react10 = require("react");
function useLazyRef(fn) {
  let isSet = (0, import_react10.useRef)(false);
  let ref = (0, import_react10.useRef)();
  if (!isSet.current) {
    isSet.current = true;
    ref.current = fn();
  }
  return ref;
}

// src/use-previous.ts
var import_react11 = require("react");
function usePrevious(value) {
  const ref = (0, import_react11.useRef)(null);
  (0, import_react11.useEffect)(() => {
    ref.current = value;
  }, [value]);
  return ref.current;
}

// src/use-stable-callback.ts
var import_react12 = require("react");
function createStableCallbackHook(useEffectHook, callback) {
  let callbackRef = (0, import_react12.useRef)(callback);
  useEffectHook(() => {
    callbackRef.current = callback;
  });
  return (0, import_react12.useCallback)((...args) => {
    callbackRef.current && callbackRef.current(...args);
  }, []);
}
function useStableCallback(callback) {
  return createStableCallbackHook(import_react12.useEffect, callback);
}
function useStableLayoutCallback(callback) {
  return createStableCallbackHook(useIsomorphicLayoutEffect, callback);
}

// src/use-stateful-ref-value.ts
var import_react13 = require("react");
function useStatefulRefValue(ref, initialState) {
  let [state, setState] = (0, import_react13.useState)(initialState);
  let callbackRef = (0, import_react13.useCallback)((refValue) => {
    ref.current = refValue;
    setState(refValue);
  }, []);
  return [state, callbackRef];
}

// src/use-update-effect.ts
var import_react14 = require("react");
function useUpdateEffect(effect, deps) {
  const mounted = (0, import_react14.useRef)(false);
  (0, import_react14.useEffect)(() => {
    if (mounted.current) {
      effect();
    } else {
      mounted.current = true;
    }
  }, deps);
}
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  assignRef,
  canUseDOM,
  cloneValidElement,
  composeEventHandlers,
  createContext,
  createNamedContext,
  getComputedStyle,
  getComputedStyles,
  getDocumentDimensions,
  getOwnerDocument,
  getOwnerWindow,
  getScrollPosition,
  getScrollbarOffset,
  isBoolean,
  isFunction,
  isNumber,
  isRightClick,
  isString,
  makeId,
  noop,
  useComposedRefs,
  useConstant,
  useControlledState,
  useControlledSwitchWarning,
  useEventListener,
  useFocusChange,
  useForceUpdate,
  useIsomorphicLayoutEffect,
  useLazyRef,
  usePrevious,
  useStableCallback,
  useStableLayoutCallback,
  useStatefulRefValue,
  useUpdateEffect
});
//# sourceMappingURL=reach-utils.cjs.dev.js.map