"use strict";
/**
  * @reach/visually-hidden v0.18.0-pre.5
  *
  * Copyright (c) 2018-2022, React Training LLC
  *
  * This source code is licensed under the MIT license found in the
  * LICENSE.md file in the root directory of this source tree.
  *
  * @license MIT
  */


// src/reach-visually-hidden.tsx
import * as React from "react";
var VisuallyHidden = React.forwardRef(function VisuallyHidden2({ as: Comp = "span", style = {}, ...props }, ref) {
  return /* @__PURE__ */ React.createElement(Comp, {
    ref,
    style: {
      border: 0,
      clip: "rect(0 0 0 0)",
      height: "1px",
      margin: "-1px",
      overflow: "hidden",
      padding: 0,
      position: "absolute",
      width: "1px",
      whiteSpace: "nowrap",
      wordWrap: "normal",
      ...style
    },
    ...props
  });
});
VisuallyHidden.displayName = "VisuallyHidden";
export {
  VisuallyHidden
};
