import * as React from 'react';
import DisplayName from '../helpers/DisplayName';
import { DivAttributes } from '../helpers/types';
import { AccordionContext } from './AccordionContext';
import { UUID } from './ItemContext';
declare type AccordionProps = Pick<DivAttributes, Exclude<keyof DivAttributes, 'onChange'>> & {
    preExpanded?: UUID[];
    allowMultipleExpanded?: boolean;
    allowZeroExpanded?: boolean;
    onChange?(args: UUID[]): void;
};
export default class Accordion extends React.Component<AccordionProps> {
    static defaultProps: AccordionProps;
    static displayName: DisplayName.Accordion;
    renderAccordion: (accordionContext: AccordionContext) => JSX.Element;
    render(): JSX.Element;
}
export {};
