import * as React from 'react';
import AccordionStore, { InjectedButtonAttributes, InjectedHeadingAttributes, InjectedPanelAttributes } from '../helpers/AccordionStore';
import { UUID } from './ItemContext';
export interface ProviderProps {
    preExpanded?: UUID[];
    allowMultipleExpanded?: boolean;
    allowZeroExpanded?: boolean;
    children?: React.ReactNode;
    onChange?(args: UUID[]): void;
}
declare type ProviderState = AccordionStore;
export interface AccordionContext {
    allowMultipleExpanded: boolean;
    allowZeroExpanded: boolean;
    toggleExpanded(uuid: UUID): void;
    isItemDisabled(uuid: UUID): boolean;
    isItemExpanded(uuid: UUID): boolean;
    getPanelAttributes(uuid: UUID): InjectedPanelAttributes;
    getHeadingAttributes(uuid: UUID): InjectedHeadingAttributes;
    getButtonAttributes(uuid: UUID): InjectedButtonAttributes;
}
export declare class Provider extends React.PureComponent<ProviderProps, ProviderState> {
    static defaultProps: ProviderProps;
    state: ProviderState;
    toggleExpanded: (key: string | number) => void;
    isItemDisabled: (key: string | number) => boolean;
    isItemExpanded: (key: string | number) => boolean;
    getPanelAttributes: (key: string | number) => InjectedPanelAttributes;
    getHeadingAttributes: (key: string | number) => InjectedHeadingAttributes;
    getButtonAttributes: (key: string | number) => InjectedButtonAttributes;
    render(): JSX.Element;
}
export declare class Consumer extends React.PureComponent<{
    children(container: AccordionContext): React.ReactNode;
}> {
    renderChildren: (container: AccordionContext | null) => React.ReactNode;
    render(): JSX.Element;
}
export {};
