import * as React from 'react';
import { InjectedButtonAttributes, InjectedHeadingAttributes, InjectedPanelAttributes } from '../helpers/AccordionStore';
import { AccordionContext } from './AccordionContext';
export declare type UUID = string | number;
declare type ProviderProps = {
    children?: React.ReactNode;
    uuid: UUID;
    accordionContext: AccordionContext;
};
export declare type ProviderWrapperProps = Pick<ProviderProps, Exclude<keyof ProviderProps, 'accordionContext'>>;
export declare type ItemContext = {
    uuid: UUID;
    expanded: boolean;
    disabled: boolean;
    panelAttributes: InjectedPanelAttributes;
    headingAttributes: InjectedHeadingAttributes;
    buttonAttributes: InjectedButtonAttributes;
    toggleExpanded(): void;
};
declare const ProviderWrapper: React.SFC<ProviderWrapperProps>;
export { ProviderWrapper as Provider };
declare type ConsumerProps = {
    children(container: ItemContext): React.ReactNode;
};
export declare class Consumer extends React.PureComponent<ConsumerProps> {
    renderChildren: (container: ItemContext | null) => React.ReactNode;
    render(): JSX.Element;
}
