"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CustomError = exports.DefaultError = exports.SubPath = exports.InsideRouter = exports.Basic = void 0;
var React = __importStar(require("react"));
var react_router_dom_1 = require("react-router-dom");
var Admin_1 = require("./Admin");
var ra_core_1 = require("ra-core");
var ra_ui_materialui_1 = require("ra-ui-materialui");
var material_1 = require("@mui/material");
exports.default = {
    title: 'react-admin/Admin',
};
var PostList = function () { return React.createElement("h1", null, "Post List"); };
var CommentList = function () { return React.createElement("h1", null, "Comment List"); };
var Basic = function () { return (React.createElement(Admin_1.Admin, { dataProvider: (0, ra_core_1.testDataProvider)() },
    React.createElement(ra_core_1.Resource, { name: "posts", list: PostList }),
    React.createElement(ra_core_1.Resource, { name: "comments", list: CommentList }))); };
exports.Basic = Basic;
var InsideRouter = function () { return (React.createElement(ra_core_1.TestMemoryRouter, null,
    React.createElement(Admin_1.Admin, { dataProvider: (0, ra_core_1.testDataProvider)() },
        React.createElement(ra_core_1.Resource, { name: "posts", list: PostList }),
        React.createElement(ra_core_1.Resource, { name: "comments", list: CommentList })))); };
exports.InsideRouter = InsideRouter;
var SubPath = function () { return (React.createElement(ra_core_1.TestMemoryRouter, null,
    React.createElement(react_router_dom_1.Routes, null,
        React.createElement(react_router_dom_1.Route, { path: "/", element: React.createElement(React.Fragment, null,
                React.createElement("h1", null, "Main"),
                React.createElement("div", null,
                    React.createElement(react_router_dom_1.Link, { to: "/admin" }, "Go to admin"))) }),
        React.createElement(react_router_dom_1.Route, { path: "/admin/*", element: React.createElement(Admin_1.Admin, { dataProvider: (0, ra_core_1.testDataProvider)(), basename: "/admin" },
                React.createElement(ra_core_1.Resource, { name: "posts", list: PostList }),
                React.createElement(ra_core_1.Resource, { name: "comments", list: CommentList })) })))); };
exports.SubPath = SubPath;
// @ts-ignore
var FailingAppBar = function () {
    throw new Error('AppBar rendering failed');
};
var FailedLayout = function (props) { return React.createElement(ra_ui_materialui_1.Layout, __assign({}, props, { appBar: FailingAppBar })); };
var DefaultError = function () { return (React.createElement(Admin_1.Admin, { layout: FailedLayout },
    React.createElement(ra_core_1.Resource, { name: "posts", list: PostList }))); };
exports.DefaultError = DefaultError;
var ErrorPage = function (_a) {
    var _b, _c, _d;
    var errorInfo = _a.errorInfo;
    return (React.createElement(material_1.Box, { sx: {
            display: 'flex',
            flexDirection: 'column',
            alignItems: 'center',
            minHeight: '100vh',
            backgroundColor: '#f44336',
        } },
        React.createElement(material_1.Typography, { variant: "h1", style: { color: 'white' } },
            React.createElement("b", null, "Error")),
        React.createElement("ul", null, (_d = (_c = (_b = errorInfo === null || errorInfo === void 0 ? void 0 : errorInfo.componentStack) === null || _b === void 0 ? void 0 : _b.split(' at ')) === null || _c === void 0 ? void 0 : _c.slice(1)) === null || _d === void 0 ? void 0 : _d.map(function (line, index) { return React.createElement("li", { key: index },
            "At ",
            line); }))));
};
var CustomError = function () { return (React.createElement(Admin_1.Admin, { layout: FailedLayout, error: ErrorPage },
    React.createElement(ra_core_1.Resource, { name: "posts", list: PostList }))); };
exports.CustomError = CustomError;
//# sourceMappingURL=Admin.stories.js.map