var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
import * as React from 'react';
import { Routes, Route, Link } from 'react-router-dom';
import { Admin } from './Admin';
import { Resource, testDataProvider, TestMemoryRouter } from 'ra-core';
import { Layout } from 'ra-ui-materialui';
import { Box, Typography } from '@mui/material';
export default {
    title: 'react-admin/Admin',
};
var PostList = function () { return React.createElement("h1", null, "Post List"); };
var CommentList = function () { return React.createElement("h1", null, "Comment List"); };
export var Basic = function () { return (React.createElement(Admin, { dataProvider: testDataProvider() },
    React.createElement(Resource, { name: "posts", list: PostList }),
    React.createElement(Resource, { name: "comments", list: CommentList }))); };
export var InsideRouter = function () { return (React.createElement(TestMemoryRouter, null,
    React.createElement(Admin, { dataProvider: testDataProvider() },
        React.createElement(Resource, { name: "posts", list: PostList }),
        React.createElement(Resource, { name: "comments", list: CommentList })))); };
export var SubPath = function () { return (React.createElement(TestMemoryRouter, null,
    React.createElement(Routes, null,
        React.createElement(Route, { path: "/", element: React.createElement(React.Fragment, null,
                React.createElement("h1", null, "Main"),
                React.createElement("div", null,
                    React.createElement(Link, { to: "/admin" }, "Go to admin"))) }),
        React.createElement(Route, { path: "/admin/*", element: React.createElement(Admin, { dataProvider: testDataProvider(), basename: "/admin" },
                React.createElement(Resource, { name: "posts", list: PostList }),
                React.createElement(Resource, { name: "comments", list: CommentList })) })))); };
// @ts-ignore
var FailingAppBar = function () {
    throw new Error('AppBar rendering failed');
};
var FailedLayout = function (props) { return React.createElement(Layout, __assign({}, props, { appBar: FailingAppBar })); };
export var DefaultError = function () { return (React.createElement(Admin, { layout: FailedLayout },
    React.createElement(Resource, { name: "posts", list: PostList }))); };
var ErrorPage = function (_a) {
    var _b, _c, _d;
    var errorInfo = _a.errorInfo;
    return (React.createElement(Box, { sx: {
            display: 'flex',
            flexDirection: 'column',
            alignItems: 'center',
            minHeight: '100vh',
            backgroundColor: '#f44336',
        } },
        React.createElement(Typography, { variant: "h1", style: { color: 'white' } },
            React.createElement("b", null, "Error")),
        React.createElement("ul", null, (_d = (_c = (_b = errorInfo === null || errorInfo === void 0 ? void 0 : errorInfo.componentStack) === null || _b === void 0 ? void 0 : _b.split(' at ')) === null || _c === void 0 ? void 0 : _c.slice(1)) === null || _d === void 0 ? void 0 : _d.map(function (line, index) { return React.createElement("li", { key: index },
            "At ",
            line); }))));
};
export var CustomError = function () { return (React.createElement(Admin, { layout: FailedLayout, error: ErrorPage },
    React.createElement(Resource, { name: "posts", list: PostList }))); };
//# sourceMappingURL=Admin.stories.js.map