---
layout: default
title: "Supported Data Provider Backends"
---

# Supported Data Provider Backends

Thanks to the Data Provider architecture, react-admin supports a lot of API backends. Check the list below for open-source packages developed and maintained by the core team and developers from the react-admin community.

If you can't find a Data Provider for your backend below, no worries! [Writing a Data Provider](./DataProviderWriting.md) takes a couple of hours, and won't prevent you from using react-admin.

<div class="providers-list" markdown="1">
* ![AppWrite Logo](./img/backend-logos/appwrite.svg "AppWrite Logo")**[AppWrite](https://appwrite.io/)**: [g33kdev/ra-appwrite](https://github.com/g33kdev/ra-appwrite)
* ![AWS Amplify Logo](./img/backend-logos/amplify.svg "AWS Amplify Logo")**[AWS Amplify](https://docs.amplify.aws)**: [MrHertal/react-admin-amplify](https://github.com/MrHertal/react-admin-amplify)
* ![blitz Logo](./img/backend-logos/blitz.svg "blitz Logo")**[Blitz-js](https://blitzjs.com/docs)**: [theapexlab/ra-data-blitz](https://github.com/theapexlab/ra-data-blitz)
* <div class="flex">
    <span class="avatar">R</span>
    <b><a href="https://github.com/zachrybaker/ra-data-rest-client">Configurable Identity Property REST Client</a></b>: <a href="https://github.com/zachrybaker/ra-data-rest-client">zachrybaker/ra-data-rest-client</a>
  </div>
* ![corebos Logo](./img/backend-logos/corebos.png "corebos Logo")**[coreBOS](https://corebos.com/)**: [React-Admin coreBOS Integration](https://github.com/coreBOS/reactadminportal)
* ![directus Logo](./img/backend-logos/directus.svg "directus Logo")**[Directus](https://directus.io/)**: [marmelab/ra-directus](https://github.com/marmelab/ra-directus/blob/main/packages/ra-directus/Readme.md)
* ![django Logo](./img/backend-logos/django.png "django Logo")**[Django Rest Framework](https://www.django-rest-framework.org/)**: [bmihelac/ra-data-django-rest-framework](https://github.com/bmihelac/ra-data-django-rest-framework)
* ![eve Logo](./img/backend-logos/eve.png "eve Logo")**[Eve](https://docs.python-eve.org/en/stable/)**: [smeng9/ra-data-eve](https://github.com/smeng9/ra-data-eve)
* ![Express Mangoose Logo](./img/backend-logos/github.svg "Express Mangoose Logo")**[Express & Mongoose](https://github.com/NathanAdhitya/express-mongoose-ra-json-server)**: [NathanAdhitya/express-mongoose-ra-json-server](https://github.com/NathanAdhitya/express-mongoose-ra-json-server)
* ![Express Sequelize Logo](./img/backend-logos/github.svg "Express Sequelize Logo")**[Express & Sequelize](https://github.com/lalalilo/express-sequelize-crud)**: [express-sequelize-crud](https://github.com/lalalilo/express-sequelize-crud)
* ![marmelab Logo](./img/backend-logos/marmelab.png "marmelab Logo")**[FakeRest](https://github.com/marmelab/FakeRest)**: [marmelab/ra-data-fakerest](https://github.com/marmelab/react-admin/tree/master/packages/ra-data-fakerest)
* ![feathersjs Logo](./img/backend-logos/feathersjs.svg "feathersjs Logo")**[Feathersjs](https://www.feathersjs.com/)**: [josx/ra-data-feathers](https://github.com/josx/ra-data-feathers)
* ![Firebase Firestore Logo](./img/backend-logos/firebase.png "Firebase Firestore Logo")**[Firebase Firestore](https://firebase.google.com/docs/firestore)**: [benwinding/react-admin-firebase](https://github.com/benwinding/react-admin-firebase).
* ![Firebase Realtime Logo](./img/backend-logos/firebase.png "Firebase Realtime Logo")**[Firebase Realtime Database](https://firebase.google.com/docs/database)**: [aymendhaya/ra-data-firebase-client](https://github.com/aymendhaya/ra-data-firebase-client).
* ![geoserver Logo](./img/backend-logos/geoserver.png "geoserver Logo")**[GeoServer](http://geoserver.org/)**: [sergioedo/ra-data-geoserver](https://github.com/sergioedo/ra-data-geoserver)
* ![Genezio Logo](./img/backend-logos/genezio.png "Genezio Logo")**[Genezio](https://genezio.com/)**: [bogdanripa/react-admin-genezio](https://github.com/bogdanripa/react-admin-genezio)
* ![sheets Logo](./img/backend-logos/sheets.svg "sheets Logo")**[Google Sheets](https://www.google.com/sheets/about/)**: [marmelab/ra-data-google-sheets](https://github.com/marmelab/ra-data-google-sheets)
* ![graphql Logo](./img/backend-logos/graphql.svg "graphql Logo")**[GraphQL (generic)](https://graphql.org/)**: [marmelab/ra-data-graphql](https://github.com/marmelab/react-admin/tree/master/packages/ra-data-graphql) (uses [Apollo](https://www.apollodata.com/))
* ![graphql Logo](./img/backend-logos/graphql.svg "graphql Logo")**[GraphQL (simple)](https://graphql.org/)**: [marmelab/ra-data-graphql-simple](https://github.com/marmelab/react-admin/tree/master/packages/ra-data-graphql-simple).
* <div class="flex">
    <span class="avatar">H</span>
    <b><a href="http://stateless.co/hal_specification.html">HAL</a></b>: <a href="https://github.com/b-social/ra-data-hal">b-social/ra-data-hal</a>
  </div>
* ![hasura Logo](./img/backend-logos/github.svg "hasura Logo")**[Hasura](https://github.com/hasura/graphql-engine)**: [hasura/ra-data-hasura](https://github.com/hasura/ra-data-hasura)
* ![hydra Logo](./img/backend-logos/hydra.png "hydra Logo")**[Hydra](https://www.hydra-cg.com/) / [JSON-LD](https://json-ld.org/)**: [api-platform/admin/hydra](https://github.com/api-platform/admin/blob/master/src/hydra/dataProvider.ts)
* ![indexedDB Logo](./img/backend-logos/indexedDB.png "indexedDB Logo")**[IndexedDB](https://developer.mozilla.org/en-US/docs/Web/API/IndexedDB_API)** (via [LocalForage](https://github.com/localForage/localForage)): [marmelab/ra-data-localforage](https://github.com/marmelab/react-admin/tree/master/packages/ra-data-localforage)
* ![indexedDB Logo](./img/backend-logos/indexedDB.png "indexedDB Logo")**[IndexedDB](https://developer.mozilla.org/en-US/docs/Web/API/IndexedDB_API)**: [tykoth/ra-data-dexie](https://github.com/tykoth/ra-data-dexie)
* ![jsonApi Logo](./img/backend-logos/jsonApi.jpg "jsonApi Logo")**[JSON API](https://jsonapi.org/)**: [henvo/ra-jsonapi-client](https://github.com/henvo/ra-jsonapi-client)
* <div class="flex">
    <span class="avatar">J</span>
    <b><a href="https://tools.ietf.org/html/draft-kelly-json-hal-08">JSON HAL</a></b>: <a href="https://www.npmjs.com/package/ra-data-json-hal">ra-data-json-hal</a>
  </div>
* ![marmelab Logo](./img/backend-logos/marmelab.png "marmelab Logo")**[JSON server](https://github.com/typicode/json-server)**: [marmelab/ra-data-json-server](https://github.com/marmelab/react-admin/tree/master/packages/ra-data-json-server)
* ![linuxForHealth Logo](./img/backend-logos/github.svg "linuxForHealth Logo")**[LinuxForHealth FHIR](https://github.com/LinuxForHealth/FHIR)**: [tum-mri-aiim/ra-data-fhir](https://gitlab.com/mri-tum/aiim/libs/ra-data-fhir)
* ![localStorage Logo](./img/backend-logos/js.png "localStorage Logo")**[LocalStorage](https://developer.mozilla.org/en-US/docs/Web/API/Window/localStorage)**: [marmelab/ra-data-localstorage](https://github.com/marmelab/react-admin/tree/master/packages/ra-data-localstorage)
* ![localStorage Logo](./img/backend-logos/js.png "localStorage Logo")**[LocalStorage](https://developer.mozilla.org/en-US/docs/Web/API/Window/localStorage)** (via [LocalForage](https://github.com/localForage/localForage)): [marmelab/ra-data-localforage](https://github.com/marmelab/react-admin/tree/master/packages/ra-data-localforage)
* ![loopback3 Logo](./img/backend-logos/loopback3.svg "loopback3 Logo")**[Loopback3](https://loopback.io/lb3)**: [darthwesker/react-admin-loopback](https://github.com/darthwesker/react-admin-loopback)
* ![loopback4 Logo](./img/backend-logos/loopback4.svg "loopback4 Logo")**[Loopback4](https://loopback.io/)**: [elmaistrenko/react-admin-lb4](https://github.com/elmaistrenko/react-admin-lb4)
* ![loopback4 Logo](./img/backend-logos/loopback4.svg "loopback4 Logo")**[Loopback4 CRUD](https://github.com/loopback4/loopback-component-crud)**: [loopback4/ra-data-lb4](https://github.com/loopback4/ra-data-lb4)
* ![mixer Logo](./img/backend-logos/github.svg "mixer Logo")**[Mixer](https://github.com/ckoliber/ra-data-mixer)**: [ckoliber/ra-data-mixer](https://github.com/ckoliber/ra-data-mixer)
* ![moleculer Logo](./img/backend-logos/github.svg "moleculer Logo")**[Moleculer Microservices](https://github.com/RancaguaInnova/moleculer-data-provider)**: [RancaguaInnova/moleculer-data-provider](https://github.com/RancaguaInnova/moleculer-data-provider)
* ![nestJs Logo](./img/backend-logos/nestjs.png "nestJs Logo")**[NestJS CRUD](https://github.com/nestjsx/crud)**: [rayman1104/ra-data-nestjsx-crud](https://github.com/rayman1104/ra-data-nestjsx-crud)
* ![oData Logo](./img/backend-logos/odata.png "oData Logo")**[OData](https://www.odata.org/)**: [Groopit/ra-data-odata-server](https://github.com/Groopit/ra-data-odata-server)
* ![open Logo](./img/backend-logos/open.png "open Logo")**[OpenCRUD](https://www.opencrud.org/)**: [weakky/ra-data-opencrud](https://github.com/Weakky/ra-data-opencrud)
* ![parse Logo](./img/backend-logos/parse.png "parse Logo")**[Parse](https://parseplatform.org/)**: [almahdi/ra-data-parse](https://github.com/almahdi/ra-data-parse)
* ![postGraphile Logo](./img/backend-logos/postgraphile.svg "postGraphile Logo")**[PostGraphile](https://www.graphile.org/postgraphile/)**: [bowlingx/ra-postgraphile](https://github.com/BowlingX/ra-postgraphile)
* ![postgRest Logo](./img/backend-logos/postgRest.png "postgRest Logo")**[PostgREST](https://postgrest.org/)**: [raphiniert-com/ra-data-postgrest](https://github.com/raphiniert-com/ra-data-postgrest)
* ![prisma Logo](./img/backend-logos/prisma.svg "prisma Logo")**[Prisma v1](https://v1.prisma.io/docs/1.34)**: [weakky/ra-data-prisma](https://github.com/weakky/ra-data-prisma)
* ![prisma Logo](./img/backend-logos/prisma.svg "prisma Logo")**[Prisma v2 (GraphQL)](https://www.prisma.io/)**: [panter/ra-data-prisma](https://github.com/panter/ra-data-prisma)
* ![prisma Logo](./img/backend-logos/prisma.svg "prisma Logo")**[Prisma v2 (REST)](https://www.npmjs.com/package/ra-data-simple-prisma)**: [codeledge/ra-data-simple-prisma](https://github.com/codeledge/ra-data-simple-prisma)
* ![processMaker Logo](./img/backend-logos/processMaker.jpeg "processMaker Logo")**[ProcessMaker3](https://www.processmaker.com/)**: [ckoliber/ra-data-processmaker3](https://github.com/ckoliber/ra-data-processmaker3)
* ![restHapi Logo](./img/backend-logos/github.svg "restHapi Logo")**[REST-HAPI](https://github.com/JKHeadley/rest-hapi)**: [ra-data-rest-hapi](https://github.com/mkg20001/ra-data-rest-hapi)
* ![sails Logo](./img/backend-logos/sails.svg "sails Logo")**[Sails.js](https://sailsjs.com/)**: [mpampin/ra-data-json-sails](https://github.com/mpampin/ra-data-json-sails)
* ![sqlite Logo](./img/backend-logos/sqlite.png "sqlite Logo")**[SQLite](https://www.sqlite.org/index.html)**: [marmelab/ra-sqlite-dataprovider](https://github.com/marmelab/ra-sqlite-dataprovider)
* ![marmelab Logo](./img/backend-logos/marmelab.png "marmelab Logo")**[REST](https://en.wikipedia.org/wiki/Representational_state_transfer)**: [marmelab/ra-data-simple-rest](https://github.com/marmelab/react-admin/tree/master/packages/ra-data-simple-rest)
* ![soul logo](./img/backend-logos/soul.png "Soul Logo")**[Soul](https://thevahidal.github.io/soul/)**: [DeepBlueCLtd/RA-Soul](https://github.com/DeepBlueCLtd/RA-Soul)
* ![spring Logo](./img/backend-logos/spring.svg "spring Logo")**[Spring Boot](https://spring.io/projects/spring-boot)**: [vishpat/ra-data-springboot-rest](https://github.com/vishpat/ra-data-springboot-rest)
* ![strapi Logo](./img/backend-logos/strapi.png "strapi Logo")**[Strapi v3/v4](https://strapi.io/)**: [nazirov91/ra-strapi-rest](https://github.com/nazirov91/ra-strapi-rest)
* ![strapi Logo](./img/backend-logos/strapi.png "strapi Logo")**[Strapi v4](https://strapi.io/)**: [garridorafa/ra-strapi-v4-rest](https://github.com/garridorafa/ra-strapi-v4-rest)
* ![supabase Logo](./img/backend-logos/supabase.svg "supabase Logo")**[Supabase](https://supabase.io/)**: [marmelab/ra-supabase](https://github.com/marmelab/ra-supabase/blob/main/packages/ra-supabase/README.md)
* ![surrealDB Logo](./img/backend-logos/surrealdb.svg "surrealDB Logo")**[SurrealDB](https://surrealdb.com/)**: [djedi23/ra-surrealdb](https://github.com/djedi23/ra-surrealdb)
* ![treeql Logo](./img/backend-logos/treeql.png "treeql Logo")**[TreeQL / PHP-CRUD-API](https://treeql.org/)**: [nkappler/ra-data-treeql](https://github.com/nkappler/ra-data-treeql)
* ![wooCommerce Logo](./img/backend-logos/wooCommerce.png "wooCommerce Logo")**[WooCommerce REST API](https://woocommerce.github.io/woocommerce-rest-api-docs)**: [zackha/ra-data-woocommerce](https://github.com/zackha/ra-data-woocommerce)
</div>


That's a long list!

If you don't know where to start, use any of the following:

* [marmelab/ra-data-fakerest](https://github.com/marmelab/react-admin/tree/master/packages/ra-data-fakerest): Simulates an API based on a JSON object. It doesn't even require a server.
* [marmelab/ra-data-json-server](https://github.com/marmelab/react-admin/tree/master/packages/ra-data-json-server): Similar to the previous one, but requires an API powered by JSONServer.
* [marmelab/ra-data-simple-rest](https://github.com/marmelab/react-admin/tree/master/packages/ra-data-simple-rest): A basic REST adapter that reflects the structure of many APIs
* [marmelab/ra-data-localstorage](https://github.com/marmelab/react-admin/tree/master/packages/ra-data-localstorage): Persists user editions in local storage. This allows local-first apps, and can be useful in tests.
* [marmelab/ra-data-localforage](https://github.com/marmelab/react-admin/tree/master/packages/ra-data-localforage): Uses a local, offline database based on IndexedDB. Falls back to WebSQL or localStorage.

**Tip**: Since dataProviders all present the same interface, you can use one dataProvider during early prototyping / development phases, then switch to the dataProvider that fits your production infrastructure.

If you've written a Data Provider for another backend, and open-sourced it, please help complete this list with your package.
