---
layout: default
title: "Ecosystem"
---

# Ecosystem

While most of the react-admin components come from the [marmelab/react-admin](https://github.com/marmelab/react-admin) repository, you can find more hooks and components for react-admin in other packages.

## Enterprise Packages

[React-admin Enterprise Edition](https://react-admin-ee.marmelab.com) provides additional packages:

- [@react-admin/ra-ai](https://react-admin-ee.marmelab.com/documentation/ra-ai): Components powered by Artificial Intelligence (AI) to boost user productivity. Suggest completion for user inputs, fix and improve large chunks of text in React-Admin forms.
- [@react-admin/ra-audit-log](https://react-admin-ee.marmelab.com/documentation/ra-audit-log): Keep track of user actions, and get an overview of the activity of your admin.
- [@react-admin/ra-calendar](https://react-admin-ee.marmelab.com/documentation/ra-calendar): Display and manipulate events, drag and resize appointments, and browse a calendar in react-admin apps.
- [@react-admin/ra-editable-datagrid](https://react-admin-ee.marmelab.com/documentation/ra-editable-datagrid): Enhance the features of react-admin's `<Datagrid>` component, including an "edit-in-place" experience.
- [@react-admin/ra-enterprise](https://react-admin-ee.marmelab.com/documentation/ra-enterprise): Preconfigured components replacing the default react-admin ones to quickly integrate the Enterprise Edition modules.
- [@react-admin/ra-form-layout](https://react-admin-ee.marmelab.com/documentation/ra-form-layout): New form layouts for complex data entry tasks (accordion, wizard, autosave, etc.).
- [@react-admin/ra-json-schema-form](https://react-admin-ee.marmelab.com/documentation/ra-json-schema-form): Build forms based on a JSON Schema description
- [@react-admin/ra-markdown](https://react-admin-ee.marmelab.com/documentation/ra-markdown): Markdown field and Input
- [@react-admin/ra-navigation](https://react-admin-ee.marmelab.com/documentation/ra-navigation): New page layouts, Menus layouts, Smart Breadcrumb, and hooks to handle the user location.
- [@react-admin/ra-relationships](https://react-admin-ee.marmelab.com/documentation/ra-relationships): A set of alternative inputs and fields to edit relationships, including many-to-many relationships using a join table.
- [@react-admin/ra-rbac](https://react-admin-ee.marmelab.com/documentation/ra-rbac): Role-Based Access Control for React-admin apps. This module extends the authProvider to manage roles and fine-grained permissions, and adds replacement for many react-admin components that use these permissions.
- [@react-admin/ra-realtime](https://react-admin-ee.marmelab.com/documentation/ra-realtime): Hooks and UI components for collaborative applications where several people work in parallel. It allows publishing and subscribing to real-time events, updating views when another user pushes a change, notifying end users of events, and preventing data loss when two editors work on the same resource concurrently.
- [@react-admin/ra-search](https://react-admin-ee.marmelab.com/documentation/ra-search): Plug your search engine and let users search across all resources via a smart Omnibox.
- [@react-admin/ra-tour](https://react-admin-ee.marmelab.com/documentation/ra-tour): Guide users through tutorials to showcase and explain important features of your interfaces.
- [@react-admin/ra-tree](https://react-admin-ee.marmelab.com/documentation/ra-tree): Tree hooks and components for react-admin. Allows to display, edit, and rearrange tree structures like directories, categories, etc.

## Third-Party Packages

- [FusionWorks/react-admin-google-maps](https://github.com/FusionWorks/react-admin-google-maps): Input/view components for displaying location using Google Maps.
- [api-platform/admin](https://api-platform.com/docs/admin): create a fully featured admin using React Admin for API supporting the [Hydra Core Vocabulary](https://www.hydra-cg.com/), including but not limited to APIs created using the [API Platform framework](https://api-platform.com)
- [zifnab87/ra-component-factory](https://github.com/zifnab87/ra-component-factory): a centralized configuration of immutability/visibility of fields/menu-links/action buttons, easy re-ordering of fields/properties and tab reorganization based on permission roles
- [ctbucha/bs-react-admin](https://github.com/ctbucha/bs-react-admin): [BuckleScript](https://bucklescript.github.io/) bindings for React Admin.
- [dryhten/ra-resource-aggregator](https://github.com/dryhten/ra-resource-aggregator): Resource aggregator for react-admin. It allows you to edit/create/delete multiple resources in the same view.
- [Dev XP demo (YouTube)](https://youtu.be/nHkVxDEnB3g): How to make changes to the core React Admin project locally
- [react-admin-import-csv](https://github.com/benwinding/react-admin-import-csv): A csv file import button for react-admin.
- [@bb-tech/ra-components](https://github.com/BigBasket/ra-components): Hierarchical menu structure, JSON field and input, Email, URL and Phone inputs

If you authored or know another package for react-admin, please open a pull request on the `docs` folder to add the package to this list. 