import React from 'react';
import { render } from 'react-dom'; // eslint-disable-line import/no-extraneous-dependencies
import Header from './Header';
import Slider from '../';
import styles from './styles.css';
import horizontalCss from '../css/horizontal.css';
import '../../build/horizontal.css';
import verticalCss from '../css/vertical.css';
import content from './content';
import Shields from './Shields';
import customCss from './custom.css';

class SourceView extends React.Component {
	state = { expanded: false };

	toggle = () => this.setState({ expanded: !this.state.expanded });

	render() {
		const { expanded } = this.state;
		const { children } = this.props;
		return (
			<div className={styles.sourceView}>
				<button className={styles.toggleButton} onClick={this.toggle}>{expanded ? 'Hide' : 'Show'} source</button>
				<pre className={expanded ? styles.expanded : styles.collapsed}>{children}</pre>
			</div>
		);
	}
}

function App() {
	return (
		<div>
			<Header />

			<Shields />

			<h1>DEMO</h1>

			<h2>Predefined horizontal slider</h2>
			<Slider classNames={horizontalCss}>
				{content.map((item, index) => (
					<div
						key={index}
						style={{ background: `url('${item.image}') no-repeat center center` }}
					>
						<div className="center">
							<h1>{item.title}</h1>
							<p>{item.description}</p>
							<button>{item.button}</button>
						</div>
					</div>
				))}
			</Slider>

			<SourceView>
				{`import Slider from 'react-animated-slider';
import 'react-animated-slider/build/horizontal.css';

<Slider>
	{content.map((item, index) => (
		<div
			key={index}
			style={{ background: \`url('\${item.image}') no-repeat center center\` }}
		>
			<div className="center">
				<h1>{item.title}</h1>
				<p>{item.description}</p>
				<button>{item.button}</button>
			</div>
		</div>
	))}
</Slider>`}
			</SourceView>

			With css modules:
			<SourceView>
				{`import Slider from 'react-animated-slider';
import horizontalCss from 'react-animated-slider/build/horizontal.css';

<Slider className={horizontalCss.slider} classNames={horizontalCss}>
	{content.map((item, index) => (
		<div
			key={index}
			style={{ background: \`url('\${item.image}') no-repeat center center\` }}
		>
			<div className="center">
				<h1>{item.title}</h1>
				<p>{item.description}</p>
				<button>{item.button}</button>
			</div>
		</div>
	))}
</Slider>`}
			</SourceView>

			<h2>Predefined vertical slider</h2>
			<Slider className={verticalCss.slider} classNames={verticalCss} direction="vertical">
				{content.map((item, index) => (
					<div
						key={index}
						style={{ background: `url('${item.image}') no-repeat center center` }}
					>
						<div className="center">
							<h1>{item.title}</h1>
							<p>{item.description}</p>
							<button>{item.button}</button>
						</div>
					</div>
				))}
			</Slider>
			<SourceView>{`import Slider from 'react-animated-slider';
import verticalCss from 'react-animated-slider/build/vertical.css';

<Slider className={verticalCss.slider} classNames={verticalCss} direction="vertical">
	{content.map((item, index) => (
		<div
			key={index}
			style={{ background: \`url('\${item.image}') no-repeat center center\` }}
		>
			<div className="center">
				<h1>{item.title}</h1>
				<p>{item.description}</p>
				<button>{item.button}</button>
			</div>
		</div>
	))}
</Slider>`}
			</SourceView>

			<h2>Custom style and animations</h2>
			<Slider className={horizontalCss.slider} classNames={horizontalCss}>
				{content.map((item, index) => (
					<div
						key={index}
						className={customCss.sliderContent}
						style={{ background: `url('${item.image}') no-repeat center center` }}
					>
						<div className={customCss.inner}>
							<h1>{item.title}</h1>
							<p>{item.description}</p>
							<button>{item.button}</button>
						</div>
						<section>
							<img src={item.userProfile} alt={item.user} />
							<span>
								Posted by <strong>{item.user}</strong>
							</span>
						</section>
					</div>
				))}
			</Slider>

			<h2>Autoplay</h2>
			<Slider className={horizontalCss.slider} classNames={horizontalCss} autoplay={3000}>
				{content.map((item, index) => (
					<div
						key={index}

						style={{ background: `url('${item.image}') no-repeat center center` }}
					>
						<div className="center">
							<h1>{item.title}</h1>
							<p>{item.description}</p>
							<button>{item.button}</button>
						</div>
					</div>
				))}
			</Slider>
			<SourceView>{`import Slider from 'react-animated-slider';
import 'react-animated-slider/build/horizontal.css';

<Slider autoplay={3000}>
	{content.map((item, index) => (
		<div
			key={index}
			style={{ background: \`url('\${item.image}') no-repeat center center\` }}
		>
			<div className="center">
				<h1>{item.title}</h1>
				<p>{item.description}</p>
				<button>{item.button}</button>
			</div>
		</div>
	))}
</Slider>`}
			</SourceView>


		</div>
	);
}

render(<App />, document.getElementById('app'));
