"use strict";

/**
 * Check if a component is an async component.
 *
 * @param {ReactComponent} component
 */
function isAsyncComponent(component) {
  return component.type.prototype && typeof component.type.prototype.getInitialStateAsync === 'function';
}

module.exports = isAsyncComponent;
