'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _utils = require('../utils');

var _utils2 = _interopRequireDefault(_utils);

var _cell = require('../cell');

var _cell2 = _interopRequireDefault(_cell);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /* eslint react/prop-types: 0 */
/* eslint react/no-array-index-key: 0 */
/* eslint no-plusplus: 0 */


var RowPureContent = function (_React$Component) {
  _inherits(RowPureContent, _React$Component);

  function RowPureContent() {
    _classCallCheck(this, RowPureContent);

    return _possibleConstructorReturn(this, (RowPureContent.__proto__ || Object.getPrototypeOf(RowPureContent)).apply(this, arguments));
  }

  _createClass(RowPureContent, [{
    key: 'shouldComponentUpdate',
    value: function shouldComponentUpdate(nextProps) {
      if (typeof nextProps.shouldUpdate !== 'undefined') {
        return nextProps.shouldUpdate;
      }
      return true;
    }
  }, {
    key: 'render',
    value: function render() {
      var _props = this.props,
          row = _props.row,
          keyField = _props.keyField,
          columns = _props.columns,
          rowIndex = _props.rowIndex,
          editable = _props.editable,
          editingRowIdx = _props.editingRowIdx,
          editingColIdx = _props.editingColIdx,
          onStart = _props.onStart,
          clickToEdit = _props.clickToEdit,
          dbclickToEdit = _props.dbclickToEdit,
          EditingCellComponent = _props.EditingCellComponent,
          tabIndexStart = _props.tabIndexStart;


      var tabIndex = tabIndexStart;

      return columns.map(function (column, index) {
        if (!column.hidden) {
          var dataField = column.dataField;

          var content = _utils2.default.get(row, dataField);
          if (rowIndex === editingRowIdx && index === editingColIdx) {
            return _react2.default.createElement(EditingCellComponent, {
              key: content + '-' + index + '-editing',
              row: row,
              rowIndex: rowIndex,
              column: column,
              columnIndex: index
            });
          }
          // render cell
          var cellTitle = void 0;
          var cellStyle = {};
          var cellAttrs = _extends({}, _utils2.default.isFunction(column.attrs) ? column.attrs(content, row, rowIndex, index) : column.attrs);

          if (column.events) {
            var events = Object.assign({}, column.events);
            Object.keys(Object.assign({}, column.events)).forEach(function (key) {
              var originFn = events[key];
              events[key] = function () {
                for (var _len = arguments.length, rest = Array(_len), _key = 0; _key < _len; _key++) {
                  rest[_key] = arguments[_key];
                }

                return originFn.apply(undefined, rest.concat([row, rowIndex]));
              };
            });
            cellAttrs = _extends({}, cellAttrs, events);
          }

          var cellClasses = _utils2.default.isFunction(column.classes) ? column.classes(content, row, rowIndex, index) : column.classes;

          if (column.style) {
            cellStyle = _utils2.default.isFunction(column.style) ? column.style(content, row, rowIndex, index) : column.style;
            cellStyle = Object.assign({}, cellStyle) || {};
          }

          if (column.title) {
            cellTitle = _utils2.default.isFunction(column.title) ? column.title(content, row, rowIndex, index) : content;
            cellAttrs.title = cellTitle;
          }

          if (column.align) {
            cellStyle.textAlign = _utils2.default.isFunction(column.align) ? column.align(content, row, rowIndex, index) : column.align;
          }

          if (cellClasses) cellAttrs.className = cellClasses;
          if (!_utils2.default.isEmptyObject(cellStyle)) cellAttrs.style = cellStyle;

          var editableCell = _utils2.default.isDefined(column.editable) ? column.editable : true;
          if (column.dataField === keyField || !editable) editableCell = false;
          if (_utils2.default.isFunction(column.editable)) {
            editableCell = column.editable(content, row, rowIndex, index);
          }

          if (tabIndexStart !== -1) {
            cellAttrs.tabIndex = tabIndex++;
          }

          return _react2.default.createElement(_cell2.default, _extends({
            key: content + '-' + index,
            row: row,
            editable: editableCell,
            rowIndex: rowIndex,
            columnIndex: index,
            column: column,
            onStart: onStart,
            clickToEdit: clickToEdit,
            dbclickToEdit: dbclickToEdit
          }, cellAttrs));
        }
        return false;
      });
    }
  }]);

  return RowPureContent;
}(_react2.default.Component);

exports.default = RowPureContent;