'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _arguments = arguments; /* eslint camelcase: 0 */
/* eslint no-return-assign: 0 */

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var handleDebounce = function handleDebounce(func, wait, immediate) {
  var timeout = void 0;

  return function () {
    var later = function later() {
      timeout = null;

      if (!immediate) {
        func.apply(undefined, _arguments);
      }
    };

    var callNow = immediate && !timeout;

    clearTimeout(timeout);

    timeout = setTimeout(later, wait || 0);

    if (callNow) {
      func.appy(undefined, _arguments);
    }
  };
};

var SearchBar = function (_React$Component) {
  _inherits(SearchBar, _React$Component);

  function SearchBar(props) {
    _classCallCheck(this, SearchBar);

    var _this = _possibleConstructorReturn(this, (SearchBar.__proto__ || Object.getPrototypeOf(SearchBar)).call(this, props));

    _this.onChangeValue = function (e) {
      _this.setState({ value: e.target.value });
    };

    _this.onKeyup = function () {
      var _this$props = _this.props,
          delay = _this$props.delay,
          onSearch = _this$props.onSearch;

      var debounceCallback = handleDebounce(function () {
        onSearch(_this.input.value);
      }, delay);
      debounceCallback();
    };

    _this.state = {
      value: props.searchText
    };
    return _this;
  }

  _createClass(SearchBar, [{
    key: 'UNSAFE_componentWillReceiveProps',
    value: function UNSAFE_componentWillReceiveProps(nextProps) {
      this.setState({ value: nextProps.searchText });
    }
  }, {
    key: 'render',
    value: function render() {
      var _this2 = this;

      var _props = this.props,
          className = _props.className,
          style = _props.style,
          placeholder = _props.placeholder,
          tableId = _props.tableId;


      return _react2.default.createElement(
        'label',
        {
          htmlFor: 'search-bar-' + tableId,
          className: 'search-label'
        },
        _react2.default.createElement(
          'span',
          { className: 'sr-only' },
          'Search this table'
        ),
        _react2.default.createElement('input', {
          ref: function ref(n) {
            return _this2.input = n;
          },
          id: 'search-bar-' + tableId,
          type: 'text',
          style: style,
          'aria-label': 'enter text you want to search',
          onKeyUp: function onKeyUp() {
            return _this2.onKeyup();
          },
          onChange: this.onChangeValue,
          className: 'form-control ' + className,
          value: this.state.value,
          placeholder: placeholder || SearchBar.defaultProps.placeholder
        })
      );
    }
  }]);

  return SearchBar;
}(_react2.default.Component);

SearchBar.propTypes = {
  onSearch: _propTypes2.default.func.isRequired,
  className: _propTypes2.default.string,
  placeholder: _propTypes2.default.string,
  style: _propTypes2.default.object,
  delay: _propTypes2.default.number,
  searchText: _propTypes2.default.string,
  tableId: _propTypes2.default.string
};

SearchBar.defaultProps = {
  className: '',
  style: {},
  placeholder: 'Search',
  delay: 250,
  searchText: '',
  tableId: '0'
};

exports.default = SearchBar;