'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /* eslint react/prop-types: 0 */
/* eslint react/require-default-props: 0 */
/* eslint no-continue: 0 */
/* eslint no-lonely-if: 0 */
/* eslint class-methods-use-this: 0 */
/* eslint camelcase: 0 */


exports.default = function () {
  var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {
    searchFormatted: false,
    onColumnMatch: null
  };
  return function (_, isRemoteSearch, handleRemoteSearchChange) {
    var SearchContext = _react2.default.createContext();

    var SearchProvider = function (_React$Component) {
      _inherits(SearchProvider, _React$Component);

      function SearchProvider(props) {
        _classCallCheck(this, SearchProvider);

        var _this = _possibleConstructorReturn(this, (SearchProvider.__proto__ || Object.getPrototypeOf(SearchProvider)).call(this, props));

        var initialData = props.data;
        if (isRemoteSearch() && _this.props.searchText !== '') {
          handleRemoteSearchChange(_this.props.searchText);
        } else {
          initialData = _this.search(props);
          _this.triggerListener(initialData);
        }
        _this.state = { data: initialData };
        return _this;
      }

      _createClass(SearchProvider, [{
        key: 'getSearched',
        value: function getSearched() {
          return this.state.data;
        }
      }, {
        key: 'triggerListener',
        value: function triggerListener(result) {
          if (this.props.dataChangeListener) {
            this.props.dataChangeListener.emit('filterChanged', result.length);
          }
        }
      }, {
        key: 'UNSAFE_componentWillReceiveProps',
        value: function UNSAFE_componentWillReceiveProps(nextProps) {
          if (nextProps.searchText !== this.props.searchText) {
            if (isRemoteSearch()) {
              handleRemoteSearchChange(nextProps.searchText);
            } else {
              var result = this.search(nextProps);
              this.triggerListener(result);
              this.setState({
                data: result
              });
            }
          } else {
            if (isRemoteSearch()) {
              this.setState({ data: nextProps.data });
            } else if (!_.isEqual(nextProps.data, this.props.data)) {
              var _result = this.search(nextProps);
              this.triggerListener(_result);
              this.setState({
                data: _result
              });
            }
          }
        }
      }, {
        key: 'search',
        value: function search(props) {
          var data = props.data,
              columns = props.columns;

          var searchText = props.searchText.toLowerCase();
          return data.filter(function (row, ridx) {
            for (var cidx = 0; cidx < columns.length; cidx += 1) {
              var column = columns[cidx];
              if (column.searchable === false) continue;
              var targetValue = _.get(row, column.dataField);
              if (column.formatter && options.searchFormatted) {
                targetValue = column.formatter(targetValue, row, ridx, column.formatExtraData);
              } else if (column.filterValue) {
                targetValue = column.filterValue(targetValue, row);
              }
              if (options.onColumnMatch) {
                if (options.onColumnMatch({
                  searchText: searchText,
                  value: targetValue,
                  column: column,
                  row: row
                })) {
                  return true;
                }
              } else {
                if (targetValue !== null && typeof targetValue !== 'undefined') {
                  targetValue = targetValue.toString().toLowerCase();
                  if (targetValue.indexOf(searchText) > -1) {
                    return true;
                  }
                }
              }
            }
            return false;
          });
        }
      }, {
        key: 'render',
        value: function render() {
          return _react2.default.createElement(
            SearchContext.Provider,
            { value: { data: this.state.data } },
            this.props.children
          );
        }
      }]);

      return SearchProvider;
    }(_react2.default.Component);

    SearchProvider.propTypes = {
      data: _propTypes2.default.array.isRequired,
      columns: _propTypes2.default.array.isRequired,
      searchText: _propTypes2.default.string,
      dataChangeListener: _propTypes2.default.object
    };


    return {
      Provider: SearchProvider,
      Consumer: SearchContext.Consumer
    };
  };
};