'use strict';

var _extends = require('babel-runtime/helpers/extends')['default'];

var _interopRequireDefault = require('babel-runtime/helpers/interop-require-default')['default'];

exports.__esModule = true;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _BootstrapMixin = require('./BootstrapMixin');

var _BootstrapMixin2 = _interopRequireDefault(_BootstrapMixin);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var NavBrand = _react2['default'].createClass({
  displayName: 'NavBrand',

  mixins: [_BootstrapMixin2['default']],

  propTypes: {
    bsRole: _react2['default'].PropTypes.string,
    navbar: _react2['default'].PropTypes.bool
  },

  getDefaultProps: function getDefaultProps() {
    return {
      bsRole: 'brand',
      navbar: false
    };
  },

  render: function render() {
    var brand = undefined;

    if (_react2['default'].isValidElement(this.props.children)) {
      brand = _react.cloneElement(this.props.children, {
        className: _classnames2['default'](this.props.children.props.className, 'navbar-brand'),
        bsRole: this.props.bsRole,
        navbar: this.props.navbar
      });
    } else {
      brand = _react2['default'].createElement(
        'span',
        _extends({}, this.props, { className: 'navbar-brand' }),
        this.props.children
      );
    }

    return brand;
  }

});

exports['default'] = NavBrand;
module.exports = exports['default'];