'use strict';

var _inherits = require('babel-runtime/helpers/inherits')['default'];

var _classCallCheck = require('babel-runtime/helpers/class-call-check')['default'];

var _extends = require('babel-runtime/helpers/extends')['default'];

var _objectWithoutProperties = require('babel-runtime/helpers/object-without-properties')['default'];

var _Object$values = require('babel-runtime/core-js/object/values')['default'];

var _interopRequireDefault = require('babel-runtime/helpers/interop-require-default')['default'];

exports.__esModule = true;

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _utilsBootstrapUtils = require('./utils/bootstrapUtils');

var _utilsStyleConfig = require('./utils/StyleConfig');

var propTypes = {
  onDismiss: _react2['default'].PropTypes.func,
  closeLabel: _react2['default'].PropTypes.string
};

var defaultProps = {
  closeLabel: 'Close alert'
};

var Alert = (function (_React$Component) {
  _inherits(Alert, _React$Component);

  function Alert() {
    _classCallCheck(this, Alert);

    _React$Component.apply(this, arguments);
  }

  Alert.prototype.renderDismissButton = function renderDismissButton(onDismiss) {
    return _react2['default'].createElement(
      'button',
      {
        type: 'button',
        className: 'close',
        onClick: onDismiss,
        'aria-hidden': 'true',
        tabIndex: '-1'
      },
      _react2['default'].createElement(
        'span',
        null,
        '×'
      )
    );
  };

  Alert.prototype.renderSrOnlyDismissButton = function renderSrOnlyDismissButton(onDismiss, closeLabel) {
    return _react2['default'].createElement(
      'button',
      {
        type: 'button',
        className: 'close sr-only',
        onClick: onDismiss
      },
      closeLabel
    );
  };

  Alert.prototype.render = function render() {
    var _extends2;

    var _props = this.props;
    var onDismiss = _props.onDismiss;
    var closeLabel = _props.closeLabel;
    var className = _props.className;
    var children = _props.children;

    var props = _objectWithoutProperties(_props, ['onDismiss', 'closeLabel', 'className', 'children']);

    var _splitBsProps = _utilsBootstrapUtils.splitBsProps(props);

    var bsProps = _splitBsProps[0];
    var elementProps = _splitBsProps[1];

    var dismissable = !!onDismiss;
    var classes = _extends({}, _utilsBootstrapUtils.getClassSet(bsProps), (_extends2 = {}, _extends2[_utilsBootstrapUtils.prefix(bsProps, 'dismissable')] = dismissable, _extends2));

    return _react2['default'].createElement(
      'div',
      _extends({}, elementProps, {
        role: 'alert',
        className: _classnames2['default'](className, classes)
      }),
      dismissable && this.renderDismissButton(onDismiss),
      children,
      dismissable && this.renderSrOnlyDismissButton(onDismiss, closeLabel)
    );
  };

  return Alert;
})(_react2['default'].Component);

Alert.propTypes = propTypes;
Alert.defaultProps = defaultProps;

exports['default'] = _utilsBootstrapUtils.bsStyles(_Object$values(_utilsStyleConfig.State), _utilsStyleConfig.State.INFO, _utilsBootstrapUtils.bsClass('alert', Alert));
module.exports = exports['default'];