'use strict';

var _inherits = require('babel-runtime/helpers/inherits')['default'];

var _classCallCheck = require('babel-runtime/helpers/class-call-check')['default'];

var _objectWithoutProperties = require('babel-runtime/helpers/object-without-properties')['default'];

var _extends = require('babel-runtime/helpers/extends')['default'];

var _interopRequireDefault = require('babel-runtime/helpers/interop-require-default')['default'];

exports.__esModule = true;

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _SafeAnchor = require('./SafeAnchor');

var _SafeAnchor2 = _interopRequireDefault(_SafeAnchor);

var propTypes = {
  /**
   * If set to true, renders `span` instead of `a`
   */
  active: _react2['default'].PropTypes.bool,
  /**
   * `href` attribute for the inner `a` element
   */
  href: _react2['default'].PropTypes.string,
  /**
   * `title` attribute for the inner `a` element
   */
  title: _react2['default'].PropTypes.node,
  /**
   * `target` attribute for the inner `a` element
   */
  target: _react2['default'].PropTypes.string
};

var defaultProps = {
  active: false
};

var BreadcrumbItem = (function (_React$Component) {
  _inherits(BreadcrumbItem, _React$Component);

  function BreadcrumbItem() {
    _classCallCheck(this, BreadcrumbItem);

    _React$Component.apply(this, arguments);
  }

  BreadcrumbItem.prototype.render = function render() {
    var _props = this.props;
    var active = _props.active;
    var href = _props.href;
    var title = _props.title;
    var target = _props.target;
    var className = _props.className;

    var props = _objectWithoutProperties(_props, ['active', 'href', 'title', 'target', 'className']);

    // Don't try to render these props on non-active <span>.
    var linkProps = { href: href, title: title, target: target };

    return _react2['default'].createElement(
      'li',
      { className: _classnames2['default'](className, { active: active }) },
      active ? _react2['default'].createElement('span', props) : _react2['default'].createElement(_SafeAnchor2['default'], _extends({}, props, linkProps))
    );
  };

  return BreadcrumbItem;
})(_react2['default'].Component);

BreadcrumbItem.propTypes = propTypes;
BreadcrumbItem.defaultProps = defaultProps;

exports['default'] = BreadcrumbItem;
module.exports = exports['default'];